/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.model;

import com.huawei.dc.common.asndatacenter.AsnActivationTypeEnum;
import com.huawei.dc.common.asndatacenter.AsnDCActivationBoardInfo;
import com.huawei.dc.common.asndatacenter.AsnDCActivationGroup;
import com.huawei.dc.common.asndatacenter.AsnDCActivationGroupInfo;
import com.huawei.dc.common.asndatacenter.AsnDCActivationGroupLst;
import com.huawei.dc.common.asndatacenter.AsnDCActivationInfo;
import com.huawei.dc.common.asndatacenter.AsnDCActivationInfoSeqOf;
import com.huawei.dc.common.asndatacenter.AsnDCBoardInfo;
import com.huawei.dc.common.asndatacenter.AsnDCLoadSimulationPackageInfo;
import com.huawei.dc.common.asndatacenter.AsnDCSimulationPackageDevice;
import com.huawei.dc.common.asndatacenter.AsnDCSimulationPackageDeviceList;
import com.huawei.dc.common.asndatacenter.AsnDCSimulationPackageInfoLst;
import com.huawei.dc.common.asndatacenter.AsnDCSimulationPackageInfoOnBoard;
import com.huawei.dc.common.asndatacenter.AsnDCSimulationPackageInfoOnBoardLst;
import com.huawei.dc.common.asndatacenter.AsnDCSimulationPackageToLoad;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCTimeDateUtil;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.taskmgmt.model.ActiveBoardInfo;
import com.huawei.dc.taskmgmt.model.ActiveDevInfo;
import com.huawei.dc.taskmgmt.model.ActiveGroupInfo;
import com.huawei.dc.taskmgmt.model.ActiveInfo;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.LoadSimPackageBoardInfo;
import com.huawei.dc.taskmgmt.model.LoadSimPackageDevInfo;
import com.huawei.dc.taskmgmt.model.LoadSimPackageFileInfo;
import com.huawei.dc.taskmgmt.model.LoadSimPackageInfo;
import java.math.BigInteger;
import java.text.Collator;
import java.util.Calendar;
import java.util.Vector;

public class SwitchTaskAndAsn {
    private static SwitchTaskAndAsn _Inatall;

    public static SwitchTaskAndAsn getSwitchTaskAndAsn() {
        if (_Inatall == null) {
            _Inatall = new SwitchTaskAndAsn();
        }
        return _Inatall;
    }

    public void switchTaskToAsnByActive(AsnDCActivationGroupInfo oActivationGroupInfo, ITask oTask) {
        ActiveInfo oActiveInfo = oTask.getActivationInfo();
        AsnDCActivationGroupLst oActiveGroupLst = new AsnDCActivationGroupLst();
        if (null != oActiveInfo.getStartTime()) {
            Calendar oStartTimeCal = Calendar.getInstance();
            oStartTimeCal.setTime(oActiveInfo.getStartTime().getTime());
            DCTimeDateUtil.switchToGMTCalendar(oStartTimeCal);
            oActivationGroupInfo.oActivationTime = oStartTimeCal;
        }
        if (!Collator.getInstance().equals(oActiveInfo.getFilePath(), "")) {
            oActivationGroupInfo.strActiveFilePath = oActiveInfo.getFilePath().getBytes();
        }
        oActivationGroupInfo.oActiveGroupLst = oActiveGroupLst;
        Vector<ActiveGroupInfo> groupList = oActiveInfo.getGroupList();
        for (int i = 0; i < groupList.size(); ++i) {
            ActiveGroupInfo groupInfo = groupList.get(i);
            AsnDCActivationGroup asnGroupInto = new AsnDCActivationGroup();
            asnGroupInto.iGroupId = new BigInteger(String.valueOf(groupInfo.getGroupId()));
            asnGroupInto.isPause = new BigInteger(String.valueOf(groupInfo.getIsPause()));
            Vector devList = groupInfo.getActivationInfoLst();
            for (int j = 0; j < devList.size(); ++j) {
                ActiveDevInfo devInfo = (ActiveDevInfo)devList.get(j);
                AsnDCActivationInfo asnDevIfo = new AsnDCActivationInfo();
                asnDevIfo.iDeviceId = new BigInteger(String.valueOf(devInfo.getDevId()));
                asnDevIfo.iOrder = new BigInteger(String.valueOf(devInfo.getOrder()));
                asnDevIfo.strDeviceName = devInfo.getDevName().getBytes();
                Vector boardList = devInfo.getBoardList();
                for (int l = 0; l < boardList.size(); ++l) {
                    ActiveBoardInfo boardInfo = (ActiveBoardInfo)boardList.get(l);
                    AsnDCActivationBoardInfo asnBoardInfo = new AsnDCActivationBoardInfo();
                    AsnDCBoardInfo oBoardInfo = new AsnDCBoardInfo();
                    oBoardInfo.iSlotId = new BigInteger(String.valueOf(boardInfo.getSlotId()));
                    oBoardInfo.strBoardVersion = boardInfo.getBoardVersion().getBytes();
                    oBoardInfo.strSlotLabel = boardInfo.getSlotLabel().getBytes();
                    oBoardInfo.iBoardType = new BigInteger(String.valueOf(boardInfo.getBoardType()));
                    asnBoardInfo.oBoardInfo = oBoardInfo;
                    asnBoardInfo.enActiveDeviceMode = new AsnActivationTypeEnum(boardInfo.getActiveDeviceMode());
                    asnBoardInfo.isDeleteDatabase = boardInfo.getIsDeleteDatabase() != 0;
                    if (null == asnDevIfo.oActivationBoardInfoLst) {
                        asnDevIfo.oActivationBoardInfoLst = new AsnDCActivationInfoSeqOf();
                    }
                    asnDevIfo.oActivationBoardInfoLst.add((Object)asnBoardInfo);
                }
                asnGroupInto.oActivationInfoLst.add((Object)asnDevIfo);
            }
            oActiveGroupLst.add((Object)asnGroupInto);
        }
    }

    public void switchTaskToAsnByLoad(AsnDCLoadSimulationPackageInfo asnLoadSimInfo, ITask oTask) {
        AsnDCSimulationPackageDeviceList asnDevList;
        LoadSimPackageInfo loadSimInfo = oTask.getLoadSimPackageInfo();
        if (loadSimInfo == null) {
            return;
        }
        Vector devList = loadSimInfo.getDevList();
        asnLoadSimInfo.oSimulationPackageDeviceList = asnDevList = new AsnDCSimulationPackageDeviceList();
        for (int i = 0; i < devList.size(); ++i) {
            AsnDCSimulationPackageInfoOnBoardLst asnBoardList;
            LoadSimPackageDevInfo devInfo = (LoadSimPackageDevInfo)devList.get(i);
            AsnDCSimulationPackageDevice asnDevInfo = new AsnDCSimulationPackageDevice();
            asnDevInfo.iDeviceID = new BigInteger(String.valueOf(devInfo.getDevId()));
            asnDevInfo.strDeviceName = devInfo.getDevName().getBytes();
            asnDevInfo.sOriginalVersion = devInfo.getDevOriginalVersion().getBytes();
            asnDevInfo.sUpgradeVersion = devInfo.getDevUpgradeVersion().getBytes();
            asnDevInfo.strPath = devInfo.getFilePath().getBytes();
            asnDevInfo.strPackageFileName = devInfo.getFileName().getBytes();
            asnDevInfo.strRollBackPath = devInfo.getRollBackPath().getBytes();
            Vector boardList = devInfo.getBoardList();
            asnDevInfo.oBoardList = asnBoardList = new AsnDCSimulationPackageInfoOnBoardLst();
            for (int j = 0; j < boardList.size(); ++j) {
                AsnDCSimulationPackageInfoLst asnFileList;
                LoadSimPackageBoardInfo boardInfo = (LoadSimPackageBoardInfo)boardList.get(j);
                AsnDCSimulationPackageInfoOnBoard asnBoardInfo = new AsnDCSimulationPackageInfoOnBoard();
                AsnDCBoardInfo oBoardInfo = new AsnDCBoardInfo();
                oBoardInfo.iSlotId = new BigInteger(String.valueOf(boardInfo.getSlotId()));
                oBoardInfo.strBoardVersion = boardInfo.getBoardVersion().getBytes();
                oBoardInfo.strSlotLabel = boardInfo.getSlotLabel().getBytes();
                oBoardInfo.iBoardType = new BigInteger(String.valueOf(boardInfo.getBoardType()));
                oBoardInfo.sOriginalVersion = boardInfo.getBoardOriginalVersion().getBytes();
                oBoardInfo.sUpgradeVersion = boardInfo.getBoardUpgradeVersion().getBytes();
                if (boardInfo.getResourceType() != null) {
                    oBoardInfo.strBoardType = boardInfo.getResourceType().getBytes();
                }
                asnBoardInfo.oBoardInfo = oBoardInfo;
                Vector fileList = boardInfo.getFileList();
                asnBoardInfo.oSimulationPackageInfoLst = asnFileList = new AsnDCSimulationPackageInfoLst();
                for (int l = 0; l < fileList.size(); ++l) {
                    LoadSimPackageFileInfo fileInfo = (LoadSimPackageFileInfo)fileList.get(l);
                    AsnDCSimulationPackageToLoad asnFileInfo = new AsnDCSimulationPackageToLoad();
                    asnFileInfo.strFileName = fileInfo.getFileName().getBytes();
                    asnFileInfo.strSoftwareNewVersion = fileInfo.getSoftwareNewVersion().getBytes();
                    asnFileInfo.strSoftwareOldVersion = fileInfo.getSoftwareOldVersion().getBytes();
                    asnFileInfo.isNeedToLoad = fileInfo.getToBeLoad() != 0;
                    asnFileList.add((Object)asnFileInfo);
                }
                asnBoardList.add((Object)asnBoardInfo);
            }
            asnDevList.add((Object)asnDevInfo);
        }
    }

    public void switchAsnToTaskByActive(AsnDCActivationGroupInfo oActivationGroupInfo, ITask oTask) {
        ActiveInfo activeInfo = new ActiveInfo();
        if (oActivationGroupInfo.strActiveFilePath != null) {
            activeInfo.setFilePath(new String(oActivationGroupInfo.strActiveFilePath));
        }
        if (null != oActivationGroupInfo.oActivationTime) {
            activeInfo.setStartTime(oActivationGroupInfo.oActivationTime);
        }
        int iHighMode = oTask.getHighefficiencyMode();
        Vector<ActiveGroupInfo> groupList = new Vector<ActiveGroupInfo>();
        activeInfo.setGroupList(groupList);
        AsnDCActivationGroupLst oActiveGroupLst = oActivationGroupInfo.oActiveGroupLst;
        for (int i = 0; i < oActiveGroupLst.size(); ++i) {
            AsnDCActivationGroup asnGroupInfo = (AsnDCActivationGroup)oActiveGroupLst.get(i);
            ActiveGroupInfo groupInfo = new ActiveGroupInfo();
            groupInfo.setGroupId(asnGroupInfo.iGroupId.intValue());
            if (iHighMode == 1) {
                groupInfo.setIsPause(1);
            } else {
                groupInfo.setIsPause(asnGroupInfo.isPause.intValue());
            }
            Vector<ActiveDevInfo> devList = new Vector<ActiveDevInfo>();
            groupInfo.setActivationInfoLst(devList);
            int devCount = asnGroupInfo.oActivationInfoLst.size();
            for (int j = 0; j < devCount; ++j) {
                AsnDCActivationInfo asnDevInfo = (AsnDCActivationInfo)asnGroupInfo.oActivationInfoLst.get(j);
                ActiveDevInfo devInfo = new ActiveDevInfo();
                devInfo.setDevId(asnDevInfo.iDeviceId.intValue());
                devInfo.setOrder(asnDevInfo.iOrder.intValue());
                devInfo.setDevName(new String(asnDevInfo.strDeviceName));
                Vector<ActiveBoardInfo> boardList = new Vector<ActiveBoardInfo>();
                devInfo.setBoardList(boardList);
                DeviceInfo oDevInfo = DeviceInfoManagerImpl.getInstance().getDevice(devInfo.getDevId());
                if (null != asnDevInfo.oActivationBoardInfoLst) {
                    int boardCount = asnDevInfo.oActivationBoardInfoLst.size();
                    for (int l = 0; l < boardCount; ++l) {
                        AsnDCActivationBoardInfo asnBoardInfo = (AsnDCActivationBoardInfo)asnDevInfo.oActivationBoardInfoLst.get(l);
                        ActiveBoardInfo boardInfo = new ActiveBoardInfo();
                        AsnDCBoardInfo oBoardInfo = asnBoardInfo.oBoardInfo;
                        String strDisplayName = "";
                        if (oBoardInfo.strBoardType != null) {
                            strDisplayName = new String(oBoardInfo.strBoardType);
                            strDisplayName = ResourceManager.getInstance().getResString(oDevInfo.getDeviceTypeInfo(), strDisplayName);
                        }
                        boardInfo.setResourceType(strDisplayName);
                        boardInfo.setBoardType(oBoardInfo.iBoardType.hashCode());
                        if (oBoardInfo.strBoardVersion != null) {
                            boardInfo.setBoardVersion(new String(oBoardInfo.strBoardVersion));
                        } else {
                            boardInfo.setBoardVersion("");
                        }
                        boardInfo.setSlotId(oBoardInfo.iSlotId.intValue());
                        if (oBoardInfo.strSlotLabel != null) {
                            boardInfo.setSlotLabel(new String(oBoardInfo.strSlotLabel));
                        } else {
                            boardInfo.setSlotLabel("");
                        }
                        boardInfo.setActiveDeviceMode(asnBoardInfo.enActiveDeviceMode.value);
                        if (asnBoardInfo.isDeleteDatabase) {
                            boardInfo.setIsDeleteDatabase(1);
                        } else {
                            boardInfo.setIsDeleteDatabase(0);
                        }
                        boardList.add(boardInfo);
                    }
                }
                devList.add(devInfo);
            }
            groupList.add(groupInfo);
        }
        oTask.setActivationInfo(activeInfo);
    }

    public void switchAsnToTaskByLoad(AsnDCLoadSimulationPackageInfo asnlLoadSimPackageInfo, ITask oTask) {
        LoadSimPackageInfo loadSimPackageInfo = new LoadSimPackageInfo();
        Vector<LoadSimPackageDevInfo> devList = new Vector<LoadSimPackageDevInfo>();
        loadSimPackageInfo.setDevList(devList);
        AsnDCSimulationPackageDeviceList asnDevList = asnlLoadSimPackageInfo.oSimulationPackageDeviceList;
        for (int i = 0; i < asnDevList.size(); ++i) {
            AsnDCSimulationPackageDevice asnDevInfo = (AsnDCSimulationPackageDevice)asnDevList.get(i);
            LoadSimPackageDevInfo devInfo = new LoadSimPackageDevInfo();
            devInfo.setDevId(asnDevInfo.iDeviceID.intValue());
            devInfo.setDevName(new String(asnDevInfo.strDeviceName));
            devInfo.setDevOriginalVersion(new String(asnDevInfo.sOriginalVersion));
            devInfo.setDevUpgradeVersion(new String(asnDevInfo.sUpgradeVersion));
            devInfo.setFileName(new String(asnDevInfo.strPackageFileName));
            devInfo.setFilePath(new String(asnDevInfo.strPath));
            devInfo.setRollbackPath(new String(asnDevInfo.strRollBackPath));
            Vector<LoadSimPackageBoardInfo> boardList = new Vector<LoadSimPackageBoardInfo>();
            devInfo.setBoardList(boardList);
            AsnDCSimulationPackageInfoOnBoardLst asnBoardList = asnDevInfo.oBoardList;
            for (int j = 0; j < asnBoardList.size(); ++j) {
                AsnDCSimulationPackageInfoOnBoard asnBoardInfo = (AsnDCSimulationPackageInfoOnBoard)asnBoardList.get(j);
                LoadSimPackageBoardInfo boardInfo = new LoadSimPackageBoardInfo();
                AsnDCBoardInfo oBoardInfo = asnBoardInfo.oBoardInfo;
                boardInfo.setBoardType(oBoardInfo.iBoardType.hashCode());
                boardInfo.setBoardOriginalVersion(new String(oBoardInfo.sOriginalVersion));
                boardInfo.setBoardUpgradeVersion(new String(oBoardInfo.sUpgradeVersion));
                String strDisplayName = "";
                if (oBoardInfo.strBoardType != null) {
                    DeviceInfo oDevInfo = DeviceInfoManagerImpl.getInstance().getDevice(devInfo.getDevId());
                    strDisplayName = new String(oBoardInfo.strBoardType);
                    if (oDevInfo != null) {
                        strDisplayName = ResourceManager.getInstance().getResString(oDevInfo.getDeviceTypeInfo(), strDisplayName);
                    } else {
                        DCDebugTracer.trace("DC::SwitchTaskAndAsn::switchAsnToTaskByLoad::get oDevInfo is null.");
                    }
                }
                boardInfo.setResourceType(strDisplayName);
                if (oBoardInfo.strBoardVersion != null) {
                    boardInfo.setBoardVersion(new String(oBoardInfo.strBoardVersion));
                } else {
                    boardInfo.setBoardVersion("");
                }
                boardInfo.setSlotId(oBoardInfo.iSlotId.intValue());
                if (oBoardInfo.strSlotLabel != null) {
                    boardInfo.setSlotLabel(new String(oBoardInfo.strSlotLabel));
                } else {
                    boardInfo.setSlotLabel("");
                }
                Vector<LoadSimPackageFileInfo> fileList = new Vector<LoadSimPackageFileInfo>();
                boardInfo.setFileList(fileList);
                AsnDCSimulationPackageInfoLst asnFileList = asnBoardInfo.oSimulationPackageInfoLst;
                for (int l = 0; l < asnFileList.size(); ++l) {
                    AsnDCSimulationPackageToLoad asnFileInfo = (AsnDCSimulationPackageToLoad)asnFileList.get(l);
                    LoadSimPackageFileInfo fileInfo = new LoadSimPackageFileInfo();
                    fileInfo.setFileName(new String(asnFileInfo.strFileName));
                    fileInfo.setSoftwareNewVersion(new String(asnFileInfo.strSoftwareNewVersion));
                    fileInfo.setSoftwareOldVersion(new String(asnFileInfo.strSoftwareOldVersion));
                    if (asnFileInfo.isNeedToLoad) {
                        fileInfo.setToBeLoad(1);
                    } else {
                        fileInfo.setToBeLoad(0);
                    }
                    fileList.add(fileInfo);
                }
                boardList.add(boardInfo);
            }
            devList.add(devInfo);
        }
        oTask.setLoadSimPackageInfo(loadSimPackageInfo);
    }
}

