/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.model;

import com.huawei.dc.common.asndatacenter.AsnDCNodeInfo;
import com.huawei.dc.common.asndatacenter.AsnFileSelectLevelEnum;
import com.huawei.dc.common.asndatacenter.AsnLoadFileInfo;
import com.huawei.dc.common.asndatacenter.AsnLoadFileLst;
import com.huawei.dc.common.asndatacenter.AsnTaskDevOpInfo;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.taskmgmt.model.SubOperationObject;
import java.io.Serializable;
import java.text.Collator;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SubOprCheckItemDetails
implements Serializable {
    private static final long serialVersionUID = 1L;
    String m_strParentNodeID = "";
    HashMap<String, SubOperationObject> m_oNodeList = new HashMap();
    ArrayList<String> m_oOrderList = new ArrayList();
    int m_iDomain = -1;

    public String getParentNodeID() {
        return this.m_strParentNodeID;
    }

    public void setParentNodeID(String parentNodeID) {
        this.m_strParentNodeID = parentNodeID;
    }

    private void fillConnectivityInfo(String parentID, String nodeID) {
        SubOperationObject oSubOperationObject = new SubOperationObject();
        oSubOperationObject.setParentID(parentID);
        oSubOperationObject.setNodeID(nodeID);
        oSubOperationObject.setHasSubCheckItems(false);
        this.m_oNodeList.put(parentID + nodeID, oSubOperationObject);
        ResourceManager resMgr = ResourceManager.getInstance();
        String connectivity = "Connectivity";
        String precheck = resMgr.getResString("UPGRADE_PRECHECK");
        String postcheck = resMgr.getResString("UPGRADE_POSTCHECK");
        String ping = "ping";
        String tracert = "tracert";
        Iterator<String> iterOrder = this.m_oOrderList.iterator();
        while (iterOrder.hasNext()) {
            String order = iterOrder.next().toLowerCase();
            if (!order.contains(connectivity) || order.contains(precheck) || order.contains(postcheck) || order.contains("ping") || order.contains("tracert")) continue;
            iterOrder.remove();
            break;
        }
        Iterator<Map.Entry<String, SubOperationObject>> iter = this.m_oNodeList.entrySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next().getKey().toLowerCase();
            if (!key.contains(connectivity) || key.contains(precheck) || key.contains(postcheck) || key.contains("ping") || key.contains("tracert")) continue;
            iter.remove();
        }
        if (!this.m_oOrderList.contains(parentID + nodeID)) {
            this.m_oOrderList.add(parentID + nodeID);
        }
    }

    public void updateCheckItemDetails(AsnDCNodeInfo oAsnNodeInfo, int iOprID) {
        String strAsnPID = Normalizer.normalize(new String(oAsnNodeInfo.strParentID), Normalizer.Form.NFC);
        String strAsnNID = Normalizer.normalize(new String(oAsnNodeInfo.strNodeID), Normalizer.Form.NFC);
        if ("Connectivity".equalsIgnoreCase(strAsnPID) && !"Connectivity".equalsIgnoreCase(strAsnNID) && !strAsnNID.isEmpty()) {
            this.fillConnectivityInfo(strAsnPID, strAsnNID);
        }
        if (!strAsnNID.isEmpty()) {
            SubOperationObject oSubOperationObject = null;
            if (4 == iOprID) {
                if (Collator.getInstance().equals(strAsnPID, "")) {
                    strAsnPID = ResourceManager.getInstance().getResString("UPGRADE_PRECHECK");
                }
            } else if (16 == iOprID) {
                if (Collator.getInstance().equals(strAsnPID, "")) {
                    strAsnPID = ResourceManager.getInstance().getResString("UPGRADE_POSTCHECK");
                }
            } else if (32 == iOprID) {
                if (Collator.getInstance().equals(strAsnPID, "PrepareUpgrade")) {
                    strAsnPID = ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_OPERATION_TYPE_39");
                }
            } else if (33 == iOprID && Collator.getInstance().equals(strAsnPID, "PostUpgrade")) {
                strAsnPID = ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_OPERATION_TYPE_40");
            }
            if (null != (oSubOperationObject = this.m_oNodeList.get(strAsnPID + strAsnNID))) {
                if (null != oAsnNodeInfo.oAsnDCConnInfo) {
                    oSubOperationObject.getDevConnInfo().setCheckMode(oAsnNodeInfo.oAsnDCConnInfo.iCheckMode.intValue());
                    oSubOperationObject.getDevConnInfo().setDevID(oAsnNodeInfo.oAsnDCConnInfo.iDevId.intValue());
                    oSubOperationObject.getDevConnInfo().setStrContent(new String(oAsnNodeInfo.oAsnDCConnInfo.strContent));
                }
                if (null != oAsnNodeInfo.oAsnDCNodeAttrEx) {
                    if (null != oAsnNodeInfo.oAsnDCNodeAttrEx.strCmdResult) {
                        oSubOperationObject.getOprNodeAttributes().setCmdResult(new String(oAsnNodeInfo.oAsnDCNodeAttrEx.strCmdResult));
                    }
                    if (null != oAsnNodeInfo.oAsnDCNodeAttrEx.oStartTime) {
                        oSubOperationObject.getOprNodeAttributes().setStartTime(oAsnNodeInfo.oAsnDCNodeAttrEx.oStartTime);
                    } else {
                        oSubOperationObject.getOprNodeAttributes().setStartTime(null);
                    }
                    if (null != oAsnNodeInfo.oAsnDCNodeAttrEx.oEndTime) {
                        oSubOperationObject.getOprNodeAttributes().setEndTime(oAsnNodeInfo.oAsnDCNodeAttrEx.oEndTime);
                    } else {
                        oSubOperationObject.getOprNodeAttributes().setEndTime(null);
                    }
                    oSubOperationObject.getOprNodeAttributes().setStatus(oAsnNodeInfo.oAsnDCNodeAttrEx.oCheckResultTypeEnum.value);
                    oSubOperationObject.getOprNodeAttributes().setErrorInfo(oAsnNodeInfo.oAsnDCNodeAttrEx.oErrorInfo);
                    oSubOperationObject.getOprNodeAttributes().setOprResult(this.getCheckItemOprResult(oAsnNodeInfo.oAsnDCNodeAttrEx.oCheckResultTypeEnum.value));
                }
                if (null != oAsnNodeInfo.oAsnDCNodeAttr) {
                    if (null != oAsnNodeInfo.oAsnDCNodeAttr.strCmd) {
                        oSubOperationObject.getOprNodeAttributes().setCommand(new String(oAsnNodeInfo.oAsnDCNodeAttr.strCmd));
                    }
                    if (null != oAsnNodeInfo.oAsnDCNodeAttr.strDesc) {
                        oSubOperationObject.getOprNodeAttributes().setDescription(new String(oAsnNodeInfo.oAsnDCNodeAttr.strDesc));
                    } else {
                        oSubOperationObject.getOprNodeAttributes().setDescription("");
                    }
                    oSubOperationObject.getOprNodeAttributes().setNodeName(new String(oAsnNodeInfo.oAsnDCNodeAttr.strName));
                } else {
                    oSubOperationObject.getOprNodeAttributes().setDescription("");
                }
            }
        }
        if (null != oAsnNodeInfo.oAsnDCNodeInfoLst) {
            int iSize = oAsnNodeInfo.oAsnDCNodeInfoLst.size();
            for (int i = 0; i < iSize; ++i) {
                this.updateCheckItemDetails((AsnDCNodeInfo)oAsnNodeInfo.oAsnDCNodeInfoLst.get(i), iOprID);
            }
        }
    }

    public void updateCheckItemDetails(AsnDCNodeInfo oAsnNodeInfo, int iOprID, int iDevId) {
        String strAsnPID = Normalizer.normalize(new String(oAsnNodeInfo.strParentID), Normalizer.Form.NFC);
        String strAsnNID = Normalizer.normalize(new String(oAsnNodeInfo.strNodeID), Normalizer.Form.NFC);
        if (!strAsnNID.isEmpty()) {
            SubOperationObject oSubOperationObject = null;
            if (32 == iOprID && Collator.getInstance().equals(strAsnPID, "PrepareUpgrade")) {
                strAsnPID = ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_OPERATION_TYPE_39");
            }
            oSubOperationObject = this.m_oNodeList.get(strAsnPID + strAsnNID + iDevId);
            DCDebugTracer.trace("strAsnPID : " + strAsnPID);
            DCDebugTracer.trace("strAsnNID : " + strAsnNID);
            DCDebugTracer.trace("iDevId : " + iDevId);
            if (null != oSubOperationObject) {
                if (null != oAsnNodeInfo.oAsnDCConnInfo) {
                    oSubOperationObject.getDevConnInfo().setCheckMode(oAsnNodeInfo.oAsnDCConnInfo.iCheckMode.intValue());
                    oSubOperationObject.getDevConnInfo().setDevID(oAsnNodeInfo.oAsnDCConnInfo.iDevId.intValue());
                    oSubOperationObject.getDevConnInfo().setStrContent(new String(oAsnNodeInfo.oAsnDCConnInfo.strContent));
                }
                if (null != oAsnNodeInfo.oAsnDCNodeAttrEx) {
                    if (null != oAsnNodeInfo.oAsnDCNodeAttrEx.strCmdResult) {
                        oSubOperationObject.getOprNodeAttributes().setCmdResult(new String(oAsnNodeInfo.oAsnDCNodeAttrEx.strCmdResult));
                    }
                    if (null != oAsnNodeInfo.oAsnDCNodeAttrEx.oStartTime) {
                        oSubOperationObject.getOprNodeAttributes().setStartTime(oAsnNodeInfo.oAsnDCNodeAttrEx.oStartTime);
                    } else {
                        oSubOperationObject.getOprNodeAttributes().setStartTime(null);
                    }
                    if (null != oAsnNodeInfo.oAsnDCNodeAttrEx.oEndTime) {
                        oSubOperationObject.getOprNodeAttributes().setEndTime(oAsnNodeInfo.oAsnDCNodeAttrEx.oEndTime);
                    } else {
                        oSubOperationObject.getOprNodeAttributes().setEndTime(null);
                    }
                    oSubOperationObject.getOprNodeAttributes().setStatus(oAsnNodeInfo.oAsnDCNodeAttrEx.oCheckResultTypeEnum.value);
                    oSubOperationObject.getOprNodeAttributes().setErrorInfo(oAsnNodeInfo.oAsnDCNodeAttrEx.oErrorInfo);
                    oSubOperationObject.getOprNodeAttributes().setOprResult(this.getCheckItemOprResult(oAsnNodeInfo.oAsnDCNodeAttrEx.oCheckResultTypeEnum.value));
                }
                if (null != oAsnNodeInfo.oAsnDCNodeAttr) {
                    if (null != oAsnNodeInfo.oAsnDCNodeAttr.strCmd) {
                        oSubOperationObject.getOprNodeAttributes().setCommand(new String(oAsnNodeInfo.oAsnDCNodeAttr.strCmd));
                    }
                    if (null != oAsnNodeInfo.oAsnDCNodeAttr.strDesc) {
                        oSubOperationObject.getOprNodeAttributes().setDescription(new String(oAsnNodeInfo.oAsnDCNodeAttr.strDesc));
                    }
                    oSubOperationObject.getOprNodeAttributes().setNodeName(new String(oAsnNodeInfo.oAsnDCNodeAttr.strName));
                }
            } else {
                DCDebugTracer.trace("oSubOperationObject is null");
            }
        }
        if (null != oAsnNodeInfo.oAsnDCNodeInfoLst) {
            int iSize = oAsnNodeInfo.oAsnDCNodeInfoLst.size();
            for (int i = 0; i < iSize; ++i) {
                this.updateCheckItemDetails((AsnDCNodeInfo)oAsnNodeInfo.oAsnDCNodeInfoLst.get(i), iOprID, iDevId);
            }
        }
    }

    private int getCheckItemOprResult(int iOprResult) {
        int iResult = 0;
        switch (iOprResult) {
            case 1: {
                iResult = 0;
                break;
            }
            case 2: {
                iResult = 1;
                break;
            }
            default: {
                iResult = 0;
            }
        }
        return iResult;
    }

    public void setDomain(int iDomain) {
        this.m_iDomain = iDomain;
    }

    public void updateSubOprDetails(AsnTaskDevOpInfo oDevOp, String strParentID, String strNodeID, int iOprID) {
        if (null != oDevOp) {
            if (null == oDevOp.oFileLst && null == oDevOp.oAsnDCNodeInfo) {
                this.updateSingleNodeOperatons(oDevOp, strParentID, strNodeID);
            } else if (null == oDevOp.oAsnDCNodeInfo && null != oDevOp.oFileLst) {
                if (4 != this.m_iDomain) {
                    this.updateFileOperationData(oDevOp, strNodeID);
                } else {
                    this.updateSingleNodeOperatons(oDevOp, strParentID, strNodeID);
                }
            } else if (null != oDevOp.oAsnDCNodeInfo) {
                if (null == oDevOp.oAsnDCNodeInfo.oAsnDCNodeInfoLst || 0 == oDevOp.oAsnDCNodeInfo.oAsnDCNodeInfoLst.size()) {
                    if (16 == iOprID) {
                        this.updateSingleNodeOperatons(oDevOp, "", ResourceManager.getInstance().getResString("UPGRADE_POSTCHECK"));
                    } else if (4 == iOprID) {
                        this.updateSingleNodeOperatons(oDevOp, "", ResourceManager.getInstance().getResString("UPGRADE_PRECHECK"));
                    } else {
                        DCDebugTracer.trace("current operation do not need handle , iOprID : " + iOprID);
                    }
                }
                this.updateCheckItemDetails(oDevOp.oAsnDCNodeInfo, iOprID);
            }
        }
    }

    public void updateSubOprDetails(AsnTaskDevOpInfo oDevOp, String strParentID, String strNodeID, int iOprID, int iDevId) {
        if (null != oDevOp) {
            if (null == oDevOp.oFileLst && null == oDevOp.oAsnDCNodeInfo) {
                if (strNodeID.equals(ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_OPERATION_TYPE_8")) && 2 == this.m_iDomain) {
                    return;
                }
                this.updateSingleNodeOperatons(oDevOp, strParentID, strNodeID);
            } else if (null == oDevOp.oAsnDCNodeInfo && null != oDevOp.oFileLst) {
                if (4 != this.m_iDomain) {
                    this.updateFileOperationData(oDevOp, strNodeID);
                } else {
                    this.updateSingleNodeOperatons(oDevOp, strParentID, strNodeID);
                }
            } else if (null != oDevOp.oAsnDCNodeInfo) {
                this.updateCheckItemDetails(oDevOp.oAsnDCNodeInfo, iOprID, iDevId);
            }
        }
    }

    private void updateFileOperationData(AsnTaskDevOpInfo oDevOp, String strNodeID) {
        strNodeID = Normalizer.normalize(strNodeID, Normalizer.Form.NFC);
        SubOperationObject oSubOperationObject = null;
        AsnLoadFileLst oAsnLoadFileLst = oDevOp.oFileLst;
        int iFileList = oAsnLoadFileLst.size();
        AsnLoadFileInfo oFileInfo = null;
        block5: for (int k = 0; k < iFileList; ++k) {
            oFileInfo = (AsnLoadFileInfo)oAsnLoadFileLst.get(k);
            oSubOperationObject = null;
            if (null != oFileInfo.iSequence) {
                if (null != oFileInfo.iDevId) {
                    if (null == oFileInfo.iFileSelectLevelEnum) {
                        oFileInfo.iFileSelectLevelEnum = new AsnFileSelectLevelEnum(0);
                    }
                    oSubOperationObject = this.m_oNodeList.get(strNodeID + oFileInfo.iDevId.intValue() + oFileInfo.iFileSelectLevelEnum.value + oFileInfo.iSequence.intValue());
                } else {
                    DCDebugTracer.trace("Device ID in the AsnLoadFileInfo asn structure is null");
                }
            }
            if (null == oSubOperationObject) {
                if (null != oFileInfo.iContentType) {
                    oSubOperationObject = this.m_oNodeList.get(strNodeID + oFileInfo.iContentType.intValue());
                } else {
                    DCDebugTracer.trace("Content type information in the AsnLoadFileInfo asn structure is null");
                }
            }
            if (null == oSubOperationObject) continue;
            if (null != oFileInfo.oStartTime) {
                oSubOperationObject.getOprNodeAttributes().setStartTime(oFileInfo.oStartTime);
            } else if (null == oFileInfo.oEndTime) {
                oSubOperationObject.getOprNodeAttributes().setStartTime(null);
            }
            if (null != oFileInfo.oEndTime) {
                oSubOperationObject.getOprNodeAttributes().setEndTime(oFileInfo.oEndTime);
            } else {
                oSubOperationObject.getOprNodeAttributes().setEndTime(null);
            }
            oSubOperationObject.getOprNodeAttributes().setErrorInfo(oFileInfo.oErrorInfo);
            if (null == oFileInfo.enResult) continue;
            oSubOperationObject.getOprNodeAttributes().setOprResult(oFileInfo.enResult.value);
            switch (oFileInfo.enResult.value) {
                case 0: {
                    oSubOperationObject.getOprNodeAttributes().setStatus(3);
                    continue block5;
                }
                case 1: {
                    oSubOperationObject.getOprNodeAttributes().setStatus(2);
                    continue block5;
                }
                case 2: {
                    oSubOperationObject.getOprNodeAttributes().setStatus(4);
                    continue block5;
                }
                default: {
                    oSubOperationObject.getOprNodeAttributes().setStatus(0);
                }
            }
        }
    }

    private void updateSingleNodeOperatons(AsnTaskDevOpInfo oDevOp, String strParentID, String strNodeID) {
        strParentID = Normalizer.normalize(strParentID, Normalizer.Form.NFC);
        strNodeID = Normalizer.normalize(strNodeID, Normalizer.Form.NFC);
        SubOperationObject oSubOperationObject = null;
        oSubOperationObject = this.m_oNodeList.get(strParentID + strNodeID);
        if (null != oSubOperationObject) {
            if (null != oDevOp.oOprStartTime) {
                oSubOperationObject.getOprNodeAttributes().setStartTime(oDevOp.oOprStartTime);
            } else {
                oSubOperationObject.getOprNodeAttributes().setStartTime(null);
            }
            if (null != oDevOp.oOprEndTime) {
                oSubOperationObject.getOprNodeAttributes().setEndTime(oDevOp.oOprEndTime);
            } else {
                oSubOperationObject.getOprNodeAttributes().setEndTime(null);
            }
            if (null != oDevOp.enOpStatus) {
                oSubOperationObject.getOprNodeAttributes().setStatus(oDevOp.enOpStatus.value);
            }
            if (0 == oDevOp.stErrorInfo.iErrorNo.intValue()) {
                if (strNodeID.equals(ResourceManager.getInstance().getResString("UPGRADE_POSTCHECK")) || strNodeID.equals(ResourceManager.getInstance().getResString("UPGRADE_PRECHECK"))) {
                    oSubOperationObject.getOprNodeAttributes().setErrorInfo(null);
                } else {
                    oSubOperationObject.getOprNodeAttributes().setErrorInfo(oDevOp.stErrorInfo);
                }
            } else {
                oSubOperationObject.getOprNodeAttributes().setErrorInfo(oDevOp.stErrorInfo);
            }
            if (null != oDevOp.enOpResult) {
                oSubOperationObject.getOprNodeAttributes().setOprResult(oDevOp.enOpResult.value);
            }
        }
    }

    public HashMap<String, SubOperationObject> getNodeList() {
        return this.m_oNodeList;
    }

    public void setNodeList(HashMap<String, SubOperationObject> oNodeList) {
        this.m_oNodeList = oNodeList;
    }

    public ArrayList<String> getOrderList() {
        return this.m_oOrderList;
    }

    public void setOrderList(ArrayList<String> oOrderList) {
        this.m_oOrderList = oOrderList;
    }
}

