/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.model;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCHelpForErrCodeUtil;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.model.ProgressInfo;
import java.awt.Color;
import java.math.BigInteger;
import java.util.Calendar;

public class ResourceProgressInfo
extends ProgressInfo {
    private String m_strCurrentOperationId = "";
    private String m_strCurrentOperationName = "";
    private String strErrorInfo = null;
    private int m_iErrorType = 0;
    private Calendar m_strStartTime = null;
    private Calendar m_strEndTime = null;
    private String strStartTime = null;
    private String strEndTime = null;
    private int iErrorNum = 0;
    private String m_strFailureReason = "";
    private String m_strSWDLStatus = "";
    private int m_iSWDLStatus = 0;
    private boolean m_bSWDLFlag = false;
    private static final Color RES_STATE_FAILURE_COLOR = new Color(196, 48, 45);
    private static final Color RES_STATE_NOT_RUN_COLOR = Color.BLACK;
    private Color m_oResStatusColor = null;

    public boolean isSWDLFlag() {
        return this.m_bSWDLFlag;
    }

    public void setSWDLFlag(boolean flag) {
        this.m_bSWDLFlag = flag;
    }

    public String getCurrentOperationId() {
        return this.m_strCurrentOperationId;
    }

    public void setCurrentOperationId(String currentOperationId) {
        this.m_strCurrentOperationId = currentOperationId;
    }

    public String getErrorInfo() {
        return this.strErrorInfo;
    }

    public void setErrorInfo(int iErrorInfo, String strErrMsg) {
        this.iErrorNum = iErrorInfo;
        this.strErrorInfo = iErrorInfo == 0 && (this.m_strCurrentOperationId.equals("PreCheck") || this.m_strCurrentOperationId.equals("PostCheck")) ? DCConstants.OPEREATION_COMPLETE : ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorInfo));
        if (999293081 == this.iErrorNum) {
            if (null != strErrMsg && strErrMsg.trim().length() > 0) {
                this.strErrorInfo = strErrMsg;
            }
        } else if (this.strErrorInfo.equals(BigInteger.valueOf(iErrorInfo).toString())) {
            if (null != strErrMsg && strErrMsg.trim().length() > 0) {
                this.strErrorInfo = strErrMsg + " (" + this.strErrorInfo + ")";
            }
        } else if (!(0 == this.iErrorNum && "PrepareUpgrade".equals(this.m_strCurrentOperationId) || null == strErrMsg || strErrMsg.trim().length() <= 0)) {
            this.strErrorInfo = this.strErrorInfo + " (" + strErrMsg + ")";
        }
    }

    @Override
    public String toString() {
        if (this.m_bSWDLFlag) {
            this.m_bSWDLFlag = false;
            return this.m_strSWDLStatus;
        }
        if (0 == this.m_iState) {
            return ResourceManager.getInstance().getResString("TASK_STATE_NOT_RUN");
        }
        if (1 == this.m_iState) {
            if (997195801 == this.iErrorNum) {
                return this.strErrorInfo + " : " + this.m_iProgress + '%';
            }
            return "" + this.m_iProgress + '%';
        }
        if (999293081 == this.iErrorNum) {
            return DCCommonUtil.getFailureStr("", this.iErrorNum);
        }
        if (null != this.m_strFailureReason && !"".equalsIgnoreCase(this.m_strFailureReason)) {
            this.strErrorInfo = this.strErrorInfo + " " + this.m_strFailureReason;
        }
        if (2 == this.m_iState) {
            if (DCHelpForErrCodeUtil.isShowHyperlink(this.iErrorNum)) {
                return DCCommonUtil.getHyperlinkStr("", this.strErrorInfo);
            }
            return DCCommonUtil.getFailureStr("", this.strErrorInfo);
        }
        if (3 == this.m_iState && 1 == this.m_iResult) {
            return DCCommonUtil.getFailureStr("", this.strErrorInfo);
        }
        this.setResStatusColor(RES_STATE_NOT_RUN_COLOR);
        return this.strErrorInfo;
    }

    @Override
    public String getToolTipText() {
        if (this.m_bSWDLFlag) {
            this.m_bSWDLFlag = false;
            return this.m_strSWDLStatus;
        }
        if (0 == this.m_iState) {
            return ResourceManager.getInstance().getResString("TASK_STATE_NOT_RUN");
        }
        if (1 == this.m_iState) {
            return "" + this.m_iProgress + '%';
        }
        if (999293081 == this.iErrorNum) {
            return ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(this.iErrorNum));
        }
        if (null != this.m_strFailureReason && !"".equalsIgnoreCase(this.m_strFailureReason)) {
            this.strErrorInfo = this.strErrorInfo + this.m_strFailureReason;
        }
        return this.strErrorInfo;
    }

    public String getResultFoReport() {
        if (this.iErrorNum == 999293081) {
            return DCFrameWorkUtil.getLocalizedString("OPERATIONFAILED") + "\n" + this.m_strFailureReason;
        }
        return this.getToolTipText();
    }

    public String getFailureReason() {
        return this.m_strFailureReason;
    }

    public void setFailureReason(String strFailureReason) {
        this.m_strFailureReason = strFailureReason;
    }

    public String getCurrentOperationName() {
        return this.m_strCurrentOperationName;
    }

    public void setCurrentOperationName(String strCurrentOperationName) {
        this.m_strCurrentOperationName = strCurrentOperationName;
    }

    public void setStartTime(Calendar oStartTime) {
        this.m_strStartTime = oStartTime;
    }

    public Calendar getStartTime() {
        return this.m_strStartTime;
    }

    public void setEndTime(Calendar oEndTime) {
        this.m_strEndTime = oEndTime;
    }

    public Calendar getEndTime() {
        return this.m_strEndTime;
    }

    public boolean equals(Object oOtherObj) {
        return oOtherObj instanceof ResourceProgressInfo && null != this.m_strCurrentOperationId && this.m_strCurrentOperationId.equalsIgnoreCase(((ResourceProgressInfo)oOtherObj).m_strCurrentOperationId);
    }

    public int hashCode() {
        if (null != this.m_strCurrentOperationId) {
            return this.m_strCurrentOperationId.hashCode();
        }
        return -1;
    }

    public void copy(ResourceProgressInfo oProgressInfo) {
        if (null == oProgressInfo) {
            return;
        }
        this.setCurrentOperationId(oProgressInfo.getCurrentOperationId());
        this.setCurrentOperationName(oProgressInfo.getCurrentOperationName());
        this.setEndTime(oProgressInfo.getEndTime());
        this.iErrorNum = oProgressInfo.iErrorNum;
        this.m_strFailureReason = oProgressInfo.getFailureReason();
        this.setProgress(oProgressInfo.getProgress());
        this.setResult(oProgressInfo.getResult());
        this.setStartTime(oProgressInfo.getStartTime());
        this.setState(oProgressInfo.getState());
    }

    public int getErrorNo() {
        return this.iErrorNum;
    }

    public String getStrStartTime() {
        return this.strStartTime;
    }

    public void setStrStartTime(String strStartTime) {
        this.strStartTime = strStartTime;
    }

    public String getStrEndTime() {
        return this.strEndTime;
    }

    public void setStrEndTime(String strEndTime) {
        this.strEndTime = strEndTime;
    }

    public String getSWDLStatus() {
        return this.m_strSWDLStatus;
    }

    public void setSWDLStatus(String status) {
        this.m_strSWDLStatus = status;
    }

    public void setSWDLStatus(String status, boolean bSupportPackageStatus) {
        if (!bSupportPackageStatus) {
            this.m_strSWDLStatus = "";
            return;
        }
        this.m_strSWDLStatus = status;
    }

    private synchronized void setResStatusColor(Color oResStatusColor) {
        this.m_oResStatusColor = oResStatusColor;
    }

    public Color getColorForResState() {
        return this.m_oResStatusColor;
    }

    public void setErrorType(int iType) {
        this.m_iErrorType = iType;
    }

    public int getErrorType() {
        return this.m_iErrorType;
    }

    public int getIntSWDLStatus() {
        return this.m_iSWDLStatus;
    }

    public void setIntSWDLStatus(int m_iSWDLStatus) {
        this.m_iSWDLStatus = m_iSWDLStatus;
    }
}

