/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.model;

import com.huawei.dc.common.controller.AbstractDeviceInfoManager;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.security.DCEncryptServiceUtil;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.standalone.snmpparams.model.SnmpParaInfo;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import com.huawei.dc.taskmgmt.model.ITaskSubOperation;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import com.huawei.dc.taskmgmt.model.TaskDeviceLogInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Resource
implements Serializable {
    private static final long serialVersionUID = 5897501134956408923L;
    public static final int UNKNOWN_BOARD = -1;
    public static final int NOT_ISOLATION_BOARD = 0;
    public static final int ISOLATION_BOARD = 1;
    private int m_iUpgradeMode = 0;
    private int m_iUpgradeModeConfig = 0;
    private String m_strDeviceName = null;
    private String m_strDeviceIP = null;
    private long m_lDevIP = 0L;
    private String m_strTL1ProtocolDevicePhyID = null;
    private int m_iMMLProtocolDevicePhyID = -1;
    private int m_iProtocol = -1;
    private int m_iGatewayType = -1;
    private String m_strGatewayAddress = null;
    private int m_iPort = 0;
    private String m_strUser = null;
    private char[] m_strPassword = null;
    private char[] m_strSuperPassword = null;
    private int m_iDeviceID = -1;
    private int m_iFrameId = -1;
    private int m_iSlotId = -1;
    private int m_iStackId = -1;
    private String m_strSlotLabel;
    private String m_strDeviceVersion = null;
    private int m_iParentDevId = -1;
    private int m_iRoleType = -1;
    private int m_iSubSlotId = -1;
    private int m_iBoardType;
    private int m_iBoardResetType;
    private String m_strBoardTypeName;
    private int iDevTypeId = -1;
    private boolean extendCheckFail;
    private int iUpgradeResult = 0;
    private String m_strOriginalVersion = "";
    private String m_strUpgradeVersion = "";
    private List<ResourceProgressInfo> m_oOperationList;
    private ResourceProgressInfo m_oProgressInfo = new ResourceProgressInfo();
    private Map<String, ResourceProgressInfo> m_oOprResultInfoMap = null;
    private Map<Integer, ITaskSubOperation> m_oSubOprListMap = null;
    private TaskDeviceLogInfo m_oDeviceLogInfo = null;
    private DeviceTypeInfo m_oStackDevTypeInfo;
    private boolean m_bIsOperationCancelled = false;
    private SnmpParaInfo m_oSnmpParaInfo = null;
    private int m_iDevVersionID = -1;
    private int m_iAddResoult = -1;
    private String m_strVPNName = null;
    private int m_iProxyType = 1;
    private int m_iProxyNodeType = -1;
    private String m_strAgentID = "";
    private int m_iSWDLStatus = 0;
    private int m_iIsolationBoard = -1;
    private String m_strMainBoardNum = "--";
    private int m_iMainBoardNum = 0;
    private int m_iKeyMode = 1;

    public void setKeyMode(int iKeyMode) {
        this.m_iKeyMode = iKeyMode;
    }

    public int getKeyMode() {
        return this.m_iKeyMode;
    }

    public boolean isOperationAlreadyCancelled() {
        return this.m_bIsOperationCancelled;
    }

    public void setOperationCancelled(boolean isOperationCancelled) {
        this.m_bIsOperationCancelled = isOperationCancelled;
    }

    public Resource() {
        this.m_oOperationList = new ArrayList<ResourceProgressInfo>(0);
        this.m_oOprResultInfoMap = new HashMap<String, ResourceProgressInfo>();
        this.m_oSubOprListMap = new HashMap<Integer, ITaskSubOperation>();
    }

    public void setAddResoult(int m_iAddResoult) {
        this.m_iAddResoult = m_iAddResoult;
    }

    public int getAddRseoult() {
        return this.m_iAddResoult;
    }

    public String getDeviceName() {
        String sResName;
        AbstractDeviceInfoManager oDeviceInfoMgr = (AbstractDeviceInfoManager)DeviceInfoManagerImpl.getInstance();
        StringBuffer strResourceName = new StringBuffer(0);
        if (!StringUtils.isNullOrEmptyStr(this.m_strDeviceName)) {
            strResourceName.append(this.m_strDeviceName);
        }
        if (-1 != this.m_iFrameId) {
            String sFrameLabel = this.getLableByFrame();
            if (!StringUtils.isNullOrEmptyStr(sFrameLabel)) {
                strResourceName.append('_');
                strResourceName.append(sFrameLabel);
            } else {
                DCDebugTracer.trace("LableByFrame is null");
            }
        }
        if (-1 != this.m_iSlotId) {
            int m_iDeviceDomain = oDeviceInfoMgr.getDevice(this.m_iDeviceID).getDeviceTypeInfo().getDevDomain();
            if (m_iDeviceDomain == 4) {
                String sBoardNameForT2000 = oDeviceInfoMgr.getBoardNameForT2000(this.m_iSlotId);
                if (!StringUtils.isNullOrEmptyStr(sBoardNameForT2000)) {
                    strResourceName.append('_');
                    strResourceName.append(sBoardNameForT2000);
                }
            } else {
                strResourceName.append('_');
                strResourceName.append(this.m_iSlotId);
            }
        }
        if (-1 != this.m_iSubSlotId) {
            strResourceName.append('_');
            strResourceName.append(this.m_iSubSlotId);
        }
        if (-1 != this.m_iStackId) {
            strResourceName = new StringBuffer(0);
            strResourceName.append(oDeviceInfoMgr.getDevice(this.m_iDeviceID).getDevName());
            strResourceName.append('_');
            strResourceName.append(this.m_iStackId);
        }
        if ((sResName = strResourceName.toString()).length() > 1 && sResName.startsWith("_")) {
            sResName = sResName.substring(1, sResName.length());
        }
        return sResName;
    }

    private String getLableByFrame() {
        if (DCFrameWorkUtil.getDeviceInfoManager().getDevice(this.m_iDeviceID).getDeviceTypeInfo().getDevDomain() == 4) {
            return this.getSlotLabel();
        }
        return String.valueOf(this.m_iFrameId);
    }

    public void setDeviceName(String deviceName) {
        this.m_strDeviceName = deviceName;
    }

    public String getDeviceIP() {
        return this.m_strDeviceIP;
    }

    public void setDeviceIP(String deviceIP) {
        this.m_strDeviceIP = deviceIP;
        this.m_lDevIP = DCCommonUtil.convertStringtoLong(deviceIP);
    }

    public long getLDevIP() {
        return this.m_lDevIP;
    }

    public int getDeviceID() {
        return this.m_iDeviceID;
    }

    public void setDeviceID(int deviceID) {
        this.m_iDeviceID = deviceID;
    }

    public int getFrameId() {
        return this.m_iFrameId;
    }

    public void setFrameId(int frameId) {
        this.m_iFrameId = frameId;
    }

    public int getSlotId() {
        return this.m_iSlotId;
    }

    public void setSlotId(int slotId) {
        this.m_iSlotId = slotId;
    }

    public String getSlotLabel() {
        return this.m_strSlotLabel;
    }

    public void setSlotLabel(String m_strSlotLabel) {
        this.m_strSlotLabel = m_strSlotLabel;
    }

    public ResourceProgressInfo getProgressInfo() {
        return this.m_oProgressInfo;
    }

    public void setProgressInfo(ResourceProgressInfo oProgressInfo) {
        this.m_oProgressInfo = oProgressInfo;
    }

    public String getDeviceVersion() {
        if (null != this.m_strDeviceVersion) {
            return this.m_strDeviceVersion;
        }
        return this.getVersionForDevice();
    }

    private String getVersionForDevice() {
        DeviceInfo oDeviceInfo = DCFrameWorkUtil.getDeviceInfoManager().getDevice(this.m_iDeviceID);
        if (null == oDeviceInfo || null == oDeviceInfo.getDevVersion() || null == oDeviceInfo.getDevVersion().getDevVersion() || "".equals(oDeviceInfo.getDevVersion().getDevVersion().trim())) {
            return ResourceManager.getInstance().getResString("UNKNOWN_VERSION");
        }
        return oDeviceInfo.getDevVersion().getDevVersion();
    }

    public String getDeviceType() {
        DeviceInfo oDeviceInfo = DCFrameWorkUtil.getDeviceInfoManager().getDevice(this.m_iDeviceID);
        if (null == oDeviceInfo || null == oDeviceInfo.getDeviceTypeInfo() || null == oDeviceInfo.getDeviceTypeInfo().getDevTypeName() || "".equals(oDeviceInfo.getDeviceTypeInfo().getDevTypeName().trim())) {
            return ResourceManager.getInstance().getResString("UNKNOWN_VERSION");
        }
        return oDeviceInfo.getDeviceTypeInfo().getDevTypeName();
    }

    public void setDeviceVersion(String deviceVersion) {
        this.m_strDeviceVersion = deviceVersion;
    }

    public int getParentDevId() {
        return this.m_iParentDevId;
    }

    public void setParentDevId(int parentDevId) {
        this.m_iParentDevId = parentDevId;
    }

    public int getRoleType() {
        return this.m_iRoleType;
    }

    public void setRoleType(int roleType) {
        this.m_iRoleType = roleType;
    }

    public int getSubSlotId() {
        return this.m_iSubSlotId;
    }

    public int getProtocolType() {
        return this.m_iProtocol;
    }

    public void setProtocolType(int iProtocolType) {
        this.m_iProtocol = iProtocolType;
    }

    public void setGatewayType(int iGatewayType) {
        this.m_iGatewayType = iGatewayType;
    }

    public String getGatewayAddress() {
        return this.m_strGatewayAddress;
    }

    public void setGatewayAddress(String strGatewayAddress) {
        this.m_strGatewayAddress = strGatewayAddress;
    }

    public int getPortValue() {
        return this.m_iPort;
    }

    public void setPortValue(int iPort) {
        this.m_iPort = iPort;
    }

    public void setUserName(String strUser) {
        this.m_strUser = strUser;
    }

    public String getUserName() {
        return this.m_strUser;
    }

    public char[] getPassword() {
        return this.m_strPassword;
    }

    public void setPassword(char[] strPassword) {
        this.m_strPassword = DCEncryptServiceUtil.encrypt(strPassword);
    }

    public char[] getSuperPassword() {
        return this.m_strSuperPassword;
    }

    public void setSuperPassword(char[] strSuperPassword) {
        this.m_strSuperPassword = strSuperPassword;
    }

    public int getGatewayType() {
        return this.m_iGatewayType;
    }

    public void setSubSlotId(int subSlotId) {
        this.m_iSubSlotId = subSlotId;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.m_oProgressInfo = new ResourceProgressInfo();
        in.defaultReadObject();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource oResouceObj = (Resource)obj;
        return oResouceObj.m_iDeviceID == this.m_iDeviceID && oResouceObj.m_iFrameId == this.m_iFrameId && oResouceObj.m_iSlotId == this.m_iSlotId && oResouceObj.m_iStackId == this.m_iStackId;
    }

    public int hashCode() {
        String strVal = "" + this.m_iDeviceID + this.m_iFrameId + this.m_iSlotId + this.m_iStackId;
        return strVal.hashCode();
    }

    public int getBoardType() {
        return this.m_iBoardType;
    }

    public int getBoardResetType() {
        return this.m_iBoardResetType;
    }

    public void setBoardType(int iBoardType) {
        this.m_iBoardType = iBoardType;
    }

    public void setBoardResetType(int iBoardResetType) {
        this.m_iBoardResetType = iBoardResetType;
    }

    public String getBoardTypeName() {
        return this.m_strBoardTypeName;
    }

    public void setTL1ProtocolPhyID(String strPhysicalID) {
        this.m_strTL1ProtocolDevicePhyID = strPhysicalID;
    }

    public String getTL1ProtocolPhyID() {
        return this.m_strTL1ProtocolDevicePhyID;
    }

    public void setMMLProtocolPhysicalID(int iPhysicalID) {
        this.m_iMMLProtocolDevicePhyID = iPhysicalID;
    }

    public int getMMLProtocolPhysicalID() {
        return this.m_iMMLProtocolDevicePhyID;
    }

    public void setBoardTypeName(String strBoardTypeName) {
        this.m_strBoardTypeName = strBoardTypeName.equals("-1") ? "" : strBoardTypeName;
    }

    public void addOprResultInfo(String strOprId, ResourceProgressInfo resultInfo) {
        this.m_oOprResultInfoMap.put(strOprId, resultInfo);
    }

    public ResourceProgressInfo getOprResultInfo(String strOprId) {
        return this.m_oOprResultInfoMap.get(strOprId);
    }

    public Map<String, ResourceProgressInfo> getOprResultInfoMap() {
        return this.m_oOprResultInfoMap;
    }

    public List<ResourceProgressInfo> getOperationResultList() {
        return this.m_oOperationList;
    }

    public void setOperationResultList(List<ResourceProgressInfo> oOpProgressList) {
        if (null != oOpProgressList) {
            this.m_oOperationList = oOpProgressList;
        }
    }

    public ResourceProgressInfo getResultForOperation(String strOperationId) {
        DCDebugTracer.trace("[Device Step] getResultForOperation start");
        if (null == strOperationId) {
            DCDebugTracer.trace("[Device Step] getResultForOperation end.. strOperationId is null ");
            return null;
        }
        int iOperationCount = this.m_oOperationList.size();
        ResourceProgressInfo oProgress = null;
        for (int i = 0; i < iOperationCount; ++i) {
            oProgress = this.m_oOperationList.get(i);
            if (null == oProgress || !strOperationId.equalsIgnoreCase(oProgress.getCurrentOperationId())) continue;
            return oProgress;
        }
        DCDebugTracer.trace("[Device Step] getResultForOperation end..");
        return null;
    }

    public void addOperationResult(ResourceProgressInfo oProgressInfo) {
        if (null == oProgressInfo) {
            return;
        }
        ResourceProgressInfo oProgress = this.getResultForOperation(oProgressInfo.getCurrentOperationId());
        if (null == oProgress) {
            this.m_oOperationList.add(oProgressInfo);
        } else {
            oProgress.copy(oProgressInfo);
        }
    }

    public void clearOperationResults() {
        this.m_oOperationList.clear();
    }

    public void clearOperResultsMap() {
        this.m_oOprResultInfoMap.clear();
    }

    public int getUpgradeMode() {
        return this.m_iUpgradeMode;
    }

    public void setUpgradeMode(int upgradeMode) {
        this.m_iUpgradeMode = upgradeMode;
    }

    public int getUpgradeModeConfig() {
        return this.m_iUpgradeModeConfig;
    }

    public void setUpgradeModeConfig(int upgradeModeConfig) {
        this.m_iUpgradeModeConfig = upgradeModeConfig;
    }

    public void addSubOprListInfo(int iOprId, ITaskSubOperation oCheckItemDetails) {
        this.m_oSubOprListMap.remove(iOprId);
        this.m_oSubOprListMap.put(iOprId, oCheckItemDetails);
    }

    public ITaskSubOperation getSubOprInfo(int iOperationId) {
        return this.m_oSubOprListMap.get(iOperationId);
    }

    public boolean isSubOprInfoEmpty() {
        return this.m_oSubOprListMap.size() == 0;
    }

    public TaskDeviceLogInfo getLogInfoObject() {
        if (null == this.m_oDeviceLogInfo) {
            this.m_oDeviceLogInfo = new TaskDeviceLogInfo();
        }
        return this.m_oDeviceLogInfo;
    }

    public void setLogInfo(TaskDeviceLogInfo logInfo) {
        this.m_oDeviceLogInfo = logInfo;
    }

    public boolean isUpgradeFail() {
        return this.iUpgradeResult == 1;
    }

    public boolean isExtendCheckFail() {
        return this.extendCheckFail;
    }

    public void setExtendCheckFail(boolean extendCheckResult) {
        this.extendCheckFail = extendCheckResult;
    }

    public int getUpgradeResult() {
        return this.iUpgradeResult;
    }

    public void setUpgradeResult(int iUpgradeResult) {
        this.iUpgradeResult = iUpgradeResult;
    }

    public void setDevTypeId(int devTypeID) {
        this.iDevTypeId = devTypeID;
    }

    public int getDevTypeId() {
        return this.iDevTypeId;
    }

    public String toString() {
        return this.m_strDeviceName;
    }

    public String getOriginalVersion() {
        return this.m_strOriginalVersion;
    }

    public void setOriginalVersion(String originalVersion) {
        this.m_strOriginalVersion = originalVersion;
    }

    public String getUpgradeVersion() {
        return this.m_strUpgradeVersion;
    }

    public void setUpgradeVersion(String upgradeVersion) {
        this.m_strUpgradeVersion = upgradeVersion;
    }

    public int getStackId() {
        return this.m_iStackId;
    }

    public void setStackId(int iStackId) {
        this.m_iStackId = iStackId;
    }

    public DeviceTypeInfo getStackDevTypeInfo() {
        return this.m_oStackDevTypeInfo;
    }

    public void setStackDevTypeInfo(DeviceTypeInfo oDevTypeInfo) {
        this.m_oStackDevTypeInfo = oDevTypeInfo;
    }

    public SnmpParaInfo getSnmpParaInfo() {
        return this.m_oSnmpParaInfo;
    }

    public void setSnmpParaInfo(SnmpParaInfo m_oSnmpParaInfo) {
        this.m_oSnmpParaInfo = m_oSnmpParaInfo;
    }

    public int getDevVersionID() {
        return this.m_iDevVersionID;
    }

    public void setDevVersionID(int m_iDevVersionID) {
        this.m_iDevVersionID = m_iDevVersionID;
    }

    public void setVPNName(String strVPNName) {
        this.m_strVPNName = strVPNName;
    }

    public String getVPNName() {
        return this.m_strVPNName;
    }

    public void setProxyType(int iProxyType) {
        this.m_iProxyType = iProxyType;
    }

    public int getProxyType() {
        return this.m_iProxyType;
    }

    public void setProxyNodeType(int iProxyNodeType) {
        this.m_iProxyNodeType = iProxyNodeType;
    }

    public int getProxyNodeType() {
        return this.m_iProxyNodeType;
    }

    public void setAgentID(String strAgentID) {
        this.m_strAgentID = strAgentID;
    }

    public String getAgentID() {
        return this.m_strAgentID;
    }

    public int getSWDLStatus() {
        return this.m_iSWDLStatus;
    }

    public void setSWDLStatus(int status) {
        this.m_iSWDLStatus = status;
    }

    public int getIsIsolationBoard() {
        return this.m_iIsolationBoard;
    }

    public void setIsIsolationBoard(int isolationBoard) {
        this.m_iIsolationBoard = isolationBoard;
    }

    public boolean isFailed() {
        if (null == this.m_oProgressInfo) {
            return false;
        }
        int iResourceOpState = this.m_oProgressInfo.getState();
        int iResourceOpResult = this.m_oProgressInfo.getResult();
        return iResourceOpState == 2 && iResourceOpResult == 1;
    }

    public boolean isSuccess() {
        if (null == this.m_oProgressInfo) {
            return false;
        }
        int iResourceOpState = this.m_oProgressInfo.getState();
        int iResourceOpResult = this.m_oProgressInfo.getResult();
        return iResourceOpState == 3 && iResourceOpResult == 0;
    }

    public boolean isPaused() {
        if (null == this.m_oProgressInfo) {
            return false;
        }
        int iResourceOpState = this.m_oProgressInfo.getState();
        int iResourceOpResult = this.m_oProgressInfo.getResult();
        return iResourceOpState == 4 && iResourceOpResult == 2;
    }

    public boolean isBoard() {
        return this.m_iFrameId != -1 || this.m_iSlotId != -1 || (3 != this.m_iRoleType || -1 != this.m_iStackId) && 3 == this.m_iRoleType;
    }

    public void setMainBoardNum(int iMainBoardNum) {
        this.m_iMainBoardNum = iMainBoardNum;
        this.m_strMainBoardNum = TaskCommUtil.getMainBoardNum(iMainBoardNum);
    }

    public String getStrMainBoardNum() {
        return this.m_strMainBoardNum;
    }

    public int getIMainBoardNum() {
        return this.m_iMainBoardNum;
    }
}

