/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.isolation.view;

import com.huawei.dc.common.components.treetable.ISortTreeTableListener;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.view.SortTreeTablePanel;
import com.huawei.dc.devicemanagement.deviceoperation.IOperation;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.taskmgmt.isolation.IUpdateIsolationOperationDetailsInfo;
import com.huawei.dc.taskmgmt.isolation.IsolationCommonOperation;
import com.huawei.dc.taskmgmt.isolation.model.IsolationTaskInfoObj;
import com.huawei.dc.taskmgmt.isolation.model.IsolationTaskInfoTableModel;
import com.huawei.dc.taskmgmt.isolation.model.IsolationTaskOprDetailInfoObj;
import com.huawei.dc.taskmgmt.isolation.model.IsolationTaskOprDetailTableInfo;
import com.huawei.dc.taskmgmt.isolation.view.IsolationTreeNodeRender;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import com.huawei.dc.taskmgmt.model.TaskDataModel;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.tree.TreeNode;

public class IsolationTaskOperationDetailsPanel
extends JPanel
implements ISortTreeTableListener,
IUpdateIsolationOperationDetailsInfo {
    private static final long serialVersionUID = 5991319741473178557L;
    private SortTreeTablePanel m_oSortTreeTablePanel;
    private TreeTableNode m_rootNode;
    private String m_strCurrSelectedOprId = "";

    public IsolationTaskOperationDetailsPanel() {
        this.setLayout(new BorderLayout());
        this.jInit();
    }

    private void jInit() {
        IsolationTaskOprDetailTableInfo oprTableInfo = new IsolationTaskOprDetailTableInfo();
        IsolationTaskInfoTableModel taskTableModel = new IsolationTaskInfoTableModel(oprTableInfo);
        this.m_oSortTreeTablePanel = new SortTreeTablePanel(taskTableModel);
        this.m_oSortTreeTablePanel.setName("com.huawei.dc.taskmgmt.isolation.view.IsolationTaskOperationDetailsPanel.m_oSortTreeTablePanel");
        this.m_oSortTreeTablePanel.getBottomPanel().setVisible(false);
        this.m_oSortTreeTablePanel.registListener(this);
        this.m_oSortTreeTablePanel.getTreeTable().getTree().setCellRenderer(new IsolationTreeNodeRender());
        this.m_rootNode = this.m_oSortTreeTablePanel.getRoot();
        this.add((Component)this.m_oSortTreeTablePanel, "Center");
    }

    @Override
    public void handleMouseClickEvent(MouseEvent mouseEvent) {
    }

    @Override
    public void updateSelectionState() {
    }

    @Override
    public void updateOprDetailsInfo(String strOprId, IsolationTaskInfoObj taskInfoObj, boolean isRefresh) {
        if (!isRefresh) {
            this.m_strCurrSelectedOprId = strOprId;
            this.m_oSortTreeTablePanel.setVisible(false);
        }
        if (null == taskInfoObj) {
            return;
        }
        if (!isRefresh) {
            this.m_oSortTreeTablePanel.setVisible(true);
            this.createOperationNode(strOprId, taskInfoObj);
        } else if (this.m_strCurrSelectedOprId.equals(strOprId)) {
            this.refreshOprDetailsInfo(strOprId, taskInfoObj);
        }
    }

    private void refreshOprDetailsInfo(String strOprId, IsolationTaskInfoObj taskInfoObj) {
        ITask oTask = TaskDataModel.getInstance().getTask(taskInfoObj.getTaskId());
        TreeTableNode oOperationNode = this.getNode(this.getOperationNameBasedOnOprID(oTask, strOprId));
        this.handleDevNode(oTask, oOperationNode, strOprId, false);
        this.m_oSortTreeTablePanel.updateTreeTable();
    }

    private void createOperationNode(String strOprId, IsolationTaskInfoObj taskInfoObj) {
        this.m_rootNode.removeAllChildren();
        ITask oTask = TaskDataModel.getInstance().getTask(taskInfoObj.getTaskId());
        IsolationTaskOprDetailInfoObj oTaskOprDetailsInfo = new IsolationTaskOprDetailInfoObj();
        oTaskOprDetailsInfo.setName(this.getOperationNameBasedOnOprID(oTask, strOprId));
        TreeTableNode oOperationNode = new TreeTableNode(oTaskOprDetailsInfo);
        this.handleDevNode(oTask, oOperationNode, strOprId, true);
        this.m_rootNode.add(oOperationNode);
        this.m_oSortTreeTablePanel.expandTree(this.m_rootNode);
        this.m_oSortTreeTablePanel.updateTreeTable();
    }

    private void handleDevNode(ITask oTask, TreeTableNode oOprNode, String strOprId, boolean isCreate) {
        THashSet<Resource> oResLst = oTask.getDeviceType().getResources();
        Calendar oOprStartTime = null;
        Calendar oOprEndTime = null;
        Resource tmpRes2 = null;
        ResourceProgressInfo oTmpResProgressInfo = null;
        for (Resource tmpRes2 : oResLst) {
            IsolationTaskOprDetailInfoObj oDevInfo = null;
            if (isCreate) {
                oDevInfo = new IsolationTaskOprDetailInfoObj();
                oDevInfo.setDevId(tmpRes2.getDeviceID());
                oDevInfo.setNodeType(2);
                oDevInfo.setName(tmpRes2.getDeviceName());
                oDevInfo.setAddress(tmpRes2.getDeviceIP());
                oDevInfo.setNEType(tmpRes2.getDeviceType());
            } else {
                oDevInfo = this.getNodeInfo(oOprNode, tmpRes2.getDeviceName());
            }
            oTmpResProgressInfo = tmpRes2.getOprResultInfo(strOprId);
            if (null != oTmpResProgressInfo) {
                oDevInfo.setOprStartTime(oTmpResProgressInfo.getStartTime());
                if (null == oOprStartTime) {
                    oOprStartTime = oTmpResProgressInfo.getStartTime();
                } else if (null != oTmpResProgressInfo.getStartTime() && 0 < oOprStartTime.getTime().compareTo(oTmpResProgressInfo.getStartTime().getTime())) {
                    oOprStartTime = oTmpResProgressInfo.getStartTime();
                }
                oDevInfo.setOprEndTime(oTmpResProgressInfo.getEndTime());
                if (null == oOprEndTime) {
                    oOprEndTime = oTmpResProgressInfo.getEndTime();
                } else if (null != oTmpResProgressInfo.getEndTime() && 0 > oOprEndTime.getTime().compareTo(oTmpResProgressInfo.getEndTime().getTime())) {
                    oOprEndTime = oTmpResProgressInfo.getEndTime();
                }
                if (0 != oTmpResProgressInfo.getState()) {
                    oDevInfo.setResult(IsolationCommonOperation.getResult(oTmpResProgressInfo.getResult(), oTmpResProgressInfo.getCurrentOperationId()));
                    oDevInfo.setDetails(oTmpResProgressInfo.getErrorInfo());
                }
            }
            if (!isCreate) continue;
            TreeTableNode oDevNode = new TreeTableNode(oDevInfo);
            oOprNode.add(oDevNode);
        }
        IsolationTaskOprDetailInfoObj oTaskOprDetailsInfo = (IsolationTaskOprDetailInfoObj)oOprNode.getUserObject();
        oTaskOprDetailsInfo.setOprStartTime(oOprStartTime);
        oTaskOprDetailsInfo.setOprEndTime(oOprEndTime);
    }

    private TreeTableNode getNode(String strName) {
        Enumeration<TreeNode> nodeEnum = this.m_rootNode.breadthFirstEnumeration();
        while (nodeEnum.hasMoreElements()) {
            TreeTableNode tmpNode = (TreeTableNode)nodeEnum.nextElement();
            IsolationTaskOprDetailInfoObj nodeInfoObj = (IsolationTaskOprDetailInfoObj)tmpNode.getUserObject();
            if (null == nodeInfoObj || !nodeInfoObj.getName().equals(strName)) continue;
            return tmpNode;
        }
        return null;
    }

    private IsolationTaskOprDetailInfoObj getNodeInfo(TreeTableNode oOprNode, String strName) {
        Enumeration<TreeNode> nodeEnum = oOprNode.breadthFirstEnumeration();
        while (nodeEnum.hasMoreElements()) {
            TreeTableNode tmpNode = (TreeTableNode)nodeEnum.nextElement();
            IsolationTaskOprDetailInfoObj nodeInfoObj = (IsolationTaskOprDetailInfoObj)tmpNode.getUserObject();
            if (null == nodeInfoObj || !nodeInfoObj.getName().equals(strName)) continue;
            return nodeInfoObj;
        }
        return null;
    }

    private String getOperationNameBasedOnOprID(ITask oTask, String strOprId) {
        String strOperationName = "";
        List<ITaskDeviceOperation> oOprList = oTask.getSupportedOperation();
        int iLen = oOprList.size();
        IOperation oObj = null;
        for (int i = 0; i < iLen; ++i) {
            oObj = oOprList.get(i);
            if (!strOprId.equals(oObj.getOperationIdString())) continue;
            strOperationName = oObj.getOperationName();
            break;
        }
        return strOperationName;
    }
}

