/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.isolation.view;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnBoardIsoStatus;
import com.huawei.dc.common.asndatacenter.AsnBoardIsoStatusLst;
import com.huawei.dc.common.asndatacenter.AsnDCDeleteIsolationDevNotify;
import com.huawei.dc.common.asndatacenter.AsnDCSWDLStatusNotify;
import com.huawei.dc.common.asndatacenter.AsnFreeIsolationBoardNotify;
import com.huawei.dc.common.asndatacenter.AsnUpdateIsolationBoardStatus;
import com.huawei.dc.common.components.dialog.CommonProgressDlg;
import com.huawei.dc.common.components.treetable.ISortTreeTableListener;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.view.JSortTreeTable;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.interfaces.DCTreeEventListener;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpForErrCodeUtil;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.common.util.TaskInfoUtil;
import com.huawei.dc.common.util.TaskInfoUtil2;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.TaskManagementMainPanel;
import com.huawei.dc.taskmgmt.controller.ITaskNotificationListener;
import com.huawei.dc.taskmgmt.controller.TaskAsynCommController;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import com.huawei.dc.taskmgmt.controller.TaskEvent;
import com.huawei.dc.taskmgmt.controller.TaskEventID;
import com.huawei.dc.taskmgmt.controller.TaskSyncCommController;
import com.huawei.dc.taskmgmt.isolation.IsolationCommonOperation;
import com.huawei.dc.taskmgmt.isolation.controller.IsolationTaskAsynCommController;
import com.huawei.dc.taskmgmt.isolation.controller.IsolationTaskSyncCommController;
import com.huawei.dc.taskmgmt.isolation.model.IsolationTaskInfoObj;
import com.huawei.dc.taskmgmt.isolation.view.AbstractIsolationTaskInfoPanel;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.ITaskGroup;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import com.huawei.dc.taskmgmt.model.TaskDataModel;
import com.huawei.dc.taskmgmt.report.tasklevel.view.TaskReportDlg;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class IsolationTaskInfoPanel
extends AbstractIsolationTaskInfoPanel
implements ISortTreeTableListener,
ITaskNotificationListener {
    private static final long serialVersionUID = -748089307323088186L;
    private List<DCTreeEventListener> m_oTreeTableSelectionListenerLst;
    private List<IsolationTaskInfoObj> m_oCurrSelectedTaskInfoObj = null;
    private int m_iPreTaskId = -1;
    private int m_iPreDevId = -1;
    private int m_iPreSlotId = -1;
    CommonProgressDlg m_oCommProgressDlg;
    List<Integer> m_oResIdLst;

    public IsolationTaskInfoPanel() {
        this.setLayout(new BorderLayout());
        this.m_oTreeTableSelectionListenerLst = new ArrayList<DCTreeEventListener>();
        IsolationTaskAsynCommController.getInstance();
        this.m_oResIdLst = new ArrayList<Integer>();
        this.jInit();
        this.initPopupMenu();
    }

    @Override
    protected void jInit() {
        super.jInit();
        this.m_oSortTreeTablePanel.registListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshState() {
        List<IsolationTaskInfoObj> oIsolationTaskInfoLst = this.getSelectedNodeInfos();
        int iCount = oIsolationTaskInfoLst.size();
        if (0 >= iCount) {
            return;
        }
        int taskID = -1;
        this.m_oResIdLst.clear();
        for (int i = 0; i < iCount; ++i) {
            IsolationTaskInfoObj nodeInfo = oIsolationTaskInfoLst.get(i);
            taskID = nodeInfo.getTaskId();
            this.m_oResIdLst.add(nodeInfo.getDevId());
        }
        Object object = DCFrameWorkUtil.getTaskTablePanel().getSynObject();
        synchronized (object) {
            int iReqId = DCFrameWorkUtil.generateRequestId();
            String strTitle = ResourceManager.getInstance().getResString("REFRESH_SWDL_DLG_PROGRESS_TITLE");
            String[] columnNames = new String[]{ResourceManager.getInstance().getResString("DEVICE_NAME"), ResourceManager.getInstance().getResString("TBL_COLUMN_NAME_STATUS")};
            this.initProgressDlg(iReqId, 43981, strTitle, columnNames, null);
            try {
                TaskAsynCommController.getInstance().refreshSWDLStatus(iReqId, taskID, this.m_oResIdLst);
                this.showProgressDlg(43981);
            }
            catch (DCException e) {
                this.m_oCommProgressDlg.dispose();
                DCOptionPane.showMessageDialog(null, e.getMessage(), ResourceManager.getInstance().getResString("ERROR"), 0);
                return;
            }
        }
    }

    public void handleSWDLStatusResponse(AsnDCSWDLStatusNotify asnDCSWDLStatusNotify) {
        if (null == asnDCSWDLStatusNotify || null == this.m_oCommProgressDlg || this.m_oCommProgressDlg.getProgressDlgId() != asnDCSWDLStatusNotify.oReqID.intValue()) {
            if (null == asnDCSWDLStatusNotify) {
                DCDebugTracer.trace("handleSWDLStatusResponse = null");
            } else {
                DCDebugTracer.trace("handleSWDLStatusResponse.iReqID = " + asnDCSWDLStatusNotify.oReqID.intValue());
            }
            if (null != this.m_oCommProgressDlg) {
                DCDebugTracer.trace("ProgressDlgId :" + this.m_oCommProgressDlg.getProgressDlgId());
            }
            return;
        }
        int iTaskID = asnDCSWDLStatusNotify.iTaskID.intValue();
        int iDevID = asnDCSWDLStatusNotify.iDevID.intValue();
        String strResult = "";
        int iErrorcode = asnDCSWDLStatusNotify.oErrorInfo.iErrorNo.intValue();
        strResult = ErrorCodeReader.getInstance().getErrorDesc(asnDCSWDLStatusNotify.oErrorInfo.iErrorNo);
        final IsolationTaskInfoObj nodeInfo = this.getNodeInfo(iTaskID, iDevID);
        if (0 == iErrorcode) {
            strResult = TaskCommUtil.getSWDLStatusRes(asnDCSWDLStatusNotify.oSWDLStatus.value);
            nodeInfo.setLoadingState(strResult);
            this.m_oSortTreeTablePanel.updateTreeTable();
        }
        final String sResult = strResult;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IsolationTaskInfoPanel.this.refreshProgressDlg(nodeInfo, sResult);
            }
        });
    }

    private void refreshProgressDlg(IsolationTaskInfoObj nodeInfo, String strResult) {
        if (null == nodeInfo || null == this.m_oCommProgressDlg) {
            DCDebugTracer.trace("devInfo :null!");
            return;
        }
        String devName = nodeInfo.getResName();
        String devIP = nodeInfo.getResAddress();
        String sDisplayName = devName + "(" + devIP + ")";
        this.m_oCommProgressDlg.setProgress(nodeInfo.getDevId(), sDisplayName, strResult);
    }

    @Override
    public void continueOperation() {
        int iConfirmOutput;
        List<IsolationTaskInfoObj> oIsolationTaskInfoLst = this.getSelectedNodeInfos();
        int iCount = oIsolationTaskInfoLst.size();
        if (0 >= iCount) {
            return;
        }
        String strMsg = ResourceManager.getInstance().getResString("ISOLATION_DEVICE_CONTINUE_CONFIRM_MSG");
        if (TaskInfoUtil.isCommitForNextOperation(oIsolationTaskInfoLst)) {
            strMsg = ResourceManager.getInstance().getResString("ISOLATION_DEVICE_CONTINUE_CONFIRM_FOR_COMMIT_MSG");
        }
        if (0 != (iConfirmOutput = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), strMsg, ResourceManager.getInstance().getResString("CONFIRM"), 0))) {
            return;
        }
        ArrayList<Integer> devIdLst = new ArrayList<Integer>();
        int iTaskID = -1;
        for (int i = 0; i < iCount; ++i) {
            IsolationTaskInfoObj nodeInfo = oIsolationTaskInfoLst.get(i);
            iTaskID = nodeInfo.getTaskId();
            devIdLst.add(nodeInfo.getDevId());
        }
        try {
            IsolationTaskSyncCommController.getInstance().continueForIsolation(iTaskID, devIdLst);
        }
        catch (DCException e) {
            DCOptionPane.showMessageDialog(null, e.getMessage(), ResourceManager.getInstance().getResString("ERROR"), 0);
            DCDebugTracer.trace("isolation continue task exception");
            DCDebugTracer.trace(e);
        }
    }

    @Override
    public void retry() {
        int iConfirmOutput;
        List<IsolationTaskInfoObj> oIsolationTaskInfoLst = this.getSelectedNodeInfos();
        int iCount = oIsolationTaskInfoLst.size();
        if (0 >= iCount) {
            return;
        }
        String strMsg = ResourceManager.getInstance().getResString("RETRY_CONFIRM_DANGER_MSG");
        if (TaskInfoUtil2.isRollbackForCurOperation(oIsolationTaskInfoLst)) {
            strMsg = null;
        }
        if (null != strMsg && 0 != (iConfirmOutput = DCOptionPane.showExtConfirmDialog(DCFrameWorkUtil.getMainFrame(), strMsg, ResourceManager.getInstance().getResString("WARNING"), 0, 2))) {
            return;
        }
        int iTaskId = -1;
        HashMap<Integer, List<Integer>> oDevIdMap = new HashMap<Integer, List<Integer>>();
        for (int i = 0; i < iCount; ++i) {
            int iSlotId;
            IsolationTaskInfoObj nodeInfo = oIsolationTaskInfoLst.get(i);
            iTaskId = nodeInfo.getTaskId();
            Integer iDevId = nodeInfo.getDevId();
            if (!oDevIdMap.containsKey(iDevId)) {
                oDevIdMap.put(iDevId, null);
            }
            if (0 >= (iSlotId = nodeInfo.getSlotId())) continue;
            if (null == oDevIdMap.get(iDevId)) {
                oDevIdMap.put(iDevId, new ArrayList());
            }
            oDevIdMap.get(iDevId).add(iSlotId);
        }
        try {
            IsolationTaskSyncCommController.getInstance().retryForIsolation(iTaskId, oDevIdMap);
        }
        catch (DCException e) {
            DCOptionPane.showMessageDialog(null, e.getMessage(), ResourceManager.getInstance().getResString("ERROR"), 0);
        }
    }

    @Override
    public void rollback() {
        int iConfirmOutput;
        List<IsolationTaskInfoObj> oIsolationTaskInfoLst = this.getSelectedNodeInfos();
        int iCount = oIsolationTaskInfoLst.size();
        if (0 >= iCount) {
            return;
        }
        String strMsg = ResourceManager.getInstance().getResString("ROLLBACK_CONFIRM_MSG");
        if (TaskInfoUtil.isActivateForRollbackOperation(oIsolationTaskInfoLst)) {
            strMsg = ResourceManager.getInstance().getResString("ROLLBACK_CONFIRM_DANGER_MSG");
        }
        if (null != strMsg && 0 != (iConfirmOutput = DCOptionPane.showExtConfirmDialog(DCFrameWorkUtil.getMainFrame(), strMsg, ResourceManager.getInstance().getResString("WARNING"), 0, 2))) {
            return;
        }
        int iTaskId = -1;
        HashMap<Integer, List<Integer>> oDevIdMap = new HashMap<Integer, List<Integer>>();
        for (int i = 0; i < iCount; ++i) {
            int iSlotId;
            IsolationTaskInfoObj nodeInfo = oIsolationTaskInfoLst.get(i);
            iTaskId = nodeInfo.getTaskId();
            Integer iDevId = nodeInfo.getDevId();
            if (!oDevIdMap.containsKey(iDevId)) {
                oDevIdMap.put(iDevId, null);
            }
            if (0 >= (iSlotId = nodeInfo.getSlotId())) continue;
            if (null == oDevIdMap.get(iDevId)) {
                oDevIdMap.put(iDevId, new ArrayList());
            }
            oDevIdMap.get(iDevId).add(iSlotId);
        }
        try {
            IsolationTaskSyncCommController.getInstance().rollbackForIsolation(iTaskId, oDevIdMap);
        }
        catch (DCException e) {
            DCOptionPane.showMessageDialog(null, e.getMessage(), ResourceManager.getInstance().getResString("ERROR"), 0);
        }
    }

    @Override
    public void export() {
        int iTaskCount = this.m_rootNode.getChildCount();
        ITask[] oTasks = new ITask[iTaskCount];
        for (int i = 0; i < iTaskCount; ++i) {
            TreeTableNode oTaskNode = (TreeTableNode)this.m_rootNode.getChildAt(i);
            IsolationTaskInfoObj oTaskInfo = (IsolationTaskInfoObj)oTaskNode.getUserObject();
            oTasks[i] = TaskDataModel.getInstance().getTask(oTaskInfo.getTaskId());
        }
        try {
            TaskReportDlg oDialog = new TaskReportDlg(oTasks, ResourceManager.getInstance().getResString("ISOLATION_EXPORT_DLG_TITLE"));
            oDialog.setVisible(true);
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
            DCDebugTracer.traceError(this.getClass().getName() + " [task report] " + e.getMessage());
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode(), ResourceManager.getInstance().getResString("ERROR"), 0);
        }
    }

    @Override
    public void delete() {
        int iConfirmOutput;
        String strMsg = ResourceManager.getInstance().getResString("TASK_DELETE_CONFIRM_MSG");
        String strTitle = ResourceManager.getInstance().getResString("TASK_DELETE");
        List<IsolationTaskInfoObj> oIsolationTaskInfoLst = this.getSelectedNodeInfos();
        int iCount = oIsolationTaskInfoLst.size();
        if (0 >= iCount) {
            return;
        }
        int iTaskId = -1;
        boolean isDeleteTask = true;
        IsolationTaskInfoObj nodeInfo = oIsolationTaskInfoLst.get(0);
        if (2 == nodeInfo.getNodeType()) {
            iTaskId = nodeInfo.getTaskId();
            isDeleteTask = false;
            strMsg = ResourceManager.getInstance().getResString("ISOLATION_DEVICE_DELETE_CONFIRM_MSG");
            strTitle = ResourceManager.getInstance().getResString("ISOLATION_DEVICE_DELETE_CONFIRM_TITLE");
        }
        if (0 != (iConfirmOutput = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), strMsg, strTitle, 0))) {
            return;
        }
        this.m_oResIdLst.clear();
        for (int i = 0; i < iCount; ++i) {
            nodeInfo = oIsolationTaskInfoLst.get(i);
            if (isDeleteTask) {
                if (1 != nodeInfo.getNodeType()) continue;
                this.m_oResIdLst.add(nodeInfo.getTaskId());
                continue;
            }
            this.m_oResIdLst.add(nodeInfo.getDevId());
        }
        if (isDeleteTask) {
            this.deleteTask(this.m_oResIdLst);
        } else {
            int iReqId = DCFrameWorkUtil.generateRequestId();
            String strTitleForProgressDlg = ResourceManager.getInstance().getResString("ISOLATION_DEVICE_DELETE_TITLE");
            this.initProgressDlg(iReqId, 44056, strTitleForProgressDlg);
            try {
                IsolationTaskSyncCommController.getInstance().deleteIsolationDevice(iReqId, iTaskId, this.m_oResIdLst);
                this.showProgressDlg(44056);
            }
            catch (DCException e) {
                this.m_oCommProgressDlg.dispose();
                DCOptionPane.showMessageDialog(null, e.getMessage(), ResourceManager.getInstance().getResString("ERROR"), 0);
            }
        }
    }

    public void handleDeleteIsolationDevResponse(AsnDCDeleteIsolationDevNotify oAsnDeleteIsolationDevNotify) {
        if (null == oAsnDeleteIsolationDevNotify || null == this.m_oCommProgressDlg || this.m_oCommProgressDlg.getProgressDlgId() != oAsnDeleteIsolationDevNotify.oReqID.intValue()) {
            if (null != oAsnDeleteIsolationDevNotify) {
                DCDebugTracer.trace("handleDeleteIsolationDevResponse.iReqID = " + oAsnDeleteIsolationDevNotify.oReqID.intValue());
            }
            if (null != this.m_oCommProgressDlg) {
                DCDebugTracer.trace("ProgressDlgId :" + this.m_oCommProgressDlg.getProgressDlgId());
            }
            return;
        }
        int iTaskID = oAsnDeleteIsolationDevNotify.iTaskID.intValue();
        int iDevID = oAsnDeleteIsolationDevNotify.iDevID.intValue();
        String strResult = "";
        int iErrorcode = oAsnDeleteIsolationDevNotify.oErrorInfo.iErrorNo.intValue();
        strResult = ErrorCodeReader.getInstance().getErrorDesc(oAsnDeleteIsolationDevNotify.oErrorInfo.iErrorNo);
        TreeTableNode oDevNode = this.getNode(iTaskID, iDevID);
        IsolationTaskInfoObj nodeInfoObj = null;
        if (null != oDevNode) {
            nodeInfoObj = (IsolationTaskInfoObj)oDevNode.getUserObject();
        }
        if (0 == iErrorcode && null != oDevNode) {
            TreeTableNode oTaskNode = (TreeTableNode)oDevNode.getParent();
            oDevNode.removeFromParent();
            ITaskGroup isoTaskGroup = TaskDataModel.getInstance().getTaskGroup(256);
            if (null != isoTaskGroup) {
                Resource res = DeviceInfoManagerImpl.getInstance().getResourceForID(iDevID);
                ArrayList<Resource> devLst = new ArrayList<Resource>(4);
                if (null != res) {
                    devLst.add(res);
                    isoTaskGroup.deleteResource(iTaskID, devLst);
                }
            }
            if (0 >= oTaskNode.getChildCount()) {
                oTaskNode.removeFromParent();
                TaskDataModel.getInstance().removeTask(iTaskID);
            }
            this.m_oSortTreeTablePanel.getTreeTable().updateUI();
            this.m_oSortTreeTablePanel.getTreeTable().getSelectionModel().setSelectionInterval(0, 0);
        }
        this.refreshProgressDlg(nodeInfoObj, strResult);
        this.updateSelectionState();
    }

    private void deleteTask(List<Integer> oTaskIdLst) {
        int iTaskCount = oTaskIdLst.size();
        int[] iTaskIds = new int[iTaskCount];
        for (int i = 0; i < iTaskCount; ++i) {
            iTaskIds[i] = oTaskIdLst.get(i);
        }
        try {
            TaskSyncCommController.getInstance().deleteTasks(iTaskIds);
        }
        catch (DCException e) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode(), ResourceManager.getInstance().getResString("ERROR"), 0);
            DCDebugTracer.trace(e);
            return;
        }
    }

    public void delTaskNodeInDelTaskNotify(List<Integer> oTaskIdLst) {
        int iDeleteTaskCount = oTaskIdLst.size();
        for (int i = 0; i < iDeleteTaskCount; ++i) {
            int iTaskId = oTaskIdLst.get(i);
            TreeTableNode oTaskNode = this.getNode(iTaskId, -1);
            if (null == oTaskNode) continue;
            oTaskNode.removeFromParent();
        }
    }

    public boolean closeIsolationPanelByNotify() {
        boolean bIsNoneTaskNode = false;
        if (null == this.m_oSortTreeTablePanel.getRoot() || this.m_oSortTreeTablePanel.getRoot().getChildCount() == 0) {
            bIsNoneTaskNode = true;
            this.closeIsolationPanel();
        }
        return bIsNoneTaskNode;
    }

    @Override
    public void freeIsolationBoard() {
        List<IsolationTaskInfoObj> oIsolationTaskInfoLst = this.getSelectedNodeInfos();
        int iCount = oIsolationTaskInfoLst.size();
        if (0 >= iCount) {
            return;
        }
        int iTaskID = -1;
        int iDevID = -1;
        this.m_oResIdLst.clear();
        HashMap<Integer, String> oBoardInfoMap = new HashMap<Integer, String>();
        for (int i = 0; i < iCount; ++i) {
            IsolationTaskInfoObj nodeInfo = oIsolationTaskInfoLst.get(i);
            iTaskID = nodeInfo.getTaskId();
            iDevID = nodeInfo.getDevId();
            this.m_oResIdLst.add(nodeInfo.getSlotId());
            oBoardInfoMap.put(nodeInfo.getSlotId(), nodeInfo.toString());
        }
        int iReqId = DCFrameWorkUtil.generateRequestId();
        String strTitleForProgressDlg = ResourceManager.getInstance().getResString("FREE_ISOLATION_DLG_PROGRESS_TITLE");
        this.initProgressDlg(iReqId, 44053, strTitleForProgressDlg, oBoardInfoMap);
        try {
            IsolationTaskSyncCommController.getInstance().freeIsolationBoards(iReqId, iTaskID, iDevID, this.m_oResIdLst);
            this.showProgressDlg(44053);
        }
        catch (DCException e) {
            this.m_oCommProgressDlg.dispose();
            DCOptionPane.showMessageDialog(null, e.getMessage(), ResourceManager.getInstance().getResString("ERROR"), 0);
        }
    }

    public void handleFreeIsolationResponse(AsnFreeIsolationBoardNotify oAsnFreeIsolationBoardNotify) {
        if (null == oAsnFreeIsolationBoardNotify || null == this.m_oCommProgressDlg || this.m_oCommProgressDlg.getProgressDlgId() != oAsnFreeIsolationBoardNotify.oReqID.intValue()) {
            if (null != oAsnFreeIsolationBoardNotify) {
                DCDebugTracer.trace("handleFreeIsolationResponse.iReqID = " + oAsnFreeIsolationBoardNotify.oReqID.intValue());
            }
            if (null != this.m_oCommProgressDlg) {
                DCDebugTracer.trace("ProgressDlgId :" + this.m_oCommProgressDlg.getProgressDlgId());
            }
            return;
        }
        int iTaskID = oAsnFreeIsolationBoardNotify.iTaskID.intValue();
        int iDevID = oAsnFreeIsolationBoardNotify.iDevID.intValue();
        int iBoardID = oAsnFreeIsolationBoardNotify.iBoardID.intValue();
        String strOperationResult = "";
        int iErrorcode = oAsnFreeIsolationBoardNotify.oErrorInfo.iErrorNo.intValue();
        DCDebugTracer.trace("DC::IsolationTaskInfoPanel.handleFreeIsolationResponse(iTaskID=" + iTaskID + ", iDevID=" + iDevID + ",iBoardID=" + iBoardID + ", iErrorcode=" + iErrorcode);
        strOperationResult = ErrorCodeReader.getInstance().getErrorDesc(oAsnFreeIsolationBoardNotify.oErrorInfo.iErrorNo);
        String strDisplayName = "";
        TreeTableNode oNode = this.getNode(iTaskID, iDevID, iBoardID);
        if (null != oNode) {
            IsolationTaskInfoObj nodeInfo = (IsolationTaskInfoObj)oNode.getUserObject();
            if (0 == iErrorcode) {
                nodeInfo.setIsolationBoard(false);
                this.m_oSortTreeTablePanel.updateTreeTable();
            }
            strDisplayName = nodeInfo.toString();
        }
        this.m_oCommProgressDlg.setProgress(iBoardID, strDisplayName, strOperationResult);
    }

    public void handleUpdateIsolationBoardStatusResponse(AsnUpdateIsolationBoardStatus oAsnUpdateIsolationBoardStatusNotify) {
        DCDebugTracer.trace("handleUpdateIsolationBoardStatusResponse start.");
        int iTaskID = oAsnUpdateIsolationBoardStatusNotify.iTaskID.intValue();
        int iDevID = oAsnUpdateIsolationBoardStatusNotify.iDevID.intValue();
        DCDebugTracer.trace("the taskid is " + iTaskID + ", the devid is " + iDevID);
        AsnBoardIsoStatusLst oAsnBoardStatusLst = oAsnUpdateIsolationBoardStatusNotify.oAsnBoardIsoStatusLst;
        int iSize = oAsnBoardStatusLst.size();
        for (int i = 0; i < iSize; ++i) {
            AsnBoardIsoStatus oAsnBoardStatus = (AsnBoardIsoStatus)oAsnBoardStatusLst.get(i);
            int iBoardID = oAsnBoardStatus.iBoard.intValue();
            int iStatus = oAsnBoardStatus.status.intValue();
            DCDebugTracer.trace("taskId = " + iTaskID + ", devId = " + iDevID + ", boardId = " + iBoardID + ", status = " + iStatus);
            TreeTableNode oNode = this.getNode(iTaskID, iDevID, iBoardID);
            if (null != oNode) {
                IsolationTaskInfoObj nodeInfo = (IsolationTaskInfoObj)oNode.getUserObject();
                if (0 < oAsnBoardStatus.status.intValue()) {
                    nodeInfo.setIsolationBoard(true);
                    continue;
                }
                nodeInfo.setIsolationBoard(false);
                continue;
            }
            DCDebugTracer.trace("can't find the node.");
        }
        this.m_oSortTreeTablePanel.updateTreeTable();
        DCDebugTracer.trace("handleUpdateIsolationBoardStatusResponse end.");
    }

    @Override
    public void handleMouseClickEvent(MouseEvent oMouseEvent) {
        if (0 != (4 & oMouseEvent.getModifiers())) {
            if (null != this.m_oPopupMenu) {
                this.handleMenuItemState();
                this.m_oPopupMenu.show(oMouseEvent.getComponent(), oMouseEvent.getX(), oMouseEvent.getY());
            }
        } else if (0 != (0x10 & oMouseEvent.getModifiers())) {
            JSortTreeTable oSortTreeTable = this.m_oSortTreeTablePanel.getTreeTable();
            int iSelectedRow = oSortTreeTable.rowAtPoint(oMouseEvent.getPoint());
            int iColumn = oSortTreeTable.columnAtPoint(oMouseEvent.getPoint());
            if (8 != iColumn) {
                return;
            }
            Object oprStatus = oSortTreeTable.getModel().getValueAt(iSelectedRow, iColumn);
            if (oprStatus instanceof ResourceProgressInfo) {
                ResourceProgressInfo progressInfo = (ResourceProgressInfo)oprStatus;
                if (995098636 == progressInfo.getErrorNo()) {
                    return;
                }
                if (1 != progressInfo.getState()) {
                    DCHelpForErrCodeUtil.showHelp(this, progressInfo.getErrorNo());
                }
            }
        }
    }

    private boolean isLastOperation(IsolationTaskInfoObj oDevInfoObj) {
        boolean isLastOperation = true;
        ITask oTask = TaskDataModel.getInstance().getTask(oDevInfoObj.getTaskId());
        if (null != oTask) {
            List<ITaskDeviceOperation> oOprList = oTask.getSupportedOperation();
            int iOprCount = oOprList.size();
            ITaskDeviceOperation oObj = null;
            boolean isFindCurrentOpr = false;
            for (int i = 0; i < iOprCount; ++i) {
                oObj = oOprList.get(i);
                if (!oObj.isSelected()) continue;
                if (isFindCurrentOpr) {
                    isLastOperation = false;
                    break;
                }
                if (!oObj.getOperationName().equals(oDevInfoObj.getCurrentOperation())) continue;
                isFindCurrentOpr = true;
            }
        }
        return isLastOperation;
    }

    private boolean isFinishOperation(IsolationTaskInfoObj oDevNodeInfo, String sOperatonIDString) {
        ResourceProgressInfo oResProgressInfo;
        ITask oTask = TaskDataModel.getInstance().getTask(oDevNodeInfo.getTaskId());
        if (oDevNodeInfo.getProgressInfo() instanceof ResourceProgressInfo && "Rollback".equals((oResProgressInfo = (ResourceProgressInfo)oDevNodeInfo.getProgressInfo()).getCurrentOperationId())) {
            return false;
        }
        if (null != oTask) {
            List<ITaskDeviceOperation> oOprList = oTask.getSupportedOperation();
            int iOprCount = oOprList.size();
            ITaskDeviceOperation oObj = null;
            for (int i = 0; i < iOprCount; ++i) {
                oObj = oOprList.get(i);
                if (!oObj.isSelected()) continue;
                if (oObj.getOperationName().equals(oDevNodeInfo.getCurrentOperation())) {
                    return sOperatonIDString.equals(oObj.getOperationIdString()) && 0 == oDevNodeInfo.getProgressInfo().getResult();
                }
                if (!sOperatonIDString.equals(oObj.getOperationIdString())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAllowToDoFreeOpr(IsolationTaskInfoObj oNodeInfo) {
        IsolationTaskInfoObj oDevNodeInfo = oNodeInfo.getParentObj();
        String strNormal = TaskCommUtil.getSWDLStatusRes(1);
        return this.isFinishOperation(oDevNodeInfo, "ActivateSoftware") || this.isFinishOperation(oDevNodeInfo, "Commit") || strNormal.equals(oDevNodeInfo.getLoadingState());
    }

    private boolean isAllowToRetry(IsolationTaskInfoObj oNodeInfo) {
        int iNodeType;
        if (null != oNodeInfo && 1 != (iNodeType = oNodeInfo.getNodeType())) {
            if (3 == iNodeType) {
                IsolationTaskInfoObj oDevNodeInfo;
                if (oNodeInfo.isIsolationBoard() && null != (oDevNodeInfo = oNodeInfo.getParentObj())) {
                    ResourceProgressInfo oDevProgressInfo = (ResourceProgressInfo)oDevNodeInfo.getProgressInfo();
                    if (1 == oDevProgressInfo.getState()) {
                        return false;
                    }
                    ITask oTask = TaskDataModel.getInstance().getTask(oDevNodeInfo.getTaskId());
                    ITaskDeviceOperation oTaskOpr = TaskInfoUtil.getTaskOperation(oTask, 19);
                    if (null != oTaskOpr && oTaskOpr.isSelected()) {
                        boolean bSlotRollbackFailed;
                        boolean isFinishActivation = this.isFinishOperation(oDevNodeInfo, "ActivateSoftware");
                        ResourceProgressInfo oSlotProgress = (ResourceProgressInfo)oNodeInfo.getProgressInfo();
                        boolean bSlotDispenseFailed = oSlotProgress.getCurrentOperationId().equals("Dispense") && oSlotProgress.getResult() == 1;
                        boolean bl = bSlotRollbackFailed = oSlotProgress.getCurrentOperationId().equals("Rollback") && oSlotProgress.getResult() == 1;
                        if (!isFinishActivation && (bSlotDispenseFailed || bSlotRollbackFailed)) {
                            return false;
                        }
                        boolean isFinishCommit = this.isFinishOperation(oDevNodeInfo, "Commit");
                        return !isFinishCommit;
                    }
                    String sSWDLStatus = oDevProgressInfo.getSWDLStatus();
                    if (ResourceManager.getInstance().getResString("SWDL_STATUS_8").equals(sSWDLStatus) || ResourceManager.getInstance().getResString("SWDL_STATUS_13").equals(sSWDLStatus)) {
                        return true;
                    }
                }
            } else {
                ResourceProgressInfo oDevProgressInfo = (ResourceProgressInfo)oNodeInfo.getProgressInfo();
                if (1 == oNodeInfo.getProgressInfo().getResult() && !"Rollback".equals(oDevProgressInfo.getCurrentOperationId())) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isAllowToRollback(IsolationTaskInfoObj oNodeInfo) {
        IsolationTaskInfoObj oDevNodeInfo;
        int iNodeType;
        return null != oNodeInfo && 1 != (iNodeType = oNodeInfo.getNodeType()) && (3 == iNodeType ? oNodeInfo.isIsolationBoard() && null != (oDevNodeInfo = oNodeInfo.getParentObj()) && 1 != oDevNodeInfo.getProgressInfo().getState() && !this.isFinishOperation(oDevNodeInfo, "Commit") : 1 != oNodeInfo.getProgressInfo().getState() && !this.isFinishOperation(oNodeInfo, "Commit"));
    }

    private void handleMenuItemState() {
        this.setMenuAndBtnDefaultStatus();
        this.m_oCurrSelectedTaskInfoObj = this.getSelectedNodeInfos();
        JTree Gtree = this.m_oSortTreeTablePanel.getTreeTable().getTree();
        int[] iGSelectedRows = this.m_oSortTreeTablePanel.getTreeTable().getSelectedRows();
        this.m_oCurrSelectedTaskInfoObj = this.getSelectedNodeInfos();
        int iCount = this.m_oCurrSelectedTaskInfoObj.size();
        if (0 < iCount) {
            boolean isSameDev = true;
            boolean isAllIsolationBoard = true;
            boolean isAllDevNode = true;
            boolean isSameTask = true;
            boolean isAllTask = true;
            boolean isAllDevSuccess = true;
            boolean isLastOperation = false;
            boolean isAllowToDoFreeOperation = true;
            boolean isAllowToDoRetry = true;
            boolean isAllowToDoRollback = true;
            boolean isSomeDevInProgress = false;
            boolean isContainRollbackOpr = false;
            boolean isT2000Dev = true;
            IsolationTaskInfoObj oNodeInfo = this.m_oCurrSelectedTaskInfoObj.get(0);
            if (1 == oNodeInfo.getNodeType()) {
                isAllTask = true;
                isAllDevNode = false;
                isAllIsolationBoard = false;
            } else if (2 == oNodeInfo.getNodeType()) {
                isAllTask = false;
                isAllDevNode = true;
                isAllIsolationBoard = false;
            } else {
                isAllTask = false;
                isAllDevNode = false;
                if (oNodeInfo.isIsolationBoard()) {
                    isAllIsolationBoard = true;
                }
            }
            int iTaskId = oNodeInfo.getTaskId();
            int iDevId = oNodeInfo.getDevId();
            for (int i = 0; i < iCount; ++i) {
                ResourceProgressInfo oProgressInfo;
                oNodeInfo = this.m_oCurrSelectedTaskInfoObj.get(i);
                if (isSameTask && iTaskId != oNodeInfo.getTaskId()) {
                    isSameTask = false;
                }
                if (isSameDev && iDevId != oNodeInfo.getDevId()) {
                    isSameDev = false;
                }
                if (isAllIsolationBoard && !oNodeInfo.isIsolationBoard()) {
                    isAllIsolationBoard = false;
                }
                if (isAllIsolationBoard && isAllowToDoFreeOperation) {
                    isAllowToDoFreeOperation = this.isAllowToDoFreeOpr(oNodeInfo);
                }
                if (isAllowToDoRetry) {
                    isAllowToDoRetry = this.isAllowToRetry(oNodeInfo);
                }
                if (isAllowToDoRollback) {
                    isAllowToDoRollback = this.isAllowToRollback(oNodeInfo);
                }
                if (!isContainRollbackOpr && 1 != oNodeInfo.getNodeType() && "Rollback".equals((oProgressInfo = (ResourceProgressInfo)oNodeInfo.getProgressInfo()).getCurrentOperationId())) {
                    isContainRollbackOpr = true;
                }
                if (isAllDevNode) {
                    if (2 != oNodeInfo.getNodeType()) {
                        isAllDevNode = false;
                    } else if (isAllDevSuccess) {
                        if (0 != oNodeInfo.getProgressInfo().getResult()) {
                            isAllDevSuccess = false;
                        }
                        if (!isLastOperation) {
                            isLastOperation = this.isLastOperation(oNodeInfo);
                        }
                        int iDevID = oNodeInfo.getDevId();
                        DeviceInfo oDeviceInfo = DCFrameWorkUtil.getDeviceInfoManager().getDevice(iDevID);
                        if (null != oDeviceInfo) {
                            DeviceTypeInfo oDeviceTypeInfo = oDeviceInfo.getDeviceTypeInfo();
                            if (isT2000Dev && 4 != oDeviceTypeInfo.getDevDomain()) {
                                isT2000Dev = false;
                            }
                        }
                    }
                }
                if (isAllTask && 1 != oNodeInfo.getNodeType()) {
                    isAllTask = false;
                }
                if (isAllTask) {
                    TreePath otmpTreePath = Gtree.getPathForRow(iGSelectedRows[i]);
                    if (null == otmpTreePath) continue;
                    TreeTableNode otmpNode = null;
                    otmpNode = (TreeTableNode)otmpTreePath.getLastPathComponent();
                    if (null == otmpNode) continue;
                    isSomeDevInProgress = this.isSomeDevInProgress(otmpNode);
                }
                if (isSomeDevInProgress) continue;
                isSomeDevInProgress = this.isExecutingOpr(oNodeInfo);
            }
            this.setFreeIsotionBtnMenuStatus(isSameDev, isAllIsolationBoard, isAllowToDoFreeOperation);
            this.setRefreshBtnMenuStatus(isAllDevNode, isSameTask);
            if (!isSomeDevInProgress) {
                this.setDelBtnMenuStatus(isAllDevNode, isSameTask, isAllTask);
                this.setContinueBtnMenuStatus(isAllDevNode, isSameTask, isAllDevSuccess, isLastOperation, isContainRollbackOpr, isT2000Dev);
                this.setRetryBtnMenuStatus(isAllIsolationBoard, isAllDevNode, isSameTask, isAllowToDoRetry);
                this.setRollbackBtnMenuStatus(isAllIsolationBoard, isAllDevNode, isSameTask, isAllowToDoRollback);
            }
        }
        if (0 == this.m_oSortTreeTablePanel.getRoot().getChildCount()) {
            this.m_oExportMenu.setEnabled(false);
            this.m_exportBtn.setEnabled(false);
        }
    }

    private void setRollbackBtnMenuStatus(boolean isAllIsolationBoard, boolean isAllDevNode, boolean isSameTask, boolean isAllowToDoRollback) {
        if (isAllowToDoRollback && isSameTask && (isAllDevNode || isAllIsolationBoard)) {
            this.m_oRollbackMenu.setEnabled(true);
            this.m_rollbackBtn.setEnabled(true);
        }
    }

    private void setRetryBtnMenuStatus(boolean isAllIsolationBoard, boolean isAllDevNode, boolean isSameTask, boolean isAllowToDoRetry) {
        if (isAllowToDoRetry && isSameTask && (isAllDevNode || isAllIsolationBoard)) {
            this.m_oRetryMenu.setEnabled(true);
            this.m_retryBtn.setEnabled(true);
        }
    }

    private void setContinueBtnMenuStatus(boolean isAllDevNode, boolean isSameTask, boolean isAllDevSuccess, boolean isLastOperation, boolean isContainRollbackOpr, boolean isT2000Dev) {
        if (isSameTask && isAllDevNode && (isAllDevSuccess || isT2000Dev) && !isLastOperation && !isContainRollbackOpr) {
            this.m_oContinueMenu.setEnabled(true);
            this.m_continueBtn.setEnabled(true);
        }
    }

    private void setDelBtnMenuStatus(boolean isAllDevNode, boolean isSameTask, boolean isAllTask) {
        if (isAllTask || isSameTask && isAllDevNode) {
            this.m_oDeleteMenu.setEnabled(true);
            this.m_deleteBtn.setEnabled(true);
        }
    }

    private void setRefreshBtnMenuStatus(boolean isAllDevNode, boolean isSameTask) {
        if (isSameTask && isAllDevNode) {
            this.m_oRefreshStateMenu.setEnabled(true);
            this.m_refreshStateBtn.setEnabled(true);
        }
    }

    private void setFreeIsotionBtnMenuStatus(boolean isSameDev, boolean isAllIsolationBoard, boolean isAllowToDoFreeOperation) {
        if (isSameDev && isAllIsolationBoard && isAllowToDoFreeOperation) {
            this.m_oFreeIsolationMenu.setEnabled(true);
            this.m_freeIsolationBtn.setEnabled(true);
        }
    }

    private boolean isSomeDevInProgress(TreeTableNode otmpNode) {
        boolean isSomeDevInProgress = false;
        for (int k = 0; k < otmpNode.getChildCount(); ++k) {
            TreeTableNode oDevNode = (TreeTableNode)otmpNode.getChildAt(k);
            IsolationTaskInfoObj oDevNodeInfo = (IsolationTaskInfoObj)oDevNode.getUserObject();
            if (!this.isExecutingOpr(oDevNodeInfo)) continue;
            isSomeDevInProgress = true;
            break;
        }
        return isSomeDevInProgress;
    }

    private void setMenuAndBtnDefaultStatus() {
        this.m_oRefreshStateMenu.setEnabled(false);
        this.m_oContinueMenu.setEnabled(false);
        this.m_oRetryMenu.setEnabled(false);
        this.m_oRollbackMenu.setEnabled(false);
        this.m_oExportMenu.setEnabled(true);
        this.m_oDeleteMenu.setEnabled(false);
        this.m_oFreeIsolationMenu.setEnabled(false);
        this.m_refreshStateBtn.setEnabled(false);
        this.m_continueBtn.setEnabled(false);
        this.m_retryBtn.setEnabled(false);
        this.m_rollbackBtn.setEnabled(false);
        this.m_exportBtn.setEnabled(true);
        this.m_deleteBtn.setEnabled(false);
        this.m_freeIsolationBtn.setEnabled(false);
    }

    @Override
    public void updateSelectionState() {
        this.handleMenuItemState();
        this.notifyEvent();
    }

    public boolean locateIsolation(int iTaskId, int iDevId) {
        IsolationTaskInfoObj nodeInfoObj;
        int iChildCount = this.m_rootNode.getChildCount();
        TreeTableNode tmpNode = null;
        for (int i = 0; i < iChildCount && iTaskId != (nodeInfoObj = (IsolationTaskInfoObj)(tmpNode = (TreeTableNode)this.m_rootNode.getChildAt(i)).getUserObject()).getTaskId(); ++i) {
            tmpNode = null;
        }
        this.m_oSortTreeTablePanel.expandTree(tmpNode);
        int iRow = this.getSelectingRow(iTaskId, iDevId);
        if (0 <= iRow) {
            this.m_oSortTreeTablePanel.getTreeTable().getTree().setSelectionRow(iRow);
            this.m_oSortTreeTablePanel.scrollRectToVisible(iRow, 0);
            this.updateSelectionState();
            return true;
        }
        return false;
    }

    public void addSelectiongEvent(DCTreeEventListener oSelectionListener) {
        this.m_oTreeTableSelectionListenerLst.add(oSelectionListener);
    }

    private void notifyEvent() {
        boolean isNotify = true;
        IsolationTaskInfoObj oEventObj = null;
        int iTaskId = -1;
        List<IsolationTaskInfoObj> taskInfoObjLst = this.getSelectedNodeInfos();
        if (1 == taskInfoObjLst.size()) {
            IsolationTaskInfoObj tmpTaskInfoObj = taskInfoObjLst.get(0);
            if (this.m_iPreTaskId == tmpTaskInfoObj.getTaskId() && this.m_iPreDevId == tmpTaskInfoObj.getDevId() && this.m_iPreSlotId == tmpTaskInfoObj.getSlotId()) {
                isNotify = false;
            } else {
                oEventObj = taskInfoObjLst.get(0);
                iTaskId = taskInfoObjLst.get(0).getTaskId();
                this.initOprInfoForResource(iTaskId, taskInfoObjLst.get(0).getResource());
                this.m_iPreTaskId = iTaskId;
                this.m_iPreDevId = tmpTaskInfoObj.getDevId();
                this.m_iPreSlotId = tmpTaskInfoObj.getSlotId();
            }
        } else {
            this.m_iPreTaskId = -1;
            this.m_iPreDevId = -1;
            this.m_iPreSlotId = -1;
        }
        if (isNotify) {
            TaskEvent oTaskEvent = new TaskEvent(oEventObj, TaskEventID.INVALID_ID);
            oTaskEvent.setTaskID(iTaskId);
            int iSize = this.m_oTreeTableSelectionListenerLst.size();
            for (int i = 0; i < iSize; ++i) {
                this.m_oTreeTableSelectionListenerLst.get(i).onTreeNodeSelection(oTaskEvent);
            }
        }
    }

    public void notifyEvent(TaskEvent oTaskEvent) {
        IsolationTaskInfoObj oEventObj = null;
        int iTaskId = -1;
        List<IsolationTaskInfoObj> taskInfoObjLst = this.getSelectedNodeInfos();
        if (1 == taskInfoObjLst.size()) {
            oEventObj = taskInfoObjLst.get(0);
            iTaskId = taskInfoObjLst.get(0).getTaskId();
            this.initOprInfoForResource(iTaskId, taskInfoObjLst.get(0).getResource());
            oTaskEvent.setSource(oEventObj);
            oTaskEvent.setTaskID(iTaskId);
        }
        int iSize = this.m_oTreeTableSelectionListenerLst.size();
        for (int i = 0; i < iSize; ++i) {
            this.m_oTreeTableSelectionListenerLst.get(i).onTreeNodeSelection(oTaskEvent);
        }
    }

    private void handleResProgressNotification(int iTaskId, Resource oRes) {
        ITask oTask = TaskDataModel.getInstance().getTask(iTaskId);
        if (null == oTask) {
            return;
        }
        if (IsolationCommonOperation.isIsolationTask(oTask.getTaskTypeId())) {
            String sLoadingState;
            IsolationTaskInfoObj oIsolationTaskInfoObj;
            if (this.isSelected(iTaskId, oRes)) {
                this.handleMenuItemState();
            }
            if (0 > oRes.getSlotId() && null != (oIsolationTaskInfoObj = this.getNodeInfo(iTaskId, oRes.getDeviceID())) && !StringUtils.isNullOrEmptyStr(sLoadingState = oRes.getProgressInfo().getSWDLStatus())) {
                DCDebugTracer.trace("refresh loadint state " + sLoadingState + " " + oRes.getDeviceID());
                oIsolationTaskInfoObj.setLoadingState(sLoadingState);
            }
            if (0 < oRes.getSlotId() && -1 != oRes.getIsIsolationBoard()) {
                TreeTableNode oNode = this.getNode(iTaskId, oRes.getDeviceID(), oRes.getSlotId());
                IsolationTaskInfoObj oBoardInfoObj = (IsolationTaskInfoObj)oNode.getUserObject();
                boolean isIsolationBoard = oRes.getIsIsolationBoard() > 0;
                oBoardInfoObj.setIsolationBoard(isIsolationBoard);
            }
        }
    }

    @Override
    public void onTaskNotification(TaskEvent oEvent) {
        TaskEventID iTaskEventType = oEvent.getTaskEventType();
        if (TaskEventID.TASK_LIST_REFRESH == iTaskEventType) {
            Boolean oIsLastInfo = (Boolean)oEvent.getSource();
            if (null != oIsLastInfo && oIsLastInfo.booleanValue()) {
                this.initPospiceTaskTable();
                this.closeIsolationPanel();
            }
        } else if (TaskEventID.RESOURCE_PROGRESS_NOTIFICATION == iTaskEventType) {
            Object oSource = oEvent.getSource();
            if (oSource instanceof HashMap) {
                HashMap oUpdateResInfoMap = (HashMap)oSource;
                Iterator oTaskIdItr = oUpdateResInfoMap.keySet().iterator();
                while (oTaskIdItr.hasNext()) {
                    int iTaskId = (Integer)oTaskIdItr.next();
                    List oResLst = (List)oUpdateResInfoMap.get(iTaskId);
                    for (Resource oTmpRes : oResLst) {
                        this.handleResProgressNotification(iTaskId, oTmpRes);
                    }
                }
            } else if (oSource instanceof Resource) {
                int iTaskId = oEvent.getTaskID();
                this.handleResProgressNotification(iTaskId, (Resource)oSource);
            } else {
                return;
            }
            TaskEvent oTaskEvent = new TaskEvent(null, TaskEventID.DC_UPDATE_ISOLATION_OPERATION_PROGRESS);
            this.notifyEvent(oTaskEvent);
            DCFrameWorkUtil.repaint((JComponent)((Object)this.m_oSortTreeTablePanel.getTreeTable()));
        } else if (TaskEventID.DC_CREATE_ISOLATION_TASK_INFO == iTaskEventType) {
            int iDevId;
            int iTaskId = oEvent.getTaskID();
            if (null == this.getNode(iTaskId, iDevId = oEvent.getDevID())) {
                this.createTaskAndAppointedDevNode(iTaskId, iDevId);
                this.m_oSortTreeTablePanel.updateTreeTable();
            }
            this.locateIsolation(oEvent.getTaskID(), oEvent.getDevID());
        } else if (TaskEventID.TASK_DELETION == iTaskEventType) {
            if (oEvent.getSource() instanceof List) {
                List iTaskIds = (List)oEvent.getSource();
                int iTaskCount = iTaskIds.size();
                for (int i = 0; i < iTaskCount; ++i) {
                    TreeTableNode oTaskNode = this.getNode((Integer)iTaskIds.get(i), -1);
                    if (null == oTaskNode) continue;
                    oTaskNode.removeFromParent();
                }
                this.m_oSortTreeTablePanel.updateTreeTable();
            }
        } else {
            DCDebugTracer.trace("the event id is " + (Object)((Object)iTaskEventType));
        }
    }

    public boolean locateIsolation(String strTaskName, int iDevId) {
        int iChildCount = this.m_rootNode.getChildCount();
        int iTaskId = -1;
        TreeTableNode tmpNode = null;
        for (int i = 0; i < iChildCount; ++i) {
            tmpNode = (TreeTableNode)this.m_rootNode.getChildAt(i);
            IsolationTaskInfoObj nodeInfoObj = (IsolationTaskInfoObj)tmpNode.getUserObject();
            if (strTaskName.equals(nodeInfoObj.getResName())) {
                iTaskId = nodeInfoObj.getTaskId();
                break;
            }
            iTaskId = -1;
            tmpNode = null;
        }
        this.m_oSortTreeTablePanel.expandTree(tmpNode);
        int iRow = this.getSelectingRow(iTaskId, iDevId);
        if (0 <= iRow) {
            this.m_oSortTreeTablePanel.getTreeTable().getTree().setSelectionRow(iRow);
            this.m_oSortTreeTablePanel.scrollRectToVisible(iRow, 0);
            this.updateSelectionState();
            return true;
        }
        return false;
    }

    private void initPospiceTaskTable() {
        this.m_rootNode.removeAllChildren();
        ITaskGroup oIsolationTaskGroup = TaskDataModel.getInstance().getTaskGroup(256);
        List<ITask> oTaskLst = oIsolationTaskGroup.getAllTask();
        int iTaskCount = oTaskLst.size();
        for (int j = 0; j < iTaskCount; ++j) {
            ITask oTask = oTaskLst.get(j);
            this.createTaskAndAllDevNode(oTask);
        }
        this.m_oSortTreeTablePanel.updateTreeTable();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IsolationTaskInfoPanel.this.m_oSortTreeTablePanel.getTreeTable().getSelectionModel().addSelectionInterval(0, 0);
                IsolationTaskInfoPanel.this.updateSelectionState();
            }
        });
    }

    public JSortTreeTable getSortTreeTable() {
        return this.m_oSortTreeTablePanel.getTreeTable();
    }

    private boolean isSelected(int iTaskId, Resource oRes) {
        if (null != this.m_oCurrSelectedTaskInfoObj && 0 < this.m_oCurrSelectedTaskInfoObj.size()) {
            int iSize = this.m_oCurrSelectedTaskInfoObj.size();
            IsolationTaskInfoObj oSelectedInfoObj = null;
            for (int i = 0; i < iSize; ++i) {
                oSelectedInfoObj = this.m_oCurrSelectedTaskInfoObj.get(i);
                if (iTaskId != oSelectedInfoObj.getTaskId() || oRes.getDeviceID() != oSelectedInfoObj.getDevId() || oRes.getSlotId() != oSelectedInfoObj.getSlotId()) continue;
                return true;
            }
        }
        return false;
    }

    void closeIsolationPanel() {
        TaskManagementMainPanel oTaskMgrMainPanel;
        int iChildCount = this.m_oSortTreeTablePanel.getRoot().getChildCount();
        if (0 >= iChildCount && null != (oTaskMgrMainPanel = DCFrameWorkUtil.getDCModuleManager().getTaskMgrMainPanel())) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("CLOSE_ISOLATION_PANEL_SUGGESTION_TEST"), ResourceManager.getInstance().getResString("CLOSE_ISOLATION_PANEL_TITLE"), 1);
                    oTaskMgrMainPanel.closeIsolationManagementPanel();
                }
            });
        }
    }

    @Override
    protected void initProgressDlg(int iReqId, int iCmdCode, String strTitle, String[] columnNames, HashMap<Integer, String> oBoardInfoMap) {
        this.m_oCommProgressDlg = null != oBoardInfoMap ? new CommonProgressDlg(iCmdCode, this.m_oResIdLst, columnNames, oBoardInfoMap) : new CommonProgressDlg(iCmdCode, this.m_oResIdLst, columnNames);
        this.m_oCommProgressDlg.setProgressDlgId(iReqId);
        this.m_oCommProgressDlg.setTitle(strTitle);
    }

    private void showProgressDlg(final int iCmdCode) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IsolationTaskInfoPanel.this.m_oCommProgressDlg.setVisible(true);
                if (44056 == iCmdCode) {
                    IsolationTaskInfoPanel.this.closeIsolationPanel();
                }
            }
        });
    }

    public void disposePanel() {
        this.m_oSortTreeTablePanel = null;
        this.m_rootNode = null;
        this.m_oPopupMenu = null;
        if (null != this.m_oTreeTableSelectionListenerLst) {
            this.m_oTreeTableSelectionListenerLst.clear();
            this.m_oTreeTableSelectionListenerLst = null;
        }
        if (null != this.m_oCurrSelectedTaskInfoObj) {
            this.m_oCurrSelectedTaskInfoObj.clear();
            this.m_oCurrSelectedTaskInfoObj = null;
        }
    }
}

