/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.isolation.view;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.taskmgmt.model.ProgressInfo;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import com.huawei.dc.taskmgmt.model.TaskProgressInfo;
import com.huawei.dc.taskmgmt.view.tasktable.TaskTableUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class IsolationOperationStatusRender
implements TableCellRenderer {
    private JTable m_oTable;
    private boolean bIsSelect;
    private Border m_oBorder = DCConstants.DEFAULT_TABLE_CELL_BORDER;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.m_oTable = table;
        this.bIsSelect = isSelected;
        Component oComponent = null;
        if (value instanceof ProgressInfo) {
            oComponent = this.getRendererComponentForProgressInfo((ProgressInfo)value);
        } else {
            JLabel oLabel = new JLabel();
            oLabel.setOpaque(true);
            String strVal = "";
            if (null != value) {
                strVal = value.toString();
            }
            oLabel.setText(strVal);
            oLabel.setBorder(this.m_oBorder);
            oComponent = oLabel;
        }
        if (!(oComponent instanceof JProgressBar)) {
            if (isSelected) {
                oComponent.setBackground(table.getSelectionBackground());
            } else {
                oComponent.setBackground(table.getBackground());
            }
        }
        return oComponent;
    }

    private Component getRendererComponentForProgressInfo(ProgressInfo oProgressInfo) {
        if (1 == oProgressInfo.getState()) {
            return this.generateProgressBar(oProgressInfo);
        }
        if (oProgressInfo instanceof ResourceProgressInfo) {
            ResourceProgressInfo oResProgress = (ResourceProgressInfo)oProgressInfo;
            if (999293081 == oResProgress.getErrorNo()) {
                return this.generateLinkRenderer(oResProgress);
            }
            JLabel oLabel = new JLabel();
            oLabel.setOpaque(true);
            oLabel.setBorder(this.m_oBorder);
            String result = 995098636 == oResProgress.getErrorNo() ? DCCommonUtil.getFailureStr("", oResProgress.getErrorInfo()) : oProgressInfo.toString();
            if (this.bIsSelect) {
                oLabel.setText(StringUtils.convertColorsToWhite(result));
                oLabel.setForeground(Color.white);
            } else {
                oLabel.setText(result);
            }
            if (oProgressInfo instanceof TaskProgressInfo) {
                oLabel.setForeground(((TaskProgressInfo)oProgressInfo).getTaskStausColor());
            }
            String strToolTipText = 995098636 == oResProgress.getErrorNo() ? DCCommonUtil.getFailureStr("", oResProgress.getErrorInfo()) : oProgressInfo.toString();
            int iNumCharInOneRow = 100;
            if (strToolTipText.length() > 100) {
                strToolTipText = TaskTableUtil.breakLongToolTipText(strToolTipText, 100);
            }
            oLabel.setToolTipText(strToolTipText);
            return oLabel;
        }
        JLabel oLabel = new JLabel();
        oLabel.setOpaque(true);
        oLabel.setBorder(this.m_oBorder);
        oLabel.setText(oProgressInfo.toString());
        if (oProgressInfo instanceof TaskProgressInfo) {
            oLabel.setForeground(((TaskProgressInfo)oProgressInfo).getTaskStausColor());
        }
        String strToolTipText = oProgressInfo.toString();
        int iNumCharInOneRow = 100;
        if (strToolTipText.length() > 100) {
            strToolTipText = TaskTableUtil.breakLongToolTipText(strToolTipText, 100);
        }
        oLabel.setToolTipText(strToolTipText);
        return oLabel;
    }

    private Component generateLinkRenderer(ResourceProgressInfo oResourceProgressInfo) {
        JButton oButton = new JButton();
        oButton.setBackground(this.m_oTable.getBackground());
        oButton.setText(oResourceProgressInfo.toString());
        oButton.setToolTipText(oResourceProgressInfo.getToolTipText());
        oButton.setHorizontalAlignment(2);
        oButton.setBorder(this.m_oBorder);
        oButton.setEnabled(true);
        return oButton;
    }

    private Component generateProgressBar(ProgressInfo oProgressInfo) {
        JProgressBar progressBar = new JProgressBar(0, 0, 100);
        progressBar.setOpaque(true);
        progressBar.setBackground(this.m_oTable.getBackground());
        progressBar.setForeground(new Color(0, 0, 115));
        progressBar.setStringPainted(true);
        progressBar.setValue(oProgressInfo.getProgress());
        progressBar.setToolTipText(oProgressInfo.toString());
        progressBar.setBorder(this.m_oBorder);
        return progressBar;
    }
}

