/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.isolation.view;

import com.huawei.dc.adapter.swimap.iview.commstyle.resource.DCResourceMng;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.OperationIdStore;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.event.DCEventObject;
import com.huawei.dc.common.framework.interfaces.DCTreeEventListener;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.taskmgmt.controller.TaskAsynCommController;
import com.huawei.dc.taskmgmt.controller.TaskEvent;
import com.huawei.dc.taskmgmt.controller.TaskEventID;
import com.huawei.dc.taskmgmt.controller.TaskSyncCommController;
import com.huawei.dc.taskmgmt.isolation.IUpdateIsolationOperationDetailsInfo;
import com.huawei.dc.taskmgmt.isolation.model.IsolationDevOprDetailInfoObj;
import com.huawei.dc.taskmgmt.isolation.model.IsolationTaskInfoObj;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import com.huawei.dc.taskmgmt.model.TaskDataModel;
import com.huawei.dc.taskmgmt.view.common.HyperLinkLabel;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class IsolationOperationListPanel
extends JPanel
implements DCTreeEventListener {
    private static final long serialVersionUID = -4289154375712329164L;
    private int m_iTaskId = -1;
    private int m_iDevId = -1;
    private HashMap<Integer, HyperLinkLabel> m_oHyperLinkLabelMap = null;
    private GridLayout m_gridLayout = new GridLayout(7, 1);
    private IUpdateIsolationOperationDetailsInfo m_oOprDetailsPanel;
    private IsolationTaskInfoObj m_oSelectedTaskInfoObj;
    private int m_currSelectedOprId = -1;

    public IsolationOperationListPanel() {
        this.setLayout(this.m_gridLayout);
        this.m_oHyperLinkLabelMap = new HashMap(7);
    }

    private void updateDevOperationLst(IsolationTaskInfoObj oSelectedTaskInfoObj) {
        boolean isSame = false;
        if (1 == oSelectedTaskInfoObj.getNodeType()) {
            if (this.m_iTaskId == oSelectedTaskInfoObj.getTaskId()) {
                isSame = true;
            }
        } else if (this.m_iTaskId == oSelectedTaskInfoObj.getTaskId() && this.m_iDevId == oSelectedTaskInfoObj.getDevId()) {
            isSame = true;
        }
        if (!isSame) {
            this.removeAll();
            this.m_iTaskId = oSelectedTaskInfoObj.getTaskId();
            this.m_iDevId = oSelectedTaskInfoObj.getDevId();
            DeviceInfo oDevInfo = DeviceInfoManagerImpl.getInstance().getDevice(this.m_iDevId);
            List<IsolationDevOprDetailInfoObj> oprDetailsLst = null;
            try {
                oprDetailsLst = TaskSyncCommController.getInstance().getIsolationDevOperationDetails(this.m_iTaskId, oSelectedTaskInfoObj.getResource());
            }
            catch (DCException e) {
                DCDebugTracer.trace(e);
                return;
            }
            if (null != oprDetailsLst) {
                int iOprCount = oprDetailsLst.size();
                if (this.m_gridLayout.getRows() != iOprCount) {
                    this.m_gridLayout.setRows(iOprCount);
                }
                IsolationDevOprDetailInfoObj tmpOprDetails = null;
                String strFirstOprId = "";
                for (int i = 0; i < iOprCount; ++i) {
                    tmpOprDetails = oprDetailsLst.get(i);
                    DCDebugTracer.trace("DC::IsolationOperationListPanel.updateDevOperationLst(taskId = " + this.m_iTaskId + ", devId = " + oSelectedTaskInfoObj.getDevId() + ", devName = " + oSelectedTaskInfoObj.getResName() + ", operationName = " + tmpOprDetails.getName() + ", status = " + tmpOprDetails.getStatus() + ", result = " + tmpOprDetails.getResult());
                    int iOprId = OperationIdStore.getInstance().getOperationId(tmpOprDetails.getName());
                    HyperLinkLabel tmpLinkLbl = this.getHyperLinkLabel(iOprId);
                    if (0 == i) {
                        strFirstOprId = tmpOprDetails.getName();
                    }
                    tmpLinkLbl.setName("com.huawei.dc.taskmgmt.isolation.view.IsolationDevOperationListPanel." + tmpOprDetails.getName() + "LinkLbl");
                    tmpLinkLbl.setText(ResourceManager.getInstance().getResString(oDevInfo.getDeviceTypeInfo(), tmpOprDetails.getName()));
                    tmpLinkLbl.setOperationID(iOprId);
                    tmpLinkLbl.setOperationStatus(tmpOprDetails.getStatus());
                    tmpLinkLbl.setIcon(this.getIconBasedOnStatus(tmpOprDetails.getStatus(), tmpOprDetails.getResult()));
                    this.add(tmpLinkLbl);
                }
                this.m_currSelectedOprId = OperationIdStore.getInstance().getOperationId(strFirstOprId);
                this.m_oOprDetailsPanel.updateOprDetailsInfo(strFirstOprId, oSelectedTaskInfoObj, false);
                DCFrameWorkUtil.updateUI(this);
            }
        }
    }

    private void getTaskOperationLst(IsolationTaskInfoObj oSelectedTaskInfoObj) {
        ITask oTask = TaskDataModel.getInstance().getTask(oSelectedTaskInfoObj.getTaskId());
        THashSet<Resource> oResList = oTask.getDeviceType().getResources();
        TaskAsynCommController.getInstance().getTaskLevelDevOprResultDetails(oTask.getTaskId(), oResList);
    }

    private void updateTaskOperationLst(IsolationTaskInfoObj oSelectedTaskInfoObj, boolean isCreate) {
        if (isCreate) {
            this.removeAll();
            this.m_iTaskId = oSelectedTaskInfoObj.getTaskId();
            this.m_iDevId = -1;
        }
        ITask oTask = TaskDataModel.getInstance().getTask(this.m_iTaskId);
        List<ITaskDeviceOperation> oOprList = oTask.getSupportedOperation();
        int iLen = oOprList.size();
        ITaskDeviceOperation oObj = null;
        Vector<HyperLinkLabel> linkLblVec = new Vector<HyperLinkLabel>();
        int iOprStatus = -1;
        boolean isFirst = true;
        String strFirstOprId = "";
        for (int i = 0; i < iLen; ++i) {
            oObj = oOprList.get(i);
            if (!oObj.isSelected()) continue;
            HyperLinkLabel oHyperLinkLabel = this.getHyperLinkLabel(oObj.getOperationId());
            if (isFirst) {
                strFirstOprId = oObj.getOperationIdString();
                isFirst = false;
            }
            oHyperLinkLabel.setText(oObj.getOperationName());
            oHyperLinkLabel.setName("com.huawei.dc.taskmgmt.isolation.view.IsolationDevOperationListPanel." + oObj.getOperationName() + "LinkLbl");
            iOprStatus = this.getOprStatusForSelectedTask(oTask, oObj.getOperationId());
            if (1 == iOprStatus) {
                String str = oHyperLinkLabel.getText();
                oHyperLinkLabel.setText("<html><B>" + str + "</B></html>");
            }
            oHyperLinkLabel.setOperationID(oObj.getOperationId());
            oHyperLinkLabel.setOperationStatus(iOprStatus);
            oHyperLinkLabel.setIcon(this.getIconBasedOnStatus(iOprStatus, this.getOprResultForSelectedTask(oTask, oObj.getOperationId())));
            if (!isCreate) continue;
            linkLblVec.add(oHyperLinkLabel);
        }
        if (isCreate) {
            int iOprCount = linkLblVec.size();
            if (this.m_gridLayout.getRows() != iOprCount) {
                this.m_gridLayout.setRows(iOprCount);
            }
            for (int i = 0; i < iOprCount; ++i) {
                this.add((Component)linkLblVec.get(i));
            }
            linkLblVec.clear();
            this.m_currSelectedOprId = OperationIdStore.getInstance().getOperationId(strFirstOprId);
            this.m_oOprDetailsPanel.updateOprDetailsInfo(strFirstOprId, oSelectedTaskInfoObj, false);
        }
        DCFrameWorkUtil.updateUI(this);
    }

    private HyperLinkLabel getHyperLinkLabel(int iOprID) {
        HyperLinkLabel oHyperLinkLabel = null;
        oHyperLinkLabel = this.m_oHyperLinkLabelMap.get(iOprID);
        if (null == oHyperLinkLabel) {
            oHyperLinkLabel = new HyperLinkLabel();
            oHyperLinkLabel.addActionListener(new CustomActionListener(iOprID));
            this.m_oHyperLinkLabelMap.put(iOprID, oHyperLinkLabel);
        }
        return oHyperLinkLabel;
    }

    private ImageIcon getIconBasedOnStatus(int iOperationStatus, int result) {
        ImageIcon oIcon = null;
        switch (iOperationStatus) {
            case 2: 
            case 3: {
                if (1 == result) {
                    oIcon = ResourceManager.getInstance().getImage("error2.gif");
                    break;
                }
                oIcon = ResourceManager.getInstance().getImage("done.gif");
                break;
            }
            case 1: {
                oIcon = ResourceManager.getInstance().getImage("ondo.gif");
                break;
            }
            case 4: {
                oIcon = ResourceManager.getInstance().getImage("pause.gif");
                break;
            }
            case 0: {
                oIcon = ResourceManager.getInstance().getImage("ready.gif");
                break;
            }
            default: {
                oIcon = ResourceManager.getInstance().getImage("ready.gif");
            }
        }
        return oIcon;
    }

    @Override
    public void onTreeInit(DCEventObject eventObject) {
    }

    @Override
    public void onTreeNodeSelection(DCEventObject eventObject) {
        if (eventObject instanceof TaskEvent) {
            TaskEvent oTaskEvent = (TaskEvent)eventObject;
            if (oTaskEvent.getSource() instanceof IsolationTaskInfoObj) {
                this.m_oSelectedTaskInfoObj = (IsolationTaskInfoObj)oTaskEvent.getSource();
                if (TaskEventID.DC_UPDATE_ISOLATION_OPERATION_PROGRESS == oTaskEvent.getTaskEventType()) {
                    this.updateProgressInfo(this.m_oSelectedTaskInfoObj);
                } else if (1 == this.m_oSelectedTaskInfoObj.getNodeType()) {
                    if (TaskEventID.DC_UPDATE_ISOLATION_TASK_OPERATION_DETAILS == oTaskEvent.getTaskEventType()) {
                        this.updateTaskOperationLst(this.m_oSelectedTaskInfoObj, true);
                    } else {
                        this.getTaskOperationLst(this.m_oSelectedTaskInfoObj);
                    }
                } else if (2 == this.m_oSelectedTaskInfoObj.getNodeType()) {
                    this.updateDevOperationLst(this.m_oSelectedTaskInfoObj);
                } else {
                    this.invisibleOprLstAndDetails();
                }
            } else {
                this.invisibleOprLstAndDetails();
            }
        }
    }

    private void invisibleOprLstAndDetails() {
        this.m_iTaskId = -1;
        this.m_iDevId = -1;
        this.removeAll();
        DCFrameWorkUtil.updateUI(this);
        this.m_oOprDetailsPanel.updateOprDetailsInfo("", null, false);
    }

    private void updateProgressInfo(IsolationTaskInfoObj oSelectTaskInfoObj) {
        int iCurrentRunOprId = this.m_currSelectedOprId;
        if (1 == oSelectTaskInfoObj.getNodeType()) {
            this.updateTaskOperationLst(oSelectTaskInfoObj, false);
        } else {
            ResourceProgressInfo oProgressInfo = oSelectTaskInfoObj.getResource().getProgressInfo();
            if (null != oProgressInfo) {
                int iOprId = OperationIdStore.getInstance().getOperationId(oProgressInfo.getCurrentOperationId());
                HyperLinkLabel oHyperLinkLabel = this.getHyperLinkLabel(iOprId);
                oHyperLinkLabel.setOperationStatus(oProgressInfo.getState());
                if (1 == oProgressInfo.getState()) {
                    iCurrentRunOprId = iOprId;
                    String str = oHyperLinkLabel.getText();
                    if (!str.startsWith("<html>".toLowerCase(DCResourceMng.getInstance().getLocale()))) {
                        oHyperLinkLabel.setText("<html><B>" + str + "</B></html>");
                    }
                }
                oHyperLinkLabel.setIcon(this.getIconBasedOnStatus(oProgressInfo.getState(), oProgressInfo.getResult()));
                DCFrameWorkUtil.updateUI(this);
            }
        }
        this.m_oOprDetailsPanel.updateOprDetailsInfo(OperationIdStore.getInstance().getOperationStrId(iCurrentRunOprId), this.m_oSelectedTaskInfoObj, true);
    }

    public void setOperationDetailsPanel(IUpdateIsolationOperationDetailsInfo oOprDetailsPanel) {
        this.m_oOprDetailsPanel = oOprDetailsPanel;
    }

    private int getOprStatusForSelectedTask(ITask oTask, int iOprID) {
        THashSet<Resource> oResList = oTask.getDeviceType().getResources();
        int iOprStatus = 0;
        String strOprID = OperationIdStore.getInstance().getOperationStrId(iOprID);
        ResourceProgressInfo oResourceProgressInfo = null;
        Iterator oResItor = oResList.iterator();
        Resource oRes = null;
        while (oResItor.hasNext()) {
            oRes = (Resource)oResItor.next();
            oResourceProgressInfo = oRes.getProgressInfo();
            if (null != oResourceProgressInfo && strOprID.equals(oResourceProgressInfo.getCurrentOperationId())) {
                iOprStatus = oResourceProgressInfo.getState();
            } else {
                oResourceProgressInfo = oRes.getOprResultInfo(strOprID);
                if (null != oResourceProgressInfo) {
                    iOprStatus = oResourceProgressInfo.getState();
                }
            }
            if (1 != iOprStatus) continue;
            break;
        }
        return iOprStatus;
    }

    private int getOprResultForSelectedTask(ITask oTask, int iOprID) {
        THashSet<Resource> oResList = oTask.getDeviceType().getResources();
        int iOprResult = -1;
        String strOprID = OperationIdStore.getInstance().getOperationStrId(iOprID);
        ResourceProgressInfo oResourceProgressInfo = null;
        Iterator oResItor = oResList.iterator();
        Resource oRes = null;
        while (oResItor.hasNext()) {
            oRes = (Resource)oResItor.next();
            oResourceProgressInfo = oRes.getOprResultInfo(strOprID);
            if (null == oResourceProgressInfo) continue;
            iOprResult = oResourceProgressInfo.getResult();
            if (1 != oResourceProgressInfo.getResult()) continue;
            break;
        }
        return iOprResult;
    }

    class CustomActionListener
    implements ActionListener,
    Serializable {
        private static final long serialVersionUID = 7010879645338361138L;
        int iCurrentOprID = -1;

        public CustomActionListener(int iOprID) {
            this.iCurrentOprID = iOprID;
        }

        @Override
        public void actionPerformed(ActionEvent oEvent) {
            IsolationOperationListPanel.this.m_currSelectedOprId = this.iCurrentOprID;
            IsolationOperationListPanel.this.m_oOprDetailsPanel.updateOprDetailsInfo(OperationIdStore.getInstance().getOperationStrId(this.iCurrentOprID), IsolationOperationListPanel.this.m_oSelectedTaskInfoObj, false);
        }
    }
}

