/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.isolation.view;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.OperationIdStore;
import com.huawei.dc.common.asndatacenter.AsnDCGetDetailResultRsp;
import com.huawei.dc.common.asndatacenter.AsnUpgradeFeasibilityRsp;
import com.huawei.dc.common.components.treetable.ISortTreeTableListener;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.view.JSortTreeTable;
import com.huawei.dc.common.components.treetable.view.SortTreeTablePanel;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.common.util.ErrorInfo;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import com.huawei.dc.taskmgmt.controller.TaskSyncCommController;
import com.huawei.dc.taskmgmt.controller.UpgradeFeasibilityValidationManager;
import com.huawei.dc.taskmgmt.isolation.IUpdateIsolationOperationDetailsInfo;
import com.huawei.dc.taskmgmt.isolation.model.IsolationDevOprDetailInfoObj;
import com.huawei.dc.taskmgmt.isolation.model.IsolationDevOprDetailTableInfo;
import com.huawei.dc.taskmgmt.isolation.model.IsolationTaskInfoObj;
import com.huawei.dc.taskmgmt.isolation.model.IsolationTaskInfoTableModel;
import com.huawei.dc.taskmgmt.isolation.view.IsolationTreeNodeRender;
import com.huawei.dc.taskmgmt.model.ITaskSubOperation;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.SubOperationObject;
import com.huawei.dc.taskmgmt.model.SubOprCheckItemDetails;
import com.huawei.dc.taskmgmt.view.createtask.ViewCommandResultDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.Collator;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.tree.TreePath;

public class IsolationDevOperationDetailsPanel
extends JPanel
implements ISortTreeTableListener,
IUpdateIsolationOperationDetailsInfo {
    private static final long serialVersionUID = 4279509788233137800L;
    private static final String m_strPrefix = "<html><a href=\"x\">";
    private static final String m_strPostfix = "</a></html>";
    private SortTreeTablePanel m_oSortTreeTablePanel;
    private TreeTableNode m_rootNode;
    private String m_strOperationId = "";
    private IsolationTaskInfoObj m_oCurrentSelectedTaskInfoObj;
    private static final int DETAIL_COLUMN = 4;

    public IsolationDevOperationDetailsPanel() {
        this.setLayout(new BorderLayout());
        this.jInit();
    }

    private void jInit() {
        IsolationDevOprDetailTableInfo oprTableInfo = new IsolationDevOprDetailTableInfo();
        IsolationTaskInfoTableModel taskTableModel = new IsolationTaskInfoTableModel(oprTableInfo);
        this.m_oSortTreeTablePanel = new SortTreeTablePanel(taskTableModel);
        this.m_oSortTreeTablePanel.setName("com.huawei.dc.taskmgmt.isolation.view.IsolationDevOperationDetailsPanel.m_oSortTreeTablePanel");
        this.m_oSortTreeTablePanel.getBottomPanel().setVisible(false);
        this.m_oSortTreeTablePanel.registListener(this);
        this.m_oSortTreeTablePanel.getTreeTable().getTree().setCellRenderer(new IsolationTreeNodeRender());
        this.m_oSortTreeTablePanel.getTreeTable().getDefaultRenderer(String.class);
        this.m_oSortTreeTablePanel.getTreeTable().addMouseMotionListener(new OperationTableMouseMotionListener());
        this.m_oSortTreeTablePanel.getTreeTable().addMouseListener(new OperationTableMouseListener());
        this.m_rootNode = this.m_oSortTreeTablePanel.getRoot();
        this.add((Component)this.m_oSortTreeTablePanel, "Center");
    }

    @Override
    public void updateOprDetailsInfo(String strOprId, IsolationTaskInfoObj oTaskInfoObj, boolean isRefresh) {
        this.m_rootNode.removeAllChildren();
        this.m_strOperationId = strOprId;
        this.m_oSortTreeTablePanel.setVisible(false);
        this.m_oCurrentSelectedTaskInfoObj = oTaskInfoObj;
        if (null != oTaskInfoObj && !"".equals(strOprId)) {
            Resource oRes = oTaskInfoObj.getResource();
            this.m_oSortTreeTablePanel.setVisible(true);
            ITaskSubOperation oTaskOprDetails = null;
            SubOprCheckItemDetails oOprDetails = null;
            HashMap<String, SubOperationObject> oNodeList = null;
            ArrayList<String> oOrderList = null;
            oTaskOprDetails = oRes.getSubOprInfo(OperationIdStore.getInstance().getOperationId(this.m_strOperationId));
            if (null != oTaskOprDetails && oTaskOprDetails.mustShowData() && null != (oOprDetails = oTaskOprDetails.getSubOprObject())) {
                oNodeList = oOprDetails.getNodeList();
                oOrderList = oOprDetails.getOrderList();
                this.createNode(oNodeList, oOrderList, oTaskOprDetails.hasCheckItems(), oRes);
            }
            this.m_oSortTreeTablePanel.expandTree(this.m_rootNode);
        }
        this.m_oSortTreeTablePanel.updateTreeTable();
    }

    private void createNode(HashMap<String, SubOperationObject> oNodeList, ArrayList<String> oOrderList, boolean bHasCheckItems, Resource oRes) {
        if (0 == oNodeList.size()) {
            return;
        }
        DeviceTypeInfo oDevType = DeviceInfoManagerImpl.getInstance().getDevice(oRes.getDeviceID()).getDeviceTypeInfo();
        SubOperationObject oObj = null;
        Calendar oCompleteStartTime = null;
        Calendar oCompleteEndTime = null;
        int iCompleteResult = -1;
        String oPID = "";
        String strRoot = "";
        IsolationDevOprDetailInfoObj oOperationNodeInfo = null;
        IsolationDevOprDetailInfoObj oRow = null;
        TreeTableNode oOperationNode = null;
        int iSize = oOrderList.size();
        int iSelectedDevID = oRes.getDeviceID();
        for (int j = 0; j < iSize; ++j) {
            int iCompare;
            oObj = oNodeList.get(oOrderList.get(j));
            if (null == oObj || -1 != oObj.getDeviceID() && iSelectedDevID != oObj.getDeviceID()) continue;
            oRow = new IsolationDevOprDetailInfoObj();
            oRow.setNodeId(oObj.getNodeID());
            oRow.setName(DCFrameWorkUtil.getLocalizedString(oObj.getNodeID()));
            boolean isHaveOprTime = true;
            if (null != oObj.getOprNodeAttributes().getStartTime()) {
                oRow.setOprStartTime(oObj.getOprNodeAttributes().getStartTime());
                if (null == oCompleteStartTime) {
                    oCompleteStartTime = oObj.getOprNodeAttributes().getStartTime();
                } else {
                    iCompare = oCompleteStartTime.getTime().compareTo(oObj.getOprNodeAttributes().getStartTime().getTime());
                    if (0 == iCompare || 0 < iCompare) {
                        oCompleteStartTime = oObj.getOprNodeAttributes().getStartTime();
                    }
                }
            } else {
                isHaveOprTime = false;
            }
            if (null != oObj.getOprNodeAttributes().getEndTime()) {
                oRow.setOprEndTime(oObj.getOprNodeAttributes().getEndTime());
                if (null == oCompleteEndTime) {
                    oCompleteEndTime = oObj.getOprNodeAttributes().getEndTime();
                } else {
                    iCompare = oCompleteEndTime.getTime().compareTo(oObj.getOprNodeAttributes().getEndTime().getTime());
                    if (0 == iCompare || 0 > iCompare) {
                        oCompleteEndTime = oObj.getOprNodeAttributes().getEndTime();
                    }
                }
            } else {
                isHaveOprTime = false;
            }
            if (isHaveOprTime) {
                iCompleteResult = this.doOperationTime(oRow, oObj, iCompleteResult, oDevType);
            }
            oOperationNode = new TreeTableNode(oRow);
            oPID = Normalizer.normalize(oObj.getParentID(), Normalizer.Form.NFC);
            strRoot = Normalizer.normalize("", Normalizer.Form.NFC);
            if (Collator.getInstance().equals(oPID, strRoot)) {
                oOperationNodeInfo = oRow;
                this.m_rootNode.add(oOperationNode);
                oRow.setNodeType(1);
            } else {
                oRow.setNodeType(2);
                TreeTableNode oSubOprNode = this.getParentNode(this.m_rootNode, oPID);
                if (null != oSubOprNode) {
                    if (StringUtils.isIPV4(oObj.getNodeID()) && 0 == StringUtils.compareStr(oObj.getParentID(), "Connectivity") && !oRes.getDeviceIP().equals(oObj.getNodeID())) continue;
                    oSubOprNode.add(oOperationNode);
                }
            }
            oRow = null;
            oOperationNode = null;
            oPID = "";
            strRoot = "";
        }
        if (null != oOperationNodeInfo) {
            oOperationNodeInfo.setOprStartTime(oCompleteStartTime);
            oOperationNodeInfo.setOprEndTime(oCompleteEndTime);
            oOperationNodeInfo.setResult(iCompleteResult, oOperationNodeInfo.getNodeId());
        }
    }

    private TreeTableNode getParentNode(TreeTableNode oNode, String oParentID) {
        boolean bParentFound = false;
        String strPID = DCFrameWorkUtil.getLocalizedString(oParentID);
        strPID = Normalizer.normalize(strPID, Normalizer.Form.NFC);
        IsolationDevOprDetailInfoObj oNodeInfo = (IsolationDevOprDetailInfoObj)oNode.getUserObject();
        if (null != oNodeInfo && oNodeInfo.getName().equals(oParentID)) {
            return oNode;
        }
        int iChildCount = oNode.getChildCount();
        TreeTableNode oTemp = null;
        TreeTableNode oReqNode = null;
        for (int i = 0; i < iChildCount; ++i) {
            oTemp = (TreeTableNode)oNode.getChildAt(i);
            oReqNode = this.getParentNode(oTemp, oParentID);
            if (null == oReqNode) continue;
            bParentFound = true;
            oTemp = oReqNode;
            break;
        }
        strPID = null;
        if (bParentFound) {
            return oTemp;
        }
        return null;
    }

    private boolean isShowLinkRender(int iCurrentOprID) {
        return 4 == iCurrentOprID || 16 == iCurrentOprID || 28 == iCurrentOprID || 29 == iCurrentOprID;
    }

    @Override
    public void handleMouseClickEvent(MouseEvent mouseEvent) {
    }

    @Override
    public void updateSelectionState() {
    }

    private void showCheckItemReport(String strCheckItem) {
        int iCurrentOprID = OperationIdStore.getInstance().getOperationId(this.m_strOperationId);
        int iReportType = -1;
        if (iCurrentOprID == 4) {
            iReportType = 0;
        } else if (iCurrentOprID == 16) {
            iReportType = 1;
        } else if (iCurrentOprID == 28) {
            iReportType = 3;
        } else if (iCurrentOprID == 29) {
            iReportType = 4;
        }
        if (3 == iReportType) {
            AsnUpgradeFeasibilityRsp oAsnUpgradeFeasibilityRsp = this.getUFCResultInfo(strCheckItem, iReportType);
            UpgradeFeasibilityValidationManager.getInstance().showReportDlg(oAsnUpgradeFeasibilityRsp);
        } else {
            List<String> oCmdResult = this.getCommandResultInfo(strCheckItem, iReportType);
            this.showCheckReportDlg(strCheckItem, iReportType, oCmdResult);
        }
    }

    private List<String> getCommandResultInfo(String strChkItem, int iReportType) {
        List<String> oTaskResultList = null;
        AsnDCGetDetailResultRsp oAsnDCGetDetailResultRsp = null;
        try {
            oAsnDCGetDetailResultRsp = TaskSyncCommController.getInstance().getDetailsResultList(this.m_oCurrentSelectedTaskInfoObj.getTaskId(), this.m_oCurrentSelectedTaskInfoObj.getDevId(), iReportType, strChkItem);
        }
        catch (DCException e) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("GET_COMMAND_RESULT_ERROR"), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
            return null;
        }
        if (3 != oAsnDCGetDetailResultRsp.enOperationId.value) {
            oTaskResultList = TaskCommUtil.getCommandResultList(oAsnDCGetDetailResultRsp.oAsnDCGetCommandResultRsp);
        }
        return oTaskResultList;
    }

    private AsnUpgradeFeasibilityRsp getUFCResultInfo(String strChkItem, int iReportType) {
        AsnDCGetDetailResultRsp oAsnDCGetDetailResultRsp = null;
        try {
            oAsnDCGetDetailResultRsp = TaskSyncCommController.getInstance().getDetailsResultList(this.m_oCurrentSelectedTaskInfoObj.getTaskId(), this.m_oCurrentSelectedTaskInfoObj.getDevId(), iReportType, strChkItem);
        }
        catch (DCException e) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("GET_COMMAND_RESULT_ERROR"), ResourceManager.getInstance().getResString("ERROR"), 0);
        }
        if (null == oAsnDCGetDetailResultRsp || 3 != oAsnDCGetDetailResultRsp.enOperationId.value) {
            return null;
        }
        return oAsnDCGetDetailResultRsp.oAsnUpgradeFeasibilityRsp;
    }

    private void showCheckReportDlg(String strCheckItem, int iReportType, List<String> oCmdResult) {
        String strContent = "";
        if (null != oCmdResult) {
            if (0 == iReportType || 1 == iReportType || 4 == iReportType) {
                strContent = oCmdResult.get(0);
            }
            ViewCommandResultDialog oDialog = null;
            String strChkItem = Normalizer.normalize(strCheckItem, Normalizer.Form.NFC);
            String strAlarmID = Normalizer.normalize("ALARM", Normalizer.Form.NFC);
            String strHealthID = Normalizer.normalize("HEALTH", Normalizer.Form.NFC);
            Collator oEquals = Collator.getInstance();
            if (oEquals.equals(strChkItem, strAlarmID) || oEquals.equals(strChkItem, strHealthID)) {
                strCheckItem = strCheckItem + "_" + this.m_oCurrentSelectedTaskInfoObj.getResName() + "_" + this.getShowDevIdInfo(this.m_oCurrentSelectedTaskInfoObj.getDevId());
                oDialog = new ViewCommandResultDialog(strContent, strCheckItem);
            } else {
                oDialog = new ViewCommandResultDialog(strContent);
            }
            oDialog.setTitle(ResourceManager.getInstance().getResString("VIEW_COMMAND_RESULT_TITLE"));
            oDialog.setVisible(true);
        }
    }

    private String getShowDevIdInfo(int iDevId) {
        DeviceInfo devInfo = DeviceInfoManagerImpl.getInstance().getDevice(iDevId);
        if (null == devInfo) {
            return DeviceInfoUtil.parseNEIDInt(iDevId);
        }
        if (2 == devInfo.getProtocol()) {
            return DeviceInfoUtil.parseNEIDInt(devInfo.getNEDevId());
        }
        return devInfo.getNeTId();
    }

    private int doOperationTime(IsolationDevOprDetailInfoObj oRow, SubOperationObject oObj, int iCompleteResult, DeviceTypeInfo oDevType) {
        oRow.setResult(oObj.getOprNodeAttributes().getOprResult(), oRow.getNodeId());
        int iRtnValue = iCompleteResult;
        if (-1 == iCompleteResult) {
            iRtnValue = oObj.getOprNodeAttributes().getOprResult();
        } else if (oObj.getOprNodeAttributes().getOprResult() > iCompleteResult) {
            iRtnValue = oObj.getOprNodeAttributes().getOprResult();
        }
        int iOprId = OperationIdStore.getInstance().getOperationId(this.m_strOperationId);
        if (this.isShowLinkRender(iOprId)) {
            boolean bShow = true;
            if (28 == iOprId && oObj.getOprNodeAttributes().getErrorCode() == 0 && null != oDevType && DeviceInfoUtil.isPTNDevice(oDevType.getDevTypeID())) {
                bShow = false;
            }
            if (bShow) {
                oRow.setIsLink(true);
                oRow.setErrDetails(m_strPrefix + DCFrameWorkUtil.getLocalizedString("CHECK_REPORT_VIEW_DETAIL") + m_strPostfix);
            }
        } else if (null != oObj.getOprNodeAttributes().getErrorInfo()) {
            if (999293081 == oObj.getOprNodeAttributes().getErrorCode()) {
                ErrorInfo oErrInfo = oObj.getOprNodeAttributes().getErrorCodeInfo();
                oRow.setErrCode(oErrInfo.getErrorCode());
                oRow.setErrDetails(oErrInfo.toString());
            } else {
                oRow.setErrDetails(oObj.getOprNodeAttributes().getErrorInfo());
            }
        } else {
            oRow.setErrDetails(DCFrameWorkUtil.getLocalizedString(oObj.getOprNodeAttributes().getDescription()));
        }
        return iRtnValue;
    }

    private class OperationTableMouseListener
    extends MouseAdapter {
        private OperationTableMouseListener() {
        }

        @Override
        public void mouseExited(MouseEvent oMouseEvent) {
            DCFrameWorkUtil.setCursor(IsolationDevOperationDetailsPanel.this.getParent(), Cursor.getDefaultCursor());
        }

        @Override
        public void mouseClicked(MouseEvent oMouseEvent) {
            Point oPoint = oMouseEvent.getPoint();
            JSortTreeTable oTreeTable = IsolationDevOperationDetailsPanel.this.m_oSortTreeTablePanel.getTreeTable();
            int iCol = oTreeTable.columnAtPoint(oPoint);
            if (4 != iCol) {
                return;
            }
            int iRow = oTreeTable.rowAtPoint(oPoint);
            TreePath oTreePath = oTreeTable.getTree().getPathForRow(iRow);
            if (null == oTreePath) {
                return;
            }
            TreeTableNode node = (TreeTableNode)oTreePath.getLastPathComponent();
            IsolationDevOprDetailInfoObj nodeInfo = (IsolationDevOprDetailInfoObj)node.getUserObject();
            if (nodeInfo.isLink()) {
                IsolationDevOperationDetailsPanel.this.showCheckItemReport(nodeInfo.getNodeId());
            }
        }
    }

    private class OperationTableMouseMotionListener
    extends MouseMotionAdapter {
        private OperationTableMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent oMouseEvent) {
            Point oPoint = oMouseEvent.getPoint();
            JSortTreeTable oTreeTable = IsolationDevOperationDetailsPanel.this.m_oSortTreeTablePanel.getTreeTable();
            int iCol = oTreeTable.columnAtPoint(oPoint);
            if (4 != iCol) {
                DCFrameWorkUtil.setCursor(IsolationDevOperationDetailsPanel.this.getParent(), Cursor.getDefaultCursor());
                return;
            }
            int iRow = oTreeTable.rowAtPoint(oPoint);
            TreePath oTreePath = oTreeTable.getTree().getPathForRow(iRow);
            if (null == oTreePath) {
                DCFrameWorkUtil.setCursor(IsolationDevOperationDetailsPanel.this.getParent(), Cursor.getDefaultCursor());
                return;
            }
            TreeTableNode node = (TreeTableNode)oTreePath.getLastPathComponent();
            IsolationDevOprDetailInfoObj nodeInfo = (IsolationDevOprDetailInfoObj)node.getUserObject();
            if (nodeInfo.isLink()) {
                DCFrameWorkUtil.setCursor(IsolationDevOperationDetailsPanel.this.getParent(), Cursor.getPredefinedCursor(12));
            } else {
                DCFrameWorkUtil.setCursor(IsolationDevOperationDetailsPanel.this.getParent(), Cursor.getDefaultCursor());
            }
        }
    }
}

