/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.isolation.view;

import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.view.JSortTreeTable;
import com.huawei.dc.common.components.treetable.view.SortTreeTablePanel;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.PopupMenuManager;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCHelpForErrCodeUtil;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.loadpatch.LoadPatchOperation;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.LoadSoftwareOperation;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import com.huawei.dc.taskmgmt.isolation.model.IsolationTaskInfoObj;
import com.huawei.dc.taskmgmt.isolation.model.IsolationTaskInfoTableModel;
import com.huawei.dc.taskmgmt.isolation.model.IsolationTaskTableInfo;
import com.huawei.dc.taskmgmt.isolation.view.IsolationOperationStatusRender;
import com.huawei.dc.taskmgmt.isolation.view.IsolationTreeNodeRender;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.ProgressInfo;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import com.huawei.dc.taskmgmt.model.TaskDataModel;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;

public abstract class AbstractIsolationTaskInfoPanel
extends JPanel {
    protected static final int OPERATION_STATUS_COLUMN = 8;
    protected TreeTableNode m_rootNode;
    private static final long serialVersionUID = -2084068126745998320L;
    protected JButton m_refreshStateBtn;
    protected JButton m_continueBtn;
    protected JButton m_retryBtn;
    protected JButton m_rollbackBtn;
    protected JButton m_exportBtn;
    protected JButton m_deleteBtn;
    protected JButton m_freeIsolationBtn;
    protected JPopupMenu m_oPopupMenu;
    protected JMenuItem m_oRefreshStateMenu;
    protected JMenuItem m_oContinueMenu;
    protected JMenuItem m_oRetryMenu;
    protected JMenuItem m_oRollbackMenu;
    protected JMenuItem m_oExportMenu;
    protected JMenuItem m_oDeleteMenu;
    protected JMenuItem m_oFreeIsolationMenu;
    ResourceManager m_oResMgr = ResourceManager.getInstance();
    protected SortTreeTablePanel m_oSortTreeTablePanel;

    protected void initButton() {
        Dimension refreshBtnDimension = new Dimension(160, 23);
        String strRefreshStatelabel = this.m_oResMgr.getResString("ISOLATION_TASK_PANEL_REFRESH_BTN_TEXT");
        this.m_refreshStateBtn = new JButton(strRefreshStatelabel);
        this.m_refreshStateBtn.setName("com.huawei.dc.taskmgmt.isolation.view.IsolationTaskInfoPanel.m_refreshStateBtn");
        this.m_refreshStateBtn.setMnemonic('R');
        this.m_refreshStateBtn.setToolTipText(strRefreshStatelabel);
        this.m_refreshStateBtn.setPreferredSize(refreshBtnDimension);
        this.m_refreshStateBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractIsolationTaskInfoPanel.this.refreshState();
            }
        });
        Dimension btnDimension = new Dimension(110, 23);
        this.m_continueBtn = new JButton(this.m_oResMgr.getResString("ISOLATION_TASK_PANEL_CONTINUE_BTN_TEXT"));
        this.m_continueBtn.setName("com.huawei.dc.taskmgmt.isolation.view.IsolationTaskInfoPanel.m_continueBtn");
        this.m_continueBtn.setMnemonic('C');
        this.m_continueBtn.setPreferredSize(btnDimension);
        this.m_continueBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractIsolationTaskInfoPanel.this.continueOperation();
            }
        });
        this.m_retryBtn = new JButton(this.m_oResMgr.getResString("ISOLATION_TASK_PANEL_RETRY_BTN_TEXT"));
        this.m_retryBtn.setName("com.huawei.dc.taskmgmt.isolation.view.IsolationTaskInfoPanel.m_retryBtn");
        this.m_retryBtn.setMnemonic('T');
        this.m_retryBtn.setPreferredSize(btnDimension);
        this.m_retryBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractIsolationTaskInfoPanel.this.retry();
            }
        });
        this.m_rollbackBtn = new JButton(this.m_oResMgr.getResString("ISOLATION_TASK_PANEL_ROLLBACK_BTN_TEXT"));
        this.m_rollbackBtn.setName("com.huawei.dc.taskmgmt.isolation.view.IsolationTaskInfoPanel.m_rollbackBtn");
        this.m_rollbackBtn.setMnemonic('O');
        this.m_rollbackBtn.setPreferredSize(btnDimension);
        this.m_rollbackBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractIsolationTaskInfoPanel.this.rollback();
            }
        });
        this.m_exportBtn = new JButton(this.m_oResMgr.getResString("ISOLATION_TASK_PANEL_EXPORT_BTN_TEXT"));
        this.m_exportBtn.setName("com.huawei.dc.taskmgmt.isolation.view.IsolationTaskInfoPanel.m_exportBtn");
        this.m_exportBtn.setMnemonic('E');
        this.m_exportBtn.setPreferredSize(btnDimension);
        this.m_exportBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractIsolationTaskInfoPanel.this.export();
            }
        });
        this.m_deleteBtn = new JButton(this.m_oResMgr.getResString("ISOLATION_TASK_PANEL_DELETE_BTN_TEXT"));
        this.m_deleteBtn.setName("com.huawei.dc.taskmgmt.isolation.view.IsolationTaskInfoPanel.m_deleteBtn");
        this.m_deleteBtn.setMnemonic('D');
        this.m_deleteBtn.setPreferredSize(btnDimension);
        this.m_deleteBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractIsolationTaskInfoPanel.this.delete();
            }
        });
        this.m_freeIsolationBtn = new JButton(this.m_oResMgr.getResString("ISOLATION_TASK_PANEL_FREE_ISOLATION_BTN_TEXT"));
        this.m_freeIsolationBtn.setName("com.huawei.dc.taskmgmt.isolation.view.IsolationTaskInfoPanel.m_freeIsolationBtn");
        this.m_freeIsolationBtn.setMnemonic('F');
        this.m_freeIsolationBtn.setPreferredSize(btnDimension);
        this.m_freeIsolationBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractIsolationTaskInfoPanel.this.freeIsolationBoard();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2, 10, 5));
        buttonPanel.add(this.m_refreshStateBtn);
        buttonPanel.add(this.m_continueBtn);
        buttonPanel.add(this.m_retryBtn);
        buttonPanel.add(this.m_rollbackBtn);
        buttonPanel.add(this.m_exportBtn);
        buttonPanel.add(this.m_freeIsolationBtn);
        buttonPanel.add(this.m_deleteBtn);
        this.m_oSortTreeTablePanel.getBottomPanel().add((Component)buttonPanel, "Center");
    }

    protected abstract void freeIsolationBoard();

    protected abstract void export();

    protected abstract void rollback();

    protected abstract void retry();

    protected abstract void continueOperation();

    protected abstract void delete();

    protected abstract void refreshState();

    protected void initializeDeleteKeyEventHandler() {
        ActionListener oDeleteKeyHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractIsolationTaskInfoPanel.this.deleteKey_ActionPerformed();
            }
        };
        KeyStroke oDeleteKeyStroke = KeyStroke.getKeyStroke(127, 0);
        this.registerKeyboardAction(oDeleteKeyHandler, oDeleteKeyStroke, 0);
    }

    private void deleteKey_ActionPerformed() {
        if (!this.m_deleteBtn.isEnabled()) {
            return;
        }
        this.delete();
    }

    protected void initPopupMenu() {
        PopupMenuManager oPopupMenuMgr = PopupMenuManager.getInstance();
        this.m_oPopupMenu = oPopupMenuMgr.load(this, "isolationmgmtpopupmenu");
        this.m_oRefreshStateMenu = oPopupMenuMgr.getMenuItem(this.m_oResMgr.getResString("ISOLATION_TASK_PANEL_REFRESH_BTN_TEXT"), this.m_oPopupMenu);
        this.m_oContinueMenu = oPopupMenuMgr.getMenuItem(this.m_oResMgr.getResString("ISOLATION_TASK_PANEL_CONTINUE_BTN_TEXT"), this.m_oPopupMenu);
        this.m_oRetryMenu = oPopupMenuMgr.getMenuItem(this.m_oResMgr.getResString("ISOLATION_TASK_PANEL_RETRY_BTN_TEXT"), this.m_oPopupMenu);
        this.m_oRollbackMenu = oPopupMenuMgr.getMenuItem(this.m_oResMgr.getResString("ISOLATION_TASK_PANEL_ROLLBACK_BTN_TEXT"), this.m_oPopupMenu);
        this.m_oExportMenu = oPopupMenuMgr.getMenuItem(this.m_oResMgr.getResString("ISOLATION_TASK_PANEL_EXPORT_BTN_TEXT"), this.m_oPopupMenu);
        this.m_oDeleteMenu = oPopupMenuMgr.getMenuItem(this.m_oResMgr.getResString("ISOLATION_TASK_PANEL_DELETE_BTN_TEXT"), this.m_oPopupMenu);
        this.m_oFreeIsolationMenu = oPopupMenuMgr.getMenuItem(this.m_oResMgr.getResString("ISOLATION_TASK_PANEL_FREE_ISOLATION_BTN_TEXT"), this.m_oPopupMenu);
    }

    protected void jInit() {
        IsolationTaskTableInfo m_oTaskTableInfo = new IsolationTaskTableInfo();
        IsolationTaskInfoTableModel taskTableModel = new IsolationTaskInfoTableModel(m_oTaskTableInfo);
        this.m_oSortTreeTablePanel = new SortTreeTablePanel(taskTableModel);
        this.m_oSortTreeTablePanel.setName("com.huawei.dc.taskmgmt.isolation.view.IsolationTaskInfoPanel.m_oSortTreeTablePanel");
        this.m_oSortTreeTablePanel.getTreeTable().setDefaultRenderer(ProgressInfo.class, new IsolationOperationStatusRender());
        this.m_oSortTreeTablePanel.getTreeTable().getTree().setCellRenderer(new IsolationTreeNodeRender());
        this.m_oSortTreeTablePanel.getTreeTable().addMouseMotionListener(this.generateMouseMotionAdapter());
        this.m_rootNode = this.m_oSortTreeTablePanel.getRoot();
        this.initButton();
        this.initializeDeleteKeyEventHandler();
        this.add((Component)this.m_oSortTreeTablePanel, "Center");
    }

    MouseMotionAdapter generateMouseMotionAdapter() {
        return new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent oMouseEvent) {
                Point oPoint = oMouseEvent.getPoint();
                JSortTreeTable oSortTreeTable = AbstractIsolationTaskInfoPanel.this.m_oSortTreeTablePanel.getTreeTable();
                if (oSortTreeTable.columnAtPoint(oPoint) == 8) {
                    Object oValue = oSortTreeTable.getValueAt(oSortTreeTable.rowAtPoint(oPoint), 8);
                    if (oValue instanceof ResourceProgressInfo) {
                        ResourceProgressInfo progressInfo = (ResourceProgressInfo)oValue;
                        if (1 != progressInfo.getState() && DCHelpForErrCodeUtil.isShowHyperlink(progressInfo.getErrorNo())) {
                            Cursor cur = 995098636 == progressInfo.getErrorNo() ? new Cursor(0) : new Cursor(12);
                            DCFrameWorkUtil.setCursor(AbstractIsolationTaskInfoPanel.this.getParent(), cur);
                        } else {
                            Cursor cur = new Cursor(0);
                            DCFrameWorkUtil.setCursor(AbstractIsolationTaskInfoPanel.this.getParent(), cur);
                        }
                    } else {
                        Cursor cur = new Cursor(0);
                        DCFrameWorkUtil.setCursor(AbstractIsolationTaskInfoPanel.this.getParent(), cur);
                    }
                } else {
                    Cursor cur = new Cursor(0);
                    DCFrameWorkUtil.setCursor(AbstractIsolationTaskInfoPanel.this.getParent(), cur);
                }
            }
        };
    }

    protected void initProgressDlg(int iReqId, int iCmdCode, String strTitle) {
        String[] columnNames = new String[]{ResourceManager.getInstance().getResString("DEVICE_NAME"), ResourceManager.getInstance().getResString("OPERATE_RESULT")};
        this.initProgressDlg(iReqId, iCmdCode, strTitle, columnNames, null);
    }

    protected void initProgressDlg(int iReqId, int iCmdCode, String strTitle, HashMap<Integer, String> oBoardInfoMap) {
        String[] columnNames = new String[]{ResourceManager.getInstance().getResString("DEVICE_NAME"), ResourceManager.getInstance().getResString("OPERATE_RESULT")};
        this.initProgressDlg(iReqId, iCmdCode, strTitle, columnNames, oBoardInfoMap);
    }

    protected abstract void initProgressDlg(int var1, int var2, String var3, String[] var4, HashMap<Integer, String> var5);

    protected IsolationTaskInfoObj getNodeInfo(int iTaskId, int iDevId) {
        IsolationTaskInfoObj nodeInfoObj;
        TreeTableNode tmpNode = this.getNode(iTaskId, iDevId);
        if (null != tmpNode && null != (nodeInfoObj = (IsolationTaskInfoObj)tmpNode.getUserObject())) {
            return nodeInfoObj;
        }
        return null;
    }

    protected TreeTableNode getNode(int iTaskId, int iDevId) {
        return this.getNode(iTaskId, iDevId, -1);
    }

    protected TreeTableNode getNode(int iTaskId, int iDevId, int iSlotId) {
        IsolationTaskInfoObj taskNodeInfoObj;
        IsolationTaskInfoObj taskNodeInfoObj2;
        IsolationTaskInfoObj taskNodeInfoObj3;
        int iTaskCount = this.m_rootNode.getChildCount();
        TreeTableNode oNode = null;
        for (int i = 0; i < iTaskCount && (taskNodeInfoObj3 = (IsolationTaskInfoObj)(oNode = (TreeTableNode)this.m_rootNode.getChildAt(i)).getUserObject()).getTaskId() != iTaskId; ++i) {
            oNode = null;
        }
        if (null == oNode) {
            return null;
        }
        if (0 > iDevId) {
            return oNode;
        }
        TreeTableNode oTaskNode = oNode;
        int iDevCount = oNode.getChildCount();
        for (int i = 0; i < iDevCount && (taskNodeInfoObj2 = (IsolationTaskInfoObj)(oNode = (TreeTableNode)oTaskNode.getChildAt(i)).getUserObject()).getDevId() != iDevId; ++i) {
            oNode = null;
        }
        if (null == oNode) {
            return null;
        }
        if (0 > iSlotId) {
            return oNode;
        }
        TreeTableNode oDevNode = oNode;
        int iSlotCount = oDevNode.getChildCount();
        for (int i = 0; i < iSlotCount && (taskNodeInfoObj = (IsolationTaskInfoObj)(oNode = (TreeTableNode)oDevNode.getChildAt(i)).getUserObject()).getSlotId() != iSlotId; ++i) {
            oNode = null;
        }
        return oNode;
    }

    protected void initOprInfoForResource(int iTaskId, Resource oRes) {
        if (null == oRes) {
            return;
        }
        ITask oTask = TaskDataModel.getInstance().getTask(iTaskId);
        if (!oRes.isSubOprInfoEmpty()) {
            return;
        }
        if (null != oTask) {
            List<ITaskDeviceOperation> oSupportedOpList = oTask.getSupportedOperation();
            ITaskDeviceOperation oTaskDevOp = null;
            int iSizeOfList = oSupportedOpList.size();
            for (int i = 0; i < iSizeOfList; ++i) {
                oTaskDevOp = oSupportedOpList.get(i);
                if (null == oTaskDevOp || !oTaskDevOp.isSelected()) continue;
                if (oTaskDevOp instanceof LoadSoftwareOperation) {
                    ((LoadSoftwareOperation)oTaskDevOp).setDevID(oRes.getDeviceID());
                }
                if (oTaskDevOp instanceof LoadPatchOperation) {
                    ((LoadPatchOperation)oTaskDevOp).setDevID(oRes.getDeviceID());
                }
                oRes.addSubOprListInfo(oTaskDevOp.getOperationId(), oTaskDevOp.getSubOperationData());
            }
        }
    }

    protected void createTaskAndDevNode(ITask oTask, int iDevId) {
        TreeTableNode oTaskNode = this.getNode(oTask.getTaskId(), -1);
        if (null == oTaskNode) {
            IsolationTaskInfoObj taskInfoObj = new IsolationTaskInfoObj();
            taskInfoObj.setTaskType(oTask.getTaskTypeId());
            taskInfoObj.setTaskId(oTask.getTaskId());
            taskInfoObj.setResName(oTask.getTaskName());
            oTaskNode = new TreeTableNode(taskInfoObj);
            this.m_rootNode.add(oTaskNode);
        }
        DeviceType oDevType = oTask.getSelectedDeviceType();
        THashSet<Resource> oResources = oDevType.getResources();
        Iterator oResItor = oResources.iterator();
        Resource oResource = null;
        while (oResItor.hasNext()) {
            oResource = (Resource)oResItor.next();
            if (0 < iDevId) {
                if (iDevId != oResource.getDeviceID()) continue;
                this.createDevNode(oResource, oTaskNode, oTask.getTaskId());
                break;
            }
            this.createDevNode(oResource, oTaskNode, oTask.getTaskId());
        }
    }

    protected void createTaskAndAllDevNode(ITask oTask) {
        this.createTaskAndDevNode(oTask, -1);
    }

    protected void createTaskAndAppointedDevNode(int iTaskId, int iDevId) {
        ITask oTask = TaskDataModel.getInstance().getTask(iTaskId);
        this.createTaskAndDevNode(oTask, iDevId);
    }

    protected void createDevNode(Resource oRes, TreeTableNode oTaskNode, int iTaskID) {
        IsolationTaskInfoObj devInfoObj = new IsolationTaskInfoObj((IsolationTaskInfoObj)oTaskNode.getUserObject());
        devInfoObj.setResource(oRes);
        devInfoObj.setTaskId(iTaskID);
        devInfoObj.setDevId(oRes.getDeviceID());
        devInfoObj.setResName(oRes.getDeviceName());
        devInfoObj.setResAddress(oRes.getDeviceIP());
        devInfoObj.setResType(oRes.getDeviceType());
        devInfoObj.setOriginalVersion(oRes.getOriginalVersion());
        devInfoObj.setTargetVersion(oRes.getUpgradeVersion());
        devInfoObj.setCurrentOperation(oRes.getProgressInfo().getCurrentOperationName());
        devInfoObj.setLoadingState(TaskCommUtil.getSWDLStatusRes(oRes.getSWDLStatus()));
        TreeTableNode oDevNode = new TreeTableNode(devInfoObj);
        oTaskNode.add(oDevNode);
        this.createBoardNode(oDevNode, iTaskID, oRes.getDeviceID());
    }

    protected void createBoardNode(TreeTableNode oDevNode, int iTaskId, int iDevId) {
        ITask oTask = TaskDataModel.getInstance().getTask(iTaskId);
        List<IsolationTaskInfoObj> oIsolationBoardLst = oTask.getIsolationBoardLst(iDevId);
        if (null != oIsolationBoardLst) {
            IsolationTaskInfoObj oDevNodeInfoObj = (IsolationTaskInfoObj)oDevNode.getUserObject();
            int iBoardCount = oIsolationBoardLst.size();
            for (int i = 0; i < iBoardCount; ++i) {
                IsolationTaskInfoObj oBoardInfoObj = oIsolationBoardLst.get(i);
                oBoardInfoObj.setParentObj(oDevNodeInfoObj);
                TreeTableNode oBoardNode = new TreeTableNode(oBoardInfoObj);
                oDevNode.add(oBoardNode);
            }
        }
    }

    protected int getSelectingRow(int iTaskId, int iDevId) {
        JTree tree = this.m_oSortTreeTablePanel.getTreeTable().getTree();
        int iRowCount = this.m_oSortTreeTablePanel.getTreeTable().getRowCount();
        TreePath oTreePath = null;
        for (int i = 0; i < iRowCount; ++i) {
            TreeTableNode tmpNode;
            IsolationTaskInfoObj nodeInfoObj;
            oTreePath = tree.getPathForRow(i);
            if (null == oTreePath || iTaskId != (nodeInfoObj = (IsolationTaskInfoObj)(tmpNode = (TreeTableNode)oTreePath.getLastPathComponent()).getUserObject()).getTaskId()) continue;
            if (0 > iDevId) {
                return i;
            }
            if (iDevId != nodeInfoObj.getDevId()) continue;
            return i;
        }
        return -1;
    }

    public List<IsolationTaskInfoObj> getSelectedNodeInfos() {
        ArrayList<IsolationTaskInfoObj> selectedNodeInfoLst = new ArrayList<IsolationTaskInfoObj>();
        int[] iSelectedRows = this.m_oSortTreeTablePanel.getTreeTable().getSelectedRows();
        JTree tree = this.m_oSortTreeTablePanel.getTreeTable().getTree();
        if (null != iSelectedRows && 0 < iSelectedRows.length) {
            for (int i = 0; i < iSelectedRows.length; ++i) {
                TreePath oTreePath = tree.getPathForRow(iSelectedRows[i]);
                if (null == oTreePath) continue;
                TreeTableNode oNode = null;
                oNode = (TreeTableNode)oTreePath.getLastPathComponent();
                if (!(oNode.getUserObject() instanceof IsolationTaskInfoObj)) continue;
                selectedNodeInfoLst.add((IsolationTaskInfoObj)oNode.getUserObject());
            }
        }
        return selectedNodeInfoLst;
    }

    protected boolean isExecutingOpr(IsolationTaskInfoObj oNodeInfo) {
        if (1 != oNodeInfo.getNodeType()) {
            if (3 == oNodeInfo.getNodeType()) {
                oNodeInfo = oNodeInfo.getParentObj();
            }
            if (1 == oNodeInfo.getProgressInfo().getState()) {
                return true;
            }
            return this.isDevExecutingOpr(this.getNode(oNodeInfo.getTaskId(), oNodeInfo.getDevId()));
        }
        boolean isDevExecutingOpr = false;
        TreeTableNode oTaskNode = this.getNode(oNodeInfo.getTaskId(), oNodeInfo.getDevId());
        int iChildCount = oTaskNode.getChildCount();
        for (int i = 0; i < iChildCount; ++i) {
            TreeTableNode oDevNode = (TreeTableNode)oTaskNode.getChildAt(i);
            isDevExecutingOpr = this.isDevExecutingOpr(oDevNode);
            if (!isDevExecutingOpr) continue;
            return true;
        }
        return false;
    }

    private boolean isDevExecutingOpr(TreeTableNode oDevNode) {
        if (null == oDevNode) {
            return false;
        }
        int iChildCount = oDevNode.getChildCount();
        for (int i = 0; i < iChildCount; ++i) {
            TreeTableNode oBoardNode = (TreeTableNode)oDevNode.getChildAt(i);
            IsolationTaskInfoObj oBoardNodeInfo = (IsolationTaskInfoObj)oBoardNode.getUserObject();
            if (1 != oBoardNodeInfo.getProgressInfo().getState()) continue;
            return true;
        }
        return false;
    }
}

