/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.isolation.model;

import com.huawei.dc.common.components.treetable.ITreeTableNodeInfo;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.taskmgmt.isolation.IsolationCommonOperation;
import com.huawei.dc.taskmgmt.isolation.model.IsolationTaskTableInfo;
import com.huawei.dc.taskmgmt.model.ProgressInfo;
import com.huawei.dc.taskmgmt.model.Resource;
import javax.swing.Icon;

public class IsolationTaskInfoObj
implements ITreeTableNodeInfo {
    public static final int TASK_NODE = 1;
    public static final int DEVICE_NODE = 2;
    public static final int SLOT_NODE = 3;
    private int m_iTaskType = -1;
    private Icon m_oTaskTypeIcon = null;
    private int m_iTaskId = -1;
    private int m_iDevId = -1;
    private int m_iSlotId = -1;
    private int m_iSlotType = 0;
    private String m_strResName = "";
    private String m_strResAddress = "";
    private String m_strResType = "";
    private String m_strOriginalVersion = "";
    private String m_strTargetVersion = "";
    private String m_strLoadingState = "";
    private String m_strCurrentOperation = "";
    private ProgressInfo m_oProgressInfo;
    private String m_strIsolationBoardState = "";
    private Resource m_oResource;
    private boolean m_isIsolationBoard = false;
    private IsolationTaskInfoObj m_oParentObj = null;
    private static final IsolationTaskTableInfo m_oTaskTableInfo = new IsolationTaskTableInfo();

    public IsolationTaskInfoObj() {
    }

    public IsolationTaskInfoObj(IsolationTaskInfoObj oParentObj) {
        this.m_oParentObj = oParentObj;
    }

    public int getNodeType() {
        if (-1 != this.m_iSlotId) {
            return 3;
        }
        if (-1 != this.m_iDevId) {
            return 2;
        }
        return 1;
    }

    public int getTaskType() {
        return this.m_iTaskType;
    }

    public void setTaskType(int taskType) {
        this.m_iTaskType = taskType;
    }

    @Override
    public Icon getNodeIcon() {
        if (null == this.m_oTaskTypeIcon) {
            if (-1 != this.m_iSlotId) {
                this.m_oTaskTypeIcon = ResourceManager.getInstance().getImage("ic_slot_" + this.m_iSlotType + ".gif");
            } else if (-1 != this.m_iDevId) {
                this.m_oTaskTypeIcon = ResourceManager.getInstance().getNeTypeImage(this.m_iDevId);
            } else {
                int iCommonTaskType = IsolationCommonOperation.getCommonTaskTypeId(this.m_iTaskType);
                switch (iCommonTaskType) {
                    case 4: 
                    case 13: {
                        this.m_oTaskTypeIcon = ResourceManager.getInstance().getImage("package_upgrade_task.gif");
                        break;
                    }
                    case 5: 
                    case 12: {
                        this.m_oTaskTypeIcon = ResourceManager.getInstance().getImage("package_diffusion_task.gif");
                        break;
                    }
                }
            }
        }
        return this.m_oTaskTypeIcon;
    }

    public int getTaskId() {
        return this.m_iTaskId;
    }

    public void setTaskId(int taskId) {
        this.m_iTaskId = taskId;
    }

    public int getDevId() {
        return this.m_iDevId;
    }

    public void setDevId(int devId) {
        this.m_iDevId = devId;
    }

    public int getSlotId() {
        return this.m_iSlotId;
    }

    public void setSlotId(int slotId) {
        this.m_iSlotId = slotId;
    }

    public int getSlotType() {
        return this.m_iSlotType;
    }

    public void setSlotType(int slotType) {
        this.m_iSlotType = slotType;
    }

    public String getResName() {
        return this.m_strResName;
    }

    public void setResName(String resName) {
        this.m_strResName = resName;
    }

    public String getResAddress() {
        return this.m_strResAddress;
    }

    public void setResAddress(String resAddress) {
        this.m_strResAddress = resAddress;
    }

    public String getResType() {
        return this.m_strResType;
    }

    public void setResType(String resType) {
        this.m_strResType = resType;
    }

    public String getOriginalVersion() {
        return this.m_strOriginalVersion;
    }

    public void setOriginalVersion(String originalVersion) {
        this.m_strOriginalVersion = originalVersion;
    }

    public String getTargetVersion() {
        return this.m_strTargetVersion;
    }

    public void setTargetVersion(String targetVersion) {
        this.m_strTargetVersion = targetVersion;
    }

    public String getLoadingState() {
        return this.m_strLoadingState;
    }

    public void setLoadingState(String loadingState) {
        this.m_strLoadingState = loadingState;
    }

    public String getCurrentOperation() {
        if (null != this.m_oResource) {
            this.m_strCurrentOperation = this.m_oResource.getProgressInfo().getCurrentOperationName();
        }
        return this.m_strCurrentOperation;
    }

    public void setCurrentOperation(String currentOperation) {
        this.m_strCurrentOperation = currentOperation;
    }

    public ProgressInfo getProgressInfo() {
        if (null != this.m_oResource) {
            this.m_oProgressInfo = this.m_oResource.getProgressInfo();
        }
        return this.m_oProgressInfo;
    }

    public void setProgressInfo(ProgressInfo progressInfo) {
        this.m_oProgressInfo = progressInfo;
    }

    public String getStrOprStatus() {
        if (null == this.m_oProgressInfo) {
            return "";
        }
        return this.m_oProgressInfo.toString();
    }

    public void setResource(Resource oRes) {
        this.m_oResource = oRes;
    }

    public Resource getResource() {
        return this.m_oResource;
    }

    public String toString() {
        String strReturn = this.getResName();
        if (3 == this.getNodeType()) {
            return strReturn + "_" + DeviceInfoManagerImpl.getInstance().getBoardNameForT2000(this.getSlotId());
        }
        return strReturn;
    }

    public boolean isIsolationBoard() {
        return this.m_isIsolationBoard;
    }

    public void setIsolationBoard(boolean isolationBoard) {
        this.m_isIsolationBoard = isolationBoard;
        this.m_strIsolationBoardState = this.m_isIsolationBoard ? ResourceManager.getInstance().getResString("ISOLATION_TASK_IS_ISOLATION_BOARD_YES") : ResourceManager.getInstance().getResString("ISOLATION_TASK_IS_ISOLATION_BOARD_NO");
    }

    public String getIsolationBoardState() {
        return this.m_strIsolationBoardState;
    }

    public void setIsolationBoardState(String isolationBoardState) {
        this.m_strIsolationBoardState = isolationBoardState;
    }

    public void setParentObj(IsolationTaskInfoObj oParentObj) {
        this.m_oParentObj = oParentObj;
    }

    public IsolationTaskInfoObj getParentObj() {
        return this.m_oParentObj;
    }

    @Override
    public String[] getSortMethods() {
        return m_oTaskTableInfo.getSortMethods();
    }
}

