/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.isolation.controller;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCContinueIsolationDeviceReq;
import com.huawei.dc.common.asndatacenter.AsnDCDeleteIsolationDevReq;
import com.huawei.dc.common.asndatacenter.AsnDCIntegerLst;
import com.huawei.dc.common.asndatacenter.AsnDCIsolationDeviceInfo;
import com.huawei.dc.common.asndatacenter.AsnDCOpertionRsp;
import com.huawei.dc.common.asndatacenter.AsnDCRetryIsolationDeviceReq;
import com.huawei.dc.common.asndatacenter.AsnDCSyncRsp;
import com.huawei.dc.common.asndatacenter.AsnFreeIsolationBoardReq;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.GUIConstants;
import com.huawei.dc.framework.ErrorCodeReader;
import com.swimap.iview.util.SyncCommand;
import java.awt.Component;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.commustru.fstru.FStruct;

public class IsolationTaskSyncCommController
implements IDCObjectDeallocator {
    private static IsolationTaskSyncCommController m_instance = null;

    private IsolationTaskSyncCommController() {
    }

    public static IsolationTaskSyncCommController getInstance() {
        if (null == m_instance) {
            m_instance = new IsolationTaskSyncCommController();
        }
        return m_instance;
    }

    public void freeIsolationBoards(int iReqId, int iTaskID, int iDevID, List<Integer> iBoardIds) throws DCException {
        AsnFreeIsolationBoardReq asnFreeIsolationBoardReq = new AsnFreeIsolationBoardReq();
        asnFreeIsolationBoardReq.oReqID = BigInteger.valueOf(iReqId);
        asnFreeIsolationBoardReq.iTaskID = BigInteger.valueOf(iTaskID);
        asnFreeIsolationBoardReq.iDevID = BigInteger.valueOf(iDevID);
        for (int i = 0; i < iBoardIds.size(); ++i) {
            asnFreeIsolationBoardReq.iBoardIdLst.add((Object)BigInteger.valueOf(iBoardIds.get(i).intValue()));
        }
        this.handleMultipleDeviceRsp(44053, (FStruct)asnFreeIsolationBoardReq);
    }

    public void deleteIsolationDevice(int iReqId, int iTaskID, List<Integer> iDevIds) throws DCException {
        AsnDCDeleteIsolationDevReq asnDeleteIsolationDevReq = new AsnDCDeleteIsolationDevReq();
        asnDeleteIsolationDevReq.oReqID = BigInteger.valueOf(iReqId);
        asnDeleteIsolationDevReq.iTaskID = BigInteger.valueOf(iTaskID);
        for (int i = 0; i < iDevIds.size(); ++i) {
            asnDeleteIsolationDevReq.oDevIdLst.add((Object)BigInteger.valueOf(iDevIds.get(i).intValue()));
        }
        this.handleMultipleDeviceRsp(44056, (FStruct)asnDeleteIsolationDevReq);
    }

    public void continueForIsolation(int iTaskID, List<Integer> iDevIds) throws DCException {
        AsnDCContinueIsolationDeviceReq asnContinueIsolationDevReq = new AsnDCContinueIsolationDeviceReq();
        asnContinueIsolationDevReq.iTaskID = BigInteger.valueOf(iTaskID);
        for (int i = 0; i < iDevIds.size(); ++i) {
            asnContinueIsolationDevReq.oDevIdLst.add((Object)BigInteger.valueOf(iDevIds.get(i).intValue()));
        }
        this.handleDCOpertionRsp(44059, (FStruct)asnContinueIsolationDevReq);
    }

    public void retryForIsolation(int iTaskID, HashMap<Integer, List<Integer>> oDevIdMap) throws DCException {
        AsnDCRetryIsolationDeviceReq asnRetryIsolationDevReq = new AsnDCRetryIsolationDeviceReq();
        asnRetryIsolationDevReq.iTaskID = BigInteger.valueOf(iTaskID);
        Iterator<Map.Entry<Integer, List<Integer>>> oDevIdItr = oDevIdMap.entrySet().iterator();
        Map.Entry<Integer, List<Integer>> oEntry = null;
        while (oDevIdItr.hasNext()) {
            oEntry = oDevIdItr.next();
            AsnDCIsolationDeviceInfo oAsnIsolationDevInfo = new AsnDCIsolationDeviceInfo();
            Integer oDevId = oEntry.getKey();
            oAsnIsolationDevInfo.iDevID = BigInteger.valueOf(oDevId.intValue());
            List<Integer> oBoardIdLst = oEntry.getValue();
            if (null != oBoardIdLst) {
                oAsnIsolationDevInfo.oIsolationBDInfoLst = new AsnDCIntegerLst();
                int iBoardCount = oBoardIdLst.size();
                for (int i = 0; i < iBoardCount; ++i) {
                    oAsnIsolationDevInfo.oIsolationBDInfoLst.add((Object)BigInteger.valueOf(oBoardIdLst.get(i).intValue()));
                }
            }
            asnRetryIsolationDevReq.oIsoDevInfoLst.add((Object)oAsnIsolationDevInfo);
        }
        this.handleDCOpertionRsp(44062, (FStruct)asnRetryIsolationDevReq);
    }

    public void rollbackForIsolation(int iTaskID, HashMap<Integer, List<Integer>> oDevIdMap) throws DCException {
        AsnDCRetryIsolationDeviceReq asnRetryIsolationDevReq = new AsnDCRetryIsolationDeviceReq();
        asnRetryIsolationDevReq.iTaskID = BigInteger.valueOf(iTaskID);
        Iterator<Map.Entry<Integer, List<Integer>>> oDevIdItr = oDevIdMap.entrySet().iterator();
        Map.Entry<Integer, List<Integer>> oEntry = null;
        while (oDevIdItr.hasNext()) {
            oEntry = oDevIdItr.next();
            AsnDCIsolationDeviceInfo oAsnIsolationDevInfo = new AsnDCIsolationDeviceInfo();
            Integer oDevId = oEntry.getKey();
            oAsnIsolationDevInfo.iDevID = BigInteger.valueOf(oDevId.intValue());
            List<Integer> oBoardIdLst = oEntry.getValue();
            if (null != oBoardIdLst) {
                oAsnIsolationDevInfo.oIsolationBDInfoLst = new AsnDCIntegerLst();
                int iBoardCount = oBoardIdLst.size();
                for (int i = 0; i < iBoardCount; ++i) {
                    oAsnIsolationDevInfo.oIsolationBDInfoLst.add((Object)BigInteger.valueOf(oBoardIdLst.get(i).intValue()));
                }
            }
            asnRetryIsolationDevReq.oIsoDevInfoLst.add((Object)oAsnIsolationDevInfo);
        }
        this.handleDCOpertionRsp(44065, (FStruct)asnRetryIsolationDevReq);
    }

    @Override
    public void setToNULL() {
        m_instance = null;
    }

    private void handleMultipleDeviceRsp(final int iCmdCode, final FStruct oRequestData) throws DCException {
        final AsnDCSyncRsp oAsnRsp = new AsnDCSyncRsp();
        int iErrorCode = 0;
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int iErrorCode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(iCmdCode), oRequestData, (FStruct)oAsnRsp);
                return iErrorCode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (null != syncCommand.getResult()) {
            iErrorCode = (Integer)syncCommand.getResult();
        }
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
        iErrorCode = oAsnRsp.oErrorInfo.iErrorNo.intValue();
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(oAsnRsp.oErrorInfo.iErrorNo));
        }
    }

    private void handleDCOpertionRsp(final int iCmdCode, final FStruct oRequestData) throws DCException {
        final AsnDCOpertionRsp dcOpertionRsp = new AsnDCOpertionRsp();
        int iErrorCode = 0;
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int iErrorCode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(iCmdCode, 1, 4, GUIConstants.DC_SERVER_ID), oRequestData, (FStruct)dcOpertionRsp);
                return iErrorCode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (null != syncCommand.getResult()) {
            iErrorCode = (Integer)syncCommand.getResult();
        }
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
        iErrorCode = dcOpertionRsp.oErrorInfo.iErrorNo.intValue();
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(dcOpertionRsp.oErrorInfo.iErrorNo));
        }
    }
}

