/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.isolation.controller;

import com.huawei.dc.common.asndatacenter.AsnDCDeleteIsolationDevNotify;
import com.huawei.dc.common.asndatacenter.AsnFreeIsolationBoardNotify;
import com.huawei.dc.common.asndatacenter.AsnUpdateIsolationBoardStatus;
import com.huawei.dc.common.controller.AbstractDCMSGReceiver;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.swimap.iview.communicate.MSGPacketExt;
import net.commustru.fstru.FStruct;

public class IsolationTaskAsynCommController
extends AbstractDCMSGReceiver
implements IDCObjectDeallocator {
    private static IsolationTaskAsynCommController m_instance = null;
    private static final int[] CMMAND_CODES = new int[]{44056, 44053, 44070};

    private IsolationTaskAsynCommController() {
        super(CMMAND_CODES);
    }

    public static synchronized IsolationTaskAsynCommController getInstance() {
        if (null == m_instance) {
            m_instance = new IsolationTaskAsynCommController();
        }
        return m_instance;
    }

    protected void processMessage(MSGPacketExt oPacketExt) {
        try {
            int iCmdCode = oPacketExt.mheader.cmdCode;
            DCDebugTracer.trace("receive asyn msg cmdCode=" + iCmdCode);
            switch (iCmdCode) {
                case 44056: {
                    this.processDeleteIsolationDevMessage(oPacketExt);
                    break;
                }
                case 44053: {
                    this.processFreeIsolationBoardMessage(oPacketExt);
                    break;
                }
                case 44070: {
                    this.processUpdateIsolationBoardStatusMessage(oPacketExt);
                    break;
                }
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    private void processDeleteIsolationDevMessage(MSGPacketExt oPacketExt) {
        AsnDCDeleteIsolationDevNotify oAsnDeleteIsolationDevNotify = new AsnDCDeleteIsolationDevNotify();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnDeleteIsolationDevNotify, oPacketExt.getData());
        if (0 != iErrorCode) {
            DCDebugTracer.trace("decodeAsn1Data failure->: " + iErrorCode);
            return;
        }
        DCFrameWorkUtil.getIsolationTaskInfoPanel().handleDeleteIsolationDevResponse(oAsnDeleteIsolationDevNotify);
    }

    private void processFreeIsolationBoardMessage(MSGPacketExt oPacketExt) {
        AsnFreeIsolationBoardNotify oAsnFreeIsolationBoardNotify = new AsnFreeIsolationBoardNotify();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnFreeIsolationBoardNotify, oPacketExt.getData());
        if (0 != iErrorCode) {
            DCDebugTracer.trace("decodeAsn1Data failure->: " + iErrorCode);
            return;
        }
        DCFrameWorkUtil.getIsolationTaskInfoPanel().handleFreeIsolationResponse(oAsnFreeIsolationBoardNotify);
    }

    private void processUpdateIsolationBoardStatusMessage(MSGPacketExt oPacketExt) {
        AsnUpdateIsolationBoardStatus oAsnUpdateIsolationBoardStatus = new AsnUpdateIsolationBoardStatus();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnUpdateIsolationBoardStatus, oPacketExt.getData());
        if (0 != iErrorCode) {
            DCDebugTracer.trace("decodeAsn1Data failure->: " + iErrorCode);
            return;
        }
        DCFrameWorkUtil.getIsolationTaskInfoPanel().handleUpdateIsolationBoardStatusResponse(oAsnUpdateIsolationBoardStatus);
    }

    @Override
    public void setToNULL() {
        this.closeReceiver();
        m_instance = null;
    }
}

