/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.isolation;

import com.huawei.dc.common.asndatacenter.AsnIsolationBoard;
import com.huawei.dc.common.asndatacenter.AsnTaskInfo;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.model.TreeTableRowData;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import com.huawei.dc.taskmgmt.isolation.model.IsolationTaskInfoObj;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import java.text.Collator;
import java.util.List;

public class IsolationCommonOperation {
    private static final int COMMON_TASK_MASK = 255;

    public static String getResult(int iOprResult, String sourceOper) {
        String str = "";
        switch (iOprResult) {
            case 0: {
                if (null != sourceOper) {
                    String tarOper = DCFrameWorkUtil.getLocalizedString("UFC_OPERATION");
                    if (tarOper.equals(sourceOper) || "CheckFeasibility".equals(sourceOper)) {
                        str = DCFrameWorkUtil.getLocalizedString("OPERATION_COMPLETED");
                        break;
                    }
                    String preCheckOper = DCFrameWorkUtil.getLocalizedString("UPGRADE_PRECHECK");
                    String posthCheckOper = DCFrameWorkUtil.getLocalizedString("UPGRADE_POSTCHECK");
                    String alarmCheck = "ALARM";
                    String helalth = "HEALTH";
                    String extendCheck = "EXTENDCHECK";
                    if (0 == StringUtils.compareStr(preCheckOper, sourceOper) || 0 == StringUtils.compareStr(posthCheckOper, sourceOper) || 0 == StringUtils.compareStr(alarmCheck, sourceOper) || 0 == StringUtils.compareStr(helalth, sourceOper) || 0 == StringUtils.compareStr(extendCheck, sourceOper) || 0 == StringUtils.compareStr("PreCheck", sourceOper) || 0 == StringUtils.compareStr("PostCheck", sourceOper)) {
                        str = DCFrameWorkUtil.getLocalizedString("TASK_STATUS_0");
                        break;
                    }
                    str = DCFrameWorkUtil.getLocalizedString("TASK_SUCCESS_MESSAGE");
                    break;
                }
                str = DCFrameWorkUtil.getLocalizedString("TASK_SUCCESS_MESSAGE");
                break;
            }
            case 1: {
                str = DCFrameWorkUtil.getLocalizedString("TASK_FAILURE_MESSAGE");
                break;
            }
            case 2: {
                str = DCFrameWorkUtil.getLocalizedString("TASK_STATE_PAUSED");
                break;
            }
        }
        return str;
    }

    public static boolean isIsolationTask(int iTaskTypeId) {
        return 0 < (0x100 & iTaskTypeId);
    }

    public static int getCommonTaskTypeId(int iTaskTypeId) {
        return 0xFF & iTaskTypeId;
    }

    public static boolean isIsolationState(ResourceProgressInfo oResProgressInfo) {
        return null != oResProgressInfo && 995098636 == oResProgressInfo.getErrorNo();
    }

    public static boolean isIsolationStateForDownGrade(ResourceProgressInfo oResProgressInfo) {
        return null != oResProgressInfo && 1074200608 == oResProgressInfo.getErrorNo();
    }

    public static boolean isIsolationResource(TreeTableNode oNode) {
        if (null == oNode) {
            return false;
        }
        if (!(oNode.getUserObject() instanceof TreeTableRowData)) {
            return false;
        }
        if (!(oNode.getUserObject() instanceof TreeTableRowData)) {
            return false;
        }
        TreeTableRowData oRowData = (TreeTableRowData)oNode.getUserObject();
        if (3 == oRowData.getNodeType()) {
            oNode = (TreeTableNode)oNode.getParent();
            return IsolationCommonOperation.isIsolationResource(oNode);
        }
        if (!(oRowData.getUserObject() instanceof Resource)) {
            return false;
        }
        Resource oResource = (Resource)oRowData.getUserObject();
        return IsolationCommonOperation.isIsolationState(oResource.getProgressInfo());
    }

    public static void fillResourceToIsolationBoardInfo(String strOperationID, Resource oResource, ITask oTask) {
        if (oResource.getSlotId() < 0) {
            DCDebugTracer.trace("oResource.getSlotId() < 0");
            return;
        }
        int iDevId = oResource.getDeviceID();
        int iSlotId = oResource.getSlotId();
        List<IsolationTaskInfoObj> oIsolationBoardInfoObjLst = oTask.getIsolationBoardLst(iDevId);
        if (null == oIsolationBoardInfoObjLst) {
            DCDebugTracer.trace("oIsolationBoardInfoObjLst is null.");
            return;
        }
        String ROLLBACK_OPERATION_ID = ResourceManager.getInstance().getResString("ROLLBACK_OPERATION_ID");
        String MANUAL_ACTIVATE_OPERATION = ResourceManager.getInstance().getResString("MANUAL_ACTIVATE_OPERATION");
        int iBoardCount = oIsolationBoardInfoObjLst.size();
        IsolationTaskInfoObj tmpBoardInfo = null;
        for (int i = 0; i < iBoardCount; ++i) {
            tmpBoardInfo = oIsolationBoardInfoObjLst.get(i);
            if (iSlotId != tmpBoardInfo.getSlotId()) continue;
            ResourceProgressInfo oResourceProgress = oResource.getProgressInfo();
            if (!strOperationID.equals(oResourceProgress.getCurrentOperationId())) {
                oResourceProgress.setCurrentOperationId(strOperationID);
                if (Collator.getInstance().equals(strOperationID, "Rollback")) {
                    oResourceProgress.setCurrentOperationName(ROLLBACK_OPERATION_ID);
                } else if (Collator.getInstance().equals(strOperationID, "ManualActivate")) {
                    oResourceProgress.setCurrentOperationName(MANUAL_ACTIVATE_OPERATION);
                } else {
                    oResourceProgress.setCurrentOperationName(TaskCommUtil.getDisplayNameForOperation(oTask.getSelectedDeviceType(), strOperationID));
                }
            }
            oResource.setSlotLabel(tmpBoardInfo.getResName());
            tmpBoardInfo.setResource(oResource);
            break;
        }
    }

    public static void fillIsolationBoards(ITask oTask, AsnTaskInfo oAsnTaskInfo) {
        if (null != oAsnTaskInfo.oAsnIsolationBoardList) {
            int iBoardCount = oAsnTaskInfo.oAsnIsolationBoardList.size();
            for (int i = 0; i < iBoardCount; ++i) {
                AsnIsolationBoard tmpIsolationBoard = (AsnIsolationBoard)oAsnTaskInfo.oAsnIsolationBoardList.get(i);
                IsolationTaskInfoObj oIsolationBoard = new IsolationTaskInfoObj();
                oIsolationBoard.setTaskId(oTask.getTaskId());
                oIsolationBoard.setDevId(tmpIsolationBoard.iDeviceId.intValue());
                if (null != tmpIsolationBoard.iSlotId) {
                    oIsolationBoard.setSlotId(tmpIsolationBoard.iSlotId.intValue());
                }
                if (null != tmpIsolationBoard.strBoardName) {
                    oIsolationBoard.setResName(new String(tmpIsolationBoard.strBoardName));
                }
                oIsolationBoard.setIsolationBoard(tmpIsolationBoard.bIsolationBd);
                oTask.addIsolationBoard(oIsolationBoard);
            }
        }
    }

    public static boolean isIsolationResourceForDownGrade(TreeTableNode oNode) {
        if (null == oNode) {
            return false;
        }
        if (!(oNode.getUserObject() instanceof TreeTableRowData)) {
            return false;
        }
        if (!(oNode.getUserObject() instanceof TreeTableRowData)) {
            return false;
        }
        TreeTableRowData oRowData = (TreeTableRowData)oNode.getUserObject();
        if (3 == oRowData.getNodeType()) {
            oNode = (TreeTableNode)oNode.getParent();
            return IsolationCommonOperation.isIsolationResource(oNode);
        }
        if (!(oRowData.getUserObject() instanceof Resource)) {
            return false;
        }
        Resource oResource = (Resource)oRowData.getUserObject();
        return IsolationCommonOperation.isIsolationStateForDownGrade(oResource.getProgressInfo());
    }
}

