/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.controller;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnCheckUpgradeDevInfo;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceType;
import com.huawei.dc.common.asndatacenter.AsnDevSetInfoLst;
import com.huawei.dc.common.asndatacenter.AsnDevUpgrModeInfo;
import com.huawei.dc.common.asndatacenter.AsnDevUpgrModeInfoLst;
import com.huawei.dc.common.asndatacenter.AsnGetDevUpgradeModeRsp;
import com.huawei.dc.common.asndatacenter.AsnUpgradeDevVersionInfo;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.controller.ITaskNotificationListener;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import com.huawei.dc.taskmgmt.controller.TaskEvent;
import com.huawei.dc.taskmgmt.controller.TaskEventID;
import com.huawei.dc.taskmgmt.controller.TaskInfoNotifier;
import com.huawei.dc.taskmgmt.controller.TaskSyncCommController;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.ValidationResult;
import com.huawei.dc.taskmgmt.view.model.TaskMgmtOperationSelecModel;
import java.util.Iterator;

public class UpgradeModeValidationManager
implements ITaskNotificationListener,
IDCObjectDeallocator {
    private static UpgradeModeValidationManager m_oInstance = null;
    private ITask m_oTaskToValidate;
    private final Object m_oSyncObj = new Object();
    private AsnGetDevUpgradeModeRsp m_oAsnGetDevUpgradeModeRsp;
    private long firstOpenTime = System.nanoTime();

    private UpgradeModeValidationManager() {
        TaskInfoNotifier.getInstance().addTaskNotificationListener(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.firstOpenTime ^ this.firstOpenTime >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UpgradeModeValidationManager other = (UpgradeModeValidationManager)obj;
        return this.firstOpenTime == other.firstOpenTime;
    }

    public static synchronized UpgradeModeValidationManager getInstance() {
        if (null == m_oInstance) {
            m_oInstance = new UpgradeModeValidationManager();
            DCObjectDestructor.getInstance().addObjectForDestructor(m_oInstance);
        }
        return m_oInstance;
    }

    public ValidationResult validateUpgradeMode(ITask oTaskDataObj) {
        this.m_oTaskToValidate = oTaskDataObj;
        ValidationResult oValidationResult = new ValidationResult();
        try {
            if (!oTaskDataObj.getIsOffLineTask()) {
                this.updateUpgradeModeFromServer();
            }
            oValidationResult.setErrorCode(0);
        }
        catch (DCException e) {
            oValidationResult.setErrorCode(-1);
            oValidationResult.setErrorMessage(e.getMessage());
            oValidationResult.setErrorType(0);
        }
        this.m_oTaskToValidate = null;
        return oValidationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUpgradeModeFromServer() throws DCException {
        DCDebugTracer.trace("[upgrade mode] updateUpgradeModeFromServer start.");
        Object object = this.m_oSyncObj;
        synchronized (object) {
            DCDebugTracer.trace("[upgrade mode] updateDevUpgradeMode start.");
            TaskSyncCommController.getInstance().updateDevUpgradeMode(this.m_oTaskToValidate);
            DCDebugTracer.trace("[upgrade mode] updateDevUpgradeMode end..");
            try {
                this.m_oSyncObj.wait(DCConstants.DEFAULT_WAIT_TIME);
            }
            catch (InterruptedException e) {
                DCDebugTracer.trace(e);
                this.m_oAsnGetDevUpgradeModeRsp = null;
            }
            DCDebugTracer.trace("[upgrade mode] after wait.");
        }
        if (null == this.m_oAsnGetDevUpgradeModeRsp) {
            DCDebugTracer.trace("[upgrade mode] get upgrade mode failed m_oAsnGetDevUpgradeModeRsp is null");
            throw new DCException(ResourceManager.getInstance().getResString("UPGRADE_MODE_REQUEST_FAIL"));
        }
        if (0 != this.m_oAsnGetDevUpgradeModeRsp.oErrorNo.iErrorNo.intValue()) {
            Resource oRes = this.m_oTaskToValidate.getSelectedDeviceType().getResource(this.m_oAsnGetDevUpgradeModeRsp.iFailedDevID.intValue());
            if (null == oRes) {
                throw new DCException(ErrorCodeReader.getInstance().getErrorDesc(this.m_oAsnGetDevUpgradeModeRsp.oErrorNo.iErrorNo));
            }
            StringBuffer strErrorMessage = new StringBuffer(ResourceManager.getInstance().getResString("UPGRADE_MODE_VALIDATION_ERROR_PREFIX"));
            strErrorMessage.append('\n').append('\t');
            strErrorMessage.append(oRes.getDeviceName());
            strErrorMessage.append('(').append(oRes.getDeviceIP());
            strErrorMessage.append(')').append('\n');
            strErrorMessage.append(ErrorCodeReader.getInstance().getErrorDesc(this.m_oAsnGetDevUpgradeModeRsp.oErrorNo.iErrorNo));
            DCDebugTracer.trace("[upgrade mode] get upgrade mode have error " + strErrorMessage.toString());
            throw new DCException(strErrorMessage.toString());
        }
        TaskCommUtil.updateDevUpgradeModeResponse(this.m_oAsnGetDevUpgradeModeRsp, this.m_oTaskToValidate);
        TaskMgmtOperationSelecModel taskMgmtOperationSelecModel = new TaskMgmtOperationSelecModel();
        if (this.m_oTaskToValidate == null) {
            return;
        }
        DeviceType deviceType = this.m_oTaskToValidate.getDeviceType();
        taskMgmtOperationSelecModel.getSupportedOperationLst(this.m_oTaskToValidate, deviceType.getDeviceTypeName(), deviceType.getDeviceTypeVersionName(), DCFrameWorkUtil.getDeviceInfoManager().getDeviceTypeInfo(deviceType.getDeviceTypeID(), deviceType.getDeviceTypeVersionID()));
        DCDebugTracer.trace("[upgrade mode] updateUpgradeModeFromServer end..");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTaskNotification(TaskEvent oEvent) {
        DCDebugTracer.trace("[upgrade mode] onTaskNotification start");
        if (null == oEvent) {
            DCDebugTracer.trace("[upgrade mode] ignore it : null == oEvent ");
            return;
        }
        if (oEvent.getTaskEventType() != TaskEventID.UPGRADE_MODE_VALIDATION) {
            DCDebugTracer.trace("[upgrade mode] ignore it : oEvent.getTaskEventType() != TaskEvent.UPGRADE_MODE_VALIDATION");
            return;
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException ex) {
            DCDebugTracer.trace(ex);
        }
        if (null == this.m_oTaskToValidate) {
            DCDebugTracer.trace("[upgrade mode] update the upgrade mode failed, m_oTaskToValidate is null.");
            if (this.m_oSyncObj != null) {
                Object object = this.m_oSyncObj;
                synchronized (object) {
                    this.m_oSyncObj.notifyAll();
                }
            } else {
                DCDebugTracer.trace("[upgrade mode] m_oSyncObj is null");
            }
            return;
        }
        if (this.m_oSyncObj != null) {
            Object object = this.m_oSyncObj;
            synchronized (object) {
                this.m_oAsnGetDevUpgradeModeRsp = (AsnGetDevUpgradeModeRsp)oEvent.getSource();
                this.m_oSyncObj.notifyAll();
                DCDebugTracer.trace("[upgrade mode] update the upgrade mode noraml.");
            }
        } else {
            DCDebugTracer.trace("[upgrade mode] m_oSyncObj is null");
        }
        DCDebugTracer.trace("[upgrade mode] onTaskNotification end..");
    }

    @Override
    public void setToNULL() {
        if (this.m_oAsnGetDevUpgradeModeRsp != null) {
            AsnDevUpgrModeInfoLst oDevUpgrModeInfoLst = this.m_oAsnGetDevUpgradeModeRsp.oDevUpgrModeInfoLst;
            int iSize = oDevUpgrModeInfoLst.size();
            for (int i = 0; i < iSize; ++i) {
                AsnDevSetInfoLst oAsnDevSetInfoLst;
                AsnDevUpgrModeInfo oDevUpgrModeInfo = (AsnDevUpgrModeInfo)oDevUpgrModeInfoLst.get(i);
                if (null == oDevUpgrModeInfo) continue;
                AsnCheckUpgradeDevInfo oCheckUpgradeDevInfo = oDevUpgrModeInfo.oCheckUpgradeDevInfo;
                AsnUpgradeDevVersionInfo oDevVersion = oCheckUpgradeDevInfo.oDevVersion;
                if (null != oDevVersion) {
                    AsnDCDeviceType oAsnDCDeviceType = oDevVersion.oDevTypeInfo;
                    oAsnDCDeviceType.strDevVersionName = null;
                    oAsnDCDeviceType.strDevTypeName = null;
                    oAsnDCDeviceType.enDeviceDomain = null;
                    oAsnDCDeviceType.iDevVersionId = null;
                    oAsnDCDeviceType.iDevTypeId = null;
                    oAsnDCDeviceType.enSnmpType = null;
                    oAsnDCDeviceType.iType = null;
                }
                if (null == (oAsnDevSetInfoLst = oCheckUpgradeDevInfo.oDevSetInfoLst)) continue;
                Iterator iteator = oAsnDevSetInfoLst.iterator();
                while (iteator.hasNext()) {
                    iteator.next();
                    iteator.remove();
                }
                oAsnDevSetInfoLst = null;
                oDevUpgrModeInfo = null;
            }
        }
        this.m_oTaskToValidate = null;
        m_oInstance = null;
    }
}

