/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.controller;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnFeasibilityBoardInfo;
import com.huawei.dc.common.asndatacenter.AsnFeasibilityBoardInfoList;
import com.huawei.dc.common.asndatacenter.AsnT2000UpgradeFeasInfoRsp;
import com.huawei.dc.common.asndatacenter.AsnUpgradeFeasCheckItemInfo;
import com.huawei.dc.common.asndatacenter.AsnUpgradeFeasCheckItemInfoLst;
import com.huawei.dc.common.asndatacenter.AsnUpgradeFeasibilityRsp;
import com.huawei.dc.common.asndatacenter.DCStringList;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.standalone.controller.IDCStandAloneSyncCtrller;
import com.huawei.dc.standalone.controller.StandAloneSyncCtrller;
import com.huawei.dc.standalone.model.T2000DevInfo;
import com.huawei.dc.taskmgmt.controller.ITaskNotificationListener;
import com.huawei.dc.taskmgmt.controller.TaskAsynCommController;
import com.huawei.dc.taskmgmt.controller.TaskEvent;
import com.huawei.dc.taskmgmt.controller.TaskInfoNotifier;
import com.huawei.dc.taskmgmt.model.TaskDataModel;
import com.huawei.dc.taskmgmt.view.common.TaskOperationResultDialog;
import com.swimap.iview.communicate.MSGListener;
import java.awt.Component;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class UpgradeFeasibilityValidationManager
implements ITaskNotificationListener,
IDCObjectDeallocator {
    private static UpgradeFeasibilityValidationManager m_oInstance = null;
    private TaskOperationResultDialog m_oOpResultDlg = null;
    private Object m_oSyncObj = new Object();
    private AsnT2000UpgradeFeasInfoRsp m_oAsnT2000UpgradeFeasInfoRsp;
    private HashMap<Integer, HashMap<Integer, Vector<Vector<String>>>> m_oPTNErrorDataModel;

    private UpgradeFeasibilityValidationManager() {
        DCFrameWorkUtil.getCommManager().addMessageListener(43991, (MSGListener)((TaskAsynCommController)TaskAsynCommController.getInstance()));
        TaskInfoNotifier.getInstance().addTaskNotificationListener(this);
        this.m_oPTNErrorDataModel = new HashMap(0);
    }

    public static synchronized UpgradeFeasibilityValidationManager getInstance() {
        if (null == m_oInstance) {
            m_oInstance = new UpgradeFeasibilityValidationManager();
            DCObjectDestructor.getInstance().addObjectForDestructor(m_oInstance);
        }
        return m_oInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTaskNotification(TaskEvent oEvent) {
        if (null == oEvent || !(oEvent.getSource() instanceof AsnT2000UpgradeFeasInfoRsp)) {
            return;
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException ex) {
            DCDebugTracer.trace(ex);
        }
        Object object = this.m_oSyncObj;
        synchronized (object) {
            DCDebugTracer.trace("Processing start for upgrade feasibility response from server");
            this.m_oAsnT2000UpgradeFeasInfoRsp = (AsnT2000UpgradeFeasInfoRsp)oEvent.getSource();
            if (null != this.m_oAsnT2000UpgradeFeasInfoRsp) {
                int iTaskID = this.m_oAsnT2000UpgradeFeasInfoRsp.iTaskId.intValue();
                boolean bLastMessage = this.m_oAsnT2000UpgradeFeasInfoRsp.bIsLast;
                int iDevID = -1;
                if (null != this.m_oAsnT2000UpgradeFeasInfoRsp.iDevId) {
                    iDevID = this.m_oAsnT2000UpgradeFeasInfoRsp.iDevId.intValue();
                    AsnUpgradeFeasCheckItemInfoLst oAsnUpgradeFeasCheckItemInfoLst = this.m_oAsnT2000UpgradeFeasInfoRsp.oAsnUpgradeFeasCheckItemInfoLst;
                    if (null == oAsnUpgradeFeasCheckItemInfoLst) {
                        return;
                    }
                    this.createErrorMsgDlgForT2000(oAsnUpgradeFeasCheckItemInfoLst, iTaskID, iDevID, bLastMessage);
                }
                if (bLastMessage) {
                    if (null == this.m_oOpResultDlg) {
                        String[] strColumnNames = new String[]{DCFrameWorkUtil.getLocalizedString("TASK_NAME"), DCFrameWorkUtil.getLocalizedString("UPGRADE_FEASIBILITY_RESOURCE_NAME"), DCFrameWorkUtil.getLocalizedString("UPGRADE_FEASIBILITY_CHECK_ITEM"), DCFrameWorkUtil.getLocalizedString("OPERATION_RESULT"), DCFrameWorkUtil.getLocalizedString("SUGGESTION")};
                        String strMessage = DCFrameWorkUtil.getLocalizedString("UPGRADE_FEASIBILITY_OPERATION_RESULT_FAILURE_MSG");
                        String strTitle = DCFrameWorkUtil.getLocalizedString("DETAILCONFIGINFO");
                        this.m_oOpResultDlg = new TaskOperationResultDialog(strTitle, 1, true, strColumnNames);
                        this.m_oOpResultDlg.setMessage(strMessage);
                        this.m_oOpResultDlg.cutomizeForUFCResult();
                        this.m_oOpResultDlg.setTableRenderer();
                        this.m_oOpResultDlg.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
                    }
                    boolean bSuccess = this.fillResultDialogForTask(iTaskID);
                    if (!this.m_oOpResultDlg.isVisible() && bSuccess) {
                        this.m_oPTNErrorDataModel.remove(iTaskID);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                UpgradeFeasibilityValidationManager.this.m_oOpResultDlg.setVisible(true);
                                UpgradeFeasibilityValidationManager.this.m_oOpResultDlg = null;
                            }
                        });
                    }
                }
            }
            DCDebugTracer.trace("Processing end for upgrade feasibility response from server");
        }
    }

    private void createErrorMsgDlgForT2000(AsnUpgradeFeasCheckItemInfoLst oAsnUpgradeFeasCheckItemInfoLst, int iTaskID, int iDevID, boolean bLastMessage) {
        HashMap<Integer, Vector<Vector<String>>> oFeasibilityDevInfo = this.getDevInfoMap(iTaskID);
        Vector oCheckItemResult = new Vector(0);
        Vector<String> oRowResult = null;
        String strCheckItem = null;
        String strOperationReason = null;
        AsnUpgradeFeasCheckItemInfo oAsnUpgradeFeasCheckItemInfo = null;
        String strHandleSuggestion = null;
        int iSize = oAsnUpgradeFeasCheckItemInfoLst.size();
        for (int i = 0; i < iSize; ++i) {
            oRowResult = new Vector<String>(0);
            oAsnUpgradeFeasCheckItemInfo = (AsnUpgradeFeasCheckItemInfo)oAsnUpgradeFeasCheckItemInfoLst.get(i);
            strHandleSuggestion = null != oAsnUpgradeFeasCheckItemInfo.strHandleSuggestion ? new String(oAsnUpgradeFeasCheckItemInfo.strHandleSuggestion) : "";
            strCheckItem = new String(oAsnUpgradeFeasCheckItemInfo.strCheckItemId);
            strOperationReason = new String(oAsnUpgradeFeasCheckItemInfo.strResult);
            oRowResult.add(strCheckItem);
            oRowResult.add(strOperationReason);
            oRowResult.add(strHandleSuggestion);
            oCheckItemResult.add(oRowResult);
        }
        oFeasibilityDevInfo.put(iDevID, oCheckItemResult);
    }

    private boolean fillResultDialogForTask(int iTaskID) {
        HashMap<Integer, Vector<Vector<String>>> oDevHashMap = this.m_oPTNErrorDataModel.get(iTaskID);
        if (null == oDevHashMap) {
            return false;
        }
        Set<Integer> oDevIDSet = oDevHashMap.keySet();
        Iterator<Integer> oDevIDItr = oDevIDSet.iterator();
        int iDevID = 0;
        DeviceInfo oDeviceInfo = null;
        String strResourceInfo = null;
        Vector<Vector<String>> oCheckItemResultVec = null;
        int iCheckItemResultVecSize = 0;
        Vector<String> oResultRow = null;
        int iResultRowSize = 0;
        int iTaskCounter = 1;
        int iDevCounter = 1;
        int iRow = 0;
        while (oDevIDItr.hasNext()) {
            iDevCounter = 1;
            iDevID = oDevIDItr.next();
            oDeviceInfo = DCFrameWorkUtil.getDeviceInfoManager().getDevice(iDevID);
            strResourceInfo = oDeviceInfo.getDeviceTypeInfo().isT2000Domain() ? oDeviceInfo.getDevName() : oDeviceInfo.getDevName() + '(' + this.getShowDevIdInfo(iDevID) + ')';
            oCheckItemResultVec = oDevHashMap.get(iDevID);
            if (null == oCheckItemResultVec) {
                return false;
            }
            iCheckItemResultVecSize = oCheckItemResultVec.size();
            for (int i = 0; i < iCheckItemResultVecSize; ++i) {
                Vector<String> oRowToDisplay = new Vector<String>(5);
                if (1 == iTaskCounter) {
                    oRowToDisplay.add(TaskDataModel.getInstance().getTask(iTaskID).getTaskName());
                } else {
                    oRowToDisplay.add("");
                }
                if (1 == iDevCounter) {
                    oRowToDisplay.add(strResourceInfo);
                } else {
                    oRowToDisplay.add("");
                }
                oResultRow = oCheckItemResultVec.get(i);
                if (null == oResultRow) {
                    return false;
                }
                iResultRowSize = oResultRow.size();
                for (int j = 0; j < iResultRowSize; ++j) {
                    oRowToDisplay.add(oResultRow.get(j));
                }
                this.m_oOpResultDlg.addRowInModel(iRow, oRowToDisplay);
                ++iRow;
                ++iTaskCounter;
                ++iDevCounter;
            }
        }
        return true;
    }

    private HashMap<Integer, Vector<Vector<String>>> getDevInfoMap(int iTaskID) {
        HashMap<Integer, Vector<Vector<String>>> oDevHashMap = this.m_oPTNErrorDataModel.get(iTaskID);
        if (null == oDevHashMap) {
            oDevHashMap = new HashMap(0);
            this.m_oPTNErrorDataModel.put(iTaskID, oDevHashMap);
        }
        return oDevHashMap;
    }

    private TaskOperationResultDialog initializeErrorDlg(String[] strColumnNames, String strMessage) {
        String strTitle = DCFrameWorkUtil.getLocalizedString("DETAILCONFIGINFO");
        TaskOperationResultDialog oOpResultDlg = new TaskOperationResultDialog(strTitle, 0, true, strColumnNames);
        oOpResultDlg.setMessage(strMessage);
        return oOpResultDlg;
    }

    private String getShowDevIdInfo(int iDevId) {
        T2000DevInfo oT2000DevInfo = null;
        IDCStandAloneSyncCtrller oStandAloneSyncCtrller = StandAloneSyncCtrller.getInstance();
        try {
            oT2000DevInfo = oStandAloneSyncCtrller.getT2000DeviceInfo(iDevId);
        }
        catch (DCException ignore) {
            return DeviceInfoUtil.parseNEIDInt(iDevId);
        }
        if (2 == oT2000DevInfo.getProtocolType()) {
            return DeviceInfoUtil.parseNEIDInt(oT2000DevInfo.getMMLProtocolPhyDevIdDeviceId());
        }
        return oT2000DevInfo.getTL1ProtocolDevPhyId();
    }

    public void showReportDlg(AsnUpgradeFeasibilityRsp oAsnUpgradeFeasibilityRsp) {
        if (null == oAsnUpgradeFeasibilityRsp) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("LOG_INFO_PAN_NO_RECORD_IN_ASN"), DCFrameWorkUtil.getLocalizedString("SUGGESTION"), 1);
            return;
        }
        int iErrorCode = oAsnUpgradeFeasibilityRsp.iErrorNo.intValue();
        if (0 != iErrorCode) {
            this.showInfoMessage(iErrorCode);
        } else if (null != oAsnUpgradeFeasibilityRsp.oAsnUpgradeFeasCheckItemInfoLst) {
            this.createT2000ReportDlg(oAsnUpgradeFeasibilityRsp.oAsnUpgradeFeasCheckItemInfoLst);
        } else if (null != oAsnUpgradeFeasibilityRsp.oBoardInfoList) {
            this.createDMSReportDlg(oAsnUpgradeFeasibilityRsp.oBoardInfoList);
        } else if (null != oAsnUpgradeFeasibilityRsp.oAvailablePatchList || null != oAsnUpgradeFeasibilityRsp.oRequiredPatchList) {
            this.createBMSReportDlg(oAsnUpgradeFeasibilityRsp.oAvailablePatchList, oAsnUpgradeFeasibilityRsp.oRequiredPatchList);
        }
    }

    private void createT2000ReportDlg(AsnUpgradeFeasCheckItemInfoLst oAsnUpgradeFeasCheckItemInfoLst) {
        String[] strColumnNames = new String[]{DCFrameWorkUtil.getLocalizedString("UPGRADE_FEASIBILITY_CHECK_ITEM"), DCFrameWorkUtil.getLocalizedString("OPERATION_RESULT"), DCFrameWorkUtil.getLocalizedString("SUGGESTION")};
        TaskOperationResultDialog oDlg = this.initializeErrorDlg(strColumnNames, DCFrameWorkUtil.getLocalizedString("UPGRADE_FEASIBILITY_OPERATION_RESULT_FAILURE_MSG"));
        oDlg.cutomizeForUFCResult();
        oDlg.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
        Vector<Object> oRowData = null;
        String strCheckItem = null;
        String strOperationReason = null;
        AsnUpgradeFeasCheckItemInfo oAsnUpgradeFeasCheckItemInfo = null;
        String strHandleSuggestion = null;
        int iSize = oAsnUpgradeFeasCheckItemInfoLst.size();
        for (int i = 0; i < iSize; ++i) {
            oRowData = new Vector<Object>(0);
            oAsnUpgradeFeasCheckItemInfo = (AsnUpgradeFeasCheckItemInfo)oAsnUpgradeFeasCheckItemInfoLst.get(i);
            strHandleSuggestion = null != oAsnUpgradeFeasCheckItemInfo.strHandleSuggestion ? new String(oAsnUpgradeFeasCheckItemInfo.strHandleSuggestion) : "";
            strCheckItem = new String(oAsnUpgradeFeasCheckItemInfo.strCheckItemId);
            strOperationReason = new String(oAsnUpgradeFeasCheckItemInfo.strResult);
            oRowData.add(strCheckItem);
            oRowData.add(strOperationReason);
            oRowData.add(strHandleSuggestion);
            oDlg.addRowInModel(oRowData);
        }
        oDlg.setVisible(true);
    }

    private void createDMSReportDlg(AsnFeasibilityBoardInfoList oBoardInfoList) {
        String[] strColumnNames = new String[]{DCFrameWorkUtil.getLocalizedString("UPGRADE_FEASIBILITY_RESOURCE_NAME"), DCFrameWorkUtil.getLocalizedString("BOARD_TYPE"), DCFrameWorkUtil.getLocalizedString("UFC_DMS_REPORT_MATCH_TABLE_HEADER"), DCFrameWorkUtil.getLocalizedString("UFC_DMS_REPORT_ITEM_LIST_TABLE_HEADER")};
        TaskOperationResultDialog oDlg = this.initializeErrorDlg(strColumnNames, DCFrameWorkUtil.getLocalizedString("UPGRADE_FEASIBILITY_OPERATION_RESULT_FAILURE_MSG"));
        oDlg.cutomizeForUFCResult();
        oDlg.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
        Vector<Object> oRowData = null;
        if (null != oBoardInfoList) {
            int iSize = oBoardInfoList.size();
            AsnFeasibilityBoardInfo oAsnFeasibilityBoardInfo = null;
            String strNoMatchItemList = "";
            String strBoardType = null;
            String strMatch = null;
            for (int i = 0; i < iSize; ++i) {
                oAsnFeasibilityBoardInfo = (AsnFeasibilityBoardInfo)oBoardInfoList.get(i);
                int iBoardId = oAsnFeasibilityBoardInfo.iBoardId.intValue();
                strBoardType = new String(oAsnFeasibilityBoardInfo.strBoardType);
                boolean bIsMatch = oAsnFeasibilityBoardInfo.bIsMatch;
                strMatch = bIsMatch ? DCFrameWorkUtil.getLocalizedString("UFC_DMS_REPORT_MATCH_YES") : DCFrameWorkUtil.getLocalizedString("UFC_DMS_REPORT_MATCH_NO");
                if (null != oAsnFeasibilityBoardInfo.strUnmachedItemList) {
                    strNoMatchItemList = new String(oAsnFeasibilityBoardInfo.strUnmachedItemList);
                }
                oRowData = new Vector<Object>(4);
                oRowData.add(DCFrameWorkUtil.getLocalizedString("SLOT_LBL") + iBoardId);
                oRowData.add(strBoardType);
                oRowData.add(strMatch);
                oRowData.add(strNoMatchItemList);
                oDlg.addRowInModel(oRowData);
            }
            oDlg.setVisible(true);
        } else {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("LOG_INFO_PAN_NO_RECORD_IN_ASN"), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
        }
    }

    private void createBMSReportDlg(DCStringList oAvailablePatchList, DCStringList oRequiredPatchList) {
        int i;
        int iSize;
        String[] strColumnNames = new String[]{DCFrameWorkUtil.getLocalizedString("BACKUP_TABLE_DEVICETYPE"), DCFrameWorkUtil.getLocalizedString("UFC_BMS_REPORT_CONTENT_TABLE_HEADER")};
        TaskOperationResultDialog oDlg = this.initializeErrorDlg(strColumnNames, DCFrameWorkUtil.getLocalizedString("UPGRADE_FEASIBILITY_OPERATION_RESULT_FAILURE_MSG"));
        oDlg.cutomizeForUFCResult();
        oDlg.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
        Vector<Object> oRowData = null;
        if (null != oAvailablePatchList) {
            iSize = oAvailablePatchList.size();
            String strAvailablePatch = null;
            for (i = 0; i < iSize; ++i) {
                strAvailablePatch = (String)oAvailablePatchList.get(i);
                oRowData = new Vector(2);
                if (0 == i) {
                    oRowData.add(DCFrameWorkUtil.getLocalizedString("UFC_BMS_REPORT_AVAILABLE_PATCHES"));
                } else {
                    oRowData.add("");
                }
                oRowData.add(strAvailablePatch);
                oDlg.addRowInModel(oRowData);
            }
        } else {
            oRowData = new Vector<Object>(2);
            oRowData.add(DCFrameWorkUtil.getLocalizedString("UFC_BMS_REPORT_AVAILABLE_PATCHES"));
            oRowData.add(DCFrameWorkUtil.getLocalizedString("UFC_BMS_REPORT_NO_PATCHES"));
            oDlg.addRowInModel(oRowData);
        }
        if (null != oRequiredPatchList) {
            iSize = oRequiredPatchList.size();
            String strRequiredPatch = null;
            for (i = 0; i < iSize; ++i) {
                strRequiredPatch = (String)oRequiredPatchList.get(i);
                oRowData = new Vector(2);
                if (0 == i) {
                    oRowData.add(DCFrameWorkUtil.getLocalizedString("UFC_BMS_REPORT_REQUIRED_PATCHES"));
                } else {
                    oRowData.add("");
                }
                oRowData.add(strRequiredPatch);
                oDlg.addRowInModel(oRowData);
            }
        } else {
            oRowData = new Vector(2);
            oRowData.add(DCFrameWorkUtil.getLocalizedString("UFC_BMS_REPORT_REQUIRED_PATCHES"));
            oRowData.add(DCFrameWorkUtil.getLocalizedString("UFC_BMS_REPORT_NO_PATCHES"));
            oDlg.addRowInModel(oRowData);
        }
        oDlg.setVisible(true);
    }

    private void showInfoMessage(int iErrorCode) {
        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode)), DCFrameWorkUtil.getLocalizedString("SUGGESTION"), 1);
    }

    @Override
    public void setToNULL() {
        this.m_oOpResultDlg = null;
        this.m_oSyncObj = null;
        this.m_oAsnT2000UpgradeFeasInfoRsp = null;
        m_oInstance = null;
    }
}

