/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.controller;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCSlaveDevInfoRsp;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.controller.ITaskNotificationListener;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import com.huawei.dc.taskmgmt.controller.TaskEvent;
import com.huawei.dc.taskmgmt.controller.TaskInfoNotifier;
import com.huawei.dc.taskmgmt.controller.TaskSyncCommController;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.view.ValidationResult;

public class UpdateSlaveDeviceInfoManager
implements ITaskNotificationListener,
IDCObjectDeallocator {
    private static UpdateSlaveDeviceInfoManager m_oInstance = null;
    private ITask m_oTaskToValidate;
    private Object m_oSyncObj = new Object();
    private AsnDCSlaveDevInfoRsp m_oAsnDCSlaveDevInfoRsp;

    private UpdateSlaveDeviceInfoManager() {
        TaskInfoNotifier.getInstance().addTaskNotificationListener(this);
    }

    public static synchronized UpdateSlaveDeviceInfoManager getInstance() {
        if (null == m_oInstance) {
            m_oInstance = new UpdateSlaveDeviceInfoManager();
            DCObjectDestructor.getInstance().addObjectForDestructor(m_oInstance);
        }
        return m_oInstance;
    }

    public ValidationResult updateSlaveInfo(ITask oTaskDataObj) {
        this.m_oTaskToValidate = oTaskDataObj;
        ValidationResult oValidationResult = new ValidationResult();
        try {
            this.getSlaveInfoFromServer();
            oValidationResult.setErrorCode(0);
        }
        catch (DCException e) {
            oValidationResult.setErrorCode(-1);
            oValidationResult.setErrorMessage(e.getMessage());
            oValidationResult.setErrorType(1);
        }
        this.m_oTaskToValidate = null;
        return oValidationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSlaveInfoFromServer() throws DCException {
        Object object = this.m_oSyncObj;
        synchronized (object) {
            TaskSyncCommController.getInstance().getSlaveDevInfo(this.m_oTaskToValidate);
            try {
                this.m_oSyncObj.wait(DCConstants.DEFAULT_WAIT_TIME);
            }
            catch (InterruptedException e) {
                DCDebugTracer.trace(e);
                this.m_oAsnDCSlaveDevInfoRsp = null;
            }
        }
        if (null != this.m_oAsnDCSlaveDevInfoRsp && 0 != this.m_oAsnDCSlaveDevInfoRsp.oErrorInfo.iErrorNo.intValue()) {
            throw new DCException(ErrorCodeReader.getInstance().getErrorDesc(this.m_oAsnDCSlaveDevInfoRsp.oErrorInfo.iErrorNo));
        }
        if (null != this.m_oAsnDCSlaveDevInfoRsp && 0 == this.m_oAsnDCSlaveDevInfoRsp.oErrorInfo.iErrorNo.intValue()) {
            TaskCommUtil.updateSlaveDevInfoResponse(this.m_oAsnDCSlaveDevInfoRsp, this.m_oTaskToValidate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTaskNotification(TaskEvent oEvent) {
        if (null == oEvent || !(oEvent.getSource() instanceof AsnDCSlaveDevInfoRsp)) {
            return;
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException ex) {
            DCDebugTracer.trace(ex);
        }
        if (null == this.m_oTaskToValidate) {
            return;
        }
        Object object = this.m_oSyncObj;
        synchronized (object) {
            this.m_oAsnDCSlaveDevInfoRsp = (AsnDCSlaveDevInfoRsp)oEvent.getSource();
            this.m_oSyncObj.notifyAll();
        }
    }

    @Override
    public void setToNULL() {
        this.m_oSyncObj = null;
        this.m_oAsnDCSlaveDevInfoRsp = null;
        m_oInstance = null;
    }
}

