/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.controller;

import com.huawei.dc.common.components.deviceselection.DeviceSelectionPanel;
import com.huawei.dc.common.components.deviceselection.table.DeviceSelectionCommTablePanel;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.taskmgmt.controller.PackageModeCheckAdapter;
import com.huawei.dc.taskmgmt.controller.PatchModeCheckAdapter;
import com.huawei.dc.taskmgmt.controller.PkgDiffDuTransmitModeCheckAdapter;
import com.huawei.dc.taskmgmt.controller.PkgDiffModeCheckAdapter;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.ValidationResult;
import com.huawei.dc.taskmgmt.view.common.IUpgradeMode;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;

public class UpModeCheckController
implements IUpgradeMode,
IDCObjectDeallocator {
    private ITask m_oTaskObj = null;
    private static UpModeCheckController m_oUpModeCheckControllerInstance;
    private long firstOpenClientTime = -1L;

    private UpModeCheckController() {
    }

    public static synchronized UpModeCheckController getInstance() {
        if (null == m_oUpModeCheckControllerInstance) {
            m_oUpModeCheckControllerInstance = new UpModeCheckController();
            DCObjectDestructor.getInstance().addObjectForDestructor(m_oUpModeCheckControllerInstance);
        }
        return m_oUpModeCheckControllerInstance;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.firstOpenClientTime ^ this.firstOpenClientTime >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UpModeCheckController other = (UpModeCheckController)obj;
        return this.firstOpenClientTime == other.firstOpenClientTime;
    }

    public ValidationResult checkUpMode(ITask oTaskObj, DeviceSelectionPanel oDeviceSelectionPanel) {
        int domain;
        ValidationResult oValidResult = new ValidationResult();
        oValidResult.setErrorCode(0);
        this.m_oTaskObj = oTaskObj;
        if (null == this.m_oTaskObj) {
            return oValidResult;
        }
        int iTaskTypeID = this.m_oTaskObj.getTaskTypeId();
        THashSet nonSupportlst = new THashSet();
        THashSet<Resource> allResoutLst = this.m_oTaskObj.getDeviceType().getResources();
        if (!(5 != iTaskTypeID && 12 != iTaskTypeID || this.isAllSameTransmitMode())) {
            new PkgDiffDuTransmitModeCheckAdapter(iTaskTypeID, allResoutLst);
            oValidResult.setErrorCode(-1);
            oValidResult.setErrorType(5);
            return oValidResult;
        }
        Resource oResource = null;
        int iUpgradeMode = 0;
        boolean isSupport = true;
        Iterator oResItor = allResoutLst.iterator();
        try {
            Thread.sleep(50L);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        DCDebugTracer.trace("iTaskTypeID = " + iTaskTypeID + ", iUpgradeLevel = " + this.m_oTaskObj.getUpgradeLevel());
        while (oResItor.hasNext()) {
            oResource = (Resource)oResItor.next();
            if (-1 != oResource.getStackId()) continue;
            iUpgradeMode = oResource.getUpgradeMode();
            DCDebugTracer.trace("devid = " + oResource.getDeviceID() + ", iUpgradeMode = " + iUpgradeMode);
            isSupport = this.isSupportUpMode(iTaskTypeID, iUpgradeMode);
            if (isSupport || null == nonSupportlst) continue;
            nonSupportlst.add((Object)oResource);
        }
        if (null == nonSupportlst || nonSupportlst.isEmpty()) {
            return oValidResult;
        }
        DeviceType devType = this.m_oTaskObj.getDeviceType();
        if (null != devType && 1 == (domain = devType.getDeviceDomain())) {
            return oValidResult;
        }
        int iUpgradeLevel = this.m_oTaskObj.getUpgradeLevel();
        this.popupInformDlg(iTaskTypeID, allResoutLst, (THashSet<Resource>)nonSupportlst, iUpgradeLevel);
        final DeviceSelectionCommTablePanel commTablePanel = oDeviceSelectionPanel.getDeviceTablePanel();
        DeviceInfo devInfo = new DeviceInfo();
        int iDevID = -1;
        Resource resource2 = null;
        for (Resource resource2 : nonSupportlst) {
            iDevID = resource2.getDeviceID();
            devInfo.setDevId(iDevID);
            commTablePanel.deleteDeviceFromTable(devInfo);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                commTablePanel.updateDeleteButtonStatus();
                commTablePanel.getDeviceSelectionTable().repaint();
                commTablePanel.getDeviceSelectionTable().updateUI();
                commTablePanel.repaint();
                commTablePanel.updateUI();
            }
        });
        THashSet oNonSupportlst = new THashSet();
        Iterator oResItor3 = nonSupportlst.iterator();
        while (oResItor3.hasNext()) {
            oNonSupportlst.add(oResItor3.next());
        }
        commTablePanel.sendNotificationForEvent((THashSet<Object>)oNonSupportlst);
        if (nonSupportlst.size() > 0) {
            oValidResult.setErrorCode(-1);
            oValidResult.setErrorType(5);
        }
        this.deleteResourceFromTask((THashSet<Resource>)nonSupportlst);
        return oValidResult;
    }

    private boolean isAllSameTransmitMode() {
        THashSet<Resource> allResoutLst = this.m_oTaskObj.getDeviceType().getResources();
        int RESOURCE_COUNT = allResoutLst.size();
        Resource oResource2 = null;
        int normal_transmit_cnt = 0;
        int transmit_cnt = 0;
        for (Resource oResource2 : allResoutLst) {
            if (0 == (0x40000 & oResource2.getUpgradeMode())) {
                ++normal_transmit_cnt;
                continue;
            }
            ++transmit_cnt;
        }
        return normal_transmit_cnt == RESOURCE_COUNT || transmit_cnt == RESOURCE_COUNT;
    }

    private void popupInformDlg(int iTaskTypeID, THashSet<Resource> allResoutLst, THashSet<Resource> nonSupportLst, int iUpgradeLevel) {
        switch (iTaskTypeID) {
            case 4: 
            case 13: {
                new PackageModeCheckAdapter(iTaskTypeID, allResoutLst, nonSupportLst, iUpgradeLevel);
                break;
            }
            case 5: 
            case 12: {
                new PkgDiffModeCheckAdapter(iTaskTypeID, allResoutLst, nonSupportLst, iUpgradeLevel);
                break;
            }
            case 2: {
                new PatchModeCheckAdapter(iTaskTypeID, allResoutLst, nonSupportLst, iUpgradeLevel);
                break;
            }
        }
    }

    public boolean isShowHighefficiencyMode(ITask oTaskObj) {
        boolean isShow = false;
        if (null == oTaskObj) {
            return isShow;
        }
        int iTaskTypeID = oTaskObj.getTaskTypeId();
        if (iTaskTypeID == 4 || iTaskTypeID == 13 || iTaskTypeID == 5 || iTaskTypeID == 12) {
            isShow = true;
        }
        return isShow;
    }

    private boolean isSupportUpMode(int iTaskTypeID, int iUpgradeMode) {
        boolean bSupportMode = true;
        int iSupport = 1;
        switch (iTaskTypeID) {
            case 4: {
                iSupport = iUpgradeMode & 4;
                break;
            }
            case 13: {
                iSupport = iUpgradeMode & 0x4000;
                break;
            }
            case 5: {
                iSupport = iUpgradeMode & 8;
                if (0 == iSupport) break;
                if (this.m_oTaskObj.getUpgradeLevel() == 1) {
                    iSupport = iUpgradeMode & 0x20 | iUpgradeMode & 0x40;
                }
                if (this.m_oTaskObj.getUpgradeLevel() != 2) break;
                iSupport = iUpgradeMode & 0x20;
                break;
            }
            case 12: {
                int iSupportDownGrade = iUpgradeMode & 0x4000;
                int iSupportPkgDiff = iUpgradeMode & 8;
                if (0 != iSupportDownGrade && 0 != iSupportPkgDiff) {
                    if (this.m_oTaskObj.getUpgradeLevel() == 1) {
                        iSupport = iUpgradeMode & 0x20 | iUpgradeMode & 0x40;
                    }
                    if (this.m_oTaskObj.getUpgradeLevel() != 2) break;
                    iSupport = iUpgradeMode & 0x20;
                    break;
                }
                iSupport = 0;
                break;
            }
            case 2: {
                iSupport = iUpgradeMode & 0x10;
                break;
            }
            default: {
                iSupport = 1;
            }
        }
        bSupportMode = iSupport != 0;
        return bSupportMode;
    }

    private void deleteResourceFromTask(THashSet<Resource> nonSupportLst) {
        THashSet<Resource> allResoutLst = this.m_oTaskObj.getDeviceType().getResources();
        Iterator itor = allResoutLst.iterator();
        Resource resouceInfo = null;
        while (itor.hasNext()) {
            resouceInfo = (Resource)itor.next();
            if (null == resouceInfo || !nonSupportLst.contains((Object)resouceInfo)) continue;
            itor.remove();
        }
    }

    public boolean isAllSupportHighLevelMode(ITask oTaskObj) {
        boolean isSupport = false;
        if (null == oTaskObj) {
            return isSupport;
        }
        THashSet<Resource> allResoutLst = oTaskObj.getDeviceType().getResources();
        Iterator itor = allResoutLst.iterator();
        Resource resouceInfo = null;
        int iUpMode = -1;
        while (itor.hasNext()) {
            resouceInfo = (Resource)itor.next();
            if (null == resouceInfo || 0 == ((iUpMode = resouceInfo.getUpgradeMode()) & 0x400)) continue;
            isSupport = true;
            break;
        }
        return isSupport;
    }

    public List<String[]> isNoSupportHighLevelMode(ITask oTaskObj) {
        ArrayList<String[]> neList = new ArrayList<String[]>();
        if (null == oTaskObj || oTaskObj.getIsOffLineTask()) {
            return neList;
        }
        THashSet<Resource> allResoutLst = oTaskObj.getDeviceType().getResources();
        Iterator itor = allResoutLst.iterator();
        Resource resouceInfo = null;
        int iUpMode = -1;
        int count = 0;
        while (itor.hasNext()) {
            resouceInfo = (Resource)itor.next();
            if (null == resouceInfo || 0 != ((iUpMode = resouceInfo.getUpgradeMode()) & 0x400)) continue;
            String[] temArgs = new String[]{"" + ++count, resouceInfo.getDeviceName() + "(" + resouceInfo.getDeviceIP() + ")"};
            neList.add(temArgs);
        }
        return neList;
    }

    public boolean isAllNotSupportToleranceMode(ITask oTaskObj) {
        boolean isNotSupport = true;
        if (null == oTaskObj) {
            return isNotSupport;
        }
        THashSet<Resource> allResoutLst = oTaskObj.getDeviceType().getResources();
        Iterator itor = allResoutLst.iterator();
        Resource resouceInfo = null;
        int iUpMode = -1;
        while (itor.hasNext()) {
            resouceInfo = (Resource)itor.next();
            if (null == resouceInfo || 0 == ((iUpMode = resouceInfo.getUpgradeMode()) & 0x800)) continue;
            isNotSupport = false;
            break;
        }
        return isNotSupport;
    }

    public boolean isSupportToleranceMode(DeviceInfo devInfo) {
        boolean isSupport = false;
        if (null == devInfo) {
            return isSupport;
        }
        int iDevID = devInfo.getDevId();
        Resource resouceInfo = DeviceInfoManagerImpl.getInstance().getResourceForID(iDevID);
        if (null == resouceInfo) {
            return isSupport;
        }
        int iUpMode = resouceInfo.getUpgradeMode();
        if (0 != (iUpMode & 0x800)) {
            isSupport = true;
        }
        return isSupport;
    }

    public boolean isSupportHighLevelMode(DeviceInfo devInfo) {
        boolean isSupport = false;
        if (null == devInfo) {
            return isSupport;
        }
        int iDevID = devInfo.getDevId();
        Resource resouceInfo = DeviceInfoManagerImpl.getInstance().getResourceForID(iDevID);
        if (null == resouceInfo) {
            return isSupport;
        }
        int iUpMode = resouceInfo.getUpgradeMode();
        if (0 != (iUpMode & 0x400)) {
            isSupport = true;
        }
        return isSupport;
    }

    public boolean isShowThirdPartyFTP(ITask oTaskObj) {
        boolean isShow = false;
        if (null == oTaskObj) {
            return isShow;
        }
        IDeviceInfoManager oDevMgr = DeviceInfoManagerImpl.getInstance();
        if (4 == oTaskObj.getTaskTypeId() || 5 == oTaskObj.getTaskTypeId()) {
            THashSet<Resource> allResoutLst = oTaskObj.getDeviceType().getResources();
            Iterator itor = allResoutLst.iterator();
            Resource resouceInfo = null;
            while (itor.hasNext()) {
                int iDevID;
                DeviceInfo oDeviceInfo;
                resouceInfo = (Resource)itor.next();
                if (null == resouceInfo || null == (oDeviceInfo = oDevMgr.getDevice(iDevID = resouceInfo.getDeviceID()))) continue;
                DeviceTypeInfo devTypeInfo = oDeviceInfo.getDeviceTypeInfo();
                if (ResourceManager.getInstance().isNorthAmericaDevDevType(devTypeInfo)) continue;
                return false;
            }
            return true;
        }
        if (0 == oTaskObj.getTaskTypeId()) {
            return true;
        }
        THashSet<Resource> allResoutLst = oTaskObj.getDeviceType().getResources();
        Iterator itor = allResoutLst.iterator();
        Resource resouceInfo = null;
        int iUpMode = -1;
        DeviceInfo oDevInfo = null;
        while (itor.hasNext()) {
            resouceInfo = (Resource)itor.next();
            if (null == resouceInfo) continue;
            oDevInfo = oDevMgr.getDevice(resouceInfo.getDeviceID());
            if (DeviceInfoUtil.isClusterNE(oDevInfo)) {
                return false;
            }
            iUpMode = resouceInfo.getUpgradeMode();
            if (0 == (iUpMode & 0x1000)) {
                if (2 == oTaskObj.getTaskTypeId() && ResourceManager.getInstance().isNorthAmericaDevDevType(oTaskObj.getDeviceType().getDeviceTypeID())) {
                    isShow = true;
                    continue;
                }
                isShow = false;
                break;
            }
            isShow = true;
        }
        return isShow;
    }

    @Override
    public void setToNULL() {
        this.m_oTaskObj = null;
        m_oUpModeCheckControllerInstance = null;
    }

    @Override
    public void eludeFindBugs() {
    }
}

