/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.controller;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.standalone.controller.IDCStandAloneSyncCtrller;
import com.huawei.dc.standalone.controller.StandAloneSyncCtrller;
import com.huawei.dc.standalone.model.T2000DevInfo;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.common.IUpgradeMode;
import com.huawei.dc.taskmgmt.view.common.TaskOperationResultDialog;
import gnu.trove.THashSet;

public abstract class UpModeChechAdapter
implements IUpgradeMode {
    protected int iTaskTypeID = -1;
    protected THashSet<Resource> m_oNonSupportLst = null;
    protected THashSet<Resource> m_oAllResourcLst = null;
    protected static final int TABLE_COLUMN_INDEX_0 = 0;
    protected static final int TABLE_COLUMN_INDEX_1 = 1;
    protected static final int TABLE_COLUMN_INDEX_2 = 2;
    protected final String TABLE_COLUMN_0_NAME = ResourceManager.getInstance().getResString("DEVICE_NAME");
    protected String m_sTableColumn1Name = ResourceManager.getInstance().getResString("NE_ID");
    protected final String TABLE_COLUMN_2_NAME = ResourceManager.getInstance().getResString("PATCH_MANAGEMENT_DETAILS_BTN_TOOL_TIP_TEXT");
    protected TaskOperationResultDialog m_oMainDlg = null;
    public int iUpDownLevel = 0;

    public UpModeChechAdapter() {
    }

    public UpModeChechAdapter(int iTaskTypeID, THashSet<Resource> allResoutLst, THashSet<Resource> nonSupportLst, int iUpgradeLevel) {
        this.iTaskTypeID = iTaskTypeID;
        this.iUpDownLevel = iUpgradeLevel;
        this.m_oNonSupportLst = nonSupportLst;
        this.m_oAllResourcLst = allResoutLst;
        this.initGUI();
    }

    private void initGUI() {
        String title = this.getTitle();
        boolean bDisplayTable = true;
        String[] columns = this.getColumns();
        this.m_oMainDlg = new TaskOperationResultDialog(title, 0, bDisplayTable, columns);
        this.m_oMainDlg.setMessage(this.getNoticeInfo());
        this.initTableData();
        this.m_oMainDlg.setVisible(true);
    }

    private String getTitle() {
        String dlgTitle = ResourceManager.getInstance().getResString("TLE_DLG_MODE_CHECK_RESULT");
        return dlgTitle;
    }

    protected String getNoticeInfo() {
        if (null != this.m_oAllResourcLst && null != this.m_oNonSupportLst) {
            if (this.m_oAllResourcLst.size() != this.m_oNonSupportLst.size()) {
                return ResourceManager.getInstance().getResString("INFO_ERROR_MODE_VALIDATE_NOTICE_PART");
            }
            return ResourceManager.getInstance().getResString("INFO_ERROR_MODE_VALIDATE_NOTICE_ALL");
        }
        return null;
    }

    protected String[] getColumns() {
        return new String[]{this.TABLE_COLUMN_0_NAME, this.m_sTableColumn1Name, this.TABLE_COLUMN_2_NAME};
    }

    protected abstract void initTableData();

    protected abstract String getDetailInfo(int var1);

    public String getShowDevIdInfo(int devId) {
        T2000DevInfo oT2000DevInfo = null;
        IDCStandAloneSyncCtrller oStandAloneSyncCtrller = StandAloneSyncCtrller.getInstance();
        try {
            oT2000DevInfo = oStandAloneSyncCtrller.getT2000DeviceInfo(devId);
        }
        catch (DCException ignore) {
            return DeviceInfoUtil.parseNEIDInt(devId);
        }
        if (2 == oT2000DevInfo.getProtocolType()) {
            return DeviceInfoUtil.parseNEIDInt(oT2000DevInfo.getMMLProtocolPhyDevIdDeviceId());
        }
        return oT2000DevInfo.getTL1ProtocolDevPhyId();
    }

    @Override
    public void eludeFindBugs() {
    }
}

