/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.controller;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnCancelTaskReq;
import com.huawei.dc.common.asndatacenter.AsnCheckReportAckRsp;
import com.huawei.dc.common.asndatacenter.AsnCheckReportReq;
import com.huawei.dc.common.asndatacenter.AsnConfigureCompareReq;
import com.huawei.dc.common.asndatacenter.AsnConfigureCompareRsp;
import com.huawei.dc.common.asndatacenter.AsnContinueTaskReq;
import com.huawei.dc.common.asndatacenter.AsnContinueTaskRsp;
import com.huawei.dc.common.asndatacenter.AsnCreateTaskReq;
import com.huawei.dc.common.asndatacenter.AsnCreateTaskRsp;
import com.huawei.dc.common.asndatacenter.AsnDCCheckDevMemoryReq;
import com.huawei.dc.common.asndatacenter.AsnDCCheckDevicesInfoForTaskReq;
import com.huawei.dc.common.asndatacenter.AsnDCCheckDevicesInfoForTaskRsp;
import com.huawei.dc.common.asndatacenter.AsnDCFileDeleteOnDevReq;
import com.huawei.dc.common.asndatacenter.AsnDCGetDetailResultReq;
import com.huawei.dc.common.asndatacenter.AsnDCGetDetailResultRsp;
import com.huawei.dc.common.asndatacenter.AsnDCGetDeviceFilesReq;
import com.huawei.dc.common.asndatacenter.AsnDCGetDeviceFilesRsp;
import com.huawei.dc.common.asndatacenter.AsnDCGetTargetVersionReq;
import com.huawei.dc.common.asndatacenter.AsnDCGetTargetVersionRsp;
import com.huawei.dc.common.asndatacenter.AsnDCIntegerLst;
import com.huawei.dc.common.asndatacenter.AsnDCIsTaskExistReq;
import com.huawei.dc.common.asndatacenter.AsnDCOpertionRsp;
import com.huawei.dc.common.asndatacenter.AsnDCRollBackReq;
import com.huawei.dc.common.asndatacenter.AsnDCServerTimeRsp;
import com.huawei.dc.common.asndatacenter.AsnDCSyncRsp;
import com.huawei.dc.common.asndatacenter.AsnDCTargetVersionInfo;
import com.huawei.dc.common.asndatacenter.AsnDCTaskTypeInfo;
import com.huawei.dc.common.asndatacenter.AsnDCUpgradeTypeEnum;
import com.huawei.dc.common.asndatacenter.AsnDcDetailOperIdEnum;
import com.huawei.dc.common.asndatacenter.AsnDcDevDomainEnum;
import com.huawei.dc.common.asndatacenter.AsnDelDevInTaskReq;
import com.huawei.dc.common.asndatacenter.AsnDelDevInTaskRsp;
import com.huawei.dc.common.asndatacenter.AsnDeleteTaskReq;
import com.huawei.dc.common.asndatacenter.AsnDeleteTaskRsp;
import com.huawei.dc.common.asndatacenter.AsnDevVersionInfo;
import com.huawei.dc.common.asndatacenter.AsnGetDCExtendCheckResultByTaskRsp;
import com.huawei.dc.common.asndatacenter.AsnGetDCExtendCheckResultReq;
import com.huawei.dc.common.asndatacenter.AsnGetDCExtendCheckResultRsq;
import com.huawei.dc.common.asndatacenter.AsnGetDevUpgradeModeImmediateRsp;
import com.huawei.dc.common.asndatacenter.AsnGetDevUpgradeModeReq;
import com.huawei.dc.common.asndatacenter.AsnHighefficiencyModeEnum;
import com.huawei.dc.common.asndatacenter.AsnPauseTaskReq;
import com.huawei.dc.common.asndatacenter.AsnPauseTaskRsp;
import com.huawei.dc.common.asndatacenter.AsnRetryTaskReq;
import com.huawei.dc.common.asndatacenter.AsnRetryTaskRsp;
import com.huawei.dc.common.asndatacenter.AsnSWCompatibilityCheckReq;
import com.huawei.dc.common.asndatacenter.AsnStartTaskReq;
import com.huawei.dc.common.asndatacenter.AsnStartTaskResp;
import com.huawei.dc.common.asndatacenter.AsnStatusEnum;
import com.huawei.dc.common.asndatacenter.AsnT2000AutoUpgradeTaskReq;
import com.huawei.dc.common.asndatacenter.AsnTaskDevOpInfo;
import com.huawei.dc.common.asndatacenter.AsnTaskDevOpInfoLst;
import com.huawei.dc.common.asndatacenter.AsnTaskDevResult;
import com.huawei.dc.common.asndatacenter.AsnTaskDevResultLst;
import com.huawei.dc.common.asndatacenter.AsnTaskDevResultReq;
import com.huawei.dc.common.asndatacenter.AsnTaskDevResultRsp;
import com.huawei.dc.common.asndatacenter.AsnTaskInfo;
import com.huawei.dc.common.asndatacenter.AsnTaskMoveToCompleteReqLst;
import com.huawei.dc.common.asndatacenter.AsnTaskMoveToCompleteRsp;
import com.huawei.dc.common.asndatacenter.AsnTaskReportBoardDetailInfoReq;
import com.huawei.dc.common.asndatacenter.AsnTaskReportBoardDetailInfoRsp;
import com.huawei.dc.common.asndatacenter.AsnTaskReq;
import com.huawei.dc.common.asndatacenter.AsnTaskResource;
import com.huawei.dc.common.asndatacenter.AsnTaskResourceLst;
import com.huawei.dc.common.asndatacenter.AsnTaskResultReq;
import com.huawei.dc.common.asndatacenter.AsnTaskResultRsp;
import com.huawei.dc.common.asndatacenter.AsnToleranceReq;
import com.huawei.dc.common.asndatacenter.AsnToleranceRsp;
import com.huawei.dc.common.asndatacenter.AsnUpgradeFeasibilitySupportReq;
import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DCTimeDateUtil;
import com.huawei.dc.common.util.TaskInfoUtil;
import com.huawei.dc.configuration.system.externalftp.ExternalFTPInfo;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.controller.CancelOperationResultManager;
import com.huawei.dc.taskmgmt.controller.ITaskSyncCommController;
import com.huawei.dc.taskmgmt.controller.TaskAsnSupportUtilities;
import com.huawei.dc.taskmgmt.controller.TaskAsynCommController;
import com.huawei.dc.taskmgmt.controller.TaskAsynCommControllerHelper;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import com.huawei.dc.taskmgmt.controller.TaskResourceUtil;
import com.huawei.dc.taskmgmt.controller.TaskSyncCommControllerHelper;
import com.huawei.dc.taskmgmt.isolation.model.IsolationDevOprDetailInfoObj;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.ITaskDataModel;
import com.huawei.dc.taskmgmt.model.ITaskGroup;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import com.huawei.dc.taskmgmt.model.SnmpConfComInfo;
import com.huawei.dc.taskmgmt.model.TaskDataModel;
import com.huawei.dc.taskmgmt.model.TaskGroup;
import com.huawei.dc.taskmgmt.model.TaskOpResultInfo;
import com.huawei.dc.taskmgmt.model.TaskProgressInfo;
import com.huawei.dc.taskmgmt.report.devlevel.model.ReportPacketInfo;
import com.swimap.iview.communicate.MSGListener;
import com.swimap.iview.util.SyncCommand;
import com.swimap.iview.util.format.TimeDateFormatUtil;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Cursor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import net.commustru.fstru.FStruct;

public class TaskSyncCommController
implements ITaskSyncCommController,
IDCObjectDeallocator {
    private static ITaskSyncCommController c_oTaskSyncController;
    private long firstOpenClientTime = -1L;
    private final Semaphore objLock = new Semaphore(1, true);

    private TaskSyncCommController() {
        this.firstOpenClientTime = System.nanoTime();
        TaskAsynCommController.getInstance();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.firstOpenClientTime ^ this.firstOpenClientTime >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskSyncCommController other = (TaskSyncCommController)obj;
        return this.firstOpenClientTime == other.firstOpenClientTime;
    }

    public static synchronized ITaskSyncCommController getInstance() {
        if (null == c_oTaskSyncController) {
            c_oTaskSyncController = new TaskSyncCommController();
            DCObjectDestructor.getInstance().addObjectForDestructor((TaskSyncCommController)c_oTaskSyncController);
        }
        return c_oTaskSyncController;
    }

    @Override
    public List getVersionInfoFrmServer(int iDeviceTypeId, int iDeviceTypeVersionId, String strUpdateToolPath) throws DCException {
        ArrayList<AsnDCTargetVersionInfo> oLstTargetVersion = null;
        AsnDCGetTargetVersionReq oAsnGetTargetVersionReq = new AsnDCGetTargetVersionReq();
        oAsnGetTargetVersionReq.iDeviceTypeId = BigInteger.valueOf(iDeviceTypeId);
        oAsnGetTargetVersionReq.iDeviceTypeVersionId = BigInteger.valueOf(iDeviceTypeVersionId);
        if (null != strUpdateToolPath && 0 != strUpdateToolPath.length()) {
            oAsnGetTargetVersionReq.strUpdateToolPath = strUpdateToolPath.getBytes();
        }
        AsnDCGetTargetVersionRsp oAsnDCGetTargetVersionRsp = new AsnDCGetTargetVersionRsp();
        this.sendSyncCmdToServer((FStruct)oAsnGetTargetVersionReq, (FStruct)oAsnDCGetTargetVersionRsp, 43845);
        int iErrorCode = oAsnDCGetTargetVersionRsp.oErrorInfo.iErrorNo.intValue();
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(oAsnDCGetTargetVersionRsp.oErrorInfo.iErrorNo));
        }
        oLstTargetVersion = new ArrayList<AsnDCTargetVersionInfo>(0);
        if (null == oAsnDCGetTargetVersionRsp.oTargeVersionLst) {
            return oLstTargetVersion;
        }
        int iSizeOfLst = oAsnDCGetTargetVersionRsp.oTargeVersionLst.size();
        AsnDCTargetVersionInfo oAsnDCTargetVersionInfo = null;
        for (int i = 0; i < iSizeOfLst; ++i) {
            oAsnDCTargetVersionInfo = (AsnDCTargetVersionInfo)oAsnDCGetTargetVersionRsp.oTargeVersionLst.get(i);
            oLstTargetVersion.add(oAsnDCTargetVersionInfo);
        }
        return oLstTargetVersion;
    }

    @Override
    public int checkIfTaskNameExist(String strTaskName) {
        int iErrorCode = 0;
        AsnDCIsTaskExistReq oAsnDCIsTaskExistReq = new AsnDCIsTaskExistReq();
        oAsnDCIsTaskExistReq.strTaskName = strTaskName.getBytes();
        AsnDCOpertionRsp oAsnOpRsp = new AsnDCOpertionRsp();
        try {
            this.sendSyncCmdToServer((FStruct)oAsnDCIsTaskExistReq, (FStruct)oAsnOpRsp, 43844);
        }
        catch (DCException e) {
            DCDebugTracer.traceError("checkIfTaskNameExist" + e.getMessage());
            iErrorCode = e.getErrorCode();
        }
        if (iErrorCode == 0) {
            iErrorCode = oAsnOpRsp.oErrorInfo.iErrorNo.intValue();
        }
        return iErrorCode;
    }

    @Override
    public void createTask(ITask oTaskDataObj, int iCmdCode) throws DCException {
        String xftpType;
        ExternalFTPInfo xFtpInfo;
        String strThirdFTPName;
        int iInitialTaskId = oTaskDataObj.getTaskId();
        AsnCreateTaskReq oAsnCreateTaskReq = new AsnCreateTaskReq();
        AsnCreateTaskRsp oAsnCreateTaskRsp = new AsnCreateTaskRsp();
        oAsnCreateTaskReq.oTaskInfo.oTaskCommonInfo.iTaskId = BigInteger.valueOf(iInitialTaskId);
        oAsnCreateTaskReq.oTaskInfo.oTaskCommonInfo.strTaskName = oTaskDataObj.getTaskName().getBytes();
        oAsnCreateTaskReq.oTaskInfo.oTaskCommonInfo.oAsnDevVersionInfo = new AsnDevVersionInfo();
        TaskSyncCommControllerHelper.updateDeviceVersionInfo(oTaskDataObj, oAsnCreateTaskReq.oTaskInfo.oTaskCommonInfo.oAsnDevVersionInfo);
        oAsnCreateTaskReq.oTaskInfo.oTaskCommonInfo.enHighefficiencyMode = new AsnHighefficiencyModeEnum(oTaskDataObj.getHighefficiencyMode());
        String strThirdPartyFTPName = "";
        if (oTaskDataObj.isThirdPartySupported()) {
            strThirdPartyFTPName = oTaskDataObj.getThirdPartyServerName();
        }
        oAsnCreateTaskReq.oTaskInfo.oTaskCommonInfo.strThirdPartyFTPName = strThirdPartyFTPName.getBytes();
        oAsnCreateTaskReq.oTaskInfo.oTaskCommonInfo.enContentType = null == oTaskDataObj.getTaskContentType() ? new AsnDCUpgradeTypeEnum(2) : TaskAsnSupportUtilities.getTaskContentType(oTaskDataObj.getTaskContentType().getId());
        if (null != oTaskDataObj.getStartTime()) {
            Calendar oStartTimeCal = Calendar.getInstance();
            oStartTimeCal.setTime(oTaskDataObj.getStartTime().getTime());
            DCTimeDateUtil.switchToGMTCalendar(oStartTimeCal);
            oAsnCreateTaskReq.oTaskInfo.oTaskCommonInfo.oStartTime = oStartTimeCal;
        }
        oAsnCreateTaskReq.oTaskInfo.oTaskCommonInfo.iUserId = BigInteger.valueOf(DCFrameWorkUtil.getSecurityManager().getUserId());
        oAsnCreateTaskReq.oTaskInfo.oTaskCommonInfo.strTargetVersion = null != oTaskDataObj.getTargetVersion() ? oTaskDataObj.getTargetVersion().getBytes() : "".getBytes();
        oAsnCreateTaskReq.oTaskInfo.oTaskCommonInfo.enTaskStatus = new AsnStatusEnum(0);
        if (oTaskDataObj.getIsOffLineTask()) {
            oAsnCreateTaskReq.oTaskInfo.oTaskCommonInfo.bOfflineTask = oTaskDataObj.getIsOffLineTask();
            oAsnCreateTaskReq.oTaskInfo.oTaskCommonInfo._bOfflineTask = oTaskDataObj.getIsOffLineTask();
        }
        this.updateTaskType(oAsnCreateTaskReq.oTaskInfo, oTaskDataObj);
        TaskSyncCommControllerHelper.updateTaskViewType(oAsnCreateTaskReq.oTaskInfo, oTaskDataObj);
        TaskSyncCommControllerHelper.updateResourceList(oAsnCreateTaskReq.oTaskInfo, oTaskDataObj.getSelectedDeviceType().getResources());
        if (oTaskDataObj.getTaskTypeId() == 5 || oTaskDataObj.getTaskTypeId() == 12) {
            TaskSyncCommControllerHelper.updateUpdateLevelTpe(oAsnCreateTaskReq.oTaskInfo, oTaskDataObj);
        }
        this.updateOperationList(oAsnCreateTaskReq.oTaskInfo, oTaskDataObj, false);
        if (oAsnCreateTaskReq.oTaskInfo.oLoadSWOpInfo != null) {
            strThirdFTPName = oTaskDataObj.getThirdPartyServerName();
            xFtpInfo = oTaskDataObj.getThirdPartyFTPInfo();
            oAsnCreateTaskReq.oTaskInfo.oLoadSWOpInfo.iFtpType = null != xFtpInfo && null != strThirdFTPName && 0 != strThirdFTPName.length() ? ("SFTP".equals(xftpType = xFtpInfo.getType()) ? new BigInteger(String.valueOf(2)) : ("FTP".equals(xftpType) ? new BigInteger(String.valueOf(1)) : new BigInteger(String.valueOf(oTaskDataObj.getLoadSoftwareType())))) : new BigInteger(String.valueOf(oTaskDataObj.getLoadSoftwareType()));
        }
        if (oAsnCreateTaskReq.oTaskInfo.oLoadPatchOpInfo != null) {
            strThirdFTPName = oTaskDataObj.getThirdPartyServerName();
            xFtpInfo = oTaskDataObj.getThirdPartyFTPInfo();
            oAsnCreateTaskReq.oTaskInfo.oLoadPatchOpInfo.iFtpType = null != xFtpInfo && null != strThirdFTPName && 0 != strThirdFTPName.length() ? ("SFTP".equals(xftpType = xFtpInfo.getType()) ? new BigInteger(String.valueOf(2)) : ("FTP".equals(xftpType) ? new BigInteger(String.valueOf(1)) : new BigInteger(String.valueOf(oTaskDataObj.getLoadSoftwareType())))) : new BigInteger(String.valueOf(oTaskDataObj.getLoadSoftwareType()));
        }
        this.sendCreateTaskReq(oTaskDataObj, oAsnCreateTaskReq, oAsnCreateTaskRsp, iCmdCode);
    }

    @Override
    public void sendCreateTaskReq(ITask oTask, AsnCreateTaskReq oAsnCreateTaskReq, AsnCreateTaskRsp oAsnCreateTaskRsp, int iCmdCode) throws DCException {
        DCDebugTracer.trace("create task start. iTaskId: " + oTask.getTaskId());
        TaskDataModel.getInstance().setCreatingTaskName(new String(oAsnCreateTaskReq.oTaskInfo.oTaskCommonInfo.strTaskName));
        BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
        DCFrameWorkUtil.getCommManager();
        int iErrorCode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(iCmdCode), (FStruct)oAsnCreateTaskReq, (FStruct)oAsnCreateTaskRsp);
        if (iErrorCode != 0) {
            TaskDataModel.getInstance().setCreatingTaskName("");
            throw new DCException(iErrorCode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
        iErrorCode = oAsnCreateTaskRsp.oAsnDCErrorCodeInfo.iErrorNo.intValue();
        if (iErrorCode != 0) {
            TaskDataModel.getInstance().setCreatingTaskName("");
            DCDebugTracer.trace("[Invalid User] userId : " + DCFrameWorkUtil.getSecurityManager().getUserId());
            DCDebugTracer.trace("[Invalid User] ClientId : " + DCFrameWorkUtil.getSecurityManager().getClientId());
            if (null != DCFrameWorkUtil.getSecurityManager().getLoginInfo()) {
                DCDebugTracer.trace("[Invalid User] userName : " + DCFrameWorkUtil.getSecurityManager().getLoginInfo().getUserName());
            }
            if (null != oAsnCreateTaskRsp.oTaskResourceLst && oAsnCreateTaskRsp.oTaskResourceLst.size() != 0) {
                throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(oAsnCreateTaskRsp.oAsnDCErrorCodeInfo.iErrorNo), oAsnCreateTaskRsp.oTaskResourceLst);
            }
            DCDebugTracer.trace("oAsnCreateTaskRsp.oTaskResourceLst is null");
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(oAsnCreateTaskRsp.oAsnDCErrorCodeInfo.iErrorNo));
        }
    }

    private void updateTaskType(AsnTaskInfo oAsnTaskInfo, ITask oTaskData) {
        oAsnTaskInfo.oTaskCommonInfo.enTaskType = TaskCommUtil.getEnumForTaskType(oTaskData.getTaskTypeId());
    }

    @Override
    public void updateTaskTypes() {
        TaskDataModel.getInstance().clearTaskModel();
        ITaskGroup oITaskGroup = null;
        int[] taskGroups = TaskGroup.getTaskGroupIdLst();
        int iTaskGroupsNum = taskGroups.length;
        for (int i = 0; i < iTaskGroupsNum; ++i) {
            oITaskGroup = TaskSyncCommControllerHelper.getTaskGroup(taskGroups[i]);
            TaskDataModel.getInstance().addTaskGroup(oITaskGroup);
        }
    }

    @Override
    public List deleteTasks(int[] arrTaskIDs) throws DCException {
        if (null == arrTaskIDs) {
            return new ArrayList(0);
        }
        AsnDeleteTaskReq oDeleteReq = new AsnDeleteTaskReq();
        AsnDeleteTaskRsp oDeleteRsp = new AsnDeleteTaskRsp();
        for (int i = 0; i < arrTaskIDs.length; ++i) {
            oDeleteReq.addElement((Object)BigInteger.valueOf(arrTaskIDs[i]));
        }
        this.sendSyncCmdToServer((FStruct)oDeleteReq, (FStruct)oDeleteRsp, 43900);
        if (oDeleteRsp.oErrorInfo.iErrorNo.intValue() != 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), oDeleteRsp.oErrorInfo.iErrorNo.intValue(), ResourceManager.getInstance().getResString("ERROR"), 0);
            return null;
        }
        return null;
    }

    @Override
    public void deleteFailDevOperation(AsnDelDevInTaskReq oAsnDelDevInTaskReq, AsnDelDevInTaskRsp oAsnDelDevInTaskRsp) throws DCException {
        this.sendSyncCmdToServer((FStruct)oAsnDelDevInTaskReq, (FStruct)oAsnDelDevInTaskRsp, 44071);
    }

    @Override
    public AsnDCCheckDevicesInfoForTaskRsp checkDevicesInfoForTask(int[] arrTaskIDs) {
        AsnDCCheckDevicesInfoForTaskReq oAsnDCCheckDevicesInfoForTaskReq = new AsnDCCheckDevicesInfoForTaskReq();
        AsnDCCheckDevicesInfoForTaskRsp oAsnDCCheckDevicesInfoForTaskRsp = new AsnDCCheckDevicesInfoForTaskRsp();
        for (int i = 0; i < arrTaskIDs.length; ++i) {
            oAsnDCCheckDevicesInfoForTaskReq.iTaskIDs.addElement((Object)BigInteger.valueOf(arrTaskIDs[i]));
        }
        AsnStatusEnum firstAsnStatusEnum = new AsnStatusEnum();
        firstAsnStatusEnum.value = 3;
        AsnStatusEnum secondeAsnStatusEnum = new AsnStatusEnum();
        secondeAsnStatusEnum.value = 0;
        oAsnDCCheckDevicesInfoForTaskReq.enTaskStatusLst.addElement((Object)firstAsnStatusEnum);
        oAsnDCCheckDevicesInfoForTaskReq.enTaskStatusLst.addElement((Object)secondeAsnStatusEnum);
        try {
            this.sendSyncCmdToServer((FStruct)oAsnDCCheckDevicesInfoForTaskReq, (FStruct)oAsnDCCheckDevicesInfoForTaskRsp, 43969);
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
            return null;
        }
        return oAsnDCCheckDevicesInfoForTaskRsp;
    }

    @Override
    public List startTask(int[] arrTaskIDs) throws DCException {
        if (null == arrTaskIDs || 0 == arrTaskIDs.length) {
            return new ArrayList(0);
        }
        DCDebugTracer.trace("Method startTask start");
        AsnStartTaskReq oAsnStartTaskReq = new AsnStartTaskReq();
        AsnStartTaskResp oAsnStartTaskResp = new AsnStartTaskResp();
        for (int i = 0; i < arrTaskIDs.length; ++i) {
            oAsnStartTaskReq.addElement((Object)BigInteger.valueOf(arrTaskIDs[i]));
        }
        this.sendSyncCmdToServer((FStruct)oAsnStartTaskReq, (FStruct)oAsnStartTaskResp, 43902);
        List oTaskResultList = TaskCommUtil.getFailedTaskIDsFromStartTaskResponse(oAsnStartTaskResp);
        DCDebugTracer.trace("Method startTask end");
        return oTaskResultList;
    }

    @Override
    public List pauseTasks(HashMap oTaskResourceMap, int iReqLevel) throws DCException {
        if (null == oTaskResourceMap) {
            return null;
        }
        DCDebugTracer.trace("Method pauseTasks start");
        AsnPauseTaskReq oAsnPauseTaskReq = new AsnPauseTaskReq();
        AsnPauseTaskRsp oAsnPauseTaskRsp = new AsnPauseTaskRsp();
        List oTaskReqList = TaskCommUtil.populateTaskReqList(oTaskResourceMap);
        int iTaskCount = oTaskReqList.size();
        AsnTaskReq oAsnTaskReq = null;
        for (int i = 0; i < iTaskCount; ++i) {
            oAsnTaskReq = (AsnTaskReq)oTaskReqList.get(i);
            oAsnTaskReq.iReqLevel = BigInteger.valueOf(iReqLevel);
            oAsnPauseTaskReq.add(oTaskReqList.get(i));
        }
        this.sendSyncCmdToServer((FStruct)oAsnPauseTaskReq, (FStruct)oAsnPauseTaskRsp, 43904);
        List<Object> oTaskResultList = new ArrayList();
        if (oAsnPauseTaskRsp.oErrorInfo != null && oAsnPauseTaskRsp.oErrorInfo.iErrorNo.intValue() != 0) {
            if (null != oAsnPauseTaskRsp.oTaskRspList && oAsnPauseTaskRsp.oTaskRspList.size() > 0) {
                oTaskResultList = TaskCommUtil.getResultListForTaskOperation(oAsnPauseTaskRsp.oTaskRspList);
            } else {
                oTaskResultList.add(oAsnPauseTaskRsp.oErrorInfo);
            }
        } else {
            oTaskResultList = TaskCommUtil.getResultListForTaskOperation(oAsnPauseTaskRsp.oTaskRspList);
        }
        DCDebugTracer.trace("Method pauseTasks end");
        return oTaskResultList;
    }

    @Override
    public AsnContinueTaskRsp continueTasks(HashMap oTaskResourceMap, boolean bContinueNextOperation, boolean bContainUFCResource, boolean bContainLoadFailedBoard, DCSortableTreeTable oTaskTreeTable) throws DCException {
        if (null == oTaskResourceMap || 0 == oTaskResourceMap.size()) {
            return null;
        }
        DCDebugTracer.trace("[manualGroup]continueTasks:" + bContinueNextOperation);
        AsnContinueTaskReq oAsnContinueTaskReq = new AsnContinueTaskReq();
        AsnContinueTaskRsp oAsnContinueTaskRsp = new AsnContinueTaskRsp();
        List oTaskReqList = TaskCommUtil.populateTaskReqList(oTaskResourceMap);
        int iTaskCount = oTaskReqList.size();
        AsnTaskReq oAsnTaskReq = null;
        boolean bShowPauseContinueMsg = false;
        boolean bisActivePause = false;
        boolean bisContinueNE = false;
        ITaskDataModel oTaskDataModel = TaskDataModel.getInstance();
        for (int i = 0; i < iTaskCount; ++i) {
            oAsnTaskReq = (AsnTaskReq)oTaskReqList.get(i);
            ITask oTask = oTaskDataModel.getTask(oAsnTaskReq.iTaskID.intValue());
            TaskProgressInfo oTaskPro = oTask.getTaskProgressInfo();
            if (!bisContinueNE && oAsnTaskReq.oTaskResLst.size() < oTask.getDeviceType().getResources().size()) {
                bisContinueNE = true;
            }
            if (!bContainUFCResource && !bContainLoadFailedBoard) {
                bShowPauseContinueMsg = true;
            }
            if (!bisActivePause && oTaskPro.getState() == 4 && TaskInfoUtil.isResourceParseInActivationStep(oTask, oAsnTaskReq.oTaskResLst)) {
                bisActivePause = true;
            }
            DCDebugTracer.trace("DC::continueTasks()in loop:" + bContinueNextOperation);
            oAsnTaskReq._bIsContinueNextOper = bContinueNextOperation;
            oAsnTaskReq.bIsContinueNextOper = bContinueNextOperation;
            oAsnContinueTaskReq.add((Object)oAsnTaskReq);
        }
        if (bShowPauseContinueMsg) {
            int iConfirmOutput;
            String msg = ResourceManager.getInstance().getResString("TASK_CONTINUE_CONFIRM_MSG");
            String msg_title = ResourceManager.getInstance().getResString("CONFIRM");
            int msg_Opt = 3;
            if (bisContinueNE) {
                msg = ResourceManager.getInstance().getResString("NE_CONTINUE_CONFIRM_MSG");
            }
            if (bisActivePause) {
                msg = ResourceManager.getInstance().getResString("BEFORE_ACTIVATION_OPERATIONE_MSG");
                msg_title = ResourceManager.getInstance().getResString("WARNING");
                msg_Opt = 2;
            }
            if (0 != (iConfirmOutput = DCOptionPane.showExtConfirmDialog(DCFrameWorkUtil.getMainFrame(), msg, msg_title, 0, msg_Opt))) {
                return null;
            }
            if (msg.equals(ResourceManager.getInstance().getResString("NE_CONTINUE_CONFIRM_MSG"))) {
                TaskAsynCommControllerHelper.setIsContinueNE(bisContinueNE);
            }
        }
        if (null != oAsnTaskReq) {
            DCDebugTracer.trace("DC::continueTasks()out loop:" + oAsnTaskReq.bIsContinueNextOper);
        }
        DCDebugTracer.trace("DC::continueTasks()out loop:" + oAsnTaskReq.bIsContinueNextOper);
        this.sendSyncCmdToServer((FStruct)oAsnContinueTaskReq, (FStruct)oAsnContinueTaskRsp, 43905);
        return oAsnContinueTaskRsp;
    }

    @Override
    public AsnContinueTaskRsp nextOperation(HashMap oTaskResourceMap, boolean bContinueNextOperation, DCSortableTreeTable oTaskTreeTable) throws DCException {
        if (null == oTaskResourceMap || 0 == oTaskResourceMap.size()) {
            return null;
        }
        DCDebugTracer.trace("[manualGroup]nextOperation:" + bContinueNextOperation);
        AsnContinueTaskReq oAsnContinueTaskReq = new AsnContinueTaskReq();
        AsnContinueTaskRsp oAsnContinueTaskRsp = new AsnContinueTaskRsp();
        List oTaskReqList = TaskCommUtil.populateTaskReqList(oTaskResourceMap);
        int iTaskCount = oTaskReqList.size();
        AsnTaskReq oAsnTaskReq = null;
        for (int i = 0; i < iTaskCount; ++i) {
            oAsnTaskReq = (AsnTaskReq)oTaskReqList.get(i);
            DCDebugTracer.trace("DC::nextOperation()in loop:" + bContinueNextOperation);
            oAsnTaskReq._bIsContinueNextOper = bContinueNextOperation;
            oAsnTaskReq.bIsContinueNextOper = bContinueNextOperation;
            oAsnContinueTaskReq.add((Object)oAsnTaskReq);
        }
        if (null != oAsnTaskReq) {
            DCDebugTracer.trace("DC::nextOperation()out loop:" + oAsnTaskReq.bIsContinueNextOper);
        }
        this.sendSyncCmdToServer((FStruct)oAsnContinueTaskReq, (FStruct)oAsnContinueTaskRsp, 44075);
        return oAsnContinueTaskRsp;
    }

    @Override
    public int retryOperation(HashMap mapSelectedResources, boolean bContinueNextOpr) throws DCException {
        DCDebugTracer.trace("Method retryOperation start");
        AsnRetryTaskReq oAsnRetryTaskReq = new AsnRetryTaskReq();
        AsnDCSyncRsp oAsnRetryTaskRsp = new AsnDCSyncRsp();
        List oTaskReqList = TaskCommUtil.populateTaskReqList(mapSelectedResources);
        int iTaskCount = oTaskReqList.size();
        AsnTaskReq oAsnTaskReq = null;
        for (int i = 0; i < iTaskCount; ++i) {
            oAsnTaskReq = (AsnTaskReq)oTaskReqList.get(i);
            oAsnTaskReq._bIsContinueNextOper = bContinueNextOpr;
            oAsnTaskReq.bIsContinueNextOper = bContinueNextOpr;
            oAsnRetryTaskReq.add((Object)oAsnTaskReq);
        }
        this.sendSyncCmdToServer((FStruct)oAsnRetryTaskReq, (FStruct)oAsnRetryTaskRsp, 43909);
        DCDebugTracer.trace("Method retryOperation end");
        return oAsnRetryTaskRsp.oErrorInfo.iErrorNo.intValue();
    }

    @Override
    public int retryDiffusionTaskOperation(Map<Integer, THashSet<Resource>> oTaskFailedResourceMap) throws DCException {
        DCDebugTracer.trace("Method retryDiffusionTaskOperation start");
        AsnRetryTaskReq oAsnRetryTaskReq = new AsnRetryTaskReq();
        AsnDCSyncRsp oAsnRetryTaskRsp = new AsnDCSyncRsp();
        TaskCommUtil.boxRetryDiffusionTaskReq(oTaskFailedResourceMap, oAsnRetryTaskReq);
        this.sendSyncCmdToServer((FStruct)oAsnRetryTaskReq, (FStruct)oAsnRetryTaskRsp, 44081);
        DCDebugTracer.trace("Method retryDiffusionTaskOperation end");
        return oAsnRetryTaskRsp.oErrorInfo.iErrorNo.intValue();
    }

    @Override
    public List<TaskOpResultInfo> activeOperation(HashMap mapSelectedResources) throws DCException {
        int iConfirmOutput = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("BOARD_ACTIVATE_OPERATION_CONFIRMATION_MSG"), ResourceManager.getInstance().getResString("CONFIRM"), 0);
        if (0 != iConfirmOutput) {
            return null;
        }
        DCDebugTracer.trace("Method activeOperation start");
        AsnRetryTaskReq oAsnRetryTaskReq = new AsnRetryTaskReq();
        AsnRetryTaskRsp oAsnRetryTaskRsp = new AsnRetryTaskRsp();
        List oTaskReqList = TaskCommUtil.populateTaskReqList(mapSelectedResources);
        int iTaskCount = oTaskReqList.size();
        AsnTaskReq oAsnTaskReq = null;
        for (int i = 0; i < iTaskCount; ++i) {
            oAsnTaskReq = (AsnTaskReq)oTaskReqList.get(i);
            oAsnRetryTaskReq.add((Object)oAsnTaskReq);
        }
        this.sendSyncCmdToServer((FStruct)oAsnRetryTaskReq, (FStruct)oAsnRetryTaskRsp, 44051);
        List<TaskOpResultInfo> oTaskOpResultList = TaskCommUtil.getResultListForTaskOperation(oAsnRetryTaskRsp.oTaskRspList);
        DCDebugTracer.trace("Method activeOperation end");
        return oTaskOpResultList;
    }

    @Override
    public AsnContinueTaskRsp cancelOperation(HashMap mapSelectedResources) throws DCException {
        DCDebugTracer.trace("Method cancelOperation start");
        AsnCancelTaskReq oAsnCancelTaskReq = new AsnCancelTaskReq();
        AsnContinueTaskRsp oAsnCancelTaskRsp = new AsnContinueTaskRsp();
        List oTaskReqList = TaskCommUtil.populateTaskReqList(mapSelectedResources);
        int iTaskCount = oTaskReqList.size();
        AsnTaskReq oAsnTaskReq = null;
        for (int i = 0; i < iTaskCount; ++i) {
            oAsnTaskReq = (AsnTaskReq)oTaskReqList.get(i);
            oAsnCancelTaskReq.add((Object)oAsnTaskReq);
        }
        DCFrameWorkUtil.getCommManager().addMessageListener(44018, (MSGListener)((TaskAsynCommController)TaskAsynCommController.getInstance()));
        CancelOperationResultManager.getInstance();
        this.sendSyncCmdToServer((FStruct)oAsnCancelTaskReq, (FStruct)oAsnCancelTaskRsp, 44018);
        int iErrorCode = oAsnCancelTaskRsp.oErrorInfo.iErrorNo.intValue();
        if (iErrorCode != 0) {
            DCDebugTracer.trace("Error in DC_TASK_CANCEL_DEVICE_OPERATION request : " + ErrorCodeReader.getInstance().getErrorDesc(oAsnCancelTaskRsp.oErrorInfo.iErrorNo));
            DCFrameWorkUtil.getCommManager().removeMessageListener(44018, (MSGListener)((TaskAsynCommController)TaskAsynCommController.getInstance()));
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(oAsnCancelTaskRsp.oErrorInfo.iErrorNo));
        }
        DCDebugTracer.trace("Method cancelOperation end");
        return oAsnCancelTaskRsp;
    }

    @Override
    public AsnContinueTaskRsp rollbackOperation(HashMap mapSelectedResources) throws DCException {
        DCDebugTracer.trace("Method rollbackOperation start");
        AsnDCRollBackReq oAsnDCRollBackReq = new AsnDCRollBackReq();
        AsnContinueTaskRsp oAsnRollBackRsq = new AsnContinueTaskRsp();
        TaskSyncCommControllerHelper.fillRollBackReq(mapSelectedResources, oAsnDCRollBackReq);
        this.sendSyncCmdToServer((FStruct)oAsnDCRollBackReq, (FStruct)oAsnRollBackRsq, 43946);
        int iErrorCode = oAsnRollBackRsq.oErrorInfo.iErrorNo.intValue();
        if (oAsnRollBackRsq.oErrorInfo.iErrorNo.intValue() != 0) {
            DCDebugTracer.trace("Error in DC_ROLLBACK request : " + ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode)));
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode)));
        }
        DCDebugTracer.trace("Method rollbackOperation end");
        return oAsnRollBackRsq;
    }

    @Override
    public int recheckOperation(HashMap mapSelectedResources) throws DCException {
        DCDebugTracer.trace("Method recheckOperation start");
        AsnRetryTaskReq oAsnRetryTaskReq = new AsnRetryTaskReq();
        AsnDCSyncRsp oAsnRetryTaskRsp = new AsnDCSyncRsp();
        List oTaskReqList = TaskCommUtil.populateTaskReqList(mapSelectedResources);
        int iTaskCount = oTaskReqList.size();
        for (int i = 0; i < iTaskCount; ++i) {
            oAsnRetryTaskReq.add(oTaskReqList.get(i));
        }
        this.sendSyncCmdToServer((FStruct)oAsnRetryTaskReq, (FStruct)oAsnRetryTaskRsp, 43999);
        DCDebugTracer.trace("Method recheckOperation end");
        return oAsnRetryTaskRsp.oErrorInfo.iErrorNo.intValue();
    }

    @Override
    public List moveTasksToCompleted(ITask[] arrTasks) throws DCException {
        if (null == arrTasks || 0 == arrTasks.length) {
            return new ArrayList(0);
        }
        DCDebugTracer.trace("Method moveTasksToCompleted start");
        AsnTaskMoveToCompleteReqLst oMoveToCompletedTaskLst = new AsnTaskMoveToCompleteReqLst();
        AsnTaskMoveToCompleteRsp oMoveToCompletedRsp = new AsnTaskMoveToCompleteRsp();
        AsnDCTaskTypeInfo oAsnTaskInfo = null;
        for (int i = 0; i < arrTasks.length; ++i) {
            oAsnTaskInfo = new AsnDCTaskTypeInfo();
            oAsnTaskInfo.iTaskId = BigInteger.valueOf(arrTasks[i].getTaskId());
            oMoveToCompletedTaskLst.add((Object)oAsnTaskInfo);
        }
        this.sendSyncCmdToServer((FStruct)oMoveToCompletedTaskLst, (FStruct)oMoveToCompletedRsp, 43913);
        List oTaskResultList = TaskCommUtil.getFailedTaskIDsFromMoveToCompletedResponse(oMoveToCompletedRsp);
        DCDebugTracer.trace("Method moveTasksToCompleted end");
        return oTaskResultList;
    }

    @Override
    public void setToNULL() {
        c_oTaskSyncController = null;
    }

    @Override
    public int getCheckReportDetails(int iTaskID, THashSet<Resource> resourceList, int checkReportType) throws DCException {
        AsnCheckReportAckRsp oAsnCheckReportRsp = new AsnCheckReportAckRsp();
        AsnCheckReportReq oAsnCheckReportReq = TaskCommUtil.getCheckReportRequest(iTaskID, resourceList, checkReportType);
        int iCommandCode = TaskSyncCommControllerHelper.getCommandCodeForReportType(checkReportType);
        ITask task = TaskDataModel.getInstance().getTask(iTaskID);
        DeviceType deviceType = task.getDeviceType();
        int iDeviceDomain = -1;
        if (null != deviceType) {
            iDeviceDomain = deviceType.getDeviceDomain();
        }
        if (2 == iDeviceDomain) {
            boolean isSupport = deviceType.isUpgradeModeSupportedByAllDevices(4096);
            if (isSupport) {
                int timeout = 0;
                int CHECK_TIME_OUT = 300000;
                int deviceCnt = resourceList.size();
                if (0 == checkReportType || 1 == checkReportType) {
                    timeout = 300000 * deviceCnt;
                } else if (2 == checkReportType) {
                    timeout = 600000 * deviceCnt;
                } else {
                    DCDebugTracer.trace("checkReportType error : " + checkReportType);
                }
                this.sendSyncCmdToServerWithTimeoutTime((FStruct)oAsnCheckReportReq, (FStruct)oAsnCheckReportRsp, iCommandCode, timeout);
            } else {
                this.sendSyncCmdToServer((FStruct)oAsnCheckReportReq, (FStruct)oAsnCheckReportRsp, iCommandCode);
            }
        } else {
            this.sendSyncCmdToServer((FStruct)oAsnCheckReportReq, (FStruct)oAsnCheckReportRsp, iCommandCode);
        }
        int iErrorCode = oAsnCheckReportRsp.oErrorInfo.iErrorNo.intValue();
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(oAsnCheckReportRsp.oErrorInfo.iErrorNo));
        }
        ReportPacketInfo instance = ReportPacketInfo.getInstance();
        instance.setPacketNum(oAsnCheckReportRsp.iNumOfReportTable.intValue());
        instance.clearPacketLstInfo();
        return oAsnCheckReportRsp.iNumOfReportTable.intValue();
    }

    @Override
    public void getTaskResultFrmServer(int iTaskId, AsnTaskResultRsp asnTaskResultRsp) throws DCException {
        AsnTaskResultReq asnTaskResultReq = new AsnTaskResultReq();
        asnTaskResultReq.iTaskID = new BigInteger(String.valueOf(iTaskId));
        this.sendSyncCmdToServer((FStruct)asnTaskResultReq, (FStruct)asnTaskResultRsp, 43928);
        int iErrorCode = asnTaskResultRsp.oErrorInfo.iErrorNo.intValue();
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(asnTaskResultRsp.oErrorInfo.iErrorNo));
        }
    }

    public void getTaskResultFrmServer(int iTaskId, List<Resource> oInputResourceList, AsnTaskResultRsp asnTaskResultRsp) throws DCException {
        AsnTaskResultReq asnTaskResultReq = new AsnTaskResultReq();
        asnTaskResultReq.iTaskID = new BigInteger(String.valueOf(iTaskId));
        AsnTaskResourceLst oBoardResourceLst = new AsnTaskResourceLst();
        for (int i = 0; i < oInputResourceList.size(); ++i) {
            Resource oResource = oInputResourceList.get(i);
            AsnTaskResource oAsnTaskResource = new AsnTaskResource();
            oAsnTaskResource.iDeviceId = new BigInteger(String.valueOf(oResource.getDeviceID()));
            oAsnTaskResource.iFrameId = new BigInteger(String.valueOf(oResource.getFrameId()));
            oAsnTaskResource.iSlotId = new BigInteger(String.valueOf(oResource.getSlotId()));
            if (null != oResource.getDeviceVersion()) {
                oAsnTaskResource.strSWversion = oResource.getDeviceVersion().getBytes();
            }
            oBoardResourceLst.add((Object)oAsnTaskResource);
        }
        asnTaskResultReq.oBoardResourceLst = oBoardResourceLst;
        this.sendSyncCmdToServer((FStruct)asnTaskResultReq, (FStruct)asnTaskResultRsp, 43928);
        int iErrorCode = asnTaskResultRsp.oErrorInfo.iErrorNo.intValue();
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(asnTaskResultRsp.oErrorInfo.iErrorNo));
        }
    }

    @Override
    public void getTaskDevOperationResult(int iTaskId, List oResourceLst) throws DCException {
        DCDebugTracer.trace("Method getTaskDevOperationResult start");
        ITask oTask = TaskDataModel.getInstance().getTask(iTaskId);
        if (null == oTask) {
            return;
        }
        AsnTaskResultReq oOperResultReq = new AsnTaskResultReq();
        AsnTaskResultRsp oAsnTaskDevOprResult = new AsnTaskResultRsp();
        oOperResultReq.iTaskID = BigInteger.valueOf(iTaskId);
        int iLen = oResourceLst.size();
        for (int i = 0; i < iLen; ++i) {
            oOperResultReq.oBoardResourceLst.add((Object)TaskResourceUtil.getAsnTaskResource((Resource)oResourceLst.get(i)));
        }
        this.sendSyncCmdToServer((FStruct)oOperResultReq, (FStruct)oAsnTaskDevOprResult, 44001);
        int iErrorCode = oAsnTaskDevOprResult.oErrorInfo.iErrorNo.intValue();
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(oAsnTaskDevOprResult.oErrorInfo.iErrorNo));
        }
        AsnTaskDevResultLst oTaskDevResultLst = oAsnTaskDevOprResult.oTaskDevResultLst;
        int iResSize = oTaskDevResultLst.size();
        AsnTaskDevResult oAsnTaskDevResult = null;
        Resource oResource = null;
        AsnTaskDevOpInfoLst oTaskDevOpInfoLst = null;
        for (int i = 0; i < iResSize; ++i) {
            oAsnTaskDevResult = (AsnTaskDevResult)oTaskDevResultLst.get(i);
            oResource = (Resource)oResourceLst.get(i);
            oTaskDevOpInfoLst = oAsnTaskDevResult.oTaskDevOpInfoLst;
            int iOprSize = oTaskDevOpInfoLst.size();
            AsnTaskDevOpInfo oAsnTaskDevOpInfo = null;
            ResourceProgressInfo oOperProgressInfo = null;
            oResource.clearOperationResults();
            for (int iDeviceIndex = 0; iDeviceIndex < iOprSize; ++iDeviceIndex) {
                oAsnTaskDevOpInfo = (AsnTaskDevOpInfo)oTaskDevOpInfoLst.get(iDeviceIndex);
                oOperProgressInfo = TaskCommUtil.getProgressInfoForDevOperInfo(oTask, oAsnTaskDevOpInfo);
                oResource.addOperationResult(oOperProgressInfo);
            }
        }
        oAsnTaskDevResult = null;
        oTaskDevResultLst = null;
        DCDebugTracer.trace("Method getTaskDevOperationResult end");
    }

    private void updateMode(AsnGetDevUpgradeModeReq oDevUpgradeModeRequest, ITask oTask) throws DCException {
        DCDebugTracer.trace("[upgrade mode] method updateMode start.");
        AsnGetDevUpgradeModeImmediateRsp oAsnGetDevUpgradeModeImmediateRsp = new AsnGetDevUpgradeModeImmediateRsp();
        this.sendSyncCmdToServer((FStruct)oDevUpgradeModeRequest, (FStruct)oAsnGetDevUpgradeModeImmediateRsp, 43964, 43964);
        int iErrorCode = oAsnGetDevUpgradeModeImmediateRsp.oErrorNo.iErrorNo.intValue();
        if (iErrorCode != 0) {
            DCDebugTracer.trace("[upgrade mode] method updateMode end. Have error :  " + iErrorCode);
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(oAsnGetDevUpgradeModeImmediateRsp.oErrorNo.iErrorNo));
        }
        DCDebugTracer.trace("[upgrade mode] method updateMode end.");
    }

    @Override
    public void updateDevUpgradeMode(ITask oTask) throws DCException {
        AsnGetDevUpgradeModeReq devUpgradeModeReq = TaskCommUtil.getDevUpgradeModeReqest(oTask);
        this.updateMode(devUpgradeModeReq, oTask);
    }

    @Override
    public void updateDevUpgradeMode(DeviceInfo[] oDeviceInfos) throws DCException {
        DCDebugTracer.trace("[upgrade mode] method updateDevUpgradeMode(DeviceInfo[] oDeviceInfos) start");
        if (null == oDeviceInfos || oDeviceInfos.length == 0) {
            DCDebugTracer.trace("[upgrade mode] method updateDevUpgradeMode(DeviceInfo[] oDeviceInfos) end.. oDeviceInfos is null");
            return;
        }
        AsnGetDevUpgradeModeReq asnDevUpgradeModeReq = new AsnGetDevUpgradeModeReq();
        for (DeviceInfo oDevInfo : oDeviceInfos) {
            if (null == oDevInfo) continue;
            TaskSyncCommControllerHelper.populateUpgradeModeReq(asnDevUpgradeModeReq, oDevInfo);
        }
        this.updateMode(asnDevUpgradeModeReq, null);
        DCDebugTracer.trace("[upgrade mode] method updateDevUpgradeMode(DeviceInfo[] oDeviceInfos) end..");
    }

    @Override
    public String getLastCompletedOperation(ITask oTask) {
        return TaskSyncCommControllerHelper.getLastCompletedOperation(oTask);
    }

    @Override
    public void getTaskDevOperationDetails(int iTaskId, Resource oResource) throws DCException {
        DCDebugTracer.trace("[Device Step] Method getTaskDevOperationDetails start");
        ITask oTask = TaskDataModel.getInstance().getTask(iTaskId);
        if (null == oTask) {
            return;
        }
        AsnTaskDevResultReq oOperResultReq = new AsnTaskDevResultReq();
        AsnTaskDevResultRsp oAsnDevResultRsp = new AsnTaskDevResultRsp();
        oOperResultReq.iTaskID = BigInteger.valueOf(iTaskId);
        oOperResultReq.oResourceInfo = TaskResourceUtil.getAsnTaskResource(oResource);
        this.sendSyncCmdToServer2((FStruct)oOperResultReq, (FStruct)oAsnDevResultRsp, 43966);
        int iErrorCode = oAsnDevResultRsp.oErrorInfo.iErrorNo.intValue();
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(oAsnDevResultRsp.oErrorInfo.iErrorNo));
        }
        TaskSyncCommControllerHelper.fillTaskDetailRsp(oResource, oTask, oAsnDevResultRsp);
        DCDebugTracer.trace("[Device Step] Method getTaskDevOperationDetails end");
    }

    @Override
    public List<IsolationDevOprDetailInfoObj> getIsolationDevOperationDetails(int iTaskId, Resource oResource) throws DCException {
        AsnTaskDevResultReq oOperResultReq = new AsnTaskDevResultReq();
        AsnTaskDevResultRsp oAsnDevResultRsp = new AsnTaskDevResultRsp();
        oOperResultReq.iTaskID = BigInteger.valueOf(iTaskId);
        oOperResultReq.oResourceInfo = TaskResourceUtil.getAsnTaskResource(oResource);
        this.sendSyncCmdToServer((FStruct)oOperResultReq, (FStruct)oAsnDevResultRsp, 43966);
        int iErrorCode = oAsnDevResultRsp.oErrorInfo.iErrorNo.intValue();
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(oAsnDevResultRsp.oErrorInfo.iErrorNo));
        }
        List<IsolationDevOprDetailInfoObj> oprDetailsLst = TaskSyncCommControllerHelper.getIsolationDevOprDetailLst(iTaskId, oResource, oAsnDevResultRsp);
        return oprDetailsLst;
    }

    @Override
    public void checkLoadSoftware(AsnSWCompatibilityCheckReq oAsnSWCompatibilityCheckReq) throws DCException {
        DCDebugTracer.trace("Method checkLoadSoftware start");
        AsnDCOpertionRsp oAsnDCOpertionRsp = new AsnDCOpertionRsp();
        DCFrameWorkUtil.getCommManager().addMessageListener(43990, (MSGListener)((TaskAsynCommController)TaskAsynCommController.getInstance()));
        this.sendSyncCmdToServer((FStruct)oAsnSWCompatibilityCheckReq, (FStruct)oAsnDCOpertionRsp, 43990, 43990);
        int iErrorCode = 0;
        if (oAsnDCOpertionRsp.oErrorInfo.iErrorNo.intValue() != 0) {
            DCDebugTracer.trace("Error in DC_CHECK_SOFTWARE_FILES request : " + ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode)));
            DCFrameWorkUtil.getCommManager().removeMessageListener(43990, (MSGListener)((TaskAsynCommController)TaskAsynCommController.getInstance()));
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(oAsnDCOpertionRsp.oErrorInfo.iErrorNo));
        }
        DCDebugTracer.trace("Method checkLoadSoftware end");
    }

    @Override
    public void getSlaveDevInfo(ITask oTask) throws DCException {
        AsnDCIntegerLst oAsnDCDeviceIdLstReq = TaskCommUtil.getAsnDCSlaveDevInfoReq(oTask);
        AsnDCOpertionRsp oAsnDCOpertionRsp = new AsnDCOpertionRsp();
        DCFrameWorkUtil.getCommManager().addMessageListener(44017, (MSGListener)((TaskAsynCommController)TaskAsynCommController.getInstance()));
        this.sendSyncCmdToServer((FStruct)oAsnDCDeviceIdLstReq, (FStruct)oAsnDCOpertionRsp, 44017);
        if (oAsnDCOpertionRsp.oErrorInfo.iErrorNo.intValue() != 0) {
            DCFrameWorkUtil.getCommManager().removeMessageListener(44017, (MSGListener)((TaskAsynCommController)TaskAsynCommController.getInstance()));
            throw new DCException(oAsnDCOpertionRsp.oErrorInfo.iErrorNo.intValue(), ErrorCodeReader.getInstance().getErrorDesc(oAsnDCOpertionRsp.oErrorInfo.iErrorNo));
        }
    }

    @Override
    public void checkUpgradeFeasibilitySupport(AsnUpgradeFeasibilitySupportReq oAsnUpgradeFeasibilitySupportReq) throws DCException {
        DCDebugTracer.trace("Method checkUpgradeFeasibili1tySupport start");
        AsnDCOpertionRsp oAsnDCOpertionRsp = new AsnDCOpertionRsp();
        this.sendSyncCmdToServer((FStruct)oAsnUpgradeFeasibilitySupportReq, (FStruct)oAsnDCOpertionRsp, 44014);
        if (oAsnDCOpertionRsp.oErrorInfo.iErrorNo.intValue() != 0) {
            DCDebugTracer.trace("Error in DC_IS_SUPPORT_UPGRD_FEASIBILITY request : " + ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(oAsnDCOpertionRsp.oErrorInfo.iErrorNo.intValue())));
            throw new DCException(oAsnDCOpertionRsp.oErrorInfo.iErrorNo.intValue(), ErrorCodeReader.getInstance().getErrorDesc(oAsnDCOpertionRsp.oErrorInfo.iErrorNo));
        }
        DCDebugTracer.trace("Method checkUpgradeFeasibili1tySupport end");
    }

    @Override
    public AsnDCGetDetailResultRsp getDetailsResultList(int taskid, int devid, int operationid, String checkitem) throws DCException {
        DCDebugTracer.trace("Method TaskSynCommController.getCommandResultList start");
        AsnDCGetDetailResultReq oDetailsResultReq = new AsnDCGetDetailResultReq();
        AsnDCGetDetailResultRsp oDetailsResultRsp = new AsnDCGetDetailResultRsp();
        oDetailsResultReq.iDevId = BigInteger.valueOf(devid);
        oDetailsResultReq.iTaskid = BigInteger.valueOf(taskid);
        oDetailsResultReq.enOperationId = new AsnDcDetailOperIdEnum(operationid);
        oDetailsResultReq.strCheckitem = checkitem.getBytes();
        oDetailsResultReq.enDeviceDomain = new AsnDcDevDomainEnum(DeviceInfoManagerImpl.getInstance().getDevice(devid).getDeviceTypeInfo().getDevDomain());
        this.sendSyncCmdToServer((FStruct)oDetailsResultReq, (FStruct)oDetailsResultRsp, 44044);
        int iErrorCode = oDetailsResultRsp.iErrorNo.intValue();
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(oDetailsResultRsp.iErrorNo));
        }
        DCDebugTracer.trace("Method TaskSynCommController.getCommandResultList end");
        return oDetailsResultRsp;
    }

    @Override
    public AsnGetDCExtendCheckResultRsq getExtendDetailsResultList(int taskid, int devid) throws DCException {
        DCDebugTracer.trace("Method TaskSynCommController.getExtendDetailsResultList start");
        AsnGetDCExtendCheckResultReq oDetailsResultReq = new AsnGetDCExtendCheckResultReq();
        AsnGetDCExtendCheckResultByTaskRsp oDetailsResultRsp = new AsnGetDCExtendCheckResultByTaskRsp();
        oDetailsResultReq.iDevID = BigInteger.valueOf(devid);
        oDetailsResultReq.iTaskID = BigInteger.valueOf(taskid);
        this.sendSyncCmdToServer((FStruct)oDetailsResultReq, (FStruct)oDetailsResultRsp, 44077);
        int iErrorCode = oDetailsResultRsp.oErrorInfo.iErrorNo.intValue();
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(oDetailsResultRsp.oErrorInfo.iErrorNo));
        }
        DCDebugTracer.trace("Method TaskSynCommController.getExtendDetailsResultList end");
        if (null == oDetailsResultRsp.oAsnGetDCExtendCheckResultRspLst) {
            return null;
        }
        return (AsnGetDCExtendCheckResultRsq)oDetailsResultRsp.oAsnGetDCExtendCheckResultRspLst.get(0);
    }

    @Override
    public AsnGetDCExtendCheckResultByTaskRsp getExtendResultInfoListByTask(int taskid) throws DCException {
        DCDebugTracer.trace("Method TaskSynCommController.getExtendDetailsResultList start");
        final AsnGetDCExtendCheckResultReq oDetailsResultReq = new AsnGetDCExtendCheckResultReq();
        final AsnGetDCExtendCheckResultByTaskRsp oDetailsResultRsp = new AsnGetDCExtendCheckResultByTaskRsp();
        oDetailsResultReq.iDevID = BigInteger.valueOf(0L);
        oDetailsResultReq.iTaskID = BigInteger.valueOf(taskid);
        SyncCommand oSyncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int iErrorCode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(44077), (FStruct)oDetailsResultReq, (FStruct)oDetailsResultRsp);
                return iErrorCode;
            }
        };
        int iErrorCode = 0;
        DCDebugTracer.trace("Send request to server for DC_GET_COMMAND_RESULT.");
        oSyncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        DCDebugTracer.trace("Get response from server for DC_GET_COMMAND_RESULT.");
        iErrorCode = null != oSyncCommand.getResult() ? (Integer)oSyncCommand.getResult() : -1;
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
        iErrorCode = oDetailsResultRsp.oErrorInfo.iErrorNo.intValue();
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(oDetailsResultRsp.oErrorInfo.iErrorNo));
        }
        DCDebugTracer.trace("Method TaskSynCommController.getExtendDetailsResultList end");
        return oDetailsResultRsp;
    }

    @Override
    public AsnTaskReportBoardDetailInfoRsp getBoardVerDetail(int taskId, List<BigInteger> devIdLst) throws DCException {
        DCDebugTracer.trace("Method TaskSynCommController.getBoardVerDetail start");
        AsnTaskReportBoardDetailInfoRsp taskRprtBdDtlInfRsp = new AsnTaskReportBoardDetailInfoRsp();
        if (null == devIdLst || devIdLst.size() == 0) {
            DCDebugTracer.trace("Method TaskSynCommController.getBoardVerDetail end devIdLst is null");
            return taskRprtBdDtlInfRsp;
        }
        AsnTaskReportBoardDetailInfoReq taskRprtBdDtlInfReq = new AsnTaskReportBoardDetailInfoReq();
        taskRprtBdDtlInfReq.iTaskId = BigInteger.valueOf(taskId);
        AsnDCIntegerLst asnDevIdLst = new AsnDCIntegerLst();
        if (!asnDevIdLst.addAll(devIdLst)) {
            DCDebugTracer.trace("Method TaskSynCommController.getBoardVerDetail end add devIdLst failed");
            return taskRprtBdDtlInfRsp;
        }
        taskRprtBdDtlInfReq.oAsnDeviceIdLst = asnDevIdLst;
        this.sendSyncCmdToServer((FStruct)taskRprtBdDtlInfReq, (FStruct)taskRprtBdDtlInfRsp, 44009);
        return taskRprtBdDtlInfRsp;
    }

    private void sendSyncCmdToServerWithTimeoutTime(final FStruct oSendData, final FStruct oRecvData, final int iCmd, final int timeout) throws DCException {
        SyncCommand oSyncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int iErrorCode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(iCmd), oSendData, oRecvData, timeout);
                return iErrorCode;
            }
        };
        int iErrorCode = 0;
        DCFrameWorkUtil.setCursor(Cursor.getPredefinedCursor(3));
        oSyncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        DCFrameWorkUtil.setCursor(Cursor.getDefaultCursor());
        iErrorCode = null != oSyncCommand.getResult() ? (Integer)oSyncCommand.getResult() : -1;
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
    }

    private void sendSyncCmdToServer(FStruct oSendData, FStruct oRecvData, int iCmd) throws DCException {
        int iErrorCode = DCFrameWorkUtil.getCommManager().sendSyncMsgWithSyncCommand(iCmd, oSendData, oRecvData);
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
    }

    private void sendSyncCmdToServer2(final FStruct oSendData, final FStruct oRecvData, final int iCmd) throws DCException {
        DCDebugTracer.trace("[objLock] method sendSyncCmdToServer2 start");
        int iErrorCode = 0;
        try {
            this.objLock.acquire();
            DCDebugTracer.trace("[objLock] objLock-acquire");
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
            DCDebugTracer.trace("[objLock] objLock-Exception");
            this.objLock.release();
        }
        SyncCommand oSyncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int iErrorCode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(iCmd), oSendData, oRecvData);
                TaskSyncCommController.this.objLock.release();
                DCDebugTracer.trace("[objLock] objLock-release");
                return iErrorCode;
            }
        };
        DCDebugTracer.trace("[objLock] sendSyncCmdToServer2-Send request to server for iCmd : " + iCmd + "start");
        DCFrameWorkUtil.setCursor(Cursor.getPredefinedCursor(3));
        oSyncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        DCFrameWorkUtil.setCursor(Cursor.getDefaultCursor());
        DCDebugTracer.trace("[objLock] sendSyncCmdToServer2-Send request to server for iCmd : " + iCmd + "end..");
        if (null != oSyncCommand.getResult()) {
            iErrorCode = (Integer)oSyncCommand.getResult();
        }
        if (iErrorCode != 0) {
            DCDebugTracer.trace("[objLock] method sendSyncCmdToServer2 with Exception SEND_FAIL ");
            throw new DCException(iErrorCode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
        DCDebugTracer.trace("[objLock] method sendSyncCmdToServer2 end..");
    }

    @Override
    public Calendar getCurrentServerTime(boolean bTranserToLocalTime) {
        Calendar oServerCurrentCalendar = null;
        AsnDCServerTimeRsp asnDCServerTimeRsp = new AsnDCServerTimeRsp();
        try {
            this.sendSyncCmdToServer(null, (FStruct)asnDCServerTimeRsp, 43994);
        }
        catch (DCException e) {
            return oServerCurrentCalendar;
        }
        if (null != asnDCServerTimeRsp) {
            oServerCurrentCalendar = asnDCServerTimeRsp.currentServerTime;
        }
        if (null == oServerCurrentCalendar) {
            oServerCurrentCalendar = new GregorianCalendar();
        }
        if (bTranserToLocalTime) {
            TimeDateFormatUtil.switchLocalCalendar((Calendar)oServerCurrentCalendar);
        }
        return oServerCurrentCalendar;
    }

    private void sendSyncCmdToServer(final FStruct oSendData, final FStruct oRecvData, final int iCmd, int iListenerCmd) throws DCException {
        SyncCommand oSyncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int iErrorCode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(iCmd), oSendData, oRecvData);
                return iErrorCode;
            }
        };
        int iErrorCode = 0;
        DCDebugTracer.trace("Send request to server CMD code : " + iCmd);
        DCFrameWorkUtil.setCursor(Cursor.getPredefinedCursor(3));
        oSyncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        DCFrameWorkUtil.setCursor(Cursor.getDefaultCursor());
        DCDebugTracer.trace("Get response from server for CMD code : " + iCmd);
        iErrorCode = null != oSyncCommand.getResult() ? (Integer)oSyncCommand.getResult() : -1;
        if (iErrorCode != 0) {
            DCFrameWorkUtil.getCommManager().removeMessageListener(iListenerCmd, (MSGListener)((TaskAsynCommController)TaskAsynCommController.getInstance()));
            throw new DCException(iErrorCode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
    }

    @Override
    public void boxesAutoUpgrade(String[] sData) {
        if (null == sData || sData.length < 3) {
            DCDebugTracer.trace("receive error msg for stand-alone boxes auto upgrade");
            return;
        }
        String FDN = sData[0];
        String sDevVersion = sData[1];
        String sSubMapID = sData[2];
        int iDevID = DCCommonUtil.getNEIDFormFDN(FDN);
        AsnT2000AutoUpgradeTaskReq asnT2000AutoUpgradeTaskReq = new AsnT2000AutoUpgradeTaskReq();
        asnT2000AutoUpgradeTaskReq.iDeviceId = new BigInteger("" + iDevID);
        asnT2000AutoUpgradeTaskReq.strDevVersion = sDevVersion.getBytes();
        asnT2000AutoUpgradeTaskReq.strSubMapId = sSubMapID.getBytes();
        AsnDCOpertionRsp oAsnDCOpertionRsp = new AsnDCOpertionRsp();
        try {
            DCDebugTracer.trace("dc send box request: " + iDevID + " " + sDevVersion + " " + sSubMapID);
            this.sendSyncCmdToServer((FStruct)asnT2000AutoUpgradeTaskReq, (FStruct)oAsnDCOpertionRsp, 44033);
        }
        catch (DCException e) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode(), ResourceManager.getInstance().getResString("ERROR_AUTO_TASK"), 0);
            return;
        }
        int iErrorCode = oAsnDCOpertionRsp.oErrorInfo.iErrorNo.intValue();
        if (iErrorCode != 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorCode, ResourceManager.getInstance().getResString("ERROR_AUTO_TASK"), 0);
            return;
        }
    }

    @Override
    public List ignoreOperation(HashMap mapSelectedResources) throws DCException {
        AsnToleranceReq oAsnIsolationReq = new AsnToleranceReq();
        AsnToleranceRsp oAsnIsolationRsp = new AsnToleranceRsp();
        List oTaskReqList = TaskCommUtil.populateTaskReqList(mapSelectedResources);
        int iTaskCount = oTaskReqList.size();
        for (int i = 0; i < iTaskCount; ++i) {
            oAsnIsolationReq.add(oTaskReqList.get(i));
        }
        this.sendSyncCmdToServer((FStruct)oAsnIsolationReq, (FStruct)oAsnIsolationRsp, 44048);
        int iErrorCode = oAsnIsolationRsp.oErrorInfo.iErrorNo.intValue();
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode)));
        }
        List<TaskOpResultInfo> oTaskOpResultList = TaskCommUtil.getResultListForTaskOperation(oAsnIsolationRsp.oTaskRspList);
        return oTaskOpResultList;
    }

    @Override
    public AsnDCGetDeviceFilesRsp getDeviceFiles(int iDevID) throws DCException {
        DCDebugTracer.trace("Method getDeviceFiles start");
        AsnDCGetDeviceFilesRsp oAsnDCGetDeviceFilesRsp = new AsnDCGetDeviceFilesRsp();
        AsnDCGetDeviceFilesReq oAsnDCGetDeviceFilesReq = new AsnDCGetDeviceFilesReq();
        oAsnDCGetDeviceFilesReq.iDeviceID = BigInteger.valueOf(iDevID);
        this.sendSyncCmdToServer((FStruct)oAsnDCGetDeviceFilesReq, (FStruct)oAsnDCGetDeviceFilesRsp, 44025);
        int iErrorCode = oAsnDCGetDeviceFilesRsp.oErrorNo.iErrorNo.intValue();
        if (iErrorCode != 0) {
            String strMessage = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode));
            if (null != oAsnDCGetDeviceFilesRsp.oErrorNo.strResult && 999293081 == iErrorCode) {
                strMessage = new String(oAsnDCGetDeviceFilesRsp.oErrorNo.strResult);
            }
            DCDebugTracer.trace("Error in DC_GET_DEVICE_FILES request : " + strMessage);
            throw new DCException(iErrorCode, strMessage);
        }
        DCDebugTracer.trace("Method getDeviceFiles end");
        return oAsnDCGetDeviceFilesRsp;
    }

    @Override
    public void getMemoryInfoFromDevice(AsnDCCheckDevMemoryReq oAsnDCCheckDevMemoryReq) throws DCException {
        AsnDCOpertionRsp oAsnDCOpertionRsp = new AsnDCOpertionRsp();
        DCFrameWorkUtil.getCommManager().addMessageListener(44030, (MSGListener)((TaskAsynCommController)TaskAsynCommController.getInstance()));
        this.sendSyncCmdToServer((FStruct)oAsnDCCheckDevMemoryReq, (FStruct)oAsnDCOpertionRsp, 44030);
        if (oAsnDCOpertionRsp.oErrorInfo.iErrorNo.intValue() != 0) {
            DCFrameWorkUtil.getCommManager().removeMessageListener(44030, (MSGListener)((TaskAsynCommController)TaskAsynCommController.getInstance()));
            throw new DCException(oAsnDCOpertionRsp.oErrorInfo.iErrorNo.intValue(), ErrorCodeReader.getInstance().getErrorDesc(oAsnDCOpertionRsp.oErrorInfo.iErrorNo));
        }
    }

    @Override
    public void deleteFilesFromDevice(int iReqId, Resource oResource, List<String> oSelectedFileList) throws DCException {
        AsnDCFileDeleteOnDevReq oAsnDCFileDeleteOnDevReq = TaskCommUtil.getAsnDeleteFileOnDevReq(iReqId, oResource, oSelectedFileList);
        AsnDCSyncRsp oAsnRsp = new AsnDCSyncRsp();
        DCFrameWorkUtil.getCommManager().addMessageListener(44031, (MSGListener)((TaskAsynCommController)TaskAsynCommController.getInstance()));
        this.sendSyncCmdToServer((FStruct)oAsnDCFileDeleteOnDevReq, (FStruct)oAsnRsp, 44031);
        if (0 != oAsnRsp.oErrorInfo.iErrorNo.intValue()) {
            DCFrameWorkUtil.getCommManager().removeMessageListener(44031, (MSGListener)((TaskAsynCommController)TaskAsynCommController.getInstance()));
            throw new DCException(ErrorCodeReader.getInstance().getErrorDesc(oAsnRsp.oErrorInfo.iErrorNo));
        }
    }

    @Override
    public List<String> getCommandResultInfo(int iDevId, int taskId) {
        List<String> oTaskResultList = null;
        AsnDCGetDetailResultRsp oAsnDCGetDetailResultRsp = null;
        try {
            oAsnDCGetDetailResultRsp = this.getDetailsResultList(taskId, iDevId, 2, "CurrentConfig");
        }
        catch (DCException exception) {
            DCDebugTracer.traceError(exception.getMessage());
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("GET_COMMAND_RESULT_ERROR"), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
        }
        if (null != oAsnDCGetDetailResultRsp) {
            oTaskResultList = TaskCommUtil.getCommandResultList(oAsnDCGetDetailResultRsp.oAsnDCGetCommandResultRsp);
        }
        return oTaskResultList;
    }

    @Override
    public List<SnmpConfComInfo> getSnmpConfigCompareResult(List<BigInteger> devLst, int taskId) throws DCException {
        AsnConfigureCompareReq configureCompareReq = new AsnConfigureCompareReq();
        configureCompareReq.iTaskId = BigInteger.valueOf(taskId);
        configureCompareReq.iDevIdList.addAll(devLst);
        AsnConfigureCompareRsp configureCompareRsp = new AsnConfigureCompareRsp();
        int iErrorCode = -1;
        try {
            this.sendSyncCmdToServer((FStruct)configureCompareReq, (FStruct)configureCompareRsp, 44050);
            iErrorCode = configureCompareRsp.oErrorInfo.iErrorNo.intValue();
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
            iErrorCode = e.getErrorCode();
        }
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(configureCompareRsp.oErrorInfo.iErrorNo));
        }
        List<SnmpConfComInfo> snmpConfComInfoLst = TaskSyncCommControllerHelper.fillSnmpConf(configureCompareRsp);
        return snmpConfComInfoLst;
    }

    @Override
    public void updateOperationList(AsnTaskInfo oAsntaskInfo, ITask oTaskDatObj, boolean bAutoTask) {
        TaskSyncCommControllerHelper.updateOperationList(oAsntaskInfo, oTaskDatObj, bAutoTask);
    }

    @Override
    public int getCheckReportDetails(int iTaskID, THashSet<Resource> resourceList) throws DCException {
        AsnCheckReportAckRsp oAsnCheckReportRsp = new AsnCheckReportAckRsp();
        AsnCheckReportReq oAsnCheckReportReq = TaskCommUtil.getCheckReportRequest(iTaskID, resourceList, 2);
        this.sendSyncCmdToServer((FStruct)oAsnCheckReportReq, (FStruct)oAsnCheckReportRsp, 44088);
        int iErrorCode = oAsnCheckReportRsp.oErrorInfo.iErrorNo.intValue();
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(oAsnCheckReportRsp.oErrorInfo.iErrorNo));
        }
        ReportPacketInfo instance = ReportPacketInfo.getInstance();
        instance.setPacketNum(oAsnCheckReportRsp.iNumOfReportTable.intValue());
        instance.clearPacketLstInfo();
        return oAsnCheckReportRsp.iNumOfReportTable.intValue();
    }
}

