/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.controller;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCErrorCodeInfo;
import com.huawei.dc.common.asndatacenter.AsnDCSyncRsp;
import com.huawei.dc.common.asndatacenter.AsnDowngradeValidityErrorInfo;
import com.huawei.dc.common.asndatacenter.AsnDowngradeValidityErrorInfoLst;
import com.huawei.dc.common.asndatacenter.AsnDowngradeValidityReq;
import com.huawei.dc.common.asndatacenter.AsnDowngradeValidityRsp;
import com.huawei.dc.common.asndatacenter.AsnLoadSWInfo;
import com.huawei.dc.common.asndatacenter.AsnLoadSWInfoLst;
import com.huawei.dc.common.components.dialog.SimpleProgressDlg;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfoListParam;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationOperation;
import com.huawei.dc.devicemanagement.deviceoperation.recoverdb.RecoverDBOperation;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.sam.controller.TargetVersionPathGetter;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.common.TaskOperationResultDialog;
import com.swimap.iview.communicate.MSGPacketExt;
import com.swimap.iview.util.SyncCommand;
import gnu.trove.THashSet;
import java.awt.Component;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import net.commustru.fstru.FStruct;

public class TaskSrcDstVersionCheck {
    private static final long serialVersionUID = 1L;
    private SimpleProgressDlg m_oValidationDesVerProgressDlg = null;
    private TaskOperationResultDialog m_oValDesVerResultDialog = null;
    private boolean bValDesVerFail = false;
    private boolean bValSendCmdFail = false;
    private int iDowngradeType = 0;
    private static TaskSrcDstVersionCheck m_TaskSrcDstVersionCheck;
    private static String strThirdFTPServerName;

    public static TaskSrcDstVersionCheck getInstance() {
        if (null == m_TaskSrcDstVersionCheck) {
            m_TaskSrcDstVersionCheck = new TaskSrcDstVersionCheck();
        }
        return m_TaskSrcDstVersionCheck;
    }

    public boolean getTaskTypeinfoIsUpgradeOrDowngrade(int iTaskType) {
        return 4 == iTaskType || 13 == iTaskType;
    }

    public boolean isTaskContainDeleteDBOperation(ITask m_oTaskDataObj) {
        List<ITaskDeviceOperation> oList = m_oTaskDataObj.getSupportedOperation();
        for (int i = 0; i < oList.size(); ++i) {
            ITaskDeviceOperation oTaskDeviceOperation = oList.get(i);
            String strOpr = oTaskDeviceOperation.getOperationIdString();
            if ("DeleteDatabase".equals(strOpr)) {
                return true;
            }
            if (!"Recover".equals(strOpr)) continue;
            return false;
        }
        return false;
    }

    public void validateDestinationVersion(ITask m_oTaskDataObj) {
        ITaskDeviceOperation oTaskOp;
        DCDebugTracer.trace("Method TaskMgmtOperationSelecPanelHelper#validateDestinationVersion start..->");
        DCDebugTracer.trace("TargetVersion:" + m_oTaskDataObj.getTargetVersion());
        this.setbValDesVerFail(false);
        int iTaskType = m_oTaskDataObj.getTaskTypeId();
        if (this.getTaskTypeinfoIsUpgradeOrDowngrade(iTaskType) && (oTaskOp = TaskCommUtil.getTaskOperation(m_oTaskDataObj.getSupportedOperation(), "LoadSoftware")).isSelected()) {
            this.isDestinationVersionOk(oTaskOp, m_oTaskDataObj);
        }
        DCDebugTracer.trace("Method TaskMgmtOperationSelecPanelHelper#validateDestinationVersion end..");
    }

    private AsnLoadSWInfoLst getAsnLoadSWInfoLst(THashSet<Resource> oResourceLst, ITask m_oTaskDataObj) {
        AsnLoadSWInfoLst oAsnLoadSWInfoLst = new AsnLoadSWInfoLst();
        LoadFileInfo oLoadFileInfo = null;
        LoadFileInfoListParam oLoadFileInfoListParam = m_oTaskDataObj.getLoadFileInfoListParam();
        if (null != oLoadFileInfoListParam) {
            List<LoadFileInfo> oLoadFileInfoLst = oLoadFileInfoListParam.getLoadFileInfoList();
            Iterator oResItor = oResourceLst.iterator();
            Resource oResource = null;
            int index = 0;
            while (oResItor.hasNext()) {
                oResource = (Resource)oResItor.next();
                AsnLoadSWInfo oAsnLoadSWInf = new AsnLoadSWInfo();
                oAsnLoadSWInf.iDevId = BigInteger.valueOf(oResource.getDeviceID());
                for (int j = 0; j < oLoadFileInfoLst.size(); ++j) {
                    oLoadFileInfo = oLoadFileInfoLst.get(j);
                    if (oLoadFileInfo.getDeviceId() != 0 && oLoadFileInfo.getDeviceId() != oResource.getDeviceID()) continue;
                    oAsnLoadSWInf.strFileName = oLoadFileInfo.getFileName().getBytes();
                    DCDebugTracer.trace("TaskSrcDstVersionCheck:SelectFile->" + oLoadFileInfo.getFileName());
                    break;
                }
                oAsnLoadSWInfoLst.add(index, (Object)oAsnLoadSWInf);
                ++index;
            }
        }
        return oAsnLoadSWInfoLst;
    }

    private AsnLoadSWInfoLst getAsnLoadSWInfoLstFromTargetVersion(THashSet<Resource> oResourceLst, ITask m_oTaskDataObj) {
        String strTargetFilePath = TargetVersionPathGetter.getTargetVersionDir(m_oTaskDataObj.getDeviceType(), m_oTaskDataObj.getTargetVersion(), m_oTaskDataObj);
        AsnLoadSWInfoLst oAsnLoadSWInfoLst = new AsnLoadSWInfoLst();
        Iterator oResItor = oResourceLst.iterator();
        Resource oResource = null;
        int index = 0;
        while (oResItor.hasNext()) {
            oResource = (Resource)oResItor.next();
            AsnLoadSWInfo oAsnLoadSWInf = new AsnLoadSWInfo();
            oAsnLoadSWInf.iDevId = BigInteger.valueOf(oResource.getDeviceID());
            oAsnLoadSWInf.strFileName = strTargetFilePath.getBytes();
            DCDebugTracer.trace("TaskSrcDstVersionCheck:SelectFile->" + strTargetFilePath);
            oAsnLoadSWInfoLst.add(index, (Object)oAsnLoadSWInf);
            ++index;
        }
        return oAsnLoadSWInfoLst;
    }

    private void isDestinationVersionOk(final ITaskDeviceOperation oTaskOp, final ITask m_oTaskDataObj) {
        this.validationProgressDlg();
        Thread oCheckDestinationVersion = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TaskSrcDstVersionCheck.this.sendSyncCmdCode(oTaskOp, m_oTaskDataObj);
                }
                catch (Exception e) {
                    DCDebugTracer.traceDetail("TaskSrcDstVersionCheck#sendSyncCmdCode Exception");
                    DCDebugTracer.trace(e);
                    TaskSrcDstVersionCheck.this.setbSendCmdFail(true);
                    TaskSrcDstVersionCheck.this.setbValDesVerFail(true);
                    TaskSrcDstVersionCheck.this.m_oValidationDesVerProgressDlg.doCleanUp();
                }
            }
        });
        oCheckDestinationVersion.start();
        try {
            this.m_oValidationDesVerProgressDlg.setVisible(true);
        }
        catch (Exception e) {
            DCDebugTracer.trace("m_oValidationDesVerProgressDlg setVisible(true) failed.");
            DCDebugTracer.trace(e);
        }
    }

    public void handleDesVersionCheck(MSGPacketExt packetExt) {
        DCDebugTracer.trace("handleDesVersionCheck Process cmdCode:" + packetExt.mheader.cmdCode);
        AsnDowngradeValidityRsp oAsnDowngradeValidityRsp = new AsnDowngradeValidityRsp();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnDowngradeValidityRsp, packetExt.getData());
        if (0 == iErrorCode) {
            AsnDowngradeValidityErrorInfoLst oAsnDowngradeValidityErrorInfoLst;
            if (null != oAsnDowngradeValidityRsp && (oAsnDowngradeValidityErrorInfoLst = oAsnDowngradeValidityRsp.oErrorInfoLst).size() > 0) {
                this.setbValDesVerFail(true);
                this.m_oValDesVerResultDialog = new TaskOperationResultDialog(ResourceManager.getInstance().getResString("DESTINATION_VERSION_VALIDATION_RESULT"), 0, true, this.getColumns());
                if (null != this.m_oValidationDesVerProgressDlg) {
                    this.m_oValDesVerResultDialog.setModalParent(this.m_oValidationDesVerProgressDlg.getModalParent());
                }
                this.m_oValDesVerResultDialog.setMessage(ResourceManager.getInstance().getResString("DESTINATION_VERSION_VALIDATION_NOTICE_PART"));
                this.initTableData(oAsnDowngradeValidityErrorInfoLst);
                try {
                    this.m_oValidationDesVerProgressDlg.doCleanUp();
                }
                catch (Exception e) {
                    DCDebugTracer.trace(e);
                }
                try {
                    this.m_oValDesVerResultDialog.setVisible(true);
                }
                catch (Exception e) {
                    DCDebugTracer.trace(e);
                }
            }
            if (null != this.m_oValidationDesVerProgressDlg) {
                try {
                    this.m_oValidationDesVerProgressDlg.doCleanUp();
                }
                catch (Exception e) {
                    DCDebugTracer.trace(e);
                }
            }
        }
    }

    private void sendSyncCmdCode(ITaskDeviceOperation oTaskOp, ITask m_oTaskDataObj) throws DCException {
        AsnLoadSWInfoLst oAsnLoadSWInfoLst;
        THashSet<Resource> oResourceLst = m_oTaskDataObj.getDeviceType().getResources();
        String strTargetVer = m_oTaskDataObj.getTargetVersion();
        final AsnDowngradeValidityReq oAsnDowngradeValidityReq = new AsnDowngradeValidityReq();
        int iReqID = DCFrameWorkUtil.generateRequestId();
        final AsnDCSyncRsp oAsnDCSyncRsp = new AsnDCSyncRsp();
        oAsnDowngradeValidityReq.oReqID = BigInteger.valueOf(iReqID);
        if (m_oTaskDataObj.isThirdPartySupported() && null != m_oTaskDataObj.getThirdPartyServerName()) {
            oAsnDowngradeValidityReq.ostrThirdFtpServerName = strThirdFTPServerName.getBytes();
        }
        oAsnDowngradeValidityReq.bCheckUpgradeValidity = false;
        if (4 == m_oTaskDataObj.getTaskTypeId()) {
            oAsnDowngradeValidityReq.bCheckUpgradeValidity = true;
        }
        oAsnDowngradeValidityReq.oLoadSWInfoLst = !strTargetVer.equals("") && this.isSelectFileInTargerVerFromSAM(m_oTaskDataObj) ? (oAsnLoadSWInfoLst = this.getAsnLoadSWInfoLstFromTargetVersion(oResourceLst, m_oTaskDataObj)) : (oAsnLoadSWInfoLst = this.getAsnLoadSWInfoLst(oResourceLst, m_oTaskDataObj));
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int iErrorCode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(44094), (FStruct)oAsnDowngradeValidityReq, (FStruct)oAsnDCSyncRsp);
                return iErrorCode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        int iErrorCode = 0;
        if (null != syncCommand.getResult()) {
            iErrorCode = (Integer)syncCommand.getResult();
        }
        if (0 != iErrorCode) {
            DCDebugTracer.trace("TaskCommUtil2#isDestinationVersionOk#sendSyncCmdCode:ASNErrorcode:" + iErrorCode);
            throw new DCException(iErrorCode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
        if (0 != oAsnDCSyncRsp.oErrorInfo.iErrorNo.intValue()) {
            int errorCode = oAsnDCSyncRsp.oErrorInfo.iErrorNo.intValue();
            DCDebugTracer.trace("TaskCommUtil2#isDestinationVersionOk#sendSyncCmdCode:oAsnDCSyncRsp:" + errorCode);
            throw new DCException(errorCode, ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(errorCode)));
        }
    }

    private void validationProgressDlg() {
        this.m_oValidationDesVerProgressDlg = new SimpleProgressDlg(ResourceManager.getInstance().getResString("DESTINATION_VERSION_VALIDATION_TITLE"), true, ResourceManager.getInstance().getResString("GETTING_DESTINATION_VERSION_VALIDATION_TITLE")){
            private static final long serialVersionUID = 1L;

            @Override
            public void cancelButtonActionPerformed() {
                TaskSrcDstVersionCheck.this.setbValDesVerFail(true);
            }

            @Override
            protected void closeDialog() {
                super.closeDialog();
                TaskSrcDstVersionCheck.this.setbValDesVerFail(true);
            }
        };
        this.m_oValidationDesVerProgressDlg.setModalParent(null);
        this.m_oValidationDesVerProgressDlg.setDefaultCloseOperation(2);
    }

    protected String[] getColumns() {
        String TABLE_COLUMN_0_NAME = ResourceManager.getInstance().getResString("DEVICE_NAME");
        String m_sTableColumn1Name = ResourceManager.getInstance().getResString("TASK_REPORT_DEVICE_IP");
        String TABLE_COLUMN_2_NAME = ResourceManager.getInstance().getResString("PATCH_MANAGEMENT_DETAILS_BTN_TOOL_TIP_TEXT");
        return new String[]{TABLE_COLUMN_0_NAME, m_sTableColumn1Name, TABLE_COLUMN_2_NAME};
    }

    protected void initTableData(AsnDowngradeValidityErrorInfoLst oAsnDowngradeValidityErrorInfoLst) {
        AsnDowngradeValidityErrorInfo oAsnDowngradeValidityErrorInfo = null;
        AsnDCErrorCodeInfo oErrorInfo = null;
        String sDevName = "";
        String iDevIP = "";
        String strErrorInfo = "";
        Resource resource = null;
        for (int i = 0; i < oAsnDowngradeValidityErrorInfoLst.size(); ++i) {
            oAsnDowngradeValidityErrorInfo = (AsnDowngradeValidityErrorInfo)oAsnDowngradeValidityErrorInfoLst.get(i);
            BigInteger iBigIntDevID = oAsnDowngradeValidityErrorInfo.iErrorDeviceId;
            int iDevID = iBigIntDevID.intValue();
            resource = DCFrameWorkUtil.getDeviceInfoManager().getResourceForID(iDevID);
            sDevName = resource.getDeviceName();
            iDevIP = resource.getDeviceIP();
            oErrorInfo = oAsnDowngradeValidityErrorInfo.oErrorInfo;
            strErrorInfo = ErrorCodeReader.getInstance().getErrorDesc(oErrorInfo.iErrorNo);
            Vector<Object> rowVector = new Vector<Object>();
            rowVector.add(sDevName);
            rowVector.add(iDevIP);
            rowVector.add(strErrorInfo);
            this.m_oValDesVerResultDialog.addRowInModel(rowVector);
        }
    }

    public void setbValDesVerFail(boolean bFlag) {
        this.bValDesVerFail = bFlag;
    }

    public boolean getbValDesVerFail() {
        return this.bValDesVerFail;
    }

    public void setbSendCmdFail(boolean bFlag) {
        this.bValSendCmdFail = bFlag;
    }

    public boolean getbSendCmdVerFail() {
        return this.bValSendCmdFail;
    }

    public int iTaskTypeKey(int iTaskType, ITask oTask) {
        if (13 == iTaskType) {
            iTaskType = iTaskType * 10 + this.getDownGradeType(oTask);
        }
        return iTaskType;
    }

    public void setDownGradeType(int iValue, ITask oTask) {
        this.iDowngradeType = iValue;
        if (null != oTask) {
            oTask.setDownGradeType(iValue);
        }
    }

    public int getDownGradeType(ITask oTask) {
        if (null != oTask) {
            return oTask.getDownGradeType();
        }
        return this.iDowngradeType;
    }

    public boolean isDisableTaskOpr(int iTaskType, String strOpr) {
        return iTaskType == 13 && ("DeleteDatabase".equals(strOpr) || "Recover".equals(strOpr) || "ActivateSoftware".equals(strOpr));
    }

    public boolean isEnableLinkString(int iTaskType, ITaskDeviceOperation oTaskDevOp) {
        return (oTaskDevOp instanceof RecoverDBOperation || oTaskDevOp instanceof ActivationOperation) && iTaskType == 13;
    }

    public boolean isInChina() {
        boolean bIsInChina = false;
        Locale locale = Locale.getDefault();
        if ("CN".equals(locale.getCountry()) && "zh".equals(locale.getLanguage())) {
            bIsInChina = true;
        }
        return bIsInChina;
    }

    public boolean isSelectFileInTargerVerFromSAM(ITask m_oTaskDataObj) {
        String strTargetVer = m_oTaskDataObj.getTargetVersion();
        if (strTargetVer.equals("")) {
            return false;
        }
        String strTargetFilePath = TargetVersionPathGetter.getTargetVersionDir(m_oTaskDataObj.getDeviceType(), strTargetVer, m_oTaskDataObj);
        LoadFileInfoListParam oLoadFileInfoListParam = m_oTaskDataObj.getLoadFileInfoListParam();
        if (null == oLoadFileInfoListParam) {
            return false;
        }
        List<LoadFileInfo> oLoadFileInfoLst = oLoadFileInfoListParam.getLoadFileInfoList();
        LoadFileInfo oLoadFileInfo = oLoadFileInfoLst.get(0);
        String strSelectFilePath = oLoadFileInfo.getFileName();
        DCDebugTracer.trace("TaskSrcDstVersionCheck#isSelectFileInTargerVerFromSAM:" + strSelectFilePath);
        if (strSelectFilePath.equals("")) {
            return false;
        }
        return strSelectFilePath.equals(strTargetFilePath);
    }

    public void setThirdFTPServerName(String strValue) {
        strThirdFTPServerName = strValue;
    }

    public String getThirdFTPServerName() {
        return strThirdFTPServerName;
    }

    static {
        strThirdFTPServerName = null;
    }
}

