/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.controller;

import com.huawei.dc.adapter.swimap.iview.commstyle.resource.DCResourceMng;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCExtendCheckResultEle;
import com.huawei.dc.common.asndatacenter.AsnExtendCheckResult;
import com.huawei.dc.common.asndatacenter.AsnExtendCheckResultLst;
import com.huawei.dc.common.asndatacenter.AsnExtendCheckResultRowLst;
import com.huawei.dc.common.asndatacenter.AsnGetDCExtendCheckResultByTaskRsp;
import com.huawei.dc.common.asndatacenter.AsnGetDCExtendCheckResultRspLst;
import com.huawei.dc.common.asndatacenter.AsnGetDCExtendCheckResultRsq;
import com.huawei.dc.common.asndatacenter.AsnTaskResource;
import com.huawei.dc.common.asndatacenter.AsnTaskResourceLst;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.ExcelFileWtiterHelper;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.taskmgmt.controller.TaskSyncCommController;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.report.view.SimpleProgressDlg;
import java.awt.Component;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.Colour;
import jxl.format.UnderlineStyle;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;

public class TaskResourceUtil {
    private static final int SEQUENCE_NO_COL = 0;
    private static final int DEV_ID_COL = 1;
    private static final int IP_COL = 2;
    private static final int DETAIL_RESULT_COL = 3;

    public static AsnTaskResource getAsnTaskResource(Resource oResource) {
        AsnTaskResource oAsnTaskResource = null;
        if (oResource != null) {
            oAsnTaskResource = new AsnTaskResource();
            oAsnTaskResource.iDeviceId = BigInteger.valueOf(oResource.getDeviceID());
            oAsnTaskResource.iFrameId = BigInteger.valueOf(oResource.getFrameId());
            oAsnTaskResource.iParentDevId = BigInteger.valueOf(oResource.getParentDevId());
            oAsnTaskResource.iSlotId = BigInteger.valueOf(oResource.getSlotId());
            oAsnTaskResource.iRoleType = BigInteger.valueOf(oResource.getRoleType());
            oAsnTaskResource.iSubSlotId = BigInteger.valueOf(oResource.getSubSlotId());
            oAsnTaskResource.iStackId = BigInteger.valueOf(oResource.getStackId());
            if (null != oResource.getDeviceVersion()) {
                oAsnTaskResource.strSWversion = oResource.getDeviceVersion().getBytes();
            }
            if (null != oResource.getStackDevTypeInfo()) {
                oAsnTaskResource.iDevTypeId = BigInteger.valueOf(oResource.getStackDevTypeInfo().getDevTypeID());
                oAsnTaskResource.iDevTypeVerId = BigInteger.valueOf(oResource.getStackDevTypeInfo().getDevTypeVersionId());
            }
        }
        return oAsnTaskResource;
    }

    public static AsnTaskResourceLst getAsnTaskResourceLst(List<Resource> resource) {
        AsnTaskResourceLst oAsnTaskResourceLst = new AsnTaskResourceLst();
        int iSize = resource.size();
        for (int i = 0; i < iSize; ++i) {
            oAsnTaskResourceLst.add((Object)TaskResourceUtil.getAsnTaskResource(resource.get(i)));
        }
        return oAsnTaskResourceLst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getExtendResultInfo(int taskId, String filePath) {
        DCDebugTracer.trace("Method TaskCommUtil#getExtendResultInfo start");
        AsnGetDCExtendCheckResultByTaskRsp oDetailsResultRsp = null;
        try {
            oDetailsResultRsp = TaskSyncCommController.getInstance().getExtendResultInfoListByTask(taskId);
        }
        catch (DCException e) {
            DCDebugTracer.trace(e.getCause());
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getMessage(), ResourceManager.getInstance().getResString("ERROR_MESSAGE"), 0);
            return;
        }
        if (null != oDetailsResultRsp && null != oDetailsResultRsp.oErrorInfo) {
            boolean bIsMemoryAvailable;
            boolean bSaveSuccess;
            block18: {
                if (0 != oDetailsResultRsp.oErrorInfo.iErrorNo.intValue()) {
                    DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), oDetailsResultRsp.oErrorInfo.iErrorNo.intValue());
                    DCDebugTracer.trace("Method TaskCommUtil#getExtendResultInfo return" + oDetailsResultRsp.oErrorInfo.iErrorNo.intValue());
                    return;
                }
                AsnGetDCExtendCheckResultRspLst resultLstByDev = oDetailsResultRsp.oAsnGetDCExtendCheckResultRspLst;
                bSaveSuccess = true;
                WritableWorkbook workbook = null;
                WorkbookSettings workSpace = new WorkbookSettings();
                workSpace.setLocale(DCResourceMng.getInstance().getLocale());
                ExcelFileWtiterHelper excelHelper = new ExcelFileWtiterHelper();
                File reportFile = new File(filePath);
                String fileName = "";
                if (null == reportFile) {
                    DCDebugTracer.trace("TaskResourceUtil::getExtendResultInfo::reportFile is null");
                    return;
                }
                fileName = reportFile.getName();
                bIsMemoryAvailable = true;
                try {
                    workbook = Workbook.createWorkbook((File)reportFile, (WorkbookSettings)workSpace);
                    WritableSheet totalSheet = workbook.createSheet(ResourceManager.getInstance().getResString("EXTEND_REPORT_INFO"), 0);
                    ArrayList resList = TaskResourceUtil.writeExtendedExcelFile(resultLstByDev, workbook, excelHelper);
                    TaskResourceUtil.writeTotalSheet(totalSheet, excelHelper, resList, fileName);
                    long lFreeMemoryAvail = 0L;
                    long lFileSize = 0L;
                    if (null != reportFile) {
                        lFreeMemoryAvail = reportFile.getFreeSpace();
                    }
                    lFileSize = excelHelper.getExcelFileContentSize(workbook);
                    if (0L == lFreeMemoryAvail || lFreeMemoryAvail < lFileSize) {
                        bIsMemoryAvailable = false;
                    }
                    if (bIsMemoryAvailable) {
                        workbook.write();
                        break block18;
                    }
                    throw new DCException(ResourceManager.getInstance().getResString("TASK_REPORT_INSUFFICIENT_MEMORY"));
                }
                catch (Exception e) {
                    bSaveSuccess = false;
                    DCDebugTracer.trace(e);
                }
                finally {
                    FileUtil.freeExcelReference(workbook);
                }
            }
            if (bSaveSuccess) {
                TaskResourceUtil.showOpenExtendedReportFlieDlg(filePath);
            } else if (!bIsMemoryAvailable) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("TASK_REPORT_INSUFFICIENT_MEMORY"), ResourceManager.getInstance().getResString("ERROR_MESSAGE"), 0);
            } else {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SAVE_FAILURE"), ResourceManager.getInstance().getResString("ERROR_MESSAGE"), 0);
            }
        } else {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("Error_Code_105"), ResourceManager.getInstance().getResString("INFO"), 1);
        }
        DCDebugTracer.trace("Method TaskCommUtil#getExtendResultInfo end");
    }

    private static void writeTotalSheet(WritableSheet totalSheet, ExcelFileWtiterHelper excelHelper, ArrayList<Resource> resList, String fileName) {
        ExcelFileWtiterHelper.addCell(0, 0, ResourceManager.getInstance().getResString("TASK_REPORT_SEQUENCE_NO"), excelHelper.getTeaFormat(), totalSheet);
        ExcelFileWtiterHelper.addCell(1, 0, ResourceManager.getInstance().getResString("TASK_REPORT_DEVICE_NAME"), excelHelper.getTeaFormat(), totalSheet);
        ExcelFileWtiterHelper.addCell(2, 0, ResourceManager.getInstance().getResString("IP_ADDRESS"), excelHelper.getTeaFormat(), totalSheet);
        ExcelFileWtiterHelper.addCell(3, 0, ResourceManager.getInstance().getResString("TASK_REPORT_RESULT"), excelHelper.getTeaFormat(), totalSheet);
        totalSheet.setColumnView(0, 10);
        totalSheet.setColumnView(1, 30);
        totalSheet.setColumnView(2, 30);
        totalSheet.setColumnView(3, 30);
        for (int i = 0; i < resList.size(); ++i) {
            Resource resource = resList.get(i);
            ExcelFileWtiterHelper.addCell(0, i + 1, String.valueOf(i + 1), excelHelper.getStrFormat(), totalSheet);
            String text = null;
            try {
                text = "HYPERLINK(\"[" + fileName + "] " + "'" + resource.getDeviceName() + "'!" + "A2" + "\", \" " + resource.getDeviceName() + "\")";
            }
            catch (Exception e) {
                DCDebugTracer.trace(e);
                text = resource.getDeviceName();
            }
            ExcelFileWtiterHelper.addHyperLink(1, i + 1, text, totalSheet);
            ExcelFileWtiterHelper.addCell(2, i + 1, resource.getDeviceIP(), excelHelper.getStrFormat(), totalSheet);
            if (resource.isExtendCheckFail()) {
                ExcelFileWtiterHelper.addCell(3, i + 1, ResourceManager.getInstance().getResString("SUCCESS_RESULT"), excelHelper.getStrFormat(), totalSheet);
                continue;
            }
            ExcelFileWtiterHelper.addCell(3, i + 1, ResourceManager.getInstance().getResString("FAILURE_RESULT"), excelHelper.getRedFormatFG(), totalSheet);
        }
    }

    private static ArrayList writeExtendedExcelFile(AsnGetDCExtendCheckResultRspLst resultLstByDev, WritableWorkbook workbook, ExcelFileWtiterHelper excelHelper) {
        if (null == resultLstByDev) {
            return null;
        }
        ArrayList<Resource> resList = new ArrayList<Resource>();
        AsnGetDCExtendCheckResultRsq asnGetDCExtendCheckResultRsq = null;
        String EXTEND_CHECK_DISPLAY_CONDITION = "(YES)";
        WritableFont RED_FONT = new WritableFont(WritableFont.ARIAL, 12, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.RED);
        WritableCellFormat redFormatFG = new WritableCellFormat(RED_FONT);
        WritableFont tenfont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE);
        WritableCellFormat strFormat = new WritableCellFormat(tenfont);
        try {
            redFormatFG.setAlignment(Alignment.LEFT);
            redFormatFG.setBorder(Border.ALL, BorderLineStyle.THIN);
            redFormatFG.setWrap(true);
            strFormat.setAlignment(Alignment.LEFT);
            strFormat.setBorder(Border.ALL, BorderLineStyle.THIN);
            strFormat.setWrap(true);
        }
        catch (WriteException ignore) {
            DCDebugTracer.trace("[ignore]" + (Object)((Object)ignore));
        }
        for (int i = 0; i < resultLstByDev.size(); ++i) {
            asnGetDCExtendCheckResultRsq = (AsnGetDCExtendCheckResultRsq)resultLstByDev.get(i);
            AsnExtendCheckResult asnExtendCheckResult = asnGetDCExtendCheckResultRsq.oAsnExtendCheckResult;
            AsnExtendCheckResultLst asnExtendCheckResultLst = asnExtendCheckResult.oAsnExtendCheckResultLst;
            Resource resource = DeviceInfoManagerImpl.getInstance().getResourceForID(asnGetDCExtendCheckResultRsq.iDevID.intValue());
            if (null == resource) {
                DCDebugTracer.trace("TaskCommUtil#writeExtendedExcelFile get res fail.iDevID=" + asnGetDCExtendCheckResultRsq.iDevID.intValue());
                continue;
            }
            resource.setExtendCheckFail(true);
            WritableSheet resouseSheet = workbook.createSheet(resource.getDeviceName(), i + 1);
            int row = 0;
            for (int j = 0; j < asnExtendCheckResultLst.size(); ++j) {
                AsnExtendCheckResultRowLst asnExtendCheckResultRowLst = (AsnExtendCheckResultRowLst)asnExtendCheckResultLst.get(j);
                resouseSheet.getSettings().setShowGridLines(true);
                String[] rowData = new String[asnExtendCheckResultRowLst.size()];
                boolean isNeedRed = false;
                for (int k = 0; k < asnExtendCheckResultRowLst.size(); ++k) {
                    AsnDCExtendCheckResultEle asnDCExtendCheckResultEle = (AsnDCExtendCheckResultEle)asnExtendCheckResultRowLst.get(k);
                    rowData[k] = new String(asnDCExtendCheckResultEle.strValue);
                    if (EXTEND_CHECK_DISPLAY_CONDITION.equals(rowData[k].trim())) {
                        isNeedRed = true;
                        resource.setExtendCheckFail(false);
                    }
                    if (j != 0) continue;
                    ExcelFileWtiterHelper.addCell(k, j, rowData[k], excelHelper.getTeaFormat(), resouseSheet);
                }
                if (j == 0) {
                    ++row;
                } else {
                    for (int l = 0; l < rowData.length; ++l) {
                        if (isNeedRed) {
                            ExcelFileWtiterHelper.addCell(l, row, rowData[l], redFormatFG, resouseSheet);
                            continue;
                        }
                        ExcelFileWtiterHelper.addCell(l, row, rowData[l], strFormat, resouseSheet);
                    }
                    ++row;
                }
                resouseSheet.setColumnView(j, 30);
            }
            resList.add(resource);
        }
        return resList;
    }

    private static void showOpenExtendedReportFlieDlg(String filePath) {
        String opeName = ResourceManager.getInstance().getResString("OPERATION_RESOULT_SUTO_PROGRESS");
        String strTitle = ResourceManager.getInstance().getResString("GENERATE_EXTEND_REPORT_INFO");
        final SimpleProgressDlg progressDlg = new SimpleProgressDlg(ResourceManager.getInstance().getResString("GENERATE_REPORT_BTN"), opeName);
        progressDlg.setTitle(strTitle);
        ArrayList<String> taskFilePathNameLst = new ArrayList<String>();
        taskFilePathNameLst.add(filePath);
        progressDlg.setUserObject(taskFilePathNameLst);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                progressDlg.showDetailInfo();
                progressDlg.setVisible(true);
            }
        });
        progressDlg.setProgress(filePath, ResourceManager.getInstance().getResString("SAVE_SUCCESS"), 100);
    }
}

