/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.controller;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.model.TreeTableRowData;
import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.taskmgmt.controller.ITaskNotificationListener;
import com.huawei.dc.taskmgmt.controller.LogInfoNotifier;
import com.huawei.dc.taskmgmt.controller.TaskAsynCommController;
import com.huawei.dc.taskmgmt.controller.TaskEvent;
import com.huawei.dc.taskmgmt.controller.TaskEventID;
import com.huawei.dc.taskmgmt.controller.TaskSyncCommController;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.TaskDataModel;
import com.huawei.dc.taskmgmt.model.TaskProgressInfo;
import com.huawei.dc.taskmgmt.view.common.TaskDeviceOperationListPanel;
import com.huawei.dc.taskmgmt.view.common.TaskDeviceOperationLogPanel;
import com.huawei.dc.taskmgmt.view.tasktable.TaskTableUtil;
import gnu.trove.THashSet;
import java.awt.Component;
import java.io.Serializable;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class TaskOprDetailsController
implements Serializable,
ITaskNotificationListener {
    private static final long serialVersionUID = 6201275893136228302L;
    private DCSortableTreeTable m_oTaskTreeTable = DCFrameWorkUtil.getTaskTablePanel().getTaskTreeTable();
    private int m_iDeviceID = -1;
    private Resource m_oSelectedRes = null;
    private int m_iTaskID = -1;
    private TaskDeviceOperationLogPanel m_oLogPanelInstance = null;
    private TaskDeviceOperationListPanel m_oOprListPanelInstance = null;

    public void sendReqForDevOprDetails(boolean bNeedSetData) {
        if (bNeedSetData) {
            this.setData();
        }
        try {
            ITask oTask = TaskDataModel.getInstance().getTask(this.m_iTaskID);
            if (null != oTask && 0 != oTask.getTaskProgressInfo().getState()) {
                if (null == this.m_oSelectedRes || oTask.isT2000Domain() && this.m_oSelectedRes.isBoard()) {
                    if (null != this.m_oSelectedRes) {
                        DCDebugTracer.trace("DC::TaskOprDetailsController::onTreeNodeSelection::m_iTaskID = " + this.m_iTaskID + ";deviceID = " + this.m_oSelectedRes.getDeviceID() + ";deviceName = " + this.m_oSelectedRes.getDeviceName());
                    } else {
                        DCDebugTracer.trace("DC::TaskOprDetailsController::onTreeNodeSelection::m_iTaskID = " + this.m_iTaskID);
                    }
                    return;
                }
                DCDebugTracer.traceDetail("DC::TaskOprDetailsController::onTreeNodeSelection::m_iTaskID = " + this.m_iTaskID + ";deviceID = " + this.m_oSelectedRes.getDeviceID());
                TaskSyncCommController.getInstance().getTaskDevOperationDetails(this.m_iTaskID, this.m_oSelectedRes);
            }
        }
        catch (DCException e) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode(), ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
    }

    private void sendReqForDeviceLog(TaskEvent oEvent) {
        ITask oTask = TaskDataModel.getInstance().getTask(this.m_iTaskID);
        if (null == oTask) {
            return;
        }
        TaskProgressInfo taskProgressInfo = oTask.getTaskProgressInfo();
        if (null == taskProgressInfo) {
            return;
        }
        this.m_oLogPanelInstance.clearLogInforamtion();
        if (0 != taskProgressInfo.getState()) {
            oEvent.setTaskID(oTask.getTaskId());
            oEvent.setSource(this.m_oSelectedRes);
            this.m_oLogPanelInstance.onTreeNodeSelection(oEvent);
        }
    }

    public void sendReqForTaskDevsOprDetails() {
        ITask oTaskObj = null;
        int iSelectedRow = this.m_oTaskTreeTable.getSelectedRow();
        TreePath oTreePath = this.m_oTaskTreeTable.getTree().getPathForRow(iSelectedRow);
        TreeTableNode oNode = null;
        if (null != oTreePath && null != (oNode = (TreeTableNode)oTreePath.getLastPathComponent())) {
            oTaskObj = TaskTableUtil.getTaskForTableNode(oNode);
            THashSet<Resource> oResList = oTaskObj.getDeviceType().getResources();
            if (0 != oTaskObj.getTaskProgressInfo().getState()) {
                TaskAsynCommController.getInstance().getTaskLevelDevOprResultDetails(oTaskObj.getTaskId(), oResList);
            }
            oResList = null;
        }
        oNode = null;
        oTreePath = null;
    }

    public int getDeviceID() {
        this.setData();
        return this.m_iDeviceID;
    }

    public void setDeviceID(int iDeviceID) {
        this.setData();
        this.m_iDeviceID = iDeviceID;
    }

    private void setData() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TaskOprDetailsController.this.m_oTaskTreeTable.repaint();
            }
        });
        ITask oTaskObj = null;
        int iSelectedRow = this.m_oTaskTreeTable.getSelectedRow();
        TreePath oTreePath = this.m_oTaskTreeTable.getTree().getPathForRow(iSelectedRow);
        TreeTableNode oNode = null;
        if (null != oTreePath && null != (oNode = (TreeTableNode)oTreePath.getLastPathComponent())) {
            oTaskObj = TaskTableUtil.getTaskForTableNode(oNode);
            TreeTableRowData oData = (TreeTableRowData)oNode.getUserObject();
            if (oData != null && oData.getUserObject() instanceof Resource) {
                this.m_oSelectedRes = (Resource)oData.getUserObject();
                this.m_iDeviceID = this.m_oSelectedRes.getDeviceID();
            }
            if (null != oTaskObj) {
                this.m_iTaskID = oTaskObj.getTaskId();
            } else {
                DCDebugTracer.trace("[log]oTaskObj is null");
            }
        }
        oTreePath = null;
        oNode = null;
        oTaskObj = null;
    }

    public int getTaskID() {
        return this.m_iTaskID;
    }

    public Resource getSelectedRes() {
        return this.m_oSelectedRes;
    }

    public ITask getTaskObject() {
        this.setData();
        return TaskDataModel.getInstance().getTask(this.m_iTaskID);
    }

    public void doCleanUp() {
        LogInfoNotifier.getInstance().clearAllListeners();
        if (null != this.m_oTaskTreeTable) {
            this.m_oTaskTreeTable.removeAll();
            this.m_oTaskTreeTable = null;
        }
        if (null != this.m_oSelectedRes) {
            this.m_oSelectedRes = null;
        }
        if (null != this.m_oLogPanelInstance) {
            this.m_oLogPanelInstance.doCleanUp();
            this.m_oLogPanelInstance = null;
        }
        if (null != this.m_oOprListPanelInstance) {
            this.m_oOprListPanelInstance.doCleanUp();
            this.m_oOprListPanelInstance = null;
        }
    }

    public void setLogPanelInstance(TaskDeviceOperationLogPanel oInstance) {
        this.m_oLogPanelInstance = oInstance;
    }

    public void setOprListPanelInstance(TaskDeviceOperationListPanel oInstance) {
        this.m_oOprListPanelInstance = oInstance;
    }

    @Override
    public void onTaskNotification(TaskEvent oEvent) {
        if (TaskEventID.DEVICE_OPR_CHK_ITEM_N_LOG_EVENT == oEvent.getTaskEventType()) {
            this.setData();
            this.sendReqForDeviceLog(oEvent);
            this.sendReqForDevOprDetails(false);
        } else if (TaskEventID.TASK_DEVICES_OPR_DETAIL_EVENT == oEvent.getTaskEventType()) {
            this.m_oOprListPanelInstance.reInitializeSelectedOpr();
            this.sendReqForTaskDevsOprDetails();
        }
    }
}

