/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.controller;

import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.taskmgmt.controller.ITaskInfoNotifier;
import com.huawei.dc.taskmgmt.controller.ITaskNotificationListener;
import com.huawei.dc.taskmgmt.controller.TaskEvent;
import java.util.LinkedList;
import java.util.List;

public class TaskInfoNotifier
implements ITaskInfoNotifier,
IDCObjectDeallocator {
    private List m_oNotificationListenerList = new LinkedList();
    private static TaskInfoNotifier c_oTaskEventNotifier = null;

    private TaskInfoNotifier() {
    }

    public static synchronized ITaskInfoNotifier getInstance() {
        if (c_oTaskEventNotifier == null) {
            c_oTaskEventNotifier = new TaskInfoNotifier();
            DCObjectDestructor.getInstance().addObjectForDestructor(c_oTaskEventNotifier);
        }
        return c_oTaskEventNotifier;
    }

    @Override
    public void addTaskNotificationListener(ITaskNotificationListener oListener) {
        if (null != oListener && !this.m_oNotificationListenerList.contains(oListener)) {
            this.m_oNotificationListenerList.add(oListener);
        }
    }

    @Override
    public void notifyTaskEvent(TaskEvent oTaskEvent) {
        DCDebugTracer.traceDetail("[upgrade mode ] notifyTaskEvent start.");
        int noOfListener = this.m_oNotificationListenerList.size();
        DCDebugTracer.traceDetail("noOfListener : " + noOfListener);
        for (int index = 0; index < noOfListener; ++index) {
            Object oListenerObj = this.m_oNotificationListenerList.get(index);
            if (oListenerObj instanceof ITaskNotificationListener) {
                DCDebugTracer.traceDetail("[upgrade mode ] oListenerObj : " + oListenerObj.getClass().getSimpleName());
                ((ITaskNotificationListener)oListenerObj).onTaskNotification(oTaskEvent);
            }
            if (noOfListener >= this.m_oNotificationListenerList.size()) continue;
            noOfListener = this.m_oNotificationListenerList.size();
        }
        DCDebugTracer.traceDetail("[upgrade mode] notifyTaskEvent end..");
    }

    @Override
    public void removeTaskNotificationListener(ITaskNotificationListener oListener) {
        if (null != oListener) {
            this.m_oNotificationListenerList.remove(oListener);
        }
    }

    @Override
    public void setToNULL() {
        this.m_oNotificationListenerList.clear();
        this.m_oNotificationListenerList = null;
        c_oTaskEventNotifier = null;
    }
}

