/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.controller;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.components.dialog.SimpleProgressDlg;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.taskmgmt.controller.UpdateSlaveDeviceInfoManager;
import com.huawei.dc.taskmgmt.controller.UpgradeModeValidationManager;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.ValidationResult;
import com.huawei.dc.taskmgmt.view.model.TaskMgmtOperationSelecModel;
import com.swimap.iview.framework.windowmanagement.InternalFrame;
import gnu.trove.THashSet;
import java.util.Iterator;
import javax.swing.SwingUtilities;

public class TaskDevSelectionValidationManager {
    private ITask m_oTask = null;
    private boolean m_bCancelPressed = false;
    private int m_iCurrentOperationNo = 0;
    private boolean m_bIsSlaveInfoRequired = true;
    private boolean m_bIsUpgradeModeValidationReqd = true;
    private SimpleProgressDlg m_oValidationProgressDlg = null;

    public ValidationResult validateDeviceSelection(ITask oTask, boolean bIsUpgradeModeValidationReqd, boolean bIsSlaveInfoReqd) {
        return this.validateDeviceSelection(oTask, bIsUpgradeModeValidationReqd, bIsSlaveInfoReqd, null);
    }

    public ValidationResult validateDeviceSelection(ITask oTask, boolean bIsUpgradeModeValidationReqd, boolean bIsSlaveInfoReqd, DCModalDialog dialog) {
        this.setCancelButtonPressed(false);
        this.m_oTask = oTask;
        this.m_bIsUpgradeModeValidationReqd = bIsUpgradeModeValidationReqd;
        this.m_bIsSlaveInfoRequired = bIsSlaveInfoReqd;
        ValidationResult oValidResult = new ValidationResult();
        this.m_oValidationProgressDlg = new SimpleProgressDlg(ResourceManager.getInstance().getResString("UPGRADE_MODE_VALIDATION_TITLE"), true, dialog, ResourceManager.getInstance().getResString("GETTING_UPGRADE_MODE_VALIDATION_TITLE"), true){
            private static final long serialVersionUID = 1L;

            @Override
            public void cancelButtonActionPerformed() {
                TaskDevSelectionValidationManager.this.setCancelButtonPressed(true);
            }

            @Override
            protected void closeDialog() {
                super.closeDialog();
                TaskDevSelectionValidationManager.this.setCancelButtonPressed(true);
            }
        };
        this.m_oValidationProgressDlg.setModalParent((InternalFrame)dialog);
        this.m_oValidationProgressDlg.setDefaultCloseOperation(2);
        ValidateUpMode oValidateUpMode = new ValidateUpMode();
        try {
            if (this.m_oTask.getIsOffLineTask()) {
                oValidateUpMode.run();
                this.m_oValidationProgressDlg.doCleanUp();
                oValidResult.setErrorType(0);
                return oValidResult;
            }
            oValidateUpMode.start();
            this.m_oValidationProgressDlg.setVisible(true);
        }
        catch (Exception e) {
            DCDebugTracer.trace("m_oValidationProgressDlg setVisible(true) failed.");
            DCDebugTracer.trace(e);
        }
        if (this.m_bCancelPressed) {
            oValidResult.setErrorCode(-1);
            if (0 != this.m_iCurrentOperationNo) {
                oValidResult.setErrorMessage(ResourceManager.getInstance().getResString("SLAVE_DEVICE_REQUEST_FAIL"));
            }
            oValidResult.setErrorType(0);
        } else {
            oValidResult = oValidateUpMode.getValidateResult();
        }
        return oValidResult;
    }

    public boolean isSlaveDeviceInfoNeeded() {
        boolean bSlaveInfoNeeded = false;
        THashSet<Resource> oResList = this.m_oTask.getDeviceType().getResources();
        Iterator oResItor = oResList.iterator();
        Resource oRes = null;
        while (oResItor.hasNext()) {
            oRes = (Resource)oResItor.next();
            int iRoleType = oRes.getRoleType();
            if (3 != iRoleType) continue;
            bSlaveInfoNeeded = true;
            break;
        }
        return bSlaveInfoNeeded;
    }

    private void setCancelButtonPressed(boolean bFlag) {
        this.m_bCancelPressed = bFlag;
    }

    class ValidateUpMode
    extends Thread {
        private ValidationResult m_oResult = null;

        @Override
        public void run() {
            this.m_oResult = new ValidationResult();
            this.m_oResult.setErrorCode(0);
            this.updateDevAllUpgradeMode();
            if (!TaskDevSelectionValidationManager.this.m_oTask.getIsOffLineTask()) {
                if (TaskDevSelectionValidationManager.this.m_bIsUpgradeModeValidationReqd) {
                    TaskDevSelectionValidationManager.this.m_iCurrentOperationNo = 0;
                    this.m_oResult = UpgradeModeValidationManager.getInstance().validateUpgradeMode(TaskDevSelectionValidationManager.this.m_oTask);
                }
                if (0 == this.m_oResult.getErrorCode() && TaskDevSelectionValidationManager.this.m_bIsSlaveInfoRequired && TaskDevSelectionValidationManager.this.isSlaveDeviceInfoNeeded()) {
                    TaskDevSelectionValidationManager.this.m_iCurrentOperationNo = 1;
                    TaskDevSelectionValidationManager.this.m_oValidationProgressDlg.setTitle(ResourceManager.getInstance().getResString("UPDATE_SLAVE_DEVICE_INFO_TITLE"));
                    this.m_oResult = UpdateSlaveDeviceInfoManager.getInstance().updateSlaveInfo(TaskDevSelectionValidationManager.this.m_oTask);
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TaskDevSelectionValidationManager.this.m_oValidationProgressDlg.doCleanUp();
                }
            });
        }

        public ValidationResult getValidateResult() {
            return this.m_oResult;
        }

        private void updateDevAllUpgradeMode() {
            TaskMgmtOperationSelecModel taskMgmtOperationSelecModel = new TaskMgmtOperationSelecModel();
            DeviceType deviceType = TaskDevSelectionValidationManager.this.m_oTask.getDeviceType();
            String strDevTypeName = deviceType.getDeviceTypeName();
            String strDevTypeVerName = deviceType.getDeviceTypeVersionName();
            if (!strDevTypeVerName.contains("_telnet") && deviceType.getDeviceDomain() == 2) {
                strDevTypeVerName = strDevTypeVerName + "_telnet";
            }
            deviceType.setDeviceTypeVersionName(strDevTypeVerName);
            try {
                taskMgmtOperationSelecModel.getSupportedOperationLst(TaskDevSelectionValidationManager.this.m_oTask, strDevTypeName, strDevTypeVerName, DCFrameWorkUtil.getDeviceInfoManager().getDeviceTypeInfo(deviceType.getDeviceTypeID(), deviceType.getDeviceTypeVersionID()));
                THashSet<Resource> resLst = deviceType.getResources();
                Iterator oResItor = resLst.iterator();
                Resource res = null;
                if (oResItor.hasNext()) {
                    res = (Resource)oResItor.next();
                    int iUpgradMode = 4368;
                    DeviceInfo oDevInfo = DeviceInfoManagerImpl.getInstance().getDevice(res.getDeviceID());
                    if (4 == oDevInfo.getDeviceTypeInfo().getDevDomain()) {
                        iUpgradMode = 150654;
                    }
                    res.setUpgradeMode(iUpgradMode);
                    while (oResItor.hasNext()) {
                        res = (Resource)oResItor.next();
                        res.setUpgradeMode(iUpgradMode);
                    }
                }
            }
            catch (DCException e) {
                DCDebugTracer.trace(e);
                this.m_oResult.setErrorCode(e.getErrorCode());
            }
        }
    }
}

