/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.controller;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.OperationIdStore;
import com.huawei.dc.common.asndatacenter.AsnCheckReportReq;
import com.huawei.dc.common.asndatacenter.AsnCheckReportRsp;
import com.huawei.dc.common.asndatacenter.AsnCheckReportTypeEnum;
import com.huawei.dc.common.asndatacenter.AsnCommandResult;
import com.huawei.dc.common.asndatacenter.AsnDCCheckDevMemoryInfo;
import com.huawei.dc.common.asndatacenter.AsnDCCheckDevMemoryReq;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceIdVer;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceIdVerLst;
import com.huawei.dc.common.asndatacenter.AsnDCFileDeleteOnDevReq;
import com.huawei.dc.common.asndatacenter.AsnDCGetCommandResultRsp;
import com.huawei.dc.common.asndatacenter.AsnDCIntegerLst;
import com.huawei.dc.common.asndatacenter.AsnDCMasterDevInfo;
import com.huawei.dc.common.asndatacenter.AsnDCMasterDevInfoLst;
import com.huawei.dc.common.asndatacenter.AsnDCNodeInfo;
import com.huawei.dc.common.asndatacenter.AsnDCSlaveDevInfoRsp;
import com.huawei.dc.common.asndatacenter.AsnDCTaskIdError;
import com.huawei.dc.common.asndatacenter.AsnDCTaskIdList;
import com.huawei.dc.common.asndatacenter.AsnDeleteTaskRsp;
import com.huawei.dc.common.asndatacenter.AsnDevResult;
import com.huawei.dc.common.asndatacenter.AsnDevResultList;
import com.huawei.dc.common.asndatacenter.AsnDevTypeIdInfo;
import com.huawei.dc.common.asndatacenter.AsnDevTypeIdInfoList;
import com.huawei.dc.common.asndatacenter.AsnDeviceFileList;
import com.huawei.dc.common.asndatacenter.AsnGetDevUpgradeModeReq;
import com.huawei.dc.common.asndatacenter.AsnGetDevUpgradeModeRsp;
import com.huawei.dc.common.asndatacenter.AsnLoadFileInfo;
import com.huawei.dc.common.asndatacenter.AsnLoadFileLst;
import com.huawei.dc.common.asndatacenter.AsnOperationInfo;
import com.huawei.dc.common.asndatacenter.AsnOperationInfoLst;
import com.huawei.dc.common.asndatacenter.AsnResourceProgressInfo;
import com.huawei.dc.common.asndatacenter.AsnRetryTaskReq;
import com.huawei.dc.common.asndatacenter.AsnSWCompatibilityCheckReq;
import com.huawei.dc.common.asndatacenter.AsnStartTaskResp;
import com.huawei.dc.common.asndatacenter.AsnStatusEnum;
import com.huawei.dc.common.asndatacenter.AsnTaskDevOpInfo;
import com.huawei.dc.common.asndatacenter.AsnTaskInfo;
import com.huawei.dc.common.asndatacenter.AsnTaskMoveToCompleteRsp;
import com.huawei.dc.common.asndatacenter.AsnTaskReq;
import com.huawei.dc.common.asndatacenter.AsnTaskResource;
import com.huawei.dc.common.asndatacenter.AsnTaskResourceLst;
import com.huawei.dc.common.asndatacenter.AsnTaskRqstOpResultInfo;
import com.huawei.dc.common.asndatacenter.AsnTaskRqstOpResultInfoLst;
import com.huawei.dc.common.asndatacenter.AsnTaskRsp;
import com.huawei.dc.common.asndatacenter.AsnTaskRspList;
import com.huawei.dc.common.asndatacenter.AsnTaskTypeEnum;
import com.huawei.dc.common.asndatacenter.AsnUpgradeFeasibilitySupportReq;
import com.huawei.dc.common.asndatacenter.AsnUpgradeOpInfo;
import com.huawei.dc.common.configtree.ConfigTreeNodeInfo;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.CloneUtil;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ParamUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DCTimeDateUtil;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.common.util.TaskInfoUtil2;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.IOperation;
import com.huawei.dc.devicemanagement.deviceoperation.IParaList;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfoListParam;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.ICheckOperationConfigParam;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.PostcheckOperation;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.PrecheckOperation;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.IUpgradeSubOperation;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.PostUpgradeOperation;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.PrepareUpgradeOperation;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.devicemanagement.model.xmlconfig.DeviceXMLConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;
import com.huawei.dc.taskmgmt.controller.TaskResourceUtil;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.ResourceOpResultInfo;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import com.huawei.dc.taskmgmt.model.TaskOpResultInfo;
import com.huawei.dc.taskmgmt.report.devlevel.model.CheckReportTable;
import com.huawei.dc.taskmgmt.report.devlevel.model.ICheckReportTable;
import com.huawei.dc.taskmgmt.util.AsnTaskInfoUtil;
import com.huawei.dc.taskmgmt.util.ConfigTreeUtil;
import com.huawei.dc.taskmgmt.util.UpgradeModeUtil;
import gnu.trove.THashSet;
import java.awt.Component;
import java.math.BigInteger;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class TaskCommUtil {
    private static int iSAMFileImportShow = 0;

    private TaskCommUtil() {
    }

    public static void setNodeSelectedState(ConfigTreeNodeInfo aParentNode) {
        ConfigTreeUtil.setNodeSelectedState(aParentNode);
    }

    public static ConfigTreeNodeInfo getTreeNodeInfoFromAsn(AsnDCNodeInfo oAsnDCNodeInfo) {
        return ConfigTreeUtil.getTreeNodeInfoFromAsn(oAsnDCNodeInfo);
    }

    public static void addDeviceToTreeNode(ConfigTreeNodeInfo aConnNode, ITask aTask) {
        ConfigTreeUtil.addDeviceToTreeNode(aConnNode, aTask);
    }

    public static ConfigTreeNodeInfo getConnectivityNode(ICheckOperationConfigParam aCheckParam) {
        return ConfigTreeUtil.getConnectivityNode(aCheckParam);
    }

    public static void updateDevUpgradeModeResponse(AsnGetDevUpgradeModeRsp oResponse, ITask oTask) throws DCException {
        UpgradeModeUtil.updateDevUpgradeModeResponse(oResponse, oTask);
    }

    public static List<AsnGetDevUpgradeModeReq> getDevUpgradeModeReq(ITask oTask) {
        return UpgradeModeUtil.getDevUpgradeModeReq(oTask);
    }

    public static AsnGetDevUpgradeModeReq getDevUpgradeModeReqest(ITask oTask) {
        return UpgradeModeUtil.getDevUpgradeModeReqest(oTask);
    }

    public static void boxRetryDiffusionTaskReq(Map<Integer, THashSet<Resource>> oTaskFailedResourceMap, AsnRetryTaskReq oAsnRetryTaskReq) {
        ArrayList<AsnTaskReq> oTaskReqList = new ArrayList<AsnTaskReq>(oTaskFailedResourceMap.size());
        AsnTaskResourceLst oAsnTaskResourceLst = null;
        AsnTaskReq oAsnTaskReq = null;
        Set<Map.Entry<Integer, THashSet<Resource>>> oSet = oTaskFailedResourceMap.entrySet();
        Iterator<Map.Entry<Integer, THashSet<Resource>>> oIterator = oSet.iterator();
        Map.Entry<Integer, THashSet<Resource>> oEntry = null;
        while (oIterator.hasNext()) {
            THashSet<Resource> oResourceList;
            oEntry = oIterator.next();
            Integer oTaskID = oEntry.getKey();
            if (oTaskID == null || (oResourceList = oEntry.getValue()) == null) continue;
            oAsnTaskReq = new AsnTaskReq();
            oAsnTaskReq.iTaskID = BigInteger.valueOf(oTaskID.intValue());
            oAsnTaskResourceLst = new AsnTaskResourceLst();
            Iterator oResItor = oResourceList.iterator();
            Resource oResource = null;
            AsnTaskResource oAsnTaskResource = null;
            while (oResItor.hasNext()) {
                oResource = (Resource)oResItor.next();
                oAsnTaskResource = new AsnTaskResource();
                oAsnTaskResource.iDeviceId = BigInteger.valueOf(oResource.getDeviceID());
                oAsnTaskResourceLst.add((Object)oAsnTaskResource);
            }
            oAsnTaskReq.oTaskResLst = oAsnTaskResourceLst;
            oTaskReqList.add(oAsnTaskReq);
        }
        int iTaskCount = oTaskReqList.size();
        for (int i = 0; i < iTaskCount; ++i) {
            oAsnTaskReq = (AsnTaskReq)oTaskReqList.get(i);
            oAsnRetryTaskReq.add((Object)oAsnTaskReq);
        }
    }

    public static int converBigIntToint(BigInteger oBigIntObj) {
        int iValue = -1;
        if (null != oBigIntObj) {
            iValue = oBigIntObj.intValue();
        }
        return iValue;
    }

    public static String converTaskTypeToStr(int taskType) {
        String strTaskType = "";
        switch (taskType) {
            case 0: {
                strTaskType = ResourceManager.getInstance().getResString("SOFTWARE_UPGRADE_TASK_GROUP");
                break;
            }
            case 1: {
                strTaskType = ResourceManager.getInstance().getResString("SOFTWARE_DOWNGRADE_TASK_GROUP");
                break;
            }
            case 2: {
                strTaskType = ResourceManager.getInstance().getResString("PATCH_UPDATE_TASK_GROUP");
                break;
            }
            case 3: {
                strTaskType = ResourceManager.getInstance().getResString("MIMIC_PACKAGE_UPDATE_TASK_GROUP");
                break;
            }
            case 4: 
            case 260: {
                strTaskType = ResourceManager.getInstance().getResString("PACKAGE_UPDATE_TASK_GROUP");
                break;
            }
            case 13: 
            case 269: {
                strTaskType = ResourceManager.getInstance().getResString("PACKAGE_DOWNGRADE_TASK_GROUP");
                break;
            }
            case 5: 
            case 261: {
                strTaskType = ResourceManager.getInstance().getResString("PACKAGE_DIFFUSION_UPDATE_TASK_GROUP");
                break;
            }
            case 12: 
            case 268: {
                strTaskType = ResourceManager.getInstance().getResString("PACKAGE_DIFFUSION_DOWNGRADE_TASK_GROUP");
                break;
            }
            case 6: {
                strTaskType = ResourceManager.getInstance().getResString("MXU_AUTOUPGRADE_TASK_GROUP");
                break;
            }
            case 7: {
                strTaskType = ResourceManager.getInstance().getResString("OLT_AGENTUPGRADE_TASK_GROUP");
                break;
            }
        }
        return strTaskType;
    }

    public static AsnDCCheckDevMemoryReq getAsnDCCheckDevMemoryReq(HashMap<Integer, List<String>> oFileInfoMap) {
        AsnDCCheckDevMemoryReq oAsnDCCheckDevMemoryReq = new AsnDCCheckDevMemoryReq();
        if (null != oFileInfoMap) {
            Iterator<Map.Entry<Integer, List<String>>> oFileInfoItr = oFileInfoMap.entrySet().iterator();
            Map.Entry<Integer, List<String>> oFileInfoEntry = null;
            while (oFileInfoItr.hasNext()) {
                AsnDCCheckDevMemoryInfo oAsnCheckDevMemoryInfo = new AsnDCCheckDevMemoryInfo();
                oFileInfoEntry = oFileInfoItr.next();
                oAsnCheckDevMemoryInfo.iDevId = BigInteger.valueOf(oFileInfoEntry.getKey().intValue());
                List<String> oFileLst = oFileInfoEntry.getValue();
                for (String strFileName : oFileLst) {
                    oAsnCheckDevMemoryInfo.oLoadFileInfo.add((Object)strFileName.getBytes());
                }
                oAsnDCCheckDevMemoryReq.add((Object)oAsnCheckDevMemoryInfo);
            }
        }
        return oAsnDCCheckDevMemoryReq;
    }

    public static AsnDCIntegerLst getAsnDCSlaveDevInfoReq(ITask oTask) {
        AsnDCIntegerLst oAsnDCDeviceIdLstReq = new AsnDCIntegerLst();
        THashSet<Resource> oResList = oTask.getDeviceType().getResources();
        Resource oRes2 = null;
        for (Resource oRes2 : oResList) {
            int iRoleType = oRes2.getRoleType();
            if (3 != iRoleType) continue;
            oAsnDCDeviceIdLstReq.add((Object)BigInteger.valueOf(oRes2.getDeviceID()));
        }
        return oAsnDCDeviceIdLstReq;
    }

    public static AsnDCFileDeleteOnDevReq getAsnDeleteFileOnDevReq(int iReqId, Resource oRes, List<String> oFileList) {
        AsnDCFileDeleteOnDevReq oAsnDCFileDeleteOnDevReq = new AsnDCFileDeleteOnDevReq();
        oAsnDCFileDeleteOnDevReq.oReqID = BigInteger.valueOf(iReqId);
        AsnDeviceFileList oAsnDeviceFileList = new AsnDeviceFileList();
        oAsnDCFileDeleteOnDevReq.iDeviceID = BigInteger.valueOf(oRes.getDeviceID());
        oAsnDCFileDeleteOnDevReq.oFileList = oAsnDeviceFileList;
        int iSize = oFileList.size();
        String strFilePath = null;
        for (int i = 0; i < iSize; ++i) {
            strFilePath = oFileList.get(i);
            oAsnDeviceFileList.add((Object)strFilePath.getBytes());
        }
        return oAsnDCFileDeleteOnDevReq;
    }

    public static AsnOperationInfo getAsnOperationForID(String strOperationID, AsnOperationInfoLst oAsnOperationList) {
        if (null == oAsnOperationList || 0 == oAsnOperationList.size() || null == strOperationID) {
            return null;
        }
        int iOperationCount = oAsnOperationList.size();
        for (int i = 0; i < iOperationCount; ++i) {
            AsnOperationInfo oAsnOperation = (AsnOperationInfo)oAsnOperationList.get(i);
            if (!strOperationID.equalsIgnoreCase(new String(oAsnOperation.strOperationId))) continue;
            return oAsnOperation;
        }
        return null;
    }

    public static AsnTaskResource getAsnTaskResource(Resource oResource) {
        return TaskResourceUtil.getAsnTaskResource(oResource);
    }

    public static AsnTaskResourceLst getAsnTaskResourceLst(List<Resource> resource) {
        return TaskResourceUtil.getAsnTaskResourceLst(resource);
    }

    public static AsnSWCompatibilityCheckReq getCheckLoadSWRqst(ITask oTask, LoadFileInfoListParam oLoadParam) {
        DeviceType oDevType;
        DCDebugTracer.trace("Method getCheckLoadSWRqst start");
        AsnSWCompatibilityCheckReq oAsnSWCompatibilityCheckReq = new AsnSWCompatibilityCheckReq();
        oAsnSWCompatibilityCheckReq.oAsnDevTypeIdInfoList = new AsnDevTypeIdInfoList();
        List<DeviceTypeInfo> devcieTypeList = oTask.getDeviceTypeLst();
        if (null != devcieTypeList) {
            for (DeviceTypeInfo oDevType2 : devcieTypeList) {
                AsnDevTypeIdInfo oAsnDevTypeIdInfo = new AsnDevTypeIdInfo();
                oAsnDevTypeIdInfo.iDevTypeId = BigInteger.valueOf(oDevType2.getDevTypeID());
                oAsnDevTypeIdInfo.iDevTypeVerId = BigInteger.valueOf(oDevType2.getDevTypeVersionId());
                oAsnSWCompatibilityCheckReq.oAsnDevTypeIdInfoList.add((Object)oAsnDevTypeIdInfo);
            }
        }
        if (null != (oDevType = oTask.getSelectedDeviceType())) {
            AsnDevTypeIdInfo oAsnDevTypeIdInfo = new AsnDevTypeIdInfo();
            oAsnDevTypeIdInfo.iDevTypeId = BigInteger.valueOf(oDevType.getDeviceTypeID());
            oAsnDevTypeIdInfo.iDevTypeVerId = BigInteger.valueOf(oDevType.getDeviceTypeVersionID());
            oAsnSWCompatibilityCheckReq.oAsnDevTypeIdInfoList.add((Object)oAsnDevTypeIdInfo);
        }
        LoadFileInfo oLoadFileInfo = null;
        AsnLoadFileInfo oAsnLoadFileInfo = null;
        List<LoadFileInfo> oFileList = oLoadParam.getLoadFileInfoList();
        int iFileCount = oFileList.size();
        oAsnSWCompatibilityCheckReq.oAsnLoadFileList = new AsnLoadFileLst();
        for (int i = 0; i < iFileCount; ++i) {
            oLoadFileInfo = oFileList.get(i);
            oAsnLoadFileInfo = new AsnLoadFileInfo();
            oAsnLoadFileInfo.strFileName = oLoadFileInfo.getAbsoluteFilePath().getBytes();
            oAsnLoadFileInfo.iContentType = BigInteger.valueOf(oLoadFileInfo.getContentType().getContentTypeCode());
            oAsnLoadFileInfo.iSequence = BigInteger.valueOf(oLoadFileInfo.getSequenceNo());
            oAsnLoadFileInfo.strTargetVersion = "ABCD".getBytes();
            oAsnSWCompatibilityCheckReq.oAsnLoadFileList.add((Object)oAsnLoadFileInfo);
        }
        DCDebugTracer.trace("Method getCheckLoadSWRqst end");
        return oAsnSWCompatibilityCheckReq;
    }

    public static ICheckReportTable getCheckReportFromServerResponse(AsnCheckReportRsp asnCheckReportRsp) {
        CheckReportTable oCheckReportTable = new CheckReportTable();
        return oCheckReportTable;
    }

    public static AsnCheckReportReq getCheckReportRequest(int iTaskID, THashSet<Resource> resourceList, int checkReportType) {
        AsnCheckReportReq oAsnCheckReportReq = new AsnCheckReportReq();
        AsnCheckReportTypeEnum oAsnCheckReportTypeEnum = new AsnCheckReportTypeEnum();
        oAsnCheckReportTypeEnum.value = checkReportType;
        oAsnCheckReportReq.enCheckReportType = oAsnCheckReportTypeEnum;
        oAsnCheckReportReq.iTaskId = BigInteger.valueOf(iTaskID);
        Iterator oIterator = resourceList.iterator();
        AsnTaskResource oAsnTaskResource = null;
        Resource oResource = null;
        AsnTaskResourceLst oAsnTaskResourceLst = new AsnTaskResourceLst();
        while (oIterator.hasNext()) {
            oResource = (Resource)oIterator.next();
            if (oResource == null) continue;
            oAsnTaskResource = new AsnTaskResource();
            oAsnTaskResource.iDeviceId = BigInteger.valueOf(oResource.getDeviceID());
            oAsnTaskResource.iFrameId = BigInteger.valueOf(oResource.getFrameId());
            oAsnTaskResource.iParentDevId = BigInteger.valueOf(oResource.getParentDevId());
            oAsnTaskResource.iSlotId = BigInteger.valueOf(oResource.getSlotId());
            oAsnTaskResource.iSubSlotId = BigInteger.valueOf(oResource.getSubSlotId());
            oAsnTaskResource.iStackId = BigInteger.valueOf(oResource.getStackId());
            if (null != oResource.getDeviceVersion()) {
                oAsnTaskResource.strSWversion = oResource.getDeviceVersion().getBytes();
            }
            if (null != oResource.getStackDevTypeInfo()) {
                oAsnTaskResource.iDevTypeId = BigInteger.valueOf(oResource.getStackDevTypeInfo().getDevTypeID());
                oAsnTaskResource.iDevTypeVerId = BigInteger.valueOf(oResource.getStackDevTypeInfo().getDevTypeVersionId());
            }
            oAsnTaskResourceLst.add((Object)oAsnTaskResource);
        }
        oAsnCheckReportReq.oTaskResLst = oAsnTaskResourceLst;
        return oAsnCheckReportReq;
    }

    public static List<String> getCommandResultList(AsnDCGetCommandResultRsp oAsnDCGetCommandResultRsp) {
        ArrayList<String> cmdReslutLst = new ArrayList<String>();
        if (null == oAsnDCGetCommandResultRsp || 0 != oAsnDCGetCommandResultRsp.oErrorInfo.iErrorNo.intValue()) {
            return null;
        }
        int iResSize = oAsnDCGetCommandResultRsp.oCommandResultLst.size();
        AsnCommandResult oAsnCommandResult = null;
        for (int i = 0; i < iResSize; ++i) {
            oAsnCommandResult = (AsnCommandResult)oAsnDCGetCommandResultRsp.oCommandResultLst.get(i);
            String sResult = new String(oAsnCommandResult.strCommandResult);
            if (2 == iResSize) {
                if (0 == oAsnCommandResult.iOperationid.intValue()) {
                    cmdReslutLst.add(0, sResult);
                    continue;
                }
                cmdReslutLst.add(sResult);
                continue;
            }
            cmdReslutLst.add(sResult);
        }
        oAsnCommandResult = null;
        return cmdReslutLst;
    }

    public static List getContentTypesFromXMLConfig(DeviceTypeInfo oDeviceTypeInfo, int[] iDeviceIdLst) {
        ArrayList<Object> oFinalList = new ArrayList<Object>(0);
        List<Object> oContTypeLst = null;
        IDeviceTypeConfigModel deviceTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oDeviceTypeInfo, iDeviceIdLst);
        if (null != deviceTypeConfigModel) {
            Object[] arrParaVals;
            IParaList oGetoPerationParaList;
            IOperation oLoadSWOperationObj = deviceTypeConfigModel.getOperationObj(1, 6);
            IOperation oLoadDataOperationObj = deviceTypeConfigModel.getOperationObj(1, 7);
            IOperation oLoadPatchOperationObj = deviceTypeConfigModel.getOperationObj(1, 9);
            if (null == oLoadSWOperationObj && null == oLoadDataOperationObj && null == oLoadPatchOperationObj) {
                return null;
            }
            if (null != oLoadSWOperationObj) {
                oGetoPerationParaList = oLoadSWOperationObj.getoPerationParaList();
                arrParaVals = ParamUtil.getInstance().getContentTypeList(oGetoPerationParaList);
                if (null != arrParaVals) {
                    oContTypeLst = Arrays.asList(arrParaVals);
                    oFinalList.addAll(oContTypeLst);
                }
                if (null != (arrParaVals = ParamUtil.getInstance().getContentTypeListForDeviceLevelLoad(oGetoPerationParaList))) {
                    oContTypeLst = Arrays.asList(arrParaVals);
                    oFinalList.addAll(oContTypeLst);
                }
            }
            if (null != oLoadDataOperationObj) {
                oGetoPerationParaList = oLoadDataOperationObj.getoPerationParaList();
                arrParaVals = ParamUtil.getInstance().getContentTypeList(oGetoPerationParaList);
                if (null != arrParaVals) {
                    oContTypeLst = Arrays.asList(arrParaVals);
                    oFinalList.addAll(oContTypeLst);
                }
            }
            if (null != oLoadPatchOperationObj) {
                oGetoPerationParaList = oLoadPatchOperationObj.getoPerationParaList();
                arrParaVals = ParamUtil.getInstance().getContentTypeList(oGetoPerationParaList);
                if (null != arrParaVals) {
                    oContTypeLst = Arrays.asList(arrParaVals);
                    oFinalList.addAll(oContTypeLst);
                }
            }
        }
        return oFinalList;
    }

    public static String getDisplayNameForOperation(DeviceType oDeviceType, String strOperationID) {
        int iOperationID;
        IOperation oOperation;
        IDeviceTypeConfigModel oDevTypeModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oDeviceType);
        if (null != oDevTypeModel && null != (oOperation = oDevTypeModel.getOperationObjFrmModel(iOperationID = OperationIdStore.getInstance().getOperationId(strOperationID)))) {
            return oOperation.getOperationName();
        }
        String strOperation = ResourceManager.getInstance().getResString(oDeviceType, strOperationID);
        if (strOperation.length() > 0) {
            return strOperation;
        }
        return strOperationID;
    }

    public static AsnTaskTypeEnum getEnumForTaskType(int iTaskTypeId) {
        switch (iTaskTypeId) {
            case 0: {
                return new AsnTaskTypeEnum(0);
            }
            case 1: {
                return new AsnTaskTypeEnum(1);
            }
            case 2: {
                return new AsnTaskTypeEnum(2);
            }
            case 6: {
                return new AsnTaskTypeEnum(6);
            }
            case 3: {
                return new AsnTaskTypeEnum(3);
            }
            case 4: {
                return new AsnTaskTypeEnum(4);
            }
            case 13: {
                return new AsnTaskTypeEnum(13);
            }
            case 5: {
                return new AsnTaskTypeEnum(5);
            }
            case 12: {
                return new AsnTaskTypeEnum(12);
            }
            case 7: {
                return new AsnTaskTypeEnum(7);
            }
        }
        return null;
    }

    public static List<TaskOpResultInfo> getFailedTaskIDsFromDeleteResponse(AsnDeleteTaskRsp oDeleteRsp) {
        ArrayList<TaskOpResultInfo> oTaskResultList = new ArrayList<TaskOpResultInfo>(0);
        AsnTaskRqstOpResultInfoLst oTaskIDList = oDeleteRsp.oTaskRqstOpResultInfoLst;
        int iTaskCount = oTaskIDList.size();
        TaskOpResultInfo oTaskOpResult = null;
        for (int i = 0; i < iTaskCount; ++i) {
            AsnTaskRqstOpResultInfo asnTaskRqstOpResultInfo = (AsnTaskRqstOpResultInfo)oTaskIDList.get(i);
            oTaskOpResult = new TaskOpResultInfo();
            oTaskOpResult.setTaskId(asnTaskRqstOpResultInfo.iTaskID.intValue());
            oTaskOpResult.setErrorCode(asnTaskRqstOpResultInfo.oErrorInfo.iErrorNo);
            oTaskResultList.add(oTaskOpResult);
        }
        return oTaskResultList;
    }

    public static List getFailedTaskIDsFromMoveToCompletedResponse(AsnTaskMoveToCompleteRsp oMoveToCompletedRsp) {
        AsnDCTaskIdList oTaskIDList = oMoveToCompletedRsp.oTaskIdList;
        ArrayList<TaskOpResultInfo> oTaskResultList = new ArrayList<TaskOpResultInfo>(0);
        if (null == oTaskIDList) {
            return oTaskResultList;
        }
        int iTaskCount = oTaskIDList.size();
        TaskOpResultInfo oTaskOpResult = null;
        for (int i = 0; i < iTaskCount; ++i) {
            oTaskOpResult = new TaskOpResultInfo();
            AsnDCTaskIdError oAsnTaskResult = (AsnDCTaskIdError)oTaskIDList.get(i);
            oTaskOpResult.setTaskId(oAsnTaskResult.iTaskId.intValue());
            oTaskOpResult.setErrorCode(oAsnTaskResult.oErrorInfo.iErrorNo);
            oTaskResultList.add(oTaskOpResult);
        }
        return oTaskResultList;
    }

    public static List getFailedTaskIDsFromStartTaskResponse(AsnStartTaskResp oStartTaskRsp) {
        AsnDCIntegerLst oTaskIDList = oStartTaskRsp.oTaskIdList;
        ArrayList<TaskOpResultInfo> oTaskResultList = new ArrayList<TaskOpResultInfo>(0);
        if (null == oTaskIDList) {
            return oTaskResultList;
        }
        int iTaskCount = oTaskIDList.size();
        TaskOpResultInfo oTaskOpResult = null;
        for (int i = 0; i < iTaskCount; ++i) {
            oTaskOpResult = new TaskOpResultInfo();
            oTaskOpResult.setTaskId(((BigInteger)oTaskIDList.get(i)).intValue());
            oTaskOpResult.setErrorCode(oStartTaskRsp.oErrorInfo.iErrorNo);
            oTaskResultList.add(oTaskOpResult);
        }
        return oTaskResultList;
    }

    public static Resource getFirstDevice(THashSet<Resource> m_oResourceList) {
        if (null == m_oResourceList || m_oResourceList.size() == 0) {
            DCDebugTracer.trace("m_oResourceList is null.");
            return null;
        }
        Iterator oResItor = m_oResourceList.iterator();
        if (oResItor.hasNext()) {
            return (Resource)oResItor.next();
        }
        DCDebugTracer.trace("m_oResourceList size = 0");
        return null;
    }

    public static ITaskDeviceOperation getOperationFromLst(int iTaskOpId, List operationList) {
        if (null == operationList) {
            return null;
        }
        int iSizeOfLst = operationList.size();
        ITaskDeviceOperation oTaskOperation = null;
        ITaskDeviceOperation oTempTaskOperation = null;
        for (int i = 0; i < iSizeOfLst; ++i) {
            oTempTaskOperation = (ITaskDeviceOperation)operationList.get(i);
            if (iTaskOpId != oTempTaskOperation.getOperationId()) continue;
            oTaskOperation = oTempTaskOperation;
            break;
        }
        return oTaskOperation;
    }

    private static List<ResourceOpResultInfo> getOpResultListForTask(AsnTaskRsp oAsnTaskRsp) {
        AsnDevResultList oAsnDevOpLst = oAsnTaskRsp.oDevResultLst;
        ArrayList<ResourceOpResultInfo> oResultList = new ArrayList<ResourceOpResultInfo>(0);
        if (null == oAsnDevOpLst || 0 == oAsnDevOpLst.size()) {
            return oResultList;
        }
        int iResourceCount = oAsnDevOpLst.size();
        ResourceOpResultInfo oResultInfo = null;
        Resource oTempRes = null;
        AsnDevResult oResourceOpResult = null;
        for (int i = 0; i < iResourceCount; ++i) {
            oResultInfo = new ResourceOpResultInfo();
            oResourceOpResult = (AsnDevResult)oAsnDevOpLst.get(i);
            oTempRes = new Resource();
            oTempRes.setDeviceID(oResourceOpResult.oTaskResource.iDeviceId.intValue());
            oResultInfo.setOperationStatus(oResourceOpResult.oErrorInfo.iErrorNo.intValue());
            oResultInfo.setErrorCode(oResourceOpResult.oErrorInfo.iErrorNo);
            if (null != oResourceOpResult.oTaskResource.iFrameId) {
                oTempRes.setFrameId(oResourceOpResult.oTaskResource.iFrameId.intValue());
            }
            if (null != oResourceOpResult.oTaskResource.iSlotId) {
                oTempRes.setSlotId(oResourceOpResult.oTaskResource.iSlotId.intValue());
            }
            if (null != oResourceOpResult.oTaskResource.iSubSlotId) {
                oTempRes.setSubSlotId(oResourceOpResult.oTaskResource.iSubSlotId.intValue());
            }
            oResultInfo.setResource(oTempRes);
            if (null != oResourceOpResult.oNextOperID) {
                oResultInfo.setNextOperationType(new String(oResourceOpResult.oNextOperID));
            }
            oResultList.add(oResultInfo);
        }
        return oResultList;
    }

    public static ResourceProgressInfo getProgressInfoForDevOperInfo(ITask oTask, AsnTaskDevOpInfo oAsnTaskDevOpInfo) {
        ResourceProgressInfo oProgressInfo = new ResourceProgressInfo();
        String strOperationId = new String(oAsnTaskDevOpInfo.strOpId);
        oProgressInfo.setCurrentOperationId(strOperationId);
        String strCurrentOperationName = TaskCommUtil.getDisplayNameForOperation(oTask.getDeviceType(), strOperationId);
        oProgressInfo.setCurrentOperationName(strCurrentOperationName);
        int iOpStatus = -1;
        int iOpResult = -1;
        if (null != oAsnTaskDevOpInfo.enOpStatus) {
            iOpStatus = oAsnTaskDevOpInfo.enOpStatus.value;
            oProgressInfo.setState(iOpStatus);
        }
        if (null != oAsnTaskDevOpInfo.enOpResult) {
            iOpResult = oAsnTaskDevOpInfo.enOpResult.value;
            oProgressInfo.setResult(iOpResult);
        }
        DCDebugTracer.trace("DC:: CMD = 43966 ::strCurrentOperationName= " + strCurrentOperationName + "::iOpStatus=" + iOpStatus + "::iOpResult=" + iOpResult);
        if (null != oAsnTaskDevOpInfo.oOprStartTime) {
            Calendar oStartTime = oAsnTaskDevOpInfo.oOprStartTime;
            DCTimeDateUtil.switchToLocalCalendar(oStartTime);
            oProgressInfo.setStartTime(oStartTime);
        }
        if (null != oAsnTaskDevOpInfo.oOprEndTime) {
            Calendar oEndTime = oAsnTaskDevOpInfo.oOprEndTime;
            DCTimeDateUtil.switchToLocalCalendar(oEndTime);
            oProgressInfo.setEndTime(oEndTime);
        }
        String strErrMsg = null;
        if (null != oAsnTaskDevOpInfo.stErrorInfo.strResult) {
            strErrMsg = new String(oAsnTaskDevOpInfo.stErrorInfo.strResult);
        }
        oProgressInfo.setErrorInfo(oAsnTaskDevOpInfo.stErrorInfo.iErrorNo.intValue(), strErrMsg);
        oProgressInfo.setErrorType(oAsnTaskDevOpInfo.stErrorInfo.oResultType.value);
        return oProgressInfo;
    }

    public static Resource getResource(AsnTaskResource oAsnTaskResource) {
        Resource oResource = new Resource();
        oResource.setDeviceID(oAsnTaskResource.iDeviceId.intValue());
        if (null != oAsnTaskResource.iFrameId) {
            oResource.setFrameId(oAsnTaskResource.iFrameId.intValue());
        }
        if (null != oAsnTaskResource.iSlotId) {
            oResource.setSlotId(oAsnTaskResource.iSlotId.intValue());
        }
        if (null != oAsnTaskResource.iSubSlotId) {
            oResource.setSubSlotId(oAsnTaskResource.iSubSlotId.intValue());
        }
        if (null != oAsnTaskResource.iRoleType) {
            oResource.setRoleType(oAsnTaskResource.iRoleType.intValue());
        }
        if (null != oAsnTaskResource.iParentDevId) {
            oResource.setParentDevId(oAsnTaskResource.iParentDevId.intValue());
        }
        if (null != oAsnTaskResource.iStackId) {
            oResource.setStackId(oAsnTaskResource.iStackId.intValue());
        }
        if (null != oAsnTaskResource.strSWversion) {
            oResource.setDeviceVersion(new String(oAsnTaskResource.strSWversion));
        }
        if (null != oAsnTaskResource.iDevTypeId && null != oAsnTaskResource.iDevTypeVerId) {
            DeviceTypeInfo oDevTypeInfo = DeviceInfoManagerImpl.getInstance().getDeviceTypeInfo(oAsnTaskResource.iDevTypeId.intValue(), oAsnTaskResource.iDevTypeVerId.intValue());
            oResource.setStackDevTypeInfo(oDevTypeInfo);
        }
        return oResource;
    }

    public static Resource getResourceFromDeviceType(AsnTaskResource oAsnResource, DeviceType oDeviceType) {
        if (null == oDeviceType || null == oDeviceType.getResources() || 0 == oDeviceType.getResources().size()) {
            return null;
        }
        THashSet<Resource> oResources = oDeviceType.getResources();
        Iterator oResItor = oResources.iterator();
        Resource oResource = null;
        while (oResItor.hasNext()) {
            oResource = (Resource)oResItor.next();
            int iDeviceId = oAsnResource.iDeviceId.intValue();
            int iFrameId = TaskCommUtil.converBigIntToint(oAsnResource.iFrameId);
            int iSlotId = TaskCommUtil.converBigIntToint(oAsnResource.iSlotId);
            int iSubSlotId = TaskCommUtil.converBigIntToint(oAsnResource.iSubSlotId);
            int iStackId = TaskCommUtil.converBigIntToint(oAsnResource.iStackId);
            if (iDeviceId == oResource.getDeviceID() && iFrameId == oResource.getFrameId() && iSlotId == oResource.getSlotId() && iSubSlotId == oResource.getSubSlotId() && iStackId == oResource.getStackId()) {
                return oResource;
            }
            if (iDeviceId != oResource.getDeviceID()) continue;
            Resource resource = new Resource();
            resource.setDeviceID(iDeviceId);
            resource.setDeviceIP(oResource.getDeviceIP());
            resource.setDeviceName(oResource.getDeviceName());
            resource.setDeviceVersion(oResource.getDeviceVersion());
            resource.setFrameId(iFrameId);
            resource.setSlotId(iSlotId);
            resource.setStackId(iStackId);
            if (null != oAsnResource.strSWversion) {
                resource.setDeviceVersion(new String(oAsnResource.strSWversion));
            }
            if (null != oAsnResource.iDevTypeId && null != oAsnResource.iDevTypeVerId) {
                DeviceTypeInfo oDevTypeInfo = DeviceInfoManagerImpl.getInstance().getDeviceTypeInfo(oAsnResource.iDevTypeId.intValue(), oAsnResource.iDevTypeVerId.intValue());
                resource.setStackDevTypeInfo(oDevTypeInfo);
            }
            return resource;
        }
        return null;
    }

    public static Resource getResourceFromResourceProgressInfo(AsnResourceProgressInfo oAsnResourceProgress) {
        Resource oResource = new Resource();
        ResourceProgressInfo oResourceProgress = new ResourceProgressInfo();
        oResource.setProgressInfo(oResourceProgress);
        oResourceProgress.setProgress(oAsnResourceProgress.iResourceProgress.intValue());
        int iDevID = oAsnResourceProgress.oAsnTaskResource.iDeviceId.intValue();
        oResource.setDeviceID(iDevID);
        DeviceInfo oDeviceInfo = DeviceInfoManagerImpl.getInstance().getDevice(iDevID);
        if (null == oDeviceInfo) {
            return null;
        }
        DeviceTypeInfo oDeviceTypeInfo = oDeviceInfo.getDeviceTypeInfo();
        if (null == oDeviceTypeInfo) {
            return null;
        }
        DeviceType oDevType = new DeviceType();
        oDevType.setDeviceTypeName(oDeviceTypeInfo.getDevTypeName());
        oDevType.setDeviceTypeVersionName(oDeviceTypeInfo.getDevTypeVersionName());
        String strDevTypeIDAndVersionID = oDeviceTypeInfo.getDevTypeIDAndVersionID();
        int index = strDevTypeIDAndVersionID.indexOf(95);
        int iDevTypeID = Integer.valueOf(strDevTypeIDAndVersionID.substring(0, index));
        int iDevVersionID = Integer.valueOf(strDevTypeIDAndVersionID.substring(index + 1, strDevTypeIDAndVersionID.length()));
        oDevType.setDeviceTypeID(iDevTypeID);
        oDevType.setDeviceTypeVersionID(iDevVersionID);
        String strOperationID = new String(oAsnResourceProgress.strCurrentOperationId);
        oResourceProgress.setCurrentOperationId(strOperationID);
        oResourceProgress.setCurrentOperationName(TaskCommUtil.getDisplayNameForOperation(oDevType, strOperationID));
        if (null != oAsnResourceProgress.oAsnDCErrorCodeInfo) {
            String strErrMsg = null;
            if (null != oAsnResourceProgress.oAsnDCErrorCodeInfo.strResult) {
                strErrMsg = new String(oAsnResourceProgress.oAsnDCErrorCodeInfo.strResult);
            }
            oResourceProgress.setErrorInfo(oAsnResourceProgress.oAsnDCErrorCodeInfo.iErrorNo.intValue(), strErrMsg);
        }
        if (null != oAsnResourceProgress.strFailureReason) {
            oResourceProgress.setFailureReason(new String(oAsnResourceProgress.strFailureReason));
        }
        oResourceProgress.setProgress(oAsnResourceProgress.iResourceProgress.intValue());
        if (null != oAsnResourceProgress.enResult) {
            oResourceProgress.setResult(oAsnResourceProgress.enResult.value);
        }
        if (null != oAsnResourceProgress.enStatus) {
            oResourceProgress.setState(TaskCommUtil.getStatusFromAsnStatus(oAsnResourceProgress.enStatus));
        }
        return oResource;
    }

    public static List<TaskOpResultInfo> getResultListForTaskOperation(AsnTaskRspList oAsnTaskList) {
        if (null == oAsnTaskList || 0 == oAsnTaskList.size()) {
            return null;
        }
        int iTaskListSize = oAsnTaskList.size();
        AsnTaskRsp oTaskRsp = null;
        ArrayList<TaskOpResultInfo> oTaskOpResultList = new ArrayList<TaskOpResultInfo>(0);
        TaskOpResultInfo oTaskResult = null;
        for (int i = 0; i < iTaskListSize; ++i) {
            oTaskRsp = (AsnTaskRsp)oAsnTaskList.get(i);
            oTaskResult = new TaskOpResultInfo();
            oTaskResult.setTaskId(oTaskRsp.iTaskID.intValue());
            oTaskResult.setOperationResultList(TaskCommUtil.getOpResultListForTask(oTaskRsp));
            oTaskOpResultList.add(oTaskResult);
        }
        return oTaskOpResultList;
    }

    public static int getStatusFromAsnStatus(AsnStatusEnum oTaskStatus) {
        switch (oTaskStatus.value) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
        }
        return -1;
    }

    public static String getSWDLStatusRes(int iSWDLStatus) {
        String swdlRes = "";
        ResourceManager resManager = ResourceManager.getInstance();
        String key = "SWDL_STATUS_" + iSWDLStatus;
        swdlRes = resManager.getResString(key);
        return swdlRes;
    }

    public static String getMainBoardNum(int iMainBoardNum) {
        String strMainBoardNum = "--";
        ResourceManager resManager = ResourceManager.getInstance();
        String key = "MAIN_BOARD_NUM_" + iMainBoardNum;
        strMainBoardNum = resManager.getResString(key);
        return strMainBoardNum;
    }

    public static String getSWDLStatusRes(int iSWDLStatus, ITask oTask) {
        if (null == oTask) {
            return "";
        }
        int iTaskTypeID = oTask.getTaskTypeId();
        if (iTaskTypeID == 4 || iTaskTypeID == 13 || iTaskTypeID == 5 || iTaskTypeID == 12 || iTaskTypeID == 268 || iTaskTypeID == 261 || iTaskTypeID == 269 || iTaskTypeID == 260) {
            return TaskCommUtil.getSWDLStatusRes(iSWDLStatus);
        }
        return "";
    }

    public static ITaskDeviceOperation getTaskOperation(List operationList, String strOpId) {
        ITaskDeviceOperation oTaskDeviceOperation = null;
        if (null != operationList) {
            int iSize = operationList.size();
            for (int i = 0; i < iSize; ++i) {
                Object oObject = operationList.get(i);
                if (!(oObject instanceof IOperation) || !Collator.getInstance().equals(strOpId, ((ITaskDeviceOperation)oObject).getOperationIdString())) continue;
                oTaskDeviceOperation = (ITaskDeviceOperation)oObject;
                break;
            }
        }
        return oTaskDeviceOperation;
    }

    public static int getTaskTypeFrmAsn(int iAsnTaskType) {
        int iTaskType = -1;
        if (iAsnTaskType > 256) {
            return iAsnTaskType;
        }
        switch (iAsnTaskType) {
            case 0: {
                iTaskType = 0;
                break;
            }
            case 1: {
                iTaskType = 1;
                break;
            }
            case 2: {
                iTaskType = 2;
                break;
            }
            case 6: {
                iTaskType = 6;
                break;
            }
            case 3: {
                iTaskType = 3;
                break;
            }
            case 4: {
                iTaskType = 4;
                break;
            }
            case 5: {
                iTaskType = 5;
                break;
            }
            case 13: {
                iTaskType = 13;
                break;
            }
            case 12: {
                iTaskType = 12;
                break;
            }
            case 7: {
                iTaskType = 7;
                break;
            }
        }
        return iTaskType;
    }

    public static AsnUpgradeFeasibilitySupportReq getUFCSupportCheckReq(int iDevTypeID, int iDevTypeVerID, String strTargetVersion) {
        AsnUpgradeFeasibilitySupportReq oReq = new AsnUpgradeFeasibilitySupportReq();
        oReq.iDevTypeId = BigInteger.valueOf(iDevTypeID);
        oReq.iDevTypeVerId = BigInteger.valueOf(iDevTypeVerID);
        oReq.strTargetVersion = strTargetVersion.getBytes();
        return oReq;
    }

    public static boolean isOperationAvailable(List operationList, String strOpId) {
        boolean bIsOperationAvailable = false;
        if (null != operationList) {
            int iSize = operationList.size();
            for (int i = 0; i < iSize; ++i) {
                Object oObject = operationList.get(i);
                if (!(oObject instanceof IOperation) || !Collator.getInstance().equals(strOpId, ((IOperation)oObject).getOperationIdString())) continue;
                bIsOperationAvailable = true;
                break;
            }
        }
        return bIsOperationAvailable;
    }

    public static boolean isWorkModeOperationAvailable(List operationList) {
        return TaskCommUtil.isOperationAvailable(operationList, "SetWorkMode");
    }

    public static void updateUpgradeSwitchOp(AsnTaskInfo oAsnTaskInfo, List oOperationList) {
        if (null == oAsnTaskInfo.oTaskCommonInfo.enDevWorkModeEnum) {
            if (TaskCommUtil.isWorkModeOperationAvailable(oOperationList)) {
                TaskCommUtil.removeOperation(oOperationList, "SetWorkMode");
            }
        } else {
            ITaskDeviceOperation oTaskDeviceOperation = TaskCommUtil.getTaskOperation(oOperationList, "SetWorkMode");
            if (null != oTaskDeviceOperation) {
                switch (oAsnTaskInfo.oTaskCommonInfo.enDevWorkModeEnum.value) {
                    case 0: {
                        oTaskDeviceOperation.setSelected(false);
                        break;
                    }
                    case 1: {
                        oTaskDeviceOperation.setSelected(true);
                        break;
                    }
                }
            }
        }
    }

    public static Resource populateResourceFromAsnTaskResource(AsnTaskResource oTaskResource, ITask oTask) {
        return AsnTaskInfoUtil.populateResourceFromAsnTaskResource(oTaskResource, oTask);
    }

    public static ITask populateTaskFromAsnTask(AsnTaskInfo oAsnTaskInfo) {
        return AsnTaskInfoUtil.populateTaskFromAsnTask(oAsnTaskInfo, 0);
    }

    public static AsnTaskReq populateTaskReqForRollback(HashMap oTaskResourceMap) {
        DCDebugTracer.trace("Method populateTaskReqForRollback start");
        AsnTaskResourceLst oAsnTaskResourceLst = null;
        AsnTaskReq oAsnTaskReq = null;
        Integer oTaskID = null;
        ArrayList oResourceList = null;
        Resource oResource = null;
        AsnTaskResource oAsnTaskResource = null;
        Iterator oIterator = oTaskResourceMap.entrySet().iterator();
        Map.Entry oEntry = null;
        while (oIterator.hasNext()) {
            oEntry = oIterator.next();
            oTaskID = (Integer)oEntry.getKey();
            if (oTaskID == null || (oResourceList = (ArrayList)oEntry.getValue()) == null) continue;
            oAsnTaskReq = new AsnTaskReq();
            oAsnTaskReq.iTaskID = BigInteger.valueOf(oTaskID.intValue());
            oAsnTaskResourceLst = new AsnTaskResourceLst();
            int iResourceCount = oResourceList.size();
            for (int j = 0; j < iResourceCount; ++j) {
                oResource = (Resource)oResourceList.get(j);
                oAsnTaskResource = new AsnTaskResource();
                oAsnTaskResource.iDeviceId = BigInteger.valueOf(oResource.getDeviceID());
                oAsnTaskResourceLst.add((Object)oAsnTaskResource);
            }
            oAsnTaskReq.oTaskResLst = oAsnTaskResourceLst;
        }
        DCDebugTracer.trace("Method populateTaskReqForRollback end");
        return oAsnTaskReq;
    }

    public static List populateTaskReqList(HashMap oTaskResourceMap) {
        ArrayList<AsnTaskReq> oTaskReqList = new ArrayList<AsnTaskReq>(oTaskResourceMap.size());
        AsnTaskResourceLst oAsnTaskResourceLst = null;
        AsnTaskReq oAsnTaskReq = null;
        Iterator oIterator = oTaskResourceMap.entrySet().iterator();
        Map.Entry oEntry = null;
        while (oIterator.hasNext()) {
            THashSet oResourceList;
            oEntry = oIterator.next();
            Integer oTaskID = (Integer)oEntry.getKey();
            if (oTaskID == null || (oResourceList = (THashSet)oEntry.getValue()) == null) continue;
            oAsnTaskReq = new AsnTaskReq();
            oAsnTaskReq.iTaskID = BigInteger.valueOf(oTaskID.intValue());
            oAsnTaskResourceLst = new AsnTaskResourceLst();
            Iterator oResItor = oResourceList.iterator();
            Resource oResource = null;
            AsnTaskResource oAsnTaskResource = null;
            while (oResItor.hasNext()) {
                oResource = (Resource)oResItor.next();
                oAsnTaskResource = new AsnTaskResource();
                oAsnTaskResource.iDeviceId = BigInteger.valueOf(oResource.getDeviceID());
                oAsnTaskResource.iFrameId = BigInteger.valueOf(oResource.getFrameId());
                oAsnTaskResource.iSlotId = BigInteger.valueOf(oResource.getSlotId());
                oAsnTaskResource.iSubSlotId = BigInteger.valueOf(oResource.getSubSlotId());
                oAsnTaskResource.iRoleType = BigInteger.valueOf(oResource.getRoleType());
                oAsnTaskResource.iParentDevId = BigInteger.valueOf(oResource.getParentDevId());
                oAsnTaskResource.iStackId = BigInteger.valueOf(oResource.getStackId());
                if (null != oResource.getDeviceVersion()) {
                    oAsnTaskResource.strSWversion = oResource.getDeviceVersion().getBytes();
                }
                if (null != oResource.getStackDevTypeInfo()) {
                    oAsnTaskResource.iDevTypeId = BigInteger.valueOf(oResource.getStackDevTypeInfo().getDevTypeID());
                    oAsnTaskResource.iDevTypeVerId = BigInteger.valueOf(oResource.getStackDevTypeInfo().getDevTypeVersionId());
                }
                oAsnTaskResourceLst.add((Object)oAsnTaskResource);
            }
            oAsnTaskReq.oTaskResLst = oAsnTaskResourceLst;
            oTaskReqList.add(oAsnTaskReq);
        }
        return oTaskReqList;
    }

    public static void removeOperation(List operationList, String strOpeId) {
        if (null != operationList) {
            int iSize = operationList.size();
            for (int i = 0; i < iSize; ++i) {
                Object oObject = operationList.get(i);
                if (!(oObject instanceof IOperation) || !Collator.getInstance().equals(strOpeId, ((IOperation)oObject).getOperationIdString())) continue;
                operationList.remove(oObject);
                break;
            }
        }
    }

    public static void setTaskOperationSelectStatus(AsnTaskInfo asnTaskInfo, int iStartOperationID, int iEndOPerationID, boolean bSelected) {
        if (null == asnTaskInfo) {
            return;
        }
        boolean bStart = false;
        AsnOperationInfoLst oOperationLst = asnTaskInfo.oTaskOperationLst;
        AsnOperationInfo oTaskOperation = null;
        String id = null;
        for (int i = 0; i < oOperationLst.size(); ++i) {
            oTaskOperation = (AsnOperationInfo)oOperationLst.get(i);
            if (null == oTaskOperation) continue;
            id = new String(oTaskOperation.strOperationId);
            if (Integer.parseInt(id) == iStartOperationID) {
                bStart = true;
            }
            if (!bStart) continue;
            oTaskOperation.isSelected = bSelected;
            if (Integer.parseInt(id) != iEndOPerationID) continue;
            bStart = false;
        }
    }

    public static void setTaskOperationSelectStatus(ITask oTaskInfo, int iStartOperationID, int iEndOPerationID, boolean bSelected) {
        if (null == oTaskInfo) {
            return;
        }
        boolean bStart = false;
        List<ITaskDeviceOperation> oOperationLst = oTaskInfo.getSupportedOperation();
        ITaskDeviceOperation oTaskOperation = null;
        if (null == oOperationLst) {
            return;
        }
        for (int i = 0; i < oOperationLst.size(); ++i) {
            oTaskOperation = oOperationLst.get(i);
            if (null == oTaskOperation) continue;
            if (oTaskOperation.getOperationId() == iStartOperationID) {
                bStart = true;
            }
            if (!bStart) continue;
            oTaskOperation.setSelected(bSelected);
            if (oTaskOperation.getOperationId() != iEndOPerationID) continue;
            bStart = false;
        }
    }

    public static void setTaskOperationSelectStatus(ITask oTaskInfo, List<Integer> oOpeIDLst, boolean bSelected) {
        if (null == oTaskInfo || null == oOpeIDLst) {
            return;
        }
        List<ITaskDeviceOperation> oOperationLst = oTaskInfo.getSupportedOperation();
        ITaskDeviceOperation oTaskOperation = null;
        if (null == oOperationLst) {
            return;
        }
        for (int i = 0; i < oOperationLst.size(); ++i) {
            oTaskOperation = oOperationLst.get(i);
            if (null == oTaskOperation || !oOpeIDLst.contains(oTaskOperation.getOperationId())) continue;
            oTaskOperation.setSelected(bSelected);
        }
    }

    public static void updateIsolationTaskFromAsnTask(AsnTaskInfo oAsnTaskInfo, ITask oTask) {
        AsnTaskInfoUtil.updateIsolationTaskFromAsnTask(oAsnTaskInfo, oTask);
    }

    public static void updatePostUpgradeInfo(ITaskDeviceOperation oPostUpgradeOp, AsnUpgradeOpInfo oAsnUpgradeOpInfo) {
        AsnOperationInfoLst oAsnOperationInfoLst = oAsnUpgradeOpInfo.oSubOperationLst;
        List oUpgradeSubOprList = (List)oPostUpgradeOp.getConfiguredPara();
        int iSizeOfAsnLst = oAsnOperationInfoLst.size();
        AsnOperationInfo oAsnOperationInfo = null;
        String strOPerationId = null;
        int iSizeOfOprLst = oUpgradeSubOprList.size();
        IUpgradeSubOperation oSubOperation = null;
        for (int j = 0; j < iSizeOfOprLst; ++j) {
            oSubOperation = (IUpgradeSubOperation)oUpgradeSubOprList.get(j);
            boolean bFlag = false;
            for (int i = 0; i < iSizeOfAsnLst; ++i) {
                oAsnOperationInfo = (AsnOperationInfo)oAsnOperationInfoLst.get(i);
                strOPerationId = new String(oAsnOperationInfo.strOperationId);
                if (!Collator.getInstance().equals(strOPerationId, oSubOperation.getOperationIdString())) continue;
                bFlag = true;
                oSubOperation.setSelected(oAsnOperationInfo.isSelected);
                break;
            }
            if (bFlag) continue;
            oSubOperation.setSelected(false);
        }
    }

    public static void updateResourceProgress(AsnResourceProgressInfo oAsnResourceProgress, Resource oResource, DeviceType oDeviceType, ITask oTask) {
        if (null == oResource) {
            return;
        }
        ResourceProgressInfo oResourceProgress = oResource.getProgressInfo();
        if (null == oResourceProgress) {
            oResourceProgress = new ResourceProgressInfo();
            oResource.setProgressInfo(oResourceProgress);
        }
        if (null != oAsnResourceProgress.oSWDLStatus) {
            oResource.setSWDLStatus(oAsnResourceProgress.oSWDLStatus.value);
        }
        if (null != oAsnResourceProgress.oAsnDCErrorCodeInfo) {
            String strErrMsg = null;
            if (null != oAsnResourceProgress.oAsnDCErrorCodeInfo.strResult) {
                strErrMsg = new String(oAsnResourceProgress.oAsnDCErrorCodeInfo.strResult);
            }
            if ((oTask.getTaskTypeId() == 13 || oTask.getTaskTypeId() == 12) && 995098636 == oAsnResourceProgress.oAsnDCErrorCodeInfo.iErrorNo.intValue()) {
                oAsnResourceProgress.oAsnDCErrorCodeInfo.iErrorNo = BigInteger.valueOf(1074200608L);
            }
            oResourceProgress.setErrorInfo(oAsnResourceProgress.oAsnDCErrorCodeInfo.iErrorNo.intValue(), strErrMsg);
            oResourceProgress.setErrorType(oAsnResourceProgress.oAsnDCErrorCodeInfo.oResultType.value);
        }
        oResourceProgress.setSWDLStatus(TaskCommUtil.getSWDLStatusRes(oAsnResourceProgress.oSWDLStatus.value, oTask));
        oResourceProgress.setIntSWDLStatus(oAsnResourceProgress.oSWDLStatus.value);
        oResourceProgress.setProgress(oAsnResourceProgress.iResourceProgress.intValue());
        oResourceProgress.setResult(oAsnResourceProgress.enResult.value);
        oResourceProgress.setState(TaskCommUtil.getStatusFromAsnStatus(oAsnResourceProgress.enStatus));
        if (0 != oResourceProgress.getState()) {
            String strOperationID = new String(oAsnResourceProgress.strCurrentOperationId);
            oResourceProgress.setCurrentOperationId(strOperationID);
            if (Collator.getInstance().equals(strOperationID, "Rollback")) {
                oResourceProgress.setCurrentOperationName(ResourceManager.getInstance().getResString("ROLLBACK_OPERATION_ID"));
            } else if (Collator.getInstance().equals(strOperationID, "ManualActivate")) {
                oResourceProgress.setCurrentOperationName(ResourceManager.getInstance().getResString("MANUAL_ACTIVATE_OPERATION"));
            } else {
                oResourceProgress.setCurrentOperationName(TaskCommUtil.getDisplayNameForOperation(oDeviceType, strOperationID));
            }
        }
    }

    public static void updateSlaveDevInfoResponse(AsnDCSlaveDevInfoRsp oResponse, ITask oTask) {
        AsnDCMasterDevInfoLst oAsnDCMasterDevInfoLst = oResponse.oAsnDCMasterDevInfoLst;
        AsnDCMasterDevInfo oAsnDCMasterDevInfo = null;
        Resource oRes = null;
        AsnDCDeviceIdVer oAsnDCDeviceIdVer = null;
        THashSet<Resource> oResList = oTask.getDeviceType().getResources();
        int iStackID = -1;
        int iSize = oAsnDCMasterDevInfoLst.size();
        Resource oTmpResource = null;
        for (int i = 0; i < iSize; ++i) {
            oAsnDCMasterDevInfo = (AsnDCMasterDevInfo)oAsnDCMasterDevInfoLst.get(i);
            int iDevId = oAsnDCMasterDevInfo.iDevId.intValue();
            AsnDCDeviceIdVerLst oAsnDCDeviceIdVerLst = oAsnDCMasterDevInfo.oAsnDCDevIdVerLst;
            int iSlaveDevSize = oAsnDCMasterDevInfo.oAsnDCDevIdVerLst.size();
            for (int j = 0; j < iSlaveDevSize; ++j) {
                oAsnDCDeviceIdVer = (AsnDCDeviceIdVer)oAsnDCDeviceIdVerLst.get(j);
                DeviceTypeInfo oDevTypeInfo = DeviceInfoManagerImpl.getInstance().getDeviceTypeInfo(oAsnDCDeviceIdVer.iDevTypeId.intValue(), oAsnDCDeviceIdVer.iDevTypeVerId.intValue());
                oTmpResource = oTask.getDeviceType().getResource(iDevId);
                oRes = (Resource)CloneUtil.getClone(oTmpResource);
                if (null != oAsnDCDeviceIdVer.iDevId) {
                    iStackID = oAsnDCDeviceIdVer.iDevId.intValue();
                }
                oRes.setStackId(iStackID);
                oRes.setRoleType(3);
                oRes.setStackDevTypeInfo(oDevTypeInfo);
                oResList.add((Object)oRes);
            }
        }
    }

    public static void updateTaskModelFromAsnTask(AsnTaskInfo oAsnTaskInfo) {
        AsnTaskInfoUtil.updateTaskModelFromAsnTask(oAsnTaskInfo);
    }

    public static void resetStackClusterChildDeviceStep(List oSupportedOpLst, ITask task) {
        if (task.isDMSDomain()) {
            THashSet<Resource> oResources = task.getDeviceType().getResources();
            int iSupOpLstSize = oSupportedOpLst.size();
            ArrayList<Integer> oOperIDLst = new ArrayList<Integer>();
            for (int i = 0; i < iSupOpLstSize; ++i) {
                ITaskDeviceOperation oTaskOp = (ITaskDeviceOperation)oSupportedOpLst.get(i);
                if (!(oTaskOp instanceof PrecheckOperation) && !(oTaskOp instanceof PostcheckOperation) && !(oTaskOp instanceof PrepareUpgradeOperation) && !(oTaskOp instanceof PostUpgradeOperation) || !DeviceInfoUtil.isStackDevicePresent(oResources, 3) && !task.isClusterChildDevice()) continue;
                oOperIDLst.add(oTaskOp.getOperationId());
            }
            TaskInfoUtil2.removeOperation(oSupportedOpLst, oOperIDLst);
        }
    }

    public static int isSamFileImportShow() {
        return iSAMFileImportShow;
    }

    public static void setSamFileImportShow(int ivalue) {
        iSAMFileImportShow = ivalue;
        DCDebugTracer.trace("SAM:setSamFileImportShow#iSAMFileImportShow->" + iSAMFileImportShow);
    }

    public static boolean checkOtherSAMFileInfoTablePanelHasShow() {
        if (0 == iSAMFileImportShow) {
            return false;
        }
        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("EXIST_SAM_IMPORT_NOW"), DCFrameWorkUtil.getLocalizedString("SUGGESTION"), 1);
        TaskCommUtil.openSAMFileInfoTablePanel();
        DCFrameWorkUtil.defaultCursor();
        return true;
    }

    protected static void openSAMFileInfoTablePanel() {
        DCFrameWorkUtil.waitCursor();
        if (1 == iSAMFileImportShow) {
            DCFrameWorkUtil.getDCModuleManager().softwareArchiveManagement();
        } else if (2 == iSAMFileImportShow) {
            DCFrameWorkUtil.getDCModuleManager().taskManagement();
        }
    }
}

