/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.controller;

import com.huawei.dc.common.asndatacenter.AsnCheckReport;
import com.huawei.dc.common.asndatacenter.AsnCheckReportAckRsp;
import com.huawei.dc.common.asndatacenter.AsnCheckReportCell;
import com.huawei.dc.common.asndatacenter.AsnCheckReportHeader;
import com.huawei.dc.common.asndatacenter.AsnCheckReportHeaderInfo;
import com.huawei.dc.common.asndatacenter.AsnCheckReportHeaderList;
import com.huawei.dc.common.asndatacenter.AsnCheckReportLst;
import com.huawei.dc.common.asndatacenter.AsnCheckReportRow;
import com.huawei.dc.common.asndatacenter.AsnCheckReportRowList;
import com.huawei.dc.common.asndatacenter.AsnCheckReportRsp;
import com.huawei.dc.common.asndatacenter.AsnCheckReportTable;
import com.huawei.dc.common.asndatacenter.AsnDCRollBackDeviceRsp;
import com.huawei.dc.common.asndatacenter.AsnDevCheckNodeInfo;
import com.huawei.dc.common.asndatacenter.AsnDevCheckNodeInfoLst;
import com.huawei.dc.common.asndatacenter.AsnStatusEnum;
import com.huawei.dc.common.asndatacenter.AsnTaskResource;
import com.huawei.dc.common.asndatacenter.AsnTaskResultEnum;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.controller.TaskAsynCommControllerHelper;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import com.huawei.dc.taskmgmt.controller.TaskEvent;
import com.huawei.dc.taskmgmt.controller.TaskEventID;
import com.huawei.dc.taskmgmt.controller.TaskInfoNotifier;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import com.huawei.dc.taskmgmt.model.TaskDataModel;
import com.huawei.dc.taskmgmt.report.devlevel.controller.CheckReportNotifier;
import com.huawei.dc.taskmgmt.report.devlevel.controller.ReportNotificationEvent;
import com.huawei.dc.taskmgmt.report.devlevel.model.CheckReport;
import com.huawei.dc.taskmgmt.report.devlevel.model.CheckReportDataModel;
import com.huawei.dc.taskmgmt.report.devlevel.model.CheckReportHeader;
import com.huawei.dc.taskmgmt.report.devlevel.model.CheckReportHeaderElement;
import com.huawei.dc.taskmgmt.report.devlevel.model.CheckReportTable;
import com.huawei.dc.taskmgmt.report.devlevel.model.CheckReportTableCell;
import com.huawei.dc.taskmgmt.report.devlevel.model.DefaultCheckReportTableModel;
import com.huawei.dc.taskmgmt.report.devlevel.model.DevCheckInfo;
import com.huawei.dc.taskmgmt.report.devlevel.model.DevCheckNodeInfo;
import com.huawei.dc.taskmgmt.report.devlevel.model.ICheckReport;
import com.huawei.dc.taskmgmt.report.devlevel.model.ICheckReportDataModel;
import com.huawei.dc.taskmgmt.report.devlevel.model.ICheckReportHeader;
import com.huawei.dc.taskmgmt.report.devlevel.model.ICheckReportHeaderElement;
import com.huawei.dc.taskmgmt.report.devlevel.model.ICheckReportTable;
import com.huawei.dc.taskmgmt.report.devlevel.model.ICheckReportTableCell;
import com.huawei.dc.taskmgmt.report.devlevel.model.InvalidNumOfColException;
import com.huawei.dc.taskmgmt.report.devlevel.model.ReportDevInfoMap;
import com.huawei.dc.taskmgmt.report.devlevel.model.ReportPacketInfo;
import com.swimap.iview.communicate.MSGPacketExt;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.commustru.fstru.FStruct;

public class TaskAsynCommControllerUtil {
    public static void updateCheckReportNotification(MSGPacketExt oPacketExt, int reportType) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ex) {
            DCDebugTracer.trace(ex);
        }
        ReportPacketInfo instance = ReportPacketInfo.getInstance();
        AsnCheckReportAckRsp oasnCheckReportAckRsp = new AsnCheckReportAckRsp();
        int iDecodeErrorCode = -1;
        try {
            iDecodeErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oasnCheckReportAckRsp, oPacketExt.getData());
        }
        catch (Exception ignore) {
            DCDebugTracer.trace(" [ignore] ");
            DCDebugTracer.trace(ignore);
        }
        if (0 == iDecodeErrorCode) {
            int iTotalPackageCount = oasnCheckReportAckRsp.iNumOfReportTable.intValue();
            instance.setPacketNum(iTotalPackageCount);
            ReportNotificationEvent oReportNotificationEvent = new ReportNotificationEvent(0);
            oReportNotificationEvent.setLastMsg(false);
            oReportNotificationEvent.setTotalPackageCount(iTotalPackageCount);
            CheckReportNotifier.getInstance().notifyTaskEvent(oReportNotificationEvent);
            return;
        }
        byte[] packetInfo = oPacketExt.getData();
        List<byte[]> packetLst = instance.getPacketLst();
        packetLst.add(packetInfo);
        int SEQLENGTH = 4;
        if (instance.isReceivePacketOK()) {
            int packetNum = instance.getPacketNum();
            byte[][] packets = new byte[packetNum][];
            byte[] packetContent = null;
            int byteNum = 0;
            byte[] seqBytes = new byte[4];
            for (int i = 0; i < packetNum; ++i) {
                packetContent = packetLst.get(i);
                if (null == packetContent || 0 >= packetContent.length) continue;
                System.arraycopy(packetContent, 0, seqBytes, 0, 4);
                int sequence = TaskAsynCommControllerUtil.byteToInt(seqBytes);
                packets[sequence] = packetContent;
                byteNum = byteNum + packetContent.length - 4;
            }
            byte[] newPacket = new byte[byteNum];
            int srcPos = 0;
            for (int i = 0; i < packetNum; ++i) {
                System.arraycopy(packets[i], 4, newPacket, srcPos, packets[i].length - 4);
                srcPos = srcPos + packets[i].length - 4;
            }
            AsnCheckReportRsp oAsnCheckReportRsp = new AsnCheckReportRsp();
            int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnCheckReportRsp, newPacket);
            if (0 != iErrorCode) {
                TaskAsynCommControllerUtil.sendReportNotification(true, iErrorCode);
                return;
            }
            int iResponseCode = oAsnCheckReportRsp.oErrorInfo.iErrorNo.intValue();
            if (0 == iResponseCode) {
                ICheckReport oReport = TaskAsynCommControllerUtil.getReport(reportType);
                try {
                    ReportDevInfoMap oReportDevInfoMap = ReportDevInfoMap.getInstance();
                    oReportDevInfoMap.clear();
                    TaskAsynCommControllerUtil.saveAsnToData(oReportDevInfoMap.getDevCheckReportInfo(), oAsnCheckReportRsp);
                    TaskAsynCommControllerUtil.updateNodeCheckReport(oReport, oAsnCheckReportRsp);
                    CheckReportDataModel.getInstance().addReport(oReport);
                    TaskAsynCommControllerUtil.sendReportNotification(true, 0);
                }
                catch (InvalidNumOfColException e) {
                    DCDebugTracer.traceError(e.getMessage());
                    TaskAsynCommControllerUtil.sendReportNotification(true, e.getErrorCode());
                }
            } else {
                TaskAsynCommControllerUtil.sendReportNotification(true, iResponseCode);
            }
        } else {
            TaskAsynCommControllerUtil.sendReportNotification(false, 0);
        }
    }

    public static void updateCheckReportNotification(MSGPacketExt oPacketExt) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ex) {
            DCDebugTracer.trace(ex);
        }
        ReportPacketInfo instance = ReportPacketInfo.getInstance();
        AsnCheckReportAckRsp oasnCheckReportAckRsp = new AsnCheckReportAckRsp();
        int iDecodeErrorCode = -1;
        try {
            iDecodeErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oasnCheckReportAckRsp, oPacketExt.getData());
        }
        catch (Exception ignore) {
            DCDebugTracer.trace(" [ignore] ");
            DCDebugTracer.trace(ignore);
        }
        if (0 == iDecodeErrorCode) {
            int iTotalPackageCount = oasnCheckReportAckRsp.iNumOfReportTable.intValue();
            instance.setPacketNum(iTotalPackageCount);
            ReportNotificationEvent oReportNotificationEvent = new ReportNotificationEvent(0);
            oReportNotificationEvent.setLastMsg(false);
            oReportNotificationEvent.setTotalPackageCount(iTotalPackageCount);
            CheckReportNotifier.getInstance().notifyTaskEvent(oReportNotificationEvent);
            return;
        }
        byte[] packetInfo = oPacketExt.getData();
        List<byte[]> packetLst = instance.getPacketLst();
        packetLst.add(packetInfo);
        int SEQLENGTH = 4;
        if (instance.isReceivePacketOK()) {
            int packetNum = instance.getPacketNum();
            byte[][] packets = new byte[packetNum][];
            byte[] packetContent = null;
            int byteNum = 0;
            byte[] seqBytes = new byte[4];
            for (int i = 0; i < packetNum; ++i) {
                packetContent = packetLst.get(i);
                if (null == packetContent || 0 >= packetContent.length) continue;
                System.arraycopy(packetContent, 0, seqBytes, 0, 4);
                int sequence = TaskAsynCommControllerUtil.byteToInt(seqBytes);
                packets[sequence] = packetContent;
                byteNum = byteNum + packetContent.length - 4;
            }
            byte[] newPacket = new byte[byteNum];
            int srcPos = 0;
            for (int i = 0; i < packetNum; ++i) {
                System.arraycopy(packets[i], 4, newPacket, srcPos, packets[i].length - 4);
                srcPos = srcPos + packets[i].length - 4;
            }
            AsnCheckReportRsp oAsnCheckReportRsp = new AsnCheckReportRsp();
            int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnCheckReportRsp, newPacket);
            if (0 != iErrorCode) {
                TaskAsynCommControllerUtil.sendReportNotification(true, iErrorCode);
                return;
            }
            int iResponseCode = oAsnCheckReportRsp.oErrorInfo.iErrorNo.intValue();
            if (0 == iResponseCode) {
                try {
                    ReportDevInfoMap oReportDevInfoMap = ReportDevInfoMap.getInstance();
                    oReportDevInfoMap.clear();
                    TaskAsynCommControllerUtil.saveAsnToData(oReportDevInfoMap.getDevCheckReportInfo(), oAsnCheckReportRsp);
                    TaskAsynCommControllerUtil.sendReportNotification(true, 0);
                }
                catch (InvalidNumOfColException e) {
                    DCDebugTracer.traceError(e.getMessage());
                    TaskAsynCommControllerUtil.sendReportNotification(true, e.getErrorCode());
                }
            } else {
                TaskAsynCommControllerUtil.sendReportNotification(true, iResponseCode);
            }
        } else {
            TaskAsynCommControllerUtil.sendReportNotification(false, 0);
        }
    }

    private static int byteToInt(byte[] bArray) {
        int iRtnValue = 0;
        for (int i = 0; i < bArray.length; ++i) {
            iRtnValue += (bArray[i] & 0xFF) << 8 * (bArray.length - i - 1);
        }
        return iRtnValue;
    }

    private static ICheckReport getReport(int iReportType) {
        ICheckReportDataModel oCheckReportDataModel = CheckReportDataModel.getInstance();
        ICheckReport oReport = oCheckReportDataModel.getReport(iReportType);
        if (null == oReport) {
            oReport = new CheckReport();
            oReport.setReportType(iReportType);
        }
        return oReport;
    }

    private static void sendReportNotification(boolean isLastMsg, int iResponseCode) {
        ReportNotificationEvent oReportNotificationEvent = new ReportNotificationEvent(iResponseCode);
        oReportNotificationEvent.setLastMsg(isLastMsg);
        CheckReportNotifier.getInstance().notifyTaskEvent(oReportNotificationEvent);
    }

    private static void saveAsnToData(Map<Integer, DevCheckInfo> dataMap, AsnCheckReportRsp oAsnCheckReportRsp) throws InvalidNumOfColException {
        if (null == oAsnCheckReportRsp) {
            throw new InvalidNumOfColException();
        }
        AsnCheckReportLst oAsnCheckReportLst = oAsnCheckReportRsp.oAsnCheckReportLst;
        if (null == oAsnCheckReportLst) {
            throw new InvalidNumOfColException();
        }
        int tabelNum = oAsnCheckReportLst.size();
        DevCheckInfo devCheckInfo = null;
        DevCheckNodeInfo oDevCheckNodeInfo = null;
        AsnDevCheckNodeInfo oAsnDevCheckNodeInfo = null;
        AsnCheckReport oAsnCheckReport = null;
        Integer devId = null;
        IDeviceInfoManager devInfoMng = DeviceInfoManagerImpl.getInstance();
        DeviceInfo deviceInfo = null;
        DeviceTypeInfo deviceTypeInfo = null;
        for (int i = 0; i < tabelNum; ++i) {
            oAsnCheckReport = (AsnCheckReport)oAsnCheckReportLst.get(i);
            if (null != oAsnCheckReport) {
                devId = oAsnCheckReport.iDevID.intValue();
                deviceInfo = devInfoMng.getDevice(devId);
                deviceTypeInfo = deviceInfo.getDeviceTypeInfo();
                oAsnDevCheckNodeInfo = oAsnCheckReport.oAsnDevCheckNodeInfo;
                devCheckInfo = new DevCheckInfo();
                devCheckInfo.setiNumOfPreCheckAlarm(oAsnCheckReport.iNumOfPreCheckAlarm.longValue());
                devCheckInfo.setiNumOfPostCheckAlarm(oAsnCheckReport.iNumOfPostCheckAlarm.longValue());
                devCheckInfo.setINumOfDelCheckAlarm(oAsnCheckReport.iNumOfDelCheckAlarm.longValue());
                devCheckInfo.setINumOfNewCheckAlarm(oAsnCheckReport.iNumOfNewCheckAlarm.longValue());
                devCheckInfo.setINumOfOldCheckAlarm(oAsnCheckReport.iNumOfOldCheckAlarm.longValue());
                devCheckInfo.setiCheckReportType(oAsnCheckReport.enCheckReportType.value);
                devCheckInfo.setiCheckCompareResult(oAsnCheckReport.enCheckCompareResultEnum.value);
                oDevCheckNodeInfo = new DevCheckNodeInfo();
                if (null == deviceTypeInfo) {
                    throw new InvalidNumOfColException();
                }
                TaskAsynCommControllerUtil.updateDevCheckNodeInfo(oDevCheckNodeInfo, oAsnDevCheckNodeInfo, deviceTypeInfo);
                if (dataMap.containsKey(devId)) {
                    devCheckInfo = dataMap.get(devId);
                    if (devCheckInfo == null) continue;
                    devCheckInfo.getoDevCheckNodeInfoLst().add(oDevCheckNodeInfo);
                    continue;
                }
                devCheckInfo.getoDevCheckNodeInfoLst().add(oDevCheckNodeInfo);
                dataMap.put(devId, devCheckInfo);
                continue;
            }
            throw new InvalidNumOfColException();
        }
    }

    private static void updateNodeCheckReport(ICheckReport report, AsnCheckReportRsp oAsnCheckReportRsp) throws InvalidNumOfColException {
        if (null == oAsnCheckReportRsp) {
            throw new InvalidNumOfColException();
        }
        AsnCheckReportLst oAsnCheckReportLst = oAsnCheckReportRsp.oAsnCheckReportLst;
        if (null == oAsnCheckReportLst) {
            throw new InvalidNumOfColException();
        }
        int tabelNum = oAsnCheckReportLst.size();
        AsnDevCheckNodeInfo oAsnDevCheckNodeInfo = null;
        AsnCheckReport oAsnCheckReport = null;
        Integer devId = 0;
        Integer tempDevId = 0;
        if (tabelNum > 0) {
            oAsnCheckReport = (AsnCheckReport)oAsnCheckReportLst.get(0);
            if (null == oAsnCheckReport || null == oAsnCheckReport.iDevID) {
                throw new InvalidNumOfColException();
            }
        } else {
            return;
        }
        devId = oAsnCheckReport.iDevID.intValue();
        ReportDevInfoMap oReportDevInfoMap = ReportDevInfoMap.getInstance();
        Map<Integer, DevCheckInfo> dataMap = oReportDevInfoMap.getDevCheckReportInfo();
        List<DevCheckNodeInfo> nodeInfoLst = dataMap.get(devId).getoDevCheckNodeInfoLst();
        int nodeInfoNum = nodeInfoLst.size();
        DevCheckNodeInfo oDevCheckNodeInfo = null;
        String nodeId = null;
        for (int index = 0; index < nodeInfoNum; ++index) {
            oDevCheckNodeInfo = nodeInfoLst.get(index);
            nodeId = oDevCheckNodeInfo.getNodeId();
            for (int i = 0; i < tabelNum; ++i) {
                oAsnCheckReport = (AsnCheckReport)oAsnCheckReportLst.get(i);
                if (null != oAsnCheckReport) {
                    tempDevId = oAsnCheckReport.iDevID.intValue();
                    if (devId.intValue() == tempDevId.intValue()) continue;
                    oAsnDevCheckNodeInfo = oAsnCheckReport.oAsnDevCheckNodeInfo;
                    if (null != oAsnDevCheckNodeInfo) {
                        String asnNodeID = new String(oAsnDevCheckNodeInfo.strNodeID);
                        if (!nodeId.equalsIgnoreCase(asnNodeID)) continue;
                        TaskAsynCommControllerUtil.fillCheckItemInfo(oDevCheckNodeInfo, oAsnDevCheckNodeInfo);
                        continue;
                    }
                    throw new InvalidNumOfColException();
                }
                throw new InvalidNumOfColException();
            }
            report.addCheckReportTableNode(oDevCheckNodeInfo);
        }
    }

    private static void fillCheckItemInfo(DevCheckNodeInfo oDevCheckNodeInfo, AsnDevCheckNodeInfo oAsnDevCheckNodeInfo) throws InvalidNumOfColException {
        AsnDevCheckNodeInfoLst asnNodeInfoLst = oAsnDevCheckNodeInfo.oAsnDevCheckNodeInfoLst;
        if (null == asnNodeInfoLst) {
            return;
        }
        List<DevCheckNodeInfo> nodeInfoLst = oDevCheckNodeInfo.getDevCheckNodeInfoLst();
        int asnNodeInfoNum = asnNodeInfoLst.size();
        int nodeInfoNum = 0;
        String asnNodeID = null;
        String nodeId = null;
        DevCheckNodeInfo tempNodeInfo = null;
        AsnDevCheckNodeInfo asnNodeInfo = null;
        DevCheckNodeInfo nodeInfo = null;
        boolean isNewNode = true;
        for (int i = 0; i < asnNodeInfoNum; ++i) {
            asnNodeInfo = (AsnDevCheckNodeInfo)asnNodeInfoLst.get(i);
            if (null == asnNodeInfo || null == asnNodeInfo.strNodeID) continue;
            asnNodeID = new String(asnNodeInfo.strNodeID);
            nodeInfoNum = nodeInfoLst.size();
            isNewNode = true;
            for (int j = 0; j < nodeInfoNum; ++j) {
                nodeInfo = nodeInfoLst.get(j);
                nodeId = nodeInfo.getNodeId();
                if (!nodeId.equalsIgnoreCase(asnNodeID)) continue;
                TaskAsynCommControllerUtil.fillCheckItemInfo(nodeInfo, asnNodeInfo);
                isNewNode = false;
            }
            if (!isNewNode) continue;
            tempNodeInfo = new DevCheckNodeInfo();
            TaskAsynCommControllerUtil.updateDevCheckNodeInfo(tempNodeInfo, asnNodeInfo);
            nodeInfoLst.add(tempNodeInfo);
        }
    }

    private static void updateDevCheckNodeInfo(DevCheckNodeInfo oDevCheckNodeInfo, AsnDevCheckNodeInfo oAsnDevCheckNodeInfo) throws InvalidNumOfColException {
        if (null == oAsnDevCheckNodeInfo) {
            return;
        }
        if (null != oAsnDevCheckNodeInfo.strNodeID) {
            oDevCheckNodeInfo.setNodeId(new String(oAsnDevCheckNodeInfo.strNodeID));
        }
        if (null != oAsnDevCheckNodeInfo.iStatus) {
            oDevCheckNodeInfo.setStatus(oAsnDevCheckNodeInfo.iStatus.intValue());
        }
        oDevCheckNodeInfo.setIsCheckItem(oAsnDevCheckNodeInfo.bIsCheckitem);
        CheckReportTable oCheckReportTable = new CheckReportTable();
        AsnCheckReportTable oAsnCheckReportTable = oAsnDevCheckNodeInfo.oAsnCheckReportTable;
        int headerColumnNum = 0;
        int rowNum = 0;
        if (null != oAsnCheckReportTable) {
            AsnCheckReportRowList rowLst;
            AsnCheckReportHeaderList headerLst;
            if (null != oAsnCheckReportTable.oCheckReportHeaderInfo && null != (headerLst = oAsnCheckReportTable.oCheckReportHeaderInfo.oHeaderList) && 0 < headerLst.size()) {
                headerColumnNum = headerLst.size();
                TaskAsynCommControllerUtil.updateCheckTableHeader(oCheckReportTable, oAsnCheckReportTable.oCheckReportHeaderInfo);
            }
            if (null != (rowLst = oAsnCheckReportTable.oAsnCheckReportRowList) && 0 < rowLst.size()) {
                rowNum = rowLst.size();
                TaskAsynCommControllerUtil.updateCheckTableData(oCheckReportTable, oAsnCheckReportTable.oAsnCheckReportRowList);
            }
        }
        if (0 != headerColumnNum || 0 != rowNum) {
            oDevCheckNodeInfo.setCheckReportTable(oCheckReportTable);
        } else {
            oCheckReportTable = null;
        }
        AsnDevCheckNodeInfoLst oAsnDevCheckNodeInfoLst = oAsnDevCheckNodeInfo.oAsnDevCheckNodeInfoLst;
        if (null == oAsnDevCheckNodeInfoLst) {
            return;
        }
        int subNodeNum = oAsnDevCheckNodeInfoLst.size();
        DevCheckNodeInfo devCheckNodeInfo = null;
        List<DevCheckNodeInfo> nodeInfoLst = oDevCheckNodeInfo.getDevCheckNodeInfoLst();
        for (int i = 0; i < subNodeNum; ++i) {
            devCheckNodeInfo = new DevCheckNodeInfo();
            TaskAsynCommControllerUtil.updateDevCheckNodeInfo(devCheckNodeInfo, (AsnDevCheckNodeInfo)oAsnDevCheckNodeInfoLst.get(i));
            nodeInfoLst.add(devCheckNodeInfo);
        }
    }

    private static void updateDevCheckNodeInfo(DevCheckNodeInfo oDevCheckNodeInfo, AsnDevCheckNodeInfo oAsnDevCheckNodeInfo, DeviceTypeInfo deviceTypeInfo) throws InvalidNumOfColException {
        if (null == oAsnDevCheckNodeInfo) {
            return;
        }
        if (null != oAsnDevCheckNodeInfo.strNodeID) {
            if (deviceTypeInfo.isDMSDomain()) {
                if (ResourceManager.getInstance().isDmsForSpecialDevType(deviceTypeInfo.getDevTypeName())) {
                    oDevCheckNodeInfo.setNodeId(new String(oAsnDevCheckNodeInfo.strNodeID), deviceTypeInfo.getDevTypeName());
                } else {
                    oDevCheckNodeInfo.setNodeId(new String(oAsnDevCheckNodeInfo.strNodeID));
                }
            } else {
                oDevCheckNodeInfo.setNodeId(new String(oAsnDevCheckNodeInfo.strNodeID));
            }
        }
        if (null != oAsnDevCheckNodeInfo.iStatus) {
            oDevCheckNodeInfo.setStatus(oAsnDevCheckNodeInfo.iStatus.intValue());
        }
        oDevCheckNodeInfo.setIsCheckItem(oAsnDevCheckNodeInfo.bIsCheckitem);
        CheckReportTable oCheckReportTable = new CheckReportTable();
        AsnCheckReportTable oAsnCheckReportTable = oAsnDevCheckNodeInfo.oAsnCheckReportTable;
        int headerColumnNum = 0;
        int rowNum = 0;
        if (null != oAsnCheckReportTable) {
            AsnCheckReportRowList rowLst;
            if (null != oAsnCheckReportTable.oCheckReportHeaderInfo) {
                AsnCheckReportHeaderList headerLst = oAsnCheckReportTable.oCheckReportHeaderInfo.oHeaderList;
                if (2 != deviceTypeInfo.getDevDomain()) {
                    if (null != headerLst && 0 < headerLst.size()) {
                        headerColumnNum = headerLst.size();
                        TaskAsynCommControllerUtil.updateCheckTableHeader(oCheckReportTable, oAsnCheckReportTable.oCheckReportHeaderInfo);
                    } else {
                        throw new InvalidNumOfColException();
                    }
                }
            }
            if (null != (rowLst = oAsnCheckReportTable.oAsnCheckReportRowList) && 0 < rowLst.size()) {
                rowNum = rowLst.size();
                TaskAsynCommControllerUtil.updateCheckTableData(oCheckReportTable, oAsnCheckReportTable.oAsnCheckReportRowList);
            }
        }
        if (0 != headerColumnNum || 0 != rowNum) {
            oDevCheckNodeInfo.setCheckReportTable(oCheckReportTable);
        } else {
            oCheckReportTable = null;
        }
        AsnDevCheckNodeInfoLst oAsnDevCheckNodeInfoLst = oAsnDevCheckNodeInfo.oAsnDevCheckNodeInfoLst;
        if (null == oAsnDevCheckNodeInfoLst) {
            return;
        }
        int subNodeNum = oAsnDevCheckNodeInfoLst.size();
        DevCheckNodeInfo devCheckNodeInfo = null;
        List<DevCheckNodeInfo> nodeInfoLst = oDevCheckNodeInfo.getDevCheckNodeInfoLst();
        for (int i = 0; i < subNodeNum; ++i) {
            devCheckNodeInfo = new DevCheckNodeInfo();
            TaskAsynCommControllerUtil.updateDevCheckNodeInfo(devCheckNodeInfo, (AsnDevCheckNodeInfo)oAsnDevCheckNodeInfoLst.get(i), deviceTypeInfo);
            nodeInfoLst.add(devCheckNodeInfo);
        }
    }

    private static void updateCheckTableData(ICheckReportTable checkReportTable, AsnCheckReportRowList oAsnCheckReportRowList) throws InvalidNumOfColException {
        if (null == oAsnCheckReportRowList) {
            return;
        }
        int iColCount = 0;
        int iRowCount = oAsnCheckReportRowList.size();
        AsnCheckReportRow oAsnCheckReportRow = null;
        if (iRowCount > 0) {
            oAsnCheckReportRow = (AsnCheckReportRow)oAsnCheckReportRowList.get(0);
            iColCount = oAsnCheckReportRow.size();
        }
        DefaultCheckReportTableModel oCheckReportTableModel = new DefaultCheckReportTableModel(iColCount);
        int tableHeaderColNum = 0;
        ICheckReportHeader header = checkReportTable.getTableHeader();
        if (null != header) {
            tableHeaderColNum = header.getColumnCount();
        }
        Vector<ICheckReportTableCell> colVector = null;
        for (int i = 0; i < iRowCount; ++i) {
            oAsnCheckReportRow = (AsnCheckReportRow)oAsnCheckReportRowList.get(i);
            if (null == oAsnCheckReportRow) {
                throw new InvalidNumOfColException();
            }
            if (0 != tableHeaderColNum && tableHeaderColNum != oAsnCheckReportRow.size()) {
                throw new InvalidNumOfColException();
            }
            colVector = TaskAsynCommControllerUtil.getCheckTableRow(checkReportTable, oAsnCheckReportRow);
            oCheckReportTableModel.addRow(colVector);
        }
        checkReportTable.setModel(oCheckReportTableModel);
    }

    private static Vector<ICheckReportTableCell> getCheckTableRow(ICheckReportTable checkReportTable, AsnCheckReportRow oAsnCheckReportRow) {
        if (null == oAsnCheckReportRow) {
            return null;
        }
        int iColCount = oAsnCheckReportRow.size();
        Vector<ICheckReportTableCell> oRow = new Vector<ICheckReportTableCell>(iColCount);
        CheckReportTableCell oCheckReportTableCell = null;
        AsnCheckReportCell oAsnCheckReportCell = null;
        String strCellValue = null;
        int mark = 0;
        for (int iColIndex = 0; iColIndex < iColCount; ++iColIndex) {
            oCheckReportTableCell = new CheckReportTableCell();
            oAsnCheckReportCell = (AsnCheckReportCell)oAsnCheckReportRow.get(iColIndex);
            strCellValue = TaskAsynCommControllerUtil.getCellValue(oAsnCheckReportCell, checkReportTable, iColIndex);
            oCheckReportTableCell.setValue(strCellValue);
            if (null != oAsnCheckReportCell.iCheckResultMark) {
                mark = oAsnCheckReportCell.iCheckResultMark.intValue();
                oCheckReportTableCell.setCheckResultMark(mark);
            }
            oRow.add(oCheckReportTableCell);
        }
        return oRow;
    }

    private static String getCellValue(AsnCheckReportCell oAsnCheckReportCell, ICheckReportTable checkReportTable, int iCol) {
        ICheckReportHeader oTableHeader = checkReportTable.getTableHeader();
        String strValue = new String(oAsnCheckReportCell.strCellValue).intern();
        if (null == oTableHeader) {
            return strValue;
        }
        if (0 == checkReportTable.getTableType()) {
            ICheckReportHeaderElement oHeaderElement = oTableHeader.getHeaderElement(iCol);
            if (oHeaderElement.getColumnNameKey().equals("ERROR_DETAIL_COL")) {
                strValue = TaskAsynCommControllerUtil.getErrorCodeValue(strValue);
            } else if (oHeaderElement.getColumnNameKey().equals("OPERATION_NAME_COL")) {
                strValue = ResourceManager.getInstance().getResString(strValue);
            }
        }
        return strValue;
    }

    private static String getErrorCodeValue(String strValue) {
        try {
            return ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(Long.parseLong(strValue)));
        }
        catch (NumberFormatException e) {
            return ResourceManager.getInstance().getResString(strValue);
        }
    }

    public static void updateRollbackProgressNotification(MSGPacketExt oPacketExt, int cmdCode) {
        Resource oResource;
        DCDebugTracer.trace("TaskAsynCommController->updateRollbackProgressNotification: begin");
        AsnDCRollBackDeviceRsp oAsnDCRollBackDeviceRsp = new AsnDCRollBackDeviceRsp();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnDCRollBackDeviceRsp, oPacketExt.getData());
        if (0 != iErrorCode) {
            return;
        }
        DCDebugTracer.trace("TaskAsynCommController->updateRollbackProgressNotification decodeAsn1Data successful->: begin: " + iErrorCode);
        ITask oTask = TaskDataModel.getInstance().getTask(oAsnDCRollBackDeviceRsp.iTaskId.intValue());
        if (null == oTask) {
            return;
        }
        DCDebugTracer.trace("TaskAsynCommController->updateRollbackProgressNotificationo Task Name " + oTask.getTaskName());
        DeviceType oDevType = oTask.getSelectedDeviceType();
        TaskEvent oTaskEvent = null;
        AsnTaskResource oAsnTaskResource = oAsnDCRollBackDeviceRsp.oAsnTaskResource;
        int iDevID = oAsnTaskResource.iDeviceId.intValue();
        int iFrameID = -1;
        int iSlotID = -1;
        int iStackID = -1;
        if (null != oAsnTaskResource.iFrameId) {
            iFrameID = oAsnTaskResource.iFrameId.intValue();
        }
        if (null != oAsnTaskResource.iSlotId) {
            iSlotID = oAsnTaskResource.iSlotId.intValue();
        }
        if (null != oAsnTaskResource.iStackId) {
            iStackID = oAsnTaskResource.iStackId.intValue();
        }
        if ((oResource = oDevType.getResource(iDevID, iFrameID, iSlotID, iStackID)) == null) {
            DCDebugTracer.trace("oDevType : " + oDevType);
            oDevType = oTask.getTemporaryDevType();
            DCDebugTracer.trace("oTemporaryDevType : " + oDevType);
            if (oDevType != null) {
                oResource = oDevType.getResource(iDevID, iFrameID, iSlotID, iStackID);
            }
        }
        if (null == oResource) {
            return;
        }
        ResourceProgressInfo oResourceProgress = oResource.getProgressInfo();
        if (cmdCode == 43946) {
            String strOperationID = ResourceManager.getInstance().getResString("ROLLBACK_OPERATION_ID");
            oResourceProgress.setCurrentOperationId("Rollback");
            oResourceProgress.setCurrentOperationName(strOperationID);
        } else {
            oResourceProgress.setCurrentOperationId("ManualActivate");
            oResourceProgress.setCurrentOperationName(ResourceManager.getInstance().getResString("MANUAL_ACTIVATE_OPERATION"));
        }
        if (null != oAsnDCRollBackDeviceRsp.oSWDLStatus) {
            String oldSWDLStatus = oResourceProgress.getSWDLStatus();
            String newSWDLStatus = TaskCommUtil.getSWDLStatusRes(oAsnDCRollBackDeviceRsp.oSWDLStatus.value);
            if (!newSWDLStatus.equals("--") && oldSWDLStatus.equals("--")) {
                oResourceProgress.setSWDLStatus(TaskCommUtil.getSWDLStatusRes(oAsnDCRollBackDeviceRsp.oSWDLStatus.value));
                oResourceProgress.setIntSWDLStatus(oAsnDCRollBackDeviceRsp.oSWDLStatus.value);
            } else if (!(oldSWDLStatus.equals(newSWDLStatus) || oldSWDLStatus.equals("--") || newSWDLStatus.equals("--"))) {
                oResourceProgress.setSWDLStatus(TaskCommUtil.getSWDLStatusRes(oAsnDCRollBackDeviceRsp.oSWDLStatus.value));
                oResourceProgress.setIntSWDLStatus(oAsnDCRollBackDeviceRsp.oSWDLStatus.value);
            }
        }
        AsnStatusEnum iStatus = oAsnDCRollBackDeviceRsp.oStatus;
        AsnTaskResultEnum enResult = oAsnDCRollBackDeviceRsp.enResult;
        oResourceProgress.setState(iStatus.value);
        oResourceProgress.setResult(enResult.value);
        if (iStatus.value == 1) {
            oResourceProgress.setProgress(oAsnDCRollBackDeviceRsp.iResourceProgress.hashCode());
        } else {
            String m_strResult = null;
            if (null != oAsnDCRollBackDeviceRsp.oErrorNo.strResult) {
                m_strResult = new String(oAsnDCRollBackDeviceRsp.oErrorNo.strResult);
            }
            oResourceProgress.setErrorInfo(oAsnDCRollBackDeviceRsp.oErrorNo.iErrorNo.intValue(), m_strResult);
        }
        DCDebugTracer.trace("DC::TaskAsynCommController::updateRollbackProgressNotification ::iProgress = " + oAsnDCRollBackDeviceRsp.iResourceProgress.intValue());
        if (null != oAsnDCRollBackDeviceRsp.oSWDLStatus) {
            oResource.setSWDLStatus(oAsnDCRollBackDeviceRsp.oSWDLStatus.value);
            DCDebugTracer.trace("DC::TaskAsynCommController::updateRollbackProgressNotification ::oSWDLStatus = " + oAsnDCRollBackDeviceRsp.oSWDLStatus.value);
        }
        if (2 != oTask.getTaskViewType() && 4 != oTask.getTaskViewType()) {
            TaskAsynCommControllerHelper.sendNotificationToDeviceModel(oResource);
        }
        oTaskEvent = new TaskEvent(oResource, TaskEventID.RESOURCE_PROGRESS_NOTIFICATION);
        TaskInfoNotifier.getInstance().notifyTaskEvent(oTaskEvent);
        if (iStatus.value == 3) {
            oTaskEvent = new TaskEvent(oTask, TaskEventID.TASK_UPDATE_TASK_COUNT);
            TaskInfoNotifier.getInstance().notifyTaskEvent(oTaskEvent);
        }
    }

    private static void updateCheckTableHeader(ICheckReportTable oCheckReportTable, AsnCheckReportHeaderInfo oAsnCheckReportHeaderInfo) throws InvalidNumOfColException {
        int iRowSpan = 0;
        int iNoCol = 0;
        AsnCheckReportHeaderList oAsnCheckReportHeaderList = oAsnCheckReportHeaderInfo.oHeaderList;
        List oHeaderElementList = null;
        oCheckReportTable.setTableType(oAsnCheckReportHeaderInfo.enCompareType.value);
        switch (oAsnCheckReportHeaderInfo.enCompareType.value) {
            case 0: 
            case 2: {
                iNoCol = oAsnCheckReportHeaderList.size();
                iRowSpan = 1;
                break;
            }
            case 1: {
                iNoCol = TaskAsynCommControllerUtil.getCheckTableColCount(oAsnCheckReportHeaderList);
                iRowSpan = 2;
                break;
            }
        }
        oHeaderElementList = TaskAsynCommControllerUtil.getKeyAndKeyValueTypeHeaderElementList(iRowSpan, oAsnCheckReportHeaderList);
        CheckReportHeader reportTableHeader = new CheckReportHeader(iRowSpan, iNoCol);
        reportTableHeader.setHeaderElementList(oHeaderElementList);
        oCheckReportTable.setTableHeader(reportTableHeader);
    }

    private static List getKeyAndKeyValueTypeHeaderElementList(int iRowSpan, AsnCheckReportHeaderList asnCheckReportHeaderList) {
        ArrayList<ICheckReportHeaderElement> oHeaderElementList = new ArrayList<ICheckReportHeaderElement>(8);
        int iSize = asnCheckReportHeaderList.size();
        AsnCheckReportHeader oAsnCheckReportHeaderElement = null;
        ICheckReportHeaderElement oCheckReportHeaderElement = null;
        String strHeaderName = null;
        for (int iHeaderElementIndex = 0; iHeaderElementIndex < iSize; ++iHeaderElementIndex) {
            oAsnCheckReportHeaderElement = (AsnCheckReportHeader)asnCheckReportHeaderList.get(iHeaderElementIndex);
            strHeaderName = ResourceManager.getInstance().getResString(new String(oAsnCheckReportHeaderElement.strColumnNameKey));
            oCheckReportHeaderElement = TaskAsynCommControllerUtil.getHeaderElement(iRowSpan, strHeaderName, oAsnCheckReportHeaderElement.bIsSplited);
            if (null != oCheckReportHeaderElement) {
                oCheckReportHeaderElement.setValue(ResourceManager.getInstance().getResString(new String(oAsnCheckReportHeaderElement.strColumnNameKey)));
                oCheckReportHeaderElement.setColumnNameKey(ResourceManager.getInstance().getResString(new String(oAsnCheckReportHeaderElement.strColumnNameKey)));
            }
            oHeaderElementList.add(oCheckReportHeaderElement);
        }
        return oHeaderElementList;
    }

    private static ICheckReportHeaderElement getHeaderElement(int iRowSpan, String strHeaderName, boolean bIsSplitted) {
        CheckReportHeaderElement oCheckReportHeaderElement = new CheckReportHeaderElement();
        oCheckReportHeaderElement.setCellRowSpanCount(iRowSpan);
        oCheckReportHeaderElement.setValue(strHeaderName);
        if (bIsSplitted) {
            List oSubHeaderElementList = TaskAsynCommControllerUtil.getSubHeaderElementList();
            oCheckReportHeaderElement.setCellColumnSpanCount(oSubHeaderElementList.size());
            oCheckReportHeaderElement.setSubHeaders(oSubHeaderElementList);
            oCheckReportHeaderElement.setCellRowSpanCount(1);
        }
        return oCheckReportHeaderElement;
    }

    private static List getSubHeaderElementList() {
        ArrayList<ICheckReportHeaderElement> oSubHeaderElementList = new ArrayList<ICheckReportHeaderElement>(2);
        oSubHeaderElementList.add(TaskAsynCommControllerUtil.getHeaderElement(1, ResourceManager.getInstance().getResString("CHECk_REPORT_PRECHECK_SUBHEADER"), false));
        oSubHeaderElementList.add(TaskAsynCommControllerUtil.getHeaderElement(1, ResourceManager.getInstance().getResString("CHECk_REPORT_POSTCHECK_SUBHEADER"), false));
        return oSubHeaderElementList;
    }

    private static int getCheckTableColCount(AsnCheckReportHeaderList asnCheckReportHeaderList) {
        int iSize = asnCheckReportHeaderList.size();
        int iColCount = 0;
        AsnCheckReportHeader oAsnCheckReportHeader = null;
        for (int iHeaderElementIndex = 0; iHeaderElementIndex < iSize; ++iHeaderElementIndex) {
            oAsnCheckReportHeader = (AsnCheckReportHeader)asnCheckReportHeaderList.get(iHeaderElementIndex);
            if (oAsnCheckReportHeader.bIsSplited) {
                ++iColCount;
            }
            ++iColCount;
        }
        return iColCount;
    }
}

