/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.controller;

import com.huawei.dc.common.DCErrorCode;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCCheckActiveGroupInfoReq;
import com.huawei.dc.common.asndatacenter.AsnDCGetBDResetInfoReq;
import com.huawei.dc.common.asndatacenter.AsnDCGetSWDLStatusReq;
import com.huawei.dc.common.asndatacenter.AsnDCMainBoardNumReq;
import com.huawei.dc.common.asndatacenter.AsnDCOpertionRsp;
import com.huawei.dc.common.asndatacenter.AsnDCSetOSPFStatusReq;
import com.huawei.dc.common.asndatacenter.AsnDCSupportISSUReq;
import com.huawei.dc.common.asndatacenter.AsnDCSyncReq;
import com.huawei.dc.common.asndatacenter.AsnDCSyncRsp;
import com.huawei.dc.common.asndatacenter.AsnTaskDetailsResultInfoReq;
import com.huawei.dc.common.asndatacenter.AsnTaskResultReq;
import com.huawei.dc.common.asndatacenter.AsnToleranceSearchReq;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.controller.TaskAsynCommController;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.TaskDataModel;
import com.swimap.iview.util.SyncCommand;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Cursor;
import java.math.BigInteger;
import java.util.List;
import net.commustru.fstru.FStruct;

public final class TaskAsynCommControllerProxy {
    public static void queryBoardsResetInformation(final AsnDCGetBDResetInfoReq oGetBDResetInfoReq, String strTaskName, List<Resource> unSupportQueryDevList, final AsnDCOpertionRsp oAsnDCOperationRsp) throws DCException {
        int iErrorCode;
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int errorCode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(44057), (FStruct)oGetBDResetInfoReq, (FStruct)oAsnDCOperationRsp);
                return errorCode;
            }
        };
        DCFrameWorkUtil.setCursor(Cursor.getPredefinedCursor(3));
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (null != syncCommand.getResult() && 0 != (iErrorCode = ((Integer)syncCommand.getResult()).intValue())) {
            throw new DCException(iErrorCode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
        if (0 != oAsnDCOperationRsp.oErrorInfo.iErrorNo.intValue()) {
            throw new DCException(oAsnDCOperationRsp.oErrorInfo.iErrorNo.intValue(), ResourceManager.getInstance().getResString("CANCEL_REQUEST_FAILED"));
        }
    }

    public static void checkDevicesIsSupportDelayReboot(int iReqId, int[] oDeviceIds) throws DCException {
        int returnCode;
        final AsnDCSyncReq oReq = new AsnDCSyncReq();
        final AsnDCSyncRsp oRsp = new AsnDCSyncRsp();
        oReq.oReqID = BigInteger.valueOf(iReqId);
        for (int i = 0; i < oDeviceIds.length; ++i) {
            oReq.oDevIDLst.add((Object)BigInteger.valueOf(oDeviceIds[i]));
        }
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int errorcode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43988), (FStruct)oReq, (FStruct)oRsp);
                return errorcode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (syncCommand.getResult() != null && (returnCode = ((Integer)syncCommand.getResult()).intValue()) != 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SEND_FAIL"), ResourceManager.getInstance().getResString("ERROR"), 0);
            throw new DCException(returnCode, ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(returnCode)));
        }
        if (0 != oRsp.oErrorInfo.iErrorNo.intValue()) {
            int errorCode = oRsp.oErrorInfo.iErrorNo.intValue();
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), errorCode, ResourceManager.getInstance().getResString("ERROR"), 0);
            throw new DCException(errorCode, ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(errorCode)));
        }
    }

    public static DCErrorCode checkDevicesIsSupportISSU(final AsnDCSupportISSUReq oAsnCheckISSUReq) {
        int returnCode;
        final AsnDCSyncRsp oRsp = new AsnDCSyncRsp();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int errorcode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(44085), (FStruct)oAsnCheckISSUReq, (FStruct)oRsp);
                return errorcode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        DCErrorCode oErrInfo = new DCErrorCode(0);
        if (syncCommand.getResult() != null && 0 != (returnCode = ((Integer)syncCommand.getResult()).intValue())) {
            oErrInfo.setErrorCode(returnCode);
            oErrInfo.setErrorMsg(ResourceManager.getInstance().getResString("SEND_FAIL"));
            return oErrInfo;
        }
        if (0 != oRsp.oErrorInfo.iErrorNo.intValue()) {
            int iErrorCode = oRsp.oErrorInfo.iErrorNo.intValue();
            oErrInfo.setErrorCode(iErrorCode);
            oErrInfo.setErrorMsg(ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode)));
            oErrInfo.setErrType(oRsp.oErrorInfo.oResultType.value);
        }
        return oErrInfo;
    }

    public static void getTaskLevelDevOprResultDetails(int iTaskId, THashSet<Resource> oResourceLst) {
        ITask oTask = TaskDataModel.getInstance().getTask(iTaskId);
        if (null == oTask) {
            return;
        }
        final AsnTaskResultReq oAsnTaskResultReq = new AsnTaskResultReq();
        oAsnTaskResultReq.iTaskID = BigInteger.valueOf(iTaskId);
        final AsnDCOpertionRsp oAsnDCOperationRsp = new AsnDCOpertionRsp();
        SyncCommand oSyncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int iErrorCode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(44001), (FStruct)oAsnTaskResultReq, (FStruct)oAsnDCOperationRsp);
                return iErrorCode;
            }
        };
        oSyncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (null == oAsnDCOperationRsp.oErrorInfo.iErrorNo) {
            return;
        }
        int iErroCode = oAsnDCOperationRsp.oErrorInfo.iErrorNo.intValue();
        if (0 != iErroCode) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErroCode, ResourceManager.getInstance().getResString("ERROR"), 0);
        }
    }

    public static void getDeviceOperationLogs(int iTaskID, int iDevID, int iStackID) {
        long startTime = System.currentTimeMillis();
        DCDebugTracer.trace("[performance] getDeviceOperationLogs start : " + startTime);
        DCDebugTracer.trace("[performance] iTaskId " + iTaskID);
        DCDebugTracer.trace("[performance] iDevID " + iDevID);
        DCDebugTracer.trace("[performance] iStackID " + iStackID);
        final AsnTaskDetailsResultInfoReq oDevLogReq = new AsnTaskDetailsResultInfoReq();
        final AsnDCOpertionRsp oAsnDCOperationRsp = new AsnDCOpertionRsp();
        oDevLogReq.iTaskId = BigInteger.valueOf(iTaskID);
        oDevLogReq.iDevId = BigInteger.valueOf(iDevID);
        if (-1 != iStackID) {
            oDevLogReq.iStackId = BigInteger.valueOf(iStackID);
        }
        SyncCommand oSyncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int iErrorCode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(44002), (FStruct)oDevLogReq, (FStruct)oAsnDCOperationRsp);
                return iErrorCode;
            }
        };
        oSyncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        int iErroCode = oAsnDCOperationRsp.oErrorInfo.iErrorNo.intValue();
        if (0 != iErroCode) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErroCode, ResourceManager.getInstance().getResString("ERROR"), 0);
        }
        long endTime = System.currentTimeMillis();
        DCDebugTracer.trace("[performance] getDeviceOperationLogs end : " + endTime + " Cost : " + (endTime - startTime));
    }

    public static int checkActivationGroupInfo(AsnDCCheckActiveGroupInfoReq asnCheckActiveGoupInfoReq, TaskAsynCommController reference) {
        DCDebugTracer.trace("method checkActivationGroupInfo start ");
        BaseCommManager commManager = DCFrameWorkUtil.getCommManager();
        int errorcode = commManager.sendAsyncMsg(BaseCommManager.getMSGHead(43965), (FStruct)asnCheckActiveGoupInfoReq, reference);
        DCDebugTracer.trace("method checkActivationGroupInfo end.. errorcode : " + errorcode);
        return errorcode;
    }

    public static void queryOperation(final AsnToleranceSearchReq oAsnIsolationSearchReq) throws DCException {
        int iErrorCode = 0;
        final AsnDCSyncRsp oAsnRsp = new AsnDCSyncRsp();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int iErrorCode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(44047), (FStruct)oAsnIsolationSearchReq, (FStruct)oAsnRsp);
                return iErrorCode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (null != syncCommand.getResult()) {
            iErrorCode = (Integer)syncCommand.getResult();
        }
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
        iErrorCode = oAsnRsp.oErrorInfo.iErrorNo.intValue();
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(oAsnRsp.oErrorInfo.iErrorNo));
        }
    }

    public static void refreshSWDLStatus(int iReqId, int iTaskID, List devIDs) throws DCException {
        final AsnDCGetSWDLStatusReq asnDCGetSWDLStatusReq = new AsnDCGetSWDLStatusReq();
        final AsnDCSyncRsp oRsp = new AsnDCSyncRsp();
        asnDCGetSWDLStatusReq.oReqID = BigInteger.valueOf(iReqId);
        asnDCGetSWDLStatusReq.iTaskID = new BigInteger("" + iTaskID);
        for (int i = 0; i < devIDs.size(); ++i) {
            asnDCGetSWDLStatusReq.oDevIdLst.add((Object)new BigInteger("" + devIDs.get(i)));
        }
        int iErrorCode = 0;
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int iErrorCode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43981), (FStruct)asnDCGetSWDLStatusReq, (FStruct)oRsp);
                return iErrorCode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (null != syncCommand.getResult()) {
            iErrorCode = (Integer)syncCommand.getResult();
        }
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
        iErrorCode = oRsp.oErrorInfo.iErrorNo.intValue();
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(oRsp.oErrorInfo.iErrorNo));
        }
    }

    public static void setOSPFStatus(int iReqId, boolean openCmd, List<Integer> devIDLst) throws DCException {
        final AsnDCSetOSPFStatusReq oAsnDCSetOSPFStatusReq = new AsnDCSetOSPFStatusReq();
        final AsnDCSyncRsp oAsnRsp = new AsnDCSyncRsp();
        oAsnDCSetOSPFStatusReq.oReqID = BigInteger.valueOf(iReqId);
        oAsnDCSetOSPFStatusReq.bOpenOSPF = openCmd;
        for (int i = 0; i < devIDLst.size(); ++i) {
            oAsnDCSetOSPFStatusReq.oDevIdLst.add((Object)new BigInteger(devIDLst.get(i).toString()));
        }
        int iErrorCode = 0;
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int iErrorCode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(44005), (FStruct)oAsnDCSetOSPFStatusReq, (FStruct)oAsnRsp);
                return iErrorCode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (null != syncCommand.getResult()) {
            iErrorCode = (Integer)syncCommand.getResult();
        }
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
        iErrorCode = oAsnRsp.oErrorInfo.iErrorNo.intValue();
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(oAsnRsp.oErrorInfo.iErrorNo));
        }
    }

    public static void getTaskList() {
        DCDebugTracer.trace("method TaskAsynCommController#getTaskList start");
        final AsnDCOpertionRsp oAsnDCOperationRsp = new AsnDCOpertionRsp();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int errorCode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43871), null, (FStruct)oAsnDCOperationRsp);
                return errorCode;
            }
        };
        DCFrameWorkUtil.setCursor(Cursor.getPredefinedCursor(3));
        DCDebugTracer.trace("Send request to server for DC_LIST_TASK.");
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        DCDebugTracer.trace("Get response from server for DC_LIST_TASK.");
        int iErroCode = oAsnDCOperationRsp.oErrorInfo.iErrorNo.intValue();
        if (0 != iErroCode) {
            DCFrameWorkUtil.getToolBarButton("refreshTree").setEnabled(true);
            int iMsgType = 0;
            String sTitle = ResourceManager.getInstance().getResString("ERROR");
            if (iErroCode == 989859104) {
                iMsgType = 1;
                sTitle = ResourceManager.getInstance().getResString("INFORMATION");
            }
            try {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getTaskMgmtOperationSelecPanel(), iErroCode, sTitle, iMsgType);
            }
            catch (Exception e) {
                DCDebugTracer.trace(e);
                DCDebugTracer.trace("Method TaskAsynCommController#getTaskList end");
            }
        }
        DCFrameWorkUtil.setCursor(Cursor.getDefaultCursor());
        DCDebugTracer.trace("Method TaskAsynCommController#getTaskList end");
    }

    public static void queryMainBoardNum(final AsnDCMainBoardNumReq oReq) throws DCException {
        int iErrorCode = 0;
        final AsnDCSyncRsp oRsp = new AsnDCSyncRsp();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int iErrorCode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(44084), (FStruct)oReq, (FStruct)oRsp);
                return iErrorCode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (null != syncCommand.getResult()) {
            iErrorCode = (Integer)syncCommand.getResult();
        }
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
        iErrorCode = oRsp.oErrorInfo.iErrorNo.intValue();
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode)));
        }
    }
}

