/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.controller;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnCreateTaskReq;
import com.huawei.dc.common.asndatacenter.AsnCreateTaskRsp;
import com.huawei.dc.common.asndatacenter.AsnDCFileDeleteOnDevRsp;
import com.huawei.dc.common.asndatacenter.AsnFreeIsolationDeviceNotify;
import com.huawei.dc.common.asndatacenter.AsnT2000AutoUpgradeTaskRsp;
import com.huawei.dc.common.asndatacenter.AsnTaskInfo;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.TaskInfoUtil;
import com.huawei.dc.common.util.TaskInfoUtil2;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.deviceoperation.controller.DeviceOperationProgressController;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import com.huawei.dc.taskmgmt.controller.TaskEvent;
import com.huawei.dc.taskmgmt.controller.TaskEventID;
import com.huawei.dc.taskmgmt.controller.TaskInfoNotifier;
import com.huawei.dc.taskmgmt.controller.TaskSyncCommController;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import com.huawei.dc.taskmgmt.util.AsnTaskInfoUtil;
import com.swimap.iview.communicate.MSGPacketExt;
import java.awt.Component;
import java.math.BigInteger;
import java.util.ArrayList;
import net.commustru.fstru.FStruct;

public final class TaskAsynCommControllerHelperExt {
    public static void handleBoxesAutoUpgrade(MSGPacketExt oPacketExt) {
        AsnT2000AutoUpgradeTaskRsp asnT2000AutoUpgradeTaskRsp = new AsnT2000AutoUpgradeTaskRsp();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)asnT2000AutoUpgradeTaskRsp, oPacketExt.getData());
        if (0 != iErrorCode) {
            return;
        }
        iErrorCode = asnT2000AutoUpgradeTaskRsp.iErrorNo.intValue();
        if (0 != iErrorCode) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode)), ResourceManager.getInstance().getResString("ERROR_AUTO_TASK"), 0);
            return;
        }
        boolean bSameVersion = asnT2000AutoUpgradeTaskRsp.bIsVersionSame;
        AsnTaskInfo asnTaskInfo = asnT2000AutoUpgradeTaskRsp.oAsnTaskInfo;
        ITask oTaskInfo = AsnTaskInfoUtil.populateTaskFromAsnTask(asnTaskInfo, asnT2000AutoUpgradeTaskRsp.iDowngradeType.intValue());
        if (!oTaskInfo.isbAutoTask()) {
            DCDebugTracer.trace("dc setbAutoTask true");
            asnTaskInfo.oTaskCommonInfo.bIsAutoTask = true;
            oTaskInfo.setbAutoTask(true);
        }
        if (null == oTaskInfo.getSupportedOperation()) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("MSG_NOT_SUPPORT_BOX_AUTO_UPGRADE"), ResourceManager.getInstance().getResString("ERROR_AUTO_TASK"), 0);
        }
        ArrayList<Integer> oShouldSelectOprIDLst = new ArrayList<Integer>();
        oShouldSelectOprIDLst.add(6);
        oShouldSelectOprIDLst.add(18);
        oShouldSelectOprIDLst.add(30);
        oShouldSelectOprIDLst.add(8);
        oShouldSelectOprIDLst.add(19);
        oShouldSelectOprIDLst.add(3);
        TaskCommUtil.setTaskOperationSelectStatus(oTaskInfo, oShouldSelectOprIDLst, true);
        ArrayList<Integer> oFilterCheckIDLst = new ArrayList<Integer>(2);
        oFilterCheckIDLst.add(4);
        oFilterCheckIDLst.add(16);
        oFilterCheckIDLst.add(28);
        if (!bSameVersion) {
            int confirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("MSG_STANDALONE_AUTO_UPGRADE"), ResourceManager.getInstance().getResString("CONFIRM"), 0);
            if (confirm != 0) {
                return;
            }
        } else {
            oFilterCheckIDLst.add(6);
            oFilterCheckIDLst.add(18);
            oFilterCheckIDLst.add(30);
            oFilterCheckIDLst.add(8);
            oFilterCheckIDLst.add(19);
        }
        TaskCommUtil.setTaskOperationSelectStatus(oTaskInfo, oFilterCheckIDLst, false);
        TaskInfoUtil2.refereOperatinLst(asnTaskInfo, oTaskInfo);
        TaskInfoUtil.createTemporaryDevTypeByActiGroup(oTaskInfo);
        AsnCreateTaskReq asnCreateTaskReq = new AsnCreateTaskReq();
        AsnCreateTaskRsp oAsnCreateTaskRsp = new AsnCreateTaskRsp();
        asnCreateTaskReq.oTaskInfo = asnTaskInfo;
        try {
            TaskSyncCommController.getInstance().sendCreateTaskReq(oTaskInfo, asnCreateTaskReq, oAsnCreateTaskRsp, 43872);
        }
        catch (DCException e) {
            DCDebugTracer.traceError(e.getMessage());
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getMessage(), ResourceManager.getInstance().getResString("ERROR_AUTO_TASK"), 0);
        }
    }

    public static void handleFreeIsolationDeviceTaskNotify(MSGPacketExt oPacketExt) {
        AsnFreeIsolationDeviceNotify oAsnFreeIsolationDeviceNotify = new AsnFreeIsolationDeviceNotify();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnFreeIsolationDeviceNotify, oPacketExt.getData());
        DCDebugTracer.trace("handleFreeIsolationDeviceTaskNotify iErrorCode:" + iErrorCode);
        if (0 == iErrorCode) {
            DCDebugTracer.trace("handleFreeIsolationDeviceTaskNotify bIsFinal:" + oAsnFreeIsolationDeviceNotify.bIsFinal);
            if (oAsnFreeIsolationDeviceNotify.bIsFinal) {
                iErrorCode = oAsnFreeIsolationDeviceNotify.oErrorInfo.iErrorNo.intValue();
                if (0 != iErrorCode) {
                    DCDebugTracer.trace("handleFreeIsolationDeviceTaskNotify iTaskID:" + oAsnFreeIsolationDeviceNotify.iTaskID + " handleFreeIsolationDeviceTaskNotify iDevID:" + oAsnFreeIsolationDeviceNotify.iDevID);
                    DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorCode);
                } else {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("OPERTION_SUCCESS"));
                }
            }
        }
    }

    public static void handleDeleteFileResponse(MSGPacketExt oPacketExt) {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            DCDebugTracer.trace("DeleteDeviceFiles - Method handleDeleteFileResponse sleep error");
        }
        DCDebugTracer.trace("DeleteDeviceFiles - Method handleDeleteFileResponse start");
        AsnDCFileDeleteOnDevRsp oAsnDCCheckDevMemoryRsp = new AsnDCFileDeleteOnDevRsp();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnDCCheckDevMemoryRsp, oPacketExt.getData());
        if (0 != iErrorCode) {
            DCDebugTracer.trace("DeleteDeviceFiles - ASN Decode failed on client side");
            oAsnDCCheckDevMemoryRsp = null;
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorCode, DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
        }
        DCDebugTracer.trace("DeleteDeviceFiles - Notify to task event start");
        TaskEvent oTaskEvent = new TaskEvent(oAsnDCCheckDevMemoryRsp, TaskEventID.DC_DELETE_FILES_ON_DEVICE);
        TaskInfoNotifier.getInstance().notifyTaskEvent(oTaskEvent);
        DCDebugTracer.trace("DeleteDeviceFiles - Notify to task event end");
        DCDebugTracer.trace("DeleteDeviceFiles - Method handleDeleteFileResponse start");
    }

    public static void sendNotificationToDeviceModel(Resource oResource, int iTaskID) {
        ResourceProgressInfo oProgressInfo = oResource.getProgressInfo();
        StringBuffer strFailureReason = new StringBuffer("");
        if (null != oProgressInfo.getErrorInfo()) {
            strFailureReason.append(oProgressInfo.getErrorInfo());
        }
        if (null != oProgressInfo.getFailureReason()) {
            strFailureReason.append(oProgressInfo.getFailureReason());
        }
        int iProgress = oProgressInfo.getProgress();
        if (1 != oProgressInfo.getState()) {
            iProgress = -1;
        }
        int iDeviceId = oResource.getDeviceID();
        DeviceInfo oDevice = DCFrameWorkUtil.getDeviceInfoManager().getDevice(iDeviceId);
        if (null != oDevice) {
            oDevice.getDeviceOperationStatus().setIsProgress(true);
            oDevice.getDeviceOperationStatus().setTaskID(iTaskID);
        }
        int iResult = oResource.getProgressInfo().getResult();
        String sFailureReason = TaskAsynCommControllerHelperExt.getFailureReasonFromResoureFile(oProgressInfo.getErrorNo(), iResult, strFailureReason.toString());
        DeviceOperationProgressController.getInstance().updateDeviceProgress(iDeviceId, iProgress, oProgressInfo.getCurrentOperationName(), oProgressInfo.getErrorNo(), sFailureReason, iResult);
    }

    private static String getFailureReasonFromResoureFile(int iFailureReason, int iOperationResultStatus, String strFailureReason) {
        String sFailureReason = "";
        if (0 == iOperationResultStatus) {
            sFailureReason = ResourceManager.getInstance().getResString("OPERTION_SUCCESS");
            if (iFailureReason > 0) {
                sFailureReason = sFailureReason + strFailureReason;
            }
        } else if (1 == iOperationResultStatus) {
            if (999293081 != iFailureReason) {
                sFailureReason = ResourceManager.getInstance().getResString("OPERTION_FAILED");
                sFailureReason = sFailureReason + " " + strFailureReason;
            } else {
                sFailureReason = strFailureReason;
            }
        } else {
            sFailureReason = strFailureReason;
        }
        return sFailureReason;
    }
}

