/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.controller;

import com.huawei.dc.common.OperationIdStore;
import com.huawei.dc.common.asndatacenter.AsnCancelTaskRsp;
import com.huawei.dc.common.asndatacenter.AsnContinueTaskRsp;
import com.huawei.dc.common.asndatacenter.AsnCreateMxuTaskRsp;
import com.huawei.dc.common.asndatacenter.AsnCreateTaskReq;
import com.huawei.dc.common.asndatacenter.AsnDCActivateGroupMismatchNotify;
import com.huawei.dc.common.asndatacenter.AsnDCCheckDevMemoryRsp;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceErrorInfo;
import com.huawei.dc.common.asndatacenter.AsnDCHighModeConfigNotify;
import com.huawei.dc.common.asndatacenter.AsnDCSlaveDevInfoRsp;
import com.huawei.dc.common.asndatacenter.AsnDelDevInTaskNfy;
import com.huawei.dc.common.asndatacenter.AsnDeleteTaskReq;
import com.huawei.dc.common.asndatacenter.AsnDeleteTaskRsp;
import com.huawei.dc.common.asndatacenter.AsnDevSetInfo;
import com.huawei.dc.common.asndatacenter.AsnDevUpgrModeInfo;
import com.huawei.dc.common.asndatacenter.AsnDevUpgrModeInfoLst;
import com.huawei.dc.common.asndatacenter.AsnGetDevUpgradeModeRsp;
import com.huawei.dc.common.asndatacenter.AsnListTask;
import com.huawei.dc.common.asndatacenter.AsnListTaskRsp;
import com.huawei.dc.common.asndatacenter.AsnPauseTaskRsp;
import com.huawei.dc.common.asndatacenter.AsnResourceProgressInfo;
import com.huawei.dc.common.asndatacenter.AsnSWCompatibilityCheckResp;
import com.huawei.dc.common.asndatacenter.AsnT2000UpgradeFeasInfoRsp;
import com.huawei.dc.common.asndatacenter.AsnTaskDevOpInfo;
import com.huawei.dc.common.asndatacenter.AsnTaskDevOpInfoLst;
import com.huawei.dc.common.asndatacenter.AsnTaskDevResult;
import com.huawei.dc.common.asndatacenter.AsnTaskDevResultLst;
import com.huawei.dc.common.asndatacenter.AsnTaskInfo;
import com.huawei.dc.common.asndatacenter.AsnTaskProgressNtfn;
import com.huawei.dc.common.asndatacenter.AsnTaskProgressNtfnLst;
import com.huawei.dc.common.asndatacenter.AsnTaskResource;
import com.huawei.dc.common.asndatacenter.AsnTaskResultRsp;
import com.huawei.dc.common.asndatacenter.AsnTaskRqstOpResultInfoLst;
import com.huawei.dc.common.components.dialog.SynProgressDlg;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.CloneUtil;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceview.common.DeviceTreeTableDataSelectionEventObject;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.controller.LoadSoftwareCheckManager;
import com.huawei.dc.taskmgmt.controller.TaskAsynCommController;
import com.huawei.dc.taskmgmt.controller.TaskAsynCommControllerHelperExt;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import com.huawei.dc.taskmgmt.controller.TaskEvent;
import com.huawei.dc.taskmgmt.controller.TaskEventID;
import com.huawei.dc.taskmgmt.controller.TaskInfoNotifier;
import com.huawei.dc.taskmgmt.isolation.IsolationCommonOperation;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.ITaskDataModel;
import com.huawei.dc.taskmgmt.model.ITaskSubOperation;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.ResourceOpResultInfo;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import com.huawei.dc.taskmgmt.model.TaskDataModel;
import com.huawei.dc.taskmgmt.model.TaskOpResultInfo;
import com.huawei.dc.taskmgmt.model.TaskProgressInfo;
import com.huawei.dc.taskmgmt.model.UpgradeFailInfo;
import com.huawei.dc.taskmgmt.util.AsnTaskInfoUtil;
import com.huawei.dc.taskmgmt.view.common.TaskOperationResultDialog;
import com.huawei.dc.taskmgmt.view.tasktable.TaskTablePanel;
import com.huawei.dc.taskmgmt.view.upgraderesult.UpgradeFailDialog;
import com.swimap.iview.communicate.MSGListener;
import com.swimap.iview.communicate.MSGPacketExt;
import com.swimap.iview.framework.modulemanagement.InternalLocalMsg;
import gnu.trove.THashSet;
import java.awt.Component;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingUtilities;
import net.commustru.fstru.FStruct;

public final class TaskAsynCommControllerHelper {
    private static boolean bisContinueNE = false;

    public static void handleBoxesAutoUpgrade(MSGPacketExt oPacketExt) {
        TaskAsynCommControllerHelperExt.handleBoxesAutoUpgrade(oPacketExt);
    }

    public static void updateResourceProgressNotification(MSGPacketExt oPacketExt) {
        int taskState = 0;
        DCDebugTracer.trace("TaskAsynCommControllerHelper->updateResourceProgressNotification: begin");
        AsnTaskProgressNtfnLst oAsnTaskProgressNtfnLst = new AsnTaskProgressNtfnLst();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnTaskProgressNtfnLst, oPacketExt.getData());
        DCDebugTracer.traceDetail("TaskAsynCommControllerHelper->updateResourceProgressNotification decodeAsn1Data successful->: begin");
        if (0 != iErrorCode) {
            DCDebugTracer.trace("DC::task progress notify decode error ");
            return;
        }
        boolean isUpdateTaskCount = false;
        int iTaskProgressNtfnSize = oAsnTaskProgressNtfnLst.size();
        HashMap<Integer, List<Resource>> oUpdateResInfoMap = new HashMap<Integer, List<Resource>>();
        for (int i = 0; i < iTaskProgressNtfnSize; ++i) {
            AsnTaskProgressNtfn oAsnTaskProgressNtfn = (AsnTaskProgressNtfn)oAsnTaskProgressNtfnLst.get(i);
            ITask oTask = TaskDataModel.getInstance().getTask(oAsnTaskProgressNtfn.iTaskId.intValue());
            if (null == oTask) {
                int iSize = oAsnTaskProgressNtfn.oAsnResourceProgressInfoLst.size();
                if (0 == iSize) {
                    DCDebugTracer.trace("DC::task progress notify oTask is null ");
                }
                DCDebugTracer.trace(TaskDataModel.getInstance().toString());
                TaskAsynCommControllerHelper.sendTaskNotificationToDeviceModel(oAsnTaskProgressNtfn);
                return;
            }
            TaskProgressInfo oTaskProgress = oTask.getTaskProgressInfo();
            oTaskProgress.setProgress(oAsnTaskProgressNtfn.iTaskProgress.intValue());
            DCDebugTracer.trace("TaskAsynCommControllerHelper->updateResourceProgressNotification ->setProgress: " + oAsnTaskProgressNtfn.iTaskProgress.intValue());
            if (null != oAsnTaskProgressNtfn.oTaskResult) {
                DCDebugTracer.trace("TaskAsynCommControllerHelper->updateResourceProgressNotification ->setResult->" + oAsnTaskProgressNtfn.oTaskResult.value);
                oTaskProgress.setResult(oAsnTaskProgressNtfn.oTaskResult.value);
            }
            int iLastTaskState = oTaskProgress.getState();
            taskState = oTaskProgress.getState();
            if (null != oAsnTaskProgressNtfn.oTaskStatus) {
                DCDebugTracer.trace("TaskAsynCommControllerHelper->updateResourceProgressNotification ->setState->" + TaskCommUtil.getStatusFromAsnStatus(oAsnTaskProgressNtfn.oTaskStatus));
                oTaskProgress.setState(TaskCommUtil.getStatusFromAsnStatus(oAsnTaskProgressNtfn.oTaskStatus));
            }
            taskState = TaskAsynCommControllerHelper.getTaskStateChange(taskState, oTaskProgress.getState());
            boolean bAutoTask = oAsnTaskProgressNtfn.bIsAutoTask;
            DCDebugTracer.trace("DC::task progress notify " + oTask.getTaskName() + "(" + oTask.getTaskId() + ") progress=" + oTaskProgress.getProgress() + " status=" + oTaskProgress.getState() + " result=" + oTaskProgress.getResult() + " bAutoTask=" + bAutoTask);
            if (0 == iLastTaskState && 0 != oTaskProgress.getState()) {
                isUpdateTaskCount = true;
            }
            if (3 == taskState) {
                isUpdateTaskCount = true;
            }
            if (iLastTaskState != 2 && oTaskProgress.getState() == 2) {
                isUpdateTaskCount = true;
            }
            if (bAutoTask && null != oAsnTaskProgressNtfn.oTaskResult && null != oAsnTaskProgressNtfn.oTaskStatus) {
                TaskAsynCommControllerHelper.sendEventForAutoUpgrade(oTask, oAsnTaskProgressNtfn.oTaskStatus.value, oAsnTaskProgressNtfn.oTaskResult.value);
            }
            TaskAsynCommControllerHelper.updateTaskTime(oAsnTaskProgressNtfn, oTask);
            if (null == oAsnTaskProgressNtfn.oAsnResourceProgressInfoLst) continue;
            TaskAsynCommControllerHelper.updateProgressInfo(oAsnTaskProgressNtfn, oTask, oTaskProgress, oUpdateResInfoMap);
        }
        if (isUpdateTaskCount) {
            TaskEvent oTaskEvent = new TaskEvent(oUpdateResInfoMap, TaskEventID.TASK_UPDATE_TASK_COUNT);
            TaskInfoNotifier.getInstance().notifyTaskEvent(oTaskEvent);
        }
        if (0 < oUpdateResInfoMap.size()) {
            TaskEvent oTaskEvent = new TaskEvent(oUpdateResInfoMap, TaskEventID.RESOURCE_PROGRESS_NOTIFICATION);
            TaskInfoNotifier.getInstance().notifyTaskEvent(oTaskEvent);
        }
    }

    private static int getTaskStateChange(int taskStateFormer, int taskStateNow) {
        if (taskStateFormer == taskStateNow) {
            return 0;
        }
        if (2 == taskStateNow) {
            return 2;
        }
        if (3 == taskStateNow) {
            return 3;
        }
        return 0;
    }

    private static void sendTaskNotificationToDeviceModel(AsnTaskProgressNtfn oAsnTaskProgressNtfn) {
        int iSize = oAsnTaskProgressNtfn.oAsnResourceProgressInfoLst.size();
        for (int i = 0; i < iSize; ++i) {
            Resource oResource;
            AsnResourceProgressInfo oAsnResProgress = (AsnResourceProgressInfo)oAsnTaskProgressNtfn.oAsnResourceProgressInfoLst.get(i);
            int iFrameID = -1;
            int iSlotID = -1;
            int iSubSlotId = -1;
            if (null != oAsnResProgress.oAsnTaskResource.iFrameId) {
                iFrameID = oAsnResProgress.oAsnTaskResource.iFrameId.intValue();
            }
            if (null != oAsnResProgress.oAsnTaskResource.iSlotId) {
                iSlotID = oAsnResProgress.oAsnTaskResource.iSlotId.intValue();
            }
            if (null != oAsnResProgress.oAsnTaskResource.iSubSlotId) {
                iSubSlotId = oAsnResProgress.oAsnTaskResource.iSubSlotId.intValue();
            }
            if (-1 != iFrameID || -1 != iSlotID || -1 != iSubSlotId || null == (oResource = TaskCommUtil.getResourceFromResourceProgressInfo(oAsnResProgress))) continue;
            TaskAsynCommControllerHelper.sendNotificationToDeviceModel(oResource);
        }
    }

    private static void sendNotificationToDeviceModel(Resource oResource, int iTaskID) {
        TaskAsynCommControllerHelperExt.sendNotificationToDeviceModel(oResource, iTaskID);
    }

    public static String getFailureReasonFromResoureFile(int iFailureReason, int iOperationResultStatus, String strFailureReason) {
        String sFailureReason = "";
        if (0 == iOperationResultStatus) {
            sFailureReason = ResourceManager.getInstance().getResString("OPERTION_SUCCESS");
            if (iFailureReason > 0) {
                sFailureReason = sFailureReason + strFailureReason;
            }
        } else if (1 == iOperationResultStatus) {
            if (999293081 != iFailureReason) {
                sFailureReason = ResourceManager.getInstance().getResString("OPERTION_FAILED");
                sFailureReason = sFailureReason + " " + strFailureReason;
            } else {
                sFailureReason = strFailureReason;
            }
        } else {
            sFailureReason = strFailureReason;
        }
        return sFailureReason;
    }

    public static void sendNotificationToDeviceModel(Resource oResource) {
        TaskAsynCommControllerHelper.sendNotificationToDeviceModel(oResource, -1);
    }

    private static void updateProgressInfo(AsnTaskProgressNtfn oAsnTaskProgressNtfn, ITask oTask, TaskProgressInfo oTaskProgress, HashMap<Integer, List<Resource>> oUpdateResInfoMap) {
        DeviceType oDevType = oTask.getSelectedDeviceType();
        int iSize = oAsnTaskProgressNtfn.oAsnResourceProgressInfoLst.size();
        for (int i = 0; i < iSize; ++i) {
            int iTaskId;
            AsnResourceProgressInfo oAsnResProgress = (AsnResourceProgressInfo)oAsnTaskProgressNtfn.oAsnResourceProgressInfoLst.get(i);
            Resource oResource = null;
            int iDevID = oAsnResProgress.oAsnTaskResource.iDeviceId.intValue();
            int iFrameID = -1;
            int iSlotID = -1;
            int iStackID = -1;
            if (null != oAsnResProgress.oAsnTaskResource.iFrameId) {
                iFrameID = oAsnResProgress.oAsnTaskResource.iFrameId.intValue();
            }
            if (null != oAsnResProgress.oAsnTaskResource.iSlotId) {
                iSlotID = oAsnResProgress.oAsnTaskResource.iSlotId.intValue();
                DCDebugTracer.trace("DC::TaskAsynCommController::updateResourceProgressNotification ::slotId from server = " + iSlotID);
            }
            if (null != oAsnResProgress.oAsnTaskResource.iStackId) {
                iStackID = oAsnResProgress.oAsnTaskResource.iStackId.intValue();
            }
            oResource = oDevType.getResource(iDevID, iFrameID, iSlotID, iStackID);
            if ((IsolationCommonOperation.isIsolationTask(oTask.getTaskTypeId()) || oTask.getTaskTypeId() == 3 || (oTask.getTaskTypeId() == 12 || oTask.getTaskTypeId() == 5) && oTask.getUpgradeLevel() == 2) && oResource == null) {
                oResource = oTask.getTemporaryDevType().getResource(iDevID, iFrameID, iSlotID, iStackID);
            }
            boolean isContinue = false;
            if (null == oResource) {
                oResource = new Resource();
                oResource.setDeviceID(iDevID);
                isContinue = true;
            }
            ResourceProgressInfo oResourceProgress = oResource.getProgressInfo();
            String strOperationID = new String(oAsnResProgress.strCurrentOperationId);
            if (!oResourceProgress.getCurrentOperationId().equals(strOperationID)) {
                oResourceProgress.setStartTime(oAsnResProgress.oOprStartTime);
                oResourceProgress.setEndTime(oAsnResProgress.oOprEndTime);
            } else {
                if (null != oAsnResProgress.oOprStartTime) {
                    oResourceProgress.setStartTime(oAsnResProgress.oOprStartTime);
                }
                oResourceProgress.setEndTime(oAsnResProgress.oOprEndTime);
            }
            oResourceProgress.setCurrentOperationId(strOperationID);
            oResourceProgress.setCurrentOperationName(TaskCommUtil.getDisplayNameForOperation(oDevType, strOperationID));
            TaskAsynCommControllerHelper.setSWDLStatus(oTask, oAsnResProgress, oResourceProgress);
            String strErrMsg = null;
            if ((oTask.getTaskTypeId() == 3 || oTask.getTaskTypeId() == 13 || oTask.getTaskTypeId() == 12) && 995098636 == oAsnResProgress.oAsnDCErrorCodeInfo.iErrorNo.intValue()) {
                oAsnResProgress.oAsnDCErrorCodeInfo.iErrorNo = BigInteger.valueOf(1074200608L);
            }
            if (null != oAsnResProgress.oAsnDCErrorCodeInfo && null != oAsnResProgress.oAsnDCErrorCodeInfo.strResult) {
                strErrMsg = new String(oAsnResProgress.oAsnDCErrorCodeInfo.strResult);
            }
            if (null != oAsnResProgress.oAsnDCErrorCodeInfo) {
                oResourceProgress.setErrorInfo(oAsnResProgress.oAsnDCErrorCodeInfo.iErrorNo.intValue(), strErrMsg);
                oResourceProgress.setErrorType(oAsnResProgress.oAsnDCErrorCodeInfo.oResultType.value);
            }
            if (null != oAsnResProgress.strFailureReason) {
                oResourceProgress.setFailureReason(new String(oAsnResProgress.strFailureReason));
            }
            oResourceProgress.setProgress(oAsnResProgress.iResourceProgress.intValue());
            if (null != oAsnResProgress.enResult) {
                oResourceProgress.setResult(oAsnResProgress.enResult.value);
            }
            if (null != oAsnResProgress.enStatus) {
                oResourceProgress.setState(TaskCommUtil.getStatusFromAsnStatus(oAsnResProgress.enStatus));
            }
            if (2 != oTask.getTaskViewType() && 4 != oTask.getTaskViewType() && iFrameID == -1 && iSlotID == -1 && iStackID == -1) {
                TaskAsynCommControllerHelper.sendNotificationToDeviceModel(oResource);
            }
            if (isContinue) continue;
            DCDebugTracer.trace("task->device progress notify " + oTask.getTaskName() + "(" + oTask.getTaskId() + ") device=" + oResource.getDeviceName() + "(" + oResource.getDeviceIP() + ") oper=" + strOperationID + " progress=" + oResourceProgress.getProgress() + " status=" + oResourceProgress.getState() + " result=" + oResourceProgress.getResult());
            TaskAsynCommControllerHelper.updateDeviceSubOprProgressInfo(oTask, strOperationID, oAsnResProgress, oResource);
            if (null != oAsnResProgress.enStatus && (3 == oAsnResProgress.enStatus.value || 2 == oAsnResProgress.enStatus.value || 1 == oAsnResProgress.enStatus.value)) {
                oResource.addOprResultInfo(strOperationID, (ResourceProgressInfo)CloneUtil.getClone(oResourceProgress));
            }
            TaskAsynCommControllerHelper.setActivateGrpInfo(oAsnTaskProgressNtfn, oTask, oTaskProgress);
            if (null != oAsnResProgress.iIsolationBoard) {
                oResource.setIsIsolationBoard(oAsnResProgress.iIsolationBoard.intValue());
                DCDebugTracer.trace("DC::TaskAsynCommController::updateResourceProgressNotification ::iIsolationBoard = " + oAsnResProgress.iIsolationBoard.intValue());
            }
            if (oUpdateResInfoMap.containsKey(iTaskId = oTask.getTaskId())) {
                oUpdateResInfoMap.get(iTaskId).add(oResource);
            } else {
                ArrayList<Resource> oResLst = new ArrayList<Resource>();
                oResLst.add(oResource);
                oUpdateResInfoMap.put(iTaskId, oResLst);
            }
            TaskAsynCommControllerHelper.handleFailedDevInTask(oTask, oDevType, strOperationID, oAsnResProgress, oResource);
        }
    }

    private static void setActivateGrpInfo(AsnTaskProgressNtfn oAsnTaskProgressNtfn, ITask oTask, TaskProgressInfo oTaskProgress) {
        if (4 == oTask.getTaskProgressInfo().getState()) {
            String strCurrOpr = new String(((AsnResourceProgressInfo)oAsnTaskProgressNtfn.oAsnResourceProgressInfoLst.get((int)0)).strCurrentOperationId);
            BigInteger oVal = ((AsnResourceProgressInfo)oAsnTaskProgressNtfn.oAsnResourceProgressInfoLst.get((int)0)).iCurrentGroupId;
            if ("ActivateSoftware".equals(strCurrOpr)) {
                if (null != oVal) {
                    oTaskProgress.setPausedActivateGrpID(((AsnResourceProgressInfo)oAsnTaskProgressNtfn.oAsnResourceProgressInfoLst.get((int)0)).iCurrentGroupId.intValue());
                } else {
                    oTaskProgress.setPausedActivateGrpID(-1);
                }
            } else {
                oTaskProgress.setPausedActivateGrpID(-1);
            }
        } else {
            oTaskProgress.setPausedActivateGrpID(-1);
        }
    }

    private static boolean isT2000PatchOpertationSucc(int errorCode, int iDevDomain) {
        boolean bResult = false;
        if (4 != iDevDomain) {
            return bResult;
        }
        int SUCCESS_LOAD_REFRESH_CODE = 1000346381;
        int SUCCESS_LOAD_CODE = 1000346383;
        int SUCCESS_ACTIVATE_CODE = 1000346384;
        int SUCCESS_ROLLINGBACK_CODE = 1000346385;
        int SUCCESS_SUBMIT_CODE = 1000346386;
        if (1000346381 == errorCode || 1000346383 == errorCode || 1000346384 == errorCode || 1000346385 == errorCode || 1000346386 == errorCode) {
            bResult = true;
        }
        return bResult;
    }

    private static void updateDeviceSubOprProgressInfo(ITask oTask, String strCurOprId, AsnResourceProgressInfo oAsnResProgress, Resource oRes) {
        List<ITaskDeviceOperation> oSupportedOperationLst = oTask.getSupportedOperation();
        int iSizeOfLst = oSupportedOperationLst.size();
        int iDomain = oTask.getDeviceType().getDeviceDomain();
        ITaskDeviceOperation oTaskDevOp = null;
        ITaskSubOperation oSubOperationData = null;
        for (int i = 0; i < iSizeOfLst; ++i) {
            int iOperationId;
            oTaskDevOp = oSupportedOperationLst.get(i);
            if (null == oTaskDevOp || !oTaskDevOp.isSelected() || (iOperationId = OperationIdStore.getInstance().getOperationId(strCurOprId)) != oTaskDevOp.getOperationId() || null == (oSubOperationData = oRes.getSubOprInfo(iOperationId))) continue;
            oSubOperationData.setDomain(iDomain);
            oSubOperationData.updateSubOprDetails(oAsnResProgress);
            oRes.addSubOprListInfo(oTaskDevOp.getOperationId(), oSubOperationData);
        }
    }

    private static void setSWDLStatus(ITask oTask, AsnResourceProgressInfo oAsnResProgress, ResourceProgressInfo oResourceProgress) {
        if (null != oAsnResProgress.oSWDLStatus) {
            String oldSWDLStatus = oResourceProgress.getSWDLStatus();
            String newSWDLStatus = TaskCommUtil.getSWDLStatusRes(oAsnResProgress.oSWDLStatus.value);
            DCDebugTracer.trace("swdl status: " + oldSWDLStatus + " -->" + newSWDLStatus);
            String sSwdlStatus = TaskCommUtil.getSWDLStatusRes(oAsnResProgress.oSWDLStatus.value, oTask);
            if (!newSWDLStatus.equals("--") && oldSWDLStatus.equals("--")) {
                DCDebugTracer.trace("set swdl status 1");
                oResourceProgress.setSWDLStatus(sSwdlStatus);
                oResourceProgress.setIntSWDLStatus(oAsnResProgress.oSWDLStatus.value);
            } else if (!(oldSWDLStatus.equals(newSWDLStatus) || oldSWDLStatus.equals("--") || newSWDLStatus.equals("--"))) {
                DCDebugTracer.trace("set swdl status 2");
                oResourceProgress.setSWDLStatus(sSwdlStatus);
                oResourceProgress.setIntSWDLStatus(oAsnResProgress.oSWDLStatus.value);
            }
        }
    }

    private static int handleFailedDevInTask(ITask oTask, DeviceType oDevType, String strOperationID, AsnResourceProgressInfo oAsnResProgress, Resource oResource) {
        int errorCode;
        block7: {
            errorCode = -1;
            if (null != oAsnResProgress.oAsnDCErrorCodeInfo) {
                errorCode = oAsnResProgress.oAsnDCErrorCodeInfo.iErrorNo.intValue();
            }
            if (null != oAsnResProgress.oAsnDCErrorCodeInfo && 0 != errorCode && 989859165 != errorCode && 989855882 != errorCode && 997195801 != errorCode && 995098639 != errorCode && !TaskAsynCommControllerHelper.isT2000PatchOpertationSucc(errorCode, oDevType.getDeviceDomain()) && 1 != oDevType.getDeviceDomain()) {
                UpgradeFailInfo rowData = new UpgradeFailInfo();
                rowData.setCurrentStep(TaskCommUtil.getDisplayNameForOperation(oDevType, strOperationID));
                rowData.setNeName(oResource.getDeviceName());
                rowData.setNeIp(oResource.getDeviceIP());
                rowData.setTaskName(oTask.getTaskName());
                rowData.setReason(ErrorCodeReader.getInstance().getErrorDesc(oAsnResProgress.oAsnDCErrorCodeInfo.iErrorNo));
                rowData.setErrorInfo(oAsnResProgress.oAsnDCErrorCodeInfo);
                try {
                    if (null == DCFrameWorkUtil.getUpgradeFaildDlg()) {
                        DCFrameWorkUtil.setUpgradeFaildDlg(UpgradeFailDialog.getInstance());
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            DCDebugTracer.trace(e);
                        }
                        DCFrameWorkUtil.getUpgradeFaildDlg().addUpgFailInfo(rowData);
                        break block7;
                    }
                    DCFrameWorkUtil.getUpgradeFaildDlg().addUpgFailInfo(rowData);
                }
                catch (Exception e) {
                    DCDebugTracer.trace(e);
                    DCFrameWorkUtil.setUpgradeFaildDlg(null);
                    DCDebugTracer.trace("rowData is : " + rowData);
                }
            }
        }
        return errorCode;
    }

    private static void updateTaskTime(AsnTaskProgressNtfn oAsnTaskProgressNtfn, ITask oTask) {
        Calendar EndTime;
        Calendar startTime = oAsnTaskProgressNtfn.oStartTime;
        if (null != startTime) {
            oTask.setStartTime(startTime);
        }
        if (null != (EndTime = oAsnTaskProgressNtfn.oEndTime)) {
            oTask.setEndTime(EndTime);
        }
    }

    private static void sendEventForAutoUpgrade(ITask oTask, int iTaskState, int iTaskResult) {
        if (iTaskResult != 0 && iTaskResult != 1) {
            return;
        }
        boolean iFailedResult = true;
        DeviceType oDevType = oTask.getDeviceType();
        THashSet<Resource> oResLst = oDevType.getResources();
        int iDevID = 0;
        for (Resource oResource : oResLst) {
            if (null == oResource) continue;
            iDevID = oResource.getDeviceID();
            break;
        }
        String FDN = "NE=" + iDevID;
        iTaskResult = iTaskResult != 0 ? 1 : iTaskResult;
        Object[] sRtnData = new Object[]{FDN, iTaskResult};
        InternalLocalMsg oRtnMsg = new InternalLocalMsg();
        oRtnMsg.ID = 4000005;
        oRtnMsg.data = sRtnData;
        DCFrameWorkUtil.getDCModuleManager().sendEvent("teCfgModule", oRtnMsg);
    }

    public static void createMxuTaskModel(MSGPacketExt oPacketExt) {
        AsnCreateMxuTaskRsp oCreateMxuTaskRsp = new AsnCreateMxuTaskRsp();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oCreateMxuTaskRsp, oPacketExt.getData());
        if (0 != iErrorCode) {
            DCFrameWorkUtil.defaultCursor();
            boolean bIsLastInfo = true;
            TaskEvent oTaskEvent = new TaskEvent(bIsLastInfo, TaskEventID.TASK_LIST_REFRESH);
            TaskInfoNotifier.getInstance().notifyTaskEvent(oTaskEvent);
            return;
        }
        AsnTaskInfo oAsnTaskInfo = oCreateMxuTaskRsp.oTaskInfo;
        AsnTaskInfoUtil.updateTaskModelFromAsnTask(oAsnTaskInfo);
        TaskEvent oTaskEvent = new TaskEvent(Boolean.TRUE, TaskEventID.TASK_LIST_REFRESH);
        TaskInfoNotifier.getInstance().notifyTaskEvent(oTaskEvent);
    }

    public static void createTaskModelWithTaskList(MSGPacketExt oPacketExt) {
        AsnListTaskRsp oTaskListInfo = new AsnListTaskRsp();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oTaskListInfo, oPacketExt.getData());
        if (0 != iErrorCode) {
            DCFrameWorkUtil.defaultCursor();
            boolean bIsLastInfo = true;
            TaskEvent oTaskEvent = new TaskEvent(bIsLastInfo, TaskEventID.TASK_LIST_REFRESH);
            TaskInfoNotifier.getInstance().notifyTaskEvent(oTaskEvent);
            DCDebugTracer.trace("get data failed : " + iErrorCode);
            if (null != DCFrameWorkUtil.getTaskTablePanel()) {
                DCFrameWorkUtil.getTaskTablePanel().closeGettingTaskLstProgressDlg();
            }
            return;
        }
        AsnListTask oAsnTaskList = oTaskListInfo.oAsnListTask;
        int iTaskCount = oAsnTaskList.size();
        DCDebugTracer.trace("TaskAsynCommController-createTaskModelWithTaskList:iTaskCount=" + iTaskCount);
        DCDebugTracer.trace("is last info " + oTaskListInfo.bIsLastInfo);
        for (int i = 0; i < iTaskCount; ++i) {
            AsnTaskInfo oAsnTaskInfo = (AsnTaskInfo)oAsnTaskList.get(i);
            String taskName = new String(oAsnTaskInfo.oTaskCommonInfo.strTaskName);
            DCDebugTracer.trace("" + i + "|taskName=" + taskName);
            AsnTaskInfoUtil.updateTaskModelFromAsnTask(oAsnTaskInfo);
        }
        TaskEvent oTaskEvent = new TaskEvent(oTaskListInfo.bIsLastInfo, TaskEventID.TASK_LIST_REFRESH);
        TaskInfoNotifier.getInstance().notifyTaskEvent(oTaskEvent);
    }

    public static void handleDelTaskListSuccessResponseByModify(MSGPacketExt oPacketExt) {
        AsnDeleteTaskReq oAsnDeleteTaskRsp = new AsnDeleteTaskReq();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnDeleteTaskRsp, oPacketExt.getData());
        if (0 != iErrorCode) {
            DCDebugTracer.trace("handleDelTaskListFailResponse:" + iErrorCode);
            return;
        }
        ArrayList<Integer> oTaskIDLst = new ArrayList<Integer>();
        int iTaskCount = oAsnDeleteTaskRsp.size();
        for (int i = 0; i < iTaskCount; ++i) {
            int iTaskId = ((BigInteger)oAsnDeleteTaskRsp.get(i)).intValue();
            oTaskIDLst.add(iTaskId);
            TaskDataModel.getInstance().removeTask(iTaskId);
            DCDebugTracer.trace("TaskAsynCommControllerHelper#handleDelTaskListSuccessResponseByModify:iTaskid " + iTaskId);
        }
        TaskEvent oTaskEvent = new TaskEvent(oTaskIDLst, TaskEventID.TASK_DELETION);
        TaskInfoNotifier.getInstance().notifyTaskEvent(oTaskEvent);
    }

    public static void handleCreateTaskResponse(MSGPacketExt oPacketExt) {
        AsnCreateTaskReq oAsnCreateTaskReq = new AsnCreateTaskReq();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnCreateTaskReq, oPacketExt.getData());
        if (0 != iErrorCode) {
            DCDebugTracer.trace("handleDelTaskListFailResponse:" + iErrorCode);
            return;
        }
        AsnTaskInfo oAsnTaskInfo = oAsnCreateTaskReq.oTaskInfo;
        AsnTaskInfoUtil.updateTaskModelFromAsnTask(oAsnTaskInfo);
        int[] arrTaskIds = new int[]{oAsnTaskInfo.oTaskCommonInfo.iTaskId.intValue()};
        TaskEvent oTaskEvent = new TaskEvent(arrTaskIds, TaskEventID.TASK_CREATION);
        TaskInfoNotifier.getInstance().notifyTaskEvent(oTaskEvent);
    }

    public static void handleDelTaskListFailResponse(MSGPacketExt oPacketExt) {
        AsnTaskRqstOpResultInfoLst oTaskIDList;
        AsnDeleteTaskRsp oAsnDeleteTaskRsp = new AsnDeleteTaskRsp();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnDeleteTaskRsp, oPacketExt.getData());
        if (0 != iErrorCode) {
            DCDebugTracer.trace("handleDelTaskListFailResponse:" + iErrorCode);
            return;
        }
        if (oAsnDeleteTaskRsp.oErrorInfo.iErrorNo.intValue() != 0 && (null == (oTaskIDList = oAsnDeleteTaskRsp.oTaskRqstOpResultInfoLst) || oTaskIDList.size() == 0)) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), oAsnDeleteTaskRsp.oErrorInfo.iErrorNo.intValue(), ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        List<TaskOpResultInfo> oTaskResultList = TaskCommUtil.getFailedTaskIDsFromDeleteResponse(oAsnDeleteTaskRsp);
        TaskAsynCommControllerHelper.displayTaskOpResultMessage(oTaskResultList, ResourceManager.getInstance().getResString("DELETE_TASK_CONTENT"), ResourceManager.getInstance().getResString("OPERATION_SUCCESSFUL"));
    }

    public static void handlePauseTaskNotify(MSGPacketExt oPacketExt) {
        AsnPauseTaskRsp oAsnPauseTaskRsp = new AsnPauseTaskRsp();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnPauseTaskRsp, oPacketExt.getData());
        if (0 == iErrorCode) {
            List<TaskOpResultInfo> oTaskResultList = TaskCommUtil.getResultListForTaskOperation(oAsnPauseTaskRsp.oTaskRspList);
            TaskAsynCommControllerHelper.displayTaskOpResultMessage(oTaskResultList, ResourceManager.getInstance().getResString("PAUSE_TASK"), ResourceManager.getInstance().getResString("PAUSE_OPERATION_SUCCESSFUL"));
            return;
        }
    }

    public static void handleContinueTaskNotify(MSGPacketExt oPacketExt) {
        AsnContinueTaskRsp oAsnContinueTaskRsp = new AsnContinueTaskRsp();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnContinueTaskRsp, oPacketExt.getData());
        if (0 == iErrorCode) {
            List<TaskOpResultInfo> oTaskResultList = TaskCommUtil.getResultListForTaskOperation(oAsnContinueTaskRsp.oTaskRspList);
            String strContinueContent = ResourceManager.getInstance().getResString("CONTINUE_TASK_CONTENT");
            if (bisContinueNE) {
                strContinueContent = ResourceManager.getInstance().getResString("CONTINUE_NE_CONTENT");
                bisContinueNE = false;
            }
            TaskAsynCommControllerHelper.displayTaskOpResultMessage(oTaskResultList, strContinueContent, strContinueContent);
            return;
        }
    }

    private static void displayTaskOpResultMessage(List oTaskOpResultList, String strOpName, final String strSuccessMsg) {
        if (null == DCFrameWorkUtil.getDCModuleManager().getTaskMgrMainPanel() || !DCFrameWorkUtil.getDCModuleManager().getTaskMgrMainPanel().isActivated()) {
            DCDebugTracer.trace("task panel is not open or not activated, ignore msg");
            return;
        }
        if (null == oTaskOpResultList || 0 == oTaskOpResultList.size()) {
            if (null != strSuccessMsg) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DCOptionPane.showMessageDialog((Component)((Object)DCFrameWorkUtil.getDCModuleManager().getTaskMgrMainPanel()), strSuccessMsg, ResourceManager.getInstance().getResString("INFO"), 1);
                    }
                });
            }
            return;
        }
        String strOperationResultTitle = ResourceManager.getInstance().getResString("OPERATE_RESULT");
        final TaskOperationResultDialog oDlg = new TaskOperationResultDialog(strOperationResultTitle, 1, true);
        oDlg.setMessage(ResourceManager.getInstance().getResString("TASK_OPERATION_RESULT_FAILURE_MSG"));
        List<ResourceOpResultInfo> oOpResultList = null;
        ITaskDataModel oTaskDataModel = TaskDataModel.getInstance();
        int iTaskCount = oTaskOpResultList.size();
        for (int i = 0; i < iTaskCount; ++i) {
            TaskOpResultInfo oTaskResult = (TaskOpResultInfo)oTaskOpResultList.get(i);
            ITask oTask = oTaskDataModel.getTask(oTaskResult.getTaskId());
            if (null == oTask) continue;
            String strTaskName = oTask.getTaskName();
            oOpResultList = oTaskResult.getOperationResultList();
            if (null == oOpResultList || 0 == oOpResultList.size()) {
                if (null == oTaskResult.getErrorCode()) continue;
                oDlg.addRowInModel(strTaskName, ErrorCodeReader.getInstance().getErrorDesc(oTaskResult.getErrorCode()));
                continue;
            }
            int iResourceCount = oOpResultList.size();
            ResourceOpResultInfo oOperationResult = null;
            Resource oTempRes = null;
            for (int j = 0; j < iResourceCount; ++j) {
                oOperationResult = oOpResultList.get(j);
                oTempRes = oOperationResult.getResource();
                Resource oResource = oTask.getSelectedDeviceType().getResource(oTempRes.getDeviceID(), oTempRes.getFrameId(), oTempRes.getSlotId());
                if (null == oResource) continue;
                oDlg.addRowInModel(oResource.getDeviceName() + '[' + oTask.getTaskName() + ']', ErrorCodeReader.getInstance().getErrorDesc(oOperationResult.getErrorCode()));
            }
        }
        if (0 < oDlg.getRowCount()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    oDlg.setVisible(true);
                }
            });
        }
    }

    public static void handleIsolationTaskNotify(MSGPacketExt oPacketExt) {
        AsnListTaskRsp oTaskListInfo = new AsnListTaskRsp();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oTaskListInfo, oPacketExt.getData());
        if (0 != iErrorCode) {
            DCFrameWorkUtil.defaultCursor();
            boolean bIsLastInfo = true;
            TaskEvent oTaskEvent = new TaskEvent(bIsLastInfo, TaskEventID.TASK_LIST_REFRESH);
            TaskInfoNotifier.getInstance().notifyTaskEvent(oTaskEvent);
            DCDebugTracer.trace("get data failed : " + iErrorCode);
            return;
        }
        iErrorCode = oTaskListInfo.oErrorInfo.iErrorNo.intValue();
        if (0 != iErrorCode) {
            DCOptionPane.showErrorDialog((Component)((Object)DCFrameWorkUtil.getDCModuleManager().getTaskMgrMainPanel()), iErrorCode);
            return;
        }
        AsnListTask oAsnTaskList = oTaskListInfo.oAsnListTask;
        int iTaskCount = oAsnTaskList.size();
        TaskEvent oTaskEvent = new TaskEvent(oTaskListInfo.bIsLastInfo, TaskEventID.DC_CREATE_ISOLATION_TASK_INFO);
        if (0 < iTaskCount) {
            AsnTaskInfo oAsnTaskInfo = (AsnTaskInfo)oAsnTaskList.get(0);
            AsnTaskInfoUtil.updateTaskModelFromAsnTask(oAsnTaskInfo);
            int iTaskId = oAsnTaskInfo.oTaskCommonInfo.iTaskId.intValue();
            oTaskEvent.setTaskID(iTaskId);
            int iResCount = oAsnTaskInfo.oTaskResourceLst.size();
            if (0 < iResCount) {
                int iDevId = ((AsnTaskResource)oAsnTaskInfo.oTaskResourceLst.get((int)0)).iDeviceId.intValue();
                oTaskEvent.setDevID(iDevId);
            }
        }
        if (null != DCFrameWorkUtil.getDCModuleManager().getTaskMgrMainPanel()) {
            DCFrameWorkUtil.getDCModuleManager().taskManagement();
        }
        TaskInfoNotifier.getInstance().notifyTaskEvent(oTaskEvent);
    }

    public static void handleActGroupMismatchNotify(MSGPacketExt oPacketExt) {
        DCDebugTracer.trace("Method handleActGroupMismatchNotify start");
        AsnDCActivateGroupMismatchNotify asnDCActivateGroupMismatchNotify = new AsnDCActivateGroupMismatchNotify();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)asnDCActivateGroupMismatchNotify, oPacketExt.getData());
        if (0 != iErrorCode) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorCode, DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
        }
        if (0 == asnDCActivateGroupMismatchNotify.oDeviceErrorInfoLst.size()) {
            return;
        }
        String[] columns = new String[]{ResourceManager.getInstance().getResString("TASK_NAME"), ResourceManager.getInstance().getResString("DEVICE_NAME"), ResourceManager.getInstance().getResString("FAILURE_REASON")};
        final TaskOperationResultDialog rstDlg = new TaskOperationResultDialog(ResourceManager.getInstance().getResString("ERROR"), 1, true, columns);
        ITask oTask = null;
        int iTaskID = asnDCActivateGroupMismatchNotify.iTaskID.intValue();
        oTask = TaskDataModel.getInstance().getTask(iTaskID);
        if (null == oTask) {
            DCDebugTracer.trace("Method handleActGroupMismatchNotify taskObj is null=" + iTaskID);
            return;
        }
        rstDlg.setMessage(ResourceManager.getInstance().getResString("INFO_ACTIVE_GROUP_MISMATCH_DLG"));
        String sTaskName = new String(asnDCActivateGroupMismatchNotify.sTaskName);
        int iDevID = -1;
        String sDevName = "";
        String sFailureReson = "";
        AsnDCDeviceErrorInfo asnDCDeviceErrorInfo = null;
        Vector<Object> rowData = null;
        TaskTablePanel oTaskTablePanel = DCFrameWorkUtil.getTaskTablePanel();
        int errorDevSize = asnDCActivateGroupMismatchNotify.oDeviceErrorInfoLst.size();
        if (errorDevSize == 0) {
            return;
        }
        for (int i = 0; i < asnDCActivateGroupMismatchNotify.oDeviceErrorInfoLst.size(); ++i) {
            asnDCDeviceErrorInfo = (AsnDCDeviceErrorInfo)asnDCActivateGroupMismatchNotify.oDeviceErrorInfoLst.get(i);
            if (null == asnDCDeviceErrorInfo) continue;
            iDevID = asnDCDeviceErrorInfo.iDevID.intValue();
            DeviceInfo oDevice = DeviceInfoManagerImpl.getInstance().getDevice(iDevID);
            if (null != oDevice) {
                sDevName = oDevice.getDevName();
            }
            sFailureReson = ErrorCodeReader.getInstance().getErrorDesc(asnDCDeviceErrorInfo.oErrorInfo.iErrorNo);
            rowData = new Vector<Object>(3);
            rowData.add(sTaskName);
            rowData.add(sDevName);
            rowData.add(sFailureReson);
            rstDlg.addRowInModel(rowData);
            DCDebugTracer.trace("dc receive set handleActGroupMismatchNotify mode failed: " + sTaskName + ": " + sDevName + "(" + sFailureReson + ")");
        }
        if (null == oTaskTablePanel) {
            DCDebugTracer.trace("[HighMode]handleActGroupMismatchNotify:oTaskTablePanel is null");
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                rstDlg.setVisible(true);
            }
        });
        DCDebugTracer.trace("Method handleActGroupMismatchNotify end");
    }

    public static void handleHighModeSetFailureNotify(MSGPacketExt oPacketExt) {
        DCDebugTracer.trace("Method handleHighModeSetFailureNotify start");
        AsnDCHighModeConfigNotify asnDCHighModeConfigNotify = new AsnDCHighModeConfigNotify();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)asnDCHighModeConfigNotify, oPacketExt.getData());
        if (0 != iErrorCode) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorCode, DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
        }
        if (0 == asnDCHighModeConfigNotify.oDeviceErrorInfoLst.size()) {
            return;
        }
        String[] columns = new String[]{ResourceManager.getInstance().getResString("TASK_NAME"), ResourceManager.getInstance().getResString("NE_ID"), ResourceManager.getInstance().getResString("DEVICE_NAME"), ResourceManager.getInstance().getResString("FAILURE_REASON")};
        final TaskOperationResultDialog rstDlg = new TaskOperationResultDialog(ResourceManager.getInstance().getResString("ERROR"), 1, true, columns);
        ITask oTask = null;
        int iTaskID = asnDCHighModeConfigNotify.iTaskID.intValue();
        oTask = TaskDataModel.getInstance().getTask(iTaskID);
        if (null == oTask) {
            DCDebugTracer.trace("Method handleHighModeSetFailureNotify:get taskObj is null=" + iTaskID);
            return;
        }
        if (1 == oTask.getHighefficiencyMode()) {
            rstDlg.setMessage(ResourceManager.getInstance().getResString("INFO_HIGH_MODE_SET_FAILURE_DLG"));
        } else {
            rstDlg.setMessage(ResourceManager.getInstance().getResString("INFO_RESET_MODE_SET_FAILURE_DLG"));
        }
        String sTaskName = new String(asnDCHighModeConfigNotify.sTaskName);
        int iDevID = -1;
        int iNeID = -1;
        String sNeID = "";
        String sDevName = "";
        String sFailureReson = "";
        AsnDCDeviceErrorInfo asnDCDeviceErrorInfo = null;
        Vector<Object> rowData = null;
        int taskResult = asnDCHighModeConfigNotify.oTaskResult.value;
        DCDebugTracer.trace("Method handleHighModeSetFailureNotify taskResult=" + taskResult);
        TaskTablePanel oTaskTablePanel = DCFrameWorkUtil.getTaskTablePanel();
        int errorDevSize = asnDCHighModeConfigNotify.oDeviceErrorInfoLst.size();
        for (int i = 0; i < asnDCHighModeConfigNotify.oDeviceErrorInfoLst.size(); ++i) {
            asnDCDeviceErrorInfo = (AsnDCDeviceErrorInfo)asnDCHighModeConfigNotify.oDeviceErrorInfoLst.get(i);
            if (null == asnDCDeviceErrorInfo) continue;
            iDevID = asnDCDeviceErrorInfo.iDevID.intValue();
            iNeID = -1;
            if (null != asnDCDeviceErrorInfo.iNeID) {
                iNeID = asnDCDeviceErrorInfo.iNeID.intValue();
            }
            sNeID = DeviceInfoUtil.parseNEIDInt(iNeID);
            DeviceInfo oDevice = DeviceInfoManagerImpl.getInstance().getDevice(iDevID);
            if (null != oDevice) {
                sDevName = oDevice.getDevName();
            }
            sFailureReson = ErrorCodeReader.getInstance().getErrorDesc(asnDCDeviceErrorInfo.oErrorInfo.iErrorNo);
            rowData = new Vector<Object>(4);
            rowData.add(sTaskName);
            rowData.add(sNeID);
            rowData.add(sDevName);
            rowData.add(sFailureReson);
            rstDlg.addRowInModel(rowData);
            if (null != oTaskTablePanel) {
                oTaskTablePanel.handleHighModeSetFailedRsp(iTaskID, iDevID, asnDCDeviceErrorInfo.oErrorInfo, errorDevSize, taskResult);
            }
            DCDebugTracer.trace("dc receive set highEfficiency mode failed: " + sTaskName + ": " + sDevName + "(" + sFailureReson + ")");
        }
        if (null == oTaskTablePanel) {
            DCDebugTracer.trace("[HighMode]handleHighModeSetFailureNotify:oTaskTablePanel is null");
            return;
        }
        if (null != asnDCDeviceErrorInfo) {
            oTaskTablePanel.handleHighModeSetFailedRsp(iTaskID, -1, asnDCDeviceErrorInfo.oErrorInfo, errorDevSize, taskResult);
        }
        oTaskTablePanel.updateTableView();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                rstDlg.setVisible(true);
            }
        });
        DCFrameWorkUtil.getTaskTableButtonPanel().checkButtonsStatus();
        DCDebugTracer.trace("Method handleHighModeSetFailureNotify end");
    }

    public static void updateSlaveDevInfo(MSGPacketExt oPacketExt, TaskAsynCommController reference) {
        AsnDCSlaveDevInfoRsp oAsnDCSlaveDevInfoRsp = new AsnDCSlaveDevInfoRsp();
        DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnDCSlaveDevInfoRsp, oPacketExt.getData());
        TaskEvent oTaskEvent = new TaskEvent(oAsnDCSlaveDevInfoRsp, TaskEventID.SLAVE_DEV_INFO);
        TaskInfoNotifier.getInstance().notifyTaskEvent(oTaskEvent);
        DCFrameWorkUtil.getCommManager().removeMessageListener(44017, (MSGListener)reference);
    }

    public static void updateDevUpgradeMode(MSGPacketExt oPacketExt) {
        DCDebugTracer.trace("[upgrade mode] method updateDevUpgradeMode start.");
        AsnGetDevUpgradeModeRsp oAsnGetDevUpgradeModeRsp = new AsnGetDevUpgradeModeRsp();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnGetDevUpgradeModeRsp, oPacketExt.getData());
        AsnDevUpgrModeInfoLst oDevUpgrModeInfoLst = oAsnGetDevUpgradeModeRsp.oDevUpgrModeInfoLst;
        for (int i = 0; i < oDevUpgrModeInfoLst.size(); ++i) {
            AsnDevUpgrModeInfo oDevUpgrModeInfo = (AsnDevUpgrModeInfo)oDevUpgrModeInfoLst.get(i);
            if (null == oDevUpgrModeInfo) continue;
            DCDebugTracer.trace("oDevUpgrModeInfo:iUpgradeMode-->" + oDevUpgrModeInfo.iUpgradeMode + " DevIndex:" + i);
        }
        if (0 != iErrorCode) {
            DCDebugTracer.trace("[upgrade mode] updateDevUpgradeMode have error : " + iErrorCode);
            SynProgressDlg.getInstance().notifyError(iErrorCode, "");
        }
        TaskEvent oTaskEvent = new TaskEvent(oAsnGetDevUpgradeModeRsp, TaskEventID.UPGRADE_MODE_VALIDATION);
        TaskInfoNotifier.getInstance().notifyTaskEvent(oTaskEvent);
        DCDebugTracer.trace("[upgrade mode] method updateDevUpgradeMode end.");
    }

    public static void updateDeviceMemoryInfo(MSGPacketExt oPacketExt, TaskAsynCommController reference) {
        AsnDCCheckDevMemoryRsp oAsnDCCheckDevMemoryRsp = new AsnDCCheckDevMemoryRsp();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnDCCheckDevMemoryRsp, oPacketExt.getData());
        if (0 != iErrorCode) {
            oAsnDCCheckDevMemoryRsp = new AsnDCCheckDevMemoryRsp();
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorCode, DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
        }
        TaskEvent oTaskEvent = new TaskEvent(oAsnDCCheckDevMemoryRsp, TaskEventID.DC_GET_DEVICE_MEMORY_INFO);
        TaskInfoNotifier.getInstance().notifyTaskEvent(oTaskEvent);
        DCFrameWorkUtil.getCommManager().removeMessageListener(44030, (MSGListener)reference);
    }

    public static void handleUpgradeFeasibilityCheck(MSGPacketExt oPacketExt) {
        DCDebugTracer.trace("Method handleUpgradeFeasibilityCheck start");
        AsnT2000UpgradeFeasInfoRsp oAsnT2000UpgradeFeasInfoRsp = new AsnT2000UpgradeFeasInfoRsp();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnT2000UpgradeFeasInfoRsp, oPacketExt.getData());
        if (0 != iErrorCode) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorCode, DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
        }
        TaskEvent oTaskEvent = new TaskEvent(oAsnT2000UpgradeFeasInfoRsp, TaskEventID.UPGARDE_FEASIBILTY_VALIDATION);
        TaskInfoNotifier.getInstance().notifyTaskEvent(oTaskEvent);
        DCDebugTracer.trace("Method handleUpgradeFeasibilityCheck end");
    }

    public static void handleDeviceOperationResultResponse(MSGPacketExt oPacketExt) {
        DCDebugTracer.trace("Method handleDeviceOperationResultResponse start");
        AsnTaskResultRsp oAsnTaskResultRsp = new AsnTaskResultRsp();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnTaskResultRsp, oPacketExt.getData());
        if (0 != iErrorCode) {
            return;
        }
        ITask oTask = TaskDataModel.getInstance().getTask(oAsnTaskResultRsp.iTaskId.intValue());
        if (null == oTask) {
            return;
        }
        AsnTaskDevResultLst oAsnTaskDevResultLst = oAsnTaskResultRsp.oTaskDevResultLst;
        DeviceType oDevType = oTask.getDeviceType();
        AsnTaskDevResult oAsnTaskDevResult = null;
        AsnTaskResource oResourceInfo = null;
        Resource oResource = null;
        AsnTaskDevOpInfoLst oTaskDevOpInfoLst = null;
        AsnTaskDevOpInfo oAsnTaskDevOpInfo = null;
        int iDevID = -1;
        int iFrameID = -1;
        int iSlotID = -1;
        int iStackID = -1;
        int iLength = oAsnTaskDevResultLst.size();
        for (int i = 0; i < iLength; ++i) {
            iDevID = -1;
            iFrameID = -1;
            iSlotID = -1;
            iStackID = -1;
            oAsnTaskDevResult = (AsnTaskDevResult)oAsnTaskDevResultLst.get(i);
            oResourceInfo = oAsnTaskDevResult.oResourceInfo;
            iDevID = oResourceInfo.iDeviceId.intValue();
            if (null != oResourceInfo.iFrameId) {
                iFrameID = oResourceInfo.iFrameId.intValue();
            }
            if (null != oResourceInfo.iSlotId) {
                iSlotID = oResourceInfo.iSlotId.intValue();
            }
            if (null != oResourceInfo.iStackId) {
                iStackID = oResourceInfo.iStackId.intValue();
            }
            if (null == (oResource = oDevType.getResource(iDevID, iFrameID, iSlotID, iStackID))) {
                DCDebugTracer.trace("can not ind resource in task ");
                continue;
            }
            oTaskDevOpInfoLst = oAsnTaskDevResult.oTaskDevOpInfoLst;
            int iOprSize = oTaskDevOpInfoLst.size();
            oResource.clearOperationResults();
            oResource.clearOperResultsMap();
            for (int iDeviceIndex = 0; iDeviceIndex < iOprSize; ++iDeviceIndex) {
                oAsnTaskDevOpInfo = (AsnTaskDevOpInfo)oTaskDevOpInfoLst.get(iDeviceIndex);
                ResourceProgressInfo oResInfo = new ResourceProgressInfo();
                oResInfo.setCurrentOperationId(new String(oAsnTaskDevOpInfo.strOpId));
                oResInfo.setState(oAsnTaskDevOpInfo.enOpStatus.value);
                String strOprName = TaskCommUtil.getDisplayNameForOperation(oTask.getSelectedDeviceType(), oResInfo.getCurrentOperationId());
                oResInfo.setCurrentOperationName(strOprName);
                String strErrMsg = null;
                if (null != oAsnTaskDevOpInfo.stErrorInfo.strResult) {
                    strErrMsg = new String(oAsnTaskDevOpInfo.stErrorInfo.strResult);
                }
                oResInfo.setErrorType(oAsnTaskDevOpInfo.stErrorInfo.oResultType.value);
                oResInfo.setErrorInfo(oAsnTaskDevOpInfo.stErrorInfo.iErrorNo.intValue(), strErrMsg);
                oResInfo.setFailureReason(new String(oAsnTaskDevOpInfo.stErrorInfo.strResult));
                oResInfo.setStartTime(oAsnTaskDevOpInfo.oOprStartTime);
                oResInfo.setEndTime(oAsnTaskDevOpInfo.oOprEndTime);
                if (null != oAsnTaskDevOpInfo.enOpResult) {
                    oResInfo.setResult(oAsnTaskDevOpInfo.enOpResult.value);
                }
                oResource.addOprResultInfo(oResInfo.getCurrentOperationId(), oResInfo);
            }
        }
        if (IsolationCommonOperation.isIsolationTask(oTask.getTaskTypeId())) {
            if (null != DCFrameWorkUtil.getIsolationTaskInfoPanel()) {
                TaskEvent oTaskEvent = new TaskEvent(TaskEventID.DC_UPDATE_ISOLATION_TASK_OPERATION_DETAILS);
                DCFrameWorkUtil.getIsolationTaskInfoPanel().notifyEvent(oTaskEvent);
            }
        } else {
            DCFrameWorkUtil.getTaskTablePanel().notifyEvent(new DeviceTreeTableDataSelectionEventObject((Object)DCFrameWorkUtil.getTaskTablePanel().getTaskTreeTable()));
        }
        DCDebugTracer.trace("Method handleDeviceOperationResultResponse end");
    }

    public static void handleDelResInTask(final MSGPacketExt oPacketExt) {
        Thread oThread = new Thread(new Runnable(){

            @Override
            public void run() {
                DCDebugTracer.trace("handleDelResInTask - Method handleDelResInTask start");
                AsnDelDevInTaskNfy oAsnDelDevInTaskNfy = new AsnDelDevInTaskNfy();
                int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnDelDevInTaskNfy, oPacketExt.getData());
                if (0 != iErrorCode) {
                    DCDebugTracer.trace("handleDelResInTask - ASN Decode failed on client side");
                    return;
                }
                int noOfDevices = oAsnDelDevInTaskNfy.oDevSetInfoLst.size();
                ArrayList<Resource> oResList = new ArrayList<Resource>(4);
                Resource oResource = null;
                AsnDevSetInfo asnDeviceInfo = null;
                DCDebugTracer.trace("taskID : " + oAsnDelDevInTaskNfy.iTaskId.intValue());
                for (int i = 0; i < noOfDevices; ++i) {
                    asnDeviceInfo = (AsnDevSetInfo)oAsnDelDevInTaskNfy.oDevSetInfoLst.get(i);
                    oResource = new Resource();
                    DCDebugTracer.trace("devID : " + asnDeviceInfo.iDevId.intValue());
                    oResource.setDeviceID(asnDeviceInfo.iDevId.intValue());
                    oResList.add(oResource);
                }
                TaskEvent taskEvent = new TaskEvent(oResList, oAsnDelDevInTaskNfy.iTaskId.intValue(), TaskEventID.RESOURCE_DELETION_ONLY_IN_TASK, true);
                TaskDataModel.getInstance().notifyTaskEvent(taskEvent);
                TaskEvent oTaskEvent = new TaskEvent(Boolean.TRUE, TaskEventID.TASK_LIST_REFRESH);
                TaskInfoNotifier.getInstance().notifyTaskEvent(oTaskEvent);
                DCDebugTracer.trace("handleDelResInTask - Method handleDelResInTask end");
            }
        });
        oThread.start();
    }

    public static void handleCheckLoadSoftware(MSGPacketExt oPacketExt, TaskAsynCommController reference) {
        DCDebugTracer.trace("Method handleCheckLoadSoftware start");
        AsnSWCompatibilityCheckResp oAsnSWCompatibilityCheckResp = new AsnSWCompatibilityCheckResp();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnSWCompatibilityCheckResp, oPacketExt.getData());
        if (0 != iErrorCode) {
            LoadSoftwareCheckManager.getInstance().setError(true);
            LoadSoftwareCheckManager.getInstance().stopProgressDlg();
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorCode, DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
        }
        TaskEvent oTaskEvent = new TaskEvent(oAsnSWCompatibilityCheckResp, TaskEventID.SOFTWARE_COMPATIBILITY_VALIDATION);
        TaskInfoNotifier.getInstance().notifyTaskEvent(oTaskEvent);
        DCFrameWorkUtil.getCommManager().removeMessageListener(43990, (MSGListener)reference);
        DCDebugTracer.trace("Method handleCheckLoadSoftware end");
    }

    public static void handleDeleteFileResponse(MSGPacketExt oPacketExt) {
        TaskAsynCommControllerHelperExt.handleDeleteFileResponse(oPacketExt);
    }

    public static void handleCancelFailureResponse(MSGPacketExt oPacketExt) {
        DCDebugTracer.trace("Method handleCancelFailureResponse start");
        AsnCancelTaskRsp oAsnCancelTaskRsp = new AsnCancelTaskRsp();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnCancelTaskRsp, oPacketExt.getData());
        if (0 != iErrorCode) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorCode, DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
        }
        TaskEvent oTaskEvent = new TaskEvent(oAsnCancelTaskRsp, TaskEventID.DC_CANCEL_TASK_DEVICE_OPERATION);
        TaskInfoNotifier.getInstance().notifyTaskEvent(oTaskEvent);
        TaskAsynCommControllerHelper.updateResourceForCancel(oAsnCancelTaskRsp);
        DCDebugTracer.trace("Method handleCancelFailureResponse end");
    }

    private static void updateResourceForCancel(AsnCancelTaskRsp oAsnCancelTaskRsp) {
        int iTaskID = oAsnCancelTaskRsp.iTaskId.intValue();
        int iDevID = oAsnCancelTaskRsp.iDevId.intValue();
        int iErrorCode = oAsnCancelTaskRsp.iErrorCode.intValue();
        ITask oTask = TaskDataModel.getInstance().getTask(iTaskID);
        if (null == oTask) {
            return;
        }
        Resource oRes = oTask.getDeviceType().getResource(iDevID);
        if (0 == iErrorCode) {
            oRes.setOperationCancelled(false);
        }
    }

    public static void setIsContinueNE(boolean bValue) {
        bisContinueNE = bValue;
    }

    public static void handleFreeIsolationDeviceTaskNotify(MSGPacketExt oPacketExt) {
        TaskAsynCommControllerHelperExt.handleFreeIsolationDeviceTaskNotify(oPacketExt);
    }
}

