/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.controller;

import com.huawei.dc.common.DCErrorCode;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCActGroupBoardInfo;
import com.huawei.dc.common.asndatacenter.AsnDCActivationGroupLst;
import com.huawei.dc.common.asndatacenter.AsnDCCheckActiveGroupInfoReq;
import com.huawei.dc.common.asndatacenter.AsnDCCheckActiveGroupInfoRsp;
import com.huawei.dc.common.asndatacenter.AsnDCDefaultActiveGroupForDevLevelReq;
import com.huawei.dc.common.asndatacenter.AsnDCDefaultActiveGroupReq;
import com.huawei.dc.common.asndatacenter.AsnDCDefaultActiveGroupRsp;
import com.huawei.dc.common.asndatacenter.AsnDCDefaultGroupActivateForDiffusionReq;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceBoardNotification;
import com.huawei.dc.common.asndatacenter.AsnDCErrorCodeInfo;
import com.huawei.dc.common.asndatacenter.AsnDCGetActGroupBoardInfoReq;
import com.huawei.dc.common.asndatacenter.AsnDCGetBDResetInfoReq;
import com.huawei.dc.common.asndatacenter.AsnDCMainBoardNumRsp;
import com.huawei.dc.common.asndatacenter.AsnDCOpertionRsp;
import com.huawei.dc.common.asndatacenter.AsnDCSIBoardInfoRsp;
import com.huawei.dc.common.asndatacenter.AsnDCSimulationPackageDeviceList;
import com.huawei.dc.common.asndatacenter.AsnDCSimulationPackageLoadSortReq;
import com.huawei.dc.common.asndatacenter.AsnDCSimulationPackageLoadSortRsp;
import com.huawei.dc.common.asndatacenter.AsnDCSupportISSUReq;
import com.huawei.dc.common.asndatacenter.AsnDCSupportISSURsp;
import com.huawei.dc.common.asndatacenter.AsnDCSyncRsp;
import com.huawei.dc.common.asndatacenter.AsnDeleteTaskReq;
import com.huawei.dc.common.asndatacenter.AsnDevUpgrModeInfo;
import com.huawei.dc.common.asndatacenter.AsnDevUpgrModeInfoLst;
import com.huawei.dc.common.asndatacenter.AsnFreeIsolationDeviceReq;
import com.huawei.dc.common.asndatacenter.AsnGetDevUpgradeModeRsp;
import com.huawei.dc.common.asndatacenter.AsnStResErrorInfo;
import com.huawei.dc.common.asndatacenter.AsnStResErrorInfoLst;
import com.huawei.dc.common.asndatacenter.AsnTaskDetailsResultInfo;
import com.huawei.dc.common.asndatacenter.AsnTaskDetailsResultInfoLst;
import com.huawei.dc.common.asndatacenter.AsnTaskDetailsResultInfoRsp;
import com.huawei.dc.common.asndatacenter.AsnToleranceSearchReq;
import com.huawei.dc.common.components.dialog.ProgressDlg;
import com.huawei.dc.common.components.dialog.SynProgressDlg;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.model.TreeTableRowData;
import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.controller.AbstractDCMSGReceiver;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.deviceoperation.AutoProgressDlgForOptix;
import com.huawei.dc.devicemanagement.deviceoperation.activationpackage.view.ActivationPackagePanel;
import com.huawei.dc.devicemanagement.deviceoperation.loadsimulationpackage.view.LoadSimPackageTabbedPane;
import com.huawei.dc.devicemanagement.deviceoperation.recoverdb.RecoverAndActivateDBPanel;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.controller.ILogInfoNotifier;
import com.huawei.dc.taskmgmt.controller.ITaskAsynCommController;
import com.huawei.dc.taskmgmt.controller.LogInfoNotifier;
import com.huawei.dc.taskmgmt.controller.TaskAsynCommControllerHelper;
import com.huawei.dc.taskmgmt.controller.TaskAsynCommControllerProxy;
import com.huawei.dc.taskmgmt.controller.TaskAsynCommControllerUtil;
import com.huawei.dc.taskmgmt.controller.TaskAsynCommForUpModeNotify;
import com.huawei.dc.taskmgmt.controller.TaskEvent;
import com.huawei.dc.taskmgmt.controller.TaskEventID;
import com.huawei.dc.taskmgmt.controller.TaskInfoNotifier;
import com.huawei.dc.taskmgmt.controller.TaskSrcDstVersionCheck;
import com.huawei.dc.taskmgmt.isolation.IsolationCommonOperation;
import com.huawei.dc.taskmgmt.isolation.model.IsolationTaskInfoObj;
import com.huawei.dc.taskmgmt.isolation.view.IsolationTaskInfoPanel;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.Task;
import com.huawei.dc.taskmgmt.model.TaskDataModel;
import com.huawei.dc.taskmgmt.view.TaskMgmtOperationSelecPanel;
import com.huawei.dc.taskmgmt.view.common.GroupingAtivePanel;
import com.huawei.dc.taskmgmt.view.common.QueryBoardResetInfoDlg;
import com.huawei.dc.taskmgmt.view.modifytask.CopyModifyTaskDialog;
import com.huawei.dc.taskmgmt.view.tasktable.TaskTableUtil;
import com.swimap.iview.communicate.MSGPacketExt;
import com.swimap.iview.util.SyncCommand;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Cursor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import net.commustru.fstru.FStruct;

public class TaskAsynCommController
extends AbstractDCMSGReceiver
implements ITaskAsynCommController,
IDCObjectDeallocator {
    private static TaskAsynCommController m_oTaskAsynCommController;
    private ILogInfoNotifier m_oLogEventNotifier = LogInfoNotifier.getInstance();
    private AsnDCSimulationPackageLoadSortRsp packageLoadSortRsp;
    private AsnDCDefaultActiveGroupRsp activeGroupRsp;
    private AutoProgressDlgForOptix m_oprogressDlg;
    private ProgressDlg m_progressDlg;
    private LoadSimPackageTabbedPane tabbedPane;
    private GroupingAtivePanel activationPackagePanel;
    private int requestIdForLoadPackageSort = -1;
    private int requestIdForActivation = -1;
    private byte[] m_oSyncObj = new byte[0];
    private DCSortableTreeTable m_oTaskTreeTable = null;
    private RecoverAndActivateDBPanel m_oRecoverPanel;
    private long firstOpenClientTime = -1L;
    private QueryBoardResetInfoDlg queryResetDlg;
    private HashMap<Integer, CopyModifyTaskDialog> copyModifyTaskDialogMap = new HashMap();
    private static final int[] LISTENER_ARRAY;

    private TaskAsynCommController() {
        super(LISTENER_ARRAY);
        this.firstOpenClientTime = System.nanoTime();
        TaskAsynCommForUpModeNotify.getInstance();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.firstOpenClientTime ^ this.firstOpenClientTime >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskAsynCommController other = (TaskAsynCommController)obj;
        return this.firstOpenClientTime == other.firstOpenClientTime;
    }

    @Override
    public void setToNULL() {
        this.closeReceiver();
        m_oTaskAsynCommController = null;
    }

    public static synchronized ITaskAsynCommController getInstance() {
        if (null == m_oTaskAsynCommController) {
            m_oTaskAsynCommController = new TaskAsynCommController();
            DCObjectDestructor.getInstance().addObjectForDestructor(m_oTaskAsynCommController);
        }
        return m_oTaskAsynCommController;
    }

    @Override
    public void getTaskList() {
        TaskAsynCommControllerProxy.getTaskList();
    }

    protected void processMessage(MSGPacketExt oPacketExt) {
        block3: {
            DCDebugTracer.trace("receive asyn msg cmdCode=" + oPacketExt.mheader.cmdCode);
            try {
                this.processMessagePacket(oPacketExt);
            }
            catch (Exception e) {
                DCDebugTracer.trace(e);
                if (43871 == oPacketExt.mheader.cmdCode) {
                    DCFrameWorkUtil.defaultCursor();
                    boolean bIsLastInfo = true;
                    TaskEvent oTaskEvent = new TaskEvent(bIsLastInfo, TaskEventID.TASK_LIST_REFRESH);
                    TaskInfoNotifier.getInstance().notifyTaskEvent(oTaskEvent);
                }
                if (44031 != oPacketExt.mheader.cmdCode) break block3;
                DCDebugTracer.trace("TaskAsynCommController#processMessage#get 44031");
            }
        }
    }

    private void processMessagePacket(MSGPacketExt oPacketExt) {
        DCDebugTracer.trace("method TaskAsynCommController#processMessagePacket start");
        DCFrameWorkUtil.setIsNeedToSendCmdCode(false);
        switch (oPacketExt.mheader.cmdCode) {
            case 43871: {
                TaskAsynCommControllerHelper.createTaskModelWithTaskList(oPacketExt);
                break;
            }
            case 43961: {
                TaskAsynCommControllerHelper.createMxuTaskModel(oPacketExt);
                break;
            }
            case 43833: {
                TaskAsynCommControllerHelper.updateResourceProgressNotification(oPacketExt);
                break;
            }
            case 43920: {
                TaskAsynCommControllerUtil.updateCheckReportNotification(oPacketExt, 0);
                break;
            }
            case 43921: {
                TaskAsynCommControllerUtil.updateCheckReportNotification(oPacketExt, 1);
                break;
            }
            case 43922: {
                TaskAsynCommControllerUtil.updateCheckReportNotification(oPacketExt, 2);
                break;
            }
            case 44088: {
                TaskAsynCommControllerUtil.updateCheckReportNotification(oPacketExt);
                break;
            }
            case 43946: {
                TaskAsynCommControllerUtil.updateRollbackProgressNotification(oPacketExt, 43946);
                break;
            }
            case 44051: {
                TaskAsynCommControllerUtil.updateRollbackProgressNotification(oPacketExt, 44051);
                break;
            }
            case 43957: {
                this.updateGroupingActivationInfoNotification(oPacketExt);
                break;
            }
            case 43943: {
                this.updateGroupingActivationInfoNotification(oPacketExt);
                break;
            }
            case 44066: {
                this.updateGroupingActivationInfoNotification(oPacketExt);
                break;
            }
            case 43942: {
                this.updatePackageLoadSortNotification(oPacketExt);
                break;
            }
            case 43965: {
                this.updateCheckActivationGroupInfoNotification(oPacketExt);
                break;
            }
            case 43964: {
                break;
            }
            case 43988: {
                this.handleDeviceDelayRebootResponse(oPacketExt);
                break;
            }
            case 43900: {
                TaskAsynCommControllerHelper.handleDelTaskListFailResponse(oPacketExt);
                break;
            }
            case 43984: {
                this.handleDelTaskListSuccessResponse(oPacketExt);
                break;
            }
            case 43877: {
                TaskAsynCommControllerHelper.handleDelTaskListSuccessResponseByModify(oPacketExt);
                break;
            }
            case 43872: {
                TaskAsynCommControllerHelper.handleCreateTaskResponse(oPacketExt);
                break;
            }
            case 44017: {
                TaskAsynCommControllerHelper.updateSlaveDevInfo(oPacketExt, this);
                break;
            }
            case 43990: {
                TaskAsynCommControllerHelper.handleCheckLoadSoftware(oPacketExt, this);
                break;
            }
            case 43991: {
                TaskAsynCommControllerHelper.handleUpgradeFeasibilityCheck(oPacketExt);
                break;
            }
            case 43998: {
                TaskAsynCommControllerHelper.handleHighModeSetFailureNotify(oPacketExt);
                break;
            }
            case 44074: {
                TaskAsynCommControllerHelper.handleActGroupMismatchNotify(oPacketExt);
                break;
            }
            case 44001: {
                TaskAsynCommControllerHelper.handleDeviceOperationResultResponse(oPacketExt);
                break;
            }
            case 44002: {
                this.processDeviceOprLogs(oPacketExt);
                break;
            }
            case 44003: {
                this.processDeviceOprLogNotification(oPacketExt);
                break;
            }
            case 44018: {
                TaskAsynCommControllerHelper.handleCancelFailureResponse(oPacketExt);
                break;
            }
            case 44033: {
                TaskAsynCommControllerHelper.handleBoxesAutoUpgrade(oPacketExt);
                break;
            }
            case 44030: {
                TaskAsynCommControllerHelper.updateDeviceMemoryInfo(oPacketExt, this);
                break;
            }
            case 44031: {
                TaskAsynCommControllerHelper.handleDeleteFileResponse(oPacketExt);
                break;
            }
            case 44064: {
                TaskAsynCommControllerHelper.handleIsolationTaskNotify(oPacketExt);
                break;
            }
            case 43904: {
                TaskAsynCommControllerHelper.handlePauseTaskNotify(oPacketExt);
                break;
            }
            case 43905: {
                TaskAsynCommControllerHelper.handleContinueTaskNotify(oPacketExt);
                break;
            }
            case 44073: {
                TaskAsynCommControllerHelper.handleDelResInTask(oPacketExt);
                break;
            }
            case 44057: {
                this.queryBoardResetInfoResponse(oPacketExt);
                break;
            }
            case 44084: {
                this.handleMainBoardNumResponse(oPacketExt);
                break;
            }
            case 44085: {
                this.handleDeviceISSUResponse(oPacketExt);
                break;
            }
            case 44094: {
                TaskSrcDstVersionCheck.getInstance().handleDesVersionCheck(oPacketExt);
                break;
            }
            case 54102: {
                TaskAsynCommControllerHelper.handleFreeIsolationDeviceTaskNotify(oPacketExt);
                break;
            }
        }
        DCDebugTracer.trace("method TaskAsynCommController#processMessagePacket end..");
    }

    @Override
    public void getPackageLoadSort(AsnDCSimulationPackageLoadSortReq packageLoadReq, LoadSimPackageTabbedPane tabbedPane) {
        AsnDCSimulationPackageLoadSortReq LoadReq = packageLoadReq;
        this.requestIdForLoadPackageSort = LoadReq.oReqID.intValue();
        this.tabbedPane = tabbedPane;
        this.m_oprogressDlg = tabbedPane.getProgressDlg();
        this.packageLoadSortRsp = tabbedPane.getPackageLoadSortRsp();
        int errorcode = this.sendSyncMsg(43942, (FStruct)LoadReq);
        if (errorcode != 0) {
            tabbedPane.setThreadStop(true);
            this.m_oprogressDlg.setProgress(ResourceManager.getInstance().getResString("LOAD_PACKAGE"), ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(-1L)), 100);
            tabbedPane.setPackageLoadSortRsp(null);
        }
        this.m_oprogressDlg.setVisible(true);
    }

    private void updatePackageLoadSortNotification(MSGPacketExt oPacketExt) {
        if (this.tabbedPane == null || this.tabbedPane.getThreadStop()) {
            return;
        }
        try {
            Thread.sleep(500L);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        AsnDCSimulationPackageLoadSortRsp packageSortRsp = new AsnDCSimulationPackageLoadSortRsp();
        int iErrorCoide = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)packageSortRsp, oPacketExt.getData());
        if (iErrorCoide == 0) {
            if (this.requestIdForLoadPackageSort != packageSortRsp.oReqID.intValue()) {
                return;
            }
            AsnDCSimulationPackageDeviceList packageDevListPart = packageSortRsp.oSimulationPackageInfoDeviceLst;
            AsnDCErrorCodeInfo errorCodeInfoPart = packageSortRsp.oErrorNo;
            this.packageLoadSortRsp.oSimulationPackageInfoDeviceLst.addAll((Collection)packageDevListPart);
            this.packageLoadSortRsp.oErrorNo = errorCodeInfoPart;
            if (packageSortRsp.bIsLastInfo) {
                if (this.packageLoadSortRsp.oErrorNo.iErrorNo.intValue() == 0) {
                    this.tabbedPane.setThreadStop(true);
                    this.m_oprogressDlg.setProgress(ResourceManager.getInstance().getResString("LOAD_PACKAGE"), ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(0L)), 100);
                    this.tabbedPane.setPackageLoadSortRsp(this.packageLoadSortRsp);
                    DCDebugTracer.trace("method TaskAsynCommController#updatePackageLoadSortNotification# packageSortRsp.bIsDisableActivateStep->" + packageSortRsp.bIsDisableActivateStep);
                    this.tabbedPane.setbIsDisableActivateStep(packageSortRsp.bIsDisableActivateStep);
                    TaskMgmtOperationSelecPanel oTaskMgmtOperationSelecPanel = DCFrameWorkUtil.getTaskMgmtOperationSelecPanel();
                    if (null != oTaskMgmtOperationSelecPanel) {
                        oTaskMgmtOperationSelecPanel.setTheFirstTime(false);
                    }
                } else {
                    this.tabbedPane.setThreadStop(true);
                    this.m_oprogressDlg.setProgress(ResourceManager.getInstance().getResString("LOAD_PACKAGE"), ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(this.packageLoadSortRsp.oErrorNo.iErrorNo.intValue())), 100);
                    this.tabbedPane.setPackageLoadSortRsp(null);
                }
            }
        } else {
            this.tabbedPane.setThreadStop(true);
            this.m_oprogressDlg.setProgress(ResourceManager.getInstance().getResString("LOAD_PACKAGE"), ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCoide)), 100);
            this.tabbedPane.setPackageLoadSortRsp(null);
        }
    }

    @Override
    public void getGroupInfoForSimulationPkgTask(AsnDCDefaultActiveGroupReq groupReq, ActivationPackagePanel activationPackagePanel) {
        this.requestIdForActivation = groupReq.oReqID.intValue();
        this.activationPackagePanel = activationPackagePanel;
        this.m_oprogressDlg = activationPackagePanel.getProgressDlg();
        this.activeGroupRsp = activationPackagePanel.getActiveGroupRspTemp();
        int errorcode = this.sendSyncMsg(43943, (FStruct)groupReq);
        if (errorcode != 0) {
            activationPackagePanel.setThreadStop(true);
            this.m_oprogressDlg.setProgress(ResourceManager.getInstance().getResString("ACTIVATION"), ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(-1L)), 100);
            activationPackagePanel.setActiveGroupRspTemp(null);
        }
        this.m_oprogressDlg.setVisible(true);
    }

    @Override
    public void queryBoardsResetInformation(AsnDCGetBDResetInfoReq oGetBDResetInfoReq, String strTaskName, List<Resource> unSupportQueryDevList) throws DCException {
        AsnDCOpertionRsp oAsnDCOperationRsp = new AsnDCOpertionRsp();
        this.queryResetDlg = new QueryBoardResetInfoDlg(oGetBDResetInfoReq.oAsnBDResetInfoLst.size(), strTaskName, unSupportQueryDevList);
        TaskAsynCommControllerProxy.queryBoardsResetInformation(oGetBDResetInfoReq, strTaskName, unSupportQueryDevList, oAsnDCOperationRsp);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TaskAsynCommController.this.queryResetDlg.setVisible(true);
            }
        });
    }

    private void handleDeviceDelayRebootResponse(MSGPacketExt packetExt) {
        final AsnDCDeviceBoardNotification oAsnDCDeviceBoardNotification = new AsnDCDeviceBoardNotification();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnDCDeviceBoardNotification, packetExt.getData());
        if (0 == iErrorCode) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!oAsnDCDeviceBoardNotification.bIsFinal) {
                        int iDevId = oAsnDCDeviceBoardNotification.oVersionInfo.iDeviceId.intValue();
                        int ErrorCode = oAsnDCDeviceBoardNotification.oErrorInfo.iErrorNo.intValue();
                        if (ErrorCode == 0) {
                            ErrorCode = oAsnDCDeviceBoardNotification.oVersionInfo.iSupportDelayReboot.intValue();
                        }
                        String error = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(ErrorCode));
                        DeviceInfo deviceInfo = DCFrameWorkUtil.getDeviceInfoManager().getDevice(iDevId);
                        String strDisplayName = "";
                        if (null != deviceInfo) {
                            String devName = deviceInfo.getDevName();
                            String devIPAdd = deviceInfo.getDevIPAddress();
                            strDisplayName = devName + '(' + devIPAdd + ')';
                        } else {
                            strDisplayName = ResourceManager.getInstance().getResString("TABLE_DEVICEID") + " : " + iDevId;
                            error = ResourceManager.getInstance().getResString("DEVICE_DELETED");
                        }
                        if (null != TaskAsynCommController.this.m_progressDlg && TaskAsynCommController.this.m_progressDlg.getProgressDlgId() == oAsnDCDeviceBoardNotification.oProgressInfo.oReqID.intValue()) {
                            TaskAsynCommController.this.m_progressDlg.setProgress(strDisplayName, error, oAsnDCDeviceBoardNotification.oProgressInfo.iPercentageProgress.intValue(), iDevId);
                        }
                    }
                }
            });
        }
    }

    private void handleDeviceISSUResponse(MSGPacketExt packetExt) {
        final AsnDCSupportISSURsp oAsnCheckISSURsp = new AsnDCSupportISSURsp();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnCheckISSURsp, packetExt.getData());
        if (0 == iErrorCode) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int iReqId = oAsnCheckISSURsp.oReqID.intValue();
                    int iDevId = oAsnCheckISSURsp.iDevId.intValue();
                    int ErrorCode = oAsnCheckISSURsp.oErrorInfo.iErrorNo.intValue();
                    String error = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(ErrorCode));
                    DeviceInfo deviceInfo = DCFrameWorkUtil.getDeviceInfoManager().getDevice(iDevId);
                    String strDisplayName = "";
                    if (null != deviceInfo) {
                        String devName = deviceInfo.getDevName();
                        String devIPAdd = deviceInfo.getDevIPAddress();
                        strDisplayName = devName + '(' + devIPAdd + ')';
                    } else {
                        strDisplayName = ResourceManager.getInstance().getResString("TABLE_DEVICEID") + " : " + iDevId;
                        error = ResourceManager.getInstance().getResString("DEVICE_DELETED");
                    }
                    if (null != TaskAsynCommController.this.m_progressDlg && TaskAsynCommController.this.m_progressDlg.getProgressDlgId() == iReqId) {
                        TaskAsynCommController.this.m_progressDlg.setProgress(strDisplayName, error, -1, iDevId);
                    }
                }
            });
        }
    }

    private void updateGroupingActivationInfoNotification(MSGPacketExt oPacketExt) {
        DCDebugTracer.trace("method TaskAsynCommController#updateGroupingActivationInfoNotification start");
        DCDebugTracer.trace("oPacketExt.mheader.cmdCode :" + oPacketExt.mheader.cmdCode);
        if (this.activationPackagePanel != null) {
            if (this.activationPackagePanel.getThreadStop()) {
                return;
            }
        } else {
            if (null != this.m_oRecoverPanel) {
                this.updateRecoverActivationInfoNotification(oPacketExt);
                return;
            }
            return;
        }
        try {
            Thread.sleep(500L);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        AsnDCDefaultActiveGroupRsp groupingActiveRsp = new AsnDCDefaultActiveGroupRsp();
        int iErrorCoide = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)groupingActiveRsp, oPacketExt.getData());
        if (iErrorCoide == 0) {
            if (this.requestIdForActivation != groupingActiveRsp.oReqID.intValue()) {
                return;
            }
            AsnDCActivationGroupLst oActiveGroupLstPart = groupingActiveRsp.oActiveGroupLst;
            AsnDCErrorCodeInfo errorCodeInfoPart = groupingActiveRsp.oErrorNo;
            this.activeGroupRsp.oActiveGroupLst.addAll((Collection)oActiveGroupLstPart);
            this.activeGroupRsp.oErrorNo = errorCodeInfoPart;
            AsnStResErrorInfoLst oStResErrorInfoLst = groupingActiveRsp.oStResErrorInfoLst;
            if (groupingActiveRsp.bIsLastInfo) {
                if (this.activeGroupRsp.oErrorNo.iErrorNo.intValue() == 0) {
                    if (oStResErrorInfoLst.size() > 0) {
                        ArrayList rowList = new ArrayList();
                        int errorListSize = oStResErrorInfoLst.size();
                        String str = ResourceManager.getInstance().getResString("ACTIVATION");
                        for (int i = 0; i < errorListSize; ++i) {
                            AsnStResErrorInfo errorInfo = (AsnStResErrorInfo)oStResErrorInfoLst.get(i);
                            Vector<String> vecRow = new Vector<String>(0);
                            DeviceInfo oDeviceInfo = DeviceInfoManagerImpl.getInstance().getDevice(errorInfo.iDeviceID.intValue());
                            String devName = str + "_" + oDeviceInfo.getDevName();
                            String result = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(errorInfo.oErrorInfo.iErrorNo.intValue()));
                            vecRow.add(devName);
                            vecRow.add(result);
                            rowList.add(vecRow);
                        }
                        this.activationPackagePanel.setThreadStop(true);
                        this.m_oprogressDlg.setProgress(rowList, 100);
                        this.activationPackagePanel.setActiveGroupRspTemp(null);
                    } else {
                        this.activationPackagePanel.setThreadStop(true);
                        this.m_oprogressDlg.setProgress(ResourceManager.getInstance().getResString("ACTIVATION"), ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(0L)), 100);
                        this.activationPackagePanel.setActiveGroupRspTemp(this.activeGroupRsp);
                    }
                } else {
                    this.activationPackagePanel.setThreadStop(true);
                    this.m_oprogressDlg.setProgress(ResourceManager.getInstance().getResString("ACTIVATION"), ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(this.activeGroupRsp.oErrorNo.iErrorNo.intValue())), 100);
                    this.activationPackagePanel.setActiveGroupRspTemp(null);
                }
            }
        } else {
            this.activationPackagePanel.setThreadStop(true);
            this.m_oprogressDlg.setProgress(ResourceManager.getInstance().getResString("ACTIVATION"), ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCoide)), 100);
            this.activationPackagePanel.setActiveGroupRspTemp(null);
        }
        DCDebugTracer.trace("method TaskAsynCommController#updateGroupingActivationInfoNotification end..");
    }

    @Override
    public void getGroupInfoForDiffusionTaskRsp(AsnDCDefaultGroupActivateForDiffusionReq req, ActivationPackagePanel activationPackagePanel) {
        this.m_oRecoverPanel = null;
        this.activationPackagePanel = activationPackagePanel;
        this.requestIdForActivation = req.oReqID.intValue();
        this.m_oprogressDlg = activationPackagePanel.getProgressDlg();
        this.activeGroupRsp = activationPackagePanel.getActiveGroupRspTemp();
        int errorcode = this.sendSyncMsg(43957, (FStruct)req);
        if (errorcode != 0) {
            activationPackagePanel.setThreadStop(true);
            this.m_oprogressDlg.setProgress(ResourceManager.getInstance().getResString("ACTIVATION"), ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(-1L)), 100);
            activationPackagePanel.setActiveGroupRspTemp(null);
        }
        this.m_oprogressDlg.setVisible(true);
    }

    @Override
    public void getGroupInfoForDevLevelTaskRsp(AsnDCDefaultActiveGroupForDevLevelReq req, GroupingAtivePanel devLevelGroupingAtivePanel) {
        this.requestIdForActivation = req.oReqID.intValue();
        this.activationPackagePanel = devLevelGroupingAtivePanel;
        this.m_oprogressDlg = this.activationPackagePanel.getProgressDlg();
        this.activeGroupRsp = this.activationPackagePanel.getActiveGroupRspTemp();
        int errorcode = this.sendSyncMsg(44066, (FStruct)req);
        if (errorcode != 0) {
            this.activationPackagePanel.setThreadStop(true);
            this.m_oprogressDlg.setProgress(ResourceManager.getInstance().getResString("ACTIVATION"), ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(-1L)), 100);
            this.activationPackagePanel.setActiveGroupRspTemp(null);
        }
        this.m_oprogressDlg.setVisible(true);
    }

    @Override
    public void getRecoverGroupInfo(AsnDCDefaultGroupActivateForDiffusionReq oReq, RecoverAndActivateDBPanel oRecoverPanel) {
        this.activationPackagePanel = null;
        this.m_oRecoverPanel = oRecoverPanel;
        this.requestIdForActivation = oReq.oReqID.intValue();
        this.m_oprogressDlg = this.m_oRecoverPanel.getProgressDlg();
        this.activeGroupRsp = this.m_oRecoverPanel.getRecoverGroupRspTemp();
        int errorcode = this.sendSyncMsg(43957, (FStruct)oReq);
        if (errorcode != 0) {
            this.m_oRecoverPanel.setThreadStop(true);
            this.m_oprogressDlg.setProgress(ResourceManager.getInstance().getResString("RECOVER"), ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(-1L)), 100);
            this.m_oRecoverPanel.setRecoverGroupRspTemp(null);
        }
        this.m_oprogressDlg.setVisible(true);
    }

    private void updateRecoverActivationInfoNotification(MSGPacketExt oPacketExt) {
        DCDebugTracer.trace("method TaskAsynCommController#updateRecoverActivationInfoNotification start");
        DCDebugTracer.trace("oPacketExt.mheader.cmdCode :" + oPacketExt.mheader.cmdCode);
        if (this.m_oRecoverPanel != null) {
            if (this.m_oRecoverPanel.getThreadStop()) {
                return;
            }
        } else {
            return;
        }
        try {
            Thread.sleep(500L);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        AsnDCDefaultActiveGroupRsp oRecoverGroupRsp = new AsnDCDefaultActiveGroupRsp();
        int iErrorCoide = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oRecoverGroupRsp, oPacketExt.getData());
        if (iErrorCoide == 0) {
            if (this.requestIdForActivation != oRecoverGroupRsp.oReqID.intValue()) {
                return;
            }
            AsnDCActivationGroupLst oActiveGroupLstPart = oRecoverGroupRsp.oActiveGroupLst;
            AsnDCErrorCodeInfo errorCodeInfoPart = oRecoverGroupRsp.oErrorNo;
            this.activeGroupRsp.oActiveGroupLst.addAll((Collection)oActiveGroupLstPart);
            this.activeGroupRsp.oErrorNo = errorCodeInfoPart;
            AsnStResErrorInfoLst oStResErrorInfoLst = oRecoverGroupRsp.oStResErrorInfoLst;
            if (oRecoverGroupRsp.bIsLastInfo) {
                if (this.activeGroupRsp.oErrorNo.iErrorNo.intValue() == 0) {
                    if (oStResErrorInfoLst.size() > 0) {
                        ArrayList rowList = new ArrayList();
                        int errorListSize = oStResErrorInfoLst.size();
                        String str = ResourceManager.getInstance().getResString("RECOVER");
                        for (int i = 0; i < errorListSize; ++i) {
                            AsnStResErrorInfo errorInfo = (AsnStResErrorInfo)oStResErrorInfoLst.get(i);
                            Vector<String> vecRow = new Vector<String>(0);
                            DeviceInfo oDeviceInfo = DeviceInfoManagerImpl.getInstance().getDevice(errorInfo.iDeviceID.intValue());
                            String devName = str + "_" + oDeviceInfo.getDevName();
                            String result = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(errorInfo.oErrorInfo.iErrorNo.intValue()));
                            vecRow.add(devName);
                            vecRow.add(result);
                            rowList.add(vecRow);
                        }
                        this.m_oRecoverPanel.setThreadStop(true);
                        this.m_oprogressDlg.setProgress(rowList, 100);
                        this.m_oRecoverPanel.setRecoverGroupRspTemp(null);
                    } else {
                        this.m_oRecoverPanel.setThreadStop(true);
                        this.m_oprogressDlg.setProgress(ResourceManager.getInstance().getResString("RECOVER"), ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(0L)), 100);
                        this.m_oRecoverPanel.setRecoverGroupRspTemp(this.activeGroupRsp);
                    }
                } else {
                    this.m_oRecoverPanel.setThreadStop(true);
                    this.m_oprogressDlg.setProgress(ResourceManager.getInstance().getResString("RECOVER"), ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(this.activeGroupRsp.oErrorNo.iErrorNo.intValue())), 100);
                    this.m_oRecoverPanel.setRecoverGroupRspTemp(null);
                }
            }
        } else {
            this.m_oRecoverPanel.setThreadStop(true);
            this.m_oprogressDlg.setProgress(ResourceManager.getInstance().getResString("RECOVER"), ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCoide)), 100);
            this.m_oRecoverPanel.setRecoverGroupRspTemp(null);
        }
        DCDebugTracer.trace("method TaskAsynCommController#updateRecoverActivationInfoNotification end..");
    }

    @Override
    public int checkActivationGroupInfo(AsnDCCheckActiveGroupInfoReq asnCheckActiveGoupInfoReq) {
        return TaskAsynCommControllerProxy.checkActivationGroupInfo(asnCheckActiveGoupInfoReq, this);
    }

    private void updateCheckActivationGroupInfoNotification(MSGPacketExt oPacketExt) {
        DCDebugTracer.trace("method TaskAsynCommController#updateCheckActivationGroupInfoNotification start");
        try {
            Thread.sleep(500L);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        AsnDCCheckActiveGroupInfoRsp asnCheckActiveGroupInfoRsp = new AsnDCCheckActiveGroupInfoRsp();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)asnCheckActiveGroupInfoRsp, oPacketExt.getData());
        if (0 != iErrorCode) {
            SynProgressDlg.getInstance().notifyError(iErrorCode, "");
        } else {
            SynProgressDlg.getInstance().notifyAsnMessage((FStruct)asnCheckActiveGroupInfoRsp);
        }
        DCDebugTracer.trace("method TaskAsynCommController#updateCheckActivationGroupInfoNotification end..");
    }

    @Override
    public void checkDevicesIsSupportDelayReboot(ProgressDlg progressDlg, int[] oDeviceIds) {
        int iReqId = DCFrameWorkUtil.generateRequestId();
        this.m_progressDlg = progressDlg;
        this.m_progressDlg.setProgressDlgId(iReqId);
        try {
            TaskAsynCommControllerProxy.checkDevicesIsSupportDelayReboot(iReqId, oDeviceIds);
        }
        catch (DCException e) {
            this.m_progressDlg.dispose();
            DCDebugTracer.trace(e);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TaskAsynCommController.this.m_progressDlg.showDetailInfo();
                TaskAsynCommController.this.m_progressDlg.setVisible(true);
            }
        });
    }

    @Override
    public DCErrorCode checkDevicesIsSupportISSU(ProgressDlg oProgressDlg, AsnDCSupportISSUReq oAsnCheckISSUReq) {
        this.m_progressDlg = oProgressDlg;
        DCErrorCode oErrInfo = TaskAsynCommControllerProxy.checkDevicesIsSupportISSU(oAsnCheckISSUReq);
        if (0 == oErrInfo.getErrorCode()) {
            this.m_progressDlg.showDetailInfo();
            this.m_progressDlg.setVisible(true);
        }
        return oErrInfo;
    }

    @Override
    public void getTaskLevelDevOprResultDetails(int iTaskId, THashSet<Resource> oResourceLst) {
        TaskAsynCommControllerProxy.getTaskLevelDevOprResultDetails(iTaskId, oResourceLst);
    }

    @Override
    public void getDeviceOperationLogs(int iTaskID, int iDevID, int iStackID) {
        TaskAsynCommControllerProxy.getDeviceOperationLogs(iTaskID, iDevID, iStackID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processDeviceOprLogs(MSGPacketExt oPacketExt) {
        long startTime = System.currentTimeMillis();
        DCDebugTracer.trace("[performance] processDeviceOprLogs start : " + startTime);
        AsnTaskDetailsResultInfoRsp oDevOprLogRsp = new AsnTaskDetailsResultInfoRsp();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oDevOprLogRsp, oPacketExt.getData());
        if (0 != iErrorCode) {
            DCDebugTracer.trace("[performance] processDeviceOprLogs iErrorCode : " + iErrorCode);
            return;
        }
        AsnTaskDetailsResultInfoLst oLogList = oDevOprLogRsp.oTaskDetailsResultInfoLst;
        int iTaskID = oDevOprLogRsp.iTaskId.intValue();
        int TASKID_INDEX = 0;
        int DEVID_INDEX = 1;
        List<Integer> oList = this.getTaskIDnResIDOfSelTask(iTaskID);
        if (null == oList || 0 == oList.size()) {
            return;
        }
        DCDebugTracer.trace("[performance] processDeviceOprLogs iTaskID : " + iTaskID);
        if (oList.get(TASKID_INDEX) != iTaskID) {
            return;
        }
        Resource oRes = null;
        oRes = this.getResource(iTaskID, oDevOprLogRsp.iDevId.intValue());
        if (null == oLogList) {
            byte[] byArray = this.m_oSyncObj;
            synchronized (this.m_oSyncObj) {
                oRes.getLogInfoObject().setToGetOldData(true);
                DCDebugTracer.trace("[progress abnormality] processDeviceOprLogs notify");
                this.m_oSyncObj.notifyAll();
                // ** MonitorExit[var12_11] (shouldn't be in output)
                DCDebugTracer.trace("[performance] processDeviceOprLogs oLogList is NULL;");
                return;
            }
        }
        AsnTaskDetailsResultInfo oOprLogInfo = null;
        int iSize = oLogList.size();
        DCDebugTracer.trace("[performance] processDeviceOprLogs oLogList.size : " + iSize);
        for (int i = 0; i < iSize; ++i) {
            oOprLogInfo = (AsnTaskDetailsResultInfo)oLogList.get(i);
            if (null == oOprLogInfo || null == (oRes = this.getResource(iTaskID, oOprLogInfo.oAsnTaskResource.iDeviceId.intValue()))) continue;
            oRes.getLogInfoObject().updateLogInfo(oOprLogInfo, iTaskID);
        }
        DCDebugTracer.trace("[performance] processDeviceOprLogs oDevOprLogRsp.bIsLastLog : " + oDevOprLogRsp.bIsLastLog);
        if (oDevOprLogRsp.bIsLastLog && null != oRes) {
            oRes.getLogInfoObject().setToGetOldData(true);
            if (oRes.getLogInfoObject().hasGotLogNotification()) {
                DCDebugTracer.trace("[progress abnormality] processDeviceOprLogs notify hasGotLogNotification");
                this.m_oSyncObj.notifyAll();
            }
        }
        if (null != oRes && oList.get(DEVID_INDEX).intValue() == oRes.getDeviceID()) {
            TaskEvent oTaskEvent = new TaskEvent(oRes, iTaskID, TaskEventID.DEVICE_OPR_LOG_UPDATION_EVENT, false);
            this.m_oLogEventNotifier.notifyOprLogEvent(oTaskEvent);
        }
        long endTime = System.currentTimeMillis();
        DCDebugTracer.trace("[performance] processDeviceOprLogs end : " + endTime + " Cost : " + (endTime - startTime));
    }

    private Resource getResource(int iTaskID, int iRspDevID) {
        Resource oRes = null;
        ITask oTask = TaskDataModel.getInstance().getTask(iTaskID);
        THashSet<Resource> oResList = oTask.getDeviceType().getResources();
        Iterator oResItor = oResList.iterator();
        while (oResItor.hasNext() && (oRes = (Resource)oResItor.next()).getDeviceID() != iRspDevID) {
        }
        return oRes;
    }

    public void setTaskTreeTableInstance(DCSortableTreeTable oTaskTreeTable) {
        this.m_oTaskTreeTable = oTaskTreeTable;
    }

    private List<Integer> getTaskIDnResIDOfSelTask(int iTaskID) {
        ArrayList<Integer> oList = new ArrayList<Integer>();
        ITask oTmpTask = TaskDataModel.getInstance().getTask(iTaskID);
        if (null == oTmpTask) {
            return oList;
        }
        if (IsolationCommonOperation.isIsolationTask(oTmpTask.getTaskTypeId())) {
            IsolationTaskInfoObj oIsolationDevInfo;
            List<IsolationTaskInfoObj> oSelectInfoLst;
            IsolationTaskInfoPanel oIsolationTaskInfoPanel = DCFrameWorkUtil.getIsolationTaskInfoPanel();
            if (null != oIsolationTaskInfoPanel && 1 == (oSelectInfoLst = oIsolationTaskInfoPanel.getSelectedNodeInfos()).size() && 2 == (oIsolationDevInfo = oSelectInfoLst.get(0)).getNodeType()) {
                oList.add(oIsolationDevInfo.getTaskId());
                oList.add(oIsolationDevInfo.getDevId());
            }
        } else {
            TreeTableNode oNode = null;
            TreeTableRowData oData = null;
            Resource oTaskTableSelectedRes = null;
            int iSelectedTaskID = -1;
            if (!TaskTableUtil.isAResourceOnlySelection(this.m_oTaskTreeTable)) {
                return null;
            }
            int iSelectedRow = this.m_oTaskTreeTable.getSelectedRow();
            TreePath oTreePath = this.m_oTaskTreeTable.getTree().getPathForRow(iSelectedRow);
            TreeTableNode oTaskNode = null;
            TreeTableRowData oTaskObject = null;
            Task oTask = null;
            if (null != oTreePath && null != (oNode = (TreeTableNode)oTreePath.getLastPathComponent())) {
                oTaskNode = (TreeTableNode)oNode.getParent();
                oTaskObject = (TreeTableRowData)oTaskNode.getUserObject();
                if (oTaskObject.getUserObject() instanceof Task) {
                    oTask = (Task)oTaskObject.getUserObject();
                    iSelectedTaskID = oTask.getTaskId();
                    oList.add(iSelectedTaskID);
                }
                oData = (TreeTableRowData)oNode.getUserObject();
                oTaskTableSelectedRes = (Resource)oData.getUserObject();
                oList.add(oTaskTableSelectedRes.getDeviceID());
            }
        }
        return oList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void processDeviceOprLogNotification(MSGPacketExt oPacketExt) {
        DCDebugTracer.trace("Method processDeviceOprLogNotification start");
        int[] iRows = this.m_oTaskTreeTable.getSelectedRows();
        if (null != iRows && (0 == iRows.length || 1 < iRows.length)) {
            DCDebugTracer.trace("TaskAsynCommController#processDeviceOprLogNotification  --> null != iRows && (0 == iRows.length || 1 < iRows.length)");
            return;
        }
        AsnTaskDetailsResultInfoRsp oDevOprLogRsp = new AsnTaskDetailsResultInfoRsp();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oDevOprLogRsp, oPacketExt.getData());
        if (0 != iErrorCode) {
            DCDebugTracer.trace("TaskAsynCommController#processDeviceOprLogNotification  --> DCConstants.SUCCESS_RESPONSE_CODE != iErrorCode ");
            return;
        }
        int iTaskID = oDevOprLogRsp.iTaskId.intValue();
        int TASKID_INDEX = 0;
        int DEVID_INDEX = 1;
        List<Integer> oList = this.getTaskIDnResIDOfSelTask(iTaskID);
        if (null == oList || 0 == oList.size()) {
            DCDebugTracer.trace("TaskAsynCommController#processDeviceOprLogNotification  --> null == oList || 0 == oList.size()");
            return;
        }
        AsnTaskDetailsResultInfoLst oLogList = oDevOprLogRsp.oTaskDetailsResultInfoLst;
        if (oList.get(TASKID_INDEX) != iTaskID) {
            DCDebugTracer.trace("TaskAsynCommController#processDeviceOprLogNotification  --> ((Integer)oList.get(TASKID_INDEX)).intValue() != iTaskID");
            return;
        }
        AsnTaskDetailsResultInfo oOprLogInfo = null;
        if (null == oLogList) {
            DCDebugTracer.trace("TaskAsynCommController#processDeviceOprLogNotification  --> null == oLogList");
            return;
        }
        int iSize = oLogList.size();
        Resource oRes = null;
        try {
            DCDebugTracer.trace("TaskAsynCommController#processDeviceOprLogNotification : the size of log is " + iSize);
            for (int i = 0; i < iSize; ++i) {
                oOprLogInfo = (AsnTaskDetailsResultInfo)oLogList.get(i);
                if (null == oOprLogInfo || null == (oRes = this.getResource(iTaskID, oOprLogInfo.oAsnTaskResource.iDeviceId.intValue()))) continue;
                if (oList.get(DEVID_INDEX).intValue() != oRes.getDeviceID()) {
                    return;
                }
                if (oRes.getLogInfoObject().hasGotOldData()) {
                    oRes.getLogInfoObject().updateLogInfo(oOprLogInfo, iTaskID);
                    oRes.getLogInfoObject().setGotLogNotification(false);
                    continue;
                }
                oRes.getLogInfoObject().setGotLogNotification(true);
                byte[] byArray = this.m_oSyncObj;
                // MONITORENTER : this.m_oSyncObj
                DCDebugTracer.trace("[progress abnormality] processDeviceOprLogNotification  wait ");
                this.m_oSyncObj.wait(this.getPreCheckItemTimeoutNumber());
                // MONITOREXIT : byArray
                oRes.getLogInfoObject().updateLogInfo(oOprLogInfo, iTaskID);
                oRes.getLogInfoObject().setGotLogNotification(false);
            }
        }
        catch (InterruptedException e) {
            DCDebugTracer.trace(e);
        }
        if (null != oRes && oList.get(DEVID_INDEX).intValue() == oRes.getDeviceID()) {
            DCDebugTracer.trace("TaskAsynCommController#processDeviceOprLogNotification  --> m_oLogEventNotifier.notifyOprLogEvent --- > start");
            TaskEvent oTaskEvent = new TaskEvent(oRes, iTaskID, TaskEventID.DEVICE_OPR_LOG_UPDATION_EVENT, false);
            this.m_oLogEventNotifier.notifyOprLogEvent(oTaskEvent);
            DCDebugTracer.trace("TaskAsynCommController#processDeviceOprLogNotification  --> m_oLogEventNotifier.notifyOprLogEvent --- > End");
        }
        DCDebugTracer.trace("Method processDeviceOprLogNotification end");
    }

    @Override
    public void updateDevUpgradeMode(MSGPacketExt oPacketExt) {
        DCDebugTracer.trace("[upgrade mode] method updateDevUpgradeMode start.");
        AsnGetDevUpgradeModeRsp oAsnGetDevUpgradeModeRsp = new AsnGetDevUpgradeModeRsp();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnGetDevUpgradeModeRsp, oPacketExt.getData());
        AsnDevUpgrModeInfoLst oDevUpgrModeInfoLst = oAsnGetDevUpgradeModeRsp.oDevUpgrModeInfoLst;
        for (int i = 0; i < oDevUpgrModeInfoLst.size(); ++i) {
            AsnDevUpgrModeInfo oDevUpgrModeInfo = (AsnDevUpgrModeInfo)oDevUpgrModeInfoLst.get(i);
            if (null == oDevUpgrModeInfo) continue;
            DCDebugTracer.trace("oDevUpgrModeInfo:iUpgradeMode-->" + oDevUpgrModeInfo.iUpgradeMode + "DevIndex:" + i);
        }
        if (0 != iErrorCode) {
            DCDebugTracer.trace("[upgrade mode] updateDevUpgradeMode have error : " + iErrorCode);
            SynProgressDlg.getInstance().notifyError(iErrorCode, "");
        }
        TaskEvent oTaskEvent = new TaskEvent(oAsnGetDevUpgradeModeRsp, TaskEventID.UPGRADE_MODE_VALIDATION);
        TaskInfoNotifier.getInstance().notifyTaskEvent(oTaskEvent);
        DCDebugTracer.trace("[upgrade mode] method updateDevUpgradeMode end.");
    }

    private int getPreCheckItemTimeoutNumber() {
        DCDebugTracer.trace("TaskAsynCommController#getPreCheckItemTimeoutNumber---start");
        int timeOutNum = -1;
        String oTimeout = ResourceManager.getInstance().getResString("PRECHECK_ITEM_TIME_OUT", "config");
        try {
            timeOutNum = Integer.parseInt(oTimeout);
        }
        catch (NumberFormatException e) {
            timeOutNum = 0;
        }
        DCDebugTracer.trace("TaskAsynCommController#getPreCheckItemTimeoutNumber---end.. timeOutNum : " + timeOutNum);
        return timeOutNum;
    }

    private void handleDelTaskListSuccessResponse(MSGPacketExt oPacketExt) {
        AsnDeleteTaskReq oAsnDeleteTaskRsp = new AsnDeleteTaskReq();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnDeleteTaskRsp, oPacketExt.getData());
        if (0 != iErrorCode) {
            DCDebugTracer.trace("handleDelTaskListFailResponse:" + iErrorCode);
            return;
        }
        ArrayList<Integer> oTaskIDLst = new ArrayList<Integer>();
        int iTaskCount = oAsnDeleteTaskRsp.size();
        for (int i = 0; i < iTaskCount; ++i) {
            int iTaskId = ((BigInteger)oAsnDeleteTaskRsp.get(i)).intValue();
            oTaskIDLst.add(iTaskId);
            TaskDataModel.getInstance().removeTask(iTaskId);
            CopyModifyTaskDialog copyModifyTaskDialog = this.copyModifyTaskDialogMap.get(iTaskId);
            this.delCurModifyTaskSession(iTaskId);
            if (copyModifyTaskDialog == null) continue;
            DCDebugTracer.trace("[DelTask] task del by other client|iTaskId=" + iTaskId);
            DCOptionPane.showMessageDialog((Component)((Object)copyModifyTaskDialog), ResourceManager.getInstance().getResString("TASK_ALREADY_DELETED"), ResourceManager.getInstance().getResString("CONFIRM_DIALOG_TITLE"), 1);
            copyModifyTaskDialog.dispose();
        }
        TaskEvent oTaskEvent = new TaskEvent(oTaskIDLst, TaskEventID.TASK_DELETION);
        TaskInfoNotifier.getInstance().notifyTaskEvent(oTaskEvent);
        if (null != DCFrameWorkUtil.getIsolationTaskInfoPanel()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DCFrameWorkUtil.getIsolationTaskInfoPanel().closeIsolationPanelByNotify();
                }
            });
        }
    }

    private void queryBoardResetInfoResponse(MSGPacketExt oPacketExt) {
        AsnDCSIBoardInfoRsp oAsnDCSIBoardInfoRsp = new AsnDCSIBoardInfoRsp();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnDCSIBoardInfoRsp, oPacketExt.getData());
        if (0 != iErrorCode) {
            DCFrameWorkUtil.setCursor(Cursor.getPredefinedCursor(0));
            DCDebugTracer.trace("DC::TaskAsynCommController::queryBoardResetInfoResponse() :: decode failed");
            return;
        }
        if (null != this.queryResetDlg) {
            this.queryResetDlg.insertBoardResetInfo(oAsnDCSIBoardInfoRsp);
        }
    }

    private void handleMainBoardNumResponse(MSGPacketExt oPacketExt) {
        AsnDCMainBoardNumRsp oRsp = new AsnDCMainBoardNumRsp();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oRsp, oPacketExt.getData());
        if (0 != iErrorCode) {
            DCFrameWorkUtil.setCursor(Cursor.getPredefinedCursor(0));
            DCDebugTracer.trace("DC::TaskAsynCommController::queryBoardResetInfoResponse() :: decode failed");
            return;
        }
        DCFrameWorkUtil.getTaskTablePanel().handleMainBoardNumResponse(oRsp);
    }

    @Override
    public void refreshSWDLStatus(int iReqId, int iTaskID, List devIDs) throws DCException {
        TaskAsynCommControllerProxy.refreshSWDLStatus(iReqId, iTaskID, devIDs);
    }

    @Override
    public void setOSPFStatus(int iReqId, boolean openCmd, List<Integer> devIDLst) throws DCException {
        TaskAsynCommControllerProxy.setOSPFStatus(iReqId, openCmd, devIDLst);
    }

    @Override
    public void queryOperation(AsnToleranceSearchReq oAsnIsolationSearchReq) throws DCException {
        TaskAsynCommControllerProxy.queryOperation(oAsnIsolationSearchReq);
    }

    @Override
    public void setCurModifyTask(Integer taskId, CopyModifyTaskDialog currModifyTaskDlg) {
        if (null == currModifyTaskDlg) {
            return;
        }
        this.copyModifyTaskDialogMap.put(taskId, currModifyTaskDlg);
    }

    @Override
    public void delCurModifyTaskSession(Integer taskId) {
        this.copyModifyTaskDialogMap.remove(taskId);
    }

    private int sendSyncMsg(int iCmdCode, FStruct oSendData) {
        AsnDCSyncRsp oRsp = new AsnDCSyncRsp();
        BaseCommManager commManager = DCFrameWorkUtil.getCommManager();
        int iErrCode = commManager.sendSyncMsgWithSyncCommand(iCmdCode, oSendData, (FStruct)oRsp);
        if (0 == iErrCode) {
            iErrCode = oRsp.oErrorInfo.iErrorNo.intValue();
        }
        return iErrCode;
    }

    @Override
    public void getModifySingleNEActiveGroupOperation(final AsnDCGetActGroupBoardInfoReq oAsnDCGetActGroupBoardInfoReq, final AsnDCOpertionRsp oAsnDCOpertionRsp) throws DCException {
        int iErrorCode = 0;
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int iErrorCode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(44090), (FStruct)oAsnDCGetActGroupBoardInfoReq, (FStruct)oAsnDCOpertionRsp);
                return iErrorCode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (null != syncCommand.getResult()) {
            iErrorCode = (Integer)syncCommand.getResult();
        }
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
        iErrorCode = oAsnDCOpertionRsp.oErrorInfo.iErrorNo.intValue();
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(oAsnDCOpertionRsp.oErrorInfo.iErrorNo));
        }
    }

    @Override
    public void setModifySingleNEActiveGroupOperation(final AsnDCActGroupBoardInfo oAsnDCGetActGroupBoardInfoResult, final AsnDCOpertionRsp oAsnDCOpertionRsp) throws DCException {
        int iErrorCode = 0;
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int iErrorCode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(44091), (FStruct)oAsnDCGetActGroupBoardInfoResult, (FStruct)oAsnDCOpertionRsp);
                return iErrorCode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (null != syncCommand.getResult()) {
            iErrorCode = (Integer)syncCommand.getResult();
        }
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
        iErrorCode = oAsnDCOpertionRsp.oErrorInfo.iErrorNo.intValue();
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(oAsnDCOpertionRsp.oErrorInfo.iErrorNo));
        }
    }

    @Override
    public void setFreeIsolationDeviceOperation(final AsnFreeIsolationDeviceReq oAsnFreeIsolationDeviceReq, final AsnDCOpertionRsp oAsnDCOpertionRsp) {
        int iErrorCode = 0;
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int iErrorCode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(54102), (FStruct)oAsnFreeIsolationDeviceReq, (FStruct)oAsnDCOpertionRsp);
                return iErrorCode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (null != syncCommand.getResult()) {
            iErrorCode = (Integer)syncCommand.getResult();
        }
        if (iErrorCode != 0) {
            DCDebugTracer.trace("setFreeIsolationDeviceOperation Send Fail:" + iErrorCode);
            return;
        }
        iErrorCode = oAsnDCOpertionRsp.oErrorInfo.iErrorNo.intValue();
        if (iErrorCode != 0) {
            DCDebugTracer.trace("setFreeIsolationDeviceOperation#oAsnDCOpertionRsp.oErrorInfo.iErrorNo:" + iErrorCode);
            return;
        }
    }

    static {
        LISTENER_ARRAY = new int[]{43871, 43833, 43920, 43921, 43922, 44088, 43946, 44051, 43957, 43943, 43988, 43942, 43965, 43961, 43984, 43998, 44074, 43900, 44001, 44033, 44064, 44066, 43904, 43905, 43964, 44057, 44073, 43872, 43877, 44084, 44085, 43962, 44094, 54102};
    }
}

