/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.controller;

import com.huawei.dc.common.asndatacenter.AsnDCActGroupBoardInfo;
import com.huawei.dc.common.asndatacenter.AsnDCBoardInfo4ActGrp;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.devicemanagement.deviceoperation.activationgroupfordevice.GroupingBdActForSingleDevDlg;
import com.huawei.dc.devicemanagement.deviceoperation.activationgroupfordevice.RowData;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.model.Resource;
import com.swimap.iview.communicate.MSGListener;
import com.swimap.iview.communicate.MSGPacketExt;
import com.swimap.iview.communicate.MSGReceiver;
import java.awt.Component;
import java.util.Vector;
import net.commustru.fstru.FStruct;

public class TaskAsnyCommForDev
extends MSGReceiver
implements IDCObjectDeallocator {
    private static TaskAsnyCommForDev m_TaskAsnyCommForDev;
    private long firstOpenClientTime = -1L;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.firstOpenClientTime ^ this.firstOpenClientTime >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskAsnyCommForDev other = (TaskAsnyCommForDev)obj;
        return this.firstOpenClientTime == other.firstOpenClientTime;
    }

    private TaskAsnyCommForDev() {
        this.addMessageListener();
    }

    public static synchronized TaskAsnyCommForDev getInstance() {
        if (null == m_TaskAsnyCommForDev) {
            m_TaskAsnyCommForDev = new TaskAsnyCommForDev();
            DCObjectDestructor.getInstance().addObjectForDestructor(m_TaskAsnyCommForDev);
        }
        return m_TaskAsnyCommForDev;
    }

    protected void processMessage(MSGPacketExt oPacketExt) {
        DCDebugTracer.trace("receive asyn msg cmdCode=" + oPacketExt.mheader.cmdCode);
        switch (oPacketExt.mheader.cmdCode) {
            case 44090: {
                this.processGetSingleDevActiveGroupRsp(oPacketExt);
                break;
            }
            case 44091: {
                this.processSetSingleDevActiveGroupRsp(oPacketExt);
                break;
            }
        }
        DCDebugTracer.trace("method TaskAsynCommForDevOprLogWait#processMessage end..");
    }

    private void addMessageListener() {
        DCFrameWorkUtil.getCommManager().addMessageListener(44090, (MSGListener)this);
        DCFrameWorkUtil.getCommManager().addMessageListener(44091, (MSGListener)this);
    }

    private void removeMessageListener() {
        if (null != DCFrameWorkUtil.getCommManager()) {
            DCFrameWorkUtil.getCommManager().removeMessageListener(44090, (MSGListener)this);
            DCFrameWorkUtil.getCommManager().removeMessageListener(44091, (MSGListener)this);
        }
    }

    public void processGetSingleDevActiveGroupRsp(MSGPacketExt oPacketExt) {
        DCDebugTracer.trace("Method processGetSingleDevActiveGroupRsp start");
        AsnDCActGroupBoardInfo oAsnDCActGroupBoardInfoRsp = new AsnDCActGroupBoardInfo();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnDCActGroupBoardInfoRsp, oPacketExt.getData());
        if (0 != iErrorCode) {
            DCDebugTracer.trace("TaskAsnyCommForDev#processGetSingleDevActiveGroupRsp  --> DCConstants.SUCCESS_RESPONSE_CODE !=" + iErrorCode);
            DCFrameWorkUtil.getTaskTablePanel().handSingleDeviceGetActiveGroupRsp(0, 0);
            return;
        }
        if (null != oAsnDCActGroupBoardInfoRsp.oErrorInfo && 0 != oAsnDCActGroupBoardInfoRsp.oErrorInfo.iErrorNo.intValue()) {
            DCFrameWorkUtil.getTaskTablePanel().handSingleDeviceGetActiveGroupRsp(0, 0);
            int errorCode = oAsnDCActGroupBoardInfoRsp.oErrorInfo.iErrorNo.intValue();
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), errorCode, ResourceManager.getInstance().getResString("ERROR"), 0);
            DCFrameWorkUtil.getTaskTablePanel().handSingleDeviceGetActiveGroupRsp(0, 0);
            return;
        }
        if (null != oAsnDCActGroupBoardInfoRsp.oErrorInfo && 0 == oAsnDCActGroupBoardInfoRsp.oErrorInfo.iErrorNo.intValue() && (null == oAsnDCActGroupBoardInfoRsp.oAsnDCBoardInfo4ActGrpLst || 0 == oAsnDCActGroupBoardInfoRsp.oAsnDCBoardInfo4ActGrpLst.size())) {
            DCFrameWorkUtil.getTaskTablePanel().handSingleDeviceGetActiveGroupRsp(0, 0);
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("DEVICE_IS_NOT_IN_WAIT_ACTIVE"), ResourceManager.getInstance().getResString("INFO"), 1);
            DCFrameWorkUtil.getTaskTablePanel().handSingleDeviceGetActiveGroupRsp(0, 0);
            return;
        }
        int devId = oAsnDCActGroupBoardInfoRsp.iDeviceID.intValue();
        int reqId = oAsnDCActGroupBoardInfoRsp.iRequestID.intValue();
        int lastReqId = 0;
        if (null == DCFrameWorkUtil.getTaskTablePanel().getResultDlg()) {
            DCDebugTracer.trace("Method processGetSingleDevActiveGroupRsp m_oCommProgressDlg is null.");
            return;
        }
        lastReqId = DCFrameWorkUtil.getTaskTablePanel().getResultDlg().getProgressDlgId();
        if (lastReqId != reqId) {
            DCDebugTracer.trace("Method processGetSingleDevActiveGroupRsp lastReqId=" + lastReqId);
            DCDebugTracer.trace("Method processGetSingleDevActiveGroupRsp reqId=" + reqId);
            DCDebugTracer.trace("Method processGetSingleDevActiveGroupRsp requetId is not correct.");
            return;
        }
        DCFrameWorkUtil.getTaskTablePanel().handSingleDeviceGetActiveGroupRsp(devId, reqId);
        int boardSize = oAsnDCActGroupBoardInfoRsp.oAsnDCBoardInfo4ActGrpLst.size();
        Vector<TreeTableNode> boardList = new Vector<TreeTableNode>();
        for (int i = 0; i < boardSize; ++i) {
            AsnDCBoardInfo4ActGrp oAsnDCBoardInfo4ActGrp = (AsnDCBoardInfo4ActGrp)oAsnDCActGroupBoardInfoRsp.oAsnDCBoardInfo4ActGrpLst.get(i);
            int groupId = oAsnDCBoardInfo4ActGrp.iGroupId.intValue();
            int slotId = oAsnDCBoardInfo4ActGrp.iSlotId.intValue();
            String boardName = new String(oAsnDCBoardInfo4ActGrp.strBoardName);
            int resetInfo = oAsnDCBoardInfo4ActGrp.enActiveDeviceMode.value;
            Resource boardRes = new Resource();
            boardRes.setBoardTypeName(boardName);
            boardRes.setSlotId(slotId);
            boardRes.setBoardResetType(resetInfo);
            RowData boardNodeInfo = new RowData(groupId, boardRes, 4, boardRes.getDeviceType());
            TreeTableNode devNode = new TreeTableNode(boardNodeInfo);
            boardList.add(devNode);
        }
        try {
            new GroupingBdActForSingleDevDlg(boardList, devId);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    public void processSetSingleDevActiveGroupRsp(MSGPacketExt oPacketExt) {
        DCDebugTracer.trace("Method processSetSingleDevActiveGroupRsp start");
        AsnDCActGroupBoardInfo oAsnDCActGroupBoardInfoRsp = new AsnDCActGroupBoardInfo();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnDCActGroupBoardInfoRsp, oPacketExt.getData());
        if (0 != iErrorCode) {
            DCDebugTracer.trace("TaskAsnyCommForDev#processGetSingleDevActiveGroupRsp  --> DCConstants.SUCCESS_RESPONSE_CODE !=" + iErrorCode);
            return;
        }
        int devId = oAsnDCActGroupBoardInfoRsp.iDeviceID.intValue();
        int reqId = oAsnDCActGroupBoardInfoRsp.iRequestID.intValue();
        int lastReqId = 0;
        if (null == DCFrameWorkUtil.getTaskTablePanel().getResultDlg()) {
            DCDebugTracer.trace("Method processGetSingleDevActiveGroupRsp m_oCommProgressDlg is null.");
            return;
        }
        lastReqId = DCFrameWorkUtil.getTaskTablePanel().getResultDlg().getProgressDlgId();
        if (lastReqId != reqId) {
            DCDebugTracer.trace("Method processGetSingleDevActiveGroupRsp lastReqId=" + lastReqId);
            DCDebugTracer.trace("Method processGetSingleDevActiveGroupRsp reqId=" + reqId);
            DCDebugTracer.trace("Method processGetSingleDevActiveGroupRsp requetId is not correct.");
            return;
        }
        String strOperationResult = ErrorCodeReader.getInstance().getErrorDesc(oAsnDCActGroupBoardInfoRsp.oErrorInfo.iErrorNo);
        DCFrameWorkUtil.getTaskTablePanel().getResultDlg().setProgress(devId, DeviceInfoManagerImpl.getInstance().getResourceForID(devId).getDeviceName(), strOperationResult);
    }

    @Override
    public void setToNULL() {
        this.removeMessageListener();
        this.close();
        m_TaskAsnyCommForDev = null;
    }

    public void timeout(int arg0, Character arg1) {
    }
}

