/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.controller;

import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.taskmgmt.controller.UpModeChechAdapter;
import com.huawei.dc.taskmgmt.model.Resource;
import gnu.trove.THashSet;
import java.util.Iterator;
import java.util.Vector;

public class PkgDiffModeCheckAdapter
extends UpModeChechAdapter {
    private static final long serialVersionUID = 1L;

    public PkgDiffModeCheckAdapter(int iTaskTypeID, THashSet<Resource> allResoutLst, THashSet<Resource> nonSupportLst, int iUpgradeLevel) {
        super(iTaskTypeID, allResoutLst, nonSupportLst, iUpgradeLevel);
    }

    @Override
    protected void initTableData() {
        if (null == this.m_oNonSupportLst || this.m_oNonSupportLst.size() == 0) {
            return;
        }
        Iterator itor = this.m_oNonSupportLst.iterator();
        String sDevName = "";
        int iDevID = -1;
        int iUpMode = -1;
        while (itor.hasNext()) {
            Vector<Object> rowData = new Vector<Object>();
            Resource resource = (Resource)itor.next();
            sDevName = resource.getDeviceName();
            iDevID = resource.getDeviceID();
            iUpMode = resource.getUpgradeMode();
            rowData.add(sDevName);
            rowData.add(this.getShowDevIdInfo(iDevID));
            rowData.add(this.getDetailInfo(iUpMode));
            this.m_oMainDlg.addRowInModel(rowData);
        }
    }

    @Override
    public String getDetailInfo(int iUpMode) {
        String sDetailInfo = ResourceManager.getInstance().getResString("INFO_ERROR_NOT_SUPPORT_DIFFUSE_TASK");
        if (this.iTaskTypeID == 5) {
            if (0 == (iUpMode & 8)) {
                sDetailInfo = ResourceManager.getInstance().getResString("INFO_ERROR_NOT_SUPPORT_DIFFUSE_UPGRADE_TASK");
            }
            if (1 == this.iUpDownLevel && 0 == (iUpMode & 0x40)) {
                sDetailInfo = ResourceManager.getInstance().getResString("INFO_ERROR_NOT_SUPPORT_DIFFUSE_DEVICE_TASK");
            } else if (2 == this.iUpDownLevel && 0 == (iUpMode & 0x20)) {
                sDetailInfo = ResourceManager.getInstance().getResString("INFO_ERROR_NOT_SUPPORT_DIFFUSE_BOARD_TASK");
            }
        } else if (this.iTaskTypeID == 12) {
            if (0 == (iUpMode & 0x4000)) {
                sDetailInfo = ResourceManager.getInstance().getResString("INFO_ERROR_NOT_SUPPORT_DIFFUSE_DOWNGRADE_TASK");
            } else if (1 == this.iUpDownLevel && 0 == (iUpMode & 0x40)) {
                sDetailInfo = ResourceManager.getInstance().getResString("INFO_ERROR_NOT_SUPPORT_DIFFUSE_DEVICE_AND_DELETEDB_TASK");
            } else if (2 == this.iUpDownLevel && 0 == (iUpMode & 0x20)) {
                sDetailInfo = ResourceManager.getInstance().getResString("INFO_ERROR_NOT_SUPPORT_DIFFUSE_BOARD_AND_DELETEDB_TASK");
            }
        }
        return sDetailInfo;
    }
}

