/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.controller;

import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.taskmgmt.controller.UpModeChechAdapter;
import com.huawei.dc.taskmgmt.model.Resource;
import gnu.trove.THashSet;
import java.util.Iterator;
import java.util.Vector;

public class PatchModeCheckAdapter
extends UpModeChechAdapter {
    private static final String TABLE_COLUMN_1_NAME = ResourceManager.getInstance().getResString("DEVICE_IP");

    public PatchModeCheckAdapter(int iTaskTypeID, THashSet<Resource> allResoutLst, THashSet<Resource> nonSupportLst, int iUpgradeLevel) {
        super(iTaskTypeID, allResoutLst, nonSupportLst, iUpgradeLevel);
    }

    @Override
    protected String[] getColumns() {
        return new String[]{this.TABLE_COLUMN_0_NAME, TABLE_COLUMN_1_NAME, this.TABLE_COLUMN_2_NAME};
    }

    @Override
    protected void initTableData() {
        if (null == this.m_oNonSupportLst || this.m_oNonSupportLst.size() == 0) {
            return;
        }
        int iDevDomain = DeviceInfoManagerImpl.getInstance().getDevice(((Resource)this.m_oNonSupportLst.iterator().next()).getDeviceID()).getDeviceTypeInfo().getDevDomain();
        if (4 == iDevDomain) {
            this.m_oMainDlg.getTable().getColumnModel().getColumn(1).setHeaderValue(ResourceManager.getInstance().getResString("NE_ID"));
        }
        Iterator itor = this.m_oNonSupportLst.iterator();
        String sDevName = "";
        String sDevIP = "";
        int iUpMode = -1;
        while (itor.hasNext()) {
            Vector<Object> rowVector = new Vector<Object>();
            Resource resource = (Resource)itor.next();
            sDevName = resource.getDeviceName();
            sDevIP = 4 == iDevDomain ? this.getShowDevIdInfo(resource.getDeviceID()) : resource.getDeviceIP();
            iUpMode = resource.getUpgradeMode();
            rowVector.add(sDevName);
            rowVector.add(sDevIP);
            rowVector.add(this.getDetailInfo(iUpMode));
            this.m_oMainDlg.addRowInModel(rowVector);
        }
    }

    @Override
    protected String getDetailInfo(int iUpMode) {
        return ResourceManager.getInstance().getResString("INFO_ERROR_NOT_SUPPORT_PATCH_TASK");
    }
}

