/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.controller;

import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.taskmgmt.controller.UpModeChechAdapter;
import com.huawei.dc.taskmgmt.model.Resource;
import gnu.trove.THashSet;
import java.util.Iterator;
import java.util.Vector;

public class PackageModeCheckAdapter
extends UpModeChechAdapter {
    private static final long serialVersionUID = 1L;

    public PackageModeCheckAdapter() {
    }

    public PackageModeCheckAdapter(int iTaskTypID, THashSet<Resource> allResoutLst, THashSet<Resource> nonSupportLst, int iUpgradeLevel) {
        super(iTaskTypID, allResoutLst, nonSupportLst, iUpgradeLevel);
    }

    @Override
    protected void initTableData() {
        if (null == this.m_oNonSupportLst || this.m_oNonSupportLst.size() == 0) {
            return;
        }
        Iterator itor = this.m_oNonSupportLst.iterator();
        String sDevName = "";
        int iDevID = -1;
        int iUpMode = -1;
        while (itor.hasNext()) {
            Vector<Object> rowVector = new Vector<Object>();
            Resource resource = (Resource)itor.next();
            sDevName = resource.getDeviceName();
            iDevID = resource.getDeviceID();
            iUpMode = resource.getUpgradeMode();
            rowVector.add(sDevName);
            rowVector.add(this.getShowDevIdInfo(iDevID));
            rowVector.add(this.getDetailInfo(iUpMode));
            this.m_oMainDlg.addRowInModel(rowVector);
        }
    }

    @Override
    protected String getDetailInfo(int iUpMode) {
        String sDetailInfo = ResourceManager.getInstance().getResString("INFO_ERROR_NOT_SUPPORT_PACKAGE_TASK");
        if (4 == this.iTaskTypeID && 0 == (iUpMode & 4)) {
            DCDebugTracer.trace("DC::A42D17028: " + iUpMode);
            sDetailInfo = ResourceManager.getInstance().getResString("INFO_ERROR_NOT_SUPPORT_PACKAGE_UPGRADE_TASK");
        } else if (13 == this.iTaskTypeID && 0 == (iUpMode & 0x4000)) {
            sDetailInfo = ResourceManager.getInstance().getResString("INFO_ERROR_NOT_SUPPORT_PACKAGE_DOWNGRADE_TASK");
        }
        return sDetailInfo;
    }

    @Override
    public void eludeFindBugs() {
    }
}

