/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.controller;

import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.taskmgmt.controller.ILogInfoNotifier;
import com.huawei.dc.taskmgmt.controller.ITaskNotificationListener;
import com.huawei.dc.taskmgmt.controller.TaskEvent;
import java.util.ArrayList;
import java.util.List;

public class LogInfoNotifier
implements ILogInfoNotifier,
IDCObjectDeallocator {
    private List<Object> m_oListenerListToProcessResponse = new ArrayList<Object>(0);
    private List<Object> m_oListenerListToSendRequest = new ArrayList<Object>(0);
    private static LogInfoNotifier m_oEventNotifier = new LogInfoNotifier();

    private LogInfoNotifier() {
    }

    public static synchronized LogInfoNotifier getInstance() {
        if (null == m_oEventNotifier) {
            m_oEventNotifier = new LogInfoNotifier();
            DCObjectDestructor.getInstance().addObjectForDestructor(m_oEventNotifier);
        }
        return m_oEventNotifier;
    }

    @Override
    public void notifyOprLogEvent(TaskEvent oTaskEvent) {
        int noOfListener = this.m_oListenerListToProcessResponse.size();
        for (int index = 0; index < noOfListener; ++index) {
            Object oListenerObj = this.m_oListenerListToProcessResponse.get(index);
            if (!(oListenerObj instanceof ITaskNotificationListener)) continue;
            ((ITaskNotificationListener)oListenerObj).onTaskNotification(oTaskEvent);
        }
    }

    @Override
    public void removeNotificationListener(ITaskNotificationListener oListener) {
        if (null != oListener) {
            this.m_oListenerListToProcessResponse.remove(oListener);
            this.m_oListenerListToSendRequest.remove(oListener);
        }
    }

    @Override
    public void setToNULL() {
        this.m_oListenerListToProcessResponse.clear();
        this.m_oListenerListToProcessResponse = null;
        this.m_oListenerListToSendRequest.clear();
        this.m_oListenerListToSendRequest = null;
        m_oEventNotifier = null;
    }

    @Override
    public void addListenerToProcessResponse(ITaskNotificationListener oListener) {
        if (null != oListener && !this.m_oListenerListToProcessResponse.contains(oListener)) {
            this.m_oListenerListToProcessResponse.add(oListener);
        }
    }

    @Override
    public void addListenerToSendRequest(ITaskNotificationListener oListener) {
        if (null != oListener && !this.m_oListenerListToSendRequest.contains(oListener)) {
            this.m_oListenerListToSendRequest.add(oListener);
        }
    }

    @Override
    public void sendRequestForLog(TaskEvent oTaskEvent) {
        int noOfListener = this.m_oListenerListToSendRequest.size();
        for (int index = 0; index < noOfListener; ++index) {
            Object oListenerObj = this.m_oListenerListToSendRequest.get(index);
            if (!(oListenerObj instanceof ITaskNotificationListener)) continue;
            DCDebugTracer.trace("LogInfoNotifier-sendRequestForLog:" + oListenerObj.getClass().getSimpleName());
            ((ITaskNotificationListener)oListenerObj).onTaskNotification(oTaskEvent);
        }
    }

    public void clearAllListeners() {
        this.m_oListenerListToProcessResponse.clear();
        this.m_oListenerListToSendRequest.clear();
    }
}

