/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.controller;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDevErrorInfo;
import com.huawei.dc.common.asndatacenter.AsnDevErrorInfoList;
import com.huawei.dc.common.asndatacenter.AsnSWCompatibilityCheckReq;
import com.huawei.dc.common.asndatacenter.AsnSWCompatibilityCheckResp;
import com.huawei.dc.common.asndatacenter.DCStringList;
import com.huawei.dc.common.components.dialog.SimpleProgressDlg;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfoListParam;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.controller.ITaskNotificationListener;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import com.huawei.dc.taskmgmt.controller.TaskEvent;
import com.huawei.dc.taskmgmt.controller.TaskInfoNotifier;
import com.huawei.dc.taskmgmt.controller.TaskSyncCommController;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.view.ValidationResult;
import com.huawei.dc.taskmgmt.view.common.TaskOperationResultDialog;
import java.awt.Component;
import java.text.Collator;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class LoadSoftwareCheckManager
implements ITaskNotificationListener,
IDCObjectDeallocator {
    private static LoadSoftwareCheckManager m_oInstance = null;
    private SimpleProgressDlg m_oValidationProgressDlg;
    private TaskOperationResultDialog m_oOpResultDlg = null;
    private ITask m_oTaskToValidate;
    private LoadFileInfoListParam m_oLoadParam;
    private byte[] m_oSyncObj = new byte[0];
    private AsnSWCompatibilityCheckResp m_oAsnSWCompatibilityCheckResp;
    private boolean bIsError = false;
    private boolean m_bCancelPressed = false;

    private LoadSoftwareCheckManager() {
        TaskInfoNotifier.getInstance().addTaskNotificationListener(this);
    }

    public static synchronized LoadSoftwareCheckManager getInstance() {
        if (null == m_oInstance) {
            m_oInstance = new LoadSoftwareCheckManager();
            DCObjectDestructor.getInstance().addObjectForDestructor(m_oInstance);
        }
        return m_oInstance;
    }

    public ValidationResult validateLoadSoftwareFiles(ITask oTaskDataObj, LoadFileInfoListParam oLoadParam) {
        DCDebugTracer.trace("Method validateLoadSoftwareFiles Start");
        this.m_oTaskToValidate = oTaskDataObj;
        this.m_oLoadParam = oLoadParam;
        ValidationResult oValidationResult = new ValidationResult();
        try {
            this.checkSoftwareFilesFromServer();
            oValidationResult.setErrorType(0);
            oValidationResult.setErrorCode(0);
        }
        catch (DCException e) {
            if (Collator.getInstance().equals(DCFrameWorkUtil.getLocalizedString("CHECK_SOFTWARE_VALIDATION_FAILED"), e.getMessage())) {
                oValidationResult.setErrorCode(-1);
                oValidationResult.setErrorMessage(e.getMessage());
                oValidationResult.setErrorType(4);
            }
            oValidationResult.setErrorCode(-1);
            oValidationResult.setErrorMessage(e.getMessage());
            oValidationResult.setErrorType(0);
        }
        this.m_oTaskToValidate = null;
        this.m_oLoadParam = null;
        DCDebugTracer.trace("Method validateLoadSoftwareFiles end");
        return oValidationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSoftwareFilesFromServer() throws DCException {
        DCDebugTracer.trace("Method checkSoftwareFilesFromServer Start");
        this.m_bCancelPressed = false;
        this.m_oValidationProgressDlg = new SimpleProgressDlg(ResourceManager.getInstance().getResString("CHECK_LOAD_SOFTWARE_VALIDATION_TITLE"), true, ResourceManager.getInstance().getResString("GETTING_CHECK_LOAD_SOFTWARE_VALIDATION_TITLE")){
            private static final long serialVersionUID = 1L;

            @Override
            protected void cancelButtonActionPerformed() {
                LoadSoftwareCheckManager.this.m_bCancelPressed = true;
            }
        };
        if (null == this.m_oValidationProgressDlg) {
            return;
        }
        AutoCloseThread oAutoCloseThread = new AutoCloseThread();
        oAutoCloseThread.start();
        byte[] byArray = this.m_oSyncObj;
        synchronized (this.m_oSyncObj) {
            this.m_oAsnSWCompatibilityCheckResp = null;
            this.setError(false);
            this.m_oOpResultDlg = null;
            AsnSWCompatibilityCheckReq oAsnSWCompatibilityCheckReq = TaskCommUtil.getCheckLoadSWRqst(this.m_oTaskToValidate, this.m_oLoadParam);
            TaskSyncCommController.getInstance().checkLoadSoftware(oAsnSWCompatibilityCheckReq);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.m_oValidationProgressDlg.setVisible(true);
            if (this.isError()) {
                DCDebugTracer.trace("Throw CHECK_SOFTWARE_VALIDATION_FAILED exception from checkSoftwareFilesFromServer method");
                throw new DCException(DCFrameWorkUtil.getLocalizedString("CHECK_SOFTWARE_VALIDATION_FAILED"));
            }
            DCDebugTracer.trace("Method checkSoftwareFilesFromServer end");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTaskNotification(TaskEvent oEvent) {
        if (null == oEvent || !(oEvent.getSource() instanceof AsnSWCompatibilityCheckResp)) {
            return;
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException ex) {
            DCDebugTracer.trace(ex);
        }
        if (null == this.m_oValidationProgressDlg || null == this.m_oTaskToValidate) {
            return;
        }
        byte[] byArray = this.m_oSyncObj;
        synchronized (this.m_oSyncObj) {
            DCDebugTracer.trace("Processing start for check load software response from server");
            this.m_oAsnSWCompatibilityCheckResp = (AsnSWCompatibilityCheckResp)oEvent.getSource();
            if (null != this.m_oAsnSWCompatibilityCheckResp) {
                int iErrorCode = this.m_oAsnSWCompatibilityCheckResp.oErrorInfo.iErrorNo.intValue();
                if (0 != iErrorCode) {
                    this.setError(true);
                    AsnDevErrorInfoList oAsnDevErrorInfoLst = this.m_oAsnSWCompatibilityCheckResp.oAsnDevErrorInfoList;
                    if (null == oAsnDevErrorInfoLst || 0 == oAsnDevErrorInfoLst.size()) {
                        this.stopProgressDlg();
                        this.showErrorMessage(iErrorCode);
                    } else {
                        if (null == this.m_oOpResultDlg) {
                            String strTitle = DCFrameWorkUtil.getLocalizedString("ERROR");
                            String[] strColumnNames = new String[]{DCFrameWorkUtil.getLocalizedString("CHECK_SOFTWARE_RESOURCE_NAME"), DCFrameWorkUtil.getLocalizedString("CHECK_SOFTWARE_FILE_LIST"), DCFrameWorkUtil.getLocalizedString("TASK_RESULT_FAILURE_REASON")};
                            this.m_oOpResultDlg = new TaskOperationResultDialog(strTitle, 1, true, strColumnNames);
                            this.m_oOpResultDlg.setMessage(ErrorCodeReader.getInstance().getErrorDesc(this.m_oAsnSWCompatibilityCheckResp.oErrorInfo.iErrorNo));
                        }
                        int iSize = oAsnDevErrorInfoLst.size();
                        Vector<Object> oRowData = null;
                        AsnDevErrorInfo oAsnDevErrorInfo = null;
                        DeviceTypeInfo oDeviceTypeInfo = null;
                        DCStringList strFileList = null;
                        StringBuffer strFiles = null;
                        String strFilesToDisplay = null;
                        for (int i = 0; i < iSize; ++i) {
                            oAsnDevErrorInfo = (AsnDevErrorInfo)oAsnDevErrorInfoLst.get(i);
                            int iDevTypeID = oAsnDevErrorInfo.iDevTypeId.intValue();
                            int iDevTypeVerID = oAsnDevErrorInfo.iDevTypeVerId.intValue();
                            oDeviceTypeInfo = DCFrameWorkUtil.getDeviceInfoManager().getDeviceTypeInfo(iDevTypeID, iDevTypeVerID);
                            strFileList = oAsnDevErrorInfo.strSWFileList;
                            int iNoOfFiles = strFileList.size();
                            strFiles = new StringBuffer();
                            for (int j = 0; j < iNoOfFiles; ++j) {
                                strFiles.append(new String((byte[])strFileList.get(j)) + ", ");
                            }
                            strFilesToDisplay = strFiles.toString();
                            if (strFilesToDisplay.trim().endsWith(",")) {
                                strFilesToDisplay = strFilesToDisplay.substring(0, strFilesToDisplay.trim().length() - 1);
                            }
                            oRowData = new Vector<Object>(3);
                            oRowData.add(oDeviceTypeInfo.toString());
                            oRowData.add(strFilesToDisplay);
                            oRowData.add(ErrorCodeReader.getInstance().getErrorDesc(oAsnDevErrorInfo.oErrorInfo.iErrorNo));
                            this.m_oOpResultDlg.addRowInModel(oRowData);
                        }
                    }
                }
                this.stopProgressDlg();
                if (null != this.m_oOpResultDlg) {
                    this.m_oOpResultDlg.setVisible(true);
                }
            }
            DCDebugTracer.trace("Processing end for check load software response from server");
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return;
        }
    }

    private void showErrorMessage(int iErrorCode) {
        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorCode, DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
    }

    public synchronized void stopProgressDlg() {
        if (null != this.m_oValidationProgressDlg) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LoadSoftwareCheckManager.this.m_oValidationProgressDlg.dispose();
                    LoadSoftwareCheckManager.this.m_oValidationProgressDlg = null;
                }
            });
        }
        try {
            this.wait(300L);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    @Override
    public void setToNULL() {
        this.m_oValidationProgressDlg = null;
        this.m_oOpResultDlg = null;
        this.m_oSyncObj = null;
        this.m_oAsnSWCompatibilityCheckResp = null;
        m_oInstance = null;
    }

    public boolean isError() {
        return this.bIsError;
    }

    public void setError(boolean isError) {
        this.bIsError = isError;
    }

    class AutoCloseThread
    extends Thread {
        AutoCloseThread() {
        }

        @Override
        public void run() {
            SimpleProgressDlg oCurrentDlg = LoadSoftwareCheckManager.this.m_oValidationProgressDlg;
            try {
                AutoCloseThread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (null != LoadSoftwareCheckManager.this.m_oValidationProgressDlg && oCurrentDlg == LoadSoftwareCheckManager.this.m_oValidationProgressDlg && LoadSoftwareCheckManager.this.m_oValidationProgressDlg.isVisible()) {
                LoadSoftwareCheckManager.this.stopProgressDlg();
            }
        }
    }
}

