/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt.controller;

import com.huawei.dc.common.asndatacenter.AsnCancelTaskRsp;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.controller.ITaskNotificationListener;
import com.huawei.dc.taskmgmt.controller.TaskEvent;
import com.huawei.dc.taskmgmt.controller.TaskInfoNotifier;
import com.huawei.dc.taskmgmt.model.TaskDataModel;
import com.huawei.dc.taskmgmt.view.common.TaskOperationResultDialog;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class CancelOperationResultManager
implements ITaskNotificationListener,
IDCObjectDeallocator {
    private static CancelOperationResultManager m_oInstance = null;
    private TaskOperationResultDialog m_oOpResultDlg = null;
    private byte[] m_oSyncObj = new byte[0];

    private CancelOperationResultManager() {
        TaskInfoNotifier.getInstance().addTaskNotificationListener(this);
    }

    public static synchronized CancelOperationResultManager getInstance() {
        if (null == m_oInstance) {
            m_oInstance = new CancelOperationResultManager();
            DCObjectDestructor.getInstance().addObjectForDestructor(m_oInstance);
        }
        return m_oInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTaskNotification(TaskEvent oEvent) {
        if (null == oEvent || !(oEvent.getSource() instanceof AsnCancelTaskRsp)) {
            return;
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException ex) {
            DCDebugTracer.trace(ex);
        }
        byte[] byArray = this.m_oSyncObj;
        synchronized (this.m_oSyncObj) {
            DCDebugTracer.trace("Processing start for cancel operation response from server");
            AsnCancelTaskRsp oAsnCancelTaskRsp = (AsnCancelTaskRsp)oEvent.getSource();
            if (null != oAsnCancelTaskRsp) {
                int iTaskID = oAsnCancelTaskRsp.iTaskId.intValue();
                int iDevID = oAsnCancelTaskRsp.iDevId.intValue();
                DeviceInfo oDeviceInfo = DCFrameWorkUtil.getDeviceInfoManager().getDevice(iDevID);
                String strTaskName = TaskDataModel.getInstance().getTask(iTaskID).getTaskName();
                String strResource = oDeviceInfo.getDevName() + '(' + oDeviceInfo.getDevIPAddress() + ')';
                String strFailureReason = ErrorCodeReader.getInstance().getErrorDesc(oAsnCancelTaskRsp.iErrorCode);
                Vector<String> oRowData = new Vector<String>(3);
                if (null == this.m_oOpResultDlg) {
                    String[] strColumnNames = new String[]{DCFrameWorkUtil.getLocalizedString("TASK_NAME"), DCFrameWorkUtil.getLocalizedString("RESOURCE_NAME"), DCFrameWorkUtil.getLocalizedString("FAILURE_REASON")};
                    String strMessage = DCFrameWorkUtil.getLocalizedString("CANCEL_OPERATION_RESULT_FAILURE_MSG");
                    String strTitle = DCFrameWorkUtil.getLocalizedString("ERROR");
                    this.m_oOpResultDlg = new TaskOperationResultDialog(strTitle, 1, true, strColumnNames);
                    this.m_oOpResultDlg.setMessage(strMessage);
                }
                oRowData.add(strTaskName);
                oRowData.add(strResource);
                oRowData.add(strFailureReason);
                this.m_oOpResultDlg.addRowInModel(0, oRowData);
                if (!this.m_oOpResultDlg.isVisible()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CancelOperationResultManager.this.m_oOpResultDlg.setVisible(true);
                            CancelOperationResultManager.this.m_oOpResultDlg = null;
                        }
                    });
                }
            }
            DCDebugTracer.trace("Processing end for cancel operation response from server");
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void setToNULL() {
        this.m_oOpResultDlg = null;
        this.m_oSyncObj = null;
        m_oInstance = null;
    }
}

