/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.taskmgmt;

import com.huawei.dc.adapter.swimap.iview.templates.tabbedpane.DCCloseableTabbedPane;
import com.huawei.dc.adapter.swimap.iview.templates.tabbedpane.DCCloseableTabbedPaneListener;
import com.huawei.dc.adapter.swimap.mdi.DCExtendedWindow;
import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.dcmodule.DataCenterModuleManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.MenuUtil;
import com.huawei.dc.framework.ObjectStore;
import com.huawei.dc.taskmgmt.ITaskManagement;
import com.huawei.dc.taskmgmt.controller.ITaskNotificationListener;
import com.huawei.dc.taskmgmt.controller.TaskEvent;
import com.huawei.dc.taskmgmt.controller.TaskEventID;
import com.huawei.dc.taskmgmt.controller.TaskInfoNotifier;
import com.huawei.dc.taskmgmt.isolation.view.IsolationManagementPanel;
import com.huawei.dc.taskmgmt.isolation.view.IsolationTaskInfoPanel;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.ITaskGroup;
import com.huawei.dc.taskmgmt.model.TaskDataModel;
import com.huawei.dc.taskmgmt.view.common.TaskManagementPanel;
import com.huawei.dc.taskmgmt.view.tasktable.TaskTablePanel;
import com.swimap.iview.templates.tabbedpane.CloseableTabbedPaneListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class TaskManagementMainPanel
extends DCExtendedWindow
implements ITaskManagement,
ITaskNotificationListener {
    private static final long serialVersionUID = 1L;
    private DataCenterModuleManager m_oDCModuleMgr;
    private DCCloseableTabbedPane m_oTabbedPane;
    private TaskManagementPanel m_oTaskMgrPanel;
    private boolean m_isRefreshOperation = false;

    public TaskManagementMainPanel(DataCenterModuleManager dcModuleMgr) {
        this.m_oDCModuleMgr = dcModuleMgr;
        this.setTitle(ResourceManager.getInstance().getResString("TASK_MANAGEMENT_TAB"));
        this.setLayout(new BorderLayout());
        TaskInfoNotifier.getInstance().addTaskNotificationListener(this);
        this.jInit();
    }

    public TaskManagementPanel getM_oTaskMgrPanel() {
        return this.m_oTaskMgrPanel;
    }

    private void jInit() {
        this.m_oTabbedPane = new DCCloseableTabbedPane();
        this.m_oTabbedPane.addCloseableTabbedPaneListener((CloseableTabbedPaneListener)new TabCloseListener());
        this.m_oTaskMgrPanel = new TaskManagementPanel(this.m_oDCModuleMgr);
        this.m_oTabbedPane.addCloseableTab(this.m_oTaskMgrPanel.getTitle(), (Component)this.m_oTaskMgrPanel, false);
        this.add((Component)this.m_oTabbedPane, "Center");
    }

    public void showIsolationManagementPanel() {
        if (this.isContainIsolationTask()) {
            this.addIsolationManagementPanel(true);
            IsolationTaskInfoPanel oIsolationTaskInfoPanel = DCFrameWorkUtil.getIsolationTaskInfoPanel();
            if (null != oIsolationTaskInfoPanel) {
                TaskEvent oTaskEvent = new TaskEvent(Boolean.TRUE, TaskEventID.TASK_LIST_REFRESH);
                oIsolationTaskInfoPanel.notifyEvent(oTaskEvent);
            }
        }
    }

    public void closeIsolationManagementPanel() {
        String strTitle = ResourceManager.getInstance().getResString("ISOLATION_MANAGEMENT_TAB_TITLE");
        Component oComponent = this.getTabComponent(strTitle);
        if (null != oComponent) {
            this.m_oTabbedPane.remove(oComponent);
            ITaskManagement oIsolationTaskManagement = (ITaskManagement)((Object)oComponent);
            oIsolationTaskManagement.disposePanel();
        }
    }

    private synchronized void addIsolationManagementPanel(boolean isSelected) {
        DCDebugTracer.traceDetail("TaskManagementMainPanel#addIsolationManagementPanel start");
        String strTitle = ResourceManager.getInstance().getResString("ISOLATION_MANAGEMENT_TAB_TITLE");
        Component oComponent = this.getTabComponent(strTitle);
        if (null == oComponent) {
            IsolationManagementPanel oIsolationMgrPanel = new IsolationManagementPanel();
            this.m_oTabbedPane.addCloseableTab(oIsolationMgrPanel.getTitle(), (Component)oIsolationMgrPanel, false);
            oComponent = oIsolationMgrPanel;
        }
        if (isSelected) {
            this.m_oTabbedPane.setSelectedComponent(oComponent);
        }
        DCDebugTracer.traceDetail("TaskManagementMainPanel#addIsolationManagementPanel end");
    }

    private Component getTabComponent(String strTitle) {
        int iTabCount = this.m_oTabbedPane.getTabCount();
        for (int i = 0; i < iTabCount; ++i) {
            Component oComponent = this.m_oTabbedPane.getComponentAt(i);
            if (!(oComponent instanceof ITaskManagement) || !((ITaskManagement)((Object)oComponent)).getTitle().equals(strTitle)) continue;
            return oComponent;
        }
        return null;
    }

    private void removeComponentAtIndex(Component oComponent) {
        if (null == oComponent) {
            return;
        }
        if (oComponent instanceof ITaskManagement) {
            ((ITaskManagement)((Object)oComponent)).disposePanel();
        }
        this.m_oTabbedPane.remove(oComponent);
    }

    @Override
    public void disposePanel() {
        int iTabCount = this.m_oTabbedPane.getTabCount();
        for (int i = 0; i < iTabCount; ++i) {
            Component oComponent = this.m_oTabbedPane.getComponentAt(i);
            if (!(oComponent instanceof ITaskManagement)) continue;
            ((ITaskManagement)((Object)oComponent)).disposePanel();
        }
        TaskDataModel.getInstance().clearTaskModel();
        ObjectStore.getInstance().removeObjectInstance("TaskMgmtOperationSelectionPanel");
        ObjectStore.getInstance().removeObjectInstance("TaskDeviceOperationLogPanel");
        ObjectStore.getInstance().removeObjectInstance("TaskMgmtOperationSelectionPanel");
        ObjectStore.getInstance().removeObjectInstance("TaskTableButtonPanel");
    }

    @Override
    public void refreshTaskManagement() {
        this.m_isRefreshOperation = true;
        int iTabCount = this.m_oTabbedPane.getTabCount();
        for (int i = 0; i < iTabCount; ++i) {
            Component oComponent = this.m_oTabbedPane.getComponentAt(i);
            if (!(oComponent instanceof ITaskManagement)) continue;
            ((ITaskManagement)((Object)oComponent)).refreshTaskManagement();
        }
    }

    public void windowActivated() {
        DCDebugTracer.trace("TaskManagementMainPanel.windowActivated() start");
        super.windowActivated();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TaskManagementMainPanel.this.m_oDCModuleMgr.setToolBarIconVisible(true);
            }
        });
        MenuUtil.enableMenuItem(this.m_oDCModuleMgr.getDataCenterMenu(), "TaskManagement", false);
        DCFrameWorkUtil.getToolBarButton("TaskManagement").setEnabled(false);
        TaskTablePanel oTaskTablePanel = DCFrameWorkUtil.getTaskTablePanel();
        if (null != oTaskTablePanel && oTaskTablePanel.isGettingTaskInfo()) {
            DCFrameWorkUtil.getToolBarButton("refreshTree").setEnabled(false);
            return;
        }
        DCFrameWorkUtil.getToolBarButton("refreshTree").setEnabled(true);
        if (null != DCFrameWorkUtil.getUpgradeFaildDlg()) {
            DCFrameWorkUtil.getUpgradeFaildDlg().locateToCentre((Component)((Object)this));
            DCFrameWorkUtil.visibleUI((JComponent)((Object)DCFrameWorkUtil.getUpgradeFaildDlg()));
        }
        this.requestFocus();
        DCDebugTracer.trace("TaskManagementMainPanel.windowActivated() end");
    }

    public void windowDeactivated() {
        DCDebugTracer.trace("TaskManagementMainPanel.windowDeactivated() start");
        super.windowDeactivated();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TaskManagementMainPanel.this.m_oDCModuleMgr.setToolBarIconVisible(false);
            }
        });
        MenuUtil.enableMenuItem(this.m_oDCModuleMgr.getDataCenterMenu(), "TaskManagement", true);
        DCFrameWorkUtil.getToolBarButton("TaskManagement").setEnabled(true);
        DCDebugTracer.trace("TaskManagementMainPanel.windowDeactivated() end");
    }

    public void windowClosed() {
        this.disposePanel();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TaskManagementMainPanel.this.m_oDCModuleMgr.setToolBarIconVisible(false);
            }
        });
        this.m_oDCModuleMgr.closePanel("TaskInfoPanel");
        DCFrameWorkUtil.setTaskTablePanel(null);
        TaskInfoNotifier.getInstance().removeTaskNotificationListener(this);
    }

    public void windowOpened() {
        this.m_oDCModuleMgr.openPanel("TaskInfoPanel");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TaskManagementMainPanel.this.m_oDCModuleMgr.setToolBarIconVisible(true);
            }
        });
        TaskInfoNotifier.getInstance().addTaskNotificationListener(this);
        TaskTablePanel oTaskTablePanel = DCFrameWorkUtil.getTaskTablePanel();
        if (null != oTaskTablePanel && oTaskTablePanel.isGettingTaskInfo()) {
            DCFrameWorkUtil.getToolBarButton("refreshTree").setEnabled(false);
            return;
        }
    }

    @Override
    public void onTaskNotification(TaskEvent oEvent) {
        TaskEventID enTaskEventType = oEvent.getTaskEventType();
        if (TaskEventID.TASK_LIST_REFRESH == enTaskEventType) {
            Boolean oIsLastInfo;
            if (!this.m_isRefreshOperation && null != (oIsLastInfo = (Boolean)oEvent.getSource()) && oIsLastInfo.booleanValue() && this.isContainIsolationTask()) {
                this.addIsolationManagementPanel(false);
            }
            this.m_isRefreshOperation = false;
        } else if (TaskEventID.DC_CREATE_ISOLATION_TASK_INFO == enTaskEventType) {
            this.addIsolationManagementPanel(true);
        } else {
            DCDebugTracer.trace("TaskManagementMainPanel the task event id is " + (Object)((Object)enTaskEventType));
        }
    }

    private boolean isContainIsolationTask() {
        List<ITask> oTaskLst;
        ITaskGroup oTaskGroup = TaskDataModel.getInstance().getTaskGroup(256);
        return null != oTaskGroup && null != (oTaskLst = oTaskGroup.getAllTask()) && 0 < oTaskLst.size();
    }

    public Rectangle getWindowBounds() {
        return new Rectangle(0, 0, DCConstants.DC_WINDOW_WIDTH, DCConstants.DC_WINDOW_HEIGHT);
    }

    class TabCloseListener
    implements DCCloseableTabbedPaneListener {
        TabCloseListener() {
        }

        public void tabClosed(Component arg0) {
        }

        public boolean tabClosing(Component oComponent) {
            TaskManagementMainPanel.this.removeComponentAtIndex(oComponent);
            return true;
        }
    }
}

