/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.view;

import com.huawei.dc.adapter.swimap.iview.commstyle.resource.DCResourceMng;
import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCExtendedTable;
import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCSortableTableModel;
import com.huawei.dc.adapter.swimap.iview.templates.print.DCPrintSupportor;
import com.huawei.dc.adapter.swimap.iview.templates.print.DCTablePrintable;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.ConfigurationInfo;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.framework.utility.print.PrintSupportor;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DCSaveFileChooser;
import com.huawei.dc.common.util.WindowStyleButton;
import com.huawei.dc.standalone.model.BoardInformation;
import com.huawei.dc.standalone.model.DeviceStatisticsReportInfo;
import com.swimap.iview.templates.extendedtable.SortableTableModel;
import com.swimap.iview.templates.print.tools.TablePrintable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;

public class SoftwareStatisticsDlg
extends DCModalDialog {
    private static final long serialVersionUID = 1L;
    private SoftwareInfoSortableTableModel m_oTaskstatisticsModel;
    private static final int DEFAULT_HEADER_SIZE = 6;
    private String[] m_arrHeader;
    JPanel oMainPanel = null;
    private DCExtendedTable m_statisticsTable;
    private ResourceManager m_oRes;
    private WindowStyleButton m_saveButton = null;
    private WindowStyleButton m_previewButton = null;
    private WindowStyleButton m_printButton = null;
    private JScrollPane oScrollPan = null;
    private final List oReportInfoList;
    private static final int DEVICE_NAME_INDEX = 0;
    private static final int DEVICE_TYPE_INDEX = 1;
    private static final int DEVICE_ID_INDEX = 2;
    private static final int DEVICE_VERSION_INDEX = 3;
    private static final int BOARD_ID_INDEX = 4;
    private static final int BOARD_TYPE_INDEX = 5;

    public SoftwareStatisticsDlg(List oReportInfoList) {
        this.setResizable(false);
        this.setSize(878, 401);
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
        this.initMgrs();
        this.setTitle(this.m_oRes.getResString("SOFTWARE_STATISTICS_DLG_TITLE"));
        this.oReportInfoList = oReportInfoList;
        this.populateHeader(this.oReportInfoList);
        this.jbInit();
        this.populateTable(this.oReportInfoList);
        ListSelectionModel oSelectionModel = this.m_statisticsTable.getSelectionModel();
        int iSelectedRow = this.m_statisticsTable.getRowCount() - 1;
        if (iSelectedRow > 0) {
            oSelectionModel.setSelectionInterval(0, 0);
        }
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), this.getCurrentContext());
    }

    private void populateHeader(List oReportInfoList) {
        HashSet oHeaderSet = new HashSet();
        int iSize = oReportInfoList.size();
        for (int index = 0; index < iSize; ++index) {
            DeviceStatisticsReportInfo oReportInfo = (DeviceStatisticsReportInfo)oReportInfoList.get(index);
            List oBoardList = oReportInfo.getBoardList();
            int iBoardListSize = oBoardList.size();
            for (int i = 0; i < iBoardListSize; ++i) {
                BoardInformation oBoardInformation = (BoardInformation)oBoardList.get(i);
                HashMap oVerMap = oBoardInformation.getVersionMap();
                Set oKeySet = oVerMap.keySet();
                oHeaderSet.addAll(oKeySet);
            }
        }
        Arrays.sort(oHeaderSet.toArray());
        Iterator oIterator = oHeaderSet.iterator();
        int iHeaderSize = oHeaderSet.size();
        this.m_arrHeader = new String[iHeaderSize + 6];
        this.m_arrHeader[0] = ResourceManager.getInstance().getResString("DEVICE_NAME");
        this.m_arrHeader[1] = ResourceManager.getInstance().getResString("DEVICE_TYPE");
        this.m_arrHeader[2] = ResourceManager.getInstance().getResString("NE_ID");
        this.m_arrHeader[3] = ResourceManager.getInstance().getResString("DEVICE_VERSION");
        this.m_arrHeader[4] = ResourceManager.getInstance().getResString("BOARD_ID");
        this.m_arrHeader[5] = ResourceManager.getInstance().getResString("BOARD_TYPE");
        for (int index = 6; index < iHeaderSize + 6; ++index) {
            this.m_arrHeader[index] = (String)oIterator.next();
        }
    }

    private void populateTable(List oReportInfoList) {
        int iSize = oReportInfoList.size();
        IDeviceInfoManager oDevMgr = DeviceInfoManagerImpl.getInstance();
        for (int index = 0; index < iSize; ++index) {
            DeviceStatisticsReportInfo oReportInfo = (DeviceStatisticsReportInfo)oReportInfoList.get(index);
            List oBoardList = oReportInfo.getBoardList();
            int iBoardListSize = oBoardList.size();
            String boardName = null;
            String strBoardLocation = "";
            for (int i = 0; i < iBoardListSize; ++i) {
                Vector<String> oRowVector = new Vector<String>(0);
                if (0 == i) {
                    oRowVector.add(oReportInfo.getDeviceName());
                    oRowVector.add(oReportInfo.getDeviceTypeName());
                    oRowVector.add(oReportInfo.getDeviceId());
                    oRowVector.add(oReportInfo.getDeviceVerName());
                } else {
                    oRowVector.add("");
                    oRowVector.add("");
                    oRowVector.add("");
                    oRowVector.add("");
                }
                BoardInformation oBoardInfo = (BoardInformation)oBoardList.get(i);
                int iBoardId = oBoardInfo.getBoardId();
                boardName = oDevMgr.getBoardNameForT2000(iBoardId);
                strBoardLocation = boardName.indexOf("-") != -1 ? ResourceManager.getInstance().getResString("SLOT_LBL") + boardName : boardName.trim();
                oRowVector.add(strBoardLocation);
                String strBoardName = oBoardInfo.getBoardName();
                oRowVector.add(strBoardName);
                HashMap oVerMap = oBoardInfo.getVersionMap();
                for (int j = 6; j < this.m_arrHeader.length; ++j) {
                    String strVal = (String)oVerMap.get(this.m_arrHeader[j]);
                    if (null == strVal || 0 == strVal.length()) {
                        strVal = "_";
                    }
                    oRowVector.add(strVal);
                }
                this.m_oTaskstatisticsModel.addRow(oRowVector);
            }
        }
        this.m_statisticsTable.setRowSelectionInterval(0, 0);
        this.oScrollPan.getVerticalScrollBar().setValue(0);
    }

    private void initMgrs() {
        this.m_oRes = ResourceManager.getInstance();
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), "HELP_TOPIC_SOFTWARE_STATISTICS");
    }

    private void jbInit() {
        this.oMainPanel = new JPanel();
        this.oMainPanel.setLayout(null);
        JPanel oToolBarPanel = new JPanel();
        JPanel tablePanel = new JPanel();
        tablePanel.setBounds(new Rectangle(12, 50, 845, 273));
        tablePanel.setLayout(null);
        oToolBarPanel.setBounds(new Rectangle(12, 12, 200, 30));
        oToolBarPanel.setLayout(new BorderLayout());
        JToolBar oToolBar = new JToolBar();
        oToolBar.setFloatable(false);
        ImageIcon saveIcon = ResourceManager.getInstance().getImage("save.gif");
        ImageIcon previewIcon = ResourceManager.getInstance().getImage("preview.gif");
        ImageIcon printIcon = ResourceManager.getInstance().getImage("print.gif");
        this.m_saveButton = new WindowStyleButton();
        this.m_saveButton.setName("StandAlone_SoftwareStatisticsDlg_m_saveButton");
        this.m_previewButton = new WindowStyleButton();
        this.m_previewButton.setName("StandAlone_SoftwareStatisticsDlg_m_previewButton");
        this.m_printButton = new WindowStyleButton();
        this.m_printButton.setName("StandAlone_SoftwareStatisticsDlg_m_printButton");
        this.m_saveButton.setIcon(saveIcon);
        this.m_previewButton.setIcon(previewIcon);
        this.m_printButton.setIcon(printIcon);
        ButtonGroup oViewButtonGrp = new ButtonGroup();
        oViewButtonGrp.add(this.m_saveButton);
        oViewButtonGrp.add(this.m_previewButton);
        oViewButtonGrp.add(this.m_printButton);
        this.m_saveButton.setToolTipText(ResourceManager.getInstance().getResString("SAVE"));
        this.m_previewButton.setToolTipText(ResourceManager.getInstance().getResString("PRINT_PREVIEW"));
        this.m_printButton.setToolTipText(ResourceManager.getInstance().getResString("PRINT_PRINT"));
        this.m_previewButton.setPreferredSize(new Dimension(25, 25));
        this.m_previewButton.setMaximumSize(new Dimension(25, 25));
        this.m_previewButton.setMinimumSize(new Dimension(25, 25));
        this.m_printButton.setPreferredSize(new Dimension(25, 25));
        this.m_printButton.setMaximumSize(new Dimension(25, 25));
        this.m_printButton.setMinimumSize(new Dimension(25, 25));
        this.m_saveButton.setPreferredSize(new Dimension(25, 25));
        this.m_saveButton.setMaximumSize(new Dimension(25, 25));
        this.m_saveButton.setMinimumSize(new Dimension(25, 25));
        this.m_saveButton.setBorder(null);
        this.m_previewButton.setBorder(null);
        this.m_printButton.setBorder(null);
        oToolBar.add(this.m_saveButton);
        oToolBar.add(this.m_previewButton);
        oToolBar.add(this.m_printButton);
        this.m_oOKBtn.setName("StandAlone_SoftwareStatisticsDlg_m_oOKBtn");
        this.m_oCancelBtn.setName("StandAlone_SoftwareStatisticsDlg_m_oCancelBtn");
        this.m_oCancelBtn.setBounds(new Rectangle(776, 335, 80, 21));
        this.m_oCancelBtn.setText(ResourceManager.getInstance().getResString("CLOSE_REPORT"));
        oToolBarPanel.add((Component)oToolBar, "First");
        this.m_oTaskstatisticsModel = new SoftwareInfoSortableTableModel(this.m_arrHeader, 0);
        this.m_statisticsTable = new DCExtendedTable((SortableTableModel)this.m_oTaskstatisticsModel);
        this.m_statisticsTable.setName("StandAlone_SoftwareStatisticsDlg_m_statisticsTable");
        this.m_statisticsTable.getTableHeader().setReorderingAllowed(false);
        this.m_statisticsTable.setRowHeight(21);
        this.m_statisticsTable.getTableHeader().setPreferredSize(new Dimension(this.m_statisticsTable.getSize().width, 21));
        this.m_statisticsTable.setSortableClickCount(1);
        for (int i = 0; i < this.m_arrHeader.length; ++i) {
            this.m_statisticsTable.setColumnSortable(i, true);
        }
        TableColumnModel oColModel = this.m_statisticsTable.getColumnModel();
        DataAllignmentInCenter oAlignrenderer = new DataAllignmentInCenter();
        for (int i = 0; i < oColModel.getColumnCount(); ++i) {
            oColModel.getColumn(i).setCellRenderer(oAlignrenderer);
        }
        this.oScrollPan = new JScrollPane();
        this.oScrollPan.setBounds(new Rectangle(0, 0, 846, 270));
        this.oScrollPan.getViewport().add((Component)this.m_statisticsTable, null);
        tablePanel.add(this.oScrollPan);
        this.oMainPanel.add((Component)oToolBarPanel, null);
        this.oMainPanel.add((Component)tablePanel, null);
        this.oMainPanel.add((Component)this.m_oCancelBtn, null);
        this.getContentPane().add(this.oMainPanel);
        this.m_statisticsTable.getTableHeader().addMouseMotionListener(new TopTableHeaderListener());
        this.initActionListener();
    }

    private void initActionListener() {
        this.m_oCancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SoftwareStatisticsDlg.this.dispose();
            }
        });
        this.m_previewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SoftwareStatisticsDlg.this.m_statisticsTable.grabFocus();
                SoftwareStatisticsDlg.this.previewButtonActionPerformed();
            }
        });
        this.m_saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SoftwareStatisticsDlg.this.m_statisticsTable.grabFocus();
                SoftwareStatisticsDlg.this.saveButtonActionPerformed();
            }
        });
        this.m_printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SoftwareStatisticsDlg.this.m_statisticsTable.grabFocus();
                SoftwareStatisticsDlg.this.printRecords();
            }
        });
    }

    protected void saveButtonActionPerformed() {
        this.m_saveButton.getModel().setPressed(true);
        this.m_saveButton.getModel().setRollover(true);
        this.m_previewButton.getModel().setPressed(false);
        this.m_printButton.getModel().setPressed(false);
        this.m_previewButton.setBorder(null);
        this.m_printButton.setBorder(null);
        this.m_saveButton.setBorder(null);
        this.m_previewButton.repaint();
        this.m_printButton.repaint();
        this.m_saveButton.repaint();
        PrintSupportor.setIsFileSelection(false);
        String strPath = ConfigurationInfo.getInstance().getAbsoluteBaseDirectory() + File.separator + "report/";
        File fileDoc = new File(strPath);
        if (!fileDoc.exists()) {
            try {
                fileDoc.mkdir();
            }
            catch (Exception ex) {
                DCDebugTracer.trace(ex);
                return;
            }
        }
        DCSaveFileChooser oFileChooserDlg = new DCSaveFileChooser(strPath, false);
        oFileChooserDlg.setFileFilter(7);
        oFileChooserDlg.setAcceptAllFileFilterUsed(false);
        oFileChooserDlg.setEncodingEnabled(true);
        int iReturnVal = -1;
        iReturnVal = oFileChooserDlg.showSaveDialog((Component)((Object)this));
        if (iReturnVal == 0) {
            String strFileName = oFileChooserDlg.getFullFileName();
            if (strFileName.toLowerCase(DCResourceMng.getInstance().getLocale()).endsWith(".html") || strFileName.toLowerCase(DCResourceMng.getInstance().getLocale()).endsWith(".htm") || strFileName.toLowerCase(DCResourceMng.getInstance().getLocale()).endsWith(".txt") || strFileName.toLowerCase(DCResourceMng.getInstance().getLocale()).endsWith(".csv")) {
                this.saveRecords(strFileName);
            } else {
                DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("TASK_STATISTICS_TABLE_FILE_TYPE_NOT_SUPP"), ResourceManager.getInstance().getResString("ERROR_MESSAGE"), 0);
            }
        }
    }

    private void saveRecords(final String strFileName) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String strUserName;
                com.huawei.dc.common.framework.utility.print.tools.TablePrintable printable = null;
                String strHeader = ResourceManager.getInstance().getResString("SOFTWARE_STATISTICS_DLG_TITLE");
                Vector oTableDataVector = new Vector();
                String fileHeader = null;
                fileHeader = strUserName = DCFrameWorkUtil.getUserName();
                int iRowCount = SoftwareStatisticsDlg.this.m_statisticsTable.getRowCount();
                int iColumnCount = SoftwareStatisticsDlg.this.m_arrHeader.length;
                int iPrintableRowCount = iRowCount + 1;
                oTableDataVector = SoftwareStatisticsDlg.this.tableDataVec(iRowCount, iColumnCount);
                try {
                    printable = new com.huawei.dc.common.framework.utility.print.tools.TablePrintable(strHeader, fileHeader, " ", SoftwareStatisticsDlg.this.m_arrHeader, oTableDataVector, iPrintableRowCount, SoftwareStatisticsDlg.this.oReportInfoList.size());
                }
                catch (Exception ex) {
                    DCDebugTracer.trace(ex);
                    return;
                }
                String strFileType = null;
                strFileType = strFileName.toLowerCase(DCResourceMng.getInstance().getLocale()).endsWith(".html") || strFileName.toLowerCase(DCResourceMng.getInstance().getLocale()).endsWith(".htm") || strFileName.endsWith(".HTML") || strFileName.endsWith(".HTM") ? "html" : (strFileName.toLowerCase(DCResourceMng.getInstance().getLocale()).endsWith(".csv") ? "csv" : "txt");
                try {
                    PrintSupportor.setIsCheckFileNameAndType(false);
                    PrintSupportor.saveToFile((Window)DCFrameWorkUtil.getMainFrame(), strFileName, printable, strFileType);
                }
                catch (Exception e) {
                    DCDebugTracer.trace(e);
                }
            }
        });
    }

    protected void previewButtonActionPerformed() {
        this.m_previewButton.getModel().setPressed(true);
        this.m_previewButton.getModel().setRollover(true);
        this.m_saveButton.getModel().setPressed(false);
        this.m_saveButton.setBorder(null);
        this.m_saveButton.setBorder(null);
        this.m_saveButton.repaint();
        this.m_printButton.getModel().setPressed(false);
        this.m_printButton.setBorder(null);
        this.m_printButton.repaint();
        this.m_previewButton.setBorder(null);
        this.m_previewButton.repaint();
        this.getPreviewPanel();
    }

    private void getPreviewPanel() {
        DCTablePrintable printable = this.getPrintTable();
        try {
            DCPrintSupportor.preview((JFrame)DCFrameWorkUtil.getMainFrame(), (TablePrintable)printable, (int)printable.getPageCount());
        }
        catch (Exception ex) {
            DCDebugTracer.traceError(ex.getMessage());
            return;
        }
        this.repaint();
    }

    private DCTablePrintable getPrintTable() {
        String strUserName;
        String strHeader = ResourceManager.getInstance().getResString("SOFTWARE_STATISTICS_DLG_TITLE");
        String fileHeader = null;
        fileHeader = strUserName = DCFrameWorkUtil.getUserName();
        DCTablePrintable printable = null;
        Vector tableData = new Vector();
        int iRowCount = this.m_statisticsTable.getRowCount();
        int iColumnCount = this.m_arrHeader.length;
        int iPrintableRowCount = iRowCount + 1;
        tableData = this.tableDataVec(iRowCount, iColumnCount);
        try {
            printable = new DCTablePrintable(strHeader, fileHeader, " ", this.m_arrHeader, tableData, iPrintableRowCount - 1, false);
        }
        catch (Exception ex) {
            DCDebugTracer.traceError(ex.getMessage());
        }
        return printable;
    }

    protected void printRecords() {
        this.m_printButton.getModel().setPressed(true);
        this.m_printButton.getModel().setRollover(true);
        this.m_saveButton.getModel().setPressed(false);
        this.m_previewButton.getModel().setPressed(false);
        this.m_saveButton.setBorder(null);
        this.m_previewButton.setBorder(null);
        this.m_printButton.setBorder(null);
        this.m_saveButton.repaint();
        this.m_previewButton.repaint();
        this.m_printButton.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DCTablePrintable printable = SoftwareStatisticsDlg.this.getPrintTable();
                try {
                    DCPrintSupportor.print((JFrame)DCFrameWorkUtil.getMainFrame(), (TablePrintable)printable, (int)printable.getPageCount());
                    SoftwareStatisticsDlg.this.repaint();
                }
                catch (Exception e) {
                    DCDebugTracer.trace(e);
                    return;
                }
            }
        });
    }

    private Vector tableDataVec(int iRowCount, int iColumnCount) {
        Vector oTableDataVector = new Vector();
        for (int i = 0; i < iRowCount; ++i) {
            Vector<String> rowData = new Vector<String>();
            for (int j = 0; j < iColumnCount; ++j) {
                if (null != this.m_statisticsTable.getValueAt(i, j) && !this.m_statisticsTable.getValueAt(i, j).equals("")) {
                    rowData.add(this.m_statisticsTable.getValueAt(i, j).toString());
                    continue;
                }
                rowData.add(" ");
            }
            oTableDataVector.add(rowData);
        }
        return oTableDataVector;
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_TOPIC_NE_SOFTWARE_STATISTICS";
    }

    class DataAllignmentInCenter
    extends DefaultTableCellRenderer {
        DataAllignmentInCenter() {
        }

        @Override
        protected void setValue(Object value) {
            super.setValue(value);
            this.setHorizontalAlignment(0);
        }
    }

    class SoftwareInfoSortableTableModel
    extends DCSortableTableModel {
        public SoftwareInfoSortableTableModel(String[] columnNames, int rowCount) {
            super((Object[])columnNames, rowCount);
        }

        public void sortByColumn(int column, boolean isDesc) {
            if (-1 == column) {
                return;
            }
            SoftwareInfoSortComparator oComparator = new SoftwareInfoSortComparator(column, isDesc);
            if (null == SoftwareStatisticsDlg.this.oReportInfoList || SoftwareStatisticsDlg.this.oReportInfoList.isEmpty()) {
                return;
            }
            if (0 == column || 1 == column || 2 == column || 3 == column) {
                Collections.sort(SoftwareStatisticsDlg.this.oReportInfoList, oComparator);
            } else {
                int iSize = SoftwareStatisticsDlg.this.oReportInfoList.size();
                for (int index = 0; index < iSize; ++index) {
                    DeviceStatisticsReportInfo oReportInfo = (DeviceStatisticsReportInfo)SoftwareStatisticsDlg.this.oReportInfoList.get(index);
                    List oBoardList = oReportInfo.getBoardList();
                    Collections.sort(oBoardList, oComparator);
                }
            }
            int rowNum = this.getRowCount();
            for (int i = rowNum - 1; i >= 0; --i) {
                this.removeModelRow(i);
            }
            SoftwareStatisticsDlg.this.populateTable(SoftwareStatisticsDlg.this.oReportInfoList);
        }
    }

    class SoftwareInfoSortComparator
    implements Comparator {
        private boolean isDesc = true;
        private int sortedColumn = -1;

        public SoftwareInfoSortComparator(int sortedColumn, boolean isDesc) {
            this.sortedColumn = sortedColumn;
            this.isDesc = !isDesc;
        }

        public int compare(Object o1, Object o2) {
            int result = 0;
            if (0 == this.sortedColumn || 1 == this.sortedColumn || 2 == this.sortedColumn || 3 == this.sortedColumn) {
                DeviceStatisticsReportInfo oReportInfo1 = (DeviceStatisticsReportInfo)o1;
                DeviceStatisticsReportInfo oReportInfo2 = (DeviceStatisticsReportInfo)o2;
                switch (this.sortedColumn) {
                    case 0: {
                        String devName1 = oReportInfo1.getDeviceName();
                        String devName2 = oReportInfo2.getDeviceName();
                        if (this.isDesc) {
                            result = devName1.compareTo(devName2);
                            break;
                        }
                        result = -devName1.compareTo(devName2);
                        break;
                    }
                    case 1: {
                        String devTypeName1 = oReportInfo1.getDeviceTypeName();
                        String devTypeName2 = oReportInfo2.getDeviceTypeName();
                        if (this.isDesc) {
                            result = devTypeName1.compareTo(devTypeName2);
                            break;
                        }
                        result = -devTypeName1.compareTo(devTypeName2);
                        break;
                    }
                    case 2: {
                        String devId1 = oReportInfo1.getDeviceId();
                        String devId2 = oReportInfo2.getDeviceId();
                        if (this.isDesc) {
                            result = devId1.compareTo(devId2);
                            break;
                        }
                        result = -devId1.compareTo(devId2);
                        break;
                    }
                    case 3: {
                        String devVerName1 = oReportInfo1.getDeviceVerName();
                        String devVerName2 = oReportInfo2.getDeviceVerName();
                        if (this.isDesc) {
                            result = devVerName1.compareTo(devVerName2);
                            break;
                        }
                        result = -devVerName1.compareTo(devVerName2);
                        break;
                    }
                }
            } else {
                BoardInformation oBoardInfo1 = (BoardInformation)o1;
                BoardInformation oBoardInfo2 = (BoardInformation)o2;
                if (4 == this.sortedColumn) {
                    int boardId1 = oBoardInfo1.getBoardId();
                    int boardId2 = oBoardInfo2.getBoardId();
                    result = this.isDesc ? boardId1 - boardId2 : boardId2 - boardId1;
                } else if (5 == this.sortedColumn) {
                    String boardName1 = oBoardInfo1.getBoardName();
                    String boardName2 = oBoardInfo2.getBoardName();
                    result = this.isDesc ? boardName1.compareTo(boardName2) : -boardName1.compareTo(boardName2);
                } else {
                    HashMap oVerMap2;
                    String strVal2;
                    HashMap oVerMap1 = oBoardInfo1.getVersionMap();
                    String strVal1 = (String)oVerMap1.get(SoftwareStatisticsDlg.this.m_arrHeader[this.sortedColumn]);
                    if (null == strVal1 || 0 == strVal1.length()) {
                        strVal1 = "_";
                    }
                    if (null == (strVal2 = (String)(oVerMap2 = oBoardInfo2.getVersionMap()).get(SoftwareStatisticsDlg.this.m_arrHeader[this.sortedColumn])) || 0 == strVal2.length()) {
                        strVal2 = "_";
                    }
                    result = this.isDesc ? strVal1.compareTo(strVal2) : -strVal1.compareTo(strVal2);
                }
            }
            return result;
        }
    }

    class TopTableHeaderListener
    implements MouseMotionListener {
        TopTableHeaderListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            SoftwareStatisticsDlg.this.m_statisticsTable.updateUI();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int colNum = SoftwareStatisticsDlg.this.m_statisticsTable.getColumnModel().getColumnIndexAtX(e.getX());
            if (colNum > -1) {
                SoftwareStatisticsDlg.this.m_statisticsTable.getTableHeader().setToolTipText(SoftwareStatisticsDlg.this.m_statisticsTable.getColumnName(colNum));
            }
        }
    }
}

