/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.view;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnFTPConfigInfoRsp;
import com.huawei.dc.common.asndatacenter.AsnFTPConfigItem;
import com.huawei.dc.common.asndatacenter.AsnFTPConfigReq;
import com.huawei.dc.common.asndatacenter.AsnFTPConfigRsp;
import com.huawei.dc.common.asndatacenter.AsnftpTypeEnum;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.framework.system.ISystemManager;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.configuration.system.FTSInfo;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.security.SecurityManagerImpl;
import com.huawei.dc.standalone.view.ModifyPasswordPanel;
import com.huawei.dc.toolkit.client.base.util.TKCommonUtil;
import com.huawei.dc.toolkit.client.base.util.TKResourceManager;
import com.swimap.iview.util.DebugTracer;
import com.swimap.iview.util.SyncCommand;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.commustru.fstru.FStruct;

public class SelfXftpConfigDialog
extends DCModalDialog {
    private static final long serialVersionUID = 277667121858032412L;
    private static final Icon ICON_FTPOK = TKResourceManager.getIcon("ftpok.gif");
    private static final Icon ICON_FTPSTOP = TKResourceManager.getIcon("ftpstop.gif");
    private static final Icon ICON_FTPSTATE = ResourceManager.getInstance().getImage("run.gif");
    private JButton ModifyPwdkeyBtn = new JButton();
    private JButton CanelBotton = new JButton();
    private JButton StopBotton = new JButton();
    private JButton StartBotton = new JButton();
    private JTextField userNameText = new JTextField();
    private JPasswordField userPasswordText = new JPasswordField();
    private JTextField portNumText = new JTextField();
    private JTextField fileRootText = new JTextField();
    private char[] password;
    private BigInteger iUserID;
    private AsnftpTypeEnum eFtptype;
    private int start = 8;
    boolean isStart = false;
    static final String CHAR_COLON = ":";
    static final String CHAR_AT = "@";
    private static String String = null;
    AsnFTPConfigReq asnFTPConfigReq = new AsnFTPConfigReq();
    AsnFTPConfigRsp asnFTPConfigRsp = new AsnFTPConfigRsp();
    AsnFTPConfigItem asnFTPConfigItem = new AsnFTPConfigItem();
    AsnFTPConfigInfoRsp asnFTPConfigInfoRsp = new AsnFTPConfigInfoRsp();
    private SecurityManagerImpl securityManagerImpl = new SecurityManagerImpl();
    private JLabel ftpStateLabel = new JLabel();
    private ISystemManager m_oSystemManager;
    private FTSInfo m_oFTSInfo = null;
    boolean islegal = true;
    private JLabel startState = new JLabel();
    private JLabel stopState = new JLabel();

    public SelfXftpConfigDialog() {
        this.getContentPane().setLayout(null);
        this.setSize(400, 300);
        this.setTitle(ResourceManager.getInstance().getResString("FTP_SERVER_CONFIG"));
        this.getFTPInfo();
        this.init();
    }

    private void init() {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        if (this.start == 0) {
            this.ftpStateLabel.setText(ResourceManager.getInstance().getResString("FTP_START"));
            this.ftpStateLabel.setIcon(ICON_FTPOK);
            this.StartBotton.setEnabled(false);
            this.userNameText.setEditable(false);
        } else {
            this.ftpStateLabel.setText(ResourceManager.getInstance().getResString("FTP_NOTRUNNING"));
            this.ftpStateLabel.setIcon(ICON_FTPSTOP);
            this.StopBotton.setEnabled(false);
            this.userNameText.setEditable(true);
        }
        this.startState.setText(ResourceManager.getInstance().getResString("FTP_IS_STRAT_LABEL"));
        this.stopState.setText(ResourceManager.getInstance().getResString("FTP_IS_STOP_LABEL"));
        this.startState.setIcon(ICON_FTPSTATE);
        this.stopState.setIcon(ICON_FTPSTATE);
        JLabel userNameLabel = new JLabel(ResourceManager.getInstance().getResString("LOGIN_USERNAME_LBL"), 2);
        JLabel modifyPasswordLabel = new JLabel(ResourceManager.getInstance().getResString("MODIFY_FTP_PASSWORD_LABEL"), 2);
        JLabel protNumLabel = new JLabel(ResourceManager.getInstance().getResString("SET_NEW_MDP_PORT"), 2);
        JLabel fileRootLabel = new JLabel(ResourceManager.getInstance().getResString("DIRECTORY_SETTING") + CHAR_COLON, 2);
        JLabel prompt = new JLabel(ResourceManager.getInstance().getResString("PROMPT"), 2);
        this.ModifyPwdkeyBtn.setText(ResourceManager.getInstance().getResString("..."));
        this.StartBotton.setText(ResourceManager.getInstance().getResString("BUTTON_SERVICE_START"));
        this.CanelBotton.setText(ResourceManager.getInstance().getResString("LICENSE_AUTH_CANCEL"));
        this.StopBotton.setText(ResourceManager.getInstance().getResString("BUTTON_SERVICE_STOP"));
        this.ftpStateLabel.setBounds(30, 10, 300, 35);
        this.startState.setBounds(30, 10, 300, 35);
        this.stopState.setBounds(30, 10, 300, 35);
        this.startState.setVisible(false);
        this.stopState.setVisible(false);
        userNameLabel.setBounds(0, 20, 100, 30);
        modifyPasswordLabel.setBounds(0, 50, 100, 30);
        protNumLabel.setBounds(0, 85, 100, 30);
        fileRootLabel.setBounds(0, 120, 100, 30);
        this.userNameText.setBounds(120, 20, 220, 25);
        this.userPasswordText.setBounds(120, 50, 188, 25);
        this.ModifyPwdkeyBtn.setBounds(310, 53, 30, 20);
        this.portNumText.setBounds(120, 85, 220, 25);
        this.fileRootText.setBounds(120, 120, 220, 25);
        prompt.setBounds(20, 165, 350, 75);
        this.StartBotton.setBounds(82, 230, 75, 25);
        this.CanelBotton.setBounds(245, 230, 75, 25);
        this.StopBotton.setBounds(165, 230, 75, 25);
        this.StartBotton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SelfXftpConfigDialog.this.StartBotton_actionPerformed();
                    }
                });
            }
        });
        this.CanelBotton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelfXftpConfigDialog.this.CanelBotton_actionPerformed();
            }
        });
        this.ModifyPwdkeyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelfXftpConfigDialog.this.ModifyPwdkeyBtn_actionPerformed();
            }
        });
        this.StopBotton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelfXftpConfigDialog.this.stopFTPServer();
            }
        });
        panel.add(userNameLabel);
        panel.add(modifyPasswordLabel);
        panel.add(protNumLabel);
        panel.add(fileRootLabel);
        panel.add(this.userNameText);
        panel.add(this.userPasswordText);
        panel.add(this.portNumText);
        panel.add(this.fileRootText);
        panel.add(this.ModifyPwdkeyBtn);
        panel.setBounds(5, 30, 385, 150);
        this.getContentPane().add(this.ftpStateLabel);
        this.getContentPane().add(this.startState);
        this.getContentPane().add(this.stopState);
        this.getContentPane().add(panel);
        this.getContentPane().add(prompt);
        this.getContentPane().add(this.StartBotton);
        this.getContentPane().add(this.CanelBotton);
        this.getContentPane().add(this.StopBotton);
    }

    public AsnFTPConfigInfoRsp getFtpSettingInfo() throws DCException {
        this.asnFTPConfigInfoRsp = new AsnFTPConfigInfoRsp();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int errorcode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(44103), null, (FStruct)SelfXftpConfigDialog.this.asnFTPConfigInfoRsp);
                return errorcode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        int iErrorCode = 0;
        iErrorCode = null != syncCommand.getResult() ? (Integer)syncCommand.getResult() : -1;
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
        return this.asnFTPConfigInfoRsp;
    }

    public boolean checkFileRoot(String fileRoot) {
        String substring;
        String[] regexs = new String[]{"[ \"`~!@#$%^&*()=+|{}\\[\\];',\\?<>]/"};
        CharBuffer buf = CharBuffer.wrap(fileRoot);
        for (int i = 0; i < regexs.length; ++i) {
            Pattern p = Pattern.compile(regexs[i]);
            Matcher matcher = p.matcher(buf);
            if (!matcher.find()) continue;
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("FILE_SPECIAL_CHAR"), ResourceManager.getInstance().getResString("CHECK_FILE_TRANSFER_STATUS"), 1);
            return false;
        }
        int index = fileRoot.indexOf("\\");
        if (index > 0 && (substring = fileRoot.substring(index + 1)).startsWith("\\")) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("FILE_SPECIAL_CHAR"), ResourceManager.getInstance().getResString("CHECK_FILE_TRANSFER_STATUS"), 1);
            return false;
        }
        if (0 < fileRoot.indexOf("/")) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("FILE_SPECIAL_CHAR"), ResourceManager.getInstance().getResString("CHECK_FILE_TRANSFER_STATUS"), 1);
            return false;
        }
        if (fileRoot.length() == 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SAM_SEARCH_EMPTY_STRING_ERROR"), ResourceManager.getInstance().getResString("INFO"), 1);
            return false;
        }
        int iErrorCode = this.m_oSystemManager.setFTSInfo(this.m_oFTSInfo);
        if (iErrorCode != 0) {
            TKCommonUtil.setRootPath(fileRoot);
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("FTP_ROOTPATH_ERROR"), ResourceManager.getInstance().getResString("CHECK_FILE_TRANSFER_STATUS"), 1);
            return false;
        }
        return true;
    }

    private boolean checkPort() {
        if (this.portNumText.getText().length() == 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("PORT_EMPTY"), ResourceManager.getInstance().getResString("INFO"), 1);
            return false;
        }
        int i = this.portNumText.getText().length();
        while (--i >= 0) {
            if (Character.isDigit(this.portNumText.getText().charAt(i))) continue;
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("INVALID_DEVICE_PORT"), ResourceManager.getInstance().getResString("INFO"), 1);
            return false;
        }
        int prot = Integer.parseInt(this.portNumText.getText(), 10);
        if (prot < 1 || prot > 65535) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SET_FTP_PORT"), ResourceManager.getInstance().getResString("INFO"), 1);
            return false;
        }
        if (this.userNameText.getText().length() == 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("USER_NAME_BLANK"), ResourceManager.getInstance().getResString("INFO"), 1);
            return false;
        }
        return true;
    }

    private void StartBotton_actionPerformed() {
        this.ftpStateLabel.setVisible(false);
        this.startState.setVisible(true);
        this.asnFTPConfigReq = this.updateMessage();
        boolean portRight = this.checkPort();
        if (!portRight) {
            return;
        }
        boolean fileRight = this.checkFileRoot(this.fileRootText.getText());
        if (!fileRight) {
            return;
        }
        BaseCommManager commManager = DCFrameWorkUtil.getCommManager();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int errorcode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(44101), (FStruct)SelfXftpConfigDialog.this.asnFTPConfigReq, (FStruct)SelfXftpConfigDialog.this.asnFTPConfigRsp);
                return errorcode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        int errorCode = this.asnFTPConfigRsp.iErrorCode.intValue();
        String errMsg = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(errorCode));
        if (errorCode != 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString(errMsg), ResourceManager.getInstance().getResString("PROMPT_FOR_OPIICAL"), 1);
            this.ftpStateLabel.setText(ResourceManager.getInstance().getResString("FTP_NOTRUNNING"));
            this.ftpStateLabel.setIcon(ICON_FTPSTOP);
            this.StartBotton.setEnabled(true);
            this.StopBotton.setEnabled(false);
            this.ftpStateLabel.setVisible(true);
            this.startState.setVisible(false);
            this.stopState.setVisible(false);
            return;
        }
        this.ftpStateLabel.setVisible(true);
        this.startState.setVisible(false);
        this.ftpStateLabel.setText(ResourceManager.getInstance().getResString("FTP_START"));
        this.ftpStateLabel.setIcon(ICON_FTPOK);
        this.StartBotton.setEnabled(false);
        this.StopBotton.setEnabled(true);
        this.userNameText.setEditable(false);
    }

    private void CanelBotton_actionPerformed() {
        super.closeDialog();
    }

    private void ModifyPwdkeyBtn_actionPerformed() {
        ModifyPasswordPanel modifyPanel = new ModifyPasswordPanel();
        modifyPanel.setDefaultCloseOperation(2);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        modifyPanel.setLocation(screenSize.width * 2 / 5, screenSize.height * 2 / 5);
        modifyPanel.setVisible(true);
        if (modifyPanel.getIsModifySuccess()) {
            this.password = modifyPanel.getNewPwd();
        }
    }

    private void stopFTPServer() {
        this.ftpStateLabel.setVisible(false);
        this.stopState.setVisible(true);
        this.asnFTPConfigReq = this.updateMessage();
        boolean portRight = this.checkPort();
        if (!portRight) {
            return;
        }
        boolean fileRight = this.checkFileRoot(this.fileRootText.getText());
        if (!fileRight) {
            return;
        }
        BaseCommManager commManager = DCFrameWorkUtil.getCommManager();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int errorcode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(44102), (FStruct)SelfXftpConfigDialog.this.asnFTPConfigReq, (FStruct)SelfXftpConfigDialog.this.asnFTPConfigRsp);
                return errorcode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        int errorCode = this.asnFTPConfigRsp.iErrorCode.intValue();
        String errMsg = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(errorCode));
        if (errorCode != 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString(errMsg), ResourceManager.getInstance().getResString("INFO"), 1);
            return;
        }
        this.ftpStateLabel.setVisible(true);
        this.stopState.setVisible(false);
        this.ftpStateLabel.setText(ResourceManager.getInstance().getResString("FTP_NOTRUNNING"));
        this.ftpStateLabel.setIcon(ICON_FTPSTOP);
        this.StopBotton.setEnabled(false);
        this.StartBotton.setEnabled(true);
        this.userNameText.setEditable(true);
    }

    private void getFTPInfo() {
        try {
            this.asnFTPConfigInfoRsp = this.getFtpSettingInfo();
        }
        catch (DCException e) {
            DebugTracer.trace((String)e.getMessage());
        }
        AsnFTPConfigItem oAsnFTPConfigItem = (AsnFTPConfigItem)this.asnFTPConfigInfoRsp.oAsnFTPConfigItemLst.get(0);
        this.asnFTPConfigReq.eFtptype = oAsnFTPConfigItem.eFtptype;
        this.eFtptype = oAsnFTPConfigItem.eFtptype;
        this.asnFTPConfigReq.strUserName = oAsnFTPConfigItem.strUserName;
        this.asnFTPConfigReq.strPassword = oAsnFTPConfigItem.strPassword;
        this.password = DCCommonUtil.convertByteArrayToChar(oAsnFTPConfigItem.strPassword);
        this.asnFTPConfigReq.strPath = oAsnFTPConfigItem.strPath;
        this.asnFTPConfigReq.iPort = oAsnFTPConfigItem.iPort;
        this.asnFTPConfigReq.iUserID = BigInteger.valueOf(this.securityManagerImpl.getUserId());
        this.start = oAsnFTPConfigItem.eStatus.value;
        this.iUserID = this.asnFTPConfigReq.iUserID;
        this.asnFTPConfigReq.bInsertDB = true;
        this.start = oAsnFTPConfigItem.eStatus.value;
        if (DCFrameWorkUtil.getIsSingleClient()) {
            this.isStart = this.start != 1;
        }
        String userName = new String(this.asnFTPConfigReq.strUserName);
        String file = new String(this.asnFTPConfigReq.strPath);
        this.userNameText.setText(userName);
        this.userPasswordText.setText("......");
        this.userPasswordText.setEnabled(false);
        this.portNumText.setText(oAsnFTPConfigItem.iPort.toString());
        this.portNumText.setEditable(false);
        this.fileRootText.setText(file);
    }

    private AsnFTPConfigReq updateMessage() {
        this.iUserID = this.asnFTPConfigReq.iUserID = BigInteger.valueOf(this.securityManagerImpl.getUserId());
        this.asnFTPConfigReq.bInsertDB = true;
        this.asnFTPConfigReq.strUserName = this.userNameText.getText().getBytes();
        this.asnFTPConfigReq.strPath = this.fileRootText.getText().getBytes();
        this.asnFTPConfigReq.strPassword = java.lang.String.valueOf(this.password).getBytes();
        this.asnFTPConfigReq.eFtptype = this.eFtptype;
        int iPort = Integer.parseInt(this.portNumText.getText());
        this.asnFTPConfigReq.iPort = BigInteger.valueOf(iPort);
        String userName = new String(this.asnFTPConfigReq.strUserName);
        String file = new String(this.asnFTPConfigReq.strPath);
        this.userNameText.setText(userName);
        this.userPasswordText.setText("......");
        this.userPasswordText.setEnabled(false);
        this.fileRootText.setText(file);
        this.m_oFTSInfo = new FTSInfo();
        String fileRoot = this.fileRootText.getText();
        String fileRootDir = this.checkLastChar(fileRoot);
        this.m_oFTSInfo.setRootDirectory(fileRootDir);
        this.m_oSystemManager = new SystemManager();
        this.m_oFTSInfo.setFTPPassword(this.password);
        this.m_oFTSInfo.setFTPPortNumber(iPort);
        this.m_oFTSInfo.setFTPUserName(userName);
        return this.asnFTPConfigReq;
    }

    @Override
    protected String getCurrentContext() {
        return null;
    }

    private String checkLastChar(String strDirectory) {
        if (strDirectory.length() > 1 && (strDirectory.endsWith("/") || strDirectory.endsWith("\\"))) {
            strDirectory = strDirectory.substring(0, strDirectory.length() - 1);
            while (strDirectory.endsWith("\\")) {
                strDirectory = strDirectory.substring(0, strDirectory.length() - 1);
            }
        }
        return strDirectory;
    }
}

