/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.view;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.standalone.controller.IDCStandAloneSyncCtrller;
import com.huawei.dc.standalone.controller.StandAloneCommUtil;
import com.huawei.dc.standalone.controller.StandAloneSyncCtrller;
import com.huawei.dc.standalone.search.view.SearchGatewayDeviceDialog;
import com.huawei.dc.standalone.view.IAddGatewayAddr;
import com.swimap.iview.templates.textfield.ipaddress.IPAddressTextField;
import com.swimap.iview.templates.textfield.ipaddress.InValideIPAddressException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboBoxEditor;

public class SearchGatewayAddressPanel
extends JPanel
implements IAddGatewayAddr {
    private ComboBoxWithToolTip m_oGateWayIPAddressDropDown;
    private JButton m_oSearchButton;
    private ResourceManager m_oResMgr = ResourceManager.getInstance();
    private IDCStandAloneSyncCtrller m_oStandAloneSyncCtrller;
    private IPAddressTextField m_oIPEditorField;
    private JTextField m_oOSIGatewayAddrTextField;
    private static final int START_INDEX = 0;
    private boolean m_isOSIGateway = false;

    public SearchGatewayAddressPanel() {
        this.setLayout(new BoxLayout(this, 2));
        this.m_oStandAloneSyncCtrller = StandAloneSyncCtrller.getInstance();
        this.jInit();
    }

    private void jInit() {
        this.m_oSearchButton = new JButton();
        this.m_oSearchButton.setMinimumSize(new Dimension(21, 20));
        this.m_oSearchButton.setPreferredSize(new Dimension(21, 20));
        this.m_oSearchButton.setMaximumSize(new Dimension(21, 20));
        this.m_oSearchButton.setName("com.huawei.dc.standalone.view.SearchGatewayAddressPanel.m_oSearchButton");
        this.m_oSearchButton.setFocusable(false);
        this.m_oSearchButton.setToolTipText(this.m_oResMgr.getResString("SEARCH_BUTTON"));
        this.m_oSearchButton.setIcon(this.m_oResMgr.getImage("searchObject.gif"));
        this.m_oSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SearchGatewayAddressPanel.this.searchButtonActionPerformed();
            }
        });
        this.m_oGateWayIPAddressDropDown = new ComboBoxWithToolTip();
        this.m_oGateWayIPAddressDropDown.setName("com.huawei.dc.standalone.view.SearchGatewayAddressPanel.m_oGateWayIPAddressDropDown");
        this.m_oGateWayIPAddressDropDown.setEditable(true);
        this.m_oIPEditorField = new IPAddressTextField();
        this.m_oIPEditorField.setName("com.huawei.dc.standalone.view.SearchGatewayAddressPanel.m_oIPEditorField");
        this.m_oOSIGatewayAddrTextField = new JTextField();
        this.m_oOSIGatewayAddrTextField.setName("com.huawei.dc.standalone.view.SearchGatewayAddressPanel.m_oOSIGatewayAddrTextField");
        this.initIPGatewayAddtess();
        this.m_oGateWayIPAddressDropDown.setEditor(new BasicComboBoxEditor(){

            @Override
            public Component getEditorComponent() {
                if (SearchGatewayAddressPanel.this.m_isOSIGateway) {
                    return SearchGatewayAddressPanel.this.m_oOSIGatewayAddrTextField;
                }
                return SearchGatewayAddressPanel.this.m_oIPEditorField;
            }
        });
        this.m_oGateWayIPAddressDropDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SearchGatewayAddressPanel.this.ipGatewayDropDownActionPerformed();
            }
        });
        this.add(this.m_oGateWayIPAddressDropDown);
        this.add(this.m_oSearchButton);
    }

    private void initIPGatewayAddtess() {
        List<String> oGatewayIPLst = DeviceInfoUtil.getGatewayIPLst();
        if (null == oGatewayIPLst || oGatewayIPLst.size() == 0) {
            return;
        }
        for (String sGatewayIP : oGatewayIPLst) {
            this.m_oGateWayIPAddressDropDown.addItem(sGatewayIP);
        }
    }

    private void searchButtonActionPerformed() {
        SearchGatewayDeviceDialog oSearchGatewayDeviceDialog = null;
        int iRequestId = DCFrameWorkUtil.generateRequestId();
        oSearchGatewayDeviceDialog = new SearchGatewayDeviceDialog(1, iRequestId, this);
        try {
            this.m_oStandAloneSyncCtrller.startSearchForGWDev(iRequestId);
        }
        catch (DCException e) {
            DCOptionPane.showMessageDialog((Component)this, e.getMessage(), ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        oSearchGatewayDeviceDialog.setVisible(true);
    }

    private void ipGatewayDropDownActionPerformed() {
        String strSelectedItem = (String)this.m_oGateWayIPAddressDropDown.getItemAt(this.m_oGateWayIPAddressDropDown.getSelectedIndex());
        if (null != strSelectedItem) {
            if ("".equals(strSelectedItem)) {
                this.m_oIPEditorField.setText("256.256.256.256");
            } else {
                this.m_oIPEditorField.setText(strSelectedItem);
            }
        }
    }

    public String getSelectAddr() {
        String strAddr = "";
        try {
            strAddr = this.m_oIPEditorField.getTrimedAddress();
            ArrayList<String> ipLst = new ArrayList<String>();
            ipLst.add(strAddr);
            this.updateGatewayIPDropDown(ipLst);
        }
        catch (InValideIPAddressException e) {
            DCDebugTracer.trace((Exception)((Object)e));
        }
        return strAddr;
    }

    public void setAddr(String strAddr) {
        if ("".equals(strAddr)) {
            this.m_oIPEditorField.setText("256.256.256.256");
        } else {
            this.m_oIPEditorField.setText(strAddr);
            ArrayList<String> ipLst = new ArrayList<String>();
            ipLst.add(strAddr);
            this.updateGatewayIPDropDown(ipLst);
        }
    }

    @Override
    public void updateGatewayIPDropDown(List oIPList) {
        boolean bExist = false;
        int iSize = oIPList.size();
        StandAloneCommUtil.setGateIPAddLst(oIPList);
        int iIPCount = this.m_oGateWayIPAddressDropDown.getItemCount();
        for (int index = 0; index < iSize; ++index) {
            bExist = false;
            String strIP = (String)oIPList.get(index);
            for (int i = 0; i < iIPCount; ++i) {
                String strValue = (String)this.m_oGateWayIPAddressDropDown.getItemAt(i);
                if (!Collator.getInstance().equals(strValue, strIP)) continue;
                this.m_oGateWayIPAddressDropDown.removeItemAt(i);
                this.m_oGateWayIPAddressDropDown.insertItemAt(strIP, 0);
                this.m_oGateWayIPAddressDropDown.setSelectedIndex(0);
                bExist = true;
                break;
            }
            if (!bExist) {
                this.m_oGateWayIPAddressDropDown.insertItemAt(strIP, 0);
                iIPCount = this.m_oGateWayIPAddressDropDown.getItemCount();
            }
            this.m_oIPEditorField.setText(strIP);
        }
    }

    @Override
    public void setGatewayDropDown(String strIp) {
        int iItemCount = this.m_oGateWayIPAddressDropDown.getItemCount();
        for (int index = 0; index < iItemCount; ++index) {
            String strValue = (String)this.m_oGateWayIPAddressDropDown.getItemAt(index);
            if (!Collator.getInstance().equals(strIp, strValue)) continue;
            this.m_oGateWayIPAddressDropDown.removeItemAt(index);
            this.m_oGateWayIPAddressDropDown.insertItemAt(strIp, 0);
            this.m_oGateWayIPAddressDropDown.setSelectedIndex(0);
            this.m_oIPEditorField.setText(strIp);
        }
    }

    public void setIsSelected(JTable table, boolean isSelected) {
        if (isSelected) {
            this.m_oIPEditorField.setForeground(table.getSelectionForeground());
            this.m_oIPEditorField.setBackground(table.getSelectionBackground());
        } else {
            this.m_oIPEditorField.setForeground(table.getForeground());
            this.m_oIPEditorField.setBackground(table.getBackground());
        }
    }
}

