/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.view;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.view.JSortTreeTable;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.CloneUtil;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.PopupMenuManager;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.MenuUtil;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.IOperation;
import com.huawei.dc.devicemanagement.model.xmlconfig.DeviceXMLConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;
import com.huawei.dc.standalone.model.RouterDevInfoObj;
import com.huawei.dc.standalone.view.CommonManualOprButtonPanel;
import com.huawei.dc.standalone.view.RouterDevInfoPanel;
import com.swimap.iview.commstyle.commini.Menu;
import com.swimap.iview.framework.menumanagement.MenuManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class RouterDevPopmenuManager {
    private CommonManualOprButtonPanel m_oManualOperationButtonPanel;
    private JSortTreeTable m_sortTreeTable;
    private JMenuItem m_createDevMenuItem;
    private JMenuItem m_createNewNodeMenuItem;
    private JMenuItem m_deleteDevMenuItem;
    private JMenuItem m_deleteMemoryMenuItem;
    private JMenu m_devManagementMenu;
    private JMenuItem m_exportCheckItemMenuItem;
    private JMenuItem m_exportDevMenuItem;
    private JMenuItem m_exportTemplateMenuItem;
    private JMenuItem m_getPatchMenuItem;
    private JMenuItem m_getVersionMenuItem;
    private JMenu m_newTaskMenuItem;
    private JMenuItem m_recoverMenuItem;
    private JPopupMenu m_routerDevTablePopupMenu;
    private PopupMenuManager m_oPopupMenuManager;
    private JMenuItem m_saveMenuItem;
    private JMenuItem m_databaseOperMenuItem;
    private JMenuItem m_backupMenuItem;
    private JMenuItem m_telnetTerminelMenuItem;
    private Menu m_oNeMenu;
    RouterDevInfoPanel oRouterDevInfoPanel = null;

    public void initPopupMenu() {
        this.m_oPopupMenuManager = PopupMenuManager.getInstance();
        this.m_routerDevTablePopupMenu = this.m_oPopupMenuManager.load(this.oRouterDevInfoPanel, "devicetablepopupmenu_ip");
        this.m_devManagementMenu = this.m_oPopupMenuManager.getMenu(ResourceManager.getInstance().getResString("DEVICE_MANAGEMENT"), this.m_routerDevTablePopupMenu);
        this.m_createNewNodeMenuItem = this.m_oPopupMenuManager.getMenuItemFromJMenu(ResourceManager.getInstance().getResString("ADD_DEVICE_EXPORT_NEW_PROXY_NODE_BUTTON_TEXT"), this.m_devManagementMenu);
        this.m_createDevMenuItem = this.m_oPopupMenuManager.getMenuItemFromJMenu(ResourceManager.getInstance().getResString("ADD_DEVICE_INSERT_NEW_MENU_TEXT"), this.m_devManagementMenu);
        this.m_deleteDevMenuItem = this.m_oPopupMenuManager.getMenuItemFromJMenu(ResourceManager.getInstance().getResString("ADD_DEVICE_DELETE_MENU_TEXT"), this.m_devManagementMenu);
        this.m_exportDevMenuItem = this.m_oPopupMenuManager.getMenuItemFromJMenu(ResourceManager.getInstance().getResString("DEVICETABLE_POPUP_MENU_ITEM_EXPORT_DEVICES"), this.m_devManagementMenu);
        this.m_exportTemplateMenuItem = this.m_oPopupMenuManager.getMenuItemFromJMenu(ResourceManager.getInstance().getResString("DEVICETABLE_POPUP_MENU_ITEM_EXPORT_DEVICES_TEMPLATE"), this.m_devManagementMenu);
        this.m_exportCheckItemMenuItem = this.m_oPopupMenuManager.getMenuItemFromJMenu(ResourceManager.getInstance().getResString("EXPORT_CHECK_ITEM_MODEL_MENU"), this.m_devManagementMenu);
        this.m_saveMenuItem = this.m_oPopupMenuManager.getMenuItem(ResourceManager.getInstance().getResString("DEVICETABLE_POPUP_MENU_ITEM_SAVE"), this.m_routerDevTablePopupMenu);
        this.m_backupMenuItem = this.m_oPopupMenuManager.getMenuItem(ResourceManager.getInstance().getResString("DEVICETABLE_POPUP_MENU_ITEM_BACKUP"), this.m_routerDevTablePopupMenu);
        this.m_recoverMenuItem = this.m_oPopupMenuManager.getMenuItem(ResourceManager.getInstance().getResString("DEVICETABLE_POPUP_MENU_ITEM_RECOVER"), this.m_routerDevTablePopupMenu);
        this.m_getVersionMenuItem = this.m_oPopupMenuManager.getMenuItem(ResourceManager.getInstance().getResString("DEVICETABLE_POPUP_MENU_ITEM_VERSION"), this.m_routerDevTablePopupMenu);
        this.m_getPatchMenuItem = this.m_oPopupMenuManager.getMenuItem(ResourceManager.getInstance().getResString("DEVICETABLE_POPUP_MENU_ITEM_GET_PATCH"), this.m_routerDevTablePopupMenu);
        this.m_newTaskMenuItem = this.m_oPopupMenuManager.getMenu(ResourceManager.getInstance().getResString("TASK_NEW_TASK"), this.m_routerDevTablePopupMenu);
        this.m_deleteMemoryMenuItem = this.m_oPopupMenuManager.getMenuItem(ResourceManager.getInstance().getResString("DEVICETABLE_POPUP_MENU_DELETE_MEMORY"), this.m_routerDevTablePopupMenu);
        this.m_telnetTerminelMenuItem = this.m_oPopupMenuManager.getMenuItem(ResourceManager.getInstance().getResString("DEVICETABLE_POPUP_MENU_ITEM_TELNET_TERMINEL"), this.m_routerDevTablePopupMenu);
        JPopupMenu m_oNewTaskPopupMenu = PopupMenuManager.getInstance().load(this.oRouterDevInfoPanel, "taskmgmtpopupmenufornewtaskbutton");
        this.m_oPopupMenuManager.getMenuItem(ResourceManager.getInstance().getResString("OLT_UPGRADE_TASK_MENU_ITEM"), m_oNewTaskPopupMenu).setVisible(false);
        this.m_oPopupMenuManager.getMenuItem(ResourceManager.getInstance().getResString("PACKAGE_UPGRADE_DOWNGRADE_TASK_MENU_ITEM"), m_oNewTaskPopupMenu).setVisible(false);
        this.m_oPopupMenuManager.getMenuItem(ResourceManager.getInstance().getResString("MIMIC_PACKAGE_UPDATE_TASK_MENU_ITEM"), m_oNewTaskPopupMenu).setVisible(false);
        this.m_oPopupMenuManager.getMenuItem(ResourceManager.getInstance().getResString("PACKAGE_DIFFUSION_UPGRADE_DOWNGRADE_TASK_MENU_ITEM"), m_oNewTaskPopupMenu).setVisible(false);
        this.m_oManualOperationButtonPanel.setPopupMenu(m_oNewTaskPopupMenu);
        this.m_databaseOperMenuItem = this.m_oPopupMenuManager.getMenuItem(ResourceManager.getInstance().getResString("DATABASE_OPERATION"), this.m_routerDevTablePopupMenu);
        MenuManager oMenuManager = DCFrameWorkUtil.getDCMenuManager();
        this.m_oNeMenu = oMenuManager.getMenu("neManageMenu", "neManage");
    }

    public JPopupMenu getPopupMenu() {
        return this.m_routerDevTablePopupMenu;
    }

    public void checkRightForPopupMenu() {
        this.initMenuItemStatus();
        int iSelectedRowCount = this.m_sortTreeTable.getSelectedRowCount();
        int iRowCount = this.m_sortTreeTable.getRowCount();
        if (0 < iRowCount) {
            this.m_oManualOperationButtonPanel.getSaveDevLstButton().setEnabled(true);
        }
        if (0 < iRowCount && 0 < iSelectedRowCount) {
            MenuUtil.enableMenuItem((Component)this.m_deleteDevMenuItem, true);
            MenuUtil.enableMenuItem((Component)this.m_exportDevMenuItem, true);
            MenuUtil.enableMenuItem(this.m_oNeMenu, "ExportDevices", true);
            if (1 == iSelectedRowCount) {
                this.handleSelectOnlyOneDev();
            } else {
                this.handleSelMultiDev();
            }
        } else {
            this.disableAllOprMenu();
        }
        MenuUtil.orgSeparator(this.m_routerDevTablePopupMenu);
    }

    public RouterDevPopmenuManager(RouterDevInfoPanel routerDevInfoPanel, JSortTreeTable oDevTreeTable, CommonManualOprButtonPanel oManualOperationButtonPanel) {
        this.oRouterDevInfoPanel = routerDevInfoPanel;
        this.m_sortTreeTable = oDevTreeTable;
        this.m_oManualOperationButtonPanel = oManualOperationButtonPanel;
    }

    private boolean checkIsSupportDeleteNEFileOpr(List<Integer> iSelectDevIds) {
        IDeviceInfoManager devInfoMgr = DeviceInfoManagerImpl.getInstance();
        IDeviceTypeConfigModel oDeviceTypeConfigModel = null;
        for (int i = 0; i < iSelectDevIds.size(); ++i) {
            IOperation operation;
            DeviceInfo oDevice = devInfoMgr.getDevice(iSelectDevIds.get(i));
            if (null == oDevice) {
                DCDebugTracer.traceError("[HGMP]checkisSupportDeleteNEFileOpr oDevice is null.devId=" + iSelectDevIds.get(i));
                continue;
            }
            DeviceTypeInfo oTypeInfo = (DeviceTypeInfo)CloneUtil.getClone(oDevice.getDeviceTypeInfo());
            if (null != oTypeInfo) {
                String strDevTypeVer = oTypeInfo.getDevTypeVersionName() + "_telnet";
                oTypeInfo.setDevTypeVersionName(strDevTypeVer);
            }
            if (null == oTypeInfo) {
                DCDebugTracer.traceError("[HGMP]checkisSupportDeleteNEFileOpr oTypeInfo is null.devId=" + iSelectDevIds.get(i));
                continue;
            }
            int[] iDeviceIdLst = new int[]{oDevice.getDevId()};
            oDeviceTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oTypeInfo, iDeviceIdLst);
            if (null != oDeviceTypeConfigModel && null != (operation = oDeviceTypeConfigModel.getOperationObj(5, 41))) {
                return true;
            }
            DCDebugTracer.traceError("[HGMP]isVisibleDeleteMemory:3.device=" + oDevice);
        }
        DCDebugTracer.traceError("[HGMP]checkisSupportDeleteNEFileOpr end");
        return false;
    }

    public void handleSelMultiDev() {
        ArrayList<Integer> iSelectDevIds = new ArrayList<Integer>();
        boolean bIsVisibleDeleteMemory = false;
        this.m_deleteMemoryMenuItem.setEnabled(false);
        this.m_telnetTerminelMenuItem.setVisible(true);
        this.m_telnetTerminelMenuItem.setEnabled(false);
        JTree tree = this.m_sortTreeTable.getTree();
        int[] iSelectedRows = this.m_sortTreeTable.getSelectedRows();
        int iSelectedNodeCount = iSelectedRows.length;
        boolean isAllSameDevType = true;
        String strDevType = "";
        boolean isContainInProgressDev = false;
        boolean isContainAgentDev = false;
        for (int i = 0; i < iSelectedNodeCount; ++i) {
            TreeTableNode tmpNode;
            RouterDevInfoObj devInfoObj;
            TreePath oTreePath = tree.getPathForRow(iSelectedRows[i]);
            if (null == oTreePath || null == (devInfoObj = (RouterDevInfoObj)(tmpNode = (TreeTableNode)oTreePath.getLastPathComponent()).getUserObject())) continue;
            iSelectDevIds.add(devInfoObj.getDevID());
            if (devInfoObj.getIsAgent() || "".equals(devInfoObj.getDevAddress()) || DCConstants.UNKNOW_TYPE.equals(devInfoObj.getDevType())) {
                if (devInfoObj.getIsAgent()) {
                    this.m_exportDevMenuItem.setEnabled(false);
                    MenuUtil.enableMenuItem(this.m_oNeMenu, "ExportDevices", false);
                }
                this.disableAllManulOprMenu(true);
                if (!"".equals(devInfoObj.getDevAddress()) && DCConstants.UNKNOW_TYPE.equals(devInfoObj.getDevType())) {
                    MenuUtil.enableMenuItem((Component)this.m_getVersionMenuItem, true);
                    this.m_oManualOperationButtonPanel.getGetVersionButton().setEnabled(true);
                }
                return;
            }
            if (null != devInfoObj.getParentDevInfoObj()) {
                isContainAgentDev = true;
            }
            if (devInfoObj.getOperationStatus().getIsProgress()) {
                isContainInProgressDev = true;
            }
            if ("".equals(strDevType)) {
                strDevType = devInfoObj.getDevType();
                continue;
            }
            if (strDevType.equals(devInfoObj.getDevType())) continue;
            isAllSameDevType = false;
        }
        if (isContainInProgressDev) {
            this.disableAllManulOprMenu(false);
            this.m_deleteDevMenuItem.setEnabled(false);
            this.m_exportDevMenuItem.setEnabled(false);
            MenuUtil.enableMenuItem(this.m_oNeMenu, "DeleteDevices", false);
            return;
        }
        if (null != this.m_saveMenuItem) {
            this.m_saveMenuItem.setEnabled(isAllSameDevType);
        }
        if (null != this.m_backupMenuItem) {
            this.m_backupMenuItem.setEnabled(true);
            this.m_oManualOperationButtonPanel.getBackupButton().setEnabled(true);
        }
        if (null != this.m_recoverMenuItem) {
            this.m_recoverMenuItem.setEnabled(true);
            this.m_oManualOperationButtonPanel.getRecoverButton().setEnabled(true);
        }
        this.m_getPatchMenuItem.setEnabled(isAllSameDevType);
        this.m_oManualOperationButtonPanel.getGetPatchButton().setEnabled(isAllSameDevType);
        if (isContainAgentDev) {
            this.m_exportDevMenuItem.setEnabled(false);
            MenuUtil.enableMenuItem(this.m_oNeMenu, "ExportDevices", false);
        }
        if (!(bIsVisibleDeleteMemory = this.checkIsSupportDeleteNEFileOpr(iSelectDevIds))) {
            this.m_deleteMemoryMenuItem.setVisible(false);
        }
    }

    public void handleSelectOnlyOneDev() {
        RouterDevInfoObj oParentDevObj;
        ArrayList<Integer> iSelectDevIds = new ArrayList<Integer>();
        boolean bIsVisibleDeleteMemory = false;
        TreePath treePath = this.m_sortTreeTable.getTree().getSelectionPath();
        if (null == treePath) {
            this.disableAllManulOprMenu(true);
            MenuUtil.enableMenuItem((Component)this.m_deleteDevMenuItem, false);
            MenuUtil.enableMenuItem((Component)this.m_exportDevMenuItem, false);
            MenuUtil.enableMenuItem(this.m_oNeMenu, "DeleteDevices", false);
            return;
        }
        TreeTableNode selectedNode = (TreeTableNode)treePath.getLastPathComponent();
        RouterDevInfoObj selectedDevInfoObj = (RouterDevInfoObj)selectedNode.getUserObject();
        if (null == selectedDevInfoObj) {
            return;
        }
        if (selectedDevInfoObj.getIsAgent() || "".equals(selectedDevInfoObj.getDevAddress()) || DCConstants.UNKNOW_TYPE.equals(selectedDevInfoObj.getDevType())) {
            if (selectedDevInfoObj.getIsAgent()) {
                MenuUtil.enableMenuItem((Component)this.m_createNewNodeMenuItem, true);
                MenuUtil.enableMenuItem(this.m_oNeMenu, "AddNewProxyNode", true);
                this.m_exportDevMenuItem.setEnabled(false);
                MenuUtil.enableMenuItem(this.m_oNeMenu, "ExportDevices", false);
            }
            this.disableAllManulOprMenu(true);
            if (!"".equals(selectedDevInfoObj.getDevAddress()) && DCConstants.UNKNOW_TYPE.equals(selectedDevInfoObj.getDevType())) {
                MenuUtil.enableMenuItem((Component)this.m_getVersionMenuItem, true);
                this.m_oManualOperationButtonPanel.getGetVersionButton().setEnabled(true);
            }
            return;
        }
        iSelectDevIds.add(selectedDevInfoObj.getDevID());
        if (ResourceManager.getInstance().getResString("ADD_ROUTER_DEV_DIRECT").equals(selectedDevInfoObj.getProxyType())) {
            if ("".equals(selectedDevInfoObj.getDevAddress()) || selectedDevInfoObj.getOperationStatus().getIsProgress()) {
                if (selectedDevInfoObj.getOperationStatus().getIsProgress()) {
                    this.disableAllManulOprMenu(false);
                    this.m_deleteDevMenuItem.setEnabled(false);
                    this.m_exportDevMenuItem.setEnabled(false);
                    MenuUtil.enableMenuItem(this.m_oNeMenu, "DeleteDevices", false);
                } else {
                    this.disableAllManulOprMenu(true);
                }
            } else {
                this.m_oManualOperationButtonPanel.getNewTaskButton().setEnabled(true);
            }
        } else {
            MenuUtil.enableMenuItem((Component)this.m_createNewNodeMenuItem, true);
            MenuUtil.enableMenuItem(this.m_oNeMenu, "AddNewProxyNode", true);
            this.disableAllManulOprMenu(true);
        }
        if (selectedDevInfoObj.getIsAgent() || null != selectedDevInfoObj.getParentDevInfoObj()) {
            this.m_exportDevMenuItem.setEnabled(false);
            MenuUtil.enableMenuItem(this.m_oNeMenu, "ExportDevices", false);
        }
        if (!(bIsVisibleDeleteMemory = this.checkIsSupportDeleteNEFileOpr(iSelectDevIds))) {
            this.m_deleteMemoryMenuItem.setVisible(false);
        }
        if (null != (oParentDevObj = selectedDevInfoObj.getParentDevInfoObj())) {
            this.m_telnetTerminelMenuItem.setVisible(false);
        } else {
            this.m_telnetTerminelMenuItem.setVisible(true);
        }
    }

    public void disableAllOprMenu() {
        MenuUtil.enableMenuItem((Component)this.m_deleteDevMenuItem, false);
        MenuUtil.enableMenuItem((Component)this.m_exportDevMenuItem, false);
        MenuUtil.enableMenuItem(this.m_oNeMenu, "DeleteDevices", false);
        MenuUtil.enableMenuItem(this.m_oNeMenu, "ExportDevices", false);
        this.m_exportDevMenuItem.setEnabled(false);
        this.disableAllManulOprMenu(true);
    }

    public void initMenuItemStatus() {
        MenuUtil.enableMenuItem((Component)this.m_createDevMenuItem, true);
        MenuUtil.enableMenuItem(this.m_oNeMenu, "AddDevices", true);
        this.m_createNewNodeMenuItem.setEnabled(false);
        this.m_oManualOperationButtonPanel.getNewTaskButton().setEnabled(false);
        MenuUtil.enableMenuItem(this.m_oNeMenu, "AddNewProxyNode", false);
        MenuUtil.enableMenuItem((Component)this.m_deleteDevMenuItem, true);
        MenuUtil.enableMenuItem(this.m_oNeMenu, "DeleteDevices", true);
        this.m_exportDevMenuItem.setEnabled(true);
        MenuUtil.enableMenuItem(this.m_oNeMenu, "ExportDevices", false);
        this.m_exportTemplateMenuItem.setEnabled(true);
        MenuUtil.enableMenuItem(this.m_oNeMenu, "ExportDevicesTemplate", true);
        this.m_exportCheckItemMenuItem.setEnabled(true);
        MenuUtil.enableMenuItem(this.m_oNeMenu, "ExportCheckItemTemp", true);
        if (null != this.m_saveMenuItem) {
            this.m_saveMenuItem.setEnabled(true);
        }
        if (null != this.m_databaseOperMenuItem) {
            this.m_databaseOperMenuItem.setEnabled(true);
        }
        if (null != this.m_backupMenuItem) {
            this.m_backupMenuItem.setEnabled(true);
            this.m_oManualOperationButtonPanel.getBackupButton().setEnabled(true);
        } else {
            this.m_oManualOperationButtonPanel.getBackupButton().setVisible(false);
        }
        if (null != this.m_recoverMenuItem) {
            this.m_recoverMenuItem.setEnabled(true);
            this.m_oManualOperationButtonPanel.getRecoverButton().setEnabled(true);
        } else {
            this.m_oManualOperationButtonPanel.getRecoverButton().setVisible(false);
        }
        this.m_getVersionMenuItem.setEnabled(true);
        this.m_oManualOperationButtonPanel.getGetVersionButton().setEnabled(true);
        this.m_getPatchMenuItem.setEnabled(true);
        this.m_oManualOperationButtonPanel.getGetPatchButton().setEnabled(true);
        this.m_newTaskMenuItem.setEnabled(true);
        this.m_oManualOperationButtonPanel.getNewTaskButton().setEnabled(true);
        this.m_deleteMemoryMenuItem.setEnabled(true);
        this.m_deleteMemoryMenuItem.setVisible(true);
        this.m_telnetTerminelMenuItem.setEnabled(true);
        this.m_oManualOperationButtonPanel.getSaveDevLstButton().setEnabled(false);
    }

    private void disableAllManulOprMenu(boolean isDisableGetVersion) {
        if (null != this.m_saveMenuItem) {
            this.m_saveMenuItem.setEnabled(false);
        }
        if (null != this.m_backupMenuItem) {
            this.m_backupMenuItem.setEnabled(false);
            this.m_oManualOperationButtonPanel.getBackupButton().setEnabled(false);
        }
        if (null != this.m_recoverMenuItem) {
            this.m_recoverMenuItem.setEnabled(false);
            this.m_oManualOperationButtonPanel.getRecoverButton().setEnabled(false);
        }
        if (null != this.m_databaseOperMenuItem) {
            this.m_databaseOperMenuItem.setEnabled(false);
        }
        if (null != this.m_exportDevMenuItem) {
            this.m_exportDevMenuItem.setEnabled(false);
        }
        if (null != this.m_oNeMenu) {
            MenuUtil.enableMenuItem(this.m_oNeMenu, "ExportDevices", false);
        }
        if (isDisableGetVersion) {
            this.m_getVersionMenuItem.setEnabled(false);
            this.m_telnetTerminelMenuItem.setEnabled(false);
            this.m_oManualOperationButtonPanel.getGetVersionButton().setEnabled(false);
        }
        this.m_getPatchMenuItem.setEnabled(false);
        this.m_oManualOperationButtonPanel.getGetPatchButton().setEnabled(false);
        this.m_deleteMemoryMenuItem.setEnabled(false);
        this.m_newTaskMenuItem.setEnabled(false);
        this.m_oManualOperationButtonPanel.getNewTaskButton().setEnabled(false);
    }
}

