/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.view;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceInfo;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.view.JSortTreeTable;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.event.DCEventObject;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.security.DCEncryptServiceUtil;
import com.huawei.dc.common.tree.SubMapNodeInfo;
import com.huawei.dc.common.tree.TreeNodeInfo;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.deviceinfo.SubMapInfo;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.standalone.model.AbstractDevInfoObj;
import com.huawei.dc.standalone.model.RouterDevInfoObj;
import com.huawei.dc.standalone.view.DeviceProgressDlg;
import java.awt.Component;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;

public class RouterDevInfoPanelHelper {
    public static void modifyDevForNotification(AsnDCDeviceInfo oDeviceInfo, TreeTableNode rootNode) {
        if (null != oDeviceInfo) {
            TreeTableNode node = RouterDevInfoPanelHelper.getDevNode(oDeviceInfo.iDevId.intValue(), rootNode);
            if (null == node) {
                return;
            }
            RouterDevInfoObj devInfoObj = (RouterDevInfoObj)node.getUserObject();
            devInfoObj.setIsFinishInitialize(false);
            if (null != oDeviceInfo.strDevName) {
                devInfoObj.setDevName(new String(oDeviceInfo.strDevName));
            } else {
                DCDebugTracer.trace("the device name is null");
            }
            if (null != oDeviceInfo.strDevIPAddress) {
                devInfoObj.setDevAddress(new String(oDeviceInfo.strDevIPAddress));
            } else {
                DCDebugTracer.trace("the device ip is null");
            }
            if (null != oDeviceInfo.strDevVersion && 0 < oDeviceInfo.strDevVersion.length) {
                devInfoObj.setVersion(new String(oDeviceInfo.strDevVersion));
            } else {
                DCDebugTracer.trace("the device version is null");
            }
            if (null != oDeviceInfo.strDevPatchVersion) {
                devInfoObj.setPatchVersion(new String(oDeviceInfo.strDevPatchVersion));
            } else {
                DCDebugTracer.trace("the device patch version is null");
            }
            int iDevTypeId = oDeviceInfo.iDevTypeId.intValue();
            int iDevTypeVersionId = oDeviceInfo.iDevTypeVersionId.intValue();
            DeviceTypeInfo oDevTypeInfo = DeviceInfoManagerImpl.getInstance().getDeviceTypeInfo(iDevTypeId, iDevTypeVersionId);
            devInfoObj.setDevType(oDevTypeInfo.getDevTypeName());
            devInfoObj.setIsFinishInitialize(true);
        }
    }

    public static DeviceInfo[] getDeviceListForTreeSelection(DCEventObject oEventObject) {
        IDeviceInfoManager oDeviceInfoManager = DeviceInfoManagerImpl.getInstance();
        TreeNodeInfo oTreeNodeInfo = (TreeNodeInfo)oEventObject.getSource();
        DeviceInfo[] oDeviceList = null;
        if (3 == oTreeNodeInfo.m_iNodeType) {
            oDeviceList = new DeviceInfo[]{};
        } else if (1 == oTreeNodeInfo.m_iNodeType) {
            int iDeviceTypeID = oTreeNodeInfo.m_oDevType.getDevTypeID();
            int iDeviceTypeVersionID = oTreeNodeInfo.m_oDevType.getDevTypeVersionId();
            oDeviceList = oDeviceInfoManager.getDevicesByTypeAndVersion(iDeviceTypeID, iDeviceTypeVersionID);
        } else if (2 == oTreeNodeInfo.m_iNodeType) {
            String strVersionID = oTreeNodeInfo.m_strDeviceVersion;
            DeviceTypeInfo oDeviceTypeInfo = oTreeNodeInfo.m_oDevType;
            oDeviceList = oDeviceInfoManager.getDevicesForVersion(strVersionID, oDeviceTypeInfo);
        } else if (0 == oTreeNodeInfo.m_iNodeType) {
            SubMapNodeInfo oSubMapNodeInfo = oTreeNodeInfo.m_oSubMapNodeInfo;
            SubMapInfo oSubMapInfo = oDeviceInfoManager.getSubmapForID(oSubMapNodeInfo.m_submapId);
            oDeviceList = oDeviceInfoManager.getDevicesRecursivelyInSubMap(oSubMapInfo);
        }
        return oDeviceList;
    }

    public static List<AbstractDevInfoObj> getSelectedRowInfoLst(JSortTreeTable m_sortTreeTable) {
        JTree tree = m_sortTreeTable.getTree();
        int[] iSelectedRows = m_sortTreeTable.getSelectedRows();
        int iSelectedNodeCount = iSelectedRows.length;
        ArrayList<AbstractDevInfoObj> oRouterDevList = new ArrayList<AbstractDevInfoObj>(iSelectedNodeCount);
        for (int i = 0; i < iSelectedNodeCount; ++i) {
            TreePath oTreePath = tree.getPathForRow(iSelectedRows[i]);
            if (null == oTreePath) continue;
            TreeTableNode tmpNode = (TreeTableNode)oTreePath.getLastPathComponent();
            RouterDevInfoObj devInfoObj = (RouterDevInfoObj)tmpNode.getUserObject();
            oRouterDevList.add(devInfoObj);
        }
        return oRouterDevList;
    }

    public static int[] getSelectedDevIds(JSortTreeTable m_sortTreeTable) {
        JTree tree = m_sortTreeTable.getTree();
        int[] iSelectedRows = m_sortTreeTable.getSelectedRows();
        int iSelectedNodeCount = iSelectedRows.length;
        Vector<RouterDevInfoObj> selectedDevInfoVec = new Vector<RouterDevInfoObj>();
        for (int i = 0; i < iSelectedNodeCount; ++i) {
            TreeTableNode tmpNode;
            RouterDevInfoObj devInfoObj;
            TreePath oTreePath = tree.getPathForRow(iSelectedRows[i]);
            if (null == oTreePath || null == (devInfoObj = (RouterDevInfoObj)(tmpNode = (TreeTableNode)oTreePath.getLastPathComponent()).getUserObject()) || devInfoObj.getIsAgent()) continue;
            selectedDevInfoVec.add(devInfoObj);
        }
        int iDevCount = selectedDevInfoVec.size();
        int[] iSelectedDevIds = new int[iDevCount];
        for (int i = 0; i < iDevCount; ++i) {
            iSelectedDevIds[i] = ((RouterDevInfoObj)selectedDevInfoVec.get(i)).getDevID();
        }
        return iSelectedDevIds;
    }

    public static void updateTreeTable(JSortTreeTable m_sortTreeTable) {
        DCFrameWorkUtil.updateUI((JComponent)((Object)m_sortTreeTable));
    }

    public static void handleWriteDMS(List<AbstractDevInfoObj> oDevInfoLst, DeviceProgressDlg oExportProgressBarDlg, WritableSheet writableSheet) {
        int iSize = oDevInfoLst.size();
        int index = 0;
        int iCurrentRow = 1;
        for (AbstractDevInfoObj oDevInfo : oDevInfoLst) {
            if (oExportProgressBarDlg.isCloseDialog()) break;
            ++index;
            RouterDevInfoObj oRouterDevInfo = (RouterDevInfoObj)oDevInfo;
            int iErrorCode = 0;
            String strErrorMsg = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode));
            String strDevName = "";
            String strDevAddr = "";
            if (null != oDevInfo) {
                strDevName = oRouterDevInfo.getDevName();
                strDevAddr = oRouterDevInfo.getDevAddress();
                try {
                    RouterDevInfoPanelHelper.addDMSDeviceListIntoExportFile(writableSheet, oRouterDevInfo, iCurrentRow);
                    ++iCurrentRow;
                }
                catch (DCException e) {
                    strErrorMsg = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(e.getErrorCode()));
                }
            } else {
                strErrorMsg = ResourceManager.getInstance().getResString("NO_DEVICES_FOUND");
            }
            String strDevInfo = strDevName + '(' + strDevAddr + ')';
            int iProgress = (index + 1) * 100 / iSize;
            oExportProgressBarDlg.setProgress(iProgress);
            if (iSize == index) {
                oExportProgressBarDlg.updateDeviceNotification(strDevInfo, strErrorMsg, true);
                continue;
            }
            oExportProgressBarDlg.updateDeviceNotification(strDevInfo, strErrorMsg, false);
        }
    }

    private static void addDMSDeviceListIntoExportFile(WritableSheet writableSheet, RouterDevInfoObj oDevInfo, int iCurrentRow) throws DCException {
        try {
            WritableCellFormat titleFormat = new WritableCellFormat();
            titleFormat.setBorder(Border.ALL, BorderLineStyle.THIN);
            Label devNameCell = new Label(0, iCurrentRow, oDevInfo.getDevName(), (CellFormat)titleFormat);
            writableSheet.addCell((WritableCell)devNameCell);
            Label devAddressCell = new Label(1, iCurrentRow, oDevInfo.getDevAddress(), (CellFormat)titleFormat);
            writableSheet.addCell((WritableCell)devAddressCell);
            Label devTypeCell = new Label(2, iCurrentRow, oDevInfo.getDevType(), (CellFormat)titleFormat);
            writableSheet.addCell((WritableCell)devTypeCell);
            Label proxyTypeCell = new Label(3, iCurrentRow, oDevInfo.getProxyType(), (CellFormat)titleFormat);
            writableSheet.addCell((WritableCell)proxyTypeCell);
            Label proxyNodeTypeCell = new Label(4, iCurrentRow, oDevInfo.getProxyNodeType(), (CellFormat)titleFormat);
            writableSheet.addCell((WritableCell)proxyNodeTypeCell);
            Label protocolTypeCell = new Label(5, iCurrentRow, oDevInfo.getProtocolType(), (CellFormat)titleFormat);
            writableSheet.addCell((WritableCell)protocolTypeCell);
            Number portCell = new Number(6, iCurrentRow, (double)oDevInfo.getIPort(), (CellFormat)titleFormat);
            writableSheet.addCell((WritableCell)portCell);
            Label userNameCell = new Label(7, iCurrentRow, oDevInfo.getUserName(), (CellFormat)titleFormat);
            writableSheet.addCell((WritableCell)userNameCell);
            Label passwordCell = new Label(8, iCurrentRow, String.valueOf(DCEncryptServiceUtil.encrypt(oDevInfo.getPassword())), (CellFormat)titleFormat);
            writableSheet.addCell((WritableCell)passwordCell);
            Label super3PassCell = new Label(9, iCurrentRow, String.valueOf(DCEncryptServiceUtil.encrypt(oDevInfo.getSuper3Pass())), (CellFormat)titleFormat);
            writableSheet.addCell((WritableCell)super3PassCell);
            Label vpnCell = new Label(10, iCurrentRow, oDevInfo.getVPNName(), (CellFormat)titleFormat);
            writableSheet.addCell((WritableCell)vpnCell);
        }
        catch (Exception e) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("FILE_EXPORT_FAILED"), ResourceManager.getInstance().getResString("ERROR"), 0);
        }
    }

    public static TreeTableNode getDevNode(int iDevId, TreeTableNode root) {
        Enumeration<TreeNode> nodeEnum = root.breadthFirstEnumeration();
        while (nodeEnum.hasMoreElements()) {
            TreeTableNode tmpNode = (TreeTableNode)nodeEnum.nextElement();
            RouterDevInfoObj devInfoObj = (RouterDevInfoObj)tmpNode.getUserObject();
            if (null == devInfoObj || devInfoObj.getDevID() != iDevId) continue;
            return tmpNode;
        }
        return null;
    }

    public static TreeTableNode getAgentNode(String strAgentID, TreeTableNode root) {
        Enumeration<TreeNode> nodeEnum = root.breadthFirstEnumeration();
        while (nodeEnum.hasMoreElements()) {
            TreeTableNode tmpNode = (TreeTableNode)nodeEnum.nextElement();
            RouterDevInfoObj devInfoObj = (RouterDevInfoObj)tmpNode.getUserObject();
            if (null == devInfoObj || !devInfoObj.getIsAgent() || !devInfoObj.getAgentID().equals(strAgentID)) continue;
            return tmpNode;
        }
        return null;
    }

    public static int getRowIndex(JSortTreeTable oSortTreeTable, int iDevId) {
        JTree tree = oSortTreeTable.getTree();
        int iRowCount = oSortTreeTable.getRowCount();
        for (int i = 0; i < iRowCount; ++i) {
            TreeTableNode tmpNode;
            RouterDevInfoObj devInfoObj;
            TreePath oTreePath = tree.getPathForRow(i);
            if (null == oTreePath || null == (devInfoObj = (RouterDevInfoObj)(tmpNode = (TreeTableNode)oTreePath.getLastPathComponent()).getUserObject()) || devInfoObj.getIsAgent() || iDevId != devInfoObj.getDevID()) continue;
            return i;
        }
        return -1;
    }
}

