/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.view;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.DCGUIUtil;
import com.huawei.dc.common.GatewayConstants;
import com.huawei.dc.common.MyMouseMotionAdapter;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceBoardNotification;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceInfo;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceLastOperationStatusEnum;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceLst;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfo;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfoLst;
import com.huawei.dc.common.asndatacenter.AsnDCExportDeviceReq;
import com.huawei.dc.common.asndatacenter.AsnRoleTypeEnum;
import com.huawei.dc.common.asndatacenter.DCStringList;
import com.huawei.dc.common.components.devicetreepanel.DeviceTreePanel;
import com.huawei.dc.common.components.editor.TableLinkEditor;
import com.huawei.dc.common.components.editor.TableLinkRenderer;
import com.huawei.dc.common.components.tree.devicetree.DeviceTree;
import com.huawei.dc.common.components.treetable.model.AbstractSortTreeTableModel;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.event.DCDeviceTreeNodeSelectionEventObject;
import com.huawei.dc.common.framework.event.DCEventObject;
import com.huawei.dc.common.framework.interfaces.DCTreeEventListener;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.framework.utility.print.PrintSupportor;
import com.huawei.dc.common.tree.TreeNodeInfo;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCFileChooser;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DCSaveFileChooser;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.common.util.TempletExportUtil;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.controller.DeviceConfigModelCtrller;
import com.huawei.dc.devicemanagement.controller.DeviceInfoSyncCtrller;
import com.huawei.dc.devicemanagement.controller.IDeviceInfoSyncCtrller;
import com.huawei.dc.devicemanagement.deviceoperation.DeviceCommonManualOpr;
import com.huawei.dc.devicemanagement.deviceoperation.controller.DeviceOperationProgressController;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.CheckDeviceMemoryUtil;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.DeleteDeviceFileDialog;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.DeviceMemoryInfo;
import com.huawei.dc.devicemanagement.deviceview.DeviceMainPanel;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.DeviceSelectionEvent;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.IDeviceInfoSelectionListener;
import com.huawei.dc.devicemanagement.deviceview.devicetable.DeviceTableUtil;
import com.huawei.dc.devicemanagement.deviceview.devicetable.devicesearch.IColumnInfo;
import com.huawei.dc.devicemanagement.deviceview.devicetable.devicesearch.ISearchManager;
import com.huawei.dc.devicemanagement.event.DeviceInfoEvent;
import com.huawei.dc.devicemanagement.event.IDeviceInfoListener;
import com.huawei.dc.deviceoperation.deviceconfigchange.DeviceConfigEventReceiver;
import com.huawei.dc.deviceoperation.deviceconfigchange.IDeviceConfigChangeListener;
import com.huawei.dc.deviceoperation.util.OperationStatus;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.standalone.IManualOperation;
import com.huawei.dc.standalone.INEManagement;
import com.huawei.dc.standalone.StandAloneDomainInfo;
import com.huawei.dc.standalone.controller.IDCStandAloneSyncCtrller;
import com.huawei.dc.standalone.controller.StandAloneSyncCtrller;
import com.huawei.dc.standalone.event.IStandAloneNotificationListener;
import com.huawei.dc.standalone.event.StandAloneEvent;
import com.huawei.dc.standalone.event.StandAloneNotifier;
import com.huawei.dc.standalone.model.AbstractDevInfoObj;
import com.huawei.dc.standalone.model.DCRouterDevTreeTableModel;
import com.huawei.dc.standalone.model.RouterDevColumnInfo;
import com.huawei.dc.standalone.model.RouterDevInfoObj;
import com.huawei.dc.standalone.model.RouterDevTableInfo;
import com.huawei.dc.standalone.view.CommonManualOprButtonPanel;
import com.huawei.dc.standalone.view.DCIPAddressEditor;
import com.huawei.dc.standalone.view.DCIPAddressRender;
import com.huawei.dc.standalone.view.DCNumberTextField;
import com.huawei.dc.standalone.view.DevInfoPanelExtForAddingDev;
import com.huawei.dc.standalone.view.DeviceProgressDlg;
import com.huawei.dc.standalone.view.DeviceTypeEditor;
import com.huawei.dc.standalone.view.ImportDeviceDialog;
import com.huawei.dc.standalone.view.OperationStatusRender;
import com.huawei.dc.standalone.view.ProtocolNodeTypeEditor;
import com.huawei.dc.standalone.view.ProtocolTypeEditor;
import com.huawei.dc.standalone.view.RouterDevInfoPanelHelper;
import com.huawei.dc.standalone.view.RouterDevPopmenuManager;
import com.huawei.dc.standalone.view.TreeNodeRender;
import com.huawei.dc.taskmgmt.TaskManagementMainPanel;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.createtask.ViewCommandResultDialog;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;

public class RouterDevInfoPanel
extends DevInfoPanelExtForAddingDev
implements ISearchManager,
IStandAloneNotificationListener,
IManualOperation,
INEManagement,
DCTreeEventListener,
IDeviceConfigChangeListener,
IDeviceInfoListener {
    private static final long serialVersionUID = -6060287771458934920L;
    private static final RouterDevTableInfo TABLE_INFO = new RouterDevTableInfo();
    protected static final int OPERATION_STATUS_COLUMN = TABLE_INFO.getHeader().length - 1;
    private DCRouterDevTreeTableModel m_sortTreeTableModel;
    private DCSortableTreeTable m_sortTreeTable;
    private boolean m_isModify = false;
    private RouterDevColumnInfo m_devColumnInfo = new RouterDevColumnInfo();
    private static final int m_iClickCountToStart = 2;
    private IDCStandAloneSyncCtrller m_oStandAloneSyncCtrller = StandAloneSyncCtrller.getInstance();
    private List<IDeviceInfoSelectionListener> m_oListeners;
    private DeviceCommonManualOpr m_devManualOpr;
    private DeviceMainPanel m_devMainPanel;
    private RouterDevPopmenuManager oRouterDevPopmenuManager = null;
    private static final int BACKUP_OPERATION = 3;
    private CommonManualOprButtonPanel m_oManualOperationButtonPanel;
    private Object m_oSyncObject = new Object();
    private RouterDevInfoObj deviceInfo = new RouterDevInfoObj();
    private List<Resource> m_oResList = null;
    private Map<Integer, DeviceMemoryInfo> m_oDeviceMemoryInfoMap = null;
    private boolean isImportDevices = false;
    private boolean m_isCurrentPanel = true;
    private boolean m_bFirstOpenFromDevPanel = false;
    private final int COL = 0;
    private final int ROW = 0;

    public RouterDevInfoPanel(DeviceMainPanel oDeviceMainPanel) {
        this.m_sortTreeTableModel = new DCRouterDevTreeTableModel(TABLE_INFO);
        super.initializeTreeTable(this.m_sortTreeTableModel, true);
        this.m_sortTreeTable = this.getTreeTable();
        this.m_sortTreeTable.getTree().setToggleClickCount(0);
        this.m_oListeners = new ArrayList<IDeviceInfoSelectionListener>();
        this.jInit();
        this.oRouterDevPopmenuManager = new RouterDevPopmenuManager(this, this.m_sortTreeTable, this.m_oManualOperationButtonPanel);
        this.oRouterDevPopmenuManager.initPopupMenu();
        this.registPopuMenu(this.oRouterDevPopmenuManager.getPopupMenu());
        this.initRegistEvent();
        this.m_devManualOpr = new DeviceCommonManualOpr(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RouterDevInfoPanel.this.m_sortTreeTable.getSelectionModel().setSelectionInterval(0, 0);
            }
        });
        DCFrameWorkUtil.setRouterDevInfoPanel(this);
        if (this.m_sortTreeTable.isRequestFocusEnabled()) {
            DCHelpManager.getInstance().enableF1HelpKey((Component)((Object)this.m_sortTreeTable), "HELP_TOPIC_VIEW_DEVICE_INFORMATION");
        }
        this.m_devMainPanel = oDeviceMainPanel;
    }

    private void jInit() {
        this.getTreeTable().getTree().setCellRenderer(new TreeNodeRender());
        this.m_addNewProxyNodeMenuItem.setVisible(true);
        ((JSeparator)this.m_oSeperatorMap.get("Seperator1")).setVisible(true);
        TableColumn devNameColumn = this.m_sortTreeTable.getColumn(this.m_oResManager.getResString("DEVICE_TABLE_HEADER_RESOURCE_NAME"));
        devNameColumn.setPreferredWidth(150);
        TableColumn addressColumn = this.m_sortTreeTable.getColumn(this.m_oResManager.getResString("DEVICE_TABLE_HEADER_RESOURCE_IP"));
        addressColumn.setCellRenderer(new DCIPAddressRender());
        addressColumn.setCellEditor(new DCIPAddressEditor());
        addressColumn.setPreferredWidth(100);
        TableColumn devTypeColumn = this.m_sortTreeTable.getColumn(this.m_oResManager.getResString("DEVICE_TABLE_HEADER_RESOURCE_TYPE"));
        ComboBoxWithToolTip devTypeComboBox = new ComboBoxWithToolTip();
        DeviceTypeEditor devTypeCellEditor = new DeviceTypeEditor((JComboBox)devTypeComboBox);
        devTypeCellEditor.setClickCountToStart(2);
        devTypeColumn.setCellEditor(devTypeCellEditor);
        TableColumn proxyTypeColumn = this.m_sortTreeTable.getColumn(this.m_oResManager.getResString("ADD_DEVICE_PROXY_TYPE_HEADER"));
        ComboBoxWithToolTip proxyTypeComboBox = new ComboBoxWithToolTip();
        proxyTypeComboBox.addItem(this.m_oResManager.getResString("ADD_ROUTER_DEV_DIRECT"));
        proxyTypeComboBox.addItem(this.m_oResManager.getResString("ADD_ROUTER_DEV_AUTO_PROXY"));
        DefaultCellEditor proxyTypeCellEditor = new DefaultCellEditor(proxyTypeComboBox);
        proxyTypeCellEditor.setClickCountToStart(2);
        proxyTypeColumn.setCellEditor(proxyTypeCellEditor);
        proxyTypeColumn.setPreferredWidth(100);
        TableColumn portColumn = this.m_sortTreeTable.getColumn(this.m_oResManager.getResString("PORT_HEADER"));
        DCNumberTextField numberTextField = new DCNumberTextField();
        portColumn.setCellEditor(new DefaultCellEditor(numberTextField));
        portColumn.setPreferredWidth(30);
        TableColumn protocolTypeColumn = this.m_sortTreeTable.getColumn(this.m_oResManager.getResString("ADD_DEVICE_PROTOCOL_TYPE_HEADER"));
        ComboBoxWithToolTip protocolTypeComboBox = new ComboBoxWithToolTip();
        ProtocolTypeEditor oProtocolTypeCellEditor = new ProtocolTypeEditor((JComboBox)protocolTypeComboBox);
        oProtocolTypeCellEditor.setClickCountToStart(2);
        protocolTypeColumn.setCellEditor(oProtocolTypeCellEditor);
        TableColumn protocolNodeTypeColumn = this.m_sortTreeTable.getColumn(this.m_oResManager.getResString("ADD_DEVICE_PROXY_NODE_TYPE_HEADER"));
        ComboBoxWithToolTip protocolNodeTypeComboBox = new ComboBoxWithToolTip();
        ProtocolNodeTypeEditor protocolCellEditor = new ProtocolNodeTypeEditor((JComboBox)protocolNodeTypeComboBox);
        protocolCellEditor.setClickCountToStart(2);
        protocolNodeTypeColumn.setCellEditor(protocolCellEditor);
        protocolNodeTypeColumn.setPreferredWidth(100);
        TableColumn userNameColumn = this.m_sortTreeTable.getColumn(ResourceManager.getInstance().getResString("USER_NAME_HEADER"));
        userNameColumn.setPreferredWidth(100);
        TableColumn passwordColumn = this.m_sortTreeTable.getColumn(this.m_oResManager.getResString("PASSWORD_HEADER"));
        TableLinkRenderer passwordRender = new TableLinkRenderer(this.m_oResManager.getResString("CONFIGURATION"), false);
        passwordColumn.setCellRenderer(passwordRender);
        TableLinkEditor pwdLinkEditor = new TableLinkEditor(this.m_oResManager.getResString("CONFIGURATION"), (JTable)((Object)this.m_sortTreeTable), false);
        passwordColumn.setCellEditor(pwdLinkEditor);
        passwordColumn.setHeaderRenderer(this.defaultTableHeaderRender);
        passwordColumn.setPreferredWidth(100);
        TableColumn super3PassColumn = this.m_sortTreeTable.getColumn(this.m_oResManager.getResString("ADD_DEVICE_SUPER3_PASS_HEADER"));
        TableLinkRenderer super3PassRender = new TableLinkRenderer(this.m_oResManager.getResString("CONFIGURATION"), false);
        super3PassColumn.setCellRenderer(super3PassRender);
        TableLinkEditor super3PwdLinkEditor = new TableLinkEditor(this.m_oResManager.getResString("CONFIGURATION"), (JTable)((Object)this.m_sortTreeTable), false);
        super3PassColumn.setCellEditor(super3PwdLinkEditor);
        super3PassColumn.setHeaderRenderer(this.defaultTableHeaderRender);
        super3PassColumn.setPreferredWidth(100);
        TableColumn oprStatusColumn = this.m_sortTreeTable.getColumn(this.m_oResManager.getResString("DEVICE_TABLE_HEADER_OPERATION_STATUS"));
        OperationStatusRender oprStatusRender = new OperationStatusRender();
        oprStatusColumn.setCellRenderer(oprStatusRender);
        oprStatusColumn.setPreferredWidth(600);
        this.initButtonPanel();
        this.m_sortTreeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent oMouseEvent) {
                if (0 != (0x10 & oMouseEvent.getModifiers())) {
                    int iColumn = RouterDevInfoPanel.this.m_sortTreeTable.columnAtPoint(oMouseEvent.getPoint());
                    if (iColumn != OPERATION_STATUS_COLUMN) {
                        return;
                    }
                    if (RouterDevInfoPanel.this.m_sortTreeTable.getSelectedRowCount() > 1) {
                        return;
                    }
                    int iSelectedRow = RouterDevInfoPanel.this.m_sortTreeTable.rowAtPoint(oMouseEvent.getPoint());
                    Object oValue = RouterDevInfoPanel.this.m_sortTreeTable.getValueAt(iSelectedRow, iColumn);
                    if (oValue instanceof OperationStatus) {
                        OperationStatus oOperationStatus = (OperationStatus)oValue;
                        if (oOperationStatus.getIsProgress()) {
                            return;
                        }
                        if (999293081 == oOperationStatus.getIFailureReason()) {
                            ViewCommandResultDialog dialog = new ViewCommandResultDialog(oOperationStatus.getFailureReason());
                            dialog.setTitle(DCFrameWorkUtil.getLocalizedString("OPERATION_RESULT"));
                            dialog.getContentTextArea().setLineWrap(true);
                            dialog.setVisible(true);
                        }
                    }
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                DCFrameWorkUtil.setCursor(RouterDevInfoPanel.this.getParent(), Cursor.getDefaultCursor());
            }
        });
        this.m_sortTreeTable.addMouseMotionListener(new MyMouseMotionAdapter(this.m_sortTreeTable));
        if (StandAloneDomainInfo.getInstance().getSelectedDomain() == 2) {
            this.m_sortTreeTable.setAutoResizeMode(0);
        }
    }

    private void initButtonPanel() {
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new GridBagLayout());
        bottomPanel.setMaximumSize(new Dimension(1720, 45));
        bottomPanel.setMinimumSize(new Dimension(1300, 45));
        bottomPanel.setPreferredSize(new Dimension(1720, 45));
        this.m_statLbl.setMinimumSize(new Dimension(400, 45));
        this.m_statLbl.setPreferredSize(new Dimension(400, 45));
        bottomPanel.add((Component)this.m_statLbl, new GridBagConstraints(0, 0, 1, 7, 1.0, 0.0, 17, 1, new Insets(8, 3, 1, 0), 0, 0));
        this.m_oManualOperationButtonPanel = new CommonManualOprButtonPanel(this);
        bottomPanel.add((Component)this.m_oManualOperationButtonPanel.getNewTaskButton(), new GridBagConstraints(1, 0, 1, 7, 0.0, 0.0, 17, 0, new Insets(8, 3, 1, 0), 0, 0));
        bottomPanel.add((Component)this.m_oManualOperationButtonPanel.getGetVersionButton(), new GridBagConstraints(2, 0, 1, 7, 0.0, 0.0, 10, 0, new Insets(8, 3, 1, 0), 0, 0));
        bottomPanel.add((Component)this.m_oManualOperationButtonPanel.getGetPatchButton(), new GridBagConstraints(3, 0, 1, 7, 0.0, 0.0, 13, 0, new Insets(8, 3, 1, 0), 0, 0));
        bottomPanel.add((Component)this.m_oManualOperationButtonPanel.getBackupButton(), new GridBagConstraints(4, 0, 1, 7, 0.0, 0.0, 17, 0, new Insets(8, 3, 1, 0), 0, 0));
        bottomPanel.add((Component)this.m_oManualOperationButtonPanel.getRecoverButton(), new GridBagConstraints(5, 0, 1, 7, 0.0, 0.0, 17, 0, new Insets(8, 3, 1, 0), 0, 0));
        bottomPanel.add((Component)this.m_oManualOperationButtonPanel.getSaveDevLstButton(), new GridBagConstraints(6, 0, 1, 7, 0.0, 0.0, 17, 0, new Insets(8, 3, 1, 0), 0, 0));
        this.add((Component)bottomPanel, "South");
    }

    private void initRegistEvent() {
        StandAloneNotifier.getInstance().addStandAloneNotificationListener(this);
        DCFrameWorkUtil.getDeviceInfoManager().registManualOprMessage(this);
        DCFrameWorkUtil.getDeviceTreePanel().addDCEventListener(this);
        DeviceConfigEventReceiver.getInstance().resigterForConfigChangeEvent(this);
        DeviceOperationProgressController.getInstance().addDeviceNotificationListener(this);
    }

    public void addDevInfoSelectionListener(IDeviceInfoSelectionListener eventListener) {
        if (null != eventListener && !this.m_oListeners.contains(eventListener)) {
            this.m_oListeners.add(eventListener);
        }
    }

    @Override
    public void addNewRow() {
        try {
            if (null != this.m_sortTreeTable.getCellEditor()) {
                this.m_sortTreeTable.getCellEditor().stopCellEditing();
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        AbstractDevInfoObj devInfoObj = this.getDefaultDevInfoObj();
        if (null != devInfoObj) {
            devInfoObj.setKeyMode(0);
            RouterDevInfoObj routerDevInfoObj = (RouterDevInfoObj)devInfoObj;
            routerDevInfoObj.sendDevInfoToServer();
        }
    }

    @Override
    public void checkRightForPopupMenu() {
        this.oRouterDevPopmenuManager.checkRightForPopupMenu();
    }

    @Override
    protected List<AbstractDevInfoObj> getSelectedDevInfoLst() {
        JTree tree = this.m_sortTreeTable.getTree();
        int[] iSelectedRows = this.m_sortTreeTable.getSelectedRows();
        int iSelectedNodeCount = iSelectedRows.length;
        ArrayList<AbstractDevInfoObj> oRouterDevList = new ArrayList<AbstractDevInfoObj>(iSelectedNodeCount);
        for (int i = 0; i < iSelectedNodeCount; ++i) {
            TreeTableNode tmpNode;
            RouterDevInfoObj devInfoObj;
            TreePath oTreePath = tree.getPathForRow(iSelectedRows[i]);
            if (null == oTreePath || null == (devInfoObj = (RouterDevInfoObj)(tmpNode = (TreeTableNode)oTreePath.getLastPathComponent()).getUserObject()) || devInfoObj.getIsAgent()) continue;
            oRouterDevList.add(devInfoObj);
        }
        return oRouterDevList;
    }

    public int[] getSelectedDevIds() {
        return RouterDevInfoPanelHelper.getSelectedDevIds(this.m_sortTreeTable);
    }

    @Override
    protected List getAllDevInfoLst() {
        this.stopAllCellEditor();
        TreeTableNode root = this.getRoot();
        int iRowCount = root.getChildCount();
        ArrayList<Resource> oRouterDevList = new ArrayList<Resource>(iRowCount);
        IDeviceInfoManager devInfoMgr = DCFrameWorkUtil.getDeviceInfoManager();
        String strDevTypeName = "";
        DeviceTypeInfo oDevTypeInfo = null;
        for (int i = 0; i < iRowCount; ++i) {
            DeviceTypeInfo[] devTypes;
            TreeTableNode tmpNode = (TreeTableNode)root.getChildAt(i);
            RouterDevInfoObj devInfoObj = (RouterDevInfoObj)tmpNode.getUserObject();
            if (!devInfoObj.validateDevInfo()) continue;
            if (this.m_isModify) {
                devInfoObj.setErrorCode(-2147483646);
            } else if (devInfoObj.getErrorCode() != 0 && devInfoObj.getErrorCode() != Integer.MIN_VALUE) {
                devInfoObj.setErrorCode(-2147483647);
            }
            if (!strDevTypeName.equals(devInfoObj.getDevType()) && null != (devTypes = devInfoMgr.getDevTypeInfoByTypeName(devInfoObj.getDevType())) && 0 < devTypes.length) {
                oDevTypeInfo = devTypes[0];
            }
            Resource res = new Resource();
            res.setDeviceID(devInfoObj.getDevID());
            if (null != oDevTypeInfo) {
                res.setDevTypeId(oDevTypeInfo.getDevTypeID());
                res.setDevVersionID(0);
            } else {
                res.setDevTypeId(178);
                res.setDevVersionID(1);
            }
            res.setDeviceIP(devInfoObj.getDevAddress());
            res.setDeviceName(devInfoObj.getDevName());
            res.setUserName(devInfoObj.getUserName());
            res.setPassword(devInfoObj.getPassword());
            res.setSuperPassword(devInfoObj.getSuper3Pass());
            res.setPortValue(devInfoObj.getIPort());
            res.setProtocolType(devInfoObj.getIProtocolType());
            res.setVPNName(devInfoObj.getVPNName());
            res.setProxyType(devInfoObj.getIProxyType());
            res.setProxyNodeType(devInfoObj.getIProxyNodeType());
            oRouterDevList.add(res);
        }
        RouterDevInfoPanelHelper.updateTreeTable(this.m_sortTreeTable);
        return oRouterDevList;
    }

    private void handleModifyResult(TreeTableNode oNode, int iErrCode) {
        RouterDevInfoObj devInfoObj = null;
        if (null != oNode) {
            devInfoObj = (RouterDevInfoObj)oNode.getUserObject();
        }
        if (null != devInfoObj) {
            devInfoObj.setErrorCode(iErrCode);
            DCDebugTracer.trace("devId = " + devInfoObj.getDevID() + ", agentId = " + devInfoObj.getAgentID() + ", devName = " + devInfoObj.getDevName() + ", isAgent = " + devInfoObj.getIsAgent() + "errorcode = " + iErrCode);
            if (0 == iErrCode) {
                if (!devInfoObj.getIsAgent()) {
                    oNode.removeAllChildren();
                }
            } else {
                devInfoObj.rollbackChangedValue();
            }
        }
        RouterDevInfoPanelHelper.updateTreeTable(this.m_sortTreeTable);
    }

    private void handleDeleteResult(TreeTableNode oNode, int iErrCode) {
        RouterDevInfoObj devInfoObj = null;
        if (null != oNode) {
            devInfoObj = (RouterDevInfoObj)oNode.getUserObject();
        }
        if (null != devInfoObj) {
            devInfoObj.setErrorCode(iErrCode);
            if (0 == iErrCode) {
                oNode.removeFromParent();
            }
        }
        RouterDevInfoPanelHelper.updateTreeTable(this.m_sortTreeTable);
        this.updateSelectionState();
    }

    @Override
    protected int getDomain() {
        return 2;
    }

    @Override
    protected AbstractDevInfoObj getDefaultDevInfoObj() {
        RouterDevInfoObj routerDevInfoObj = new RouterDevInfoObj();
        return routerDevInfoObj;
    }

    @Override
    public void addNewProxyNode() {
        if (null != this.m_sortTreeTable.getCellEditor()) {
            this.m_sortTreeTable.getCellEditor().stopCellEditing();
        }
        TreePath treePath = this.m_sortTreeTable.getTree().getSelectionPath();
        TreeTableNode selectedNode = (TreeTableNode)treePath.getLastPathComponent();
        RouterDevInfoObj selectedDevInfoObj = (RouterDevInfoObj)selectedNode.getUserObject();
        selectedDevInfoObj.setOprResult("");
        if (selectedDevInfoObj.validateDevInfo()) {
            RouterDevInfoObj devInfoObj = new RouterDevInfoObj(selectedDevInfoObj, true);
            TreeTableNode node = new TreeTableNode(devInfoObj);
            selectedNode.add(node);
            RouterDevInfoPanelHelper.updateTreeTable(this.m_sortTreeTable);
            devInfoObj.sendDevInfoToServer();
            TreePath oNewNodePath = new TreePath(node.getPath());
            this.m_sortTreeTable.getTree().setSelectionPath(oNewNodePath);
            this.m_sortTreeTable.getTree().expandPath(oNewNodePath);
            this.m_sortTreeTable.getTree().scrollPathToVisible(oNewNodePath);
            this.updateSelectionState();
        } else {
            DCOptionPane.showMessageDialog((Component)this, this.m_oResManager.getResString("AGENT_DEV_INFO_IS_WRONG"), ResourceManager.getInstance().getResString("SUGGESTION"), 1);
        }
    }

    @Override
    public IColumnInfo getColumnInfoForSearch() {
        return this.m_devColumnInfo;
    }

    @Override
    public AbstractSortTreeTableModel getTreeTableModel() {
        return this.m_sortTreeTableModel;
    }

    @Override
    public void makeRowVisible(int row) {
        this.showRow(row);
    }

    @Override
    public synchronized void onStandAloneNotification(StandAloneEvent event) {
        int iRoleType;
        if (null == event) {
            DCDebugTracer.trace("(null == oEvent) || (m_iEventType != oEvent.getEventType())");
            return;
        }
        DCDebugTracer.trace("<RouterDevInfoPanel>Event Type : " + event.getEventType());
        DCDebugTracer.trace("<RouterDevInfoPanel>Event ErrorCode : " + event.getErrorCode());
        Resource oRes = event.getResource();
        if (null == oRes) {
            return;
        }
        DeviceInfo oDevInfo = DeviceInfoManagerImpl.getInstance().getDevice(oRes.getDeviceID());
        if (null != oDevInfo && (1 == (iRoleType = oDevInfo.getRoleType()) || 2 == iRoleType)) {
            return;
        }
        boolean isAgent = false;
        if (0 >= oRes.getDeviceID()) {
            isAgent = true;
        }
        TreeTableNode oNode = null;
        oNode = isAgent ? RouterDevInfoPanelHelper.getAgentNode(oRes.getAgentID(), this.getRoot()) : RouterDevInfoPanelHelper.getDevNode(oRes.getDeviceID(), this.getRoot());
        if (!this.isImportDevices && 0 != event.getErrorCode()) {
            this.showErrMessage(event.getErrorCode());
        }
        switch (event.getEventType()) {
            case 2: {
                this.handleModifyResult(oNode, event.getErrorCode());
                break;
            }
            case 1: {
                if (!isAgent) break;
                this.handleDeleteResult(oNode, event.getErrorCode());
                break;
            }
            default: {
                DCDebugTracer.trace("<RouterDevInfoPanel>default -- Event Type : " + event.getEventType());
            }
        }
    }

    public void addDevForNotification(int iDevId) {
        TreeTableNode node = RouterDevInfoPanelHelper.getDevNode(iDevId, this.getRoot());
        if (null != node) {
            return;
        }
        DeviceInfo oDevInfo = DeviceInfoManagerImpl.getInstance().getDevice(iDevId);
        if (DeviceInfoUtil.isClusterNE(oDevInfo)) {
            return;
        }
        if (null == oDevInfo) {
            return;
        }
        DeviceInfo[] oDevs = new DeviceInfo[]{oDevInfo};
        this.addDevcieTotable(oDevs);
    }

    public void setImportDevices(boolean isImportDevices) {
        this.isImportDevices = isImportDevices;
    }

    @Override
    public void onTreeInit(DCEventObject eventObject) {
    }

    @Override
    public void onTreeNodeSelection(DCEventObject oEventObject) {
        DCDebugTracer.trace("onTreeNodeSelection(DCEventObject oEventObject)");
        if (null != this.m_sortTreeTable.getCellEditor()) {
            this.m_sortTreeTable.getCellEditor().stopCellEditing();
        }
        if (null == oEventObject || !(oEventObject instanceof DCDeviceTreeNodeSelectionEventObject) || !(oEventObject.getSource() instanceof TreeNodeInfo)) {
            return;
        }
        DeviceInfo[] oDeviceList = RouterDevInfoPanelHelper.getDeviceListForTreeSelection(oEventObject);
        if (0 < oDeviceList.length) {
            Vector<DeviceInfo> oDevInfoVec = new Vector<DeviceInfo>();
            for (DeviceInfo oDevInfo : oDeviceList) {
                int iRoleType = oDevInfo.getRoleType();
                if (1 == iRoleType || 2 == iRoleType) continue;
                oDevInfoVec.add(oDevInfo);
            }
            oDeviceList = oDevInfoVec.toArray(new DeviceInfo[oDevInfoVec.size()]);
            if (oDeviceList.length < 1) {
                oDeviceList = null;
            }
        }
        this.reInitDevInfo(oDeviceList);
    }

    @Override
    public void handleDeviceConfigNotification(int iEventType, AsnDCDeviceSubmapNtfnInfoLst oDeviceInfoList) {
        block4: {
            block5: {
                block3: {
                    if (iEventType != 1) break block3;
                    AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo = null;
                    int iDeviceCount = oDeviceInfoList.size();
                    for (int i = 0; i < iDeviceCount; ++i) {
                        oAsnDeviceInfo = (AsnDCDeviceSubmapNtfnInfo)oDeviceInfoList.get(i);
                        if (null == oAsnDeviceInfo) continue;
                        this.deleteDevForNotification(oAsnDeviceInfo.oDeviceInfo.iDevId.intValue());
                    }
                    break block4;
                }
                if (iEventType != 2) break block5;
                AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo = null;
                int iDeviceCount = oDeviceInfoList.size();
                for (int i = 0; i < iDeviceCount; ++i) {
                    oAsnDeviceInfo = (AsnDCDeviceSubmapNtfnInfo)oDeviceInfoList.get(i);
                    if (null == oAsnDeviceInfo) continue;
                    RouterDevInfoPanelHelper.modifyDevForNotification(oAsnDeviceInfo.oDeviceInfo, this.getRoot());
                    RouterDevInfoPanelHelper.updateTreeTable(this.m_sortTreeTable);
                }
                break block4;
            }
            if (0 != iEventType) break block4;
            AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo = null;
            int iDeviceCount = oDeviceInfoList.size();
            for (int i = 0; i < iDeviceCount; ++i) {
                oAsnDeviceInfo = (AsnDCDeviceSubmapNtfnInfo)oDeviceInfoList.get(i);
                if (null == oAsnDeviceInfo) continue;
                this.addDevForNotification(oAsnDeviceInfo.oDeviceInfo.iDevId.intValue());
            }
        }
    }

    private void deleteDevForNotification(int iDevId) {
        TreeTableNode node = RouterDevInfoPanelHelper.getDevNode(iDevId, this.getRoot());
        if (null == node) {
            node = RouterDevInfoPanelHelper.getAgentNode("" + iDevId, this.getRoot());
        }
        if (null != node) {
            node.removeFromParent();
        }
        DCFrameWorkUtil.updateUI((JComponent)((Object)this.m_sortTreeTable));
    }

    private void reInitDevInfo(DeviceInfo[] oDevInfos) {
        try {
            this.getRoot().removeAllChildren();
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        if (null == oDevInfos) {
            this.updateTreeTable(0, 0);
            return;
        }
        RouterDevInfoPanelHelper.updateTreeTable(this.m_sortTreeTable);
        this.addDevcieTotable(oDevInfos);
    }

    private void addDevcieTotable(DeviceInfo[] oDevInfos) {
        List<RouterDevInfoObj> devInfoObjLst = null;
        int iSize = oDevInfos.length;
        ArrayList<Integer> devIdLst = new ArrayList<Integer>(iSize);
        for (int i = 0; i < iSize; ++i) {
            devIdLst.add(oDevInfos[i].getDevId());
        }
        try {
            devInfoObjLst = this.m_oStandAloneSyncCtrller.getRouterDevExtInfo(devIdLst);
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
        }
        if (null != devInfoObjLst && 0 < devInfoObjLst.size()) {
            int iGetDevCount = devInfoObjLst.size();
            DeviceInfo tmpRes = null;
            int iRowNum = -1;
            int iToSelectDevRowNum = 0;
            int iAddingDevID = DeviceConfigModelCtrller.getInstance().getAddingDeviceID();
            for (int i = 0; i < iGetDevCount; ++i) {
                boolean isSuupported = true;
                RouterDevInfoObj devInfoObj = devInfoObjLst.get(i);
                if (0 < devInfoObj.getDevID()) {
                    tmpRes = DeviceInfoManagerImpl.getInstance().getDevice(devInfoObj.getDevID());
                    if (null != tmpRes) {
                        devInfoObj.setIsFinishInitialize(false);
                        devInfoObj.setDevName(tmpRes.getDevName());
                        devInfoObj.setDevAddress(tmpRes.getDevIPAddress());
                        devInfoObj.setDevType(tmpRes.getDeviceTypeInfo().getDevTypeName());
                        if (null != tmpRes.getDevVersion()) {
                            devInfoObj.setVersion(tmpRes.getDevVersion().getDevVersion());
                            devInfoObj.setPatchVersion(tmpRes.getDevVersion().getPatchVersion());
                        }
                        devInfoObj.setOperationStatus(tmpRes.getDeviceOperationStatus());
                        devInfoObj.setIsFinishInitialize(true);
                    } else {
                        isSuupported = false;
                    }
                }
                if (!isSuupported) continue;
                TreeTableNode node = RouterDevInfoPanelHelper.getDevNode(devInfoObj.getDevID(), this.getRoot());
                if (null != node) {
                    return;
                }
                this.addNewRow(devInfoObj, false);
                ++iRowNum;
                if (devInfoObj.getDevID() != iAddingDevID) continue;
                iToSelectDevRowNum = iRowNum;
            }
            if (0 < iSize) {
                this.updateTreeTable(iToSelectDevRowNum, iRowNum, (Integer)devIdLst.get(0));
            } else {
                this.updateTreeTable(iToSelectDevRowNum, iRowNum);
            }
            ArrayList<RouterDevInfoObj> ODevLst = new ArrayList<RouterDevInfoObj>();
            ODevLst.add(devInfoObjLst.get(0));
            this.updateSelectionState(ODevLst);
        }
    }

    public void showRow(int iTotalRowNum, int iRow) {
        this.m_scrollPane.validate();
        JScrollBar vScroll = this.m_scrollPane.getVerticalScrollBar();
        vScroll.setValue(DCGUIUtil.calculateScrollValue(iRow, vScroll.getMaximum(), iTotalRowNum));
        DCFrameWorkUtil.updateUI(vScroll);
        DCFrameWorkUtil.updateUI(this.m_scrollPane);
    }

    @Override
    public void addNewRow(AbstractDevInfoObj devInfoObj) {
        this.addNewRow(devInfoObj, true);
    }

    private void addNewRow(AbstractDevInfoObj devInfoObj, boolean isUpdateUI) {
        TreeTableNode root = this.getRoot();
        if (null != devInfoObj) {
            RouterDevInfoObj tmpDevInfoObj = (RouterDevInfoObj)devInfoObj;
            TreeTableNode tmpNode = null;
            if (0 < tmpDevInfoObj.getDevID()) {
                tmpNode = new TreeTableNode(tmpDevInfoObj);
            }
            while (null != tmpDevInfoObj.getParentDevInfoObj()) {
                TreeTableNode node = RouterDevInfoPanelHelper.getAgentNode((tmpDevInfoObj = tmpDevInfoObj.getParentDevInfoObj()).getAgentID(), this.getRoot());
                if (null == node) {
                    node = new TreeTableNode(tmpDevInfoObj);
                }
                if (null != tmpNode) {
                    node.add(tmpNode);
                }
                tmpNode = node;
            }
            if (null != tmpNode) {
                root.add(tmpNode);
                if (isUpdateUI) {
                    RouterDevInfoPanelHelper.updateTreeTable(this.m_sortTreeTable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteDevices() {
        DeviceProgressDlg oAddDeviceProgressBarDlg;
        if (null != this.m_sortTreeTable.getCellEditor()) {
            this.m_sortTreeTable.getCellEditor().stopCellEditing();
        }
        List<AbstractDevInfoObj> devInfoObjLst = RouterDevInfoPanelHelper.getSelectedRowInfoLst(this.m_sortTreeTable);
        boolean isContainAgentDev = false;
        int iDevCount = devInfoObjLst.size();
        for (int i = 0; i < iDevCount; ++i) {
            RouterDevInfoObj routerDevInfoObj = (RouterDevInfoObj)devInfoObjLst.get(i);
            if (!routerDevInfoObj.getIsAgent()) continue;
            isContainAgentDev = true;
            break;
        }
        int iConfirm = 1;
        iConfirm = isContainAgentDev ? DCOptionPane.showConfirmDialog((Component)this, this.m_oResManager.getResString("DELETE_AGENT_CONFIRMATION_MSG"), this.m_oResManager.getResString("CONFIRM"), 0) : DCOptionPane.showConfirmDialog((Component)this, this.m_oResManager.getResString("DELETE_DEVICES_CONFIRMATION_MSG"), this.m_oResManager.getResString("CONFIRM"), 0);
        if (0 != iConfirm) {
            return;
        }
        Object object = this.m_oSyncObject;
        synchronized (object) {
            oAddDeviceProgressBarDlg = new DeviceProgressDlg(1, this.m_oSyncObject);
            oAddDeviceProgressBarDlg.setTotalDev(devInfoObjLst.size());
            IDCStandAloneSyncCtrller oStandAloneSyncCtrller = StandAloneSyncCtrller.getInstance();
            try {
                DCDebugTracer.trace("DC::RouterDevInfoPanel.deleteDevices(devCount = " + devInfoObjLst.size() + ")");
                int iReqId = DCFrameWorkUtil.generateRequestId();
                oStandAloneSyncCtrller.deleteDevices(iReqId, devInfoObjLst, 2);
            }
            catch (DCException ex) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ex.getErrorCode(), this.m_oResManager.getResString("ERROR"), 0);
                return;
            }
            oAddDeviceProgressBarDlg.setProgressBarState(true);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public synchronized void run() {
                oAddDeviceProgressBarDlg.setVisible(true);
                RouterDevInfoPanel.this.updateSelectionState();
            }
        });
    }

    @Override
    public void updateSelectionState() {
        DCFrameWorkUtil.setIsNeedToSendCmdCode(true);
        this.updateSelectionState(this.getSelectedDevInfoLst());
    }

    private void updateSelectionState(List<? extends AbstractDevInfoObj> devLst) {
        super.updateSelectionState();
        DeviceSelectionEvent oEvent = new DeviceSelectionEvent();
        if (null != devLst) {
            int iDevCount = devLst.size();
            int[] iDevIDs = new int[iDevCount];
            for (int i = 0; i < iDevCount; ++i) {
                RouterDevInfoObj devInfoObj = (RouterDevInfoObj)devLst.get(i);
                iDevIDs[i] = devInfoObj.getDevID();
            }
            oEvent.setSelectedDevIds(iDevIDs);
        }
        this.dispenseDevSelectionEvent(oEvent);
        this.checkRightForPopupMenu();
    }

    private void dispenseDevSelectionEvent(DeviceSelectionEvent oEvent) {
        if (this.m_isCurrentPanel) {
            int iCount = this.m_oListeners.size();
            for (int index = 0; index < iCount; ++index) {
                IDeviceInfoSelectionListener eventListener = this.m_oListeners.get(index);
                eventListener.onDeviceInfoSelection(oEvent);
            }
        }
    }

    public void save() {
        this.m_devManualOpr.save(this.getSelectedDevIds());
    }

    @Override
    public void backup() {
        this.m_devManualOpr.backup(this.getSelectedDevIds());
    }

    @Override
    public void recover() {
        this.m_devManualOpr.recover(this.getSelectedDevIds());
    }

    @Override
    public void getVersion() {
        this.m_devManualOpr.getVersion(this.getSelectedDevIds());
    }

    @Override
    public void getPatch() {
        this.m_devMainPanel.openPatchManagement(this.getSelectedDevIds());
    }

    @Override
    public void softwareUpgradeDowngrade() {
        DeviceTypeInfo[] arrDeviceTypes = DeviceInfoManagerImpl.getInstance().getAddedDeviceTypes();
        if (0 == arrDeviceTypes.length) {
            ResourceManager oResManager = ResourceManager.getInstance();
            DCOptionPane.showMessageDialog((Component)this, oResManager.getResString(oResManager.getResString("DEVICES_NOT_ADDED")), oResManager.getResString("SYSTEM_INFO_ERROR"), 0);
            return;
        }
        this.openTaskMainPanelFromDevicepanel();
        this.m_devManualOpr.softwareUpgradeDowngrade(this.getSelectedDevIds());
        this.m_bFirstOpenFromDevPanel = false;
    }

    @Override
    public void patchUpdate() {
        DeviceTypeInfo[] arrDeviceTypes = DeviceInfoManagerImpl.getInstance().getAddedDeviceTypes();
        if (0 == arrDeviceTypes.length) {
            ResourceManager oResManager = ResourceManager.getInstance();
            DCOptionPane.showMessageDialog((Component)this, oResManager.getResString(oResManager.getResString("DEVICES_NOT_ADDED")), oResManager.getResString("SYSTEM_INFO_ERROR"), 0);
            return;
        }
        this.openTaskMainPanelFromDevicepanel();
        this.m_devManualOpr.patchUpdate(this.getSelectedDevIds());
        this.m_bFirstOpenFromDevPanel = false;
    }

    public void telnetTerminal() {
        this.m_devManualOpr.telnetTerminal(this.getSelectedDevIds());
    }

    public void deleteMemory() {
        Resource m_oResource = new Resource();
        List<AbstractDevInfoObj> oAbstractDevInfoObjList = this.getSelectedDevInfoLst();
        AbstractDevInfoObj oAbstractDevInfoObj = oAbstractDevInfoObjList.get(0);
        m_oResource.setDeviceID(oAbstractDevInfoObj.getDevID());
        m_oResource.setDeviceName(oAbstractDevInfoObj.getDevName());
        m_oResource.setDeviceIP(oAbstractDevInfoObj.getDevAddress());
        this.m_oResList = new ArrayList<Resource>(0);
        this.m_oResList.add(m_oResource);
        ArrayList oFileList = new ArrayList(0);
        HashMap<Integer, List<String>> oFileInfoMap = new HashMap<Integer, List<String>>();
        oFileInfoMap.put(m_oResource.getDeviceID(), oFileList);
        CheckDeviceMemoryUtil checkDevMemoryUtil = new CheckDeviceMemoryUtil(oFileInfoMap);
        this.m_oDeviceMemoryInfoMap = checkDevMemoryUtil.checkDeviceMemory();
        if (this.m_oDeviceMemoryInfoMap.size() > 0) {
            this.showDeleteDeviceFileDialog();
        }
    }

    private void showDeleteDeviceFileDialog() {
        DeviceMemoryInfo oDevMemoryInfo = this.m_oDeviceMemoryInfoMap.get(this.m_oResList.get(0).getDeviceID());
        DeleteDeviceFileDialog oDeleteDeviceFileDialog = new DeleteDeviceFileDialog(this.m_oResList.get(0), oDevMemoryInfo);
        oDeleteDeviceFileDialog.setVisible(true);
    }

    @Override
    public synchronized void onDeviceNotification(DeviceInfoEvent oEvent) {
        TreeTableNode node;
        if (null == oEvent) {
            return;
        }
        if (2 == oEvent.getEventType() && oEvent.getSource() instanceof OperationStatus && null != (node = RouterDevInfoPanelHelper.getDevNode(oEvent.getDeviceID(), this.getRoot()))) {
            RouterDevInfoObj devInfoObj = (RouterDevInfoObj)node.getUserObject();
            OperationStatus oprStatus = (OperationStatus)oEvent.getSource();
            devInfoObj.setOperationStatus(oprStatus);
            this.m_sortTreeTable.repaint();
            this.checkRightForPopupMenu();
        }
        if (null == oEvent.getSource()) {
            return;
        }
        if (1 < this.m_sortTreeTable.getSelectedRowCount()) {
            return;
        }
        Object oEventSrc = oEvent.getSource();
        if (oEvent.getSource() instanceof OperationStatus && !((OperationStatus)oEventSrc).getIsProgress() && ((OperationStatus)oEventSrc).getOperationType() == 3) {
            DeviceSelectionEvent oDevSelectionEvent = new DeviceSelectionEvent();
            oDevSelectionEvent.setEventType(2);
            oDevSelectionEvent.setSelectedDevIds(new int[]{oEvent.getDeviceID()});
            this.dispenseDevSelectionEvent(oDevSelectionEvent);
        }
    }

    @Override
    public void setCancelOperationProgress(AsnDCDeviceBoardNotification asnDCDeviceBoardNotification) {
        DCDebugTracer.trace("setCancelOperationProgress");
    }

    @Override
    public void setOperationStartedStatusForDevice(DeviceInfo oDevInfo, int iOperationType) {
        if (null == oDevInfo) {
            return;
        }
        OperationStatus oOprStatus = oDevInfo.getDeviceOperationStatus();
        oDevInfo.setDeviceOperationStatus(oOprStatus);
        oOprStatus.setProgress(0);
        oOprStatus.setIsProgress(true);
        oOprStatus.setOperationType(iOperationType);
        TreeTableNode node = RouterDevInfoPanelHelper.getDevNode(oDevInfo.getDevId(), this.getRoot());
        RouterDevInfoObj devInfoObj = (RouterDevInfoObj)node.getUserObject();
        devInfoObj.setOperationStatus(oOprStatus);
        this.m_sortTreeTable.repaint();
        this.checkRightForPopupMenu();
    }

    @Override
    public synchronized void setVersionProgress(AsnDCDeviceBoardNotification oAsnDCDeviceBoardNotification) {
        if (null == oAsnDCDeviceBoardNotification) {
            return;
        }
        if (!oAsnDCDeviceBoardNotification.bIsFinal) {
            this.m_devManualOpr.setVersionProgress(oAsnDCDeviceBoardNotification);
            int iDevId = oAsnDCDeviceBoardNotification.oVersionInfo.iDeviceId.intValue();
            DeviceInfo deviceInfo = DCFrameWorkUtil.getDeviceInfoManager().getDevice(iDevId);
            if (0 == oAsnDCDeviceBoardNotification.oErrorInfo.iErrorNo.intValue()) {
                TreeTableNode tmpNode = RouterDevInfoPanelHelper.getDevNode(iDevId, this.getRoot());
                if (null == tmpNode) {
                    return;
                }
                RouterDevInfoObj devInfoObj = (RouterDevInfoObj)tmpNode.getUserObject();
                devInfoObj.setVersion(deviceInfo.getDevVersion().getDevVersion());
                devInfoObj.setPatchVersion(deviceInfo.getDevVersion().getPatchVersion());
                RouterDevInfoPanelHelper.updateTreeTable(this.m_sortTreeTable);
                DeviceTreePanel oDeviceTreePanel = DCFrameWorkUtil.getDeviceTreePanel();
                DeviceTree oDeviceTree = oDeviceTreePanel.getDeviceTree();
                AsnDCDeviceSubmapNtfnInfo oAsnInfo = new AsnDCDeviceSubmapNtfnInfo();
                oAsnInfo.oDeviceInfo = new AsnDCDeviceInfo();
                oAsnInfo.oDeviceInfo.iDevId = BigInteger.valueOf(iDevId);
                oDeviceTree.processEvent(2, oAsnInfo);
            }
            if (100 == oAsnDCDeviceBoardNotification.oProgressInfo.iPercentageProgress.intValue()) {
                DCFrameWorkUtil.updateUI(this.m_devMainPanel);
            }
        }
    }

    private void updateTreeTable(int iSelectRowNum, int iTotalRowNum) {
        this.updateTreeTable(iSelectRowNum, iTotalRowNum, -1);
    }

    private void updateTreeTable(final int iSelectRowNum, final int iTotalRowNum, final int iDevId) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RouterDevInfoPanel.this.m_sortTreeTable.updateUI();
                if (iSelectRowNum >= 0 && iSelectRowNum < RouterDevInfoPanel.this.m_sortTreeTable.getRowCount()) {
                    if (0 < iDevId) {
                        int iRow = RouterDevInfoPanelHelper.getRowIndex(RouterDevInfoPanel.this.m_sortTreeTable, iDevId);
                        RouterDevInfoPanel.this.m_sortTreeTable.getSelectionModel().setSelectionInterval(iRow, iRow);
                        RouterDevInfoPanel.this.showRow(RouterDevInfoPanel.this.m_sortTreeTable.getRowCount(), iRow);
                    } else {
                        RouterDevInfoPanel.this.m_sortTreeTable.getSelectionModel().setSelectionInterval(iSelectRowNum, iSelectRowNum);
                        RouterDevInfoPanel.this.showRow(iTotalRowNum, iSelectRowNum);
                    }
                    TreePath treePath = RouterDevInfoPanel.this.m_sortTreeTable.getTree().getSelectionPath();
                    RouterDevInfoPanel.this.m_sortTreeTable.getTree().expandPath(treePath);
                    RouterDevInfoPanel.this.m_sortTreeTable.getTree().scrollPathToVisible(treePath);
                } else {
                    int iSelRow = iSelectRowNum;
                    TreePath treePath = RouterDevInfoPanel.this.m_sortTreeTable.getTree().getPathForRow(iSelRow);
                    while (null == treePath && iSelRow > 0) {
                        treePath = RouterDevInfoPanel.this.m_sortTreeTable.getTree().getPathForRow(--iSelRow);
                    }
                    if (null != treePath) {
                        RouterDevInfoPanel.this.m_sortTreeTable.getSelectionModel().setSelectionInterval(iSelRow, iSelRow);
                        RouterDevInfoPanel.this.m_sortTreeTable.getTree().expandPath(treePath);
                        RouterDevInfoPanel.this.m_sortTreeTable.getTree().scrollPathToVisible(treePath);
                    }
                }
                RouterDevInfoPanel.this.checkRightForPopupMenu();
            }
        });
    }

    @Override
    public void addDevices() {
        this.addNewRow();
    }

    public RouterDevInfoObj[] getDevIdOfSelectedRow(DCSortableTreeTable m_oDeviceTreeTable) {
        int[] arrSelectedRows = m_oDeviceTreeTable.getSelectedRows();
        RouterDevInfoObj[] arrDevInfo = new RouterDevInfoObj[arrSelectedRows.length];
        for (int iSeletedRowIndex = 0; iSeletedRowIndex < arrSelectedRows.length; ++iSeletedRowIndex) {
            if (null == m_oDeviceTreeTable.getValueAt(arrSelectedRows[iSeletedRowIndex], 0)) continue;
            RouterDevInfoObj deviceInfo = new RouterDevInfoObj();
            deviceInfo.setDevName(m_oDeviceTreeTable.getValueAt(arrSelectedRows[iSeletedRowIndex], 0).toString());
            deviceInfo.setDevAddress(m_oDeviceTreeTable.getValueAt(arrSelectedRows[iSeletedRowIndex], 1).toString());
            deviceInfo.setDevType(m_oDeviceTreeTable.getValueAt(arrSelectedRows[iSeletedRowIndex], 2).toString());
            deviceInfo.setProxyNodeType(m_oDeviceTreeTable.getValueAt(arrSelectedRows[iSeletedRowIndex], 5).toString());
            arrDevInfo[iSeletedRowIndex] = deviceInfo;
        }
        return arrDevInfo;
    }

    public AsnDCExportDeviceReq getExportDeviceReq(String strFileName, RouterDevInfoObj[] arrDeviceInfo) {
        AsnDCDeviceLst devList;
        DCStringList headList;
        DCDebugTracer.trace("RouterDevInfoPanel#getExportDeviceReq start");
        DCDebugTracer.trace("save file path  : " + strFileName);
        int iReqId = DCFrameWorkUtil.generateRequestId();
        AsnDCExportDeviceReq oReq = new AsnDCExportDeviceReq();
        oReq.oReqID = BigInteger.valueOf(iReqId);
        oReq.bIsLocale = false;
        oReq.strFilePath = strFileName.getBytes();
        oReq.strYes = ResourceManager.getInstance().getResString("YES").getBytes();
        oReq.strNo = ResourceManager.getInstance().getResString("NO").getBytes();
        oReq.oHeaderLst = headList = new DCStringList();
        for (String headTemp : GatewayConstants.ARR_DMS_EXPORT_FILE_HEADER_LIST) {
            headList.add((Object)headTemp.getBytes());
        }
        oReq.oDCDeviceLst = devList = new AsnDCDeviceLst();
        AsnDCDeviceInfo asnDevInfo = null;
        int enroleType = 0;
        for (int count = 0; count < arrDeviceInfo.length; ++count) {
            asnDevInfo = new AsnDCDeviceInfo();
            AsnRoleTypeEnum asnRoleTypeEnum = new AsnRoleTypeEnum();
            asnDevInfo.strDevName = arrDeviceInfo[count].getDevName().getBytes();
            asnDevInfo.strDevIPAddress = arrDeviceInfo[count].getDevAddress().getBytes();
            asnDevInfo.enRoleType = new AsnRoleTypeEnum(enroleType);
            asnDevInfo.oLastOperationState = new AsnDCDeviceLastOperationStatusEnum(arrDeviceInfo[count].getOperationStatus().getIOperationResultStatus());
            asnDevInfo.iDevId = BigInteger.valueOf(DeviceInfoManagerImpl.getInstance().getDevsInfoByIP(arrDeviceInfo[count].getDevAddress()).get(0).getDevId());
            if (null == DeviceInfoManagerImpl.getInstance().getDevTypeInfoByTypeName(arrDeviceInfo[count].getDevType())) {
                DCDebugTracer.trace("getExportDeviceReq#oDevTypeInfo is null which device id is : " + asnDevInfo.iDevId);
                continue;
            }
            asnDevInfo.iDevTypeId = BigInteger.valueOf(DeviceInfoManagerImpl.getInstance().getDevTypeInfoByTypeName(arrDeviceInfo[count].getDevType())[0].getDevTypeID());
            asnDevInfo.iDevTypeVersionId = BigInteger.valueOf(DeviceInfoManagerImpl.getInstance().getDevTypeInfoByTypeName(arrDeviceInfo[count].getDevType())[0].getDevTypeVersionId());
            devList.add((Object)asnDevInfo);
        }
        oReq.iDomain = BigInteger.valueOf(2L);
        DCDebugTracer.trace("devList : " + devList.size());
        DCDebugTracer.trace("DeviceTablePanelUtil#getExportDeviceReq end..");
        return oReq;
    }

    @Override
    public void exportDevices() {
        DCDebugTracer.trace("DeviceTablePanel#exportDevices start");
        String strDstString = "";
        if (DCFrameWorkUtil.getIsSingleClient()) {
            DCFileChooser m_oSaveasFileChooser = new DCFileChooser();
            m_oSaveasFileChooser.setTitle(DCFrameWorkUtil.getLocalizedString("EXPORT_DEVICE_INFO"));
            m_oSaveasFileChooser.setFileSelectionMode(1);
            int returnValue = m_oSaveasFileChooser.showDialog(DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("OK"));
            if (0 != returnValue) {
                return;
            }
            strDstString = m_oSaveasFileChooser.getSelectedFile().getAbsolutePath();
        } else {
            SystemManager temp = new SystemManager();
            strDstString = temp.getSystemRootDirectory();
            strDstString = strDstString + "/" + DCConstants.UPDATE;
        }
        RouterDevInfoObj[] arrDeviceInfo = this.getDevIdOfSelectedRow(this.m_sortTreeTable);
        AsnDCExportDeviceReq oReq = this.getExportDeviceReq(strDstString, arrDeviceInfo);
        IDeviceInfoSyncCtrller oSyncController = DeviceInfoSyncCtrller.getInstance();
        oSyncController.exportDevices(oReq);
        DCDebugTracer.trace("DeviceTablePanel#exportDevices end..");
    }

    @Override
    public void exportDevicesTemplate() {
        String sFileName = DCFrameWorkUtil.getLocalizedString("ROUTER_DOMAIN_TEMPLET");
        TempletExportUtil exportCheckItem = new TempletExportUtil(ResourceManager.getInstance().getResString("ROUTER_DOMAIN_TEMPLET_ORG"), StringUtils.removePostfix(sFileName, ".xls"), ResourceManager.getInstance().getResString("EXPORT_DEVICE_TEMPLATE_INFO"));
        exportCheckItem.exportTemple();
    }

    @Override
    public void exportCheckItemTemp() {
        TempletExportUtil exportCheckItem = new TempletExportUtil(ResourceManager.getInstance().getResString("EXPORT_CHECK_ITEM_MODEL_ORG"), ResourceManager.getInstance().getResString("EXPORT_CHECK_ITEM_MODEL"), ResourceManager.getInstance().getResString("EXPORT_CHECK_ITEM_MODEL"));
        exportCheckItem.exportTemple();
    }

    @Override
    public void importDevices() {
        ImportDeviceDialog dialog = new ImportDeviceDialog(this);
        dialog.setVisible(true);
    }

    @Override
    public void modifyDevice() {
    }

    @Override
    public void searchDevice() {
    }

    private void showErrMessage(int iErrCode) {
        String strErrMsg = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrCode));
        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), strErrMsg, ResourceManager.getInstance().getResString("SUGGESTION"), 1);
    }

    @Override
    public void saveDevInfoLst() {
        DeviceTableUtil.saveButtonActionPerformed(this.m_sortTreeTable);
    }

    public boolean checkIsContainProxiedDev(int[] iDevIds) {
        for (int i = 0; i < iDevIds.length; ++i) {
            RouterDevInfoObj devInfoObj;
            TreeTableNode oDevNode = RouterDevInfoPanelHelper.getDevNode(iDevIds[i], this.getRoot());
            if (null == oDevNode || null == (devInfoObj = (RouterDevInfoObj)oDevNode.getUserObject()).getParentDevInfoObj()) continue;
            return true;
        }
        return false;
    }

    private DCSaveFileChooser initExportDialog(String defaultFileName, int fileFilter) {
        PrintSupportor.setIsFileSelection(false);
        DCSaveFileChooser oFileChooserDialog = new DCSaveFileChooser();
        oFileChooserDialog.setTitle(this.m_oResManager.getResString("EXPORT_DEVICE_INFO"));
        DCHelpManager.getInstance().enableF1HelpKey((Component)((Object)oFileChooserDialog), "HELP_TOPIC_NE_EXPORT");
        oFileChooserDialog.setFileFilter(fileFilter);
        oFileChooserDialog.setAcceptAllFileFilterUsed(false);
        oFileChooserDialog.setSelectedFile(new File(defaultFileName));
        return oFileChooserDialog;
    }

    public boolean isCurrentPanel() {
        return this.m_isCurrentPanel;
    }

    public void setIsCurrentPanel(boolean isCurrentPanel) {
        this.m_isCurrentPanel = isCurrentPanel;
    }

    private void openTaskMainPanelFromDevicepanel() {
        TaskManagementMainPanel oTaskMgrPanel = DCFrameWorkUtil.getDCModuleManager().getTaskMgrMainPanel();
        this.m_bFirstOpenFromDevPanel = null == oTaskMgrPanel;
    }

    public boolean isFirstOpenFromDevPanel() {
        return this.m_bFirstOpenFromDevPanel;
    }

    public void activateDataBase() {
        int iVal = DCOptionPane.showExtConfirmDialog(this, ResourceManager.getInstance().getResString("ACTIVATE_DATABASE_MSG"), ResourceManager.getInstance().getResString("WARNING"), 0, 2);
        if (0 == iVal) {
            this.m_devManualOpr.activateDataBase(this.getSelectedDevIds());
        }
    }

    public void rollbackdatabase() {
    }

    public void deleteDataBase() {
    }

    public void copyDatabase() {
    }
}

