/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.view;

import com.huawei.dc.common.components.editor.AdvanceInfoLinkEditor;
import com.huawei.dc.common.components.editor.TableLinkEditor;
import com.huawei.dc.common.components.editor.TableLinkRenderer;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.view.JSortTreeTable;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.standalone.model.AbstractDevInfoObj;
import com.huawei.dc.standalone.model.AddDeviceAdvanceObj;
import com.huawei.dc.standalone.model.DCSortTreeTableModel;
import com.huawei.dc.standalone.model.OptixDevInfoObj;
import com.huawei.dc.standalone.model.OptixDevTableInfo;
import com.huawei.dc.standalone.model.T2000DevInfo;
import com.huawei.dc.standalone.view.AddDeviceInfoPanel;
import com.huawei.dc.standalone.view.ComboBoxRender;
import com.huawei.dc.standalone.view.DCNumberTextField;
import com.huawei.dc.standalone.view.DevInfoPanelExtForAddingDev;
import com.huawei.dc.standalone.view.SearchGatewayAddressEditor;
import com.huawei.dc.standalone.view.SearchGatewayAddressRender;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class OptixDevInfoPanel
extends DevInfoPanelExtForAddingDev {
    private static final long serialVersionUID = -1620114284315472905L;
    private JSortTreeTable m_sortTreeTable;
    AddDeviceInfoPanel oBasePanel = null;

    public OptixDevInfoPanel(AddDeviceInfoPanel oBaseDevicePanel) {
        this.oBasePanel = oBaseDevicePanel;
        OptixDevTableInfo oTableInfo = new OptixDevTableInfo();
        DCSortTreeTableModel m_sortTreeTableModel = new DCSortTreeTableModel(oTableInfo);
        super.initializeTreeTable(m_sortTreeTableModel);
        this.m_sortTreeTable = this.getTreeTable();
        this.init();
        this.addNewRow(0);
        this.selectAllRow();
        this.selectAllRow();
    }

    private void init() {
        DCNumberTextField numberTextField = new DCNumberTextField();
        TableColumn extDevIDColumn = this.m_sortTreeTable.getColumn(this.m_oResManager.getResString("DEVICE_EXTEND_ID_HEADER"));
        extDevIDColumn.setCellEditor(new DefaultCellEditor(numberTextField));
        TableColumn neIDColumn = this.m_sortTreeTable.getColumn(this.m_oResManager.getResString("DEVICE_ID_HEADER"));
        neIDColumn.setCellEditor(new DefaultCellEditor(numberTextField));
        TableColumn portColumn = this.m_sortTreeTable.getColumn(OptixDevInfoPanel.getHeaderEndWithStar(this.m_oResManager.getResString("PORT_HEADER")));
        portColumn.setCellEditor(new DefaultCellEditor(numberTextField));
        portColumn.setPreferredWidth(50);
        ComboBoxRender protocolComboBoxReander = new ComboBoxRender();
        protocolComboBoxReander.addItem(this.m_oResManager.getResString("MML_PROTOCOL"));
        protocolComboBoxReander.addItem(this.m_oResManager.getResString("TLL_PROTOCOL"));
        TableColumn protocolColumn = this.m_sortTreeTable.getColumn(OptixDevInfoPanel.getHeaderEndWithStar(this.m_oResManager.getResString("PROTOCOL_TYPE_HEADER")));
        protocolColumn.setCellRenderer(protocolComboBoxReander);
        JComboBox<String> protocolComboBox = new JComboBox<String>();
        protocolComboBox.addItem(this.m_oResManager.getResString("MML_PROTOCOL"));
        protocolComboBox.addItem(this.m_oResManager.getResString("TLL_PROTOCOL"));
        protocolColumn.setCellEditor(new DefaultCellEditor(protocolComboBox));
        ComboBoxRender gatewayTypeComboBoxReander = new ComboBoxRender();
        gatewayTypeComboBoxReander.addItem(this.m_oResManager.getResString("IP_GATEWAY_TYPE"));
        gatewayTypeComboBoxReander.addItem(this.m_oResManager.getResString("OS_GATEWAY_TYPE"));
        TableColumn gatewayTypeColumn = this.m_sortTreeTable.getColumn(OptixDevInfoPanel.getHeaderEndWithStar(this.m_oResManager.getResString("GATEWAY_TYPE_HEADER")));
        gatewayTypeColumn.setCellRenderer(gatewayTypeComboBoxReander);
        JComboBox<String> gatewayTypeComboBox = new JComboBox<String>();
        gatewayTypeComboBox.addItem(this.m_oResManager.getResString("IP_GATEWAY_TYPE"));
        gatewayTypeComboBox.addItem(this.m_oResManager.getResString("OS_GATEWAY_TYPE"));
        gatewayTypeColumn.setCellEditor(new DefaultCellEditor(gatewayTypeComboBox));
        TableColumn gatewayAddrColumn = this.m_sortTreeTable.getColumn(OptixDevInfoPanel.getHeaderEndWithStar(this.m_oResManager.getResString("GATEWAY_ADDRESS_HEADER")));
        gatewayAddrColumn.setCellEditor(new SearchGatewayAddressEditor());
        gatewayAddrColumn.setCellRenderer(new SearchGatewayAddressRender());
        gatewayAddrColumn.setPreferredWidth(150);
        TableColumn protColumn = this.m_sortTreeTable.getColumn(OptixDevInfoPanel.getHeaderEndWithStar(this.m_oResManager.getResString("PORT_HEADER")));
        protColumn.setPreferredWidth(50);
        TableColumn passwordColumn = this.m_sortTreeTable.getColumn(OptixDevInfoPanel.getHeaderEndWithStar(this.m_oResManager.getResString("PASSWORD_HEADER")));
        passwordColumn.setHeaderRenderer(this.defaultTableHeaderRender);
        TableLinkRenderer linkRenderer = new TableLinkRenderer(this.m_oResManager.getResString("CONFIGURATION"), true);
        passwordColumn.setCellRenderer(linkRenderer);
        TableLinkEditor linkEditor = new TableLinkEditor(this.m_oResManager.getResString("CONFIGURATION"), (JTable)((Object)this.m_sortTreeTable), true);
        passwordColumn.setCellEditor(linkEditor);
        TableColumn advanceSettingColumn = this.m_sortTreeTable.getColumn(this.m_oResManager.getResString("ADVANCE_SETTING_HEADER"));
        advanceSettingColumn.setHeaderRenderer(this.defaultTableHeaderRender);
        TableLinkRenderer settingLinkRenderer = new TableLinkRenderer(this.m_oResManager.getResString("ADVANCE_SETTING_HEADER"), false);
        advanceSettingColumn.setCellRenderer(settingLinkRenderer);
        AdvanceInfoLinkEditor settinglinkEditor = new AdvanceInfoLinkEditor(this.m_oResManager.getResString("ADVANCE_SETTING_HEADER"), (JTable)((Object)this.m_sortTreeTable), false);
        advanceSettingColumn.setCellEditor(settinglinkEditor);
        TableColumn DevNameTIDColumn = this.m_sortTreeTable.getColumn(this.m_oResManager.getResString("DEVICE_NAME_HEADER_TID"));
        DevNameTIDColumn.setMinWidth(100);
        TableColumn resultColumn = this.m_sortTreeTable.getColumn(this.m_oResManager.getResString("OPERATION_RESULT_HEADER"));
        resultColumn.setPreferredWidth(190);
        TableColumn devTypeColumn = this.m_sortTreeTable.getColumn(this.m_oResManager.getResString("DEVICE_TYPE"));
        devTypeColumn.setMaxWidth(0);
        devTypeColumn.setMinWidth(0);
        devTypeColumn.setPreferredWidth(0);
        devTypeColumn.setResizable(false);
        TableColumn versionColumn = this.m_sortTreeTable.getColumn(this.m_oResManager.getResString("VERSION"));
        versionColumn.setMaxWidth(0);
        versionColumn.setMinWidth(0);
        versionColumn.setPreferredWidth(0);
        versionColumn.setResizable(false);
        TableColumn isGatewayColumn = this.m_sortTreeTable.getColumn(this.m_oResManager.getResString("IF_GATEWAY"));
        isGatewayColumn.setMaxWidth(0);
        isGatewayColumn.setMinWidth(0);
        isGatewayColumn.setPreferredWidth(0);
        isGatewayColumn.setResizable(false);
        JTableHeader oTableHeader = this.m_sortTreeTable.getTableHeader();
        oTableHeader.addMouseMotionListener(this.getToolTipRendererForHeader((JTable)((Object)this.m_sortTreeTable)));
    }

    private MouseMotionAdapter getToolTipRendererForHeader(final JTable oTable) {
        return new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int oColNum = oTable.getColumnModel().getColumnIndexAtX(e.getX());
                if (oColNum > -1) {
                    oTable.getTableHeader().setToolTipText(oTable.getColumnName(oColNum));
                }
            }
        };
    }

    @Override
    protected List getSelectedDevInfoLst() {
        JTree tree = this.m_sortTreeTable.getTree();
        int[] iSelectedRows = this.m_sortTreeTable.getSelectedRows();
        int iSelectedNodeCount = iSelectedRows.length;
        ArrayList<T2000DevInfo> oT2000DevList = new ArrayList<T2000DevInfo>(iSelectedNodeCount);
        for (int i = 0; i < iSelectedNodeCount; ++i) {
            TreeTableNode tmpNode = (TreeTableNode)tree.getPathForRow(iSelectedRows[i]).getLastPathComponent();
            OptixDevInfoObj devInfoObj = (OptixDevInfoObj)tmpNode.getUserObject();
            if (!this.validateDevInfo(devInfoObj)) continue;
            devInfoObj.setDevID(++this.m_currentMaxDevID);
            devInfoObj.setErrorCode(-2147483647);
            T2000DevInfo oDevInfo = new T2000DevInfo();
            oDevInfo.setDeviceID(devInfoObj.getDevID());
            oDevInfo.setDeviceName(devInfoObj.getDevName());
            oDevInfo.setProtocolType(devInfoObj.getIProtocolType());
            oDevInfo.setKeyMode(devInfoObj.getKeyMode());
            if (2 == oDevInfo.getProtocolType()) {
                oDevInfo.setMMLProtocolDevPhyId(devInfoObj.getDevPhyID());
            } else if (4 == oDevInfo.getProtocolType()) {
                if ("".equals(devInfoObj.getDevName())) {
                    oDevInfo.setTL1ProtocolDevPhyId(null);
                } else {
                    oDevInfo.setTL1ProtocolDevPhyId(devInfoObj.getDevName());
                }
            }
            oDevInfo.setGateWayType(devInfoObj.getIGatewayType());
            oDevInfo.setGatewayAddress(devInfoObj.getDevAddress());
            oDevInfo.setPort(Integer.parseInt(devInfoObj.getPort()));
            oDevInfo.setUserName(devInfoObj.getUserName());
            oDevInfo.setPass(devInfoObj.getPassword());
            AddDeviceAdvanceObj advanceObj = devInfoObj.getAdvancedSeting();
            if (null != advanceObj) {
                oDevInfo.setSFTPPassPhrase(advanceObj.getSftpPassPhrase());
                oDevInfo.setISUseSSH(advanceObj.isbIsSSH());
                oDevInfo.setSSHLoginMode(advanceObj.getKeyMode());
                oDevInfo.setSSHLoginKey(advanceObj.getSshLoginKey());
                oDevInfo.setSSHPassPhrase(advanceObj.getSshPassPhrase());
            }
            Integer devTypeId = Integer.valueOf(devInfoObj.getDevType());
            oDevInfo.setDeviceType(devTypeId);
            String bIsGateWay = devInfoObj.getIsGateWay();
            oDevInfo.setIsGateway(bIsGateWay);
            oDevInfo.setDevVersion(devInfoObj.getDevVersion());
            DCDebugTracer.trace("add.res.id = " + oDevInfo.getDeviceID());
            oT2000DevList.add(oDevInfo);
        }
        this.m_sortTreeTable.updateUI();
        return oT2000DevList;
    }

    protected boolean validateDevInfo(AbstractDevInfoObj devInfoObj) {
        String strDevAddress;
        OptixDevInfoObj optixDevInfoObj = (OptixDevInfoObj)devInfoObj;
        String strDevId = null;
        String strNeId = null;
        String strExtId = null;
        if (-2147483647 <= devInfoObj.getErrorCode() && 0 > devInfoObj.getErrorCode()) {
            return false;
        }
        if (2 == optixDevInfoObj.getIProtocolType()) {
            strNeId = optixDevInfoObj.getNEID().trim();
            strExtId = optixDevInfoObj.getDevExtID().trim();
            if (strExtId.equals("") && !strNeId.equals("")) {
                String strMsg = this.m_oResManager.getResString("INVALID_DEVICE_EXTID");
                devInfoObj.setOprResult(strMsg);
                return false;
            }
            if (!strExtId.equals("") && strNeId.equals("")) {
                String strMsg = this.m_oResManager.getResString("INVALID_DEVICE_ID");
                devInfoObj.setOprResult(strMsg);
                return false;
            }
            strDevId = strExtId + "-" + strNeId.trim();
            if (!strDevId.equals("-") && !"".equals(strDevId) && -1 == optixDevInfoObj.getDevPhyID()) {
                String strMsg = this.m_oResManager.getResString("INVALID_DEVICE_ID");
                devInfoObj.setOprResult(strMsg);
                return false;
            }
        }
        if ((strDevAddress = devInfoObj.getDevAddress().trim()).equals("")) {
            String strMsg = this.m_oResManager.getResString("GATEWAY_ADDR_EMPTY");
            devInfoObj.setOprResult(strMsg);
            return false;
        }
        String strPort = optixDevInfoObj.getPort().trim();
        if (strPort.equals("")) {
            String strMsg = this.m_oResManager.getResString("PORT_EMPTY");
            devInfoObj.setOprResult(strMsg);
            return false;
        }
        if (!strPort.matches("[\\d][\\d]++")) {
            String strMsg = this.m_oResManager.getResString("INVALID_DEVICE_PORT");
            devInfoObj.setOprResult(strMsg);
            return false;
        }
        String strUsrName = optixDevInfoObj.getUserName().trim();
        if (strUsrName.equals("")) {
            String strMsg = this.m_oResManager.getResString("USER_NAME_BLANK");
            devInfoObj.setOprResult(strMsg);
            return false;
        }
        char[] strPass = optixDevInfoObj.getPassword();
        if (String.valueOf(strPass).equals("")) {
            String strMsg = this.m_oResManager.getResString("PASSWORD_FIELD_BLANK");
            devInfoObj.setOprResult(strMsg);
            return false;
        }
        return 0 != optixDevInfoObj.getErrorCode();
    }

    public Enumeration getAllOptixInfo() {
        return this.getRoot().children();
    }

    @Override
    protected int getDomain() {
        return 4;
    }

    @Override
    protected AbstractDevInfoObj getDefaultDevInfoObj() {
        return new OptixDevInfoObj();
    }

    @Override
    public void checkRightForPopupMenu() {
        super.checkRightForPopupMenu();
        if (null != this.m_deleteRowMenuItem && null != this.oBasePanel) {
            this.m_deleteRowMenuItem.setEnabled(this.oBasePanel.isDeleteBtnEnable());
        }
    }
}

