/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.view;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.deviceoperation.util.OperationStatus;
import com.huawei.dc.taskmgmt.view.tasktable.TaskTableUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.border.MatteBorder;
import javax.swing.table.TableCellRenderer;

public class OperationStatusRender
implements TableCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component oComponent = null;
        if (value instanceof OperationStatus) {
            oComponent = this.getRendererComponentForProgressInfo((OperationStatus)value, table);
        } else {
            JLabel oLabel = new JLabel();
            oLabel.setOpaque(true);
            String strVal = "";
            if (null != value) {
                strVal = value.toString();
            }
            oLabel.setText(strVal);
            oLabel.setBorder(DCConstants.DEFAULT_TABLE_CELL_BORDER);
            oLabel.setToolTipText(strVal);
            oComponent = oLabel;
        }
        if (oComponent instanceof JProgressBar) {
            return oComponent;
        }
        if (isSelected) {
            oComponent.setBackground(table.getSelectionBackground());
        } else {
            oComponent.setBackground(table.getBackground());
        }
        return oComponent;
    }

    private Component generateProgressBar(OperationStatus oOperationStatus, JTable oTable) {
        JProgressBar progressBar = new JProgressBar(0, 0, 100);
        progressBar.setOpaque(true);
        progressBar.setBackground(oTable.getBackground());
        progressBar.setForeground(new Color(0, 0, 115));
        progressBar.setStringPainted(true);
        if (-1 != oOperationStatus.getProgress()) {
            progressBar.setValue(oOperationStatus.getProgress());
        }
        progressBar.setString(oOperationStatus.toString());
        progressBar.setToolTipText(oOperationStatus.toString());
        return progressBar;
    }

    private Component generateLinkRenderer(OperationStatus oOperationStatus, JTable oTable) {
        JButton oButton = new JButton();
        oButton.setBackground(oTable.getBackground());
        oButton.setText(oOperationStatus.toString());
        oButton.setToolTipText(oOperationStatus.getToolTipText());
        oButton.setHorizontalAlignment(2);
        MatteBorder oMatteBorder = BorderFactory.createMatteBorder(0, 0, 1, 1, oTable.getGridColor());
        oButton.setBorder(oMatteBorder);
        oButton.setEnabled(true);
        return oButton;
    }

    private Component getRendererComponentForProgressInfo(OperationStatus oOperationStatus, JTable oTable) {
        if (oOperationStatus.getIsProgress()) {
            return this.generateProgressBar(oOperationStatus, oTable);
        }
        if (999293081 == oOperationStatus.getIFailureReason()) {
            return this.generateLinkRenderer(oOperationStatus, oTable);
        }
        JLabel oLabel = new JLabel();
        oLabel.setOpaque(true);
        oLabel.setBorder(DCConstants.DEFAULT_TABLE_CELL_BORDER);
        oLabel.setText(oOperationStatus.toString());
        oLabel.setForeground(oOperationStatus.getOperationStausColor());
        String strToolTip = oOperationStatus.toString();
        int iLength = strToolTip.length();
        int iNumCharInOneRow = 100;
        if (iLength > 100) {
            strToolTip = TaskTableUtil.breakLongToolTipText(strToolTip, 100);
        }
        oLabel.setToolTipText(strToolTip);
        return oLabel;
    }
}

