/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.view;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.standalone.controller.IDCStandAloneSyncCtrller;
import com.huawei.dc.standalone.controller.StandAloneSyncCtrller;
import com.huawei.dc.standalone.snmpparams.model.SnmpParaInfo;
import com.huawei.dc.standalone.snmpparams.view.AddSNMPCommonParameterPanel;
import com.huawei.dc.standalone.snmpparams.view.AddSNMPSecurityParameterPanel;
import com.huawei.dc.standalone.view.DeviceProgressDlg;
import com.huawei.dc.standalone.view.IAddDevicePanel;
import com.huawei.dc.taskmgmt.model.Resource;
import com.swimap.imap12.util.InmLengthLimitTextField;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class ModifyDeviceDialog
extends DCModalDialog
implements IAddDevicePanel {
    private static final long serialVersionUID = 1L;
    private JLabel m_oDevIP;
    private JLabel m_oDevName;
    private Container m_oContainer;
    private ResourceManager m_oResMgr;
    private JTextField m_oDevIPTextField;
    private InmLengthLimitTextField m_oDevNameTextField;
    int m_iSNMPVersion;
    private AddSNMPCommonParameterPanel m_oAddSNMPCommonParameterPanel;
    private AddSNMPSecurityParameterPanel m_oAddSNMPSecurityParameterPanel;
    private static final int DEV_NAME_LENGTH = 20;
    private Resource m_oResource;
    private SnmpParaInfo m_oSnmpParaInfo;
    private IDCStandAloneSyncCtrller m_oSyncController;
    private byte[] m_oSyncObject;

    public ModifyDeviceDialog(Resource oResource) throws DCException {
        this.m_oResource = oResource;
        this.m_oSyncObject = new byte[0];
        this.initDialog();
    }

    private void initDialog() throws DCException {
        this.initMgrs();
        this.getCurrentSnmpPara();
        this.m_oContainer = this.getContentPane();
        this.m_oContainer.setLayout(null);
        this.setTitle(this.m_oResMgr.getResString("MODIFY_DEVICE_DIALOG_TITLE"));
        this.initComponents();
        this.alignComponents();
        this.addComponents();
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), this.getCurrentContext());
    }

    private void getCurrentSnmpPara() throws DCException {
        this.m_oSnmpParaInfo = this.m_oSyncController.getSNMPParaForResource(this.m_oResource);
        this.m_iSNMPVersion = this.m_oSnmpParaInfo.getSnmpEnum();
        this.m_oResource.setSnmpParaInfo(this.m_oSnmpParaInfo);
    }

    private void initMgrs() {
        this.m_oResMgr = ResourceManager.getInstance();
        this.m_oSyncController = StandAloneSyncCtrller.getInstance();
    }

    private void initComponents() {
        this.m_oDevIP = new JLabel(this.m_oResMgr.getResString("MODIFY_DEVICE_IP"));
        this.m_oDevName = new JLabel(this.m_oResMgr.getResString("DEVICE_NAME_LABEL"));
        this.m_oDevIPTextField = new JTextField(this.m_oResource.getDeviceIP());
        this.m_oDevIPTextField.setName("StandAlone_ModifyDeviceDialog_m_oDevIPTextField");
        this.m_oDevIPTextField.addMouseMotionListener(this.generateMouseListenerAdapter(this.m_oDevIPTextField));
        this.m_oDevIPTextField.setEditable(false);
        this.m_oDevNameTextField = new InmLengthLimitTextField(20);
        this.m_oDevNameTextField.setName("StandAlone_ModifyDeviceDialog_m_oDevNameTextField");
        this.m_oDevNameTextField.addMouseMotionListener((MouseMotionListener)this.generateMouseListenerAdapter((JTextField)this.m_oDevNameTextField));
        this.m_oDevNameTextField.setText(this.m_oResource.getDeviceName());
        TitledBorder oTitledBorder = BorderFactory.createTitledBorder(this.m_oResMgr.getResString("SNMP_PARAMETER_DIALOG_TITLE"));
        this.m_oAddSNMPCommonParameterPanel = new AddSNMPCommonParameterPanel(this.m_iSNMPVersion, oTitledBorder);
        this.m_oAddSNMPCommonParameterPanel.setParamValue(this.m_oSnmpParaInfo);
        if (2 == this.m_iSNMPVersion) {
            this.initAddSNMPSecurityParameterPanel();
        }
        this.m_oOKBtn.setName("StandAlone_ModifyDeviceDialog_m_oOKBtn");
        this.m_oOKBtn.setText(this.m_oResMgr.getResString("OK_BTN"));
        this.m_oCancelBtn.setName("StandAlone_ModifyDeviceDialog_m_oCancelBtn");
        this.m_oCancelBtn.setText(this.m_oResMgr.getResString("CANCEL_BTN"));
    }

    private void initAddSNMPSecurityParameterPanel() {
        this.m_oAddSNMPSecurityParameterPanel = new AddSNMPSecurityParameterPanel(this.m_oSnmpParaInfo);
        this.add(this.m_oAddSNMPSecurityParameterPanel);
    }

    private void alignComponents() {
        if (2 == this.m_iSNMPVersion) {
            this.m_oDevIP.setBounds(12, 12, 80, 20);
            this.m_oDevIPTextField.setBounds(90, 12, 170, 20);
            this.m_oDevName.setBounds(300, 12, 80, 20);
            this.m_oDevNameTextField.setBounds(378, 12, 170, 20);
            this.m_oAddSNMPCommonParameterPanel.setBounds(10, 50, 550, 100);
            this.m_oAddSNMPSecurityParameterPanel.setBounds(10, 160, 550, 130);
            this.m_oOKBtn.setBounds(395, 300, 75, 21);
            this.m_oOKBtn.setFocusable(true);
            this.m_oCancelBtn.setBounds(480, 300, 75, 21);
            this.m_oCancelBtn.setFocusable(true);
        } else {
            this.setSize(580, 250);
            this.m_oDevIP.setBounds(12, 12, 80, 20);
            this.m_oDevIPTextField.setBounds(90, 12, 170, 20);
            this.m_oDevName.setBounds(300, 12, 80, 20);
            this.m_oDevNameTextField.setBounds(378, 12, 170, 20);
            this.m_oAddSNMPCommonParameterPanel.setBounds(10, 50, 550, 130);
            this.m_oOKBtn.setBounds(395, 190, 75, 21);
            this.m_oOKBtn.setFocusable(true);
            this.m_oCancelBtn.setBounds(480, 190, 75, 21);
            this.m_oCancelBtn.setFocusable(true);
        }
    }

    private void addComponents() {
        this.m_oContainer.add(this.m_oDevIP);
        this.m_oContainer.add(this.m_oDevName);
        this.m_oContainer.add(this.m_oDevIPTextField);
        this.m_oContainer.add((Component)this.m_oDevNameTextField);
        this.m_oContainer.add(this.m_oAddSNMPCommonParameterPanel);
        if (2 == this.m_iSNMPVersion) {
            this.m_oContainer.add(this.m_oAddSNMPSecurityParameterPanel);
        }
        this.m_oContainer.add(this.m_oOKBtn);
        this.m_oContainer.add(this.m_oCancelBtn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void oKButton_ActionPerformed() {
        boolean bResult = this.validationResult();
        if (!bResult) {
            return;
        }
        SnmpParaInfo m_oSnmpParaInfo = this.m_oAddSNMPCommonParameterPanel.getSnmpParaInfo();
        if (2 == this.m_iSNMPVersion) {
            this.m_oAddSNMPSecurityParameterPanel.updateSnmpParaInfo(m_oSnmpParaInfo);
        }
        this.setSNMPParaInfo(m_oSnmpParaInfo);
        if (2 == this.m_iSNMPVersion) {
            if (m_oSnmpParaInfo.getDataEncryptionType() != 1 && (null == m_oSnmpParaInfo.getEncrypPasswd() || 0 == m_oSnmpParaInfo.getEncrypPasswd().length || String.valueOf(m_oSnmpParaInfo.getEncrypPasswd()).equals(""))) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SNMP_DATA_ENCRYPTION_PASSWOR_IS_NULL"), ResourceManager.getInstance().getResString("SUGGESTION"), 1);
                return;
            }
            if (m_oSnmpParaInfo.getAuthenticationType() != 1 && (null == m_oSnmpParaInfo.getAuthenticationPasswd() || 0 == m_oSnmpParaInfo.getAuthenticationPasswd().length || String.valueOf(m_oSnmpParaInfo.getAuthenticationPasswd()).equals(""))) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SNMP_AUTHENTICATION_PASSWOR_IS_NULL"), ResourceManager.getInstance().getResString("SUGGESTION"), 1);
                return;
            }
        }
        List<Resource> oSelResLst = this.getSelectedResourceList();
        byte[] byArray = this.m_oSyncObject;
        synchronized (this.m_oSyncObject) {
            DeviceProgressDlg oAddDeviceProgressBarDlg = new DeviceProgressDlg(2, this.m_oSyncObject);
            IDCStandAloneSyncCtrller oStandAloneSyncCtrller = StandAloneSyncCtrller.getInstance();
            try {
                oStandAloneSyncCtrller.modifyDevice(oSelResLst, m_oSnmpParaInfo);
            }
            catch (DCException ex) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ex.getErrorCode(), this.m_oResMgr.getResString("ERROR"), 0);
                // ** MonitorExit[var5_4] (shouldn't be in output)
                return;
            }
            oAddDeviceProgressBarDlg.setProgressBarState(true);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            this.closeDialog();
            oAddDeviceProgressBarDlg.setTotalDev(oSelResLst.size());
            oAddDeviceProgressBarDlg.setVisible(true);
            oSelResLst = null;
            return;
        }
    }

    private boolean validationResult() {
        boolean bResult = this.validateDeviceName();
        if (!bResult) {
            return bResult;
        }
        bResult = this.validateSNMPPara();
        return bResult;
    }

    private boolean validateDeviceName() {
        String strName = this.m_oDevNameTextField.getText();
        if (null == strName || 0 == strName.trim().length()) {
            String strErrorMsg = this.m_oResMgr.getResString("DEVICE_NAME_EMPTY");
            this.showErrorMsg(strErrorMsg);
            return false;
        }
        return true;
    }

    private boolean validateSNMPPara() {
        boolean result = this.m_oAddSNMPCommonParameterPanel.validateFields();
        return result;
    }

    protected void showErrorMsg(String strErrorMsg) {
        DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), strErrorMsg);
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_TOPIC_NE_MODIFY";
    }

    @Override
    public SnmpParaInfo getSNMPParaInfo() {
        return this.m_oSnmpParaInfo;
    }

    @Override
    public List<Resource> getSelectedResourceList() {
        ArrayList<Resource> oResourceList = new ArrayList<Resource>(1);
        Resource oResource = new Resource();
        oResource.setDeviceName(this.m_oDevNameTextField.getText());
        oResource.setDeviceIP(this.m_oDevIPTextField.getText());
        oResource.setDeviceID(this.m_oResource.getDeviceID());
        oResource.setSnmpParaInfo(this.m_oSnmpParaInfo);
        oResourceList.add(oResource);
        return oResourceList;
    }

    @Override
    public void refreshPanels() {
    }

    @Override
    public void setSNMPParaInfo(SnmpParaInfo oParaInfo) {
        this.m_oSnmpParaInfo = oParaInfo;
    }

    @Override
    public boolean validateFields() {
        return true;
    }

    @Override
    public void setAllFieldsBlank() {
    }

    private MouseMotionAdapter generateMouseListenerAdapter(final JTextField oTextField) {
        return new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent oEvent) {
                ModifyDeviceDialog.this.setToolTip(oEvent, oTextField);
            }
        };
    }

    private void setToolTip(MouseEvent oEvent, JTextField oTextField) {
        oTextField.setToolTipText(oTextField.getText().trim());
    }

    @Override
    public List<Resource> getT2000Resource() {
        return null;
    }

    public int getSNMPVersion() {
        return this.m_iSNMPVersion;
    }
}

