/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.view;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.standalone.controller.StandAloneSyncCtrller;
import com.huawei.dc.standalone.event.IStandAloneNotificationListener;
import com.huawei.dc.standalone.event.StandAloneEvent;
import com.huawei.dc.standalone.event.StandAloneNotifier;
import com.huawei.dc.standalone.model.AbstractDevInfoObj;
import com.huawei.dc.standalone.view.ImportDeviceDialog;
import com.huawei.dc.standalone.view.ImportDeviceFileProgressDlg;
import com.huawei.dc.standalone.view.RouterDevInfoPanel;
import com.huawei.dc.taskmgmt.controller.TaskAsynCommController;
import com.huawei.dc.taskmgmt.model.Resource;
import com.swimap.iview.communicate.MSGListener;
import java.awt.Component;
import java.math.BigInteger;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class ImportRouterDeviceFileProgressDlg
extends ImportDeviceFileProgressDlg
implements IStandAloneNotificationListener {
    private static final long serialVersionUID = 1337608442632731555L;
    private Object m_oSyncObj = new Object();
    private List<AbstractDevInfoObj> addDeviceList;
    private RouterDevInfoPanel routerDevInfoPanel;

    public ImportRouterDeviceFileProgressDlg(RouterDevInfoPanel routerDevInfoPanel, int iCommandCode, ImportDeviceDialog m_oImportDeviceFileDialog, boolean needOtherInfo) {
        super(iCommandCode);
        this.routerDevInfoPanel = routerDevInfoPanel;
        this.m_oImportDeviceFileDialog = m_oImportDeviceFileDialog;
        this.m_iCommandCode = iCommandCode;
        this.needOtherInfo = needOtherInfo;
        StandAloneNotifier.getInstance().addStandAloneNotificationListener(this);
        this.customizeTableForTelnetError();
    }

    public AbstractDevInfoObj getAddDeviceList(int devID) {
        if (null == this.addDeviceList) {
            return null;
        }
        for (AbstractDevInfoObj devInfoObj : this.addDeviceList) {
            if (devInfoObj.getDevID() != devID) continue;
            return devInfoObj;
        }
        return null;
    }

    public void setAddDeviceList(List<AbstractDevInfoObj> addDeviceList) {
        this.addDeviceList = addDeviceList;
    }

    public void setCounter(int counter) {
        this.counter = counter;
    }

    @Override
    public void onStandAloneNotification(StandAloneEvent oEvent) {
        ++this.counter;
        DCDebugTracer.trace("ImportRouterDeviceFileProgressDlg.onTaskNotification " + this.counter + "/" + this.countSize);
        if (oEvent == null || !(oEvent.getResource() instanceof Resource)) {
            DCDebugTracer.trace("oEvent is null");
            return;
        }
        if (oEvent.getEventType() != 0) {
            DCDebugTracer.trace("oEvent not add device");
            return;
        }
        Resource oAsnDevInfoRsp = oEvent.getResource();
        if (null == oAsnDevInfoRsp) {
            DCDebugTracer.trace("ImportRouterDeviceFileProgressDlg - ASN Response is null");
            StandAloneNotifier.getInstance().removeStandAloneNotificationListener(this);
            this.m_progressBar.setValue(100);
            this.m_progressBar.setIndeterminate(false);
            this.m_cancelBtn.setEnabled(false);
            this.m_closeBtn.setEnabled(true);
            return;
        }
        String strResult = "";
        Vector<Object> oRowVector = new Vector<Object>(2);
        strResult = 0 == oEvent.getErrorCode() ? DCFrameWorkUtil.getLocalizedString("OPERTION_SUCCESS") : ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(oEvent.getErrorCode()));
        oRowVector.addElement(oAsnDevInfoRsp.getDeviceName());
        oRowVector.addElement(strResult);
        this.updateProgress(oEvent, this.counter, oRowVector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateProgress(final StandAloneEvent oEvent, final int iCounter, final Vector<Object> oRowVector) {
        Object object = this.m_oSyncObj;
        synchronized (object) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ImportRouterDeviceFileProgressDlg.this.m_oDetailsTableModel.addRow(oRowVector);
                    ImportRouterDeviceFileProgressDlg.this.m_oImportDeviceFileDialog.addoRowVector(oRowVector);
                    String ip = oEvent.getResource().getDeviceIP();
                    DCDebugTracer.trace("DC::add device " + ip + " " + iCounter + "/" + ImportRouterDeviceFileProgressDlg.this.countSize);
                    ImportRouterDeviceFileProgressDlg.this.m_progressBar.setValue(iCounter * 100 / ImportRouterDeviceFileProgressDlg.this.countSize);
                    if (oEvent.isFinal() || iCounter >= ImportRouterDeviceFileProgressDlg.this.countSize) {
                        DCDebugTracer.trace("Add device - bIsFinal is true");
                        ImportRouterDeviceFileProgressDlg.this.removeMsgListener();
                        ImportRouterDeviceFileProgressDlg.this.m_progressBar.setValue(100);
                        ImportRouterDeviceFileProgressDlg.this.m_progressBar.setIndeterminate(false);
                        ImportRouterDeviceFileProgressDlg.this.m_cancelBtn.setEnabled(false);
                        ImportRouterDeviceFileProgressDlg.this.m_closeBtn.setEnabled(true);
                        DCFrameWorkUtil.getCommManager().removeMessageListener(43933, (MSGListener)((TaskAsynCommController)TaskAsynCommController.getInstance()));
                    }
                }
            });
        }
    }

    @Override
    public void doCleanUp() {
        StandAloneSyncCtrller.getInstance().cleanAsnCancelOpReq();
        this.routerDevInfoPanel.setImportDevices(false);
        this.m_oDetailsTableModel.getDataVector().removeAllElements();
        this.dispose();
        this.removeMsgListener();
        if (this.needOtherInfo) {
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString(ResourceManager.getInstance().getResString("IMPORT_DEVICE_SUCCESS")));
        }
    }

    @Override
    protected void cancelButtonActionPerformed() {
        int iErrCode = 0;
        try {
            iErrCode = StandAloneSyncCtrller.getInstance().stopImportDevices();
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
        }
        if (0 != iErrCode) {
            DCOptionPane.showMessageDialog((Component)((Object)this), iErrCode, ResourceManager.getInstance().getResString("SUGGESTION"), 1);
        } else {
            this.enableDisableButtons();
            this.doCleanUp();
            if (this.needOtherInfo) {
                DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString(ResourceManager.getInstance().getResString("IMPORT_DEVICE_SUCCESS")));
            }
        }
    }

    private void removeMsgListener() {
        StandAloneNotifier.getInstance().removeStandAloneNotificationListener(this);
    }
}

