/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.standalone.view;

import com.huawei.dc.common.DCErrorCode;
import com.huawei.dc.common.GatewayConstants;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.security.DCEncryptServiceUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.common.util.IOStreamClose;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.standalone.model.OptixDevInfoObj;
import com.huawei.dc.standalone.model.T2000DevInfo;
import com.huawei.dc.standalone.startup.DCStandaloneDebugTracer;
import com.huawei.dc.standalone.view.ImportDeviceDialog;
import com.huawei.dc.standalone.view.ImportDeviceFileProgressDlg;
import com.huawei.dc.standalone.view.OptixDevInfoPanel;
import com.huawei.dc.standalone.view.RouterDevInfoPanel;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class ImportOptixDeviceParentDialog
extends ImportDeviceDialog {
    private static final long serialVersionUID = -8039871780862021741L;
    protected OptixDevInfoPanel optixDevInfoPanel;
    protected ImportDeviceFileProgressDlg oProgressDlg;
    protected static final int optixColumn = 9;
    private boolean isAddDevice = false;
    private static final int DEVICE_TYPE_ID = 0;
    private static final int VERSION_ID = 1;
    private static final int NE_ID = 2;
    private static final int DEVICE_NAME = 3;
    private static final int PROTOCOL_TYPE = 4;
    private static final int GATEWAY_TYPE = 5;
    private static final int GATEWAY_ADDRESS = 6;
    private static final int PORT = 7;
    private static final int USER_NAME = 8;
    private static final int USER_PASSWORD = 9;
    private static final int VERSION = 10;
    private static final int IS_GATE_WAY = 11;
    private static final int IS_STELNET = 12;
    private static final int STELNET_LOGIN_MODE = 13;
    private static final int STELNET_KEY = 14;
    private static final int STELNET_PASSWORD = 15;
    private static final int SFTP_PASSWORD = 16;
    private static final int NEW_COL_PROTOCOL_TYPE = 0;
    private static final int NEW_COL_EXTEND_ID = 1;
    private static final int NEW_COL_NE_ID = 2;
    private static final int NEW_COL_NE_NAME = 3;
    private static final int NEW_COL_GATEWAY_TYPE = 4;
    private static final int NEW_COL_GATEWWAY_ADDRESS = 5;
    private static final int NEW_COL_PORT = 6;
    private static final int NEW_COL_USER_NAME = 7;
    private static final int NEW_COL_USER_PASSWORD = 8;
    private boolean mbIsMMLProtocol = true;
    private boolean mbIsIPGateway = true;
    protected List<OptixDevInfoObj> moListDevInfo;
    private static final String USE_STELNET_VALUE = "1";
    private static final String NOT_USE_STELNET_VALUE = "0";
    private HashMap moT2000FileHeaderMap = new HashMap(0);
    private static final String MML_PROTOCOL = DCFrameWorkUtil.getLocalizedString("MML_PROTOCOL");
    private static final String IP_GATEWAY_TYPE = DCFrameWorkUtil.getLocalizedString("IP_GATEWAY_TYPE");
    private static final String ROW = DCFrameWorkUtil.getLocalizedString("ROW");
    private static final String COL = DCFrameWorkUtil.getLocalizedString("COL");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void setCSVCountSize(String strFilePath) {
        Vector<String> lineContentVec = new Vector<String>();
        InputStreamReader oFileReader = null;
        BufferedReader oBufferedReader = null;
        try {
            oFileReader = new InputStreamReader((InputStream)new FileInputStream(strFilePath), this.getFileEncoding(strFilePath));
            oBufferedReader = new BufferedReader(oFileReader);
            String strLine = oBufferedReader.readLine();
            strLine = oBufferedReader.readLine();
            while (null != strLine) {
                lineContentVec.add(strLine);
                strLine = oBufferedReader.readLine();
            }
            IOStreamClose.closeReader(oFileReader);
        }
        catch (FileNotFoundException e) {
            this.handError(ResourceManager.getInstance().getResString("NOT_EXIST_FILE"));
            return;
        }
        catch (IOException e2) {
            this.handError(e2.getMessage());
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            IOStreamClose.closeReader(oFileReader);
            IOStreamClose.closeReader(oBufferedReader);
        }
        IOStreamClose.closeReader(oBufferedReader);
        this.oProgressDlg.setCountSize(lineContentVec.size());
    }

    protected DCErrorCode checkDevInfo(List<OptixDevInfoObj> m_oListDevInfo, OptixDevInfoObj optixDevInfoObj) {
        DCDebugTracer.trace("[ImportOptixDeviceDialog] checkDevInfo start");
        if (this.isNull(optixDevInfoObj.getProtocolType())) {
            return new DCErrorCode(DCFrameWorkUtil.getLocalizedString("PROTOCOL_TYPE"));
        }
        if (optixDevInfoObj.getDevExtID() != null && optixDevInfoObj.getDevExtID().length() > 65) {
            return new DCErrorCode(DCFrameWorkUtil.getLocalizedString("DEVICE_EXTEND_ID_HEADER"));
        }
        if (optixDevInfoObj.getNEID() != null && optixDevInfoObj.getNEID().length() > 65) {
            return new DCErrorCode(DCFrameWorkUtil.getLocalizedString("NE_ID"));
        }
        if (optixDevInfoObj.getDevName() != null && optixDevInfoObj.getDevName().length() > 65) {
            return new DCErrorCode(DCFrameWorkUtil.getLocalizedString("DEVICE_NAME_HEADER"));
        }
        if (this.isNull(optixDevInfoObj.getGatewayType())) {
            return new DCErrorCode(DCFrameWorkUtil.getLocalizedString("GATEWAY_TYPE_HEADER"));
        }
        if (optixDevInfoObj.getIGatewayType() == 1 ? !this.validateAddress(optixDevInfoObj.getDevAddress(), false) : this.isNull(optixDevInfoObj.getDevAddress())) {
            return new DCErrorCode(DCFrameWorkUtil.getLocalizedString("GATEWAY_ADDRESS_HEADER"));
        }
        if (this.isNull(optixDevInfoObj.getUserName())) {
            return new DCErrorCode(DCFrameWorkUtil.getLocalizedString("USER_NAME_HEADER"));
        }
        if (optixDevInfoObj.getUserName().length() > 50) {
            return new DCErrorCode(DCFrameWorkUtil.getLocalizedString("USER_NAME_HEADER"));
        }
        if (this.isNull(optixDevInfoObj.getPassword())) {
            return new DCErrorCode(DCFrameWorkUtil.getLocalizedString("PASSWORD_HEADER"));
        }
        if (optixDevInfoObj.getPassword().length > 128) {
            return new DCErrorCode(DCFrameWorkUtil.getLocalizedString("PASSWORD_HEADER"));
        }
        DCDebugTracer.trace("[ImportOptixDeviceDialog] checkDevInfo end..");
        return new DCErrorCode(0);
    }

    public void setAddDevice(boolean isAddDevice) {
        this.isAddDevice = isAddDevice;
    }

    public boolean isAddDevice() {
        return this.isAddDevice;
    }

    public List<OptixDevInfoObj> getImprotSuccDevLst() {
        return this.moListDevInfo;
    }

    protected boolean checkDevRepeatByTL1Type(List<OptixDevInfoObj> m_oListDevInfo, OptixDevInfoObj optixDevInfoObj) {
        if (this.isNull(optixDevInfoObj.getDevName())) {
            for (OptixDevInfoObj devInfo : m_oListDevInfo) {
                if (!this.comareString(devInfo.getDevAddress(), optixDevInfoObj.getDevAddress())) continue;
                return true;
            }
        } else {
            for (OptixDevInfoObj devInfo : m_oListDevInfo) {
                if (devInfo.getIProtocolType() != optixDevInfoObj.getIProtocolType() || !this.comareString(devInfo.getDevName(), optixDevInfoObj.getDevName())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean checkDevRepeatByMMLType(List<OptixDevInfoObj> m_oListDevInfo, OptixDevInfoObj optixDevInfoObj) {
        if (this.isNull(optixDevInfoObj.getDevExtID()) && this.isNull(optixDevInfoObj.getNEID())) {
            for (OptixDevInfoObj devInfo : m_oListDevInfo) {
                if (!devInfo.getDevAddress().trim().equals(optixDevInfoObj.getDevAddress().trim()) || !this.isNull(devInfo.getDevExtID()) || !this.isNull(devInfo.getNEID())) continue;
                return true;
            }
        } else {
            for (OptixDevInfoObj devInfo : m_oListDevInfo) {
                if (devInfo.getIProtocolType() != optixDevInfoObj.getIProtocolType() || !this.comareString(devInfo.getDevExtID(), optixDevInfoObj.getDevExtID()) || !this.comareString(devInfo.getNEID(), optixDevInfoObj.getNEID())) continue;
                return true;
            }
        }
        return false;
    }

    public ImportOptixDeviceParentDialog() {
    }

    public ImportOptixDeviceParentDialog(RouterDevInfoPanel routerDevInfoPanel) {
        super(routerDevInfoPanel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<T2000DevInfo> getT2000ResourceList(String strFileName) throws IOException {
        ArrayList<T2000DevInfo> oResList = new ArrayList<T2000DevInfo>(0);
        FileInputStream oFileStream = null;
        InputStreamReader oFileReader = null;
        BufferedReader oBufferedReader = null;
        String encoding = "";
        encoding = FileUtil.isUTF8File(strFileName) ? FileUtil.getUTF8Encoding() : FileUtil.getSystemEncoding();
        int ivalidateResult = -1;
        List<String> oColumnList = null;
        try {
            oFileStream = new FileInputStream(strFileName);
            oFileReader = new InputStreamReader((InputStream)oFileStream, encoding);
            oBufferedReader = new BufferedReader(oFileReader);
            String lines = oBufferedReader.readLine();
            if (!StringUtils.isNullOrEmptyStr(lines) && FileUtil.isUTF8File(strFileName)) {
                lines = lines.substring(1);
            }
            if (-1 == (ivalidateResult = this.validateHeaderList(oColumnList = this.getHeaderList(lines)))) {
                this.showInvalidFileContentMsg(DCFrameWorkUtil.getLocalizedString("INVALID_FILE_MSG"));
                List<T2000DevInfo> list = null;
                return list;
            }
            List<String> standHeadLst = null;
            int iProtocolTypeColPosition = -1;
            int iGatewayTypeColPosition = -1;
            int headType = -1;
            if (0 == ivalidateResult) {
                headType = 1;
                standHeadLst = GatewayConstants.ARR_T2000_FILE_HEADER_LIST;
                iProtocolTypeColPosition = 4;
                iGatewayTypeColPosition = 5;
            } else if (1 == ivalidateResult) {
                headType = 2;
                standHeadLst = GatewayConstants.ARR_T2000_FILE_HEADER_LIST_NEW;
                iProtocolTypeColPosition = 0;
                iGatewayTypeColPosition = 4;
            } else if (2 == ivalidateResult) {
                headType = 3;
                standHeadLst = GatewayConstants.ARR_T2000_FILE_HEADER_LIST_OFFLINE;
                iProtocolTypeColPosition = 4;
                iGatewayTypeColPosition = 5;
            } else if (3 == ivalidateResult) {
                headType = 4;
                standHeadLst = GatewayConstants.ARR_T2000_FILE_HEADER_LIST_OFFLINE_OLD;
                iProtocolTypeColPosition = 4;
                iGatewayTypeColPosition = 5;
            } else {
                headType = 2;
                standHeadLst = GatewayConstants.ARR_T2000_FILE_HEADER_LIST_NEW;
                iProtocolTypeColPosition = 0;
                iGatewayTypeColPosition = 4;
            }
            this.mapColumnsWithStandardFormat(oColumnList, standHeadLst);
            int iRecCount = 0;
            T2000DevInfo oT2000DevInfo = null;
            String[] strInfo = null;
            ArrayList<String> oResTokenList = null;
            boolean bValidationResult = false;
            String strLineContent = oBufferedReader.readLine();
            File file = new File(strFileName);
            int rowNum = (int)(file.length() / 100L);
            this.oProgressDlg.setCountSize(rowNum);
            int counter = 0;
            int temp = 0;
            while (null != strLineContent) {
                if ((counter = ++temp * 100 / rowNum) < 100) {
                    this.oProgressDlg.updateProgress(counter);
                }
                if ((strInfo = strLineContent.split(",", standHeadLst.size())) == null) continue;
                oT2000DevInfo = new T2000DevInfo();
                oT2000DevInfo.setKeyMode(1);
                oResTokenList = new ArrayList<String>(0);
                for (int i = 0; i < strInfo.length; ++i) {
                    oResTokenList.add(strInfo[i]);
                }
                if (standHeadLst.size() != oResTokenList.size()) {
                    this.showInvalidFileContentMsg(iRecCount + 1, standHeadLst.size(), DCFrameWorkUtil.getLocalizedString("INVALID_FILE_MSG_OFFLINE"));
                    List<T2000DevInfo> i = null;
                    return i;
                }
                bValidationResult = this.validateAndSetProtocolType(oResTokenList, iProtocolTypeColPosition, oT2000DevInfo, headType);
                if (!bValidationResult) {
                    this.showInvalidFileContentMsg(iRecCount + 1, iProtocolTypeColPosition + 1, DCFrameWorkUtil.getLocalizedString("INVALID_FILE_MSG_OFFLINE"));
                    List<T2000DevInfo> i = null;
                    return i;
                }
                bValidationResult = this.validateGatewayType(oResTokenList, iGatewayTypeColPosition, oT2000DevInfo, headType);
                if (!bValidationResult) {
                    this.showInvalidFileContentMsg(iRecCount + 1, iGatewayTypeColPosition + 1, DCFrameWorkUtil.getLocalizedString("INVALID_FILE_MSG_OFFLINE"));
                    List<T2000DevInfo> i = null;
                    return i;
                }
                String strProtocoType = (String)oResTokenList.get(iProtocolTypeColPosition);
                String strGatewayType = (String)oResTokenList.get(iGatewayTypeColPosition);
                this.setProtocolAndGateWay(headType, strProtocoType, strGatewayType);
                int iSize = oResTokenList.size();
                for (int index = 0; index < iSize; ++index) {
                    bValidationResult = this.validation(headType, oT2000DevInfo, oResTokenList, index);
                    if (bValidationResult) continue;
                    this.showInvalidFileContentMsg(iRecCount + 1, index + 1, DCFrameWorkUtil.getLocalizedString("INVALID_FILE_MSG_OFFLINE"));
                    List<T2000DevInfo> list = null;
                    return list;
                }
                oResList.add(oT2000DevInfo);
                ++iRecCount;
                strLineContent = oBufferedReader.readLine();
            }
            this.oProgressDlg.updateProgress(100);
            if (0 == iRecCount) {
                this.showInvalidFileContentMsg(DCFrameWorkUtil.getLocalizedString("NO_DEVICE_INFO_FOUND"));
                throw new IOException();
            }
        }
        catch (FileNotFoundException ex) {
            this.showErrorMessage(DCFrameWorkUtil.getLocalizedString("NOT_EXIST_FILE"));
            List<T2000DevInfo> list = null;
            return list;
        }
        finally {
            if (null != oBufferedReader) {
                try {
                    oBufferedReader.close();
                }
                catch (IOException e) {
                    DCStandaloneDebugTracer.trace(e);
                }
            }
            if (null != oFileReader) {
                try {
                    oFileReader.close();
                }
                catch (IOException e) {
                    DCStandaloneDebugTracer.trace(e);
                }
            }
            if (null != oFileStream) {
                try {
                    oFileStream.close();
                }
                catch (IOException e) {
                    DCStandaloneDebugTracer.trace(e);
                }
            }
        }
        return oResList;
    }

    private void setProtocolAndGateWay(int headType, String strProtocoType, String strGatewayType) {
        if (1 == headType || 3 == headType) {
            int iProtocolType = Integer.parseInt(strProtocoType.trim());
            this.mbIsMMLProtocol = 2 == iProtocolType;
            int iGatewayType = Integer.parseInt(strGatewayType.trim());
            this.mbIsIPGateway = 1 == iGatewayType;
        } else {
            this.mbIsMMLProtocol = MML_PROTOCOL.equals(strProtocoType);
            this.mbIsIPGateway = IP_GATEWAY_TYPE.equals(strGatewayType);
        }
    }

    private boolean validation(int headType, T2000DevInfo oT2000DevInfo, List<String> oResTokenList, int index) {
        boolean bValidationResult = 1 == headType ? this.validateAndSetT2000DeviceValue(oResTokenList.get(index).trim(), index, oT2000DevInfo) : (3 == headType ? this.validateAndSetT2000DeviceValueOffLine(oResTokenList.get(index).trim(), index, oT2000DevInfo) : (4 == headType ? this.validateAndSetT2000DeviceValueOffLine(oResTokenList.get(index).trim(), index, oT2000DevInfo) : this.validateAndSetT2000DeviceValueNew(oResTokenList.get(index).trim(), index, oT2000DevInfo)));
        return bValidationResult;
    }

    private boolean validateGatewayType(List<String> oResTokenList, int iGatewayTypeColPosition, T2000DevInfo oDevInfo, int headType) {
        String strProtocoType = oResTokenList.get(iGatewayTypeColPosition);
        boolean bResult = false;
        bResult = 1 == headType ? this.validateAndSetT2000DeviceValue(strProtocoType.trim(), iGatewayTypeColPosition, oDevInfo) : (3 == headType ? this.validateAndSetT2000DeviceValueOffLine(strProtocoType.trim(), iGatewayTypeColPosition, oDevInfo) : this.validateAndSetT2000DeviceValueNew(strProtocoType.trim(), iGatewayTypeColPosition, oDevInfo));
        return bResult;
    }

    private boolean validateAndSetProtocolType(List<String> oResTokenList, int iProtocolTypeColPosition, T2000DevInfo oDevInfo, int headType) {
        String strProtocoType = oResTokenList.get(iProtocolTypeColPosition);
        boolean bResult = false;
        bResult = 1 == headType ? this.validateAndSetT2000DeviceValue(strProtocoType.trim(), iProtocolTypeColPosition, oDevInfo) : (3 == headType ? this.validateAndSetT2000DeviceValueOffLineForSecurity(strProtocoType.trim(), iProtocolTypeColPosition, oDevInfo) : (4 == headType ? this.validateAndSetT2000DeviceValueOffLine(strProtocoType.trim(), iProtocolTypeColPosition, oDevInfo) : this.validateAndSetT2000DeviceValueNew(strProtocoType.trim(), iProtocolTypeColPosition, oDevInfo)));
        return bResult;
    }

    private boolean validateAndSetT2000DeviceValue(String strValue, int iCol, T2000DevInfo oDevInfo) {
        Integer oColInFormat = (Integer)this.moT2000FileHeaderMap.get(iCol);
        int iColInFormat = oColInFormat;
        boolean bResult = false;
        switch (iColInFormat) {
            case 0: {
                bResult = this.validateForIntegerValue(strValue);
                this.processDeviceTypeResult(strValue, oDevInfo, bResult);
                return bResult;
            }
            case 1: {
                bResult = this.validateForIntegerValue(strValue);
                this.processVersionResult(strValue, oDevInfo, bResult);
                return bResult;
            }
            case 2: {
                bResult = this.processNEResult(strValue, oDevInfo);
                return bResult;
            }
            case 3: {
                bResult = this.processDeviceNameResult(strValue, oDevInfo);
                return bResult;
            }
            case 4: {
                bResult = this.validateForIntegerValue(strValue);
                this.processProtocoTypeResult(strValue, oDevInfo, bResult);
                return bResult;
            }
            case 5: {
                bResult = this.validateForIntegerValue(strValue);
                if (bResult) {
                    oDevInfo.setGateWayType(Integer.parseInt(strValue));
                }
                return bResult;
            }
            case 6: {
                if (this.mbIsIPGateway) {
                    String strVal = this.checkAndFormatFileContent(strValue);
                    if (null == strValue) {
                        return false;
                    }
                    oDevInfo.setGatewayAddress(strVal);
                    return true;
                }
                bResult = this.validateForString(strValue);
                if (bResult) {
                    oDevInfo.setGatewayAddress(strValue);
                }
                return bResult;
            }
            case 7: {
                bResult = this.validateForIntegerValue(strValue);
                if (bResult) {
                    oDevInfo.setPort(Integer.parseInt(strValue));
                }
                return bResult;
            }
            case 8: {
                bResult = this.validateForString(strValue);
                if (bResult) {
                    oDevInfo.setUserName(strValue);
                }
                return bResult;
            }
            case 9: {
                String strPassword = strValue;
                if (null == strPassword) {
                    return false;
                }
                bResult = this.validateForString(strPassword);
                if (bResult) {
                    oDevInfo.setPass(DCEncryptServiceUtil.decrypt(strPassword.toCharArray()));
                }
                return bResult;
            }
        }
        return false;
    }

    private boolean validateAndSetT2000DeviceValueOffLine(String strValue, int iCol, T2000DevInfo oDevInfo) {
        Integer oColInFormat = (Integer)this.moT2000FileHeaderMap.get(iCol);
        int iColInFormat = oColInFormat;
        boolean bResult = false;
        switch (iColInFormat) {
            case 0: {
                bResult = this.validateForIntegerValue(strValue);
                this.processDeviceTypeResult(strValue, oDevInfo, bResult);
                return bResult;
            }
            case 1: {
                bResult = this.validateForIntegerValue(strValue);
                this.processVersionResult(strValue, oDevInfo, bResult);
                return bResult;
            }
            case 2: {
                bResult = this.processNEResult(strValue, oDevInfo);
                return bResult;
            }
            case 3: {
                bResult = this.processDeviceNameResult(strValue, oDevInfo);
                return bResult;
            }
            case 4: {
                bResult = this.validateForIntegerValue(strValue);
                this.processProtocoTypeResult(strValue, oDevInfo, bResult);
                return bResult;
            }
            case 5: {
                bResult = this.validateForIntegerValue(strValue);
                if (bResult) {
                    oDevInfo.setGateWayType(Integer.parseInt(strValue));
                }
                return bResult;
            }
            case 6: {
                if (this.mbIsIPGateway) {
                    String strVal = this.checkAndFormatFileContent(strValue);
                    if (null == strValue) {
                        return false;
                    }
                    oDevInfo.setGatewayAddress(strVal);
                    return true;
                }
                bResult = this.validateForString(strValue);
                if (bResult) {
                    oDevInfo.setGatewayAddress(strValue);
                }
                return bResult;
            }
            case 7: {
                bResult = this.validateForIntegerValue(strValue);
                if (bResult) {
                    oDevInfo.setPort(Integer.parseInt(strValue));
                }
                return bResult;
            }
            case 8: {
                bResult = this.validateForString(strValue);
                if (bResult) {
                    oDevInfo.setUserName(strValue);
                }
                return bResult;
            }
            case 9: {
                String strPassword = strValue;
                if (null == strPassword) {
                    return false;
                }
                bResult = this.validateForString(strPassword);
                if (bResult) {
                    char[] strEncryptPwd = DCEncryptServiceUtil.encrypt(strPassword.toCharArray());
                    oDevInfo.setPass(strEncryptPwd);
                    if (!String.valueOf(strEncryptPwd).equals(strPassword)) {
                        oDevInfo.setKeyMode(0);
                    }
                }
                return bResult;
            }
            case 10: {
                bResult = this.validateForString(strValue + " ");
                if (bResult) {
                    oDevInfo.setDevVersion(strValue);
                }
                return bResult;
            }
            case 11: {
                bResult = this.validateForString(strValue);
                if (bResult) {
                    oDevInfo.setIsGateway(strValue);
                }
                return bResult;
            }
            case 12: {
                bResult = this.validateForIntegerValue(strValue);
                if (bResult) {
                    if (USE_STELNET_VALUE.equals(strValue)) {
                        oDevInfo.setISUseSSH(true);
                    } else if (NOT_USE_STELNET_VALUE.equals(strValue)) {
                        oDevInfo.setISUseSSH(false);
                    } else {
                        return false;
                    }
                }
                return bResult;
            }
            case 13: {
                bResult = this.validateForIntegerValue(strValue);
                if (bResult) {
                    oDevInfo.setSSHLoginMode(Integer.parseInt(strValue));
                }
                return bResult;
            }
            case 14: {
                bResult = this.validateForString(strValue + " ");
                this.processStelnetResult(strValue, oDevInfo, bResult);
                return bResult;
            }
            case 15: {
                bResult = this.validateForString(strValue + " ");
                if (bResult) {
                    if (null == strValue) {
                        oDevInfo.setSSHPassPhrase("".toCharArray());
                    } else {
                        oDevInfo.setSSHPassPhrase(strValue.toCharArray());
                    }
                }
                return bResult;
            }
            case 16: {
                bResult = this.validateForString(strValue + " ");
                this.processSFTPResult(strValue, oDevInfo, bResult);
                return bResult;
            }
        }
        return false;
    }

    private void processSFTPResult(String strValue, T2000DevInfo oDevInfo, boolean bResult) {
        if (bResult) {
            if (null == strValue) {
                oDevInfo.setSFTPPassPhrase("".toCharArray());
            } else {
                oDevInfo.setSFTPPassPhrase(strValue.toCharArray());
            }
        }
    }

    private void processStelnetResult(String strValue, T2000DevInfo oDevInfo, boolean bResult) {
        if (bResult) {
            if (null == strValue) {
                oDevInfo.setSSHLoginKey("".toCharArray());
            } else {
                oDevInfo.setSSHLoginKey(strValue.toCharArray());
            }
        }
    }

    private void processProtocoTypeResult(String strValue, T2000DevInfo oDevInfo, boolean bResult) {
        if (bResult) {
            oDevInfo.setProtocolType(Integer.parseInt(strValue));
        }
    }

    private boolean processDeviceNameResult(String strValue, T2000DevInfo oDevInfo) {
        boolean bResult;
        if (this.mbIsMMLProtocol) {
            bResult = this.validateForString(strValue);
            if (bResult) {
                oDevInfo.setDeviceName(strValue);
            }
        } else {
            bResult = true;
            oDevInfo.setTL1ProtocolDevPhyId(strValue);
            oDevInfo.setDeviceName(strValue);
        }
        return bResult;
    }

    private boolean processNEResult(String strValue, T2000DevInfo oDevInfo) {
        boolean bResult;
        if (strValue.equals("null")) {
            strValue = "";
        }
        if (this.mbIsMMLProtocol) {
            bResult = this.validateForIntegerValue(strValue);
            if (bResult) {
                oDevInfo.setMMLProtocolDevPhyId(Integer.parseInt(strValue));
            }
        } else {
            bResult = true;
        }
        return bResult;
    }

    private void processVersionResult(String strValue, T2000DevInfo oDevInfo, boolean bResult) {
        if (bResult) {
            oDevInfo.setDeviceTypeVersionId(Integer.parseInt(strValue));
        }
    }

    private void processDeviceTypeResult(String strValue, T2000DevInfo oDevInfo, boolean bResult) {
        if (bResult) {
            oDevInfo.setDeviceType(Integer.parseInt(strValue));
        }
    }

    private boolean validateAndSetT2000DeviceValueOffLineForSecurity(String strValue, int iCol, T2000DevInfo oDevInfo) {
        Integer oColInFormat = (Integer)this.moT2000FileHeaderMap.get(iCol);
        int iColInFormat = oColInFormat;
        boolean bResult = false;
        switch (iColInFormat) {
            case 0: {
                bResult = this.validateForIntegerValue(strValue);
                this.processDeviceTypeResult(strValue, oDevInfo, bResult);
                return bResult;
            }
            case 1: {
                bResult = this.validateForIntegerValue(strValue);
                this.processVersionResult(strValue, oDevInfo, bResult);
                return bResult;
            }
            case 2: {
                bResult = this.processNEResult(strValue, oDevInfo);
                return bResult;
            }
            case 3: {
                bResult = this.processDeviceNameResult(strValue, oDevInfo);
                return bResult;
            }
            case 4: {
                bResult = this.validateForIntegerValue(strValue);
                this.processProtocoTypeResult(strValue, oDevInfo, bResult);
                return bResult;
            }
            case 5: {
                bResult = this.validateForIntegerValue(strValue);
                if (bResult) {
                    oDevInfo.setGateWayType(Integer.parseInt(strValue));
                }
                return bResult;
            }
            case 6: {
                if (this.mbIsIPGateway) {
                    String strVal = this.checkAndFormatFileContent(strValue);
                    if (null == strValue) {
                        return false;
                    }
                    oDevInfo.setGatewayAddress(strVal);
                    return true;
                }
                bResult = this.validateForString(strValue);
                if (bResult) {
                    oDevInfo.setGatewayAddress(strValue);
                }
                return bResult;
            }
            case 7: {
                bResult = this.validateForIntegerValue(strValue);
                if (bResult) {
                    oDevInfo.setPort(Integer.parseInt(strValue));
                }
                return bResult;
            }
            case 8: {
                bResult = this.validateForString(strValue);
                if (bResult) {
                    oDevInfo.setUserName(strValue);
                }
                return bResult;
            }
            case 9: {
                String strPassword = strValue;
                if (null == strPassword) {
                    return false;
                }
                bResult = this.validateForString(strPassword);
                if (bResult) {
                    oDevInfo.setPass(DCEncryptServiceUtil.decrypt(strPassword.toCharArray()));
                }
                return bResult;
            }
            case 10: {
                bResult = this.validateForString(strValue + " ");
                if (bResult) {
                    oDevInfo.setDevVersion(strValue);
                }
                return bResult;
            }
            case 11: {
                bResult = this.validateForString(strValue);
                if (bResult) {
                    oDevInfo.setIsGateway(strValue);
                }
                return bResult;
            }
        }
        return false;
    }

    private boolean validateAndSetT2000DeviceValueNew(String strValue, int iCol, T2000DevInfo oDevInfo) {
        Integer oColInFormat = (Integer)this.moT2000FileHeaderMap.get(iCol);
        boolean bResult = false;
        switch (oColInFormat) {
            case 0: {
                if (Collator.getInstance().equals(strValue, DCFrameWorkUtil.getLocalizedString("MML_PROTOCOL"))) {
                    bResult = true;
                    oDevInfo.setProtocolType(2);
                    break;
                }
                if (!Collator.getInstance().equals(strValue, DCFrameWorkUtil.getLocalizedString("TLL_PROTOCOL"))) break;
                bResult = true;
                oDevInfo.setProtocolType(4);
                break;
            }
            case 1: {
                bResult = 4 == oDevInfo.getProtocolType() ? true : this.checkNumber(strValue, 1, 255);
                if (!bResult) break;
                oDevInfo.setExtendID(Integer.valueOf(strValue));
                break;
            }
            case 2: {
                bResult = 4 == oDevInfo.getProtocolType() ? true : this.checkNumber(strValue, 1, 49151);
                if (!bResult) break;
                oDevInfo.setNEID(Integer.valueOf(strValue));
                break;
            }
            case 3: {
                bResult = true;
                oDevInfo.setDeviceName(strValue);
                break;
            }
            case 4: {
                if (Collator.getInstance().equals(strValue, DCFrameWorkUtil.getLocalizedString("IP_GATEWAY_TYPE"))) {
                    bResult = true;
                    oDevInfo.setGateWayType(1);
                    break;
                }
                if (!Collator.getInstance().equals(strValue, DCFrameWorkUtil.getLocalizedString("OS_GATEWAY_TYPE"))) break;
                bResult = true;
                oDevInfo.setProtocolType(2);
                break;
            }
            case 5: {
                if (oDevInfo.getGateWayType() == 1) {
                    String strVal = this.checkAndFormatFileContent(strValue);
                    if (null == strValue) {
                        bResult = false;
                        break;
                    }
                    bResult = true;
                    oDevInfo.setGatewayAddress(strVal);
                    break;
                }
                bResult = this.validateForString(strValue);
                if (!bResult) break;
                oDevInfo.setGatewayAddress(strValue);
                break;
            }
            case 6: {
                bResult = this.checkNumber(strValue, 1, 65535);
                if (!bResult) break;
                oDevInfo.setPort(Integer.valueOf(strValue));
                break;
            }
            case 7: {
                bResult = true;
                oDevInfo.setUserName(strValue);
                break;
            }
            case 8: {
                bResult = true;
                oDevInfo.setPass(DCEncryptServiceUtil.decrypt(strValue.toCharArray()));
                break;
            }
        }
        return bResult;
    }

    private boolean validateForIntegerValue(String strValue) {
        try {
            Integer.parseInt(strValue);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    private boolean validateForString(String strValue) {
        return 0 != strValue.length();
    }

    private String checkAndFormatFileContent(String strIPAddresses) {
        if (null == strIPAddresses || strIPAddresses.equalsIgnoreCase("")) {
            return null;
        }
        String[] strIPPartsArr = new String[4];
        String strSearchedIPAddresses = strIPAddresses.trim();
        int iCounter = 0;
        while (-1 != strSearchedIPAddresses.indexOf(".")) {
            if (iCounter >= 3) {
                return null;
            }
            int iIndex = strSearchedIPAddresses.indexOf(".");
            strIPPartsArr[iCounter] = strSearchedIPAddresses.substring(0, iIndex).trim();
            ++iCounter;
            strSearchedIPAddresses = strSearchedIPAddresses.substring(iIndex + 1).trim();
        }
        if (3 != iCounter) {
            return null;
        }
        strIPPartsArr[iCounter] = strSearchedIPAddresses;
        try {
            int[] iValue = new int[4];
            for (int i = 0; i < 4; ++i) {
                if (strIPPartsArr[i].equals("*")) continue;
                iValue[i] = Integer.parseInt(strIPPartsArr[i]);
                if (iValue[i] < 0 || iValue[i] > 255 || 0 == i && 0 == iValue[i]) {
                    throw new NumberFormatException();
                }
                strIPPartsArr[i] = String.valueOf(iValue[i]);
            }
            if (0 == iValue[0] || 223 < iValue[0]) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException ex) {
            return null;
        }
        return strIPPartsArr[0] + '.' + strIPPartsArr[1] + '.' + strIPPartsArr[2] + '.' + strIPPartsArr[3];
    }

    private void showInvalidFileContentMsg(int row, int col, String strMsg) {
        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), new StringBuffer().append(col).append(ROW).append(row).append(COL).append(strMsg).toString(), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
    }

    private void showInvalidFileContentMsg(String strMsg) {
        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), strMsg, DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
    }

    private void mapColumnsWithStandardFormat(List<String> oHeaderList, List<String> standHeadLst) {
        int iSize = oHeaderList.size();
        block0: for (int iHeaderIndex = 0; iHeaderIndex < iSize; ++iHeaderIndex) {
            String strHeader = oHeaderList.get(iHeaderIndex);
            for (int index = 0; index < iSize; ++index) {
                if (!strHeader.trim().equals(standHeadLst.get(index).trim())) continue;
                this.moT2000FileHeaderMap.put(iHeaderIndex, index);
                continue block0;
            }
        }
    }

    private List<String> getHeaderList(String strLineContent) {
        if (null == strLineContent || 0 == strLineContent.length()) {
            return null;
        }
        ArrayList<String> oHeaderList = new ArrayList<String>(0);
        StringTokenizer oHeaderTokenizer = new StringTokenizer(strLineContent, ",");
        while (oHeaderTokenizer.hasMoreTokens()) {
            String strToken = oHeaderTokenizer.nextToken();
            oHeaderList.add(strToken);
        }
        return oHeaderList;
    }

    private int validateHeaderList(List<String> oHeaderList) {
        int bRtnValue = -1;
        if (null == oHeaderList) {
            return bRtnValue;
        }
        if (this.validateHeaderTitle(oHeaderList, GatewayConstants.ARR_T2000_FILE_HEADER_LIST)) {
            return 0;
        }
        if (this.validateHeaderTitle(oHeaderList, GatewayConstants.ARR_T2000_FILE_HEADER_LIST_NEW)) {
            return 1;
        }
        if (this.validateHeaderTitle(oHeaderList, GatewayConstants.ARR_T2000_FILE_HEADER_LIST_OFFLINE)) {
            return 2;
        }
        if (this.validateHeaderTitle(oHeaderList, GatewayConstants.ARR_T2000_FILE_HEADER_LIST_OFFLINE_OLD)) {
            return 3;
        }
        return bRtnValue;
    }

    private boolean validateHeaderTitle(List<String> oHeaderList, List<String> oCorrectHeadList) {
        if (oHeaderList.size() != oCorrectHeadList.size()) {
            return false;
        }
        if (!this.bIsSTDSupportImprotFileSize(oHeaderList)) {
            return false;
        }
        int iSize = oCorrectHeadList.size();
        Collator oCol = Collator.getInstance();
        String sSource = "";
        String sDest = "";
        for (int iHeaderIndex = 0; iHeaderIndex < iSize; ++iHeaderIndex) {
            sSource = oHeaderList.get(iHeaderIndex).trim();
            if (oCol.equals(sSource, sDest = oCorrectHeadList.get(iHeaderIndex).trim())) continue;
            return false;
        }
        return true;
    }

    protected void showErrorMessage(String strError) {
        DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString(strError));
    }

    private boolean bIsSTDSupportImprotFileSize(List<String> oHeaderList) {
        if (oHeaderList.size() == GatewayConstants.ARR_T2000_FILE_HEADER_LIST_OFFLINE.size()) {
            return true;
        }
        if (oHeaderList.size() == GatewayConstants.ARR_T2000_FILE_HEADER_LIST_NEW.size()) {
            return true;
        }
        if (oHeaderList.size() == GatewayConstants.ARR_T2000_FILE_HEADER_LIST.size()) {
            return true;
        }
        return oHeaderList.size() == GatewayConstants.ARR_T2000_FILE_HEADER_LIST_OFFLINE_OLD.size();
    }

    private void handError(String message) {
        DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), message);
        this.oProgressDlg.operatorEnd();
        this.oProgressDlg.doCleanUp();
    }
}

